/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.trie;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0015\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\r2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0016JJ\u0010\u0017\u001a\u00020\u0018\"\u0004\b\u0001\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\n\u0010\u0010\u001a\u00060\u001bj\u0002`\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00190 H\u0002J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00190!\"\u0004\b\u0001\u0010\u00192\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00190 R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00028\u00000\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/trie/Trie;", "V", "", "()V", "isEmpty", "", "()Z", "root", "Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$Node;", "isChildless", "(Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$Node;)Z", "contains", "word", "", "empty", "findNode", "prefix", "findValue", "(Ljava/lang/CharSequence;)Ljava/lang/Object;", "insert", "key", "value", "(Ljava/lang/CharSequence;Ljava/lang/Object;)Z", "visit", "", "R", "node", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "result", "", "visitor", "Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$NodeVisitor;", "", "Node", "NodeVisitor", "structure-base"})
@SourceDebugExtension(value={"SMAP\nTrie.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Trie.kt\ncom/jetbrains/plugin/structure/base/utils/trie/Trie\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n372#2,3:74\n375#2,4:78\n1#3:77\n*E\n*S KotlinDebug\n*F\n+ 1 Trie.kt\ncom/jetbrains/plugin/structure/base/utils/trie/Trie\n*L\n34#1,3:74\n34#1,4:78\n*E\n"})
public final class Trie<V> {
    @NotNull
    private final Node<V> root = this.empty();

    private final Node<V> empty() {
        return new Node(new HashMap(), null, false, 4, null);
    }

    public final boolean isEmpty() {
        return this.isChildless(this.root) && this.root.getValue() == null && !this.root.isTerminal();
    }

    private final boolean isChildless(Node<V> $this$isChildless) {
        return $this$isChildless.getChildren().isEmpty();
    }

    public final boolean contains(@NotNull CharSequence word) {
        Intrinsics.checkNotNullParameter(word, "word");
        return this.findNode(word) != null;
    }

    @Nullable
    public final V findValue(@NotNull CharSequence word) {
        Intrinsics.checkNotNullParameter(word, "word");
        Node<V> node = this.findNode(word);
        return (V)(node != null ? node.getValue() : null);
    }

    private final Node<V> findNode(CharSequence prefix) {
        Node<V> n = this.root;
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (n.getChildren().get(Character.valueOf(c)) != null) continue;
            return null;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean insert(@NotNull CharSequence key, @Nullable V value) {
        Intrinsics.checkNotNullParameter(key, "key");
        boolean isInserted = false;
        Node currentNode = this.root;
        for (int i = 0; i < key.length(); ++i) {
            Object object;
            void $this$getOrPut$iv;
            char c = key.charAt(i);
            Map<Character, Node<V>> map = currentNode.getChildren();
            Character key$iv = Character.valueOf(c);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                Node<V> node;
                boolean bl = false;
                Node<V> it = node = this.empty();
                boolean bl2 = false;
                isInserted = true;
                Node<V> answer$iv = node;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            currentNode = (Node)object;
        }
        currentNode.setValue(value);
        currentNode.setTerminal(true);
        return isInserted;
    }

    public static /* synthetic */ boolean insert$default(Trie trie, CharSequence charSequence, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return trie.insert(charSequence, object);
    }

    @NotNull
    public final <R> List<R> visit(@NotNull NodeVisitor<V, R> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        if (this.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        this.visit(this.root, new StringBuilder(), result2, visitor2);
        return result2;
    }

    private final <R> void visit(Node<V> node, StringBuilder prefix, List<R> result2, NodeVisitor<V, R> visitor2) {
        if (this.isChildless(node)) {
            ((Collection)result2).add(visitor2.visit(new NodeVisitor.NodeVisit<V>(prefix, node.getValue(), true, node.isTerminal())));
        } else {
            ((Collection)result2).add(visitor2.visit(new NodeVisitor.NodeVisit<V>(prefix, node.getValue(), false, node.isTerminal())));
            for (Map.Entry<Character, Node<V>> entry : node.getChildren().entrySet()) {
                char c = entry.getKey().charValue();
                Node<V> child = entry.getValue();
                StringBuilder $this$visit_u24lambda_u242 = prefix;
                boolean bl = false;
                $this$visit_u24lambda_u242.append(c);
                this.visit(child, prefix, result2, visitor2);
                $this$visit_u24lambda_u242.deleteCharAt(StringsKt.getLastIndex($this$visit_u24lambda_u242));
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B7\u0012\u001a\b\u0002\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00018\u0001\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u0004H\u00c6\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00018\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003JF\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u001a\b\u0002\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00018\u00012\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0006\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$Node;", "V", "", "children", "", "", "value", "isTerminal", "", "(Ljava/util/Map;Ljava/lang/Object;Z)V", "getChildren", "()Ljava/util/Map;", "()Z", "setTerminal", "(Z)V", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "component1", "component2", "component3", "copy", "(Ljava/util/Map;Ljava/lang/Object;Z)Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$Node;", "equals", "other", "hashCode", "", "toString", "", "structure-base"})
    private static final class Node<V> {
        @NotNull
        private final Map<Character, Node<V>> children;
        @Nullable
        private V value;
        private boolean isTerminal;

        public Node(@NotNull Map<Character, Node<V>> children, @Nullable V value, boolean isTerminal) {
            Intrinsics.checkNotNullParameter(children, "children");
            this.children = children;
            this.value = value;
            this.isTerminal = isTerminal;
        }

        public /* synthetic */ Node(Map map, Object object, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 1) != 0) {
                map = new HashMap();
            }
            if ((n & 2) != 0) {
                object = null;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            this(map, object, bl);
        }

        @NotNull
        public final Map<Character, Node<V>> getChildren() {
            return this.children;
        }

        @Nullable
        public final V getValue() {
            return this.value;
        }

        public final void setValue(@Nullable V v) {
            this.value = v;
        }

        public final boolean isTerminal() {
            return this.isTerminal;
        }

        public final void setTerminal(boolean bl) {
            this.isTerminal = bl;
        }

        @NotNull
        public final Map<Character, Node<V>> component1() {
            return this.children;
        }

        @Nullable
        public final V component2() {
            return this.value;
        }

        public final boolean component3() {
            return this.isTerminal;
        }

        @NotNull
        public final Node<V> copy(@NotNull Map<Character, Node<V>> children, @Nullable V value, boolean isTerminal) {
            Intrinsics.checkNotNullParameter(children, "children");
            return new Node<V>(children, value, isTerminal);
        }

        public static /* synthetic */ Node copy$default(Node node, Map map, Object object, boolean bl, int n, Object object2) {
            if ((n & 1) != 0) {
                map = node.children;
            }
            if ((n & 2) != 0) {
                object = node.value;
            }
            if ((n & 4) != 0) {
                bl = node.isTerminal;
            }
            return node.copy(map, object, bl);
        }

        @NotNull
        public String toString() {
            return "Node(children=" + this.children + ", value=" + this.value + ", isTerminal=" + this.isTerminal + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.children).hashCode();
            result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.isTerminal);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Node)) {
                return false;
            }
            Node node = (Node)other;
            if (!Intrinsics.areEqual(this.children, node.children)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.value, node.value)) {
                return false;
            }
            return this.isTerminal == node.isTerminal;
        }

        public Node() {
            this(null, null, false, 7, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\u00020\u0003:\u0001\u0007J\u001b\u0010\u0004\u001a\u00028\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$NodeVisitor;", "V", "R", "", "visit", "Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$NodeVisitor$NodeVisit;", "(Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$NodeVisitor$NodeVisit;)Ljava/lang/Object;", "NodeVisit", "structure-base"})
    public static interface NodeVisitor<V, R> {
        public R visit(@NotNull NodeVisit<V> var1);

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00018\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J>\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\nR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$NodeVisitor$NodeVisit;", "V", "", "word", "", "value", "isLeaf", "", "isTerminal", "(Ljava/lang/CharSequence;Ljava/lang/Object;ZZ)V", "()Z", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getWord", "()Ljava/lang/CharSequence;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/CharSequence;Ljava/lang/Object;ZZ)Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$NodeVisitor$NodeVisit;", "equals", "other", "hashCode", "", "toString", "", "structure-base"})
        public static final class NodeVisit<V> {
            @NotNull
            private final CharSequence word;
            @Nullable
            private final V value;
            private final boolean isLeaf;
            private final boolean isTerminal;

            public NodeVisit(@NotNull CharSequence word, @Nullable V value, boolean isLeaf, boolean isTerminal) {
                Intrinsics.checkNotNullParameter(word, "word");
                this.word = word;
                this.value = value;
                this.isLeaf = isLeaf;
                this.isTerminal = isTerminal;
            }

            @NotNull
            public final CharSequence getWord() {
                return this.word;
            }

            @Nullable
            public final V getValue() {
                return this.value;
            }

            public final boolean isLeaf() {
                return this.isLeaf;
            }

            public final boolean isTerminal() {
                return this.isTerminal;
            }

            @NotNull
            public final CharSequence component1() {
                return this.word;
            }

            @Nullable
            public final V component2() {
                return this.value;
            }

            public final boolean component3() {
                return this.isLeaf;
            }

            public final boolean component4() {
                return this.isTerminal;
            }

            @NotNull
            public final NodeVisit<V> copy(@NotNull CharSequence word, @Nullable V value, boolean isLeaf, boolean isTerminal) {
                Intrinsics.checkNotNullParameter(word, "word");
                return new NodeVisit<V>(word, value, isLeaf, isTerminal);
            }

            public static /* synthetic */ NodeVisit copy$default(NodeVisit nodeVisit, CharSequence charSequence, Object object, boolean bl, boolean bl2, int n, Object object2) {
                if ((n & 1) != 0) {
                    charSequence = nodeVisit.word;
                }
                if ((n & 2) != 0) {
                    object = nodeVisit.value;
                }
                if ((n & 4) != 0) {
                    bl = nodeVisit.isLeaf;
                }
                if ((n & 8) != 0) {
                    bl2 = nodeVisit.isTerminal;
                }
                return nodeVisit.copy(charSequence, object, bl, bl2);
            }

            @NotNull
            public String toString() {
                return "NodeVisit(word=" + this.word + ", value=" + this.value + ", isLeaf=" + this.isLeaf + ", isTerminal=" + this.isTerminal + ")";
            }

            public int hashCode() {
                int result2 = this.word.hashCode();
                result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
                result2 = result2 * 31 + Boolean.hashCode(this.isLeaf);
                result2 = result2 * 31 + Boolean.hashCode(this.isTerminal);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NodeVisit)) {
                    return false;
                }
                NodeVisit nodeVisit = (NodeVisit)other;
                if (!Intrinsics.areEqual(this.word, nodeVisit.word)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.value, nodeVisit.value)) {
                    return false;
                }
                if (this.isLeaf != nodeVisit.isLeaf) {
                    return false;
                }
                return this.isTerminal == nodeVisit.isTerminal;
            }
        }
    }
}

