/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.extractor;

import com.jetbrains.plugin.structure.base.decompress.DecompressorSizeLimitExceededException;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.problems.PluginFileSizeIsTooLarge;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.ZipUtilKt;
import com.jetbrains.plugin.structure.intellij.extractor.DefaultPluginExtractorKt;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractedPlugin;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractorResult;
import com.jetbrains.plugin.structure.intellij.extractor.PluginExtractor;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipContainsMultipleFiles;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipContainsSingleJarInRoot;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipContainsUnknownFile;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipIsEmpty;
import com.jetbrains.plugin.structure.intellij.problems.UnexpectedPluginZipStructure;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/plugin/structure/intellij/extractor/DefaultPluginExtractor;", "Lcom/jetbrains/plugin/structure/intellij/extractor/PluginExtractor;", "()V", "extractPlugin", "Lcom/jetbrains/plugin/structure/intellij/extractor/ExtractorResult;", "pluginFile", "Ljava/nio/file/Path;", "extractDirectory", "fail", "problem", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "extractedPlugin", "getExtractorResult", "isJarInZip", "", "path", "success", "actualFile", "fileToDelete", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nDefaultPluginExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultPluginExtractor.kt\ncom/jetbrains/plugin/structure/intellij/extractor/DefaultPluginExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1747#2,3:96\n1549#2:99\n1620#2,3:100\n*E\n*S KotlinDebug\n*F\n+ 1 DefaultPluginExtractor.kt\ncom/jetbrains/plugin/structure/intellij/extractor/DefaultPluginExtractor\n*L\n71#1,3:96\n80#1:99\n80#1,3:100\n*E\n"})
public final class DefaultPluginExtractor
implements PluginExtractor {
    @Override
    @NotNull
    public ExtractorResult extractPlugin(@NotNull Path pluginFile, @NotNull Path extractDirectory) {
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
        Files.createDirectories(extractDirectory, new FileAttribute[0]);
        Path extractedPlugin = Files.createTempDirectory(extractDirectory, "plugin_", new FileAttribute[0]);
        try {
            Intrinsics.checkNotNullExpressionValue(extractedPlugin, "extractedPlugin");
            ZipUtilKt.extractZip(pluginFile, extractedPlugin, Settings.INTELLIJ_PLUGIN_SIZE_LIMIT.getAsLong());
        }
        catch (DecompressorSizeLimitExceededException e) {
            PluginProblem pluginProblem = new PluginFileSizeIsTooLarge(e.getSizeLimit());
            Intrinsics.checkNotNullExpressionValue(extractedPlugin, "extractedPlugin");
            return this.fail(pluginProblem, extractedPlugin);
        }
        catch (Throwable e) {
            Intrinsics.checkNotNullExpressionValue(extractedPlugin, "extractedPlugin");
            FileUtilKt.deleteQuietly(extractedPlugin);
            throw e;
        }
        return this.getExtractorResult(extractedPlugin);
    }

    private final ExtractorResult success(Path actualFile, Path fileToDelete) {
        return new ExtractorResult.Success(new ExtractedPlugin(actualFile, fileToDelete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExtractorResult fail(PluginProblem problem, Path extractedPlugin) {
        try {
            ExtractorResult extractorResult = new ExtractorResult.Fail(problem);
            return extractorResult;
        }
        finally {
            FileUtilKt.deleteQuietly(extractedPlugin);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final ExtractorResult getExtractorResult(Path extractedPlugin) {
        rootFiles = FileUtilKt.listFiles(extractedPlugin);
        switch (rootFiles.size()) {
            case 0: {
                return this.fail(new PluginZipIsEmpty(), extractedPlugin);
            }
            case 1: {
                singleFile = rootFiles.get(0);
                if (!FileUtilKt.isJar(singleFile)) ** GOTO lbl10
                v0 = this.fail(new PluginZipContainsSingleJarInRoot(FileUtilKt.getSimpleName(singleFile)), extractedPlugin);
                ** GOTO lbl29
lbl10:
                // 1 sources

                if (!FileUtilKt.isDirectory(singleFile)) ** GOTO lbl28
                allFiles = FileUtilKt.listAllFiles(extractedPlugin);
                Intrinsics.checkNotNullExpressionValue(allFiles, "allFiles");
                $this$any$iv = allFiles;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl18
                v1 = false;
                ** GOTO lbl26
lbl18:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (Path)element$iv;
                    $i$a$-any-DefaultPluginExtractor$getExtractorResult$1 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    if (!this.isJarInZip(it)) continue;
                    v1 = true;
                    ** GOTO lbl26
                }
                v1 = false;
lbl26:
                // 3 sources

                v0 = v1 ? this.success(singleFile, extractedPlugin) : this.fail(new UnexpectedPluginZipStructure(), extractedPlugin);
                ** GOTO lbl29
lbl28:
                // 1 sources

                v0 = this.fail(new PluginZipContainsUnknownFile(FileUtilKt.getSimpleName(singleFile)), extractedPlugin);
lbl29:
                // 3 sources

                return v0;
            }
        }
        singleFile = rootFiles;
        var12_19 = this;
        $i$f$map = false;
        $this$any$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-any-DefaultPluginExtractor$getExtractorResult$1 = (Path)item$iv$iv;
            var13_21 = destination$iv$iv;
            $i$a$-map-DefaultPluginExtractor$getExtractorResult$2 = false;
            var13_21.add(FileUtilKt.getSimpleName((Path)it));
        }
        var14_22 = CollectionsKt.sorted((List)destination$iv$iv);
        return var12_19.fail(new PluginZipContainsMultipleFiles(var14_22), extractedPlugin);
    }

    private final boolean isJarInZip(Path path) {
        boolean bl;
        FileSystem pathFs = path.getFileSystem();
        try {
            PathMatcher pathMatcher;
            PathMatcher pathMatcher2 = pathMatcher = pathFs.getPathMatcher("glob:*/lib/*.jar");
            bl = pathMatcher2 != null ? pathMatcher2.matches(path) : false;
        }
        catch (Throwable e) {
            DefaultPluginExtractorKt.access$getLOG$p().warn("Cannot determine whether 'glob:*/lib/*.jar' is supported by the filesystem [{}]", (Object)pathFs.getClass().getName());
            bl = false;
        }
        return bl;
    }
}

