/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.loaders;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.descriptors.DescriptorResource;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.ModuleFromDescriptorLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.ModuleFromDescriptorLoaderKt;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoadingContext;
import com.jetbrains.plugin.structure.intellij.problems.AnyProblemToWarningPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom2.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/ModuleFromDescriptorLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/ModuleFromDescriptorLoader$Context;", "()V", "loadPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "pluginLoadingContext", "logPluginCreationWarnings", "", "pluginId", "", "pluginCreator", "Context", "structure-intellij"})
public final class ModuleFromDescriptorLoader
implements PluginLoader<Context> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PluginCreator loadPlugin(@NotNull Context pluginLoadingContext) {
        PluginCreator pluginCreator;
        Intrinsics.checkNotNullParameter(pluginLoadingContext, "pluginLoadingContext");
        Context $this$loadPlugin_u24lambda_u243 = pluginLoadingContext;
        boolean bl = false;
        Closeable closeable = $this$loadPlugin_u24lambda_u243.getDescriptorResource().getInputStream();
        Throwable throwable = null;
        try {
            PluginCreator pluginCreator2;
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            try {
                PluginCreator pluginCreator3;
                AnyProblemToWarningPluginCreationResultResolver problemResolver = AnyProblemToWarningPluginCreationResultResolver.INSTANCE;
                Document document = JDOMUtil.loadDocument(it);
                Intrinsics.checkNotNullExpressionValue(document, "loadDocument(it)");
                Document descriptorXml = document;
                PluginCreator it2 = pluginCreator3 = PluginCreator.Companion.createPlugin($this$loadPlugin_u24lambda_u243.getDescriptorResource(), $this$loadPlugin_u24lambda_u243.getParentPlugin(), descriptorXml, $this$loadPlugin_u24lambda_u243.getResourceResolver(), problemResolver);
                boolean bl3 = false;
                this.logPluginCreationWarnings($this$loadPlugin_u24lambda_u243.getModuleId(), it2);
                pluginCreator2 = pluginCreator3;
            }
            catch (IOException e) {
                DescriptorResource $this$loadPlugin_u24lambda_u243_u24lambda_u242_u24lambda_u241 = $this$loadPlugin_u24lambda_u243.getDescriptorResource();
                boolean bl4 = false;
                ModuleFromDescriptorLoaderKt.access$getLOG$p().warn("Unable to read descriptor stream (source: '" + $this$loadPlugin_u24lambda_u243_u24lambda_u242_u24lambda_u241.getUri() + "')", e);
                UnableToReadDescriptor problem = new UnableToReadDescriptor($this$loadPlugin_u24lambda_u243_u24lambda_u242_u24lambda_u241.getFileName(), e.getLocalizedMessage());
                pluginCreator2 = PluginCreator.Companion.createInvalidPlugin($this$loadPlugin_u24lambda_u243_u24lambda_u242_u24lambda_u241.getArtifactFileName(), $this$loadPlugin_u24lambda_u243_u24lambda_u242_u24lambda_u241.getFileName(), (PluginProblem)problem);
            }
            pluginCreator = pluginCreator2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return pluginCreator;
    }

    private final void logPluginCreationWarnings(String pluginId, PluginCreator pluginCreator) {
        PluginCreationResult<IdePlugin> pluginCreationResult = pluginCreator.getPluginCreationResult();
        if (ModuleFromDescriptorLoaderKt.access$getLOG$p().isDebugEnabled() && pluginCreationResult instanceof PluginCreationSuccess) {
            String warningMessage2 = CollectionsKt.joinToString$default(((PluginCreationSuccess)pluginCreationResult).getWarnings(), "\n", null, null, 0, null, logPluginCreationWarnings.warningMessage.1.INSTANCE, 30, null);
            ModuleFromDescriptorLoaderKt.access$getLOG$p().debug("Plugin or module '" + pluginId + "' has plugin problems: " + warningMessage2);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/ModuleFromDescriptorLoader$Context;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoadingContext;", "moduleId", "", "descriptorResource", "Lcom/jetbrains/plugin/structure/intellij/plugin/descriptors/DescriptorResource;", "parentPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "(Ljava/lang/String;Lcom/jetbrains/plugin/structure/intellij/plugin/descriptors/DescriptorResource;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;)V", "getDescriptorResource", "()Lcom/jetbrains/plugin/structure/intellij/plugin/descriptors/DescriptorResource;", "getModuleId", "()Ljava/lang/String;", "getParentPlugin", "()Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "getResourceResolver", "()Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "structure-intellij"})
    public static final class Context
    extends PluginLoadingContext {
        @NotNull
        private final String moduleId;
        @NotNull
        private final DescriptorResource descriptorResource;
        @Nullable
        private final PluginCreator parentPlugin;
        @NotNull
        private final ResourceResolver resourceResolver;

        public Context(@NotNull String moduleId, @NotNull DescriptorResource descriptorResource, @Nullable PluginCreator parentPlugin, @NotNull ResourceResolver resourceResolver) {
            Intrinsics.checkNotNullParameter(moduleId, "moduleId");
            Intrinsics.checkNotNullParameter(descriptorResource, "descriptorResource");
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            super(resourceResolver, AnyProblemToWarningPluginCreationResultResolver.INSTANCE);
            this.moduleId = moduleId;
            this.descriptorResource = descriptorResource;
            this.parentPlugin = parentPlugin;
            this.resourceResolver = resourceResolver;
        }

        public /* synthetic */ Context(String string, DescriptorResource descriptorResource, PluginCreator pluginCreator, ResourceResolver resourceResolver, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 4) != 0) {
                pluginCreator = null;
            }
            this(string, descriptorResource, pluginCreator, resourceResolver);
        }

        @NotNull
        public final String getModuleId() {
            return this.moduleId;
        }

        @NotNull
        public final DescriptorResource getDescriptorResource() {
            return this.descriptorResource;
        }

        @Nullable
        public final PluginCreator getParentPlugin() {
            return this.parentPlugin;
        }

        @Override
        @NotNull
        public ResourceResolver getResourceResolver() {
            return this.resourceResolver;
        }

        @NotNull
        public final String component1() {
            return this.moduleId;
        }

        @NotNull
        public final DescriptorResource component2() {
            return this.descriptorResource;
        }

        @Nullable
        public final PluginCreator component3() {
            return this.parentPlugin;
        }

        @NotNull
        public final ResourceResolver component4() {
            return this.resourceResolver;
        }

        @NotNull
        public final Context copy(@NotNull String moduleId, @NotNull DescriptorResource descriptorResource, @Nullable PluginCreator parentPlugin, @NotNull ResourceResolver resourceResolver) {
            Intrinsics.checkNotNullParameter(moduleId, "moduleId");
            Intrinsics.checkNotNullParameter(descriptorResource, "descriptorResource");
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            return new Context(moduleId, descriptorResource, parentPlugin, resourceResolver);
        }

        public static /* synthetic */ Context copy$default(Context context, String string, DescriptorResource descriptorResource, PluginCreator pluginCreator, ResourceResolver resourceResolver, int n, Object object) {
            if ((n & 1) != 0) {
                string = context.moduleId;
            }
            if ((n & 2) != 0) {
                descriptorResource = context.descriptorResource;
            }
            if ((n & 4) != 0) {
                pluginCreator = context.parentPlugin;
            }
            if ((n & 8) != 0) {
                resourceResolver = context.resourceResolver;
            }
            return context.copy(string, descriptorResource, pluginCreator, resourceResolver);
        }

        @NotNull
        public String toString() {
            return "Context(moduleId=" + this.moduleId + ", descriptorResource=" + this.descriptorResource + ", parentPlugin=" + this.parentPlugin + ", resourceResolver=" + this.resourceResolver + ")";
        }

        public int hashCode() {
            int result2 = this.moduleId.hashCode();
            result2 = result2 * 31 + this.descriptorResource.hashCode();
            result2 = result2 * 31 + (this.parentPlugin == null ? 0 : this.parentPlugin.hashCode());
            result2 = result2 * 31 + this.resourceResolver.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual(this.moduleId, context.moduleId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.descriptorResource, context.descriptorResource)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.parentPlugin, context.parentPlugin)) {
                return false;
            }
            return Intrinsics.areEqual(this.resourceResolver, context.resourceResolver);
        }
    }
}

