/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.filtering;

import com.jetbrains.pluginverifier.filtering.IgnoreCondition;
import com.jetbrains.pluginverifier.filtering.ProblemsFilter;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.verifiers.PluginVerificationContext;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/pluginverifier/filtering/IgnoredProblemsFilter;", "Lcom/jetbrains/pluginverifier/filtering/ProblemsFilter;", "ignoreConditions", "", "Lcom/jetbrains/pluginverifier/filtering/IgnoreCondition;", "(Ljava/util/List;)V", "getIgnoreConditions", "()Ljava/util/List;", "shouldReportProblem", "Lcom/jetbrains/pluginverifier/filtering/ProblemsFilter$Result;", "problem", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "verifier-intellij"})
public final class IgnoredProblemsFilter
implements ProblemsFilter {
    @NotNull
    private final List<IgnoreCondition> ignoreConditions;

    public IgnoredProblemsFilter(@NotNull List<IgnoreCondition> ignoreConditions) {
        Intrinsics.checkNotNullParameter(ignoreConditions, "ignoreConditions");
        this.ignoreConditions = ignoreConditions;
    }

    @NotNull
    public final List<IgnoreCondition> getIgnoreConditions() {
        return this.ignoreConditions;
    }

    @Override
    @NotNull
    public ProblemsFilter.Result shouldReportProblem(@NotNull CompatibilityProblem problem, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(problem, "problem");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(context instanceof PluginVerificationContext)) {
            return ProblemsFilter.Result.Report.INSTANCE;
        }
        String currentId = ((PluginVerificationContext)context).getIdePlugin().getPluginId();
        String currentVersion = ((PluginVerificationContext)context).getIdePlugin().getPluginVersion();
        for (IgnoreCondition ignoreCondition : this.ignoreConditions) {
            String pluginId = ignoreCondition.component1();
            String version = ignoreCondition.component2();
            Regex pattern = ignoreCondition.component3();
            if (pluginId != null && !Intrinsics.areEqual(pluginId, currentId) || version != null && !Intrinsics.areEqual(version, currentVersion) || !pattern.matches(problem.getShortDescription())) continue;
            return new ProblemsFilter.Result.Ignore("the problem is ignored by RegExp pattern: \"" + pattern + "\"");
        }
        return ProblemsFilter.Result.Report.INSTANCE;
    }
}

