/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.jdk;

import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/pluginverifier/jdk/JdkVersion;", "", "javaVersion", "", "bundledTo", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "(Ljava/lang/String;Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;)V", "getBundledTo", "()Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "isBundled", "", "()Z", "getJavaVersion", "()Ljava/lang/String;", "majorVersion", "", "getMajorVersion", "()I", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "verifier-intellij"})
public final class JdkVersion {
    @NotNull
    private final String javaVersion;
    @Nullable
    private final IdeVersion bundledTo;
    private final int majorVersion;

    public JdkVersion(@NotNull String javaVersion, @Nullable IdeVersion bundledTo) {
        Intrinsics.checkNotNullParameter(javaVersion, "javaVersion");
        this.javaVersion = javaVersion;
        this.bundledTo = bundledTo;
        Integer n = StringsKt.startsWith$default(this.javaVersion, "1.", false, 2, null) ? StringsKt.toIntOrNull(StringsKt.substringBefore$default(StringsKt.substringAfter$default(this.javaVersion, "1.", null, 2, null), ".", null, 2, null)) : StringsKt.toIntOrNull(StringsKt.substringBefore$default(this.javaVersion, ".", null, 2, null));
        if (n == null) {
            throw new IllegalArgumentException("Invalid version: '" + this.javaVersion + "'");
        }
        this.majorVersion = n;
    }

    @NotNull
    public final String getJavaVersion() {
        return this.javaVersion;
    }

    @Nullable
    public final IdeVersion getBundledTo() {
        return this.bundledTo;
    }

    public final boolean isBundled() {
        return this.bundledTo != null;
    }

    public final int getMajorVersion() {
        return this.majorVersion;
    }

    @NotNull
    public final String component1() {
        return this.javaVersion;
    }

    @Nullable
    public final IdeVersion component2() {
        return this.bundledTo;
    }

    @NotNull
    public final JdkVersion copy(@NotNull String javaVersion, @Nullable IdeVersion bundledTo) {
        Intrinsics.checkNotNullParameter(javaVersion, "javaVersion");
        return new JdkVersion(javaVersion, bundledTo);
    }

    public static /* synthetic */ JdkVersion copy$default(JdkVersion jdkVersion, String string, IdeVersion ideVersion, int n, Object object) {
        if ((n & 1) != 0) {
            string = jdkVersion.javaVersion;
        }
        if ((n & 2) != 0) {
            ideVersion = jdkVersion.bundledTo;
        }
        return jdkVersion.copy(string, ideVersion);
    }

    @NotNull
    public String toString() {
        return "JdkVersion(javaVersion=" + this.javaVersion + ", bundledTo=" + this.bundledTo + ")";
    }

    public int hashCode() {
        int result2 = this.javaVersion.hashCode();
        result2 = result2 * 31 + (this.bundledTo == null ? 0 : this.bundledTo.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JdkVersion)) {
            return false;
        }
        JdkVersion jdkVersion = (JdkVersion)other;
        if (!Intrinsics.areEqual(this.javaVersion, jdkVersion.javaVersion)) {
            return false;
        }
        return Intrinsics.areEqual(this.bundledTo, jdkVersion.bundledTo);
    }
}

