/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0014\u0010\r\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/SuperClassBecameInterfaceProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "child", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "interfaze", "(Lcom/jetbrains/pluginverifier/results/location/ClassLocation;Lcom/jetbrains/pluginverifier/results/location/ClassLocation;)V", "getChild", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "getInterfaze", "problemType", "getProblemType", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class SuperClassBecameInterfaceProblem
extends CompatibilityProblem {
    @NotNull
    private final ClassLocation child;
    @NotNull
    private final ClassLocation interfaze;

    public SuperClassBecameInterfaceProblem(@NotNull ClassLocation child, @NotNull ClassLocation interfaze) {
        Intrinsics.checkNotNullParameter(child, "child");
        Intrinsics.checkNotNullParameter(interfaze, "interfaze");
        this.child = child;
        this.interfaze = interfaze;
    }

    @NotNull
    public final ClassLocation getChild() {
        return this.child;
    }

    @NotNull
    public final ClassLocation getInterfaze() {
        return this.interfaze;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Incompatible change of super class to interface";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.interfaze};
        return FormatUtilsKt.formatMessage("Incompatible change of super class {0} to interface", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        Object[] objectArray = new Object[]{this.child, this.interfaze};
        return FormatUtilsKt.formatMessage("Class {0} has a *super class* {1} which is actually an *interface*. This can lead to **IncompatibleClassChangeError** at runtime.", objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SuperClassBecameInterfaceProblem && Intrinsics.areEqual(this.child, ((SuperClassBecameInterfaceProblem)other).child) && Intrinsics.areEqual(this.interfaze, ((SuperClassBecameInterfaceProblem)other).interfaze);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.child, this.interfaze};
        return Objects.hash(objectArray);
    }
}

