/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.ide.BuildTxtIdeVersionProvider;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.ide.IdeManager;
import com.jetbrains.plugin.structure.ide.IdeVersionResolution;
import com.jetbrains.plugin.structure.ide.InvalidIdeException;
import com.jetbrains.plugin.structure.ide.PluginCollectionProvider;
import com.jetbrains.plugin.structure.ide.PluginCollectionSource;
import com.jetbrains.plugin.structure.ide.ProductInfoBasedIde;
import com.jetbrains.plugin.structure.ide.ProductInfoBasedIdeManagerKt;
import com.jetbrains.plugin.structure.ide.ProductInfoLayoutBasedPluginCollectionProvider;
import com.jetbrains.plugin.structure.ide.ProductInfoLayoutComponentsPluginCollectionSource;
import com.jetbrains.plugin.structure.ide.ProductInfoPluginCollectionSource;
import com.jetbrains.plugin.structure.ide.ProductInfoPluginReaderPluginCollectionProvider;
import com.jetbrains.plugin.structure.ide.layout.LayoutComponentNameSource;
import com.jetbrains.plugin.structure.ide.layout.LayoutComponents;
import com.jetbrains.plugin.structure.ide.layout.MissingLayoutFileMode;
import com.jetbrains.plugin.structure.ide.resolver.ValidatingLayoutComponentsProvider;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfo;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfoParseException;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfoParser;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.plugin.structure.jar.SingletonCachingJarFileSystemProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003()*B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J<\u0010\u001d\u001a\u001e\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000f\u0012\u0002\b\u00030\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0 0\u001e2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010%\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u000fJ\u001c\u0010&\u001a\u00020\u001c*\u00020\b2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010&\u001a\u00020'*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager;", "Lcom/jetbrains/plugin/structure/ide/IdeManager;", "missingLayoutFileMode", "Lcom/jetbrains/plugin/structure/ide/layout/MissingLayoutFileMode;", "additionalProductInfoPluginReader", "Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$PluginReader;", "Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfo;", "additionalLayoutComponentsPluginReader", "Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponents;", "(Lcom/jetbrains/plugin/structure/ide/layout/MissingLayoutFileMode;Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$PluginReader;Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$PluginReader;)V", "layoutComponentsProvider", "Lcom/jetbrains/plugin/structure/ide/resolver/ValidatingLayoutComponentsProvider;", "productInfoParser", "Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfoParser;", "productInfoJson", "Ljava/nio/file/Path;", "getProductInfoJson", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "assertProductInfoPresent", "idePath", "createIde", "Lcom/jetbrains/plugin/structure/ide/Ide;", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "productInfo", "version", "createIdeVersion", "createLayoutComponentsSource", "Lcom/jetbrains/plugin/structure/ide/ProductInfoLayoutComponentsPluginCollectionSource;", "createPluginCollectionProviders", "", "Lcom/jetbrains/plugin/structure/ide/PluginCollectionSource;", "Lcom/jetbrains/plugin/structure/ide/PluginCollectionProvider;", "isAtLeastVersion", "", "expectedVersion", "", "supports", "asSource", "Lcom/jetbrains/plugin/structure/ide/ProductInfoPluginCollectionSource;", "NoOpLayoutComponentsPluginReader", "NoOpProductInfoPluginReader", "PluginReader", "structure-ide"})
@SourceDebugExtension(value={"SMAP\nProductInfoBasedIdeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductInfoBasedIdeManager.kt\ncom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n288#2,2:154\n*E\n*S KotlinDebug\n*F\n+ 1 ProductInfoBasedIdeManager.kt\ncom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager\n*L\n101#1,2:154\n*E\n"})
public final class ProductInfoBasedIdeManager
extends IdeManager {
    @NotNull
    private final PluginReader<ProductInfo> additionalProductInfoPluginReader;
    @NotNull
    private final PluginReader<LayoutComponents> additionalLayoutComponentsPluginReader;
    @NotNull
    private final ProductInfoParser productInfoParser;
    @NotNull
    private final ValidatingLayoutComponentsProvider layoutComponentsProvider;

    public ProductInfoBasedIdeManager(@NotNull MissingLayoutFileMode missingLayoutFileMode, @NotNull PluginReader<ProductInfo> additionalProductInfoPluginReader, @NotNull PluginReader<LayoutComponents> additionalLayoutComponentsPluginReader) {
        Intrinsics.checkNotNullParameter((Object)missingLayoutFileMode, "missingLayoutFileMode");
        Intrinsics.checkNotNullParameter(additionalProductInfoPluginReader, "additionalProductInfoPluginReader");
        Intrinsics.checkNotNullParameter(additionalLayoutComponentsPluginReader, "additionalLayoutComponentsPluginReader");
        this.additionalProductInfoPluginReader = additionalProductInfoPluginReader;
        this.additionalLayoutComponentsPluginReader = additionalLayoutComponentsPluginReader;
        this.productInfoParser = new ProductInfoParser();
        this.layoutComponentsProvider = new ValidatingLayoutComponentsProvider(missingLayoutFileMode);
    }

    public /* synthetic */ ProductInfoBasedIdeManager(MissingLayoutFileMode missingLayoutFileMode, PluginReader pluginReader, PluginReader pluginReader2, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            missingLayoutFileMode = MissingLayoutFileMode.SKIP_AND_WARN;
        }
        if ((n & 2) != 0) {
            pluginReader = NoOpProductInfoPluginReader.INSTANCE;
        }
        if ((n & 4) != 0) {
            pluginReader2 = NoOpLayoutComponentsPluginReader.INSTANCE;
        }
        this(missingLayoutFileMode, pluginReader, pluginReader2);
    }

    @Override
    @NotNull
    public Ide createIde(@NotNull Path idePath) throws InvalidIdeException {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        return this.createIde(idePath, ProductInfoBasedIdeManagerKt.getVERSION_FROM_PRODUCT_INFO());
    }

    @Override
    @NotNull
    public Ide createIde(@NotNull Path idePath, @Nullable IdeVersion version) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        this.assertProductInfoPresent(idePath);
        try {
            Path path = this.getProductInfoJson(idePath);
            Intrinsics.checkNotNull(path);
            ProductInfo productInfo = this.productInfoParser.parse(path);
            IdeVersion ideVersion = version;
            if (ideVersion == null) {
                ideVersion = this.createIdeVersion(productInfo);
            }
            IdeVersion ideVersion2 = ideVersion;
            return this.createIde(idePath, ideVersion2, productInfo);
        }
        catch (ProductInfoParseException e) {
            throw new InvalidIdeException(idePath, e);
        }
    }

    private final Ide createIde(Path idePath, IdeVersion ideVersion, ProductInfo productInfo) {
        if (!FileUtilKt.isDirectory(idePath)) {
            throw new IOException("Specified path does not exist or is not a directory: " + idePath);
        }
        Map<PluginCollectionSource<Path, ?>, PluginCollectionProvider<Path>> pluginCollectionProviders = this.createPluginCollectionProviders(idePath, ideVersion, productInfo);
        return ProductInfoBasedIde.Companion.of(idePath, ideVersion, productInfo, pluginCollectionProviders);
    }

    private final IdeVersion createIdeVersion(ProductInfo productInfo) {
        StringBuilder stringBuilder;
        StringBuilder $this$createIdeVersion_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ProductInfo $this$createIdeVersion_u24lambda_u241_u24lambda_u240 = productInfo;
        boolean bl2 = false;
        if (((CharSequence)$this$createIdeVersion_u24lambda_u241_u24lambda_u240.getProductCode()).length() > 0) {
            $this$createIdeVersion_u24lambda_u241.append($this$createIdeVersion_u24lambda_u241_u24lambda_u240.getProductCode()).append("-");
        }
        $this$createIdeVersion_u24lambda_u241.append($this$createIdeVersion_u24lambda_u241_u24lambda_u240.getBuildNumber());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String versionString = string;
        IdeVersion ideVersion = IdeVersion.createIdeVersion(versionString);
        Intrinsics.checkNotNullExpressionValue(ideVersion, "createIdeVersion(versionString)");
        return ideVersion;
    }

    private final Map<PluginCollectionSource<Path, ?>, PluginCollectionProvider<Path>> createPluginCollectionProviders(Path idePath, IdeVersion ideVersion, ProductInfo productInfo) {
        Map map;
        Map $this$createPluginCollectionProviders_u24lambda_u242 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        ProductInfoLayoutComponentsPluginCollectionSource layoutComponentsSource = this.createLayoutComponentsSource(idePath, ideVersion, productInfo);
        $this$createPluginCollectionProviders_u24lambda_u242.put(layoutComponentsSource, new ProductInfoLayoutBasedPluginCollectionProvider(this.additionalLayoutComponentsPluginReader, SingletonCachingJarFileSystemProvider.INSTANCE));
        if (!(this.additionalProductInfoPluginReader instanceof NoOpProductInfoPluginReader)) {
            ProductInfoPluginCollectionSource productInfoSource = this.asSource(productInfo, idePath, ideVersion);
            $this$createPluginCollectionProviders_u24lambda_u242.put(productInfoSource, new ProductInfoPluginReaderPluginCollectionProvider(this.additionalProductInfoPluginReader));
        }
        return map;
    }

    private final ProductInfoLayoutComponentsPluginCollectionSource createLayoutComponentsSource(Path idePath, IdeVersion ideVersion, ProductInfo productInfo) {
        return this.asSource(this.layoutComponentsProvider.resolveLayoutComponents(productInfo, idePath), idePath, ideVersion);
    }

    private final ProductInfoPluginCollectionSource asSource(ProductInfo $this$asSource, Path idePath, IdeVersion ideVersion) {
        return new ProductInfoPluginCollectionSource(idePath, ideVersion, $this$asSource);
    }

    private final ProductInfoLayoutComponentsPluginCollectionSource asSource(LayoutComponents $this$asSource, Path idePath, IdeVersion ideVersion) {
        return new ProductInfoLayoutComponentsPluginCollectionSource(idePath, ideVersion, $this$asSource);
    }

    private final Path getProductInfoJson(Path $this$productInfoJson) {
        Object v0;
        block1: {
            Path[] pathArray = new Path[2];
            Intrinsics.checkNotNullExpressionValue($this$productInfoJson.resolve("product-info.json"), "resolve(PRODUCT_INFO_JSON)");
            Intrinsics.checkNotNullExpressionValue($this$productInfoJson.resolve("Resources").resolve("product-info.json"), "resolve(MACOS_RESOURCES_\u2026esolve(PRODUCT_INFO_JSON)");
            List<Path> locations = CollectionsKt.listOf(pathArray);
            Iterable $this$firstOrNull$iv = locations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!FileUtilKt.exists(it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final Path assertProductInfoPresent(Path idePath) throws InvalidIdeException {
        Path path = this.getProductInfoJson(idePath);
        if (path == null) {
            throw new InvalidIdeException(idePath, "The 'product-info.json' file is not available.");
        }
        return path;
    }

    public final boolean supports(@NotNull Path idePath) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        return this.getProductInfoJson(idePath) != null && this.isAtLeastVersion(idePath, "242");
    }

    private final boolean isAtLeastVersion(Path idePath, String expectedVersion) {
        boolean bl;
        IdeVersionResolution version = new BuildTxtIdeVersionProvider().readIdeVersion(idePath);
        if (version instanceof IdeVersionResolution.Found) {
            bl = ((IdeVersionResolution.Found)version).getIdeVersion().compareTo(IdeVersion.createIdeVersion(expectedVersion)) > 0;
        } else if (version instanceof IdeVersionResolution.Failed ? true : version instanceof IdeVersionResolution.NotFound) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public ProductInfoBasedIdeManager() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J4\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$NoOpLayoutComponentsPluginReader;", "Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$PluginReader;", "Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponents;", "()V", "readPlugins", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "idePath", "Ljava/nio/file/Path;", "pluginMetadataSource", "layoutComponentNameSource", "Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponentNameSource;", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "supports", "", "", "structure-ide"})
    private static final class NoOpLayoutComponentsPluginReader
    implements PluginReader<LayoutComponents> {
        @NotNull
        public static final NoOpLayoutComponentsPluginReader INSTANCE = new NoOpLayoutComponentsPluginReader();

        private NoOpLayoutComponentsPluginReader() {
        }

        @Override
        @NotNull
        public List<IdePlugin> readPlugins(@NotNull Path idePath, @NotNull LayoutComponents pluginMetadataSource, @NotNull LayoutComponentNameSource<LayoutComponents> layoutComponentNameSource, @NotNull IdeVersion ideVersion) {
            Intrinsics.checkNotNullParameter(idePath, "idePath");
            Intrinsics.checkNotNullParameter(pluginMetadataSource, "pluginMetadataSource");
            Intrinsics.checkNotNullParameter(layoutComponentNameSource, "layoutComponentNameSource");
            Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
            return CollectionsKt.emptyList();
        }

        @Override
        public boolean supports(@NotNull Object pluginMetadataSource) {
            Intrinsics.checkNotNullParameter(pluginMetadataSource, "pluginMetadataSource");
            return true;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J4\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$NoOpProductInfoPluginReader;", "Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$PluginReader;", "Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfo;", "()V", "readPlugins", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "idePath", "Ljava/nio/file/Path;", "pluginMetadataSource", "layoutComponentNameSource", "Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponentNameSource;", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "supports", "", "", "structure-ide"})
    private static final class NoOpProductInfoPluginReader
    implements PluginReader<ProductInfo> {
        @NotNull
        public static final NoOpProductInfoPluginReader INSTANCE = new NoOpProductInfoPluginReader();

        private NoOpProductInfoPluginReader() {
        }

        @Override
        @NotNull
        public List<IdePlugin> readPlugins(@NotNull Path idePath, @NotNull ProductInfo pluginMetadataSource, @NotNull LayoutComponentNameSource<ProductInfo> layoutComponentNameSource, @NotNull IdeVersion ideVersion) {
            Intrinsics.checkNotNullParameter(idePath, "idePath");
            Intrinsics.checkNotNullParameter(pluginMetadataSource, "pluginMetadataSource");
            Intrinsics.checkNotNullParameter(layoutComponentNameSource, "layoutComponentNameSource");
            Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
            return CollectionsKt.emptyList();
        }

        @Override
        public boolean supports(@NotNull Object pluginMetadataSource) {
            Intrinsics.checkNotNullParameter(pluginMetadataSource, "pluginMetadataSource");
            return true;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J9\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0002H&\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager$PluginReader;", "S", "", "readPlugins", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "idePath", "Ljava/nio/file/Path;", "pluginMetadataSource", "layoutComponentNameSource", "Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponentNameSource;", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "(Ljava/nio/file/Path;Ljava/lang/Object;Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponentNameSource;Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;)Ljava/util/List;", "supports", "", "structure-ide"})
    public static interface PluginReader<S> {
        @NotNull
        public List<IdePlugin> readPlugins(@NotNull Path var1, S var2, @NotNull LayoutComponentNameSource<S> var3, @NotNull IdeVersion var4);

        public boolean supports(@NotNull Object var1);
    }
}

