/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.ide.repositories;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.ide.AvailableIde;
import com.jetbrains.pluginverifier.ide.IntelliJRepositoryIndexParser;
import com.jetbrains.pluginverifier.ide.repositories.ArtifactJson;
import com.jetbrains.pluginverifier.ide.repositories.IdeRepository;
import com.jetbrains.pluginverifier.ide.repositories.RepositoryIndexConnector;
import com.jetbrains.pluginverifier.repository.cache.MemoizerKt;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/pluginverifier/ide/repositories/IntelliJIdeRepository;", "Lcom/jetbrains/pluginverifier/ide/repositories/IdeRepository;", "channel", "Lcom/jetbrains/pluginverifier/ide/repositories/IntelliJIdeRepository$Channel;", "(Lcom/jetbrains/pluginverifier/ide/repositories/IntelliJIdeRepository$Channel;)V", "indexBaseUrl", "", "getIndexBaseUrl", "()Ljava/lang/String;", "indexCache", "Ljava/util/function/Supplier;", "", "Lcom/jetbrains/pluginverifier/ide/AvailableIde;", "repositoryIndexConnector", "Lcom/jetbrains/pluginverifier/ide/repositories/RepositoryIndexConnector;", "getRepositoryIndexConnector", "()Lcom/jetbrains/pluginverifier/ide/repositories/RepositoryIndexConnector;", "repositoryIndexConnector$delegate", "Lkotlin/Lazy;", "fetchIndex", "toString", "updateIndex", "Channel", "Companion", "verifier-repository"})
public class IntelliJIdeRepository
implements IdeRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Channel channel;
    @NotNull
    private final Lazy repositoryIndexConnector$delegate;
    @NotNull
    private final Supplier<List<AvailableIde>> indexCache;
    @NotNull
    private static final List<Triple<String, String, String>> artifactIdGroupIdAndProductCode;

    public IntelliJIdeRepository(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, "channel");
        this.channel = channel;
        this.repositoryIndexConnector$delegate = LazyKt.lazy((Function0)new Function0<RepositoryIndexConnector>(this){
            final /* synthetic */ IntelliJIdeRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RepositoryIndexConnector invoke() {
                return new RepositoryIndexConnector(this.this$0.getIndexBaseUrl());
            }
        });
        this.indexCache = MemoizerKt.memoize(1L, (Function0)new Function0<List<? extends AvailableIde>>(this){
            final /* synthetic */ IntelliJIdeRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<AvailableIde> invoke() {
                return IntelliJIdeRepository.access$updateIndex(this.this$0);
            }
        });
    }

    private final RepositoryIndexConnector getRepositoryIndexConnector() {
        Lazy lazy = this.repositoryIndexConnector$delegate;
        return (RepositoryIndexConnector)lazy.getValue();
    }

    private final List<AvailableIde> updateIndex() {
        try {
            List<ArtifactJson> artifacts = this.getRepositoryIndexConnector().getIndex();
            return new IntelliJRepositoryIndexParser().parseArtifacts(artifacts, this.channel);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            if (this.channel == Channel.NIGHTLY) {
                throw new IOException("Failed to fetch index from nightly channel. This channel is only accessible with JetBrains VPN connection", e);
            }
            throw e;
        }
    }

    @NotNull
    protected String getIndexBaseUrl() {
        return this.channel.getRepositoryUrl();
    }

    @Override
    @NotNull
    public List<AvailableIde> fetchIndex() {
        List<AvailableIde> list = this.indexCache.get();
        Intrinsics.checkNotNullExpressionValue(list, "indexCache.get()");
        return list;
    }

    @NotNull
    public String toString() {
        String string = this.channel.name();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        return "IntelliJ Artifacts Repository (channel = " + string2 + ")";
    }

    public static final /* synthetic */ List access$updateIndex(IntelliJIdeRepository $this) {
        return $this.updateIndex();
    }

    static {
        Triple[] tripleArray = new Triple[]{new Triple<String, String, String>("ideaIC", "com.jetbrains.intellij.idea", "IC"), new Triple<String, String, String>("ideaIU", "com.jetbrains.intellij.idea", "IU"), new Triple<String, String, String>("riderRD", "com.jetbrains.intellij.rider", "RD"), new Triple<String, String, String>("mps", "com.jetbrains.mps", "MPS"), new Triple<String, String, String>("clion", "com.jetbrains.intellij.clion", "CL"), new Triple<String, String, String>("goland", "com.jetbrains.intellij.goland", "GO")};
        artifactIdGroupIdAndProductCode = CollectionsKt.listOf(tripleArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/pluginverifier/ide/repositories/IntelliJIdeRepository$Channel;", "", "repositoryUrl", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getRepositoryUrl", "()Ljava/lang/String;", "RELEASE", "SNAPSHOTS", "NIGHTLY", "verifier-repository"})
    public static final class Channel
    extends Enum<Channel> {
        @NotNull
        private final String repositoryUrl;
        public static final /* enum */ Channel RELEASE = new Channel("https://cache-redirector.jetbrains.com/intellij-repository/releases");
        public static final /* enum */ Channel SNAPSHOTS = new Channel("https://cache-redirector.jetbrains.com/intellij-repository/snapshots");
        public static final /* enum */ Channel NIGHTLY = new Channel("https://www.jetbrains.com/intellij-repository/nightly");
        private static final /* synthetic */ Channel[] $VALUES;

        private Channel(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
        }

        @NotNull
        public final String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        public static Channel[] values() {
            return (Channel[])$VALUES.clone();
        }

        public static Channel valueOf(String value) {
            return Enum.valueOf(Channel.class, value);
        }

        static {
            $VALUES = channelArray = new Channel[]{Channel.RELEASE, Channel.SNAPSHOTS, Channel.NIGHTLY};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u0006R&\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/pluginverifier/ide/repositories/IntelliJIdeRepository$Companion;", "", "()V", "artifactIdGroupIdAndProductCode", "", "Lkotlin/Triple;", "", "getArtifactIdByProductCode", "productCode", "getGroupIdByProductCode", "getProductCodeByArtifactId", "artifactId", "verifier-repository"})
    @SourceDebugExtension(value={"SMAP\nIntelliJIdeRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJIdeRepository.kt\ncom/jetbrains/pluginverifier/ide/repositories/IntelliJIdeRepository$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getArtifactIdByProductCode(@NotNull String productCode) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(productCode, "productCode");
                Iterable iterable = artifactIdGroupIdAndProductCode;
                for (Object t2 : iterable) {
                    Triple it = (Triple)t2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getThird(), productCode)) continue;
                    v0 = t2;
                    break block1;
                }
                v0 = null;
            }
            Triple triple = v0;
            return triple != null ? (String)triple.getFirst() : null;
        }

        @Nullable
        public final String getGroupIdByProductCode(@NotNull String productCode) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(productCode, "productCode");
                Iterable iterable = artifactIdGroupIdAndProductCode;
                for (Object t2 : iterable) {
                    Triple it = (Triple)t2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getThird(), productCode)) continue;
                    v0 = t2;
                    break block1;
                }
                v0 = null;
            }
            Triple triple = v0;
            return triple != null ? (String)triple.getSecond() : null;
        }

        @Nullable
        public final String getProductCodeByArtifactId(@NotNull String artifactId) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(artifactId, "artifactId");
                Iterable iterable = artifactIdGroupIdAndProductCode;
                for (Object t2 : iterable) {
                    Triple it = (Triple)t2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getFirst(), artifactId)) continue;
                    v0 = t2;
                    break block1;
                }
                v0 = null;
            }
            Triple triple = v0;
            return triple != null ? (String)triple.getThird() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

