/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.presentation;

import com.jetbrains.pluginverifier.results.presentation.JvmDescriptorsPresentationKt;
import com.jetbrains.pluginverifier.results.signatures.ClassSignature;
import com.jetbrains.pluginverifier.results.signatures.FieldSignature;
import com.jetbrains.pluginverifier.results.signatures.FormatOptions;
import com.jetbrains.pluginverifier.results.signatures.JavaTypeSignature;
import com.jetbrains.pluginverifier.results.signatures.MethodSignature;
import com.jetbrains.pluginverifier.results.signatures.SigVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.signature.SignatureReader;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0002\b\bJ'\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0002\b\bJ9\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0002\b\bJ'\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0002\b\bJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J \u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u0011\u001a\u00020\u0004\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/pluginverifier/results/presentation/JvmDescriptorsPresentation;", "", "()V", "convertClassSignature", "", "signature", "binaryNameConverter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "convertJvmDescriptorToNormalPresentation", "descriptor", "convertMethodSignature", "Lkotlin/Pair;", "", "convertTypeSignature", "typeSignature", "parseMethodParametersTypesByDescriptor", "methodDescriptor", "runSignatureVisitor", "Lcom/jetbrains/pluginverifier/results/signatures/SigVisitor;", "splitMethodDescriptorOnRawParametersAndReturnTypes", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nJvmDescriptorsPresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmDescriptorsPresentation.kt\ncom/jetbrains/pluginverifier/results/presentation/JvmDescriptorsPresentation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1#2:143\n1549#3:144\n1620#3,3:145\n*S KotlinDebug\n*F\n+ 1 JvmDescriptorsPresentation.kt\ncom/jetbrains/pluginverifier/results/presentation/JvmDescriptorsPresentation\n*L\n67#1:144\n67#1:145,3\n*E\n"})
public final class JvmDescriptorsPresentation {
    @NotNull
    public static final JvmDescriptorsPresentation INSTANCE = new JvmDescriptorsPresentation();

    private JvmDescriptorsPresentation() {
    }

    @NotNull
    public final String convertJvmDescriptorToNormalPresentation(@NotNull String descriptor2, @NotNull Function1<? super String, String> binaryNameConverter) {
        String string;
        String elemType;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(binaryNameConverter, "binaryNameConverter");
        int dims = 0;
        while (descriptor2.charAt(dims) == '[') {
            ++dims;
        }
        String string2 = descriptor2.substring(dims);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        switch (elemType = string2) {
            case "V": {
                string = "void";
                break;
            }
            case "Z": {
                string = "boolean";
                break;
            }
            case "C": {
                string = "char";
                break;
            }
            case "B": {
                string = "byte";
                break;
            }
            case "S": {
                string = "short";
                break;
            }
            case "I": {
                string = "int";
                break;
            }
            case "F": {
                string = "float";
                break;
            }
            case "J": {
                string = "long";
                break;
            }
            case "D": {
                string = "double";
                break;
            }
            default: {
                if (!(StringsKt.startsWith$default(elemType, "L", false, 2, null) && StringsKt.endsWith$default(elemType, ";", false, 2, null) && elemType.length() > 2)) {
                    boolean bl = false;
                    String string3 = elemType;
                    throw new IllegalArgumentException(string3.toString());
                }
                String string4 = elemType.substring(1, elemType.length() - 1);
                Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                string = binaryNameConverter.invoke(string4);
            }
        }
        String arrayType = string;
        return arrayType + StringsKt.repeat("[]", dims);
    }

    @NotNull
    public final Pair<List<String>, String> splitMethodDescriptorOnRawParametersAndReturnTypes(@NotNull String methodDescriptor) {
        Intrinsics.checkNotNullParameter(methodDescriptor, "methodDescriptor");
        List<String> parameterTypes = this.parseMethodParametersTypesByDescriptor(methodDescriptor);
        String returnType = StringsKt.substringAfter$default(methodDescriptor, ")", null, 2, null);
        return TuplesKt.to(parameterTypes, returnType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<List<String>, String> convertMethodSignature(@NotNull String signature2, @NotNull Function1<? super String, String> binaryNameConverter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(binaryNameConverter, "binaryNameConverter");
        if (!(((CharSequence)signature2).length() > 0)) {
            boolean $i$a$-require-JvmDescriptorsPresentation$convertMethodSignature$22 = false;
            String $i$a$-require-JvmDescriptorsPresentation$convertMethodSignature$22 = "Empty signature is not expected here";
            throw new IllegalArgumentException($i$a$-require-JvmDescriptorsPresentation$convertMethodSignature$22.toString());
        }
        SigVisitor visitor2 = this.runSignatureVisitor(signature2);
        MethodSignature methodSignature = visitor2.getMethodSignature();
        FormatOptions formatOptions = new FormatOptions(false, false, false, false, false, false, false, binaryNameConverter, null, null, 895, null);
        String returnType = methodSignature.getResult().format(formatOptions);
        Iterable $this$map$iv = methodSignature.getParameterSignatures();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JavaTypeSignature javaTypeSignature = (JavaTypeSignature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.format(formatOptions));
        }
        List parameters2 = (List)destination$iv$iv;
        return TuplesKt.to(parameters2, returnType);
    }

    private final SigVisitor runSignatureVisitor(String signature2) {
        if (!(((CharSequence)signature2).length() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        SigVisitor visitor2 = new SigVisitor();
        new SignatureReader(signature2).accept(visitor2);
        return visitor2;
    }

    @NotNull
    public final String convertClassSignature(@NotNull String signature2, @NotNull Function1<? super String, String> binaryNameConverter) {
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(binaryNameConverter, "binaryNameConverter");
        if (!(((CharSequence)signature2).length() > 0)) {
            boolean $i$a$-require-JvmDescriptorsPresentation$convertClassSignature$22 = false;
            String $i$a$-require-JvmDescriptorsPresentation$convertClassSignature$22 = "Empty signature is not expected here";
            throw new IllegalArgumentException($i$a$-require-JvmDescriptorsPresentation$convertClassSignature$22.toString());
        }
        SigVisitor visitor2 = null;
        try {
            visitor2 = this.runSignatureVisitor(signature2);
        }
        catch (IllegalArgumentException e) {
            return "{unparseable: " + JvmDescriptorsPresentationKt.access$toHex(signature2) + "}";
        }
        ClassSignature classSignature = visitor2.getClassSignature();
        FormatOptions formatOptions = new FormatOptions(false, false, false, false, false, false, false, binaryNameConverter, null, null, 895, null);
        return classSignature.format(formatOptions);
    }

    @NotNull
    public final String convertTypeSignature(@NotNull String typeSignature, @NotNull Function1<? super String, String> binaryNameConverter) {
        Intrinsics.checkNotNullParameter(typeSignature, "typeSignature");
        Intrinsics.checkNotNullParameter(binaryNameConverter, "binaryNameConverter");
        if (!(((CharSequence)typeSignature).length() > 0)) {
            boolean $i$a$-require-JvmDescriptorsPresentation$convertTypeSignature$22 = false;
            String $i$a$-require-JvmDescriptorsPresentation$convertTypeSignature$22 = "Empty signature is not expected here";
            throw new IllegalArgumentException($i$a$-require-JvmDescriptorsPresentation$convertTypeSignature$22.toString());
        }
        SigVisitor visitor2 = new SigVisitor();
        new SignatureReader(typeSignature).acceptType(visitor2);
        FieldSignature fieldSignature = visitor2.getFieldSignature();
        FormatOptions formatOptions = new FormatOptions(false, false, false, false, false, false, false, binaryNameConverter, null, null, 895, null);
        return fieldSignature.format(formatOptions);
    }

    private final List<String> parseMethodParametersTypesByDescriptor(String methodDescriptor) {
        if (!(StringsKt.startsWith$default(methodDescriptor, "(", false, 2, null) && StringsKt.contains$default((CharSequence)methodDescriptor, ')', false, 2, null))) {
            boolean $i$a$-require-JvmDescriptorsPresentation$parseMethodParametersTypesByDescriptor$22 = false;
            String $i$a$-require-JvmDescriptorsPresentation$parseMethodParametersTypesByDescriptor$22 = "Invalid method descriptor: " + methodDescriptor;
            throw new IllegalArgumentException($i$a$-require-JvmDescriptorsPresentation$parseMethodParametersTypesByDescriptor$22.toString());
        }
        ArrayList<String> rawParameterTypes = new ArrayList<String>();
        int pos = 1;
        while (methodDescriptor.charAt(pos) != ')') {
            int end;
            char c = methodDescriptor.charAt(pos);
            char c2 = c;
            if (StringsKt.contains$default((CharSequence)"ZCBSIFJD", c2, false, 2, null)) {
                rawParameterTypes.add(String.valueOf(c));
                ++pos;
                continue;
            }
            if (c2 == '[') {
                end = pos;
                while (methodDescriptor.charAt(end) == '[') {
                    ++end;
                }
                if (methodDescriptor.charAt(end) == 'L') {
                    end = StringsKt.indexOf$default((CharSequence)methodDescriptor, ';', end, false, 4, null);
                }
                String string = methodDescriptor.substring(pos, end + 1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                rawParameterTypes.add(string);
                pos = end + 1;
                continue;
            }
            if (!(c == 'L')) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            end = StringsKt.indexOf$default((CharSequence)methodDescriptor, ';', pos, false, 4, null);
            String string = methodDescriptor.substring(pos, end + 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            rawParameterTypes.add(string);
            pos = end + 1;
        }
        return rawParameterTypes;
    }
}

