/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.resolution;

import com.jetbrains.pluginverifier.results.access.AccessType;
import com.jetbrains.pluginverifier.results.hierarchy.ClassHierarchy;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.problems.IllegalMethodAccessProblem;
import com.jetbrains.pluginverifier.results.problems.MethodNotFoundProblem;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.hierarchy.ClassHierarchyBuilder;
import com.jetbrains.pluginverifier.verifiers.resolution.AccessibilityUtilKt;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodResolutionResult;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodResolveImpl;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002JD\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J0\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J0\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/resolution/MethodResolver;", "", "()V", "checkMethodIsAccessible", "", "resolvedMethod", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "methodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "callerMethod", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "lookupSpecialMethod", "Lkotlin/Pair;", "", "ownerClass", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "callerLocation", "registerMethodNotFoundProblem", "resolveMethod", "verifier-core"})
public final class MethodResolver {
    @Nullable
    public final Method resolveMethod(@NotNull ClassFile ownerClass, @NotNull MethodReference methodReference, @NotNull Instruction instruction, @NotNull Method callerMethod, @NotNull VerificationContext context) {
        Method method;
        Intrinsics.checkNotNullParameter(ownerClass, "ownerClass");
        Intrinsics.checkNotNullParameter(methodReference, "methodReference");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
        Intrinsics.checkNotNullParameter(context, "context");
        MethodResolutionResult resolutionResult = new MethodResolveImpl(methodReference, instruction, callerMethod, context).resolveMethod(ownerClass);
        if (Intrinsics.areEqual(resolutionResult, MethodResolutionResult.Abort.INSTANCE)) {
            method = null;
        } else if (resolutionResult instanceof MethodResolutionResult.NotFound) {
            this.registerMethodNotFoundProblem(ownerClass, context, methodReference, instruction, callerMethod);
            method = null;
        } else if (resolutionResult instanceof MethodResolutionResult.Found) {
            this.checkMethodIsAccessible(((MethodResolutionResult.Found)resolutionResult).getMethod(), context, methodReference, callerMethod, instruction);
            method = ((MethodResolutionResult.Found)resolutionResult).getMethod();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return method;
    }

    @Nullable
    public final Pair<Integer, Method> lookupSpecialMethod(@NotNull ClassFile ownerClass, @NotNull MethodReference methodReference, @NotNull Instruction instruction, @NotNull Method callerLocation, @NotNull VerificationContext context, @NotNull Method resolvedMethod) {
        Intrinsics.checkNotNullParameter(ownerClass, "ownerClass");
        Intrinsics.checkNotNullParameter(methodReference, "methodReference");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        Intrinsics.checkNotNullParameter(callerLocation, "callerLocation");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(resolvedMethod, "resolvedMethod");
        return new MethodResolveImpl(methodReference, instruction, callerLocation, context).lookupSpecialMethod(ownerClass, resolvedMethod);
    }

    private final void registerMethodNotFoundProblem(ClassFile ownerClass, VerificationContext context, MethodReference methodReference, Instruction instruction, Method callerMethod) {
        ClassHierarchy methodOwnerHierarchy = new ClassHierarchyBuilder(context).buildClassHierarchy(ownerClass);
        context.getProblemRegistrar().registerProblem(new MethodNotFoundProblem(methodReference, callerMethod.getLocation(), instruction, methodOwnerHierarchy));
    }

    private final void checkMethodIsAccessible(Method resolvedMethod, VerificationContext context, MethodReference methodReference, Method callerMethod, Instruction instruction) {
        AccessType accessProblem = AccessibilityUtilKt.detectAccessProblem(resolvedMethod, callerMethod, context);
        if (accessProblem != null) {
            context.getProblemRegistrar().registerProblem(new IllegalMethodAccessProblem(methodReference, resolvedMethod.getLocation(), accessProblem, callerMethod.getLocation(), instruction));
        }
    }
}

