/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.inflector;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.atteo.evo.inflector.CategoryRule;
import org.atteo.evo.inflector.RegExpRule;
import org.atteo.evo.inflector.Rule;

public abstract class TwoFormInflector {
    private final List<Rule> rules = new ArrayList<Rule>();

    protected String getPlural(String word) {
        for (Rule rule : this.rules) {
            String result2 = rule.getPlural(word);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    protected void uncountable(String[] list) {
        this.rules.add(new CategoryRule(list, "", ""));
    }

    protected void irregular(String singular, String plural) {
        if (singular.charAt(0) == plural.charAt(0)) {
            this.rules.add(new RegExpRule("(?i)(" + singular.charAt(0) + ")" + singular.substring(1) + "$", "$1" + plural.substring(1)));
        } else {
            this.rules.add(new RegExpRule(Character.toUpperCase(singular.charAt(0)) + "(?i)" + singular.substring(1) + "$", Character.toUpperCase(plural.charAt(0)) + plural.substring(1)));
            this.rules.add(new RegExpRule(Character.toLowerCase(singular.charAt(0)) + "(?i)" + singular.substring(1) + "$", Character.toLowerCase(plural.charAt(0)) + plural.substring(1)));
        }
    }

    protected void irregular(String[][] list) {
        for (String[] pair : list) {
            this.irregular(pair[0], pair[1]);
        }
    }

    protected void rule(String singular, String plural) {
        this.rules.add(new RegExpRule(Pattern.compile(singular, 2), plural));
    }

    protected void rule(String[][] list) {
        for (String[] pair : list) {
            this.rules.add(new RegExpRule(Pattern.compile(pair[0], 2), pair[1]));
        }
    }

    protected void categoryRule(String[] list, String singular, String plural) {
        this.rules.add(new CategoryRule(list, singular, plural));
    }
}

