/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.css;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.css.Color;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\r\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005\u001a&\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u001e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005\u001a&\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u001e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b\u001a&\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b\u001a\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"withZeros", "", "hex", "Lkotlinx/css/Color;", "value", "", "rgb", "red", "green", "blue", "alpha", "", "hsl", "hue", "saturation", "lightness", "oklch", "l", "c", "h", "a", "blackAlpha", "whiteAlpha", "formatAlpha", "kotlin-css"})
public final class ColorKt {
    private static final String withZeros(String $this$withZeros) {
        return $this$withZeros + StringsKt.repeat((CharSequence)"0", (int)Math.max(0, 3 - $this$withZeros.length()));
    }

    @NotNull
    public static final Color hex(int value) {
        String string = Integer.toString(value, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new Color("#" + ColorKt.withZeros(string));
    }

    @NotNull
    public static final Color rgb(int red, int green, int blue) {
        return new Color("rgb(" + red + ", " + green + ", " + blue + ")");
    }

    @NotNull
    public static final Color rgb(int red, int green, int blue, double alpha) {
        return new Color("rgba(" + red + ", " + green + ", " + blue + ", " + ColorKt.formatAlpha(alpha) + ")");
    }

    @NotNull
    public static final Color hsl(int hue, int saturation, int lightness) {
        return new Color("hsl(" + hue + ", " + saturation + "%, " + lightness + "%)");
    }

    @NotNull
    public static final Color hsl(int hue, int saturation, int lightness, double alpha) {
        return new Color("hsla(" + hue + ", " + saturation + "%, " + lightness + "%, " + ColorKt.formatAlpha(alpha) + ")");
    }

    @NotNull
    public static final Color oklch(int l, double c, double h) {
        return new Color("oklch(" + l + " " + c + " " + h + ")");
    }

    @NotNull
    public static final Color oklch(int l, double c, double h, double a) {
        return new Color("oklch(" + l + " " + c + " " + h + " / " + a + ")");
    }

    @NotNull
    public static final Color blackAlpha(double alpha) {
        return Color.Companion.getBlack().withAlpha(alpha);
    }

    @NotNull
    public static final Color whiteAlpha(double alpha) {
        return Color.Companion.getWhite().withAlpha(alpha);
    }

    private static final String formatAlpha(double alpha) {
        String it = String.valueOf(alpha);
        boolean bl = false;
        return StringsKt.contains$default((CharSequence)it, (CharSequence)".", (boolean)false, (int)2, null) ? it : it + ".0";
    }
}

