/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.components.compilerPluginGeneratedDeclarationsProvider;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.compilerPluginGeneratedDeclarationsProvider.AbstractCompilerPluginGeneratedDeclarationsTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/components/compilerPluginGeneratedDeclarationsProvider/compilerPluginGeneratedDeclarations")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeNormalAnalysisSourceModuleCompilerPluginGeneratedDeclarationsTestGenerated extends AbstractCompilerPluginGeneratedDeclarationsTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.Source,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Ide
      )
    );
  }

  @Test
  public void testAllFilesPresentInCompilerPluginGeneratedDeclarations() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/compilerPluginGeneratedDeclarationsProvider/compilerPluginGeneratedDeclarations"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("fromOtherModule.kt")
  public void testFromOtherModule() {
    runTest("analysis/analysis-api/testData/components/compilerPluginGeneratedDeclarationsProvider/compilerPluginGeneratedDeclarations/fromOtherModule.kt");
  }

  @Test
  @TestMetadata("topLevelClass.kt")
  public void testTopLevelClass() {
    runTest("analysis/analysis-api/testData/components/compilerPluginGeneratedDeclarationsProvider/compilerPluginGeneratedDeclarations/topLevelClass.kt");
  }

  @Test
  @TestMetadata("topLevelFunction.kt")
  public void testTopLevelFunction() {
    runTest("analysis/analysis-api/testData/components/compilerPluginGeneratedDeclarationsProvider/compilerPluginGeneratedDeclarations/topLevelFunction.kt");
  }

  @Test
  @TestMetadata("topLevelFunction_nestedPackage.kt")
  public void testTopLevelFunction_nestedPackage() {
    runTest("analysis/analysis-api/testData/components/compilerPluginGeneratedDeclarationsProvider/compilerPluginGeneratedDeclarations/topLevelFunction_nestedPackage.kt");
  }

  @Test
  @TestMetadata("topLevelFunction_private.kt")
  public void testTopLevelFunction_private() {
    runTest("analysis/analysis-api/testData/components/compilerPluginGeneratedDeclarationsProvider/compilerPluginGeneratedDeclarations/topLevelFunction_private.kt");
  }

  @Test
  @TestMetadata("topLevelFunction_rootPackage.kt")
  public void testTopLevelFunction_rootPackage() {
    runTest("analysis/analysis-api/testData/components/compilerPluginGeneratedDeclarationsProvider/compilerPluginGeneratedDeclarations/topLevelFunction_rootPackage.kt");
  }
}
