/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.components.scopeProvider;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.scopeProvider.AbstractMemberScopeTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/components/scopeProvider/memberScope")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeNormalAnalysisSourceModuleMemberScopeTestGenerated extends AbstractMemberScopeTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.Source,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Ide
      )
    );
  }

  @Test
  public void testAllFilesPresentInMemberScope() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/scopeProvider/memberScope"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("class.kt")
  public void testClass() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/class.kt");
  }

  @Test
  @TestMetadata("dataClass.kt")
  public void testDataClass() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/dataClass.kt");
  }

  @Test
  @TestMetadata("enumClass.kt")
  public void testEnumClass() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/enumClass.kt");
  }

  @Test
  @TestMetadata("enumClassWithAbstractMembers.kt")
  public void testEnumClassWithAbstractMembers() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/enumClassWithAbstractMembers.kt");
  }

  @Test
  @TestMetadata("enumClassWithFinalMembers.kt")
  public void testEnumClassWithFinalMembers() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/enumClassWithFinalMembers.kt");
  }

  @Test
  @TestMetadata("enumEntryInitializer.kt")
  public void testEnumEntryInitializer() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/enumEntryInitializer.kt");
  }

  @Test
  @TestMetadata("enumEntryInitializerWithFinalEnumMember.kt")
  public void testEnumEntryInitializerWithFinalEnumMember() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/enumEntryInitializerWithFinalEnumMember.kt");
  }

  @Test
  @TestMetadata("enumEntryInitializerWithOverriddenMember.kt")
  public void testEnumEntryInitializerWithOverriddenMember() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/enumEntryInitializerWithOverriddenMember.kt");
  }

  @Test
  @TestMetadata("innerClass.kt")
  public void testInnerClass() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/innerClass.kt");
  }

  @Test
  @TestMetadata("Int.kt")
  public void testInt() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/Int.kt");
  }

  @Test
  @TestMetadata("javaClass.kt")
  public void testJavaClass() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/javaClass.kt");
  }

  @Test
  @TestMetadata("javaField.kt")
  public void testJavaField() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/javaField.kt");
  }

  @Test
  @TestMetadata("javaFieldClash.kt")
  public void testJavaFieldClash() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/javaFieldClash.kt");
  }

  @Test
  @TestMetadata("javaMethods.kt")
  public void testJavaMethods() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/javaMethods.kt");
  }

  @Test
  @TestMetadata("java.lang.String.kt")
  public void testJava_lang_String() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/java.lang.String.kt");
  }

  @Test
  @TestMetadata("kotlin.Function2.kt")
  public void testKotlin_Function2() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/kotlin.Function2.kt");
  }

  @Test
  @TestMetadata("MutableList.kt")
  public void testMutableList() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/MutableList.kt");
  }

  @Test
  @TestMetadata("substitutionOverride.kt")
  public void testSubstitutionOverride() {
    runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/substitutionOverride.kt");
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/scopeProvider/memberScope/withTestCompilerPluginEnabled")
  @TestDataPath("$PROJECT_ROOT")
  public class WithTestCompilerPluginEnabled {
    @Test
    public void testAllFilesPresentInWithTestCompilerPluginEnabled() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/scopeProvider/memberScope/withTestCompilerPluginEnabled"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @Test
    @TestMetadata("customSerlializable.kt")
    public void testCustomSerlializable() {
      runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/withTestCompilerPluginEnabled/customSerlializable.kt");
    }

    @Test
    @TestMetadata("generatedCompanionWithFoo.kt")
    public void testGeneratedCompanionWithFoo() {
      runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/withTestCompilerPluginEnabled/generatedCompanionWithFoo.kt");
    }

    @Test
    @TestMetadata("nestedClassAndMaterializeMember.kt")
    public void testNestedClassAndMaterializeMember() {
      runTest("analysis/analysis-api/testData/components/scopeProvider/memberScope/withTestCompilerPluginEnabled/nestedClassAndMaterializeMember.kt");
    }
  }
}
