/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.components.typeCreator;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.typeCreator.AbstractTypeParameterTypeTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/components/typeCreator/typeParameter")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeNormalAnalysisSourceModuleTypeParameterTypeTestGenerated extends AbstractTypeParameterTypeTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.Source,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Ide
      )
    );
  }

  @Test
  public void testAllFilesPresentInTypeParameter() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/typeCreator/typeParameter"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("javaByName.kt")
  public void testJavaByName() {
    runTest("analysis/analysis-api/testData/components/typeCreator/typeParameter/javaByName.kt");
  }

  @Test
  @TestMetadata("kotlinByName.kt")
  public void testKotlinByName() {
    runTest("analysis/analysis-api/testData/components/typeCreator/typeParameter/kotlinByName.kt");
  }

  @Test
  @TestMetadata("multipleBounds.kt")
  public void testMultipleBounds() {
    runTest("analysis/analysis-api/testData/components/typeCreator/typeParameter/multipleBounds.kt");
  }

  @Test
  @TestMetadata("regular.kt")
  public void testRegular() {
    runTest("analysis/analysis-api/testData/components/typeCreator/typeParameter/regular.kt");
  }

  @Test
  @TestMetadata("reified.kt")
  public void testReified() {
    runTest("analysis/analysis-api/testData/components/typeCreator/typeParameter/reified.kt");
  }
}
