/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.components.typeProvider;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.typeProvider.AbstractDefaultTypeTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/components/typeProvider/defaultType")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeDependentAnalysisScriptSourceModuleDefaultTypeTestGenerated extends AbstractDefaultTypeTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.ScriptSource,
        AnalysisSessionMode.Dependent,
        AnalysisApiMode.Ide
      )
    );
  }

  @Test
  public void testAllFilesPresentInDefaultType() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/typeProvider/defaultType"), Pattern.compile("^(.+)\\.kts$"), null, true);
  }

  @Test
  @TestMetadata("classScript.kts")
  public void testClassScript() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/classScript.kts");
  }

  @Test
  @TestMetadata("nestedClassScript.kts")
  public void testNestedClassScript() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/nestedClassScript.kts");
  }

  @Test
  @TestMetadata("nestedClassScriptWithParameters.kts")
  public void testNestedClassScriptWithParameters() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/nestedClassScriptWithParameters.kts");
  }

  @Test
  @TestMetadata("scriptAnonymousObject.kts")
  public void testScriptAnonymousObject() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/scriptAnonymousObject.kts");
  }

  @Test
  @TestMetadata("scriptLocalObject.kts")
  public void testScriptLocalObject() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/scriptLocalObject.kts");
  }
}
