/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.components.typeProvider;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.typeProvider.AbstractDefaultTypeTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/components/typeProvider/defaultType")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeDependentAnalysisSourceModuleDefaultTypeTestGenerated extends AbstractDefaultTypeTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.Source,
        AnalysisSessionMode.Dependent,
        AnalysisApiMode.Ide
      )
    );
  }

  @Test
  public void testAllFilesPresentInDefaultType() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/typeProvider/defaultType"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("anonymousObject.kt")
  public void testAnonymousObject() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/anonymousObject.kt");
  }

  @Test
  @TestMetadata("anonymousObjectWithBaseClass.kt")
  public void testAnonymousObjectWithBaseClass() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/anonymousObjectWithBaseClass.kt");
  }

  @Test
  @TestMetadata("innerClass.kt")
  public void testInnerClass() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/innerClass.kt");
  }

  @Test
  @TestMetadata("innerClassWithParameter.kt")
  public void testInnerClassWithParameter() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/innerClassWithParameter.kt");
  }

  @Test
  @TestMetadata("innerClassWithParameters.kt")
  public void testInnerClassWithParameters() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/innerClassWithParameters.kt");
  }

  @Test
  @TestMetadata("innerClassWithParameters2.kt")
  public void testInnerClassWithParameters2() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/innerClassWithParameters2.kt");
  }

  @Test
  @TestMetadata("innerLocalClass.kt")
  public void testInnerLocalClass() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/innerLocalClass.kt");
  }

  @Test
  @TestMetadata("innerLocalClassParameter.kt")
  public void testInnerLocalClassParameter() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/innerLocalClassParameter.kt");
  }

  @Test
  @TestMetadata("localAnonymousObject.kt")
  public void testLocalAnonymousObject() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/localAnonymousObject.kt");
  }

  @Test
  @TestMetadata("localClass.kt")
  public void testLocalClass() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/localClass.kt");
  }

  @Test
  @TestMetadata("nestedClass.kt")
  public void testNestedClass() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/nestedClass.kt");
  }

  @Test
  @TestMetadata("nestedClassWithParameter.kt")
  public void testNestedClassWithParameter() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/nestedClassWithParameter.kt");
  }

  @Test
  @TestMetadata("nestedClassWithParameters.kt")
  public void testNestedClassWithParameters() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/nestedClassWithParameters.kt");
  }

  @Test
  @TestMetadata("nestedObject.kt")
  public void testNestedObject() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/nestedObject.kt");
  }

  @Test
  @TestMetadata("nestedObjectInsideClassWithParameter.kt")
  public void testNestedObjectInsideClassWithParameter() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/nestedObjectInsideClassWithParameter.kt");
  }

  @Test
  @TestMetadata("topLevelClass.kt")
  public void testTopLevelClass() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/topLevelClass.kt");
  }

  @Test
  @TestMetadata("topLevelObject.kt")
  public void testTopLevelObject() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/topLevelObject.kt");
  }

  @Test
  @TestMetadata("typeAlias.kt")
  public void testTypeAlias() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/typeAlias.kt");
  }

  @Test
  @TestMetadata("typeAliasTypeParameter.kt")
  public void testTypeAliasTypeParameter() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/typeAliasTypeParameter.kt");
  }

  @Test
  @TestMetadata("typeAliasTypeParameterWithBound.kt")
  public void testTypeAliasTypeParameterWithBound() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/typeAliasTypeParameterWithBound.kt");
  }

  @Test
  @TestMetadata("typeAliasWithParameters.kt")
  public void testTypeAliasWithParameters() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/typeAliasWithParameters.kt");
  }

  @Test
  @TestMetadata("withSuperTypeTopLevelObject.kt")
  public void testWithSuperTypeTopLevelObject() {
    runTest("analysis/analysis-api/testData/components/typeProvider/defaultType/withSuperTypeTopLevelObject.kt");
  }
}
