/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.imports;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.fir.test.cases.imports.AbstractKaDefaultImportsProviderTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/imports/defaultImportProvider")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeNormalAnalysisSourceModuleKaDefaultImportsProviderTestGenerated extends AbstractKaDefaultImportsProviderTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.Source,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Ide
      )
    );
  }

  @Test
  public void testAllFilesPresentInDefaultImportProvider() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/imports/defaultImportProvider"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("common.kt")
  public void testCommon() {
    runTest("analysis/analysis-api/testData/imports/defaultImportProvider/common.kt");
  }

  @Test
  @TestMetadata("js.kt")
  public void testJs() {
    runTest("analysis/analysis-api/testData/imports/defaultImportProvider/js.kt");
  }

  @Test
  @TestMetadata("jvm.kt")
  public void testJvm() {
    runTest("analysis/analysis-api/testData/imports/defaultImportProvider/jvm.kt");
  }

  @Test
  @TestMetadata("native.kt")
  public void testNative() {
    runTest("analysis/analysis-api/testData/imports/defaultImportProvider/native.kt");
  }

  @Test
  @TestMetadata("wasmJs.kt")
  public void testWasmJs() {
    runTest("analysis/analysis-api/testData/imports/defaultImportProvider/wasmJs.kt");
  }

  @Test
  @TestMetadata("wasmWasi.kt")
  public void testWasmWasi() {
    runTest("analysis/analysis-api/testData/imports/defaultImportProvider/wasmWasi.kt");
  }
}
