/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.references;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.references.AbstractReferenceShortenerTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeNormalAnalysisScriptSourceModuleReferenceShortenerTestGenerated extends AbstractReferenceShortenerTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.ScriptSource,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Ide
      )
    );
  }

  @Test
  public void testAllFilesPresentInShortenRange() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange"), Pattern.compile("^(.+)\\.kts$"), null, true);
  }

  @Test
  @TestMetadata("callInsideScriptExpression.kts")
  public void testCallInsideScriptExpression() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/callInsideScriptExpression.kts");
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts")
  @TestDataPath("$PROJECT_ROOT")
  public class Conflicts {
    @Test
    public void testAllFilesPresentInConflicts() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts"), Pattern.compile("^(.+)\\.kts$"), null, true);
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName")
    @TestDataPath("$PROJECT_ROOT")
    public class ClassWithSameName {
      @Test
      public void testAllFilesPresentInClassWithSameName() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName"), Pattern.compile("^(.+)\\.kts$"), null, true);
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses")
  @TestDataPath("$PROJECT_ROOT")
  public class NestedClasses {
    @Test
    public void testAllFilesPresentInNestedClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses"), Pattern.compile("^(.+)\\.kts$"), null, true);
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions")
    @TestDataPath("$PROJECT_ROOT")
    public class ClassHeaderPositions {
      @Test
      public void testAllFilesPresentInClassHeaderPositions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions"), Pattern.compile("^(.+)\\.kts$"), null, true);
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference")
  @TestDataPath("$PROJECT_ROOT")
  public class ThisReference {
    @Test
    public void testAllFilesPresentInThisReference() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference"), Pattern.compile("^(.+)\\.kts$"), null, true);
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel")
    @TestDataPath("$PROJECT_ROOT")
    public class WithLabel {
      @Test
      public void testAllFilesPresentInWithLabel() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel"), Pattern.compile("^(.+)\\.kts$"), null, true);
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/typeParameters")
  @TestDataPath("$PROJECT_ROOT")
  public class TypeParameters {
    @Test
    public void testAllFilesPresentInTypeParameters() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/typeParameters"), Pattern.compile("^(.+)\\.kts$"), null, true);
    }
  }
}
