/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.standalone.fir.test.cases.generated.cases.components.inheritorsProvider;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.fir.test.configurators.AnalysisApiFirStandaloneModeTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.inheritorsProvider.AbstractSealedInheritorsTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors")
@TestDataPath("$PROJECT_ROOT")
public class FirStandaloneNormalAnalysisSourceModuleSealedInheritorsTestGenerated extends AbstractSealedInheritorsTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirStandaloneModeTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.Source,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Standalone
      )
    );
  }

  @Test
  public void testAllFilesPresentInSealedInheritors() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("sealedClassFromDependency.kt")
  public void testSealedClassFromDependency() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedClassFromDependency.kt");
  }

  @Test
  @TestMetadata("sealedClassFromLibrary.kt")
  public void testSealedClassFromLibrary() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedClassFromLibrary.kt");
  }

  @Test
  @TestMetadata("sealedClassSameModule.kt")
  public void testSealedClassSameModule() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedClassSameModule.kt");
  }

  @Test
  @TestMetadata("sealedClassTypeAliasedFromDependency.kt")
  public void testSealedClassTypeAliasedFromDependency() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedClassTypeAliasedFromDependency.kt");
  }

  @Test
  @TestMetadata("sealedClassTypeAliasedFromLibrary.kt")
  public void testSealedClassTypeAliasedFromLibrary() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedClassTypeAliasedFromLibrary.kt");
  }

  @Test
  @TestMetadata("sealedClassTypeAliasedSameModule.kt")
  public void testSealedClassTypeAliasedSameModule() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedClassTypeAliasedSameModule.kt");
  }

  @Test
  @TestMetadata("sealedInheritorWrongPackageFromDependency.kt")
  public void testSealedInheritorWrongPackageFromDependency() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedInheritorWrongPackageFromDependency.kt");
  }

  @Test
  @TestMetadata("sealedInheritorWrongPackageSameModule.kt")
  public void testSealedInheritorWrongPackageSameModule() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedInheritorWrongPackageSameModule.kt");
  }

  @Test
  @TestMetadata("sealedInterfaceFromDependency.kt")
  public void testSealedInterfaceFromDependency() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedInterfaceFromDependency.kt");
  }

  @Test
  @TestMetadata("sealedInterfaceFromLibrary.kt")
  public void testSealedInterfaceFromLibrary() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedInterfaceFromLibrary.kt");
  }

  @Test
  @TestMetadata("sealedInterfaceSameModule.kt")
  public void testSealedInterfaceSameModule() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedInterfaceSameModule.kt");
  }

  @Test
  @TestMetadata("sealedInterfaceTypeAliasedFromDependency.kt")
  public void testSealedInterfaceTypeAliasedFromDependency() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedInterfaceTypeAliasedFromDependency.kt");
  }

  @Test
  @TestMetadata("sealedInterfaceTypeAliasedFromLibrary.kt")
  public void testSealedInterfaceTypeAliasedFromLibrary() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedInterfaceTypeAliasedFromLibrary.kt");
  }

  @Test
  @TestMetadata("sealedInterfaceTypeAliasedSameModule.kt")
  public void testSealedInterfaceTypeAliasedSameModule() {
    runTest("analysis/analysis-api/testData/components/inheritorsProvider/sealedInheritors/sealedInterfaceTypeAliasedSameModule.kt");
  }
}
