/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.standalone.fir.test.cases.generated.cases.references;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.fir.test.configurators.AnalysisApiFirStandaloneModeTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.references.AbstractReferenceShortenerTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange")
@TestDataPath("$PROJECT_ROOT")
public class FirStandaloneNormalAnalysisSourceModuleReferenceShortenerTestGenerated extends AbstractReferenceShortenerTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirStandaloneModeTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.Source,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Standalone
      )
    );
  }

  @Test
  public void testAllFilesPresentInShortenRange() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("annotaiton.kt")
  public void testAnnotaiton() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/annotaiton.kt");
  }

  @Test
  @TestMetadata("anonymousFunction_annotation.kt")
  public void testAnonymousFunction_annotation() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/anonymousFunction_annotation.kt");
  }

  @Test
  @TestMetadata("anonymousFunction_receiverType.kt")
  public void testAnonymousFunction_receiverType() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/anonymousFunction_receiverType.kt");
  }

  @Test
  @TestMetadata("anonymousFunction_returnType.kt")
  public void testAnonymousFunction_returnType() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/anonymousFunction_returnType.kt");
  }

  @Test
  @TestMetadata("callableFromDefaultImport.kt")
  public void testCallableFromDefaultImport() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/callableFromDefaultImport.kt");
  }

  @Test
  @TestMetadata("callableFromDefaultImport2.kt")
  public void testCallableFromDefaultImport2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/callableFromDefaultImport2.kt");
  }

  @Test
  @TestMetadata("callableFromExplicitImport.kt")
  public void testCallableFromExplicitImport() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/callableFromExplicitImport.kt");
  }

  @Test
  @TestMetadata("classScopes.kt")
  public void testClassScopes() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classScopes.kt");
  }

  @Test
  @TestMetadata("classScopes2.kt")
  public void testClassScopes2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classScopes2.kt");
  }

  @Test
  @TestMetadata("classScopes3.kt")
  public void testClassScopes3() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classScopes3.kt");
  }

  @Test
  @TestMetadata("classType.kt")
  public void testClassType() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classType.kt");
  }

  @Test
  @TestMetadata("classType2.kt")
  public void testClassType2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classType2.kt");
  }

  @Test
  @TestMetadata("classWithWrongNumberOfTypeArguments.kt")
  public void testClassWithWrongNumberOfTypeArguments() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classWithWrongNumberOfTypeArguments.kt");
  }

  @Test
  @TestMetadata("classesWithSameName.kt")
  public void testClassesWithSameName() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classesWithSameName.kt");
  }

  @Test
  @TestMetadata("classesWithSameName10.kt")
  public void testClassesWithSameName10() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classesWithSameName10.kt");
  }

  @Test
  @TestMetadata("classesWithSameName11.kt")
  public void testClassesWithSameName11() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classesWithSameName11.kt");
  }

  @Test
  @TestMetadata("classesWithSameName2.kt")
  public void testClassesWithSameName2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classesWithSameName2.kt");
  }

  @Test
  @TestMetadata("classesWithSameName3.kt")
  public void testClassesWithSameName3() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classesWithSameName3.kt");
  }

  @Test
  @TestMetadata("classesWithSameName4.kt")
  public void testClassesWithSameName4() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classesWithSameName4.kt");
  }

  @Test
  @TestMetadata("classesWithSameName5.kt")
  public void testClassesWithSameName5() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classesWithSameName5.kt");
  }

  @Test
  @TestMetadata("classesWithSameName6.kt")
  public void testClassesWithSameName6() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classesWithSameName6.kt");
  }

  @Test
  @TestMetadata("classesWithSameName7.kt")
  public void testClassesWithSameName7() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classesWithSameName7.kt");
  }

  @Test
  @TestMetadata("classesWithSameName8.kt")
  public void testClassesWithSameName8() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classesWithSameName8.kt");
  }

  @Test
  @TestMetadata("classesWithSameName9.kt")
  public void testClassesWithSameName9() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/classesWithSameName9.kt");
  }

  @Test
  @TestMetadata("companionClassLiteral.kt")
  public void testCompanionClassLiteral() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/companionClassLiteral.kt");
  }

  @Test
  @TestMetadata("companionClassLiteral2.kt")
  public void testCompanionClassLiteral2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/companionClassLiteral2.kt");
  }

  @Test
  @TestMetadata("companionClassLiteral3.kt")
  public void testCompanionClassLiteral3() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/companionClassLiteral3.kt");
  }

  @Test
  @TestMetadata("companionQualifier.kt")
  public void testCompanionQualifier() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/companionQualifier.kt");
  }

  @Test
  @TestMetadata("companionUsedOutOfClass.kt")
  public void testCompanionUsedOutOfClass() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/companionUsedOutOfClass.kt");
  }

  @Test
  @TestMetadata("constructorParameter.kt")
  public void testConstructorParameter() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/constructorParameter.kt");
  }

  @Test
  @TestMetadata("contextReceiver.kt")
  public void testContextReceiver() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/contextReceiver.kt");
  }

  @Test
  @TestMetadata("enumClassCompanionAlreadyImported.kt")
  public void testEnumClassCompanionAlreadyImported() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/enumClassCompanionAlreadyImported.kt");
  }

  @Test
  @TestMetadata("enumEntryInitUsesCompanion.kt")
  public void testEnumEntryInitUsesCompanion() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/enumEntryInitUsesCompanion.kt");
  }

  @Test
  @TestMetadata("enumEntryInitUsesCompanion2.kt")
  public void testEnumEntryInitUsesCompanion2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/enumEntryInitUsesCompanion2.kt");
  }

  @Test
  @TestMetadata("extensionFromObject.kt")
  public void testExtensionFromObject() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/extensionFromObject.kt");
  }

  @Test
  @TestMetadata("extensionFunction_objectReceiverWithOtherThisInScope.kt")
  public void testExtensionFunction_objectReceiverWithOtherThisInScope() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/extensionFunction_objectReceiverWithOtherThisInScope.kt");
  }

  @Test
  @TestMetadata("extensionProperty_objectReceiverWithOtherThisInScope.kt")
  public void testExtensionProperty_objectReceiverWithOtherThisInScope() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/extensionProperty_objectReceiverWithOtherThisInScope.kt");
  }

  @Test
  @TestMetadata("functionalType_parameterPosition.kt")
  public void testFunctionalType_parameterPosition() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/functionalType_parameterPosition.kt");
  }

  @Test
  @TestMetadata("importAliasAndStarImport.kt")
  public void testImportAliasAndStarImport() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/importAliasAndStarImport.kt");
  }

  @Test
  @TestMetadata("importAliasForFunction.kt")
  public void testImportAliasForFunction() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/importAliasForFunction.kt");
  }

  @Test
  @TestMetadata("importAliasForProperty.kt")
  public void testImportAliasForProperty() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/importAliasForProperty.kt");
  }

  @Test
  @TestMetadata("importAliasForType.kt")
  public void testImportAliasForType() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/importAliasForType.kt");
  }

  @Test
  @TestMetadata("importAliasForTypeQualifier.kt")
  public void testImportAliasForTypeQualifier() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/importAliasForTypeQualifier.kt");
  }

  @Test
  @TestMetadata("incompleteCodeTypeArgument.kt")
  public void testIncompleteCodeTypeArgument() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/incompleteCodeTypeArgument.kt");
  }

  @Test
  @TestMetadata("kdoc.kt")
  public void testKdoc() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/kdoc.kt");
  }

  @Test
  @TestMetadata("kdocQualifierSelected.kt")
  public void testKdocQualifierSelected() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/kdocQualifierSelected.kt");
  }

  @Test
  @TestMetadata("kdocQualifierSelected_rootIdePrefix.kt")
  public void testKdocQualifierSelected_rootIdePrefix() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/kdocQualifierSelected_rootIdePrefix.kt");
  }

  @Test
  @TestMetadata("kdocUnresolved.kt")
  public void testKdocUnresolved() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/kdocUnresolved.kt");
  }

  @Test
  @TestMetadata("memberVsCompanionObjectMemberConflict.kt")
  public void testMemberVsCompanionObjectMemberConflict() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/memberVsCompanionObjectMemberConflict.kt");
  }

  @Test
  @TestMetadata("memberVsObjectMemberConflict_sameMember.kt")
  public void testMemberVsObjectMemberConflict_sameMember() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/memberVsObjectMemberConflict_sameMember.kt");
  }

  @Test
  @TestMetadata("multipleImport.kt")
  public void testMultipleImport() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/multipleImport.kt");
  }

  @Test
  @TestMetadata("multipleImportAlias.kt")
  public void testMultipleImportAlias() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/multipleImportAlias.kt");
  }

  @Test
  @TestMetadata("multipleImportAlias2.kt")
  public void testMultipleImportAlias2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/multipleImportAlias2.kt");
  }

  @Test
  @TestMetadata("nestedClass.kt")
  public void testNestedClass() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClass.kt");
  }

  @Test
  @TestMetadata("nestedClass2.kt")
  public void testNestedClass2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClass2.kt");
  }

  @Test
  @TestMetadata("nestedClass3.kt")
  public void testNestedClass3() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClass3.kt");
  }

  @Test
  @TestMetadata("objectWithInvokeOperator.kt")
  public void testObjectWithInvokeOperator() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/objectWithInvokeOperator.kt");
  }

  @Test
  @TestMetadata("parameterTypeTopLevelTypeLoses.kt")
  public void testParameterTypeTopLevelTypeLoses() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/parameterTypeTopLevelTypeLoses.kt");
  }

  @Test
  @TestMetadata("partiallySelectedQualifiedCall1.kt")
  public void testPartiallySelectedQualifiedCall1() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/partiallySelectedQualifiedCall1.kt");
  }

  @Test
  @TestMetadata("partiallySelectedQualifiedCall2.kt")
  public void testPartiallySelectedQualifiedCall2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/partiallySelectedQualifiedCall2.kt");
  }

  @Test
  @TestMetadata("partiallySelectedQualifiedCall3.kt")
  public void testPartiallySelectedQualifiedCall3() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/partiallySelectedQualifiedCall3.kt");
  }

  @Test
  @TestMetadata("partiallySelectedQualifiedCall4.kt")
  public void testPartiallySelectedQualifiedCall4() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/partiallySelectedQualifiedCall4.kt");
  }

  @Test
  @TestMetadata("partiallySelectedType1.kt")
  public void testPartiallySelectedType1() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/partiallySelectedType1.kt");
  }

  @Test
  @TestMetadata("partiallySelectedType2.kt")
  public void testPartiallySelectedType2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/partiallySelectedType2.kt");
  }

  @Test
  @TestMetadata("partiallySelectedType3.kt")
  public void testPartiallySelectedType3() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/partiallySelectedType3.kt");
  }

  @Test
  @TestMetadata("partiallySelectedType4.kt")
  public void testPartiallySelectedType4() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/partiallySelectedType4.kt");
  }

  @Test
  @TestMetadata("partiallySelectedTypeQualifier1.kt")
  public void testPartiallySelectedTypeQualifier1() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/partiallySelectedTypeQualifier1.kt");
  }

  @Test
  @TestMetadata("partiallySelectedTypeQualifier2.kt")
  public void testPartiallySelectedTypeQualifier2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/partiallySelectedTypeQualifier2.kt");
  }

  @Test
  @TestMetadata("partiallySelectedTypeQualifier3.kt")
  public void testPartiallySelectedTypeQualifier3() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/partiallySelectedTypeQualifier3.kt");
  }

  @Test
  @TestMetadata("partiallySelectedTypeQualifier4.kt")
  public void testPartiallySelectedTypeQualifier4() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/partiallySelectedTypeQualifier4.kt");
  }

  @Test
  @TestMetadata("qualifierOfUnresolvedReference.kt")
  public void testQualifierOfUnresolvedReference() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/qualifierOfUnresolvedReference.kt");
  }

  @Test
  @TestMetadata("receiver.kt")
  public void testReceiver() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/receiver.kt");
  }

  @Test
  @TestMetadata("receiver2.kt")
  public void testReceiver2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/receiver2.kt");
  }

  @Test
  @TestMetadata("receiver3.kt")
  public void testReceiver3() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/receiver3.kt");
  }

  @Test
  @TestMetadata("receiver4.kt")
  public void testReceiver4() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/receiver4.kt");
  }

  @Test
  @TestMetadata("referenceInNestedClass.kt")
  public void testReferenceInNestedClass() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/referenceInNestedClass.kt");
  }

  @Test
  @TestMetadata("samConstructorWithTypeAliasNameClash.kt")
  public void testSamConstructorWithTypeAliasNameClash() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/samConstructorWithTypeAliasNameClash.kt");
  }

  @Test
  @TestMetadata("samInterface_constructorCall.kt")
  public void testSamInterface_constructorCall() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/samInterface_constructorCall.kt");
  }

  @Test
  @TestMetadata("samInterface_constructorCall_java.kt")
  public void testSamInterface_constructorCall_java() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/samInterface_constructorCall_java.kt");
  }

  @Test
  @TestMetadata("sameNameDifferentParams.kt")
  public void testSameNameDifferentParams() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/sameNameDifferentParams.kt");
  }

  @Test
  @TestMetadata("sameNameDifferentReceiver.kt")
  public void testSameNameDifferentReceiver() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/sameNameDifferentReceiver.kt");
  }

  @Test
  @TestMetadata("sameTypeNamesWithinSameScopes.kt")
  public void testSameTypeNamesWithinSameScopes() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/sameTypeNamesWithinSameScopes.kt");
  }

  @Test
  @TestMetadata("selfPropertyChain.kt")
  public void testSelfPropertyChain() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/selfPropertyChain.kt");
  }

  @Test
  @TestMetadata("selfPropertyChain1.kt")
  public void testSelfPropertyChain1() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/selfPropertyChain1.kt");
  }

  @Test
  @TestMetadata("shortenAlreadyImportedClass.kt")
  public void testShortenAlreadyImportedClass() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/shortenAlreadyImportedClass.kt");
  }

  @Test
  @TestMetadata("shortenAlreadyImportedClass2.kt")
  public void testShortenAlreadyImportedClass2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/shortenAlreadyImportedClass2.kt");
  }

  @Test
  @TestMetadata("shortenAlreadyImportedFunction.kt")
  public void testShortenAlreadyImportedFunction() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/shortenAlreadyImportedFunction.kt");
  }

  @Test
  @TestMetadata("shortenAlreadyImportedFunction2.kt")
  public void testShortenAlreadyImportedFunction2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/shortenAlreadyImportedFunction2.kt");
  }

  @Test
  @TestMetadata("shortenAlreadyImportedFunction3.kt")
  public void testShortenAlreadyImportedFunction3() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/shortenAlreadyImportedFunction3.kt");
  }

  @Test
  @TestMetadata("shortenAlreadyImportedFunction4.kt")
  public void testShortenAlreadyImportedFunction4() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/shortenAlreadyImportedFunction4.kt");
  }

  @Test
  @TestMetadata("starImport.kt")
  public void testStarImport() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/starImport.kt");
  }

  @Test
  @TestMetadata("staticMethodFromBaseClassConflict.kt")
  public void testStaticMethodFromBaseClassConflict() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/staticMethodFromBaseClassConflict.kt");
  }

  @Test
  @TestMetadata("staticMethodFromBaseClassConflict2.kt")
  public void testStaticMethodFromBaseClassConflict2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/staticMethodFromBaseClassConflict2.kt");
  }

  @Test
  @TestMetadata("superClass.kt")
  public void testSuperClass() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/superClass.kt");
  }

  @Test
  @TestMetadata("superEntry.kt")
  public void testSuperEntry() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/superEntry.kt");
  }

  @Test
  @TestMetadata("typeArgument.kt")
  public void testTypeArgument() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/typeArgument.kt");
  }

  @Test
  @TestMetadata("typeParams.kt")
  public void testTypeParams() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/typeParams.kt");
  }

  @Test
  @TestMetadata("typeParams2.kt")
  public void testTypeParams2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/typeParams2.kt");
  }

  @Test
  @TestMetadata("vararg.kt")
  public void testVararg() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/vararg.kt");
  }

  @Test
  @TestMetadata("variable.kt")
  public void testVariable() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/variable.kt");
  }

  @Test
  @TestMetadata("variable2.kt")
  public void testVariable2() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/variable2.kt");
  }

  @Test
  @TestMetadata("variableAssignment.kt")
  public void testVariableAssignment() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/variableAssignment.kt");
  }

  @Test
  @TestMetadata("variableAssignment_plusAssignOperator.kt")
  public void testVariableAssignment_plusAssignOperator() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/variableAssignment_plusAssignOperator.kt");
  }

  @Test
  @TestMetadata("variableAssignment_plusOperator.kt")
  public void testVariableAssignment_plusOperator() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/variableAssignment_plusOperator.kt");
  }

  @Test
  @TestMetadata("variable_invokeOperator.kt")
  public void testVariable_invokeOperator() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/variable_invokeOperator.kt");
  }

  @Test
  @TestMetadata("_rootIdePackage_IsNotRemovedIfNotSelected.kt")
  public void test_rootIdePackage_IsNotRemovedIfNotSelected() {
    runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/_rootIdePackage_IsNotRemovedIfNotSelected.kt");
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts")
  @TestDataPath("$PROJECT_ROOT")
  public class Conflicts {
    @Test
    public void testAllFilesPresentInConflicts() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName")
    @TestDataPath("$PROJECT_ROOT")
    public class ClassWithSameName {
      @Test
      public void testAllFilesPresentInClassWithSameName() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName"), Pattern.compile("^(.+)\\.kt$"), null, true);
      }

      @Test
      @TestMetadata("constructorCall_vs_constructorCall.kt")
      public void testConstructorCall_vs_constructorCall() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName/constructorCall_vs_constructorCall.kt");
      }

      @Test
      @TestMetadata("constructorCall_vs_noUsages.kt")
      public void testConstructorCall_vs_noUsages() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName/constructorCall_vs_noUsages.kt");
      }

      @Test
      @TestMetadata("constructorCall_vs_typeRefs.kt")
      public void testConstructorCall_vs_typeRefs() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName/constructorCall_vs_typeRefs.kt");
      }

      @Test
      @TestMetadata("qualifier_vs_constructorCall.kt")
      public void testQualifier_vs_constructorCall() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName/qualifier_vs_constructorCall.kt");
      }

      @Test
      @TestMetadata("qualifier_vs_noUsages.kt")
      public void testQualifier_vs_noUsages() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName/qualifier_vs_noUsages.kt");
      }

      @Test
      @TestMetadata("qualifier_vs_typeRef.kt")
      public void testQualifier_vs_typeRef() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName/qualifier_vs_typeRef.kt");
      }

      @Test
      @TestMetadata("typeRef_vs_constructorCall.kt")
      public void testTypeRef_vs_constructorCall() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName/typeRef_vs_constructorCall.kt");
      }

      @Test
      @TestMetadata("typeRef_vs_noUsages.kt")
      public void testTypeRef_vs_noUsages() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName/typeRef_vs_noUsages.kt");
      }

      @Test
      @TestMetadata("typeRef_vs_typeRef.kt")
      public void testTypeRef_vs_typeRef() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/conflicts/classWithSameName/typeRef_vs_typeRef.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses")
  @TestDataPath("$PROJECT_ROOT")
  public class NestedClasses {
    @Test
    public void testAllFilesPresentInNestedClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @Test
    @TestMetadata("classAndObjectHaveConflictingNestedClasses_inside.kt")
    public void testClassAndObjectHaveConflictingNestedClasses_inside() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classAndObjectHaveConflictingNestedClasses_inside.kt");
    }

    @Test
    @TestMetadata("classAndObjectHaveConflictingNestedClasses_inside_companion.kt")
    public void testClassAndObjectHaveConflictingNestedClasses_inside_companion() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classAndObjectHaveConflictingNestedClasses_inside_companion.kt");
    }

    @Test
    @TestMetadata("classAndObjectHaveConflictingNestedClasses_inside_namedCompanion.kt")
    public void testClassAndObjectHaveConflictingNestedClasses_inside_namedCompanion() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classAndObjectHaveConflictingNestedClasses_inside_namedCompanion.kt");
    }

    @Test
    @TestMetadata("classAndObjectHaveConflictingNestedClasses_outside.kt")
    public void testClassAndObjectHaveConflictingNestedClasses_outside() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classAndObjectHaveConflictingNestedClasses_outside.kt");
    }

    @Test
    @TestMetadata("classAndObjectHaveConflictingNestedClasses_outside_companion.kt")
    public void testClassAndObjectHaveConflictingNestedClasses_outside_companion() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classAndObjectHaveConflictingNestedClasses_outside_companion.kt");
    }

    @Test
    @TestMetadata("classAndObjectHaveConflictingNestedClasses_outside_namedCompanion.kt")
    public void testClassAndObjectHaveConflictingNestedClasses_outside_namedCompanion() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classAndObjectHaveConflictingNestedClasses_outside_namedCompanion.kt");
    }

    @Test
    @TestMetadata("nestedClassFromSupertypes1.kt")
    public void testNestedClassFromSupertypes1() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/nestedClassFromSupertypes1.kt");
    }

    @Test
    @TestMetadata("nestedClassFromSupertypes1_java.kt")
    public void testNestedClassFromSupertypes1_java() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/nestedClassFromSupertypes1_java.kt");
    }

    @Test
    @TestMetadata("nestedClassFromSupertypes2.kt")
    public void testNestedClassFromSupertypes2() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/nestedClassFromSupertypes2.kt");
    }

    @Test
    @TestMetadata("nestedClassFromSupertypes2_java.kt")
    public void testNestedClassFromSupertypes2_java() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/nestedClassFromSupertypes2_java.kt");
    }

    @Test
    @TestMetadata("nestedClassFromSupertypes3.kt")
    public void testNestedClassFromSupertypes3() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/nestedClassFromSupertypes3.kt");
    }

    @Test
    @TestMetadata("nestedClassFromSupertypes3_java.kt")
    public void testNestedClassFromSupertypes3_java() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/nestedClassFromSupertypes3_java.kt");
    }

    @Test
    @TestMetadata("nestedClassFromSupertypes4.kt")
    public void testNestedClassFromSupertypes4() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/nestedClassFromSupertypes4.kt");
    }

    @Test
    @TestMetadata("nestedClassFromSupertypes5.kt")
    public void testNestedClassFromSupertypes5() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/nestedClassFromSupertypes5.kt");
    }

    @Test
    @TestMetadata("nestedClassFromSupertypes5_java.kt")
    public void testNestedClassFromSupertypes5_java() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/nestedClassFromSupertypes5_java.kt");
    }

    @Test
    @TestMetadata("nestedClassFromSupertypes6.kt")
    public void testNestedClassFromSupertypes6() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/nestedClassFromSupertypes6.kt");
    }

    @Test
    @TestMetadata("nestedClassFromSupertypes6_java.kt")
    public void testNestedClassFromSupertypes6_java() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/nestedClassFromSupertypes6_java.kt");
    }

    @Test
    @TestMetadata("nestedSamInterface_constructorCall.kt")
    public void testNestedSamInterface_constructorCall() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/nestedSamInterface_constructorCall.kt");
    }

    @Test
    @TestMetadata("TypeWithGenericsAsExtensionReceiverType_innerType.kt")
    public void testTypeWithGenericsAsExtensionReceiverType_innerType() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/TypeWithGenericsAsExtensionReceiverType_innerType.kt");
    }

    @Test
    @TestMetadata("TypeWithGenericsAsExtensionReceiverType_nestedType.kt")
    public void testTypeWithGenericsAsExtensionReceiverType_nestedType() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/TypeWithGenericsAsExtensionReceiverType_nestedType.kt");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions")
    @TestDataPath("$PROJECT_ROOT")
    public class ClassHeaderPositions {
      @Test
      public void testAllFilesPresentInClassHeaderPositions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions"), Pattern.compile("^(.+)\\.kt$"), null, true);
      }

      @Test
      @TestMetadata("annotationOnClass.kt")
      public void testAnnotationOnClass() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/annotationOnClass.kt");
      }

      @Test
      @TestMetadata("annotationOnClass_nested.kt")
      public void testAnnotationOnClass_nested() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/annotationOnClass_nested.kt");
      }

      @Test
      @TestMetadata("annotationOnConstructor.kt")
      public void testAnnotationOnConstructor() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/annotationOnConstructor.kt");
      }

      @Test
      @TestMetadata("annotationOnConstructor_nested.kt")
      public void testAnnotationOnConstructor_nested() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/annotationOnConstructor_nested.kt");
      }

      @Test
      @TestMetadata("annotationOnParameter.kt")
      public void testAnnotationOnParameter() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/annotationOnParameter.kt");
      }

      @Test
      @TestMetadata("annotationOnParameter_nested.kt")
      public void testAnnotationOnParameter_nested() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/annotationOnParameter_nested.kt");
      }

      @Test
      @TestMetadata("constructorParameterVsTopLevelProperty_conflict.kt")
      public void testConstructorParameterVsTopLevelProperty_conflict() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/constructorParameterVsTopLevelProperty_conflict.kt");
      }

      @Test
      @TestMetadata("constructorParameterVsTopLevelProperty_noConflict.kt")
      public void testConstructorParameterVsTopLevelProperty_noConflict() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/constructorParameterVsTopLevelProperty_noConflict.kt");
      }

      @Test
      @TestMetadata("contextReceiver.kt")
      public void testContextReceiver() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/contextReceiver.kt");
      }

      @Test
      @TestMetadata("contextReceiver_nested.kt")
      public void testContextReceiver_nested() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/contextReceiver_nested.kt");
      }

      @Test
      @TestMetadata("primaryConstructorParameter.kt")
      public void testPrimaryConstructorParameter() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/primaryConstructorParameter.kt");
      }

      @Test
      @TestMetadata("primaryConstructorParameter_nested.kt")
      public void testPrimaryConstructorParameter_nested() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/primaryConstructorParameter_nested.kt");
      }

      @Test
      @TestMetadata("superType.kt")
      public void testSuperType() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superType.kt");
      }

      @Test
      @TestMetadata("superTypeConstructor.kt")
      public void testSuperTypeConstructor() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superTypeConstructor.kt");
      }

      @Test
      @TestMetadata("superTypeConstructorArgument.kt")
      public void testSuperTypeConstructorArgument() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superTypeConstructorArgument.kt");
      }

      @Test
      @TestMetadata("superTypeConstructorArgument_nested.kt")
      public void testSuperTypeConstructorArgument_nested() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superTypeConstructorArgument_nested.kt");
      }

      @Test
      @TestMetadata("superTypeConstructorArgument_nested_objectLiteral.kt")
      public void testSuperTypeConstructorArgument_nested_objectLiteral() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superTypeConstructorArgument_nested_objectLiteral.kt");
      }

      @Test
      @TestMetadata("superTypeConstructorArgument_objectLiteral.kt")
      public void testSuperTypeConstructorArgument_objectLiteral() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superTypeConstructorArgument_objectLiteral.kt");
      }

      @Test
      @TestMetadata("superTypeConstructor_nested.kt")
      public void testSuperTypeConstructor_nested() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superTypeConstructor_nested.kt");
      }

      @Test
      @TestMetadata("superTypeConstructor_nested_objectLiteral.kt")
      public void testSuperTypeConstructor_nested_objectLiteral() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superTypeConstructor_nested_objectLiteral.kt");
      }

      @Test
      @TestMetadata("superTypeConstructor_objectLiteral.kt")
      public void testSuperTypeConstructor_objectLiteral() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superTypeConstructor_objectLiteral.kt");
      }

      @Test
      @TestMetadata("superTypeDelegation.kt")
      public void testSuperTypeDelegation() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superTypeDelegation.kt");
      }

      @Test
      @TestMetadata("superTypeDelegation_nested.kt")
      public void testSuperTypeDelegation_nested() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superTypeDelegation_nested.kt");
      }

      @Test
      @TestMetadata("superTypeTypeArguments.kt")
      public void testSuperTypeTypeArguments() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superTypeTypeArguments.kt");
      }

      @Test
      @TestMetadata("superTypeTypeArguments_nested.kt")
      public void testSuperTypeTypeArguments_nested() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superTypeTypeArguments_nested.kt");
      }

      @Test
      @TestMetadata("superType_nested.kt")
      public void testSuperType_nested() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/superType_nested.kt");
      }

      @Test
      @TestMetadata("typeBound.kt")
      public void testTypeBound() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/typeBound.kt");
      }

      @Test
      @TestMetadata("typeBound_nested.kt")
      public void testTypeBound_nested() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/typeBound_nested.kt");
      }

      @Test
      @TestMetadata("typeBound_whereClause.kt")
      public void testTypeBound_whereClause() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/nestedClasses/classHeaderPositions/typeBound_whereClause.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference")
  @TestDataPath("$PROJECT_ROOT")
  public class ThisReference {
    @Test
    public void testAllFilesPresentInThisReference() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @Test
    @TestMetadata("this_extensionFunction_fromExtensionFunction.kt")
    public void testThis_extensionFunction_fromExtensionFunction() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_extensionFunction_fromExtensionFunction.kt");
    }

    @Test
    @TestMetadata("this_extensionFunction_fromExtensionFunction_conflictWithLocal.kt")
    public void testThis_extensionFunction_fromExtensionFunction_conflictWithLocal() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_extensionFunction_fromExtensionFunction_conflictWithLocal.kt");
    }

    @Test
    @TestMetadata("this_memberFunction_fromMemberFunction.kt")
    public void testThis_memberFunction_fromMemberFunction() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_memberFunction_fromMemberFunction.kt");
    }

    @Test
    @TestMetadata("this_memberFunction_fromMemberFunction_conflictWithLocal.kt")
    public void testThis_memberFunction_fromMemberFunction_conflictWithLocal() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_memberFunction_fromMemberFunction_conflictWithLocal.kt");
    }

    @Test
    @TestMetadata("this_memberProperty_fromInit.kt")
    public void testThis_memberProperty_fromInit() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_memberProperty_fromInit.kt");
    }

    @Test
    @TestMetadata("this_memberProperty_fromInit_conflictWithParameter.kt")
    public void testThis_memberProperty_fromInit_conflictWithParameter() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_memberProperty_fromInit_conflictWithParameter.kt");
    }

    @Test
    @TestMetadata("this_memberProperty_fromMemberFunction.kt")
    public void testThis_memberProperty_fromMemberFunction() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_memberProperty_fromMemberFunction.kt");
    }

    @Test
    @TestMetadata("this_memberProperty_fromMemberFunctionWithContextReceiver.kt")
    public void testThis_memberProperty_fromMemberFunctionWithContextReceiver() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_memberProperty_fromMemberFunctionWithContextReceiver.kt");
    }

    @Test
    @TestMetadata("this_memberProperty_fromMemberFunction_conflictWithLocal.kt")
    public void testThis_memberProperty_fromMemberFunction_conflictWithLocal() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_memberProperty_fromMemberFunction_conflictWithLocal.kt");
    }

    @Test
    @TestMetadata("this_memberProperty_fromMemberFunction_conflictWithParameter.kt")
    public void testThis_memberProperty_fromMemberFunction_conflictWithParameter() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_memberProperty_fromMemberFunction_conflictWithParameter.kt");
    }

    @Test
    @TestMetadata("this_memberProperty_fromMemberFunction_noConflictWithLocal.kt")
    public void testThis_memberProperty_fromMemberFunction_noConflictWithLocal() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_memberProperty_fromMemberFunction_noConflictWithLocal.kt");
    }

    @Test
    @TestMetadata("this_nullableReceiver.kt")
    public void testThis_nullableReceiver() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_nullableReceiver.kt");
    }

    @Test
    @TestMetadata("this_safeCall.kt")
    public void testThis_safeCall() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/this_safeCall.kt");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel")
    @TestDataPath("$PROJECT_ROOT")
    public class WithLabel {
      @Test
      public void testAllFilesPresentInWithLabel() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel"), Pattern.compile("^(.+)\\.kt$"), null, true);
      }

      @Test
      @TestMetadata("extensionReceiver.kt")
      public void testExtensionReceiver() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel/extensionReceiver.kt");
      }

      @Test
      @TestMetadata("extensionReceiver_vs_lambdaReceiver.kt")
      public void testExtensionReceiver_vs_lambdaReceiver() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel/extensionReceiver_vs_lambdaReceiver.kt");
      }

      @Test
      @TestMetadata("extensionReceiver_vs_lambdaReceiver_conflict.kt")
      public void testExtensionReceiver_vs_lambdaReceiver_conflict() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel/extensionReceiver_vs_lambdaReceiver_conflict.kt");
      }

      @Test
      @TestMetadata("extensionReceiver_vs_local.kt")
      public void testExtensionReceiver_vs_local() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel/extensionReceiver_vs_local.kt");
      }

      @Test
      @TestMetadata("lambdaReceiver.kt")
      public void testLambdaReceiver() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel/lambdaReceiver.kt");
      }

      @Test
      @TestMetadata("lambdaReceiver_vs_lambdaReceiver.kt")
      public void testLambdaReceiver_vs_lambdaReceiver() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel/lambdaReceiver_vs_lambdaReceiver.kt");
      }

      @Test
      @TestMetadata("lambdaReceiver_vs_lambdaReceiver_conflict.kt")
      public void testLambdaReceiver_vs_lambdaReceiver_conflict() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel/lambdaReceiver_vs_lambdaReceiver_conflict.kt");
      }

      @Test
      @TestMetadata("regularClass.kt")
      public void testRegularClass() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel/regularClass.kt");
      }

      @Test
      @TestMetadata("regularClass_vs_extensionReceiver.kt")
      public void testRegularClass_vs_extensionReceiver() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel/regularClass_vs_extensionReceiver.kt");
      }

      @Test
      @TestMetadata("regularClass_vs_innerClass.kt")
      public void testRegularClass_vs_innerClass() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel/regularClass_vs_innerClass.kt");
      }

      @Test
      @TestMetadata("regularClass_vs_innerClass_conflict.kt")
      public void testRegularClass_vs_innerClass_conflict() {
        runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/thisReference/withLabel/regularClass_vs_innerClass_conflict.kt");
      }
    }
  }

  @Nested
  @TestMetadata("analysis/analysis-api/testData/components/referenceShortener/shortenRange/typeParameters")
  @TestDataPath("$PROJECT_ROOT")
  public class TypeParameters {
    @Test
    public void testAllFilesPresentInTypeParameters() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/referenceShortener/shortenRange/typeParameters"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @Test
    @TestMetadata("functionTypeParameterVsType.kt")
    public void testFunctionTypeParameterVsType() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/typeParameters/functionTypeParameterVsType.kt");
    }

    @Test
    @TestMetadata("typeParameterVsNestedType.kt")
    public void testTypeParameterVsNestedType() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/typeParameters/typeParameterVsNestedType.kt");
    }

    @Test
    @TestMetadata("typeParameterVsType_conflict.kt")
    public void testTypeParameterVsType_conflict() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/typeParameters/typeParameterVsType_conflict.kt");
    }

    @Test
    @TestMetadata("typeParameterVsType_noConflict.kt")
    public void testTypeParameterVsType_noConflict() {
      runTest("analysis/analysis-api/testData/components/referenceShortener/shortenRange/typeParameters/typeParameterVsType_noConflict.kt");
    }
  }
}
