/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.standalone.fir.test.cases.generated.cases.types;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.fir.test.configurators.AnalysisApiFirStandaloneModeTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.types.AbstractTypePointerConsistencyTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/types/typePointers/consistency")
@TestDataPath("$PROJECT_ROOT")
public class FirStandaloneNormalAnalysisSourceModuleTypePointerConsistencyTestGenerated extends AbstractTypePointerConsistencyTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirStandaloneModeTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.Source,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Standalone
      )
    );
  }

  @Test
  @TestMetadata("aliasedType.kt")
  public void testAliasedType() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/aliasedType.kt");
  }

  @Test
  public void testAllFilesPresentInConsistency() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/types/typePointers/consistency"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("annotatedType.kt")
  public void testAnnotatedType() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/annotatedType.kt");
  }

  @Test
  @TestMetadata("badArgumentCount.kt")
  public void testBadArgumentCount() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/badArgumentCount.kt");
  }

  @Test
  @TestMetadata("badArgumentCount2.kt")
  public void testBadArgumentCount2() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/badArgumentCount2.kt");
  }

  @Test
  @TestMetadata("badArgumentCount3.kt")
  public void testBadArgumentCount3() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/badArgumentCount3.kt");
  }

  @Test
  @TestMetadata("classType.kt")
  public void testClassType() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/classType.kt");
  }

  @Test
  @TestMetadata("dynamicType.kt")
  public void testDynamicType() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/dynamicType.kt");
  }

  @Test
  @TestMetadata("flexibleType.kt")
  public void testFlexibleType() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/flexibleType.kt");
  }

  @Test
  @TestMetadata("flexibleType2.kt")
  public void testFlexibleType2() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/flexibleType2.kt");
  }

  @Test
  @TestMetadata("functionType.kt")
  public void testFunctionType() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/functionType.kt");
  }

  @Test
  @TestMetadata("intersectionType.kt")
  public void testIntersectionType() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/intersectionType.kt");
  }

  @Test
  @TestMetadata("nullableClassType.kt")
  public void testNullableClassType() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/nullableClassType.kt");
  }

  @Test
  @TestMetadata("nullableType.kt")
  public void testNullableType() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/nullableType.kt");
  }

  @Test
  @TestMetadata("qualifierNotFound.kt")
  public void testQualifierNotFound() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/qualifierNotFound.kt");
  }

  @Test
  @TestMetadata("qualifierNotFound2.kt")
  public void testQualifierNotFound2() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/qualifierNotFound2.kt");
  }

  @Test
  @TestMetadata("symbolNotFound.kt")
  public void testSymbolNotFound() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/symbolNotFound.kt");
  }

  @Test
  @TestMetadata("typeParameterType.kt")
  public void testTypeParameterType() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/typeParameterType.kt");
  }

  @Test
  @TestMetadata("typeParameterType2.kt")
  public void testTypeParameterType2() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/typeParameterType2.kt");
  }

  @Test
  @TestMetadata("variance.kt")
  public void testVariance() {
    runTest("analysis/analysis-api/testData/types/typePointers/consistency/variance.kt");
  }
}
