/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/contextCollector")
@TestDataPath("$PROJECT_ROOT")
public class ContextCollectorSourceTestGenerated extends AbstractContextCollectorSourceTest {
  @Test
  public void testAllFilesPresentInContextCollector() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/contextCollector"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
  }

  @Test
  @TestMetadata("classFunction.kt")
  public void testClassFunction() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/classFunction.kt");
  }

  @Test
  @TestMetadata("classProperty.kt")
  public void testClassProperty() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/classProperty.kt");
  }

  @Test
  @TestMetadata("contextReceivers.kt")
  public void testContextReceivers() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/contextReceivers.kt");
  }

  @Test
  @TestMetadata("contextReceiversClass.kt")
  public void testContextReceiversClass() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/contextReceiversClass.kt");
  }

  @Test
  @TestMetadata("enumValueFunction.kt")
  public void testEnumValueFunction() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/enumValueFunction.kt");
  }

  @Test
  @TestMetadata("enumValuePropertyAccessor.kt")
  public void testEnumValuePropertyAccessor() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/enumValuePropertyAccessor.kt");
  }

  @Test
  @TestMetadata("extensionFunction.kt")
  public void testExtensionFunction() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/extensionFunction.kt");
  }

  @Test
  @TestMetadata("extensionLambdas.kt")
  public void testExtensionLambdas() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/extensionLambdas.kt");
  }

  @Test
  @TestMetadata("file.kt")
  public void testFile() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/file.kt");
  }

  @Test
  @TestMetadata("fileAnnotation.kt")
  public void testFileAnnotation() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/fileAnnotation.kt");
  }

  @Test
  @TestMetadata("fileImport.kt")
  public void testFileImport() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/fileImport.kt");
  }

  @Test
  @TestMetadata("fileImportInside.kt")
  public void testFileImportInside() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/fileImportInside.kt");
  }

  @Test
  @TestMetadata("filePackage.kt")
  public void testFilePackage() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/filePackage.kt");
  }

  @Test
  @TestMetadata("forLoopVariable.kt")
  public void testForLoopVariable() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/forLoopVariable.kt");
  }

  @Test
  @TestMetadata("innerClasses.kt")
  public void testInnerClasses() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/innerClasses.kt");
  }

  @Test
  @TestMetadata("KT-61728.kt")
  public void testKT_61728() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/KT-61728.kt");
  }

  @Test
  @TestMetadata("lambdaArguments.kt")
  public void testLambdaArguments() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/lambdaArguments.kt");
  }

  @Test
  @TestMetadata("localClass.kt")
  public void testLocalClass() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/localClass.kt");
  }

  @Test
  @TestMetadata("localClassFunction.kt")
  public void testLocalClassFunction() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/localClassFunction.kt");
  }

  @Test
  @TestMetadata("localFunction.kt")
  public void testLocalFunction() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/localFunction.kt");
  }

  @Test
  @TestMetadata("localFunctionExpression.kt")
  public void testLocalFunctionExpression() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/localFunctionExpression.kt");
  }

  @Test
  @TestMetadata("nestedClass.kt")
  public void testNestedClass() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/nestedClass.kt");
  }

  @Test
  @TestMetadata("nestedClassFunction.kt")
  public void testNestedClassFunction() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/nestedClassFunction.kt");
  }

  @Test
  @TestMetadata("parameter.kt")
  public void testParameter() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/parameter.kt");
  }

  @Test
  @TestMetadata("primaryConstructor.kt")
  public void testPrimaryConstructor() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/primaryConstructor.kt");
  }

  @Test
  @TestMetadata("primaryConstructorParameter.kt")
  public void testPrimaryConstructorParameter() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/primaryConstructorParameter.kt");
  }

  @Test
  @TestMetadata("primaryConstructorProperty.kt")
  public void testPrimaryConstructorProperty() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/primaryConstructorProperty.kt");
  }

  @Test
  @TestMetadata("propertyAccessor.kt")
  public void testPropertyAccessor() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/propertyAccessor.kt");
  }

  @Test
  @TestMetadata("propertyDelegateInitializer.kt")
  public void testPropertyDelegateInitializer() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/propertyDelegateInitializer.kt");
  }

  @Test
  @TestMetadata("secondaryConstructor_superCallArgument.kt")
  public void testSecondaryConstructor_superCallArgument() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/secondaryConstructor_superCallArgument.kt");
  }

  @Test
  @TestMetadata("simple.kt")
  public void testSimple() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/simple.kt");
  }

  @Test
  @TestMetadata("topLevelFunction.kt")
  public void testTopLevelFunction() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/topLevelFunction.kt");
  }

  @Test
  @TestMetadata("topLevelProperty.kt")
  public void testTopLevelProperty() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/topLevelProperty.kt");
  }

  @Test
  @TestMetadata("typeAlias.kt")
  public void testTypeAlias() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/typeAlias.kt");
  }

  @Test
  @TestMetadata("typeAliasInitializer.kt")
  public void testTypeAliasInitializer() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/typeAliasInitializer.kt");
  }

  @Test
  @TestMetadata("typeParameter.kt")
  public void testTypeParameter() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameter.kt");
  }

  @Test
  @TestMetadata("wholeDeclaration_class.kt")
  public void testWholeDeclaration_class() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/wholeDeclaration_class.kt");
  }

  @Test
  @TestMetadata("wholeDeclaration_fun.kt")
  public void testWholeDeclaration_fun() {
    runTest("analysis/low-level-api-fir/testData/contextCollector/wholeDeclaration_fun.kt");
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions")
  @TestDataPath("$PROJECT_ROOT")
  public class ClassHeaderPositions {
    @Test
    public void testAllFilesPresentInClassHeaderPositions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("contextReceiver.kt")
    public void testContextReceiver() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/contextReceiver.kt");
    }

    @Test
    @TestMetadata("primaryConstructorParameter_initializerExpression.kt")
    public void testPrimaryConstructorParameter_initializerExpression() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/primaryConstructorParameter_initializerExpression.kt");
    }

    @Test
    @TestMetadata("primaryConstructorParameter_typeRef.kt")
    public void testPrimaryConstructorParameter_typeRef() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/primaryConstructorParameter_typeRef.kt");
    }

    @Test
    @TestMetadata("superTypeCallArgumentsExpression.kt")
    public void testSuperTypeCallArgumentsExpression() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCallArgumentsExpression.kt");
    }

    @Test
    @TestMetadata("superTypeCallArgumentsExpression_objectLiteral.kt")
    public void testSuperTypeCallArgumentsExpression_objectLiteral() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCallArgumentsExpression_objectLiteral.kt");
    }

    @Test
    @TestMetadata("superTypeCallArgumentsTypeRef.kt")
    public void testSuperTypeCallArgumentsTypeRef() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCallArgumentsTypeRef.kt");
    }

    @Test
    @TestMetadata("superTypeCallee.kt")
    public void testSuperTypeCallee() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCallee.kt");
    }

    @Test
    @TestMetadata("superTypeCalleeGenerics.kt")
    public void testSuperTypeCalleeGenerics() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCalleeGenerics.kt");
    }

    @Test
    @TestMetadata("superTypeCallee_objectLiteral.kt")
    public void testSuperTypeCallee_objectLiteral() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeCallee_objectLiteral.kt");
    }

    @Test
    @TestMetadata("superTypeDelegatedExpression.kt")
    public void testSuperTypeDelegatedExpression() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeDelegatedExpression.kt");
    }

    @Test
    @TestMetadata("superTypeDelegatedToCompanion.kt")
    public void testSuperTypeDelegatedToCompanion() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeDelegatedToCompanion.kt");
    }

    @Test
    @TestMetadata("superTypeDelegatedToPrimaryConstructorParam.kt")
    public void testSuperTypeDelegatedToPrimaryConstructorParam() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeDelegatedToPrimaryConstructorParam.kt");
    }

    @Test
    @TestMetadata("superTypeDelegatedTypeRef.kt")
    public void testSuperTypeDelegatedTypeRef() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeDelegatedTypeRef.kt");
    }

    @Test
    @TestMetadata("superTypeRef.kt")
    public void testSuperTypeRef() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeRef.kt");
    }

    @Test
    @TestMetadata("superTypeRefGenerics.kt")
    public void testSuperTypeRefGenerics() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/classHeaderPositions/superTypeRefGenerics.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/contextCollector/error")
  @TestDataPath("$PROJECT_ROOT")
  public class Error {
    @Test
    public void testAllFilesPresentInError() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/contextCollector/error"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("InvalidInitializer.kt")
    public void testInvalidInitializer() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/error/InvalidInitializer.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/contextCollector/scripts")
  @TestDataPath("$PROJECT_ROOT")
  public class Scripts {
    @Test
    public void testAllFilesPresentInScripts() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/contextCollector/scripts"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/contextCollector/smartCasts")
  @TestDataPath("$PROJECT_ROOT")
  public class SmartCasts {
    @Test
    @TestMetadata("afterIf.kt")
    public void testAfterIf() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/afterIf.kt");
    }

    @Test
    @TestMetadata("afterLoop.kt")
    public void testAfterLoop() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/afterLoop.kt");
    }

    @Test
    public void testAllFilesPresentInSmartCasts() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/contextCollector/smartCasts"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("andRight.kt")
    public void testAndRight() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/andRight.kt");
    }

    @Test
    @TestMetadata("argument.kt")
    public void testArgument() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/argument.kt");
    }

    @Test
    @TestMetadata("argumentAsReceiver.kt")
    public void testArgumentAsReceiver() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/argumentAsReceiver.kt");
    }

    @Test
    @TestMetadata("beforeIf.kt")
    public void testBeforeIf() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/beforeIf.kt");
    }

    @Test
    @TestMetadata("beforeLoop.kt")
    public void testBeforeLoop() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/beforeLoop.kt");
    }

    @Test
    @TestMetadata("dispatchReceiver.kt")
    public void testDispatchReceiver() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/dispatchReceiver.kt");
    }

    @Test
    @TestMetadata("extensionReceiver.kt")
    public void testExtensionReceiver() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/extensionReceiver.kt");
    }

    @Test
    @TestMetadata("insideLetOnNullableReceiver.kt")
    public void testInsideLetOnNullableReceiver() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/insideLetOnNullableReceiver.kt");
    }

    @Test
    @TestMetadata("insideLoop.kt")
    public void testInsideLoop() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/insideLoop.kt");
    }

    @Test
    @TestMetadata("onLabel.kt")
    public void testOnLabel() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/onLabel.kt");
    }

    @Test
    @TestMetadata("onReference.kt")
    public void testOnReference() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/onReference.kt");
    }

    @Test
    @TestMetadata("onSmartCastExpression.kt")
    public void testOnSmartCastExpression() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/onSmartCastExpression.kt");
    }

    @Test
    @TestMetadata("onType.kt")
    public void testOnType() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/onType.kt");
    }

    @Test
    @TestMetadata("orRight.kt")
    public void testOrRight() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/orRight.kt");
    }

    @Test
    @TestMetadata("plainCheck.kt")
    public void testPlainCheck() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/plainCheck.kt");
    }

    @Test
    @TestMetadata("require.kt")
    public void testRequire() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/require.kt");
    }

    @Test
    @TestMetadata("when.kt")
    public void testWhen() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/smartCasts/when.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/contextCollector/typeParameters")
  @TestDataPath("$PROJECT_ROOT")
  public class TypeParameters {
    @Test
    public void testAllFilesPresentInTypeParameters() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/contextCollector/typeParameters"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("declaredInClass_fromContextReceiver.kt")
    public void testDeclaredInClass_fromContextReceiver() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromContextReceiver.kt");
    }

    @Test
    @TestMetadata("declaredInClass_fromInner_typeBound.kt")
    public void testDeclaredInClass_fromInner_typeBound() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromInner_typeBound.kt");
    }

    @Test
    @TestMetadata("declaredInClass_fromInner_typeRefInMember.kt")
    public void testDeclaredInClass_fromInner_typeRefInMember() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromInner_typeRefInMember.kt");
    }

    @Test
    @TestMetadata("declaredInClass_fromNested_typeBound.kt")
    public void testDeclaredInClass_fromNested_typeBound() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromNested_typeBound.kt");
    }

    @Test
    @TestMetadata("declaredInClass_fromNested_typeRefInMember.kt")
    public void testDeclaredInClass_fromNested_typeRefInMember() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromNested_typeRefInMember.kt");
    }

    @Test
    @TestMetadata("declaredInClass_fromSuperType.kt")
    public void testDeclaredInClass_fromSuperType() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromSuperType.kt");
    }

    @Test
    @TestMetadata("declaredInClass_fromTypeBound.kt")
    public void testDeclaredInClass_fromTypeBound() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/typeParameters/declaredInClass_fromTypeBound.kt");
    }
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled")
  @TestDataPath("$PROJECT_ROOT")
  public class WithTestCompilerPluginEnabled {
    @Test
    public void testAllFilesPresentInWithTestCompilerPluginEnabled() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled"), Pattern.compile("^(.+)\\.(kt)$"), null, true);
    }

    @Test
    @TestMetadata("callShapeBasedInjector.kt")
    public void testCallShapeBasedInjector() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector.kt");
    }

    @Test
    @TestMetadata("callShapeBasedInjector_asReceiver.kt")
    public void testCallShapeBasedInjector_asReceiver() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector_asReceiver.kt");
    }

    @Test
    @TestMetadata("callShapeBasedInjector_delegate.kt")
    public void testCallShapeBasedInjector_delegate() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector_delegate.kt");
    }

    @Test
    @TestMetadata("callShapeBasedInjector_extraCall.kt")
    public void testCallShapeBasedInjector_extraCall() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector_extraCall.kt");
    }

    @Test
    @TestMetadata("callShapeBasedInjector_extraSafeCall.kt")
    public void testCallShapeBasedInjector_extraSafeCall() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector_extraSafeCall.kt");
    }

    @Test
    @TestMetadata("callShapeBasedInjector_notNullCheck.kt")
    public void testCallShapeBasedInjector_notNullCheck() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector_notNullCheck.kt");
    }

    @Test
    @TestMetadata("callShapeBasedInjector_safeCall.kt")
    public void testCallShapeBasedInjector_safeCall() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/callShapeBasedInjector_safeCall.kt");
    }

    @Test
    @TestMetadata("receiverInjection.kt")
    public void testReceiverInjection() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/receiverInjection.kt");
    }

    @Test
    @TestMetadata("receiverInjection_before.kt")
    public void testReceiverInjection_before() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/receiverInjection_before.kt");
    }

    @Test
    @TestMetadata("receiverInjection_extraCall.kt")
    public void testReceiverInjection_extraCall() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/receiverInjection_extraCall.kt");
    }

    @Test
    @TestMetadata("receiverInjection_wrongScope.kt")
    public void testReceiverInjection_wrongScope() {
      runTest("analysis/low-level-api-fir/testData/contextCollector/withTestCompilerPluginEnabled/receiverInjection_wrongScope.kt");
    }
  }
}
