/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/firClassByPsiClass")
@TestDataPath("$PROJECT_ROOT")
public class FirClassByPsiClassProviderTestGenerated extends AbstractFirClassByPsiClassProviderTest {
  @Test
  public void testAllFilesPresentInFirClassByPsiClass() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/firClassByPsiClass"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("classWithDollarInName.kt")
  public void testClassWithDollarInName() {
    runTest("analysis/low-level-api-fir/testData/firClassByPsiClass/classWithDollarInName.kt");
  }

  @Test
  @TestMetadata("nestedAndTopLevelClassesConflict.kt")
  public void testNestedAndTopLevelClassesConflict() {
    runTest("analysis/low-level-api-fir/testData/firClassByPsiClass/nestedAndTopLevelClassesConflict.kt");
  }

  @Test
  @TestMetadata("nestedClassWithDollarInName.kt")
  public void testNestedClassWithDollarInName() {
    runTest("analysis/low-level-api-fir/testData/firClassByPsiClass/nestedClassWithDollarInName.kt");
  }

  @Test
  @TestMetadata("nestedConflictInLibraryDifferentRoots.kt")
  public void testNestedConflictInLibraryDifferentRoots() {
    runTest("analysis/low-level-api-fir/testData/firClassByPsiClass/nestedConflictInLibraryDifferentRoots.kt");
  }

  @Test
  @TestMetadata("topLevelClassesConflict.kt")
  public void testTopLevelClassesConflict() {
    runTest("analysis/low-level-api-fir/testData/firClassByPsiClass/topLevelClassesConflict.kt");
  }

  @Test
  @TestMetadata("topLevelConflictInLibraryDifferentRoots.kt")
  public void testTopLevelConflictInLibraryDifferentRoots() {
    runTest("analysis/low-level-api-fir/testData/firClassByPsiClass/topLevelConflictInLibraryDifferentRoots.kt");
  }
}
