/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir.api;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/resolveToFirSymbol")
@TestDataPath("$PROJECT_ROOT")
public class ResolveToFirSymbolTestGenerated extends AbstractResolveToFirSymbolTest {
  @Test
  public void testAllFilesPresentInResolveToFirSymbol() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/resolveToFirSymbol"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities")
  @TestDataPath("$PROJECT_ROOT")
  public class Ambiguities {
    @Test
    public void testAllFilesPresentInAmbiguities() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @Test
    @TestMetadata("classAmbiguityLibraryMultiModule.kt")
    public void testClassAmbiguityLibraryMultiModule() {
      runTest("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities/classAmbiguityLibraryMultiModule.kt");
    }

    @Test
    @TestMetadata("classAmbiguityLibrarySingleModuleMultiRoot.kt")
    public void testClassAmbiguityLibrarySingleModuleMultiRoot() {
      runTest("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities/classAmbiguityLibrarySingleModuleMultiRoot.kt");
    }

    @Test
    @TestMetadata("classAmbiguitySourceSingleModule.kt")
    public void testClassAmbiguitySourceSingleModule() {
      runTest("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities/classAmbiguitySourceSingleModule.kt");
    }

    @Test
    @TestMetadata("classCallableAmbiguityLibraryMultiModule.kt")
    public void testClassCallableAmbiguityLibraryMultiModule() {
      runTest("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities/classCallableAmbiguityLibraryMultiModule.kt");
    }

    @Test
    @TestMetadata("classCallableAmbiguityLibrarySingleModuleMultiRoot.kt")
    public void testClassCallableAmbiguityLibrarySingleModuleMultiRoot() {
      runTest("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities/classCallableAmbiguityLibrarySingleModuleMultiRoot.kt");
    }

    @Test
    @TestMetadata("classCallableAmbiguitySourceSingleModule.kt")
    public void testClassCallableAmbiguitySourceSingleModule() {
      runTest("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities/classCallableAmbiguitySourceSingleModule.kt");
    }

    @Test
    @TestMetadata("enumEntryAmbiguityLibraryMultiModule.kt")
    public void testEnumEntryAmbiguityLibraryMultiModule() {
      runTest("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities/enumEntryAmbiguityLibraryMultiModule.kt");
    }

    @Test
    @TestMetadata("enumEntryAmbiguityLibrarySingleModuleMultiRoot.kt")
    public void testEnumEntryAmbiguityLibrarySingleModuleMultiRoot() {
      runTest("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities/enumEntryAmbiguityLibrarySingleModuleMultiRoot.kt");
    }

    @Test
    @TestMetadata("enumEntryAmbiguitySourceSingleModule.kt")
    public void testEnumEntryAmbiguitySourceSingleModule() {
      runTest("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities/enumEntryAmbiguitySourceSingleModule.kt");
    }

    @Test
    @TestMetadata("topLevelCallableAmbiguityLibraryMultiModule.kt")
    public void testTopLevelCallableAmbiguityLibraryMultiModule() {
      runTest("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities/topLevelCallableAmbiguityLibraryMultiModule.kt");
    }

    @Test
    @TestMetadata("topLevelCallableAmbiguityLibrarySingleModuleMultiRoot.kt")
    public void testTopLevelCallableAmbiguityLibrarySingleModuleMultiRoot() {
      runTest("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities/topLevelCallableAmbiguityLibrarySingleModuleMultiRoot.kt");
    }

    @Test
    @TestMetadata("topLevelCallableAmbiguitySourceSingleModule.kt")
    public void testTopLevelCallableAmbiguitySourceSingleModule() {
      runTest("analysis/low-level-api-fir/testData/resolveToFirSymbol/ambiguities/topLevelCallableAmbiguitySourceSingleModule.kt");
    }
  }
}
