/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostic.compiler.based;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testData/compilerLikeAnalysis")
@TestDataPath("$PROJECT_ROOT")
public class DiagnosticCompilerTestAATestdataTestGenerated extends AbstractDiagnosticCompilerTestDataTest {
  @Test
  public void testAllFilesPresentInCompilerLikeAnalysis() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/compilerLikeAnalysis"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("kt72704.kt")
  public void testKt72704() {
    runTest("analysis/low-level-api-fir/testData/compilerLikeAnalysis/kt72704.kt");
  }

  @Nested
  @TestMetadata("analysis/low-level-api-fir/testData/compilerLikeAnalysis/classpathSubstitution")
  @TestDataPath("$PROJECT_ROOT")
  public class ClasspathSubstitution {
    @Test
    public void testAllFilesPresentInClasspathSubstitution() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testData/compilerLikeAnalysis/classpathSubstitution"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
    }

    @Test
    @TestMetadata("cyclicSupertype3.kt")
    public void testCyclicSupertype3() {
      runTest("analysis/low-level-api-fir/testData/compilerLikeAnalysis/classpathSubstitution/cyclicSupertype3.kt");
    }

    @Test
    @TestMetadata("cyclicSupertype4.kt")
    public void testCyclicSupertype4() {
      runTest("analysis/low-level-api-fir/testData/compilerLikeAnalysis/classpathSubstitution/cyclicSupertype4.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithAlias.kt")
    public void testCyclicSupertypeWithAlias() {
      runTest("analysis/low-level-api-fir/testData/compilerLikeAnalysis/classpathSubstitution/cyclicSupertypeWithAlias.kt");
    }

    @Test
    @TestMetadata("cyclicSupertypeWithAlias2.kt")
    public void testCyclicSupertypeWithAlias2() {
      runTest("analysis/low-level-api-fir/testData/compilerLikeAnalysis/classpathSubstitution/cyclicSupertypeWithAlias2.kt");
    }
  }
}
