/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostic.compiler.based;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.utils.TransformersFunctions;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
public class DiagnosticCompilerTestFE10TestdataTestGenerated extends AbstractDiagnosticCompilerTestDataTest {
  @Nested
  @TestMetadata("compiler/testData/diagnostics/tests")
  @TestDataPath("$PROJECT_ROOT")
  public class Tests {
    @Test
    @TestMetadata("Abstract.kt")
    public void testAbstract() {
      runTest("compiler/testData/diagnostics/tests/Abstract.kt");
    }

    @Test
    @TestMetadata("AbstractAccessor.kt")
    public void testAbstractAccessor() {
      runTest("compiler/testData/diagnostics/tests/AbstractAccessor.kt");
    }

    @Test
    @TestMetadata("abstractClassReference.kt")
    public void testAbstractClassReference() {
      runTest("compiler/testData/diagnostics/tests/abstractClassReference.kt");
    }

    @Test
    @TestMetadata("AbstractInAbstractClass.kt")
    public void testAbstractInAbstractClass() {
      runTest("compiler/testData/diagnostics/tests/AbstractInAbstractClass.kt");
    }

    @Test
    @TestMetadata("AbstractInClass.kt")
    public void testAbstractInClass() {
      runTest("compiler/testData/diagnostics/tests/AbstractInClass.kt");
    }

    @Test
    @TestMetadata("AbstractInTrait.kt")
    public void testAbstractInTrait() {
      runTest("compiler/testData/diagnostics/tests/AbstractInTrait.kt");
    }

    @Test
    @TestMetadata("addTestForFalsePositiveDuplicateLabelInWhen.kt")
    public void testAddTestForFalsePositiveDuplicateLabelInWhen() {
      runTest("compiler/testData/diagnostics/tests/addTestForFalsePositiveDuplicateLabelInWhen.kt");
    }

    @Test
    public void testAllFilesPresentInTests() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
    }

    @Test
    @TestMetadata("alwaysRenderFullExpansions.kt")
    public void testAlwaysRenderFullExpansions() {
      runTest("compiler/testData/diagnostics/tests/alwaysRenderFullExpansions.kt");
    }

    @Test
    @TestMetadata("ambiguityNamedVararg.kt")
    public void testAmbiguityNamedVararg() {
      runTest("compiler/testData/diagnostics/tests/ambiguityNamedVararg.kt");
    }

    @Test
    @TestMetadata("ambiguityWithVararg.kt")
    public void testAmbiguityWithVararg() {
      runTest("compiler/testData/diagnostics/tests/ambiguityWithVararg.kt");
    }

    @Test
    @TestMetadata("ambiguityWithVarargManyExamples.kt")
    public void testAmbiguityWithVarargManyExamples() {
      runTest("compiler/testData/diagnostics/tests/ambiguityWithVarargManyExamples.kt");
    }

    @Test
    @TestMetadata("ambiguousLabelInExtensionFunctionWithOuterClass.kt")
    public void testAmbiguousLabelInExtensionFunctionWithOuterClass() {
      runTest("compiler/testData/diagnostics/tests/ambiguousLabelInExtensionFunctionWithOuterClass.kt");
    }

    @Test
    @TestMetadata("ambiguousLabelInSuper.kt")
    public void testAmbiguousLabelInSuper() {
      runTest("compiler/testData/diagnostics/tests/ambiguousLabelInSuper.kt");
    }

    @Test
    @TestMetadata("annotationArgumentWithAliasedArrayType.kt")
    public void testAnnotationArgumentWithAliasedArrayType() {
      runTest("compiler/testData/diagnostics/tests/annotationArgumentWithAliasedArrayType.kt");
    }

    @Test
    @TestMetadata("AnonymousInitializerVarAndConstructor.kt")
    public void testAnonymousInitializerVarAndConstructor() {
      runTest("compiler/testData/diagnostics/tests/AnonymousInitializerVarAndConstructor.kt");
    }

    @Test
    @TestMetadata("AnonymousInitializers.kt")
    public void testAnonymousInitializers() {
      runTest("compiler/testData/diagnostics/tests/AnonymousInitializers.kt");
    }

    @Test
    @TestMetadata("argumentTypeMismatchVsTooManyArgs.kt")
    public void testArgumentTypeMismatchVsTooManyArgs() {
      runTest("compiler/testData/diagnostics/tests/argumentTypeMismatchVsTooManyArgs.kt");
    }

    @Test
    @TestMetadata("AssignToArrayElement.kt")
    public void testAssignToArrayElement() {
      runTest("compiler/testData/diagnostics/tests/AssignToArrayElement.kt");
    }

    @Test
    @TestMetadata("assigningAssignments.kt")
    public void testAssigningAssignments() {
      runTest("compiler/testData/diagnostics/tests/assigningAssignments.kt");
    }

    @Test
    @TestMetadata("assignmentsAndSmartcastsToUnrelatedProperty.kt")
    public void testAssignmentsAndSmartcastsToUnrelatedProperty() {
      runTest("compiler/testData/diagnostics/tests/assignmentsAndSmartcastsToUnrelatedProperty.kt");
    }

    @Test
    @TestMetadata("AutoCreatedIt.kt")
    public void testAutoCreatedIt() {
      runTest("compiler/testData/diagnostics/tests/AutoCreatedIt.kt");
    }

    @Test
    @TestMetadata("BacktickNames.kt")
    public void testBacktickNames() {
      runTest("compiler/testData/diagnostics/tests/BacktickNames.kt");
    }

    @Test
    @TestMetadata("Basic.kt")
    public void testBasic() {
      runTest("compiler/testData/diagnostics/tests/Basic.kt");
    }

    @Test
    @TestMetadata("BinaryCallsOnNullableValues.kt")
    public void testBinaryCallsOnNullableValues() {
      runTest("compiler/testData/diagnostics/tests/BinaryCallsOnNullableValues.kt");
    }

    @Test
    @TestMetadata("Bounds.kt")
    public void testBounds() {
      runTest("compiler/testData/diagnostics/tests/Bounds.kt");
    }

    @Test
    @TestMetadata("BreakContinue.kt")
    public void testBreakContinue() {
      runTest("compiler/testData/diagnostics/tests/BreakContinue.kt");
    }

    @Test
    @TestMetadata("BreakContinueInWhen_after.kt")
    public void testBreakContinueInWhen_after() {
      runTest("compiler/testData/diagnostics/tests/BreakContinueInWhen_after.kt");
    }

    @Test
    @TestMetadata("breakLoopsBug.kt")
    public void testBreakLoopsBug() {
      runTest("compiler/testData/diagnostics/tests/breakLoopsBug.kt");
    }

    @Test
    @TestMetadata("breakLoopsBug2.kt")
    public void testBreakLoopsBug2() {
      runTest("compiler/testData/diagnostics/tests/breakLoopsBug2.kt");
    }

    @Test
    @TestMetadata("breakLoopsBug3.kt")
    public void testBreakLoopsBug3() {
      runTest("compiler/testData/diagnostics/tests/breakLoopsBug3.kt");
    }

    @Test
    @TestMetadata("breakLoopsBug4.kt")
    public void testBreakLoopsBug4() {
      runTest("compiler/testData/diagnostics/tests/breakLoopsBug4.kt");
    }

    @Test
    @TestMetadata("Builders.kt")
    public void testBuilders() {
      runTest("compiler/testData/diagnostics/tests/Builders.kt");
    }

    @Test
    @TestMetadata("callingProtectedFromInline.kt")
    public void testCallingProtectedFromInline() {
      runTest("compiler/testData/diagnostics/tests/callingProtectedFromInline.kt");
    }

    @Test
    @TestMetadata("callingSuspensionFunctionFromSuspendLambdas.kt")
    public void testCallingSuspensionFunctionFromSuspendLambdas() {
      runTest("compiler/testData/diagnostics/tests/callingSuspensionFunctionFromSuspendLambdas.kt");
    }

    @Test
    @TestMetadata("capturedTypesSubtyping.kt")
    public void testCapturedTypesSubtyping() {
      runTest("compiler/testData/diagnostics/tests/capturedTypesSubtyping.kt");
    }

    @Test
    @TestMetadata("Casts.kt")
    public void testCasts() {
      runTest("compiler/testData/diagnostics/tests/Casts.kt");
    }

    @Test
    @TestMetadata("CharacterLiterals.kt")
    public void testCharacterLiterals() {
      runTest("compiler/testData/diagnostics/tests/CharacterLiterals.kt");
    }

    @Test
    @TestMetadata("checkTypeTest.kt")
    public void testCheckTypeTest() {
      runTest("compiler/testData/diagnostics/tests/checkTypeTest.kt");
    }

    @Test
    @TestMetadata("checkTypeWithExactTest.kt")
    public void testCheckTypeWithExactTest() {
      runTest("compiler/testData/diagnostics/tests/checkTypeWithExactTest.kt");
    }

    @Test
    @TestMetadata("companionObjectInEnumAccess.kt")
    public void testCompanionObjectInEnumAccess() {
      runTest("compiler/testData/diagnostics/tests/companionObjectInEnumAccess.kt");
    }

    @Test
    @TestMetadata("CompareToWithErrorType.kt")
    public void testCompareToWithErrorType() {
      runTest("compiler/testData/diagnostics/tests/CompareToWithErrorType.kt");
    }

    @Test
    @TestMetadata("compareWithReified.kt")
    public void testCompareWithReified() {
      runTest("compiler/testData/diagnostics/tests/compareWithReified.kt");
    }

    @Test
    @TestMetadata("comparingArbitraryClasses.kt")
    public void testComparingArbitraryClasses() {
      runTest("compiler/testData/diagnostics/tests/comparingArbitraryClasses.kt");
    }

    @Test
    @TestMetadata("comparingCallableReferencesWithInstanceOfJavaClass.kt")
    public void testComparingCallableReferencesWithInstanceOfJavaClass() {
      runTest("compiler/testData/diagnostics/tests/comparingCallableReferencesWithInstanceOfJavaClass.kt");
    }

    @Test
    @TestMetadata("comparisonOfGenericInterfaceWithGenericClass.kt")
    public void testComparisonOfGenericInterfaceWithGenericClass() {
      runTest("compiler/testData/diagnostics/tests/comparisonOfGenericInterfaceWithGenericClass.kt");
    }

    @Test
    @TestMetadata("compilerCrashInRedCode.kt")
    public void testCompilerCrashInRedCode() {
      runTest("compiler/testData/diagnostics/tests/compilerCrashInRedCode.kt");
    }

    @Test
    @TestMetadata("compilerCrashInTypeParameterBoundsChecker.kt")
    public void testCompilerCrashInTypeParameterBoundsChecker() {
      runTest("compiler/testData/diagnostics/tests/compilerCrashInTypeParameterBoundsChecker.kt");
    }

    @Test
    @TestMetadata("compilerCrashParameterType.kt")
    public void testCompilerCrashParameterType() {
      runTest("compiler/testData/diagnostics/tests/compilerCrashParameterType.kt");
    }

    @Test
    @TestMetadata("compilerRequiredAnnotationAsTypealias.kt")
    public void testCompilerRequiredAnnotationAsTypealias() {
      runTest("compiler/testData/diagnostics/tests/compilerRequiredAnnotationAsTypealias.kt");
    }

    @Test
    @TestMetadata("confirmObsoleteAssignmentCanBeReplacedWithOperator.kt")
    public void testConfirmObsoleteAssignmentCanBeReplacedWithOperator() {
      runTest("compiler/testData/diagnostics/tests/confirmObsoleteAssignmentCanBeReplacedWithOperator.kt");
    }

    @Test
    @TestMetadata("confirmObsoleteTypealiasExpansionInconsistencies.kt")
    public void testConfirmObsoleteTypealiasExpansionInconsistencies() {
      runTest("compiler/testData/diagnostics/tests/confirmObsoleteTypealiasExpansionInconsistencies.kt");
    }

    @Test
    @TestMetadata("conflictingOverloadsPrivateFunctions.kt")
    public void testConflictingOverloadsPrivateFunctions() {
      runTest("compiler/testData/diagnostics/tests/conflictingOverloadsPrivateFunctions.kt");
    }

    @Test
    @TestMetadata("Constants.kt")
    public void testConstants() {
      runTest("compiler/testData/diagnostics/tests/Constants.kt");
    }

    @Test
    @TestMetadata("Constructors.kt")
    public void testConstructors() {
      runTest("compiler/testData/diagnostics/tests/Constructors.kt");
    }

    @Test
    @TestMetadata("ConstructorsOfPrimitives.kt")
    public void testConstructorsOfPrimitives() {
      runTest("compiler/testData/diagnostics/tests/ConstructorsOfPrimitives.kt");
    }

    @Test
    @TestMetadata("CovariantOverrideType.kt")
    public void testCovariantOverrideType() {
      runTest("compiler/testData/diagnostics/tests/CovariantOverrideType.kt");
    }

    @Test
    @TestMetadata("DefaultValueForParameterInFunctionType.kt")
    public void testDefaultValueForParameterInFunctionType() {
      runTest("compiler/testData/diagnostics/tests/DefaultValueForParameterInFunctionType.kt");
    }

    @Test
    @TestMetadata("DefaultValuesCheckWithoutBody.kt")
    public void testDefaultValuesCheckWithoutBody() {
      runTest("compiler/testData/diagnostics/tests/DefaultValuesCheckWithoutBody.kt");
    }

    @Test
    @TestMetadata("DefaultValuesTypechecking.kt")
    public void testDefaultValuesTypechecking() {
      runTest("compiler/testData/diagnostics/tests/DefaultValuesTypechecking.kt");
    }

    @Test
    @TestMetadata("DeferredTypes.kt")
    public void testDeferredTypes() {
      runTest("compiler/testData/diagnostics/tests/DeferredTypes.kt");
    }

    @Test
    @TestMetadata("delegatedMemberHidesSupertypeOverride.kt")
    public void testDelegatedMemberHidesSupertypeOverride() {
      runTest("compiler/testData/diagnostics/tests/delegatedMemberHidesSupertypeOverride.kt");
    }

    @Test
    @TestMetadata("delegationTypeMismatch.kt")
    public void testDelegationTypeMismatch() {
      runTest("compiler/testData/diagnostics/tests/delegationTypeMismatch.kt");
    }

    @Test
    @TestMetadata("DeprecatedGetSetPropertyDelegateConvention.kt")
    public void testDeprecatedGetSetPropertyDelegateConvention() {
      runTest("compiler/testData/diagnostics/tests/DeprecatedGetSetPropertyDelegateConvention.kt");
    }

    @Test
    @TestMetadata("DeprecatedUnaryOperatorConventions.kt")
    public void testDeprecatedUnaryOperatorConventions() {
      runTest("compiler/testData/diagnostics/tests/DeprecatedUnaryOperatorConventions.kt");
    }

    @Test
    @TestMetadata("derivedIntersectionPropertyShadowsBaseClassField.kt")
    public void testDerivedIntersectionPropertyShadowsBaseClassField() {
      runTest("compiler/testData/diagnostics/tests/derivedIntersectionPropertyShadowsBaseClassField.kt");
    }

    @Test
    @TestMetadata("DiamondFunction.kt")
    public void testDiamondFunction() {
      runTest("compiler/testData/diagnostics/tests/DiamondFunction.kt");
    }

    @Test
    @TestMetadata("DiamondFunctionGeneric.kt")
    public void testDiamondFunctionGeneric() {
      runTest("compiler/testData/diagnostics/tests/DiamondFunctionGeneric.kt");
    }

    @Test
    @TestMetadata("DiamondProperty.kt")
    public void testDiamondProperty() {
      runTest("compiler/testData/diagnostics/tests/DiamondProperty.kt");
    }

    @Test
    @TestMetadata("differentNumericTypesFromSmartCast.kt")
    public void testDifferentNumericTypesFromSmartCast() {
      runTest("compiler/testData/diagnostics/tests/differentNumericTypesFromSmartCast.kt");
    }

    @Test
    @TestMetadata("DisabledMultiDollarInterpolation.kt")
    public void testDisabledMultiDollarInterpolation() {
      runTest("compiler/testData/diagnostics/tests/DisabledMultiDollarInterpolation.kt");
    }

    @Test
    @TestMetadata("dnnAsSuperTypeTypeArgument.kt")
    public void testDnnAsSuperTypeTypeArgument() {
      runTest("compiler/testData/diagnostics/tests/dnnAsSuperTypeTypeArgument.kt");
    }

    @Test
    @TestMetadata("Dollar.kt")
    public void testDollar() {
      runTest("compiler/testData/diagnostics/tests/Dollar.kt");
    }

    @Test
    @TestMetadata("duplicateDefaultValuesSubsumedIntersection.kt")
    public void testDuplicateDefaultValuesSubsumedIntersection() {
      runTest("compiler/testData/diagnostics/tests/duplicateDefaultValuesSubsumedIntersection.kt");
    }

    @Test
    @TestMetadata("duplicateDirrectOverriddenCallables.kt")
    public void testDuplicateDirrectOverriddenCallables() {
      runTest("compiler/testData/diagnostics/tests/duplicateDirrectOverriddenCallables.kt");
    }

    @Test
    @TestMetadata("duplicateParameterName.kt")
    public void testDuplicateParameterName() {
      runTest("compiler/testData/diagnostics/tests/duplicateParameterName.kt");
    }

    @Test
    @TestMetadata("duplicateParameterNameMinimized.kt")
    public void testDuplicateParameterNameMinimized() {
      runTest("compiler/testData/diagnostics/tests/duplicateParameterNameMinimized.kt");
    }

    @Test
    @TestMetadata("duplicateParameterNameSimplified.kt")
    public void testDuplicateParameterNameSimplified() {
      runTest("compiler/testData/diagnostics/tests/duplicateParameterNameSimplified.kt");
    }

    @Test
    @TestMetadata("emptyLhsClassLiterals.kt")
    public void testEmptyLhsClassLiterals() {
      runTest("compiler/testData/diagnostics/tests/emptyLhsClassLiterals.kt");
    }

    @Test
    @TestMetadata("EmptyThrow.kt")
    public void testEmptyThrow() {
      runTest("compiler/testData/diagnostics/tests/EmptyThrow.kt");
    }

    @Test
    @TestMetadata("EnabledMultiDollarInterpolation.kt")
    public void testEnabledMultiDollarInterpolation() {
      runTest("compiler/testData/diagnostics/tests/EnabledMultiDollarInterpolation.kt");
    }

    @Test
    @TestMetadata("EnumEntryAsType.kt")
    public void testEnumEntryAsType() {
      runTest("compiler/testData/diagnostics/tests/EnumEntryAsType.kt");
    }

    @Test
    @TestMetadata("equalityComparisonToSelf.kt")
    public void testEqualityComparisonToSelf() {
      runTest("compiler/testData/diagnostics/tests/equalityComparisonToSelf.kt");
    }

    @Test
    @TestMetadata("equalityWithSmartCastInIfBlock.kt")
    public void testEqualityWithSmartCastInIfBlock() {
      runTest("compiler/testData/diagnostics/tests/equalityWithSmartCastInIfBlock.kt");
    }

    @Test
    @TestMetadata("errorSuppressionsWithoutWarning.kt")
    public void testErrorSuppressionsWithoutWarning() {
      runTest("compiler/testData/diagnostics/tests/errorSuppressionsWithoutWarning.kt");
    }

    @Test
    @TestMetadata("expressionsInQaSelectorsCornerCases.kt")
    public void testExpressionsInQaSelectorsCornerCases() {
      runTest("compiler/testData/diagnostics/tests/expressionsInQaSelectorsCornerCases.kt");
    }

    @Test
    @TestMetadata("expressionsInQaSelectorsReceiverConversion.kt")
    public void testExpressionsInQaSelectorsReceiverConversion() {
      runTest("compiler/testData/diagnostics/tests/expressionsInQaSelectorsReceiverConversion.kt");
    }

    @Test
    @TestMetadata("expressionsInQaSelectorsWithElvis.kt")
    public void testExpressionsInQaSelectorsWithElvis() {
      runTest("compiler/testData/diagnostics/tests/expressionsInQaSelectorsWithElvis.kt");
    }

    @Test
    @TestMetadata("ExtensionCallInvoke.kt")
    public void testExtensionCallInvoke() {
      runTest("compiler/testData/diagnostics/tests/ExtensionCallInvoke.kt");
    }

    @Test
    @TestMetadata("extensionShadowedByMember.kt")
    public void testExtensionShadowedByMember() {
      runTest("compiler/testData/diagnostics/tests/extensionShadowedByMember.kt");
    }

    @Test
    @TestMetadata("extensionShadowedByMemberWithMpp.kt")
    public void testExtensionShadowedByMemberWithMpp() {
      runTest("compiler/testData/diagnostics/tests/extensionShadowedByMemberWithMpp.kt");
    }

    @Test
    @TestMetadata("ExternalAccessors.kt")
    public void testExternalAccessors() {
      runTest("compiler/testData/diagnostics/tests/ExternalAccessors.kt");
    }

    @Test
    @TestMetadata("ExternalAndAbstract.kt")
    public void testExternalAndAbstract() {
      runTest("compiler/testData/diagnostics/tests/ExternalAndAbstract.kt");
    }

    @Test
    @TestMetadata("falseNegativeDuplicateDefaultValues1.kt")
    public void testFalseNegativeDuplicateDefaultValues1() {
      runTest("compiler/testData/diagnostics/tests/falseNegativeDuplicateDefaultValues1.kt");
    }

    @Test
    @TestMetadata("falseNegativeDuplicateDefaultValues1_error.kt")
    public void testFalseNegativeDuplicateDefaultValues1_error() {
      runTest("compiler/testData/diagnostics/tests/falseNegativeDuplicateDefaultValues1_error.kt");
    }

    @Test
    @TestMetadata("falseNegativeDuplicateDefaultValues2.kt")
    public void testFalseNegativeDuplicateDefaultValues2() {
      runTest("compiler/testData/diagnostics/tests/falseNegativeDuplicateDefaultValues2.kt");
    }

    @Test
    @TestMetadata("falseNegativeDuplicateDefaultValues3.kt")
    public void testFalseNegativeDuplicateDefaultValues3() {
      runTest("compiler/testData/diagnostics/tests/falseNegativeDuplicateDefaultValues3.kt");
    }

    @Test
    @TestMetadata("falseNegativeSuperCallWithDefaults.kt")
    public void testFalseNegativeSuperCallWithDefaults() {
      runTest("compiler/testData/diagnostics/tests/falseNegativeSuperCallWithDefaults.kt");
    }

    @Test
    @TestMetadata("falsePositiveRedundantVisibility.kt")
    public void testFalsePositiveRedundantVisibility() {
      runTest("compiler/testData/diagnostics/tests/falsePositiveRedundantVisibility.kt");
    }

    @Test
    @TestMetadata("falsePropertyAmongEnums.kt")
    public void testFalsePropertyAmongEnums() {
      runTest("compiler/testData/diagnostics/tests/falsePropertyAmongEnums.kt");
    }

    @Test
    @TestMetadata("falsePropertyAmongEnumsWithProperAnalysis.kt")
    public void testFalsePropertyAmongEnumsWithProperAnalysis() {
      runTest("compiler/testData/diagnostics/tests/falsePropertyAmongEnumsWithProperAnalysis.kt");
    }

    @Test
    @TestMetadata("fileDependencyRecursion.kt")
    public void testFileDependencyRecursion() {
      runTest("compiler/testData/diagnostics/tests/fileDependencyRecursion.kt");
    }

    @Test
    @TestMetadata("finalSupertype.kt")
    public void testFinalSupertype() {
      runTest("compiler/testData/diagnostics/tests/finalSupertype.kt");
    }

    @Test
    @TestMetadata("fixExpressionsInQaSelectors.kt")
    public void testFixExpressionsInQaSelectors() {
      runTest("compiler/testData/diagnostics/tests/fixExpressionsInQaSelectors.kt");
    }

    @Test
    @TestMetadata("ForRangeConventions.kt")
    public void testForRangeConventions() {
      runTest("compiler/testData/diagnostics/tests/ForRangeConventions.kt");
    }

    @Test
    @TestMetadata("fpRedundantProtected.kt")
    public void testFpRedundantProtected() {
      runTest("compiler/testData/diagnostics/tests/fpRedundantProtected.kt");
    }

    @Test
    @TestMetadata("FreeFunctionCalledAsExtension.kt")
    public void testFreeFunctionCalledAsExtension() {
      runTest("compiler/testData/diagnostics/tests/FreeFunctionCalledAsExtension.kt");
    }

    @Test
    @TestMetadata("funReturnsAny.kt")
    public void testFunReturnsAny() {
      runTest("compiler/testData/diagnostics/tests/funReturnsAny.kt");
    }

    @Test
    @TestMetadata("FunctionCalleeExpressions.kt")
    public void testFunctionCalleeExpressions() {
      runTest("compiler/testData/diagnostics/tests/FunctionCalleeExpressions.kt");
    }

    @Test
    @TestMetadata("FunctionParameterWithoutType.kt")
    public void testFunctionParameterWithoutType() {
      runTest("compiler/testData/diagnostics/tests/FunctionParameterWithoutType.kt");
    }

    @Test
    @TestMetadata("FunctionReturnTypes.kt")
    public void testFunctionReturnTypes() {
      runTest("compiler/testData/diagnostics/tests/FunctionReturnTypes.kt");
    }

    @Test
    @TestMetadata("functionTypeInitializerTypeMismatch.kt")
    public void testFunctionTypeInitializerTypeMismatch() {
      runTest("compiler/testData/diagnostics/tests/functionTypeInitializerTypeMismatch.kt");
    }

    @Test
    @TestMetadata("GenericArgumentConsistency.kt")
    public void testGenericArgumentConsistency() {
      runTest("compiler/testData/diagnostics/tests/GenericArgumentConsistency.kt");
    }

    @Test
    @TestMetadata("GenericFunctionIsLessSpecific.kt")
    public void testGenericFunctionIsLessSpecific() {
      runTest("compiler/testData/diagnostics/tests/GenericFunctionIsLessSpecific.kt");
    }

    @Test
    @TestMetadata("genericTypeMismatch.kt")
    public void testGenericTypeMismatch() {
      runTest("compiler/testData/diagnostics/tests/genericTypeMismatch.kt");
    }

    @Test
    @TestMetadata("IdentityComparisonWithPrimitives.kt")
    public void testIdentityComparisonWithPrimitives() {
      runTest("compiler/testData/diagnostics/tests/IdentityComparisonWithPrimitives.kt");
    }

    @Test
    @TestMetadata("illegalCharsInPackageWithDots.kt")
    public void testIllegalCharsInPackageWithDots() {
      runTest("compiler/testData/diagnostics/tests/illegalCharsInPackageWithDots.kt");
    }

    @Test
    @TestMetadata("implicitIntersection.kt")
    public void testImplicitIntersection() {
      runTest("compiler/testData/diagnostics/tests/implicitIntersection.kt");
    }

    @Test
    @TestMetadata("implicitNestedIntersection.kt")
    public void testImplicitNestedIntersection() {
      runTest("compiler/testData/diagnostics/tests/implicitNestedIntersection.kt");
    }

    @Test
    @TestMetadata("implicitNothing.kt")
    public void testImplicitNothing() {
      runTest("compiler/testData/diagnostics/tests/implicitNothing.kt");
    }

    @Test
    @TestMetadata("inapplicableTargetPropertyImmutableInPrimaryConstructor.kt")
    public void testInapplicableTargetPropertyImmutableInPrimaryConstructor() {
      runTest("compiler/testData/diagnostics/tests/inapplicableTargetPropertyImmutableInPrimaryConstructor.kt");
    }

    @Test
    @TestMetadata("IncDec.kt")
    public void testIncDec() {
      runTest("compiler/testData/diagnostics/tests/IncDec.kt");
    }

    @Test
    @TestMetadata("incDecInsideClasses.kt")
    public void testIncDecInsideClasses() {
      runTest("compiler/testData/diagnostics/tests/incDecInsideClasses.kt");
    }

    @Test
    @TestMetadata("incGenericExtensionProperty.kt")
    public void testIncGenericExtensionProperty() {
      runTest("compiler/testData/diagnostics/tests/incGenericExtensionProperty.kt");
    }

    @Test
    @TestMetadata("IncorrectCharacterLiterals.kt")
    public void testIncorrectCharacterLiterals() {
      runTest("compiler/testData/diagnostics/tests/IncorrectCharacterLiterals.kt");
    }

    @Test
    @TestMetadata("IncorrectMultiDollarInterpolationCodeA.kt")
    public void testIncorrectMultiDollarInterpolationCodeA() {
      runTest("compiler/testData/diagnostics/tests/IncorrectMultiDollarInterpolationCodeA.kt");
    }

    @Test
    @TestMetadata("IncorrectMultiDollarInterpolationCodeB.kt")
    public void testIncorrectMultiDollarInterpolationCodeB() {
      runTest("compiler/testData/diagnostics/tests/IncorrectMultiDollarInterpolationCodeB.kt");
    }

    @Test
    @TestMetadata("IncorrectPaddedMultiDollarInterpolationCodeA.kt")
    public void testIncorrectPaddedMultiDollarInterpolationCodeA() {
      runTest("compiler/testData/diagnostics/tests/IncorrectPaddedMultiDollarInterpolationCodeA.kt");
    }

    @Test
    @TestMetadata("IncorrectPaddedMultiDollarInterpolationCodeB.kt")
    public void testIncorrectPaddedMultiDollarInterpolationCodeB() {
      runTest("compiler/testData/diagnostics/tests/IncorrectPaddedMultiDollarInterpolationCodeB.kt");
    }

    @Test
    @TestMetadata("incrementDecrementOnFullyQualified.kt")
    public void testIncrementDecrementOnFullyQualified() {
      runTest("compiler/testData/diagnostics/tests/incrementDecrementOnFullyQualified.kt");
    }

    @Test
    @TestMetadata("incrementDecrementOnObject.kt")
    public void testIncrementDecrementOnObject() {
      runTest("compiler/testData/diagnostics/tests/incrementDecrementOnObject.kt");
    }

    @Test
    @TestMetadata("incrementOnErrorCallable.kt")
    public void testIncrementOnErrorCallable() {
      runTest("compiler/testData/diagnostics/tests/incrementOnErrorCallable.kt");
    }

    @Test
    @TestMetadata("InferNullabilityInThenBlock.kt")
    public void testInferNullabilityInThenBlock() {
      runTest("compiler/testData/diagnostics/tests/InferNullabilityInThenBlock.kt");
    }

    @Test
    @TestMetadata("Infix.kt")
    public void testInfix() {
      runTest("compiler/testData/diagnostics/tests/Infix.kt");
    }

    @Test
    @TestMetadata("InfixModifierApplicability.kt")
    public void testInfixModifierApplicability() {
      runTest("compiler/testData/diagnostics/tests/InfixModifierApplicability.kt");
    }

    @Test
    @TestMetadata("initializedAfterRethrow.kt")
    public void testInitializedAfterRethrow() {
      runTest("compiler/testData/diagnostics/tests/initializedAfterRethrow.kt");
    }

    @Test
    @TestMetadata("inlineConstructorParameter.kt")
    public void testInlineConstructorParameter() {
      runTest("compiler/testData/diagnostics/tests/inlineConstructorParameter.kt");
    }

    @Test
    @TestMetadata("inlineConstructorParameter_on.kt")
    public void testInlineConstructorParameter_on() {
      runTest("compiler/testData/diagnostics/tests/inlineConstructorParameter_on.kt");
    }

    @Test
    @TestMetadata("inlineDeprecationsOnImplicitCalls.kt")
    public void testInlineDeprecationsOnImplicitCalls() {
      runTest("compiler/testData/diagnostics/tests/inlineDeprecationsOnImplicitCalls.kt");
    }

    @Test
    @TestMetadata("intersectedVisibilitiesAccessorDifferences_Huge.kt")
    public void testIntersectedVisibilitiesAccessorDifferences_Huge() {
      runTest("compiler/testData/diagnostics/tests/intersectedVisibilitiesAccessorDifferences_Huge.kt");
    }

    @Test
    @TestMetadata("intersectedVisibilitiesAccessorDifferences_Small.kt")
    public void testIntersectedVisibilitiesAccessorDifferences_Small() {
      runTest("compiler/testData/diagnostics/tests/intersectedVisibilitiesAccessorDifferences_Small.kt");
    }

    @Test
    @TestMetadata("intersectedVisibilitiesAccessorDifferences_Useful1.kt")
    public void testIntersectedVisibilitiesAccessorDifferences_Useful1() {
      runTest("compiler/testData/diagnostics/tests/intersectedVisibilitiesAccessorDifferences_Useful1.kt");
    }

    @Test
    @TestMetadata("intersectedVisibilitiesAccessorDifferences_Useful2.kt")
    public void testIntersectedVisibilitiesAccessorDifferences_Useful2() {
      runTest("compiler/testData/diagnostics/tests/intersectedVisibilitiesAccessorDifferences_Useful2.kt");
    }

    @Test
    @TestMetadata("intersectedVisibilitiesForAbstractPropertyAccessors.kt")
    public void testIntersectedVisibilitiesForAbstractPropertyAccessors() {
      runTest("compiler/testData/diagnostics/tests/intersectedVisibilitiesForAbstractPropertyAccessors.kt");
    }

    @Test
    @TestMetadata("intersectedVisibilitiesForNonAbstractPropertyAccessors.kt")
    public void testIntersectedVisibilitiesForNonAbstractPropertyAccessors() {
      runTest("compiler/testData/diagnostics/tests/intersectedVisibilitiesForNonAbstractPropertyAccessors.kt");
    }

    @Test
    @TestMetadata("intersectedVisibilitiesPropertyAccessorsAdditionalWarnigns.kt")
    public void testIntersectedVisibilitiesPropertyAccessorsAdditionalWarnigns() {
      runTest("compiler/testData/diagnostics/tests/intersectedVisibilitiesPropertyAccessorsAdditionalWarnigns.kt");
    }

    @Test
    @TestMetadata("intersectionTypeRendering.kt")
    public void testIntersectionTypeRendering() {
      runTest("compiler/testData/diagnostics/tests/intersectionTypeRendering.kt");
    }

    @Test
    @TestMetadata("intersectionWithMultipleDefaultsInJava.kt")
    public void testIntersectionWithMultipleDefaultsInJava() {
      runTest("compiler/testData/diagnostics/tests/intersectionWithMultipleDefaultsInJava.kt");
    }

    @Test
    @TestMetadata("intersectionWithMultipleDefaultsInJavaOverriddenByIntersectionInKotlin.kt")
    public void testIntersectionWithMultipleDefaultsInJavaOverriddenByIntersectionInKotlin() {
      runTest("compiler/testData/diagnostics/tests/intersectionWithMultipleDefaultsInJavaOverriddenByIntersectionInKotlin.kt");
    }

    @Test
    @TestMetadata("intersectionWithMultipleDefaultsInJavaWithAdditionalSymbolsAfterNonSubsumed.kt")
    public void testIntersectionWithMultipleDefaultsInJavaWithAdditionalSymbolsAfterNonSubsumed() {
      runTest("compiler/testData/diagnostics/tests/intersectionWithMultipleDefaultsInJavaWithAdditionalSymbolsAfterNonSubsumed.kt");
    }

    @Test
    @TestMetadata("invalidAnnotation.kt")
    public void testInvalidAnnotation() {
      runTest("compiler/testData/diagnostics/tests/invalidAnnotation.kt");
    }

    @Test
    @TestMetadata("invalidTargetCrashesCompiler.kt")
    public void testInvalidTargetCrashesCompiler() {
      runTest("compiler/testData/diagnostics/tests/invalidTargetCrashesCompiler.kt");
    }

    @Test
    @TestMetadata("invisibleClassInsteadOfFun.kt")
    public void testInvisibleClassInsteadOfFun() {
      runTest("compiler/testData/diagnostics/tests/invisibleClassInsteadOfFun.kt");
    }

    @Test
    @TestMetadata("invisibleMemberDestructuring.kt")
    public void testInvisibleMemberDestructuring() {
      runTest("compiler/testData/diagnostics/tests/invisibleMemberDestructuring.kt");
    }

    @Test
    @TestMetadata("InvokeAndRecursiveResolve.kt")
    public void testInvokeAndRecursiveResolve() {
      runTest("compiler/testData/diagnostics/tests/InvokeAndRecursiveResolve.kt");
    }

    @Test
    @TestMetadata("IsExpressions.kt")
    public void testIsExpressions() {
      runTest("compiler/testData/diagnostics/tests/IsExpressions.kt");
    }

    @Test
    @TestMetadata("k2IrParentIssue.kt")
    public void testK2IrParentIssue() {
      runTest("compiler/testData/diagnostics/tests/k2IrParentIssue.kt");
    }

    @Test
    @TestMetadata("KotlinActualAnnotationHasNoEffectInKotlin.kt")
    public void testKotlinActualAnnotationHasNoEffectInKotlin() {
      runTest("compiler/testData/diagnostics/tests/KotlinActualAnnotationHasNoEffectInKotlin.kt");
    }

    @Test
    @TestMetadata("kt11167.kt")
    public void testKt11167() {
      runTest("compiler/testData/diagnostics/tests/kt11167.kt");
    }

    @Test
    @TestMetadata("kt13401.kt")
    public void testKt13401() {
      runTest("compiler/testData/diagnostics/tests/kt13401.kt");
    }

    @Test
    @TestMetadata("kt310.kt")
    public void testKt310() {
      runTest("compiler/testData/diagnostics/tests/kt310.kt");
    }

    @Test
    @TestMetadata("kt34440.kt")
    public void testKt34440() {
      runTest("compiler/testData/diagnostics/tests/kt34440.kt");
    }

    @Test
    @TestMetadata("kt34857.kt")
    public void testKt34857() {
      runTest("compiler/testData/diagnostics/tests/kt34857.kt");
    }

    @Test
    @TestMetadata("kt435.kt")
    public void testKt435() {
      runTest("compiler/testData/diagnostics/tests/kt435.kt");
    }

    @Test
    @TestMetadata("kt46483.kt")
    public void testKt46483() {
      runTest("compiler/testData/diagnostics/tests/kt46483.kt");
    }

    @Test
    @TestMetadata("kt49438.kt")
    public void testKt49438() {
      runTest("compiler/testData/diagnostics/tests/kt49438.kt");
    }

    @Test
    @TestMetadata("kt53.kt")
    public void testKt53() {
      runTest("compiler/testData/diagnostics/tests/kt53.kt");
    }

    @Test
    @TestMetadata("kt53988.kt")
    public void testKt53988() {
      runTest("compiler/testData/diagnostics/tests/kt53988.kt");
    }

    @Test
    @TestMetadata("kt54587_1.kt")
    public void testKt54587_1() {
      runTest("compiler/testData/diagnostics/tests/kt54587_1.kt");
    }

    @Test
    @TestMetadata("kt54587_2.kt")
    public void testKt54587_2() {
      runTest("compiler/testData/diagnostics/tests/kt54587_2.kt");
    }

    @Test
    @TestMetadata("kt55181.kt")
    public void testKt55181() {
      runTest("compiler/testData/diagnostics/tests/kt55181.kt");
    }

    @Test
    @TestMetadata("kt55666.kt")
    public void testKt55666() {
      runTest("compiler/testData/diagnostics/tests/kt55666.kt");
    }

    @Test
    @TestMetadata("kt55733.kt")
    public void testKt55733() {
      runTest("compiler/testData/diagnostics/tests/kt55733.kt");
    }

    @Test
    @TestMetadata("kt56612.kt")
    public void testKt56612() {
      runTest("compiler/testData/diagnostics/tests/kt56612.kt");
    }

    @Test
    @TestMetadata("kt56665.kt")
    public void testKt56665() {
      runTest("compiler/testData/diagnostics/tests/kt56665.kt");
    }

    @Test
    @TestMetadata("kt56723.kt")
    public void testKt56723() {
      runTest("compiler/testData/diagnostics/tests/kt56723.kt");
    }

    @Test
    @TestMetadata("kt56769.kt")
    public void testKt56769() {
      runTest("compiler/testData/diagnostics/tests/kt56769.kt");
    }

    @Test
    @TestMetadata("kt56876.kt")
    public void testKt56876() {
      runTest("compiler/testData/diagnostics/tests/kt56876.kt");
    }

    @Test
    @TestMetadata("kt56877.kt")
    public void testKt56877() {
      runTest("compiler/testData/diagnostics/tests/kt56877.kt");
    }

    @Test
    @TestMetadata("kt57085.kt")
    public void testKt57085() {
      runTest("compiler/testData/diagnostics/tests/kt57085.kt");
    }

    @Test
    @TestMetadata("kt57175.kt")
    public void testKt57175() {
      runTest("compiler/testData/diagnostics/tests/kt57175.kt");
    }

    @Test
    @TestMetadata("kt57214.kt")
    public void testKt57214() {
      runTest("compiler/testData/diagnostics/tests/kt57214.kt");
    }

    @Test
    @TestMetadata("kt58583.kt")
    public void testKt58583() {
      runTest("compiler/testData/diagnostics/tests/kt58583.kt");
    }

    @Test
    @TestMetadata("Kt60343.kt")
    public void testKt60343() {
      runTest("compiler/testData/diagnostics/tests/Kt60343.kt");
    }

    @Test
    @TestMetadata("kt60638.kt")
    public void testKt60638() {
      runTest("compiler/testData/diagnostics/tests/kt60638.kt");
    }

    @Test
    @TestMetadata("LValueAssignment.kt")
    public void testLValueAssignment() {
      runTest("compiler/testData/diagnostics/tests/LValueAssignment.kt");
    }

    @Test
    @TestMetadata("labelNameClash.kt")
    public void testLabelNameClash() {
      runTest("compiler/testData/diagnostics/tests/labelNameClash.kt");
    }

    @Test
    @TestMetadata("labeledLambda.kt")
    public void testLabeledLambda() {
      runTest("compiler/testData/diagnostics/tests/labeledLambda.kt");
    }

    @Test
    @TestMetadata("LiteralAsResult.kt")
    public void testLiteralAsResult() {
      runTest("compiler/testData/diagnostics/tests/LiteralAsResult.kt");
    }

    @Test
    @TestMetadata("LocalClassAndShortSubpackageNames.kt")
    public void testLocalClassAndShortSubpackageNames() {
      runTest("compiler/testData/diagnostics/tests/LocalClassAndShortSubpackageNames.kt");
    }

    @Test
    @TestMetadata("localInterfaces.kt")
    public void testLocalInterfaces() {
      runTest("compiler/testData/diagnostics/tests/localInterfaces.kt");
    }

    @Test
    @TestMetadata("missedTypeArgumentsInAnnotationCall.kt")
    public void testMissedTypeArgumentsInAnnotationCall() {
      runTest("compiler/testData/diagnostics/tests/missedTypeArgumentsInAnnotationCall.kt");
    }

    @Test
    @TestMetadata("missingConflictingOverloads.kt")
    public void testMissingConflictingOverloads() {
      runTest("compiler/testData/diagnostics/tests/missingConflictingOverloads.kt");
    }

    @Test
    @TestMetadata("missingDependencyTypealias.kt")
    public void testMissingDependencyTypealias() {
      runTest("compiler/testData/diagnostics/tests/missingDependencyTypealias.kt");
    }

    @Test
    @TestMetadata("missingIteratorMissing.kt")
    public void testMissingIteratorMissing() {
      runTest("compiler/testData/diagnostics/tests/missingIteratorMissing.kt");
    }

    @Test
    @TestMetadata("missingMultipleDefaultsOnTransitiveInheritance1.kt")
    public void testMissingMultipleDefaultsOnTransitiveInheritance1() {
      runTest("compiler/testData/diagnostics/tests/missingMultipleDefaultsOnTransitiveInheritance1.kt");
    }

    @Test
    @TestMetadata("missingMultipleDefaultsOnTransitiveInheritance2.kt")
    public void testMissingMultipleDefaultsOnTransitiveInheritance2() {
      runTest("compiler/testData/diagnostics/tests/missingMultipleDefaultsOnTransitiveInheritance2.kt");
    }

    @Test
    @TestMetadata("missingVisibilityErrorAccessThroughTypealias.kt")
    public void testMissingVisibilityErrorAccessThroughTypealias() {
      runTest("compiler/testData/diagnostics/tests/missingVisibilityErrorAccessThroughTypealias.kt");
    }

    @Test
    @TestMetadata("missingWrongAnnotationTarget.kt")
    public void testMissingWrongAnnotationTarget() {
      runTest("compiler/testData/diagnostics/tests/missingWrongAnnotationTarget.kt");
    }

    @Test
    @TestMetadata("moreThanOneOverriddenMissingK2.kt")
    public void testMoreThanOneOverriddenMissingK2() {
      runTest("compiler/testData/diagnostics/tests/moreThanOneOverriddenMissingK2.kt");
    }

    @Test
    @TestMetadata("MultilineStringTemplates.kt")
    public void testMultilineStringTemplates() {
      runTest("compiler/testData/diagnostics/tests/MultilineStringTemplates.kt");
    }

    @Test
    @TestMetadata("MultipleBounds.kt")
    public void testMultipleBounds() {
      runTest("compiler/testData/diagnostics/tests/MultipleBounds.kt");
    }

    @Test
    @TestMetadata("multipleDefaultsIncorrectlyAllowed1.kt")
    public void testMultipleDefaultsIncorrectlyAllowed1() {
      runTest("compiler/testData/diagnostics/tests/multipleDefaultsIncorrectlyAllowed1.kt");
    }

    @Test
    @TestMetadata("multipleDefaultsIncorrectlyAllowed2.kt")
    public void testMultipleDefaultsIncorrectlyAllowed2() {
      runTest("compiler/testData/diagnostics/tests/multipleDefaultsIncorrectlyAllowed2.kt");
    }

    @Test
    @TestMetadata("multipleDefaultsNoSource.kt")
    public void testMultipleDefaultsNoSource() {
      runTest("compiler/testData/diagnostics/tests/multipleDefaultsNoSource.kt");
    }

    @Test
    @TestMetadata("NamedFunctionTypeParameterInSupertype.kt")
    public void testNamedFunctionTypeParameterInSupertype() {
      runTest("compiler/testData/diagnostics/tests/NamedFunctionTypeParameterInSupertype.kt");
    }

    @Test
    @TestMetadata("nestedClassConstructorVsMemberFunctionConflict.kt")
    public void testNestedClassConstructorVsMemberFunctionConflict() {
      runTest("compiler/testData/diagnostics/tests/nestedClassConstructorVsMemberFunctionConflict.kt");
    }

    @Test
    @TestMetadata("noLibraryProvidersDuplication.kt")
    public void testNoLibraryProvidersDuplication() {
      runTest("compiler/testData/diagnostics/tests/noLibraryProvidersDuplication.kt");
    }

    @Test
    @TestMetadata("noLibraryProvidersDuplicationWithMpp.kt")
    public void testNoLibraryProvidersDuplicationWithMpp() {
      runTest("compiler/testData/diagnostics/tests/noLibraryProvidersDuplicationWithMpp.kt");
    }

    @Test
    @TestMetadata("noSymbolProvidersDuplicationInDiamond.kt")
    public void testNoSymbolProvidersDuplicationInDiamond() {
      runTest("compiler/testData/diagnostics/tests/noSymbolProvidersDuplicationInDiamond.kt");
    }

    @Test
    @TestMetadata("noUnusedOnDelegationWithProvider.kt")
    public void testNoUnusedOnDelegationWithProvider() {
      runTest("compiler/testData/diagnostics/tests/noUnusedOnDelegationWithProvider.kt");
    }

    @Test
    @TestMetadata("noValueForParameterOfLambda.kt")
    public void testNoValueForParameterOfLambda() {
      runTest("compiler/testData/diagnostics/tests/noValueForParameterOfLambda.kt");
    }

    @Test
    @TestMetadata("nonConstNotCall.kt")
    public void testNonConstNotCall() {
      runTest("compiler/testData/diagnostics/tests/nonConstNotCall.kt");
    }

    @Test
    @TestMetadata("nothingBound.kt")
    public void testNothingBound() {
      runTest("compiler/testData/diagnostics/tests/nothingBound.kt");
    }

    @Test
    @TestMetadata("Nullability.kt")
    public void testNullability() {
      runTest("compiler/testData/diagnostics/tests/Nullability.kt");
    }

    @Test
    @TestMetadata("NumberPrefixAndSuffix.kt")
    public void testNumberPrefixAndSuffix() {
      runTest("compiler/testData/diagnostics/tests/NumberPrefixAndSuffix.kt");
    }

    @Test
    @TestMetadata("ObjectWithConstructor.kt")
    public void testObjectWithConstructor() {
      runTest("compiler/testData/diagnostics/tests/ObjectWithConstructor.kt");
    }

    @Test
    @TestMetadata("obsoleteInsufficientDescription.kt")
    public void testObsoleteInsufficientDescription() {
      runTest("compiler/testData/diagnostics/tests/obsoleteInsufficientDescription.kt");
    }

    @Test
    @TestMetadata("OperatorChecks.kt")
    public void testOperatorChecks() {
      runTest("compiler/testData/diagnostics/tests/OperatorChecks.kt");
    }

    @Test
    @TestMetadata("OperatorConventions.kt")
    public void testOperatorConventions() {
      runTest("compiler/testData/diagnostics/tests/OperatorConventions.kt");
    }

    @Test
    @TestMetadata("Operators.kt")
    public void testOperators() {
      runTest("compiler/testData/diagnostics/tests/Operators.kt");
    }

    @Test
    @TestMetadata("OperatorsWithWrongNames.kt")
    public void testOperatorsWithWrongNames() {
      runTest("compiler/testData/diagnostics/tests/OperatorsWithWrongNames.kt");
    }

    @Test
    @TestMetadata("OverrideFunctionWithParamDefaultValue.kt")
    public void testOverrideFunctionWithParamDefaultValue() {
      runTest("compiler/testData/diagnostics/tests/OverrideFunctionWithParamDefaultValue.kt");
    }

    @Test
    @TestMetadata("overrideNotNull_Fail.kt")
    public void testOverrideNotNull_Fail() {
      runTest("compiler/testData/diagnostics/tests/overrideNotNull_Fail.kt");
    }

    @Test
    @TestMetadata("overrideNotNull_Ok.kt")
    public void testOverrideNotNull_Ok() {
      runTest("compiler/testData/diagnostics/tests/overrideNotNull_Ok.kt");
    }

    @Test
    @TestMetadata("OverridenFunctionAndSpecifiedTypeParameter.kt")
    public void testOverridenFunctionAndSpecifiedTypeParameter() {
      runTest("compiler/testData/diagnostics/tests/OverridenFunctionAndSpecifiedTypeParameter.kt");
    }

    @Test
    @TestMetadata("OverridenSetterVisibility.kt")
    public void testOverridenSetterVisibility() {
      runTest("compiler/testData/diagnostics/tests/OverridenSetterVisibility.kt");
    }

    @Test
    @TestMetadata("OverridingVarByVal.kt")
    public void testOverridingVarByVal() {
      runTest("compiler/testData/diagnostics/tests/OverridingVarByVal.kt");
    }

    @Test
    @TestMetadata("PackageInExpressionPosition.kt")
    public void testPackageInExpressionPosition() {
      runTest("compiler/testData/diagnostics/tests/PackageInExpressionPosition.kt");
    }

    @Test
    @TestMetadata("PackageInTypePosition.kt")
    public void testPackageInTypePosition() {
      runTest("compiler/testData/diagnostics/tests/PackageInTypePosition.kt");
    }

    @Test
    @TestMetadata("PackageQualified.kt")
    public void testPackageQualified() {
      runTest("compiler/testData/diagnostics/tests/PackageQualified.kt");
    }

    @Test
    @TestMetadata("packageWithModifiers.kt")
    public void testPackageWithModifiers() {
      runTest("compiler/testData/diagnostics/tests/packageWithModifiers.kt");
    }

    @Test
    @TestMetadata("parenthesesWithAssignmentOrSet.kt")
    public void testParenthesesWithAssignmentOrSet() {
      runTest("compiler/testData/diagnostics/tests/parenthesesWithAssignmentOrSet.kt");
    }

    @Test
    @TestMetadata("parenthesesWithAssignmentOrSetValCornerCases.kt")
    public void testParenthesesWithAssignmentOrSetValCornerCases() {
      runTest("compiler/testData/diagnostics/tests/parenthesesWithAssignmentOrSetValCornerCases.kt");
    }

    @Test
    @TestMetadata("parenthesesWithAssignmentOrSetVarCornerCases.kt")
    public void testParenthesesWithAssignmentOrSetVarCornerCases() {
      runTest("compiler/testData/diagnostics/tests/parenthesesWithAssignmentOrSetVarCornerCases.kt");
    }

    @Test
    @TestMetadata("parenthesesWithIncrements.kt")
    public void testParenthesesWithIncrements() {
      runTest("compiler/testData/diagnostics/tests/parenthesesWithIncrements.kt");
    }

    @Test
    @TestMetadata("parenthesesWithIndexedAssignmentOrSetValCornerCases.kt")
    public void testParenthesesWithIndexedAssignmentOrSetValCornerCases() {
      runTest("compiler/testData/diagnostics/tests/parenthesesWithIndexedAssignmentOrSetValCornerCases.kt");
    }

    @Test
    @TestMetadata("parenthesesWithIndexedAssignmentOrSetVarCornerCases.kt")
    public void testParenthesesWithIndexedAssignmentOrSetVarCornerCases() {
      runTest("compiler/testData/diagnostics/tests/parenthesesWithIndexedAssignmentOrSetVarCornerCases.kt");
    }

    @Test
    @TestMetadata("phantomIntersections.kt")
    public void testPhantomIntersections() {
      runTest("compiler/testData/diagnostics/tests/phantomIntersections.kt");
    }

    @Test
    @TestMetadata("plusAssignVsPrivateSetter.kt")
    public void testPlusAssignVsPrivateSetter() {
      runTest("compiler/testData/diagnostics/tests/plusAssignVsPrivateSetter.kt");
    }

    @Test
    @TestMetadata("postfixIncSmartCast.kt")
    public void testPostfixIncSmartCast() {
      runTest("compiler/testData/diagnostics/tests/postfixIncSmartCast.kt");
    }

    @Test
    @TestMetadata("prefixIncReturnType.kt")
    public void testPrefixIncReturnType() {
      runTest("compiler/testData/diagnostics/tests/prefixIncReturnType.kt");
    }

    @Test
    @TestMetadata("prefixIncSmartCast.kt")
    public void testPrefixIncSmartCast() {
      runTest("compiler/testData/diagnostics/tests/prefixIncSmartCast.kt");
    }

    @Test
    @TestMetadata("PrimaryConstructors.kt")
    public void testPrimaryConstructors() {
      runTest("compiler/testData/diagnostics/tests/PrimaryConstructors.kt");
    }

    @Test
    @TestMetadata("PrivateFromOuterPackage.kt")
    public void testPrivateFromOuterPackage() {
      runTest("compiler/testData/diagnostics/tests/PrivateFromOuterPackage.kt");
    }

    @Test
    @TestMetadata("PrivateSetterForOverridden.kt")
    public void testPrivateSetterForOverridden() {
      runTest("compiler/testData/diagnostics/tests/PrivateSetterForOverridden.kt");
    }

    @Test
    @TestMetadata("privateSetterSmartcastsToPublicSetter.kt")
    public void testPrivateSetterSmartcastsToPublicSetter() {
      runTest("compiler/testData/diagnostics/tests/privateSetterSmartcastsToPublicSetter.kt");
    }

    @Test
    @TestMetadata("ProcessingEmptyImport.kt")
    public void testProcessingEmptyImport() {
      runTest("compiler/testData/diagnostics/tests/ProcessingEmptyImport.kt");
    }

    @Test
    @TestMetadata("ProjectionOnFunctionArgumentErrror.kt")
    public void testProjectionOnFunctionArgumentErrror() {
      runTest("compiler/testData/diagnostics/tests/ProjectionOnFunctionArgumentErrror.kt");
    }

    @Test
    @TestMetadata("projectionProblemInIsExpression.kt")
    public void testProjectionProblemInIsExpression() {
      runTest("compiler/testData/diagnostics/tests/projectionProblemInIsExpression.kt");
    }

    @Test
    @TestMetadata("projectionProblemInIsMultiTypealiasArgument.kt")
    public void testProjectionProblemInIsMultiTypealiasArgument() {
      runTest("compiler/testData/diagnostics/tests/projectionProblemInIsMultiTypealiasArgument.kt");
    }

    @Test
    @TestMetadata("projectionProblemInIsTypealiasArgument.kt")
    public void testProjectionProblemInIsTypealiasArgument() {
      runTest("compiler/testData/diagnostics/tests/projectionProblemInIsTypealiasArgument.kt");
    }

    @Test
    @TestMetadata("projectionProblemWithTypealiasArgument.kt")
    public void testProjectionProblemWithTypealiasArgument() {
      runTest("compiler/testData/diagnostics/tests/projectionProblemWithTypealiasArgument.kt");
    }

    @Test
    @TestMetadata("ProjectionsInSupertypes.kt")
    public void testProjectionsInSupertypes() {
      runTest("compiler/testData/diagnostics/tests/ProjectionsInSupertypes.kt");
    }

    @Test
    @TestMetadata("properDefaultInitializationInTailrec.kt")
    public void testProperDefaultInitializationInTailrec() {
      runTest("compiler/testData/diagnostics/tests/properDefaultInitializationInTailrec.kt");
    }

    @Test
    @TestMetadata("Properties.kt")
    public void testProperties() {
      runTest("compiler/testData/diagnostics/tests/Properties.kt");
    }

    @Test
    @TestMetadata("PropertyInitializers.kt")
    public void testPropertyInitializers() {
      runTest("compiler/testData/diagnostics/tests/PropertyInitializers.kt");
    }

    @Test
    @TestMetadata("propertyPrivateSetttersPlusAssign.kt")
    public void testPropertyPrivateSetttersPlusAssign() {
      runTest("compiler/testData/diagnostics/tests/propertyPrivateSetttersPlusAssign.kt");
    }

    @Test
    @TestMetadata("protectedWithGenericsInDifferentPackage.kt")
    public void testProtectedWithGenericsInDifferentPackage() {
      runTest("compiler/testData/diagnostics/tests/protectedWithGenericsInDifferentPackage.kt");
    }

    @Test
    @TestMetadata("publishedApi.kt")
    public void testPublishedApi() {
      runTest("compiler/testData/diagnostics/tests/publishedApi.kt");
    }

    @Test
    @TestMetadata("publishedApiOverride.kt")
    public void testPublishedApiOverride() {
      runTest("compiler/testData/diagnostics/tests/publishedApiOverride.kt");
    }

    @Test
    @TestMetadata("QualifiedExpressions.kt")
    public void testQualifiedExpressions() {
      runTest("compiler/testData/diagnostics/tests/QualifiedExpressions.kt");
    }

    @Test
    @TestMetadata("rawCastToStarProjection_Fail.kt")
    public void testRawCastToStarProjection_Fail() {
      runTest("compiler/testData/diagnostics/tests/rawCastToStarProjection_Fail.kt");
    }

    @Test
    @TestMetadata("rawCastToStarProjection_Ok.kt")
    public void testRawCastToStarProjection_Ok() {
      runTest("compiler/testData/diagnostics/tests/rawCastToStarProjection_Ok.kt");
    }

    @Test
    @TestMetadata("receiverResolutionInDelegatedConstructor.kt")
    public void testReceiverResolutionInDelegatedConstructor() {
      runTest("compiler/testData/diagnostics/tests/receiverResolutionInDelegatedConstructor.kt");
    }

    @Test
    @TestMetadata("RecursiveResolve.kt")
    public void testRecursiveResolve() {
      runTest("compiler/testData/diagnostics/tests/RecursiveResolve.kt");
    }

    @Test
    @TestMetadata("RecursiveTypeInference.kt")
    public void testRecursiveTypeInference() {
      runTest("compiler/testData/diagnostics/tests/RecursiveTypeInference.kt");
    }

    @Test
    @TestMetadata("RecursiveTypeParameterEqualityCheck.kt")
    public void testRecursiveTypeParameterEqualityCheck() {
      runTest("compiler/testData/diagnostics/tests/RecursiveTypeParameterEqualityCheck.kt");
    }

    @Test
    @TestMetadata("recursiveTypealiasWithProjection.kt")
    public void testRecursiveTypealiasWithProjection() {
      runTest("compiler/testData/diagnostics/tests/recursiveTypealiasWithProjection.kt");
    }

    @Test
    @TestMetadata("redundantExplicitTypeWithIntegerLiterals.kt")
    public void testRedundantExplicitTypeWithIntegerLiterals() {
      runTest("compiler/testData/diagnostics/tests/redundantExplicitTypeWithIntegerLiterals.kt");
    }

    @Test
    @TestMetadata("referenceToParameterizedFun.kt")
    public void testReferenceToParameterizedFun() {
      runTest("compiler/testData/diagnostics/tests/referenceToParameterizedFun.kt");
    }

    @Test
    @TestMetadata("renderConstructorWithIntersection.kt")
    public void testRenderConstructorWithIntersection() {
      runTest("compiler/testData/diagnostics/tests/renderConstructorWithIntersection.kt");
    }

    @Test
    @TestMetadata("renderingOfTypesWithSameName.kt")
    public void testRenderingOfTypesWithSameName() {
      runTest("compiler/testData/diagnostics/tests/renderingOfTypesWithSameName.kt");
    }

    @Test
    @TestMetadata("ReserveYield.kt")
    public void testReserveYield() {
      runTest("compiler/testData/diagnostics/tests/ReserveYield.kt");
    }

    @Test
    @TestMetadata("ReserveYield2.kt")
    public void testReserveYield2() {
      runTest("compiler/testData/diagnostics/tests/ReserveYield2.kt");
    }

    @Test
    @TestMetadata("ReserveYieldNoMore.kt")
    public void testReserveYieldNoMore() {
      runTest("compiler/testData/diagnostics/tests/ReserveYieldNoMore.kt");
    }

    @Test
    @TestMetadata("ReserveYieldNoMore2.kt")
    public void testReserveYieldNoMore2() {
      runTest("compiler/testData/diagnostics/tests/ReserveYieldNoMore2.kt");
    }

    @Test
    @TestMetadata("resolutionToTypealiasInsteadOfProperty.kt")
    public void testResolutionToTypealiasInsteadOfProperty() {
      runTest("compiler/testData/diagnostics/tests/resolutionToTypealiasInsteadOfProperty.kt");
    }

    @Test
    @TestMetadata("ResolveOfJavaGenerics.kt")
    public void testResolveOfJavaGenerics() {
      runTest("compiler/testData/diagnostics/tests/ResolveOfJavaGenerics.kt");
    }

    @Test
    @TestMetadata("ResolveToJava.kt")
    public void testResolveToJava() {
      runTest("compiler/testData/diagnostics/tests/ResolveToJava.kt");
    }

    @Test
    @TestMetadata("restrictsSuspensionDifference.kt")
    public void testRestrictsSuspensionDifference() {
      runTest("compiler/testData/diagnostics/tests/restrictsSuspensionDifference.kt");
    }

    @Test
    @TestMetadata("Return.kt")
    public void testReturn() {
      runTest("compiler/testData/diagnostics/tests/Return.kt");
    }

    @Test
    @TestMetadata("ReturnInFunctionWithoutBody.kt")
    public void testReturnInFunctionWithoutBody() {
      runTest("compiler/testData/diagnostics/tests/ReturnInFunctionWithoutBody.kt");
    }

    @Test
    @TestMetadata("safeCall.kt")
    public void testSafeCall() {
      runTest("compiler/testData/diagnostics/tests/safeCall.kt");
    }

    @Test
    @TestMetadata("SafeCallInvoke.kt")
    public void testSafeCallInvoke() {
      runTest("compiler/testData/diagnostics/tests/SafeCallInvoke.kt");
    }

    @Test
    @TestMetadata("SafeCallNonNullReceiver.kt")
    public void testSafeCallNonNullReceiver() {
      runTest("compiler/testData/diagnostics/tests/SafeCallNonNullReceiver.kt");
    }

    @Test
    @TestMetadata("SafeCallNonNullReceiver2.kt")
    public void testSafeCallNonNullReceiver2() {
      runTest("compiler/testData/diagnostics/tests/SafeCallNonNullReceiver2.kt");
    }

    @Test
    @TestMetadata("SafeCallNonNullReceiverReturnNull.kt")
    public void testSafeCallNonNullReceiverReturnNull() {
      runTest("compiler/testData/diagnostics/tests/SafeCallNonNullReceiverReturnNull.kt");
    }

    @Test
    @TestMetadata("SafeCallOnFakePackage.kt")
    public void testSafeCallOnFakePackage() {
      runTest("compiler/testData/diagnostics/tests/SafeCallOnFakePackage.kt");
    }

    @Test
    @TestMetadata("SafeCallOnSuperReceiver.kt")
    public void testSafeCallOnSuperReceiver() {
      runTest("compiler/testData/diagnostics/tests/SafeCallOnSuperReceiver.kt");
    }

    @Test
    @TestMetadata("SafeCallUnknownType.kt")
    public void testSafeCallUnknownType() {
      runTest("compiler/testData/diagnostics/tests/SafeCallUnknownType.kt");
    }

    @Test
    @TestMetadata("Serializable.kt")
    public void testSerializable() {
      runTest("compiler/testData/diagnostics/tests/Serializable.kt");
    }

    @Test
    @TestMetadata("SetterVisibility.kt")
    public void testSetterVisibility() {
      runTest("compiler/testData/diagnostics/tests/SetterVisibility.kt");
    }

    @Test
    @TestMetadata("ShiftFunctionTypes.kt")
    public void testShiftFunctionTypes() {
      runTest("compiler/testData/diagnostics/tests/ShiftFunctionTypes.kt");
    }

    @Test
    @TestMetadata("StarsInFunctionCalls.kt")
    public void testStarsInFunctionCalls() {
      runTest("compiler/testData/diagnostics/tests/StarsInFunctionCalls.kt");
    }

    @Test
    @TestMetadata("StringPrefixAndSuffix.kt")
    public void testStringPrefixAndSuffix() {
      runTest("compiler/testData/diagnostics/tests/StringPrefixAndSuffix.kt");
    }

    @Test
    @TestMetadata("StringTemplates.kt")
    public void testStringTemplates() {
      runTest("compiler/testData/diagnostics/tests/StringTemplates.kt");
    }

    @Test
    @TestMetadata("superCallsWithDefaultArguments.kt")
    public void testSuperCallsWithDefaultArguments() {
      runTest("compiler/testData/diagnostics/tests/superCallsWithDefaultArguments.kt");
    }

    @Test
    @TestMetadata("superQualifierTypeArgsInDelegatedConstructorCall.kt")
    public void testSuperQualifierTypeArgsInDelegatedConstructorCall() {
      runTest("compiler/testData/diagnostics/tests/superQualifierTypeArgsInDelegatedConstructorCall.kt");
    }

    @Test
    @TestMetadata("SupertypeListChecks.kt")
    public void testSupertypeListChecks() {
      runTest("compiler/testData/diagnostics/tests/SupertypeListChecks.kt");
    }

    @Test
    @TestMetadata("suppressExposedPropertyTypeInConstructor.kt")
    public void testSuppressExposedPropertyTypeInConstructor() {
      runTest("compiler/testData/diagnostics/tests/suppressExposedPropertyTypeInConstructor.kt");
    }

    @Test
    @TestMetadata("suppressExposedPropertyTypeInPrivateConstructor.kt")
    public void testSuppressExposedPropertyTypeInPrivateConstructor() {
      runTest("compiler/testData/diagnostics/tests/suppressExposedPropertyTypeInPrivateConstructor.kt");
    }

    @Test
    @TestMetadata("suppressInWhen.kt")
    public void testSuppressInWhen() {
      runTest("compiler/testData/diagnostics/tests/suppressInWhen.kt");
    }

    @Test
    @TestMetadata("suppressNamedArg.kt")
    public void testSuppressNamedArg() {
      runTest("compiler/testData/diagnostics/tests/suppressNamedArg.kt");
    }

    @Test
    @TestMetadata("suppressOnPlusAssign.kt")
    public void testSuppressOnPlusAssign() {
      runTest("compiler/testData/diagnostics/tests/suppressOnPlusAssign.kt");
    }

    @Test
    @TestMetadata("suspendConflictingOverloads.kt")
    public void testSuspendConflictingOverloads() {
      runTest("compiler/testData/diagnostics/tests/suspendConflictingOverloads.kt");
    }

    @Test
    @TestMetadata("suspendFunAndPrivateJava.kt")
    public void testSuspendFunAndPrivateJava() {
      runTest("compiler/testData/diagnostics/tests/suspendFunAndPrivateJava.kt");
    }

    @Test
    @TestMetadata("SyntaxErrorInTestHighlighting.kt")
    public void testSyntaxErrorInTestHighlighting() {
      runTest("compiler/testData/diagnostics/tests/SyntaxErrorInTestHighlighting.kt");
    }

    @Test
    @TestMetadata("SyntaxErrorInTestHighlightingEof.kt")
    public void testSyntaxErrorInTestHighlightingEof() {
      runTest("compiler/testData/diagnostics/tests/SyntaxErrorInTestHighlightingEof.kt");
    }

    @Test
    @TestMetadata("syntheticSet.kt")
    public void testSyntheticSet() {
      runTest("compiler/testData/diagnostics/tests/syntheticSet.kt");
    }

    @Test
    @TestMetadata("syntheticSetFalsePositive.kt")
    public void testSyntheticSetFalsePositive() {
      runTest("compiler/testData/diagnostics/tests/syntheticSetFalsePositive.kt");
    }

    @Test
    @TestMetadata("tailRecBasic.kt")
    public void testTailRecBasic() {
      runTest("compiler/testData/diagnostics/tests/tailRecBasic.kt");
    }

    @Test
    @TestMetadata("tailRecInNestedScopes.kt")
    public void testTailRecInNestedScopes() {
      runTest("compiler/testData/diagnostics/tests/tailRecInNestedScopes.kt");
    }

    @Test
    @TestMetadata("tailRecInTry.kt")
    public void testTailRecInTry() {
      runTest("compiler/testData/diagnostics/tests/tailRecInTry.kt");
    }

    @Test
    @TestMetadata("tailRecOnVirtualMemberError.kt")
    public void testTailRecOnVirtualMemberError() {
      runTest("compiler/testData/diagnostics/tests/tailRecOnVirtualMemberError.kt");
    }

    @Test
    @TestMetadata("tailRecOverridden.kt")
    public void testTailRecOverridden() {
      runTest("compiler/testData/diagnostics/tests/tailRecOverridden.kt");
    }

    @Test
    @TestMetadata("tailRecSingleton.kt")
    public void testTailRecSingleton() {
      runTest("compiler/testData/diagnostics/tests/tailRecSingleton.kt");
    }

    @Test
    @TestMetadata("tailRecWithDispatchReceiver.kt")
    public void testTailRecWithDispatchReceiver() {
      runTest("compiler/testData/diagnostics/tests/tailRecWithDispatchReceiver.kt");
    }

    @Test
    @TestMetadata("tailRecWithExtensionReceiver.kt")
    public void testTailRecWithExtensionReceiver() {
      runTest("compiler/testData/diagnostics/tests/tailRecWithExtensionReceiver.kt");
    }

    @Test
    @TestMetadata("tailRecursionComplex.kt")
    public void testTailRecursionComplex() {
      runTest("compiler/testData/diagnostics/tests/tailRecursionComplex.kt");
    }

    @Test
    @TestMetadata("tailrec.kt")
    public void testTailrec() {
      runTest("compiler/testData/diagnostics/tests/tailrec.kt");
    }

    @Test
    @TestMetadata("TraitOverrideObjectMethods.kt")
    public void testTraitOverrideObjectMethods() {
      runTest("compiler/testData/diagnostics/tests/TraitOverrideObjectMethods.kt");
    }

    @Test
    @TestMetadata("TraitWithConstructor.kt")
    public void testTraitWithConstructor() {
      runTest("compiler/testData/diagnostics/tests/TraitWithConstructor.kt");
    }

    @Test
    @TestMetadata("typeExposureAsABound.kt")
    public void testTypeExposureAsABound() {
      runTest("compiler/testData/diagnostics/tests/typeExposureAsABound.kt");
    }

    @Test
    @TestMetadata("TypeInference.kt")
    public void testTypeInference() {
      runTest("compiler/testData/diagnostics/tests/TypeInference.kt");
    }

    @Test
    @TestMetadata("TypeMismatchOnOverrideWithSyntaxErrors.kt")
    public void testTypeMismatchOnOverrideWithSyntaxErrors() {
      runTest("compiler/testData/diagnostics/tests/TypeMismatchOnOverrideWithSyntaxErrors.kt");
    }

    @Test
    @TestMetadata("typeMismatchSameShortName.kt")
    public void testTypeMismatchSameShortName() {
      runTest("compiler/testData/diagnostics/tests/typeMismatchSameShortName.kt");
    }

    @Test
    @TestMetadata("typealiasAnnotationWithFixedTypeArgument.kt")
    public void testTypealiasAnnotationWithFixedTypeArgument() {
      runTest("compiler/testData/diagnostics/tests/typealiasAnnotationWithFixedTypeArgument.kt");
    }

    @Test
    @TestMetadata("typealiasInAnnotationPrimitiveVararg.kt")
    public void testTypealiasInAnnotationPrimitiveVararg() {
      runTest("compiler/testData/diagnostics/tests/typealiasInAnnotationPrimitiveVararg.kt");
    }

    @Test
    @TestMetadata("typealiasedFunInterface.kt")
    public void testTypealiasedFunInterface() {
      runTest("compiler/testData/diagnostics/tests/typealiasedFunInterface.kt");
    }

    @Test
    @TestMetadata("Underscore.kt")
    public void testUnderscore() {
      runTest("compiler/testData/diagnostics/tests/Underscore.kt");
    }

    @Test
    @TestMetadata("UnderscoreUsageInAnnotation.kt")
    public void testUnderscoreUsageInAnnotation() {
      runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInAnnotation.kt");
    }

    @Test
    @TestMetadata("UnderscoreUsageInCall.kt")
    public void testUnderscoreUsageInCall() {
      runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInCall.kt");
    }

    @Test
    @TestMetadata("UnderscoreUsageInCallableRefTypeLHS.kt")
    public void testUnderscoreUsageInCallableRefTypeLHS() {
      runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInCallableRefTypeLHS.kt");
    }

    @Test
    @TestMetadata("UnderscoreUsageInType.kt")
    public void testUnderscoreUsageInType() {
      runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInType.kt");
    }

    @Test
    @TestMetadata("UnderscoreUsageInVariableAsFunctionCall.kt")
    public void testUnderscoreUsageInVariableAsFunctionCall() {
      runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInVariableAsFunctionCall.kt");
    }

    @Test
    @TestMetadata("unexpectedSafeCall.kt")
    public void testUnexpectedSafeCall() {
      runTest("compiler/testData/diagnostics/tests/unexpectedSafeCall.kt");
    }

    @Test
    @TestMetadata("UnitByDefaultForFunctionTypes.kt")
    public void testUnitByDefaultForFunctionTypes() {
      runTest("compiler/testData/diagnostics/tests/UnitByDefaultForFunctionTypes.kt");
    }

    @Test
    @TestMetadata("UnitValue.kt")
    public void testUnitValue() {
      runTest("compiler/testData/diagnostics/tests/UnitValue.kt");
    }

    @Test
    @TestMetadata("unnamedArgsInJavaAnnotations.kt")
    public void testUnnamedArgsInJavaAnnotations() {
      runTest("compiler/testData/diagnostics/tests/unnamedArgsInJavaAnnotations.kt");
    }

    @Test
    @TestMetadata("Unresolved.kt")
    public void testUnresolved() {
      runTest("compiler/testData/diagnostics/tests/Unresolved.kt");
    }

    @Test
    @TestMetadata("unresolvedNameInBackticksInReceiver.kt")
    public void testUnresolvedNameInBackticksInReceiver() {
      runTest("compiler/testData/diagnostics/tests/unresolvedNameInBackticksInReceiver.kt");
    }

    @Test
    @TestMetadata("UnusedInDestructuring.kt")
    public void testUnusedInDestructuring() {
      runTest("compiler/testData/diagnostics/tests/UnusedInDestructuring.kt");
    }

    @Test
    @TestMetadata("UnusedParameters.kt")
    public void testUnusedParameters() {
      runTest("compiler/testData/diagnostics/tests/UnusedParameters.kt");
    }

    @Test
    @TestMetadata("unusedVariableOnRegularDelegatedProperty.kt")
    public void testUnusedVariableOnRegularDelegatedProperty() {
      runTest("compiler/testData/diagnostics/tests/unusedVariableOnRegularDelegatedProperty.kt");
    }

    @Test
    @TestMetadata("UnusedVariables.kt")
    public void testUnusedVariables() {
      runTest("compiler/testData/diagnostics/tests/UnusedVariables.kt");
    }

    @Test
    @TestMetadata("ValAndFunOverrideCompatibilityClash.kt")
    public void testValAndFunOverrideCompatibilityClash() {
      runTest("compiler/testData/diagnostics/tests/ValAndFunOverrideCompatibilityClash.kt");
    }

    @Test
    @TestMetadata("valueParameterWithoutExplicitType.kt")
    public void testValueParameterWithoutExplicitType() {
      runTest("compiler/testData/diagnostics/tests/valueParameterWithoutExplicitType.kt");
    }

    @Test
    @TestMetadata("varOverriddenByValThroughIntersection.kt")
    public void testVarOverriddenByValThroughIntersection() {
      runTest("compiler/testData/diagnostics/tests/varOverriddenByValThroughIntersection.kt");
    }

    @Test
    @TestMetadata("VarargTypes.kt")
    public void testVarargTypes() {
      runTest("compiler/testData/diagnostics/tests/VarargTypes.kt");
    }

    @Test
    @TestMetadata("Varargs.kt")
    public void testVarargs() {
      runTest("compiler/testData/diagnostics/tests/Varargs.kt");
    }

    @Test
    @TestMetadata("Variance.kt")
    public void testVariance() {
      runTest("compiler/testData/diagnostics/tests/Variance.kt");
    }

    @Test
    @TestMetadata("whileConditionExpectedType.kt")
    public void testWhileConditionExpectedType() {
      runTest("compiler/testData/diagnostics/tests/whileConditionExpectedType.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/annotations")
    @TestDataPath("$PROJECT_ROOT")
    public class Annotations {
      @Test
      public void testAllFilesPresentInAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("AmbigiousAnnotationConstructor.kt")
      public void testAmbigiousAnnotationConstructor() {
        runTest("compiler/testData/diagnostics/tests/annotations/AmbigiousAnnotationConstructor.kt");
      }

      @Test
      @TestMetadata("AnnotatedBlock.kt")
      public void testAnnotatedBlock() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedBlock.kt");
      }

      @Test
      @TestMetadata("AnnotatedCatchValueParameter.kt")
      public void testAnnotatedCatchValueParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedCatchValueParameter.kt");
      }

      @Test
      @TestMetadata("AnnotatedConstructor.kt")
      public void testAnnotatedConstructor() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedConstructor.kt");
      }

      @Test
      @TestMetadata("AnnotatedConstructorParams.kt")
      public void testAnnotatedConstructorParams() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedConstructorParams.kt");
      }

      @Test
      @TestMetadata("AnnotatedErrorTypeRef.kt")
      public void testAnnotatedErrorTypeRef() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedErrorTypeRef.kt");
      }

      @Test
      @TestMetadata("annotatedExpressionInsideAnnotation.kt")
      public void testAnnotatedExpressionInsideAnnotation() {
        runTest("compiler/testData/diagnostics/tests/annotations/annotatedExpressionInsideAnnotation.kt");
      }

      @Test
      @TestMetadata("AnnotatedLocalObjectFun.kt")
      public void testAnnotatedLocalObjectFun() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedLocalObjectFun.kt");
      }

      @Test
      @TestMetadata("AnnotatedLocalObjectProperty.kt")
      public void testAnnotatedLocalObjectProperty() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedLocalObjectProperty.kt");
      }

      @Test
      @TestMetadata("AnnotatedLoop.kt")
      public void testAnnotatedLoop() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedLoop.kt");
      }

      @Test
      @TestMetadata("AnnotatedNullableTypes.kt")
      public void testAnnotatedNullableTypes() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedNullableTypes.kt");
      }

      @Test
      @TestMetadata("AnnotatedResultType.kt")
      public void testAnnotatedResultType() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedResultType.kt");
      }

      @Test
      @TestMetadata("AnnotatedStatement.kt")
      public void testAnnotatedStatement() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedStatement.kt");
      }

      @Test
      @TestMetadata("AnnotatedTryCatch.kt")
      public void testAnnotatedTryCatch() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedTryCatch.kt");
      }

      @Test
      @TestMetadata("AnnotationAsDefaultParameter.kt")
      public void testAnnotationAsDefaultParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotationAsDefaultParameter.kt");
      }

      @Test
      @TestMetadata("AnnotationForClassTypeParameter_15.kt")
      public void testAnnotationForClassTypeParameter_15() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForClassTypeParameter_15.kt");
      }

      @Test
      @TestMetadata("AnnotationForClassTypeParameter_16.kt")
      public void testAnnotationForClassTypeParameter_16() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForClassTypeParameter_16.kt");
      }

      @Test
      @TestMetadata("AnnotationForClassTypeParameter_typeUseFlag.kt")
      public void testAnnotationForClassTypeParameter_typeUseFlag() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForClassTypeParameter_typeUseFlag.kt");
      }

      @Test
      @TestMetadata("AnnotationForFunctionTypeParameter.kt")
      public void testAnnotationForFunctionTypeParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForFunctionTypeParameter.kt");
      }

      @Test
      @TestMetadata("AnnotationForObject.kt")
      public void testAnnotationForObject() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForObject.kt");
      }

      @Test
      @TestMetadata("AnnotationIdentifier.kt")
      public void testAnnotationIdentifier() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotationIdentifier.kt");
      }

      @Test
      @TestMetadata("AnnotationInContract.kt")
      public void testAnnotationInContract() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotationInContract.kt");
      }

      @Test
      @TestMetadata("annotationInheritance.kt")
      public void testAnnotationInheritance() {
        runTest("compiler/testData/diagnostics/tests/annotations/annotationInheritance.kt");
      }

      @Test
      @TestMetadata("annotationModifier.kt")
      public void testAnnotationModifier() {
        runTest("compiler/testData/diagnostics/tests/annotations/annotationModifier.kt");
      }

      @Test
      @TestMetadata("AnnotationOnObject.kt")
      public void testAnnotationOnObject() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotationOnObject.kt");
      }

      @Test
      @TestMetadata("annotationOnParameterInFunctionType.kt")
      public void testAnnotationOnParameterInFunctionType() {
        runTest("compiler/testData/diagnostics/tests/annotations/annotationOnParameterInFunctionType.kt");
      }

      @Test
      @TestMetadata("annotationRenderingInTypes.kt")
      public void testAnnotationRenderingInTypes() {
        runTest("compiler/testData/diagnostics/tests/annotations/annotationRenderingInTypes.kt");
      }

      @Test
      @TestMetadata("AnnotationsForClasses.kt")
      public void testAnnotationsForClasses() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotationsForClasses.kt");
      }

      @Test
      @TestMetadata("AnnotationsForPropertyTypeParameter.kt")
      public void testAnnotationsForPropertyTypeParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/AnnotationsForPropertyTypeParameter.kt");
      }

      @Test
      @TestMetadata("annotationsOnDataClassCopy.kt")
      public void testAnnotationsOnDataClassCopy() {
        runTest("compiler/testData/diagnostics/tests/annotations/annotationsOnDataClassCopy.kt");
      }

      @Test
      @TestMetadata("annotationsOnLambdaAsCallArgument.kt")
      public void testAnnotationsOnLambdaAsCallArgument() {
        runTest("compiler/testData/diagnostics/tests/annotations/annotationsOnLambdaAsCallArgument.kt");
      }

      @Test
      @TestMetadata("annotationsOnNullableTypes.kt")
      public void testAnnotationsOnNullableTypes() {
        runTest("compiler/testData/diagnostics/tests/annotations/annotationsOnNullableTypes.kt");
      }

      @Test
      @TestMetadata("arrayLiteralFalseNegativeInsideLambda.kt")
      public void testArrayLiteralFalseNegativeInsideLambda() {
        runTest("compiler/testData/diagnostics/tests/annotations/arrayLiteralFalseNegativeInsideLambda.kt");
      }

      @Test
      @TestMetadata("arrayLiteralInAnnotationCompanion_after.kt")
      public void testArrayLiteralInAnnotationCompanion_after() {
        runTest("compiler/testData/diagnostics/tests/annotations/arrayLiteralInAnnotationCompanion_after.kt");
      }

      @Test
      @TestMetadata("arrayLiteralInAnnotationCompanion_before.kt")
      public void testArrayLiteralInAnnotationCompanion_before() {
        runTest("compiler/testData/diagnostics/tests/annotations/arrayLiteralInAnnotationCompanion_before.kt");
      }

      @Test
      @TestMetadata("atAnnotationResolve.kt")
      public void testAtAnnotationResolve() {
        runTest("compiler/testData/diagnostics/tests/annotations/atAnnotationResolve.kt");
      }

      @Test
      @TestMetadata("BasicAnnotations.kt")
      public void testBasicAnnotations() {
        runTest("compiler/testData/diagnostics/tests/annotations/BasicAnnotations.kt");
      }

      @Test
      @TestMetadata("blockLevelOnTheSameLineWarning.kt")
      public void testBlockLevelOnTheSameLineWarning() {
        runTest("compiler/testData/diagnostics/tests/annotations/blockLevelOnTheSameLineWarning.kt");
      }

      @Test
      @TestMetadata("classAnnotationsInLocalClass.kt")
      public void testClassAnnotationsInLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/classAnnotationsInLocalClass.kt");
      }

      @Test
      @TestMetadata("companionAnnotations.kt")
      public void testCompanionAnnotations() {
        runTest("compiler/testData/diagnostics/tests/annotations/companionAnnotations.kt");
      }

      @Test
      @TestMetadata("constantFromOuterScopeAsAnnotaionParameter.kt")
      public void testConstantFromOuterScopeAsAnnotaionParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/constantFromOuterScopeAsAnnotaionParameter.kt");
      }

      @Test
      @TestMetadata("ConstructorCall.kt")
      public void testConstructorCall() {
        runTest("compiler/testData/diagnostics/tests/annotations/ConstructorCall.kt");
      }

      @Test
      @TestMetadata("ConstructorCallAllowed.kt")
      public void testConstructorCallAllowed() {
        runTest("compiler/testData/diagnostics/tests/annotations/ConstructorCallAllowed.kt");
      }

      @Test
      @TestMetadata("contextReceiverAsFunctionImplicitReturnType.kt")
      public void testContextReceiverAsFunctionImplicitReturnType() {
        runTest("compiler/testData/diagnostics/tests/annotations/contextReceiverAsFunctionImplicitReturnType.kt");
      }

      @Test
      @TestMetadata("contextReceiverAsPropertyImplicitReturnType.kt")
      public void testContextReceiverAsPropertyImplicitReturnType() {
        runTest("compiler/testData/diagnostics/tests/annotations/contextReceiverAsPropertyImplicitReturnType.kt");
      }

      @Test
      @TestMetadata("contextReceiverOnClass.kt")
      public void testContextReceiverOnClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/contextReceiverOnClass.kt");
      }

      @Test
      @TestMetadata("contextReceiverOnFunction.kt")
      public void testContextReceiverOnFunction() {
        runTest("compiler/testData/diagnostics/tests/annotations/contextReceiverOnFunction.kt");
      }

      @Test
      @TestMetadata("contextReceiverOnProperty.kt")
      public void testContextReceiverOnProperty() {
        runTest("compiler/testData/diagnostics/tests/annotations/contextReceiverOnProperty.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnFunction.kt")
      public void testCycleAnnotationOnFunction() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnFunction.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnFunctionInsideLocalClass.kt")
      public void testCycleAnnotationOnFunctionInsideLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnFunctionInsideLocalClass.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnFunctionParameterType.kt")
      public void testCycleAnnotationOnFunctionParameterType() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnFunctionParameterType.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnFunctionParameterTypeInsideLocalClass.kt")
      public void testCycleAnnotationOnFunctionParameterTypeInsideLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnFunctionParameterTypeInsideLocalClass.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnFunctionReceiverType.kt")
      public void testCycleAnnotationOnFunctionReceiverType() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnFunctionReceiverType.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnFunctionReceiverTypeInsideLocalClass.kt")
      public void testCycleAnnotationOnFunctionReceiverTypeInsideLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnFunctionReceiverTypeInsideLocalClass.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnProperty.kt")
      public void testCycleAnnotationOnProperty() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnProperty.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnPropertyField.kt")
      public void testCycleAnnotationOnPropertyField() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnPropertyField.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnPropertyFieldInsideLocalClass.kt")
      public void testCycleAnnotationOnPropertyFieldInsideLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnPropertyFieldInsideLocalClass.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnPropertyInsideLocalClass.kt")
      public void testCycleAnnotationOnPropertyInsideLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnPropertyInsideLocalClass.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnPropertyReceiverType.kt")
      public void testCycleAnnotationOnPropertyReceiverType() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnPropertyReceiverType.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnPropertyReceiverTypeInsideLocalClass.kt")
      public void testCycleAnnotationOnPropertyReceiverTypeInsideLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnPropertyReceiverTypeInsideLocalClass.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnReceiverParameterFunction.kt")
      public void testCycleAnnotationOnReceiverParameterFunction() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnReceiverParameterFunction.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnReceiverParameterFunctionInsideLocalClass.kt")
      public void testCycleAnnotationOnReceiverParameterFunctionInsideLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnReceiverParameterFunctionInsideLocalClass.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnReceiverParameterProperty.kt")
      public void testCycleAnnotationOnReceiverParameterProperty() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnReceiverParameterProperty.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnReceiverParameterPropertyInsideLocalClass.kt")
      public void testCycleAnnotationOnReceiverParameterPropertyInsideLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnReceiverParameterPropertyInsideLocalClass.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnTypeParameterFunction.kt")
      public void testCycleAnnotationOnTypeParameterFunction() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnTypeParameterFunction.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnTypeParameterFunctionInsideLocalClass.kt")
      public void testCycleAnnotationOnTypeParameterFunctionInsideLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnTypeParameterFunctionInsideLocalClass.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnTypeParameterProperty.kt")
      public void testCycleAnnotationOnTypeParameterProperty() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnTypeParameterProperty.kt");
      }

      @Test
      @TestMetadata("cycleAnnotationOnTypeParameterPropertyInsideLocalClass.kt")
      public void testCycleAnnotationOnTypeParameterPropertyInsideLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleAnnotationOnTypeParameterPropertyInsideLocalClass.kt");
      }

      @Test
      @TestMetadata("cycleInParameters_after.kt")
      public void testCycleInParameters_after() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleInParameters_after.kt");
      }

      @Test
      @TestMetadata("cycleInParameters_array.kt")
      public void testCycleInParameters_array() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleInParameters_array.kt");
      }

      @Test
      @TestMetadata("cycleInParameters_before.kt")
      public void testCycleInParameters_before() {
        runTest("compiler/testData/diagnostics/tests/annotations/cycleInParameters_before.kt");
      }

      @Test
      @TestMetadata("danglingAnnotation.kt")
      public void testDanglingAnnotation() {
        runTest("compiler/testData/diagnostics/tests/annotations/danglingAnnotation.kt");
      }

      @Test
      @TestMetadata("danglingAnnotationInLocalClass.kt")
      public void testDanglingAnnotationInLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/danglingAnnotationInLocalClass.kt");
      }

      @Test
      @TestMetadata("danglingFileModifierWithNestedDeclarations.kt")
      public void testDanglingFileModifierWithNestedDeclarations() {
        runTest("compiler/testData/diagnostics/tests/annotations/danglingFileModifierWithNestedDeclarations.kt");
      }

      @Test
      @TestMetadata("DanglingInScript.kts")
      public void testDanglingInScript() {
        runTest("compiler/testData/diagnostics/tests/annotations/DanglingInScript.kts");
      }

      @Test
      @TestMetadata("DanglingMixed.kt")
      public void testDanglingMixed() {
        runTest("compiler/testData/diagnostics/tests/annotations/DanglingMixed.kt");
      }

      @Test
      @TestMetadata("DanglingNoBrackets.kt")
      public void testDanglingNoBrackets() {
        runTest("compiler/testData/diagnostics/tests/annotations/DanglingNoBrackets.kt");
      }

      @Test
      @TestMetadata("DanglingWithBrackets.kt")
      public void testDanglingWithBrackets() {
        runTest("compiler/testData/diagnostics/tests/annotations/DanglingWithBrackets.kt");
      }

      @Test
      @TestMetadata("Deprecated.kt")
      public void testDeprecated() {
        runTest("compiler/testData/diagnostics/tests/annotations/Deprecated.kt");
      }

      @Test
      @TestMetadata("deprecatedDanglingFileModifierWithNestedDeclarations.kt")
      public void testDeprecatedDanglingFileModifierWithNestedDeclarations() {
        runTest("compiler/testData/diagnostics/tests/annotations/deprecatedDanglingFileModifierWithNestedDeclarations.kt");
      }

      @Test
      @TestMetadata("DeprecatedInJavaDoc.kt")
      public void testDeprecatedInJavaDoc() {
        runTest("compiler/testData/diagnostics/tests/annotations/DeprecatedInJavaDoc.kt");
      }

      @Test
      @TestMetadata("DeprecationOnAny.kt")
      public void testDeprecationOnAny() {
        runTest("compiler/testData/diagnostics/tests/annotations/DeprecationOnAny.kt");
      }

      @Test
      @TestMetadata("dontReportWarningAboutChangingExecutionOrderForVararg.kt")
      public void testDontReportWarningAboutChangingExecutionOrderForVararg() {
        runTest("compiler/testData/diagnostics/tests/annotations/dontReportWarningAboutChangingExecutionOrderForVararg.kt");
      }

      @Test
      @TestMetadata("extensionFunctionType.kt")
      public void testExtensionFunctionType() {
        runTest("compiler/testData/diagnostics/tests/annotations/extensionFunctionType.kt");
      }

      @Test
      @TestMetadata("forParameterAnnotationResolve.kt")
      public void testForParameterAnnotationResolve() {
        runTest("compiler/testData/diagnostics/tests/annotations/forParameterAnnotationResolve.kt");
      }

      @Test
      @TestMetadata("functionParameterAsImplicitReturnType.kt")
      public void testFunctionParameterAsImplicitReturnType() {
        runTest("compiler/testData/diagnostics/tests/annotations/functionParameterAsImplicitReturnType.kt");
      }

      @Test
      @TestMetadata("illegalRequireKotlinValue.kt")
      public void testIllegalRequireKotlinValue() {
        runTest("compiler/testData/diagnostics/tests/annotations/illegalRequireKotlinValue.kt");
      }

      @Test
      @TestMetadata("illegalSinceKotlinValue.kt")
      public void testIllegalSinceKotlinValue() {
        runTest("compiler/testData/diagnostics/tests/annotations/illegalSinceKotlinValue.kt");
      }

      @Test
      @TestMetadata("inheritFromAnnotationClass.kt")
      public void testInheritFromAnnotationClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/inheritFromAnnotationClass.kt");
      }

      @Test
      @TestMetadata("inheritFromAnnotationClass2.kt")
      public void testInheritFromAnnotationClass2() {
        runTest("compiler/testData/diagnostics/tests/annotations/inheritFromAnnotationClass2.kt");
      }

      @Test
      @TestMetadata("InheritingAnnotationClass.kt")
      public void testInheritingAnnotationClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/InheritingAnnotationClass.kt");
      }

      @Test
      @TestMetadata("initializerWithNestedAnnotation.kt")
      public void testInitializerWithNestedAnnotation() {
        runTest("compiler/testData/diagnostics/tests/annotations/initializerWithNestedAnnotation.kt");
      }

      @Test
      @TestMetadata("initializerWithNestedAnnotationInLocalClass.kt")
      public void testInitializerWithNestedAnnotationInLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/initializerWithNestedAnnotationInLocalClass.kt");
      }

      @Test
      @TestMetadata("invalidTypesInAnnotationConstructor.kt")
      public void testInvalidTypesInAnnotationConstructor() {
        runTest("compiler/testData/diagnostics/tests/annotations/invalidTypesInAnnotationConstructor.kt");
      }

      @Test
      @TestMetadata("javaAnnotationAndJavaClassWithIt.kt")
      public void testJavaAnnotationAndJavaClassWithIt() {
        runTest("compiler/testData/diagnostics/tests/annotations/javaAnnotationAndJavaClassWithIt.kt");
      }

      @Test
      @TestMetadata("JavaAnnotationConstructors.kt")
      public void testJavaAnnotationConstructors() {
        runTest("compiler/testData/diagnostics/tests/annotations/JavaAnnotationConstructors.kt");
      }

      @Test
      @TestMetadata("javaAnnotationWithClassArray.kt")
      public void testJavaAnnotationWithClassArray() {
        runTest("compiler/testData/diagnostics/tests/annotations/javaAnnotationWithClassArray.kt");
      }

      @Test
      @TestMetadata("javaAnnotationWithParameter.kt")
      public void testJavaAnnotationWithParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/javaAnnotationWithParameter.kt");
      }

      @Test
      @TestMetadata("JvmSerializableLambdaAnnotation.kt")
      public void testJvmSerializableLambdaAnnotation() {
        runTest("compiler/testData/diagnostics/tests/annotations/JvmSerializableLambdaAnnotation.kt");
      }

      @Test
      @TestMetadata("kt1860-negative.kt")
      public void testKt1860_negative() {
        runTest("compiler/testData/diagnostics/tests/annotations/kt1860-negative.kt");
      }

      @Test
      @TestMetadata("kt1860-positive.kt")
      public void testKt1860_positive() {
        runTest("compiler/testData/diagnostics/tests/annotations/kt1860-positive.kt");
      }

      @Test
      @TestMetadata("kt1886annotationBody_after.kt")
      public void testKt1886annotationBody_after() {
        runTest("compiler/testData/diagnostics/tests/annotations/kt1886annotationBody_after.kt");
      }

      @Test
      @TestMetadata("kt1886annotationBody_before.kt")
      public void testKt1886annotationBody_before() {
        runTest("compiler/testData/diagnostics/tests/annotations/kt1886annotationBody_before.kt");
      }

      @Test
      @TestMetadata("localImplicitTypeUnavailable.kt")
      public void testLocalImplicitTypeUnavailable() {
        runTest("compiler/testData/diagnostics/tests/annotations/localImplicitTypeUnavailable.kt");
      }

      @Test
      @TestMetadata("missingValOnParameter.kt")
      public void testMissingValOnParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/missingValOnParameter.kt");
      }

      @Test
      @TestMetadata("MultiDeclaration.kt")
      public void testMultiDeclaration() {
        runTest("compiler/testData/diagnostics/tests/annotations/MultiDeclaration.kt");
      }

      @Test
      @TestMetadata("MutuallyRecursivelyAnnotatedGlobalFunction.kt")
      public void testMutuallyRecursivelyAnnotatedGlobalFunction() {
        runTest("compiler/testData/diagnostics/tests/annotations/MutuallyRecursivelyAnnotatedGlobalFunction.kt");
      }

      @Test
      @TestMetadata("nestedAliasWithNestedAnnotation.kt")
      public void testNestedAliasWithNestedAnnotation() {
        runTest("compiler/testData/diagnostics/tests/annotations/nestedAliasWithNestedAnnotation.kt");
      }

      @Test
      @TestMetadata("nestedAliasWithNestedAnnotationInLocalClass.kt")
      public void testNestedAliasWithNestedAnnotationInLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/nestedAliasWithNestedAnnotationInLocalClass.kt");
      }

      @Test
      @TestMetadata("nestedAnnotationOnOuterClassDeclaration.kt")
      public void testNestedAnnotationOnOuterClassDeclaration() {
        runTest("compiler/testData/diagnostics/tests/annotations/nestedAnnotationOnOuterClassDeclaration.kt");
      }

      @Test
      @TestMetadata("nestedClassAsAnnotationParameter.kt")
      public void testNestedClassAsAnnotationParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/nestedClassAsAnnotationParameter.kt");
      }

      @Test
      @TestMetadata("nestedClassAsIsAsAnnotationParameter.kt")
      public void testNestedClassAsIsAsAnnotationParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/nestedClassAsIsAsAnnotationParameter.kt");
      }

      @Test
      @TestMetadata("nestedClassesInAnnotations.kt")
      public void testNestedClassesInAnnotations() {
        runTest("compiler/testData/diagnostics/tests/annotations/nestedClassesInAnnotations.kt");
      }

      @Test
      @TestMetadata("nestedObjectAsAnnotationParameter.kt")
      public void testNestedObjectAsAnnotationParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/nestedObjectAsAnnotationParameter.kt");
      }

      @Test
      @TestMetadata("noNameProperty.kt")
      public void testNoNameProperty() {
        runTest("compiler/testData/diagnostics/tests/annotations/noNameProperty.kt");
      }

      @Test
      @TestMetadata("NonAnnotationClass.kt")
      public void testNonAnnotationClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/NonAnnotationClass.kt");
      }

      @Test
      @TestMetadata("onExpression.kt")
      public void testOnExpression() {
        runTest("compiler/testData/diagnostics/tests/annotations/onExpression.kt");
      }

      @Test
      @TestMetadata("onFunctionParameter.kt")
      public void testOnFunctionParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/onFunctionParameter.kt");
      }

      @Test
      @TestMetadata("onInitializer.kt")
      public void testOnInitializer() {
        runTest("compiler/testData/diagnostics/tests/annotations/onInitializer.kt");
      }

      @Test
      @TestMetadata("onLoops.kt")
      public void testOnLoops() {
        runTest("compiler/testData/diagnostics/tests/annotations/onLoops.kt");
      }

      @Test
      @TestMetadata("onLoopsUnreachable.kt")
      public void testOnLoopsUnreachable() {
        runTest("compiler/testData/diagnostics/tests/annotations/onLoopsUnreachable.kt");
      }

      @Test
      @TestMetadata("onMultiDeclaration.kt")
      public void testOnMultiDeclaration() {
        runTest("compiler/testData/diagnostics/tests/annotations/onMultiDeclaration.kt");
      }

      @Test
      @TestMetadata("OptInWithArrayArgument.kt")
      public void testOptInWithArrayArgument() {
        runTest("compiler/testData/diagnostics/tests/annotations/OptInWithArrayArgument.kt");
      }

      @Test
      @TestMetadata("propagationAnnotationToLocalMemberFunction.kt")
      public void testPropagationAnnotationToLocalMemberFunction() {
        runTest("compiler/testData/diagnostics/tests/annotations/propagationAnnotationToLocalMemberFunction.kt");
      }

      @Test
      @TestMetadata("propagationBetweenLocalMemberProperties.kt")
      public void testPropagationBetweenLocalMemberProperties() {
        runTest("compiler/testData/diagnostics/tests/annotations/propagationBetweenLocalMemberProperties.kt");
      }

      @Test
      @TestMetadata("propagationFromLocalMemberFunctionAnnotation.kt")
      public void testPropagationFromLocalMemberFunctionAnnotation() {
        runTest("compiler/testData/diagnostics/tests/annotations/propagationFromLocalMemberFunctionAnnotation.kt");
      }

      @Test
      @TestMetadata("propagationToLocalMemberProperty.kt")
      public void testPropagationToLocalMemberProperty() {
        runTest("compiler/testData/diagnostics/tests/annotations/propagationToLocalMemberProperty.kt");
      }

      @Test
      @TestMetadata("qualifiedNestedClassAsAnnotationParameter.kt")
      public void testQualifiedNestedClassAsAnnotationParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/qualifiedNestedClassAsAnnotationParameter.kt");
      }

      @Test
      @TestMetadata("qualifiedNestedClassAsIsAsAnnotationParameter.kt")
      public void testQualifiedNestedClassAsIsAsAnnotationParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/qualifiedNestedClassAsIsAsAnnotationParameter.kt");
      }

      @Test
      @TestMetadata("receiverAsFunctionImplicitType.kt")
      public void testReceiverAsFunctionImplicitType() {
        runTest("compiler/testData/diagnostics/tests/annotations/receiverAsFunctionImplicitType.kt");
      }

      @Test
      @TestMetadata("receiverAsPropertyImplicitType.kt")
      public void testReceiverAsPropertyImplicitType() {
        runTest("compiler/testData/diagnostics/tests/annotations/receiverAsPropertyImplicitType.kt");
      }

      @Test
      @TestMetadata("RecursivelyAnnotated.kt")
      public void testRecursivelyAnnotated() {
        runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotated.kt");
      }

      @Test
      @TestMetadata("RecursivelyAnnotatedFunctionParameter.kt")
      public void testRecursivelyAnnotatedFunctionParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedFunctionParameter.kt");
      }

      @Test
      @TestMetadata("RecursivelyAnnotatedGlobalFunction.kt")
      public void testRecursivelyAnnotatedGlobalFunction() {
        runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedGlobalFunction.kt");
      }

      @Test
      @TestMetadata("RecursivelyAnnotatedGlobalProperty.kt")
      public void testRecursivelyAnnotatedGlobalProperty() {
        runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedGlobalProperty.kt");
      }

      @Test
      @TestMetadata("RecursivelyAnnotatedParameter.kt")
      public void testRecursivelyAnnotatedParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedParameter.kt");
      }

      @Test
      @TestMetadata("RecursivelyAnnotatedParameterType.kt")
      public void testRecursivelyAnnotatedParameterType() {
        runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedParameterType.kt");
      }

      @Test
      @TestMetadata("RecursivelyAnnotatedParameterWithAt.kt")
      public void testRecursivelyAnnotatedParameterWithAt() {
        runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedParameterWithAt.kt");
      }

      @Test
      @TestMetadata("RecursivelyAnnotatedProperty.kt")
      public void testRecursivelyAnnotatedProperty() {
        runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedProperty.kt");
      }

      @Test
      @TestMetadata("RecursivelyIncorrectlyAnnotatedParameter.kt")
      public void testRecursivelyIncorrectlyAnnotatedParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyIncorrectlyAnnotatedParameter.kt");
      }

      @Test
      @TestMetadata("referenceOfAnnotatedFunctionInAnnotation.kt")
      public void testReferenceOfAnnotatedFunctionInAnnotation() {
        runTest("compiler/testData/diagnostics/tests/annotations/referenceOfAnnotatedFunctionInAnnotation.kt");
      }

      @Test
      @TestMetadata("requireKotlin.kt")
      public void testRequireKotlin() {
        runTest("compiler/testData/diagnostics/tests/annotations/requireKotlin.kt");
      }

      @Test
      @TestMetadata("RetentionsOfAnnotationWithExpressionTarget_after.kt")
      public void testRetentionsOfAnnotationWithExpressionTarget_after() {
        runTest("compiler/testData/diagnostics/tests/annotations/RetentionsOfAnnotationWithExpressionTarget_after.kt");
      }

      @Test
      @TestMetadata("RetentionsOfAnnotationWithExpressionTarget_before.kt")
      public void testRetentionsOfAnnotationWithExpressionTarget_before() {
        runTest("compiler/testData/diagnostics/tests/annotations/RetentionsOfAnnotationWithExpressionTarget_before.kt");
      }

      @Test
      @TestMetadata("typeAnnotations.kt")
      public void testTypeAnnotations() {
        runTest("compiler/testData/diagnostics/tests/annotations/typeAnnotations.kt");
      }

      @Test
      @TestMetadata("typeArgumentsInAnnotation.kt")
      public void testTypeArgumentsInAnnotation() {
        runTest("compiler/testData/diagnostics/tests/annotations/typeArgumentsInAnnotation.kt");
      }

      @Test
      @TestMetadata("typeParameterAnnotations.kt")
      public void testTypeParameterAnnotations() {
        runTest("compiler/testData/diagnostics/tests/annotations/typeParameterAnnotations.kt");
      }

      @Test
      @TestMetadata("typeParameterAnnotationsInLocalClass.kt")
      public void testTypeParameterAnnotationsInLocalClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/typeParameterAnnotationsInLocalClass.kt");
      }

      @Test
      @TestMetadata("typeParameterAsAnnotation.kt")
      public void testTypeParameterAsAnnotation() {
        runTest("compiler/testData/diagnostics/tests/annotations/typeParameterAsAnnotation.kt");
      }

      @Test
      @TestMetadata("typealiasWithAnnotatedAbstractClass.kt")
      public void testTypealiasWithAnnotatedAbstractClass() {
        runTest("compiler/testData/diagnostics/tests/annotations/typealiasWithAnnotatedAbstractClass.kt");
      }

      @Test
      @TestMetadata("unreachableNestedClassAsAnnotationParameter.kt")
      public void testUnreachableNestedClassAsAnnotationParameter() {
        runTest("compiler/testData/diagnostics/tests/annotations/unreachableNestedClassAsAnnotationParameter.kt");
      }

      @Test
      @TestMetadata("UnresolvedAnnotationOnObject.kt")
      public void testUnresolvedAnnotationOnObject() {
        runTest("compiler/testData/diagnostics/tests/annotations/UnresolvedAnnotationOnObject.kt");
      }

      @Test
      @TestMetadata("unresolvedReferenceRange.kt")
      public void testUnresolvedReferenceRange() {
        runTest("compiler/testData/diagnostics/tests/annotations/unresolvedReferenceRange.kt");
      }

      @Test
      @TestMetadata("WrongAnnotationArgsOnObject.kt")
      public void testWrongAnnotationArgsOnObject() {
        runTest("compiler/testData/diagnostics/tests/annotations/WrongAnnotationArgsOnObject.kt");
      }

      @Test
      @TestMetadata("wrongAnnotationTarget.kt")
      public void testWrongAnnotationTarget() {
        runTest("compiler/testData/diagnostics/tests/annotations/wrongAnnotationTarget.kt");
      }

      @Test
      @TestMetadata("wrongAnnotationTargetAnnotationOrder.kt")
      public void testWrongAnnotationTargetAnnotationOrder() {
        runTest("compiler/testData/diagnostics/tests/annotations/wrongAnnotationTargetAnnotationOrder.kt");
      }

      @Test
      @TestMetadata("wrongAnnotationTargetAnnotationOrderProperSyntax.kt")
      public void testWrongAnnotationTargetAnnotationOrderProperSyntax() {
        runTest("compiler/testData/diagnostics/tests/annotations/wrongAnnotationTargetAnnotationOrderProperSyntax.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant")
      @TestDataPath("$PROJECT_ROOT")
      public class AnnotationParameterMustBeConstant {
        @Test
        public void testAllFilesPresentInAnnotationParameterMustBeConstant() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("annotationConstructorDefaultParameter.kt")
        public void testAnnotationConstructorDefaultParameter() {
          runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/annotationConstructorDefaultParameter.kt");
        }

        @Test
        @TestMetadata("booleanLocalVal.kt")
        public void testBooleanLocalVal() {
          runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/booleanLocalVal.kt");
        }

        @Test
        @TestMetadata("compareAndEquals.kt")
        public void testCompareAndEquals() {
          runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/compareAndEquals.kt");
        }

        @Test
        @TestMetadata("enumConst_after.kt")
        public void testEnumConst_after() {
          runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/enumConst_after.kt");
        }

        @Test
        @TestMetadata("enumConst_before.kt")
        public void testEnumConst_before() {
          runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/enumConst_before.kt");
        }

        @Test
        @TestMetadata("javaProperties.kt")
        public void testJavaProperties() {
          runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/javaProperties.kt");
        }

        @Test
        @TestMetadata("kotlinProperties.kt")
        public void testKotlinProperties() {
          runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/kotlinProperties.kt");
        }

        @Test
        @TestMetadata("lambdaParameter.kt")
        public void testLambdaParameter() {
          runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/lambdaParameter.kt");
        }

        @Test
        @TestMetadata("standaloneInExpression.kt")
        public void testStandaloneInExpression() {
          runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/standaloneInExpression.kt");
        }

        @Test
        @TestMetadata("strings.kt")
        public void testStrings() {
          runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/strings.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/annotations/functionalTypes")
      @TestDataPath("$PROJECT_ROOT")
      public class FunctionalTypes {
        @Test
        public void testAllFilesPresentInFunctionalTypes() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/functionalTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("nonParenthesizedAnnotationsWithoutError.kt")
        public void testNonParenthesizedAnnotationsWithoutError() {
          runTest("compiler/testData/diagnostics/tests/annotations/functionalTypes/nonParenthesizedAnnotationsWithoutError.kt");
        }

        @Test
        @TestMetadata("parameterName.kt")
        public void testParameterName() {
          runTest("compiler/testData/diagnostics/tests/annotations/functionalTypes/parameterName.kt");
        }

        @Test
        @TestMetadata("parenthesizedAnnotations.kt")
        public void testParenthesizedAnnotations() {
          runTest("compiler/testData/diagnostics/tests/annotations/functionalTypes/parenthesizedAnnotations.kt");
        }

        @Test
        @TestMetadata("propagteAnyAnnotations.kt")
        public void testPropagteAnyAnnotations() {
          runTest("compiler/testData/diagnostics/tests/annotations/functionalTypes/propagteAnyAnnotations.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/annotations/options")
      @TestDataPath("$PROJECT_ROOT")
      public class Options {
        @Test
        public void testAllFilesPresentInOptions() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/options"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("annotationAsArg.kt")
        public void testAnnotationAsArg() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/annotationAsArg.kt");
        }

        @Test
        @TestMetadata("annotationAsArgComplex.kt")
        public void testAnnotationAsArgComplex() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/annotationAsArgComplex.kt");
        }

        @Test
        @TestMetadata("assignment.kt")
        public void testAssignment() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/assignment.kt");
        }

        @Test
        @TestMetadata("documented.kt")
        public void testDocumented() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/documented.kt");
        }

        @Test
        @TestMetadata("forParam.kt")
        public void testForParam() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/forParam.kt");
        }

        @Test
        @TestMetadata("functionExpression.kt")
        public void testFunctionExpression() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/functionExpression.kt");
        }

        @Test
        @TestMetadata("functions.kt")
        public void testFunctions() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/functions.kt");
        }

        @Test
        @TestMetadata("javaDocumented.kt")
        public void testJavaDocumented() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/javaDocumented.kt");
        }

        @Test
        @TestMetadata("javaKotlinTargetRetention.kt")
        public void testJavaKotlinTargetRetention() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/javaKotlinTargetRetention.kt");
        }

        @Test
        @TestMetadata("javaKotlinTargetRetentionWithExplicitImport.kt")
        public void testJavaKotlinTargetRetentionWithExplicitImport() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/javaKotlinTargetRetentionWithExplicitImport.kt");
        }

        @Test
        @TestMetadata("javaretention.kt")
        public void testJavaretention() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/javaretention.kt");
        }

        @Test
        @TestMetadata("multiDeclaration.kt")
        public void testMultiDeclaration() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/multiDeclaration.kt");
        }

        @Test
        @TestMetadata("objectLiteral.kt")
        public void testObjectLiteral() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/objectLiteral.kt");
        }

        @Test
        @TestMetadata("prefix.kt")
        public void testPrefix() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/prefix.kt");
        }

        @Test
        @TestMetadata("retention.kt")
        public void testRetention() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/retention.kt");
        }

        @Test
        @TestMetadata("setterParam.kt")
        public void testSetterParam() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/setterParam.kt");
        }

        @Test
        @TestMetadata("target.kt")
        public void testTarget() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/target.kt");
        }

        @Test
        @TestMetadata("unrepeatable.kt")
        public void testUnrepeatable() {
          runTest("compiler/testData/diagnostics/tests/annotations/options/unrepeatable.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/annotations/options/targets")
        @TestDataPath("$PROJECT_ROOT")
        public class Targets {
          @Test
          @TestMetadata("accessors.kt")
          public void testAccessors() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/accessors.kt");
          }

          @Test
          public void testAllFilesPresentInTargets() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/options/targets"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("annotation.kt")
          public void testAnnotation() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/annotation.kt");
          }

          @Test
          @TestMetadata("classifier.kt")
          public void testClassifier() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/classifier.kt");
          }

          @Test
          @TestMetadata("constructor.kt")
          public void testConstructor() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/constructor.kt");
          }

          @Test
          @TestMetadata("empty.kt")
          public void testEmpty() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/empty.kt");
          }

          @Test
          @TestMetadata("expr.kt")
          public void testExpr() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/expr.kt");
          }

          @Test
          @TestMetadata("field.kt")
          public void testField() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/field.kt");
          }

          @Test
          @TestMetadata("file.kt")
          public void testFile() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/file.kt");
          }

          @Test
          @TestMetadata("function.kt")
          public void testFunction() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/function.kt");
          }

          @Test
          @TestMetadata("funtypeargs.kt")
          public void testFuntypeargs() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/funtypeargs.kt");
          }

          @Test
          @TestMetadata("incorrect.kt")
          public void testIncorrect() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/incorrect.kt");
          }

          @Test
          @TestMetadata("init.kt")
          public void testInit() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/init.kt");
          }

          @Test
          @TestMetadata("java.kt")
          public void testJava() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/java.kt");
          }

          @Test
          @TestMetadata("local.kt")
          public void testLocal() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/local.kt");
          }

          @Test
          @TestMetadata("mixedTargeting.kt")
          public void testMixedTargeting() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/mixedTargeting.kt");
          }

          @Test
          @TestMetadata("nested.kt")
          public void testNested() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/nested.kt");
          }

          @Test
          @TestMetadata("property.kt")
          public void testProperty() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/property.kt");
          }

          @Test
          @TestMetadata("returntype.kt")
          public void testReturntype() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/returntype.kt");
          }

          @Test
          @TestMetadata("suppress.kt")
          public void testSuppress() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/suppress.kt");
          }

          @Test
          @TestMetadata("type.kt")
          public void testType() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/type.kt");
          }

          @Test
          @TestMetadata("typeParams.kt")
          public void testTypeParams() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/typeParams.kt");
          }

          @Test
          @TestMetadata("typeargs.kt")
          public void testTypeargs() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/typeargs.kt");
          }

          @Test
          @TestMetadata("valueparam.kt")
          public void testValueparam() {
            runTest("compiler/testData/diagnostics/tests/annotations/options/targets/valueparam.kt");
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/annotations/parameters")
      @TestDataPath("$PROJECT_ROOT")
      public class Parameters {
        @Test
        public void testAllFilesPresentInParameters() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/parameters"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("byte.kt")
        public void testByte() {
          runTest("compiler/testData/diagnostics/tests/annotations/parameters/byte.kt");
        }

        @Test
        @TestMetadata("char.kt")
        public void testChar() {
          runTest("compiler/testData/diagnostics/tests/annotations/parameters/char.kt");
        }

        @Test
        @TestMetadata("double.kt")
        public void testDouble() {
          runTest("compiler/testData/diagnostics/tests/annotations/parameters/double.kt");
        }

        @Test
        @TestMetadata("float.kt")
        public void testFloat() {
          runTest("compiler/testData/diagnostics/tests/annotations/parameters/float.kt");
        }

        @Test
        @TestMetadata("int.kt")
        public void testInt() {
          runTest("compiler/testData/diagnostics/tests/annotations/parameters/int.kt");
        }

        @Test
        @TestMetadata("long.kt")
        public void testLong() {
          runTest("compiler/testData/diagnostics/tests/annotations/parameters/long.kt");
        }

        @Test
        @TestMetadata("short.kt")
        public void testShort() {
          runTest("compiler/testData/diagnostics/tests/annotations/parameters/short.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/annotations/parameters/expressions")
        @TestDataPath("$PROJECT_ROOT")
        public class Expressions {
          @Test
          public void testAllFilesPresentInExpressions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/parameters/expressions"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("andAnd.kt")
          public void testAndAnd() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/andAnd.kt");
          }

          @Test
          @TestMetadata("boolean.kt")
          public void testBoolean() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/boolean.kt");
          }

          @Test
          @TestMetadata("char.kt")
          public void testChar() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/char.kt");
          }

          @Test
          @TestMetadata("compositeCallBinary.kt")
          public void testCompositeCallBinary() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/compositeCallBinary.kt");
          }

          @Test
          @TestMetadata("divide.kt")
          public void testDivide() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/divide.kt");
          }

          @Test
          @TestMetadata("double.kt")
          public void testDouble() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/double.kt");
          }

          @Test
          @TestMetadata("eqeq.kt")
          public void testEqeq() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/eqeq.kt");
          }

          @Test
          @TestMetadata("escapedString.kt")
          public void testEscapedString() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/escapedString.kt");
          }

          @Test
          @TestMetadata("float.kt")
          public void testFloat() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/float.kt");
          }

          @Test
          @TestMetadata("gt.kt")
          public void testGt() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/gt.kt");
          }

          @Test
          @TestMetadata("gteq.kt")
          public void testGteq() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/gteq.kt");
          }

          @Test
          @TestMetadata("intrincics.kt")
          public void testIntrincics() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/intrincics.kt");
          }

          @Test
          @TestMetadata("labeled.kt")
          public void testLabeled() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/labeled.kt");
          }

          @Test
          @TestMetadata("long.kt")
          public void testLong() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/long.kt");
          }

          @Test
          @TestMetadata("lt.kt")
          public void testLt() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/lt.kt");
          }

          @Test
          @TestMetadata("lteq.kt")
          public void testLteq() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/lteq.kt");
          }

          @Test
          @TestMetadata("maxValue.kt")
          public void testMaxValue() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/maxValue.kt");
          }

          @Test
          @TestMetadata("maxValueByte.kt")
          public void testMaxValueByte() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/maxValueByte.kt");
          }

          @Test
          @TestMetadata("maxValueInt.kt")
          public void testMaxValueInt() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/maxValueInt.kt");
          }

          @Test
          @TestMetadata("miltiply.kt")
          public void testMiltiply() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/miltiply.kt");
          }

          @Test
          @TestMetadata("minus.kt")
          public void testMinus() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/minus.kt");
          }

          @Test
          @TestMetadata("mod.kt")
          public void testMod() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/mod.kt");
          }

          @Test
          @TestMetadata("multilineString.kt")
          public void testMultilineString() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/multilineString.kt");
          }

          @Test
          @TestMetadata("not.kt")
          public void testNot() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/not.kt");
          }

          @Test
          @TestMetadata("noteq.kt")
          public void testNoteq() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/noteq.kt");
          }

          @Test
          @TestMetadata("orOr.kt")
          public void testOrOr() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/orOr.kt");
          }

          @Test
          @TestMetadata("paranthesized.kt")
          public void testParanthesized() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/paranthesized.kt");
          }

          @Test
          @TestMetadata("plus.kt")
          public void testPlus() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/plus.kt");
          }

          @Test
          @TestMetadata("simpleCallBinary.kt")
          public void testSimpleCallBinary() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/simpleCallBinary.kt");
          }

          @Test
          @TestMetadata("stringPlusInt.kt")
          public void testStringPlusInt() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/stringPlusInt.kt");
          }

          @Test
          @TestMetadata("stringTemplate.kt")
          public void testStringTemplate() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/stringTemplate.kt");
          }

          @Test
          @TestMetadata("strings.kt")
          public void testStrings() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/strings.kt");
          }

          @Test
          @TestMetadata("unaryMinus.kt")
          public void testUnaryMinus() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/unaryMinus.kt");
          }

          @Test
          @TestMetadata("unaryPlus.kt")
          public void testUnaryPlus() {
            runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/unaryPlus.kt");
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/annotations/rendering")
      @TestDataPath("$PROJECT_ROOT")
      public class Rendering {
        @Test
        public void testAllFilesPresentInRendering() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/rendering"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("cannotOverrideInvisibleMember.kt")
        public void testCannotOverrideInvisibleMember() {
          runTest("compiler/testData/diagnostics/tests/annotations/rendering/cannotOverrideInvisibleMember.kt");
        }

        @Test
        @TestMetadata("conflictingOverloads.kt")
        public void testConflictingOverloads() {
          runTest("compiler/testData/diagnostics/tests/annotations/rendering/conflictingOverloads.kt");
        }

        @Test
        @TestMetadata("differentNamesForParameter.kt")
        public void testDifferentNamesForParameter() {
          runTest("compiler/testData/diagnostics/tests/annotations/rendering/differentNamesForParameter.kt");
        }

        @Test
        @TestMetadata("memberProjectedOut.kt")
        public void testMemberProjectedOut() {
          runTest("compiler/testData/diagnostics/tests/annotations/rendering/memberProjectedOut.kt");
        }

        @Test
        @TestMetadata("multipleInheritedDefaults.kt")
        public void testMultipleInheritedDefaults() {
          runTest("compiler/testData/diagnostics/tests/annotations/rendering/multipleInheritedDefaults.kt");
        }

        @Test
        @TestMetadata("notImplementedMembers.kt")
        public void testNotImplementedMembers() {
          runTest("compiler/testData/diagnostics/tests/annotations/rendering/notImplementedMembers.kt");
        }

        @Test
        @TestMetadata("notImplementedMembersAroundJava.kt")
        public void testNotImplementedMembersAroundJava() {
          runTest("compiler/testData/diagnostics/tests/annotations/rendering/notImplementedMembersAroundJava.kt");
        }

        @Test
        @TestMetadata("tooManyArguments.kt")
        public void testTooManyArguments() {
          runTest("compiler/testData/diagnostics/tests/annotations/rendering/tooManyArguments.kt");
        }

        @Test
        @TestMetadata("typeMismatchDueToTypeProjections.kt")
        public void testTypeMismatchDueToTypeProjections() {
          runTest("compiler/testData/diagnostics/tests/annotations/rendering/typeMismatchDueToTypeProjections.kt");
        }

        @Test
        @TestMetadata("typeMismatchOnOverride.kt")
        public void testTypeMismatchOnOverride() {
          runTest("compiler/testData/diagnostics/tests/annotations/rendering/typeMismatchOnOverride.kt");
        }

        @Test
        @TestMetadata("typeMismatchOnOverrideJavaNullable.kt")
        public void testTypeMismatchOnOverrideJavaNullable() {
          runTest("compiler/testData/diagnostics/tests/annotations/rendering/typeMismatchOnOverrideJavaNullable.kt");
        }

        @Test
        @TestMetadata("unusedValue.kt")
        public void testUnusedValue() {
          runTest("compiler/testData/diagnostics/tests/annotations/rendering/unusedValue.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/annotations/repeatable")
      @TestDataPath("$PROJECT_ROOT")
      public class Repeatable {
        @Test
        public void testAllFilesPresentInRepeatable() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/repeatable"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("containerAndAnnotationAreBothApplied_1_5.kt")
        public void testContainerAndAnnotationAreBothApplied_1_5() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerAndAnnotationAreBothApplied_1_5.kt");
        }

        @Test
        @TestMetadata("containerAndAnnotationAreBothApplied_1_6.kt")
        public void testContainerAndAnnotationAreBothApplied_1_6() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerAndAnnotationAreBothApplied_1_6.kt");
        }

        @Test
        @TestMetadata("containerArguments_1_5.kt")
        public void testContainerArguments_1_5() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerArguments_1_5.kt");
        }

        @Test
        @TestMetadata("containerArguments_1_6.kt")
        public void testContainerArguments_1_6() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerArguments_1_6.kt");
        }

        @Test
        @TestMetadata("containerRetention_1_5.kt")
        public void testContainerRetention_1_5() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerRetention_1_5.kt");
        }

        @Test
        @TestMetadata("containerRetention_1_6.kt")
        public void testContainerRetention_1_6() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerRetention_1_6.kt");
        }

        @Test
        @TestMetadata("containerTarget_1_6.kt")
        public void testContainerTarget_1_6() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerTarget_1_6.kt");
        }

        @Test
        @TestMetadata("javaRepeatableInKotlin.kt")
        public void testJavaRepeatableInKotlin() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/javaRepeatableInKotlin.kt");
        }

        @Test
        @TestMetadata("javaRepeatable_1_5.kt")
        public void testJavaRepeatable_1_5() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/javaRepeatable_1_5.kt");
        }

        @Test
        @TestMetadata("javaRepeatable_1_6.kt")
        public void testJavaRepeatable_1_6() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/javaRepeatable_1_6.kt");
        }

        @Test
        @TestMetadata("javaUnrepeatable_1_5.kt")
        public void testJavaUnrepeatable_1_5() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/javaUnrepeatable_1_5.kt");
        }

        @Test
        @TestMetadata("javaUnrepeatable_1_6.kt")
        public void testJavaUnrepeatable_1_6() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/javaUnrepeatable_1_6.kt");
        }

        @Test
        @TestMetadata("kotlinRepeatable_1_5.kt")
        public void testKotlinRepeatable_1_5() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/kotlinRepeatable_1_5.kt");
        }

        @Test
        @TestMetadata("kotlinRepeatable_1_6.kt")
        public void testKotlinRepeatable_1_6() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/kotlinRepeatable_1_6.kt");
        }

        @Test
        @TestMetadata("nestedClassContainer_1_5.kt")
        public void testNestedClassContainer_1_5() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/nestedClassContainer_1_5.kt");
        }

        @Test
        @TestMetadata("nestedClassContainer_1_6.kt")
        public void testNestedClassContainer_1_6() {
          runTest("compiler/testData/diagnostics/tests/annotations/repeatable/nestedClassContainer_1_6.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/annotations/typeUse")
      @TestDataPath("$PROJECT_ROOT")
      public class TypeUse {
        @Test
        public void testAllFilesPresentInTypeUse() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/typeUse"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("implicitTypeWithInaccessibleAnnotation.kt")
        public void testImplicitTypeWithInaccessibleAnnotation() {
          runTest("compiler/testData/diagnostics/tests/annotations/typeUse/implicitTypeWithInaccessibleAnnotation.kt");
        }

        @Test
        @TestMetadata("kt19455.kt")
        public void testKt19455() {
          runTest("compiler/testData/diagnostics/tests/annotations/typeUse/kt19455.kt");
        }

        @Test
        @TestMetadata("kt25876.kt")
        public void testKt25876() {
          runTest("compiler/testData/diagnostics/tests/annotations/typeUse/kt25876.kt");
        }

        @Test
        @TestMetadata("kt45905.kt")
        public void testKt45905() {
          runTest("compiler/testData/diagnostics/tests/annotations/typeUse/kt45905.kt");
        }

        @Test
        @TestMetadata("kt46173.kt")
        public void testKt46173() {
          runTest("compiler/testData/diagnostics/tests/annotations/typeUse/kt46173.kt");
        }

        @Test
        @TestMetadata("kt47772.kt")
        public void testKt47772() {
          runTest("compiler/testData/diagnostics/tests/annotations/typeUse/kt47772.kt");
        }

        @Test
        @TestMetadata("kt8325.kt")
        public void testKt8325() {
          runTest("compiler/testData/diagnostics/tests/annotations/typeUse/kt8325.kt");
        }

        @Test
        @TestMetadata("nonTypeUseAnnotationOnType.kt")
        public void testNonTypeUseAnnotationOnType() {
          runTest("compiler/testData/diagnostics/tests/annotations/typeUse/nonTypeUseAnnotationOnType.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget")
      @TestDataPath("$PROJECT_ROOT")
      public class WithUseSiteTarget {
        @Test
        public void testAllFilesPresentInWithUseSiteTarget() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("DelegateAnnotations.kt")
        public void testDelegateAnnotations() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/DelegateAnnotations.kt");
        }

        @Test
        @TestMetadata("diagnosticFileAnnotationInWrongPlace.kt")
        public void testDiagnosticFileAnnotationInWrongPlace() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/diagnosticFileAnnotationInWrongPlace.kt");
        }

        @Test
        @TestMetadata("diagnosticWithoutPackage.kt")
        public void testDiagnosticWithoutPackage() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/diagnosticWithoutPackage.kt");
        }

        @Test
        @TestMetadata("diagnosticWithoutPackageWithSimpleAnnotation.kt")
        public void testDiagnosticWithoutPackageWithSimpleAnnotation() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/diagnosticWithoutPackageWithSimpleAnnotation.kt");
        }

        @Test
        @TestMetadata("FieldAnnotations.kt")
        public void testFieldAnnotations() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/FieldAnnotations.kt");
        }

        @Test
        @TestMetadata("fileAnnotationWithoutColon_after.kt")
        public void testFileAnnotationWithoutColon_after() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/fileAnnotationWithoutColon_after.kt");
        }

        @Test
        @TestMetadata("fileAnnotationWithoutColon_before.kt")
        public void testFileAnnotationWithoutColon_before() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/fileAnnotationWithoutColon_before.kt");
        }

        @Test
        @TestMetadata("FileAnnotations.kt")
        public void testFileAnnotations() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/FileAnnotations.kt");
        }

        @Test
        @TestMetadata("GetterAnnotations.kt")
        public void testGetterAnnotations() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/GetterAnnotations.kt");
        }

        @Test
        @TestMetadata("kt23992_after.kt")
        public void testKt23992_after() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/kt23992_after.kt");
        }

        @Test
        @TestMetadata("kt26638_after.kt")
        public void testKt26638_after() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/kt26638_after.kt");
        }

        @Test
        @TestMetadata("ParamAnnotations.kt")
        public void testParamAnnotations() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/ParamAnnotations.kt");
        }

        @Test
        @TestMetadata("prohibitUseSiteGetTargetAnnotationsOff.kt")
        public void testProhibitUseSiteGetTargetAnnotationsOff() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/prohibitUseSiteGetTargetAnnotationsOff.kt");
        }

        @Test
        @TestMetadata("prohibitUseSiteGetTargetAnnotationsOn.kt")
        public void testProhibitUseSiteGetTargetAnnotationsOn() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/prohibitUseSiteGetTargetAnnotationsOn.kt");
        }

        @Test
        @TestMetadata("PropertyAnnotations.kt")
        public void testPropertyAnnotations() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/PropertyAnnotations.kt");
        }

        @Test
        @TestMetadata("propertyTargetOnEnumEntry_error.kt")
        public void testPropertyTargetOnEnumEntry_error() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/propertyTargetOnEnumEntry_error.kt");
        }

        @Test
        @TestMetadata("propertyTargetOnEnumEntry_warning.kt")
        public void testPropertyTargetOnEnumEntry_warning() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/propertyTargetOnEnumEntry_warning.kt");
        }

        @Test
        @TestMetadata("ReceiverAnnotations.kt")
        public void testReceiverAnnotations() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/ReceiverAnnotations.kt");
        }

        @Test
        @TestMetadata("receiverUseSiteTargetOnExtensionFunction_after.kt")
        public void testReceiverUseSiteTargetOnExtensionFunction_after() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/receiverUseSiteTargetOnExtensionFunction_after.kt");
        }

        @Test
        @TestMetadata("receiverUseSiteTargetOnExtensionFunction_before.kt")
        public void testReceiverUseSiteTargetOnExtensionFunction_before() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/receiverUseSiteTargetOnExtensionFunction_before.kt");
        }

        @Test
        @TestMetadata("repeatable.kt")
        public void testRepeatable() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/repeatable.kt");
        }

        @Test
        @TestMetadata("SetterAnnotations.kt")
        public void testSetterAnnotations() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/SetterAnnotations.kt");
        }

        @Test
        @TestMetadata("SparamAnnotations.kt")
        public void testSparamAnnotations() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/SparamAnnotations.kt");
        }

        @Test
        @TestMetadata("wrongParamAnnotationsOnTypesError.kt")
        public void testWrongParamAnnotationsOnTypesError() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/wrongParamAnnotationsOnTypesError.kt");
        }

        @Test
        @TestMetadata("wrongParamAnnotationsOnTypes_after.kt")
        public void testWrongParamAnnotationsOnTypes_after() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/wrongParamAnnotationsOnTypes_after.kt");
        }

        @Test
        @TestMetadata("wrongParamAnnotationsOnTypes_before.kt")
        public void testWrongParamAnnotationsOnTypes_before() {
          runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/wrongParamAnnotationsOnTypes_before.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/backingField")
    @TestDataPath("$PROJECT_ROOT")
    public class BackingField {
      @Test
      public void testAllFilesPresentInBackingField() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/backingField"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("CustomGetSet.kt")
      public void testCustomGetSet() {
        runTest("compiler/testData/diagnostics/tests/backingField/CustomGetSet.kt");
      }

      @Test
      @TestMetadata("CustomGetVal.kt")
      public void testCustomGetVal() {
        runTest("compiler/testData/diagnostics/tests/backingField/CustomGetVal.kt");
      }

      @Test
      @TestMetadata("CustomGetValGlobal.kt")
      public void testCustomGetValGlobal() {
        runTest("compiler/testData/diagnostics/tests/backingField/CustomGetValGlobal.kt");
      }

      @Test
      @TestMetadata("CustomGetVar.kt")
      public void testCustomGetVar() {
        runTest("compiler/testData/diagnostics/tests/backingField/CustomGetVar.kt");
      }

      @Test
      @TestMetadata("CustomSet.kt")
      public void testCustomSet() {
        runTest("compiler/testData/diagnostics/tests/backingField/CustomSet.kt");
      }

      @Test
      @TestMetadata("ExtensionProperty.kt")
      public void testExtensionProperty() {
        runTest("compiler/testData/diagnostics/tests/backingField/ExtensionProperty.kt");
      }

      @Test
      @TestMetadata("FieldAsParam.kt")
      public void testFieldAsParam() {
        runTest("compiler/testData/diagnostics/tests/backingField/FieldAsParam.kt");
      }

      @Test
      @TestMetadata("FieldAsProperty.kt")
      public void testFieldAsProperty() {
        runTest("compiler/testData/diagnostics/tests/backingField/FieldAsProperty.kt");
      }

      @Test
      @TestMetadata("FieldDerived.kt")
      public void testFieldDerived() {
        runTest("compiler/testData/diagnostics/tests/backingField/FieldDerived.kt");
      }

      @Test
      @TestMetadata("FieldInInterface.kt")
      public void testFieldInInterface() {
        runTest("compiler/testData/diagnostics/tests/backingField/FieldInInterface.kt");
      }

      @Test
      @TestMetadata("FieldInLocal.kt")
      public void testFieldInLocal() {
        runTest("compiler/testData/diagnostics/tests/backingField/FieldInLocal.kt");
      }

      @Test
      @TestMetadata("FieldOnVal.kt")
      public void testFieldOnVal() {
        runTest("compiler/testData/diagnostics/tests/backingField/FieldOnVal.kt");
      }

      @Test
      @TestMetadata("FieldOnVar.kt")
      public void testFieldOnVar() {
        runTest("compiler/testData/diagnostics/tests/backingField/FieldOnVar.kt");
      }

      @Test
      @TestMetadata("FieldReassignment_after.kt")
      public void testFieldReassignment_after() {
        runTest("compiler/testData/diagnostics/tests/backingField/FieldReassignment_after.kt");
      }

      @Test
      @TestMetadata("FieldReassignment_before.kt")
      public void testFieldReassignment_before() {
        runTest("compiler/testData/diagnostics/tests/backingField/FieldReassignment_before.kt");
      }

      @Test
      @TestMetadata("FieldShadow.kt")
      public void testFieldShadow() {
        runTest("compiler/testData/diagnostics/tests/backingField/FieldShadow.kt");
      }

      @Test
      @TestMetadata("InitCustomSetter.kt")
      public void testInitCustomSetter() {
        runTest("compiler/testData/diagnostics/tests/backingField/InitCustomSetter.kt");
      }

      @Test
      @TestMetadata("InitOpenSetter.kt")
      public void testInitOpenSetter() {
        runTest("compiler/testData/diagnostics/tests/backingField/InitOpenSetter.kt");
      }

      @Test
      @TestMetadata("kt782packageLevel.kt")
      public void testKt782packageLevel() {
        runTest("compiler/testData/diagnostics/tests/backingField/kt782packageLevel.kt");
      }

      @Test
      @TestMetadata("LocalDeclarations.kt")
      public void testLocalDeclarations() {
        runTest("compiler/testData/diagnostics/tests/backingField/LocalDeclarations.kt");
      }

      @Test
      @TestMetadata("MustBeInitializedEffectivelyFinalOff.kt")
      public void testMustBeInitializedEffectivelyFinalOff() {
        runTest("compiler/testData/diagnostics/tests/backingField/MustBeInitializedEffectivelyFinalOff.kt");
      }

      @Test
      @TestMetadata("MustBeInitializedEffectivelyFinalOn.kt")
      public void testMustBeInitializedEffectivelyFinalOn() {
        runTest("compiler/testData/diagnostics/tests/backingField/MustBeInitializedEffectivelyFinalOn.kt");
      }

      @Test
      @TestMetadata("OpenPrivateValDeferredInit.kt")
      public void testOpenPrivateValDeferredInit() {
        runTest("compiler/testData/diagnostics/tests/backingField/OpenPrivateValDeferredInit.kt");
      }

      @Test
      @TestMetadata("OpenValDeferredInitError_InFinalClass_DisableEffectivelyFinal.kt")
      public void testOpenValDeferredInitError_InFinalClass_DisableEffectivelyFinal() {
        runTest("compiler/testData/diagnostics/tests/backingField/OpenValDeferredInitError_InFinalClass_DisableEffectivelyFinal.kt");
      }

      @Test
      @TestMetadata("OpenValDeferredInitError_InFinalClass_EnableEffectivelyFinal.kt")
      public void testOpenValDeferredInitError_InFinalClass_EnableEffectivelyFinal() {
        runTest("compiler/testData/diagnostics/tests/backingField/OpenValDeferredInitError_InFinalClass_EnableEffectivelyFinal.kt");
      }

      @Test
      @TestMetadata("OpenValDeferredInitWarning_InFinalClass_DisableEffectivelyFinal.kt")
      public void testOpenValDeferredInitWarning_InFinalClass_DisableEffectivelyFinal() {
        runTest("compiler/testData/diagnostics/tests/backingField/OpenValDeferredInitWarning_InFinalClass_DisableEffectivelyFinal.kt");
      }

      @Test
      @TestMetadata("OpenValDeferredInitWarning_InFinalClass_EnableEffectivelyFinal.kt")
      public void testOpenValDeferredInitWarning_InFinalClass_EnableEffectivelyFinal() {
        runTest("compiler/testData/diagnostics/tests/backingField/OpenValDeferredInitWarning_InFinalClass_EnableEffectivelyFinal.kt");
      }

      @Test
      @TestMetadata("OpenValPartialDeferredInitErrorAnyway.kt")
      public void testOpenValPartialDeferredInitErrorAnyway() {
        runTest("compiler/testData/diagnostics/tests/backingField/OpenValPartialDeferredInitErrorAnyway.kt");
      }

      @Test
      @TestMetadata("OpenValPartialDeferredInitSecondaryConstructorErrorAnyway.kt")
      public void testOpenValPartialDeferredInitSecondaryConstructorErrorAnyway() {
        runTest("compiler/testData/diagnostics/tests/backingField/OpenValPartialDeferredInitSecondaryConstructorErrorAnyway.kt");
      }

      @Test
      @TestMetadata("OpenValPartialDeferredInitTwoSecondaryConstructorsErrorAnyway.kt")
      public void testOpenValPartialDeferredInitTwoSecondaryConstructorsErrorAnyway() {
        runTest("compiler/testData/diagnostics/tests/backingField/OpenValPartialDeferredInitTwoSecondaryConstructorsErrorAnyway.kt");
      }

      @Test
      @TestMetadata("SetterWithExplicitType.kt")
      public void testSetterWithExplicitType() {
        runTest("compiler/testData/diagnostics/tests/backingField/SetterWithExplicitType.kt");
      }

      @Test
      @TestMetadata("TopLevelPropertyInitialization.kt")
      public void testTopLevelPropertyInitialization() {
        runTest("compiler/testData/diagnostics/tests/backingField/TopLevelPropertyInitialization.kt");
      }

      @Test
      @TestMetadata("ValDeferredInitInFinalClass.kt")
      public void testValDeferredInitInFinalClass() {
        runTest("compiler/testData/diagnostics/tests/backingField/ValDeferredInitInFinalClass.kt");
      }

      @Test
      @TestMetadata("ValDeferredInitInOpenClassOpenValError.kt")
      public void testValDeferredInitInOpenClassOpenValError() {
        runTest("compiler/testData/diagnostics/tests/backingField/ValDeferredInitInOpenClassOpenValError.kt");
      }

      @Test
      @TestMetadata("ValDeferredInitInOpenClassOpenValWarning.kt")
      public void testValDeferredInitInOpenClassOpenValWarning() {
        runTest("compiler/testData/diagnostics/tests/backingField/ValDeferredInitInOpenClassOpenValWarning.kt");
      }

      @Test
      @TestMetadata("ValWithSetterDeferredInit.kt")
      public void testValWithSetterDeferredInit() {
        runTest("compiler/testData/diagnostics/tests/backingField/ValWithSetterDeferredInit.kt");
      }

      @Test
      @TestMetadata("VarDeferredInitInFinalClass.kt")
      public void testVarDeferredInitInFinalClass() {
        runTest("compiler/testData/diagnostics/tests/backingField/VarDeferredInitInFinalClass.kt");
      }

      @Test
      @TestMetadata("VarDeferredInitInOpenClass.kt")
      public void testVarDeferredInitInOpenClass() {
        runTest("compiler/testData/diagnostics/tests/backingField/VarDeferredInitInOpenClass.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor")
      @TestDataPath("$PROJECT_ROOT")
      public class ProhibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor {
        @Test
        public void testAllFilesPresentInProhibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("implicitPrimaryConstructor_errorAnyway.kt")
        public void testImplicitPrimaryConstructor_errorAnyway() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/implicitPrimaryConstructor_errorAnyway.kt");
        }

        @Test
        @TestMetadata("noPrimary_oneInheritedSecondary_mustBeInitializedError.kt")
        public void testNoPrimary_oneInheritedSecondary_mustBeInitializedError() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_oneInheritedSecondary_mustBeInitializedError.kt");
        }

        @Test
        @TestMetadata("noPrimary_oneInheritedSecondary_mustBeInitializedWarning.kt")
        public void testNoPrimary_oneInheritedSecondary_mustBeInitializedWarning() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_oneInheritedSecondary_mustBeInitializedWarning.kt");
        }

        @Test
        @TestMetadata("noPrimary_oneSecondary_deferredInitInSecondary_mustBeInitializedError.kt")
        public void testNoPrimary_oneSecondary_deferredInitInSecondary_mustBeInitializedError() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_oneSecondary_deferredInitInSecondary_mustBeInitializedError.kt");
        }

        @Test
        @TestMetadata("noPrimary_oneSecondary_deferredInitInSecondary_mustBeInitializedWarning.kt")
        public void testNoPrimary_oneSecondary_deferredInitInSecondary_mustBeInitializedWarning() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_oneSecondary_deferredInitInSecondary_mustBeInitializedWarning.kt");
        }

        @Test
        @TestMetadata("noPrimary_oneSecondary_mustBeInitializedError.kt")
        public void testNoPrimary_oneSecondary_mustBeInitializedError() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_oneSecondary_mustBeInitializedError.kt");
        }

        @Test
        @TestMetadata("noPrimary_oneSecondary_mustBeInitializedWarning.kt")
        public void testNoPrimary_oneSecondary_mustBeInitializedWarning() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_oneSecondary_mustBeInitializedWarning.kt");
        }

        @Test
        @TestMetadata("noPrimary_oneSecondary_openValError_mustBeInitializedError.kt")
        public void testNoPrimary_oneSecondary_openValError_mustBeInitializedError() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_oneSecondary_openValError_mustBeInitializedError.kt");
        }

        @Test
        @TestMetadata("noPrimary_oneSecondary_openValError_mustBeInitializedWarning.kt")
        public void testNoPrimary_oneSecondary_openValError_mustBeInitializedWarning() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_oneSecondary_openValError_mustBeInitializedWarning.kt");
        }

        @Test
        @TestMetadata("noPrimary_oneSecondary_openValWarning_mustBeInitializedError.kt")
        public void testNoPrimary_oneSecondary_openValWarning_mustBeInitializedError() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_oneSecondary_openValWarning_mustBeInitializedError.kt");
        }

        @Test
        @TestMetadata("noPrimary_oneSecondary_openValWarning_mustBeInitializedWarning.kt")
        public void testNoPrimary_oneSecondary_openValWarning_mustBeInitializedWarning() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_oneSecondary_openValWarning_mustBeInitializedWarning.kt");
        }

        @Test
        @TestMetadata("noPrimary_oneSecondary_openVar_mustBeInitializedError.kt")
        public void testNoPrimary_oneSecondary_openVar_mustBeInitializedError() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_oneSecondary_openVar_mustBeInitializedError.kt");
        }

        @Test
        @TestMetadata("noPrimary_oneSecondary_openVar_mustBeInitializedWarning.kt")
        public void testNoPrimary_oneSecondary_openVar_mustBeInitializedWarning() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_oneSecondary_openVar_mustBeInitializedWarning.kt");
        }

        @Test
        @TestMetadata("noPrimary_partialDeferredInitInSecondary_errorAnyway.kt")
        public void testNoPrimary_partialDeferredInitInSecondary_errorAnyway() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_partialDeferredInitInSecondary_errorAnyway.kt");
        }

        @Test
        @TestMetadata("noPrimary_partialDeferredInitInTwoSecondaries_errorAnyway.kt")
        public void testNoPrimary_partialDeferredInitInTwoSecondaries_errorAnyway() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_partialDeferredInitInTwoSecondaries_errorAnyway.kt");
        }

        @Test
        @TestMetadata("noPrimary_twoSecondary_mustBeInitializedError.kt")
        public void testNoPrimary_twoSecondary_mustBeInitializedError() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_twoSecondary_mustBeInitializedError.kt");
        }

        @Test
        @TestMetadata("noPrimary_twoSecondary_mustBeInitializedWarning.kt")
        public void testNoPrimary_twoSecondary_mustBeInitializedWarning() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/noPrimary_twoSecondary_mustBeInitializedWarning.kt");
        }

        @Test
        @TestMetadata("onePrimary_oneSecondary_errorAnyway.kt")
        public void testOnePrimary_oneSecondary_errorAnyway() {
          runTest("compiler/testData/diagnostics/tests/backingField/prohibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor/onePrimary_oneSecondary_errorAnyway.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    public class CallableReference {
      @Test
      public void testAllFilesPresentInCallableReference() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("bareType.kt")
      public void testBareType() {
        runTest("compiler/testData/diagnostics/tests/callableReference/bareType.kt");
      }

      @Test
      @TestMetadata("callableReferenceAsLastExpressionInBlock.kt")
      public void testCallableReferenceAsLastExpressionInBlock() {
        runTest("compiler/testData/diagnostics/tests/callableReference/callableReferenceAsLastExpressionInBlock.kt");
      }

      @Test
      @TestMetadata("callableReferenceAssignmentToVar.kt")
      public void testCallableReferenceAssignmentToVar() {
        runTest("compiler/testData/diagnostics/tests/callableReference/callableReferenceAssignmentToVar.kt");
      }

      @Test
      @TestMetadata("callableReferenceInWhenExpression.kt")
      public void testCallableReferenceInWhenExpression() {
        runTest("compiler/testData/diagnostics/tests/callableReference/callableReferenceInWhenExpression.kt");
      }

      @Test
      @TestMetadata("callableReferenceWithMostSpecificGenericTypeParameter.kt")
      public void testCallableReferenceWithMostSpecificGenericTypeParameter() {
        runTest("compiler/testData/diagnostics/tests/callableReference/callableReferenceWithMostSpecificGenericTypeParameter.kt");
      }

      @Test
      @TestMetadata("callableReferencesToCompanionMembers.kt")
      public void testCallableReferencesToCompanionMembers() {
        runTest("compiler/testData/diagnostics/tests/callableReference/callableReferencesToCompanionMembers.kt");
      }

      @Test
      @TestMetadata("classVsPackage.kt")
      public void testClassVsPackage() {
        runTest("compiler/testData/diagnostics/tests/callableReference/classVsPackage.kt");
      }

      @Test
      @TestMetadata("compatibilityResolveWithVarargAndOperatorCall.kt")
      public void testCompatibilityResolveWithVarargAndOperatorCall() {
        runTest("compiler/testData/diagnostics/tests/callableReference/compatibilityResolveWithVarargAndOperatorCall.kt");
      }

      @Test
      @TestMetadata("constraintFromLHSWithCorrectDirection.kt")
      public void testConstraintFromLHSWithCorrectDirection() {
        runTest("compiler/testData/diagnostics/tests/callableReference/constraintFromLHSWithCorrectDirection.kt");
      }

      @Test
      @TestMetadata("constraintFromLHSWithCorrectDirectionError.kt")
      public void testConstraintFromLHSWithCorrectDirectionError() {
        runTest("compiler/testData/diagnostics/tests/callableReference/constraintFromLHSWithCorrectDirectionError.kt");
      }

      @Test
      @TestMetadata("correctCandidateWithCompatibilityForSeveralCandidates.kt")
      public void testCorrectCandidateWithCompatibilityForSeveralCandidates() {
        runTest("compiler/testData/diagnostics/tests/callableReference/correctCandidateWithCompatibilityForSeveralCandidates.kt");
      }

      @Test
      @TestMetadata("correctInfoAfterArrayLikeCall.kt")
      public void testCorrectInfoAfterArrayLikeCall() {
        runTest("compiler/testData/diagnostics/tests/callableReference/correctInfoAfterArrayLikeCall.kt");
      }

      @Test
      @TestMetadata("deprecateTopLevelReferenceWithCompanionLHS.kt")
      public void testDeprecateTopLevelReferenceWithCompanionLHS() {
        runTest("compiler/testData/diagnostics/tests/callableReference/deprecateTopLevelReferenceWithCompanionLHS.kt");
      }

      @Test
      @TestMetadata("deprecatedCompanionReceiverInParentheses.kt")
      public void testDeprecatedCompanionReceiverInParentheses() {
        runTest("compiler/testData/diagnostics/tests/callableReference/deprecatedCompanionReceiverInParentheses.kt");
      }

      @Test
      @TestMetadata("emptyLhs.kt")
      public void testEmptyLhs() {
        runTest("compiler/testData/diagnostics/tests/callableReference/emptyLhs.kt");
      }

      @Test
      @TestMetadata("expectedTypeAsSubtypeOfFunctionType.kt")
      public void testExpectedTypeAsSubtypeOfFunctionType() {
        runTest("compiler/testData/diagnostics/tests/callableReference/expectedTypeAsSubtypeOfFunctionType.kt");
      }

      @Test
      @TestMetadata("functionReferenceWithDefaultValueAsOtherFunctionType.kt")
      public void testFunctionReferenceWithDefaultValueAsOtherFunctionType() {
        runTest("compiler/testData/diagnostics/tests/callableReference/functionReferenceWithDefaultValueAsOtherFunctionType.kt");
      }

      @Test
      @TestMetadata("functionReferenceWithDefaultValueAsOtherFunctionType_enabled.kt")
      public void testFunctionReferenceWithDefaultValueAsOtherFunctionType_enabled() {
        runTest("compiler/testData/diagnostics/tests/callableReference/functionReferenceWithDefaultValueAsOtherFunctionType_enabled.kt");
      }

      @Test
      @TestMetadata("genericCallWithReferenceAgainstVararg.kt")
      public void testGenericCallWithReferenceAgainstVararg() {
        runTest("compiler/testData/diagnostics/tests/callableReference/genericCallWithReferenceAgainstVararg.kt");
      }

      @Test
      @TestMetadata("genericCallWithReferenceAgainstVarargAndKFunction.kt")
      public void testGenericCallWithReferenceAgainstVarargAndKFunction() {
        runTest("compiler/testData/diagnostics/tests/callableReference/genericCallWithReferenceAgainstVarargAndKFunction.kt");
      }

      @Test
      @TestMetadata("genericTypealiasInLhs.kt")
      public void testGenericTypealiasInLhs() {
        runTest("compiler/testData/diagnostics/tests/callableReference/genericTypealiasInLhs.kt");
      }

      @Test
      @TestMetadata("kt15439_completeCall.kt")
      public void testKt15439_completeCall() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt15439_completeCall.kt");
      }

      @Test
      @TestMetadata("kt25433.kt")
      public void testKt25433() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt25433.kt");
      }

      @Test
      @TestMetadata("kt31981.kt")
      public void testKt31981() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt31981.kt");
      }

      @Test
      @TestMetadata("kt32256.kt")
      public void testKt32256() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt32256.kt");
      }

      @Test
      @TestMetadata("kt32267.kt")
      public void testKt32267() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt32267.kt");
      }

      @Test
      @TestMetadata("kt34314.kt")
      public void testKt34314() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt34314.kt");
      }

      @Test
      @TestMetadata("kt34314_lambda.kt")
      public void testKt34314_lambda() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt34314_lambda.kt");
      }

      @Test
      @TestMetadata("kt35105.kt")
      public void testKt35105() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt35105.kt");
      }

      @Test
      @TestMetadata("kt35959.kt")
      public void testKt35959() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt35959.kt");
      }

      @Test
      @TestMetadata("kt37530.kt")
      public void testKt37530() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt37530.kt");
      }

      @Test
      @TestMetadata("kt46437.kt")
      public void testKt46437() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt46437.kt");
      }

      @Test
      @TestMetadata("kt49038.kt")
      public void testKt49038() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt49038.kt");
      }

      @Test
      @TestMetadata("kt52503.kt")
      public void testKt52503() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt52503.kt");
      }

      @Test
      @TestMetadata("kt55373.kt")
      public void testKt55373() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt55373.kt");
      }

      @Test
      @TestMetadata("kt7430_wrongClassOnLHS.kt")
      public void testKt7430_wrongClassOnLHS() {
        runTest("compiler/testData/diagnostics/tests/callableReference/kt7430_wrongClassOnLHS.kt");
      }

      @Test
      @TestMetadata("lambdaResult.kt")
      public void testLambdaResult() {
        runTest("compiler/testData/diagnostics/tests/callableReference/lambdaResult.kt");
      }

      @Test
      @TestMetadata("memberExtensionsImportedFromObjectsUnsupported.kt")
      public void testMemberExtensionsImportedFromObjectsUnsupported() {
        runTest("compiler/testData/diagnostics/tests/callableReference/memberExtensionsImportedFromObjectsUnsupported.kt");
      }

      @Test
      @TestMetadata("noAmbiguityWhenAllReferencesAreInapplicable.kt")
      public void testNoAmbiguityWhenAllReferencesAreInapplicable() {
        runTest("compiler/testData/diagnostics/tests/callableReference/noAmbiguityWhenAllReferencesAreInapplicable.kt");
      }

      @Test
      @TestMetadata("noCompatibilityResolveWithProressiveModeForNI.kt")
      public void testNoCompatibilityResolveWithProressiveModeForNI() {
        runTest("compiler/testData/diagnostics/tests/callableReference/noCompatibilityResolveWithProressiveModeForNI.kt");
      }

      @Test
      @TestMetadata("noExceptionOnRedCodeWithArrayLikeCall.kt")
      public void testNoExceptionOnRedCodeWithArrayLikeCall() {
        runTest("compiler/testData/diagnostics/tests/callableReference/noExceptionOnRedCodeWithArrayLikeCall.kt");
      }

      @Test
      @TestMetadata("overloadResolutionWithDefaults.kt")
      public void testOverloadResolutionWithDefaults() {
        runTest("compiler/testData/diagnostics/tests/callableReference/overloadResolutionWithDefaults.kt");
      }

      @Test
      @TestMetadata("packageInLhs.kt")
      public void testPackageInLhs() {
        runTest("compiler/testData/diagnostics/tests/callableReference/packageInLhs.kt");
      }

      @Test
      @TestMetadata("parsingPriorityOfGenericArgumentsVsLess.kt")
      public void testParsingPriorityOfGenericArgumentsVsLess() {
        runTest("compiler/testData/diagnostics/tests/callableReference/parsingPriorityOfGenericArgumentsVsLess.kt");
      }

      @Test
      @TestMetadata("propertyOfNestedGenericClass.kt")
      public void testPropertyOfNestedGenericClass() {
        runTest("compiler/testData/diagnostics/tests/callableReference/propertyOfNestedGenericClass.kt");
      }

      @Test
      @TestMetadata("referenceAdaptationCompatibility.kt")
      public void testReferenceAdaptationCompatibility() {
        runTest("compiler/testData/diagnostics/tests/callableReference/referenceAdaptationCompatibility.kt");
      }

      @Test
      @TestMetadata("referenceInCycleInProperties.kt")
      public void testReferenceInCycleInProperties() {
        runTest("compiler/testData/diagnostics/tests/callableReference/referenceInCycleInProperties.kt");
      }

      @Test
      @TestMetadata("referenceToCompanionObjectMemberViaClassName.kt")
      public void testReferenceToCompanionObjectMemberViaClassName() {
        runTest("compiler/testData/diagnostics/tests/callableReference/referenceToCompanionObjectMemberViaClassName.kt");
      }

      @Test
      @TestMetadata("referenceToCompanionObjectMemberViaClassNameCompatibility.kt")
      public void testReferenceToCompanionObjectMemberViaClassNameCompatibility() {
        runTest("compiler/testData/diagnostics/tests/callableReference/referenceToCompanionObjectMemberViaClassNameCompatibility.kt");
      }

      @Test
      @TestMetadata("rewriteAtSliceOnGetOperator.kt")
      public void testRewriteAtSliceOnGetOperator() {
        runTest("compiler/testData/diagnostics/tests/callableReference/rewriteAtSliceOnGetOperator.kt");
      }

      @Test
      @TestMetadata("sam.kt")
      public void testSam() {
        runTest("compiler/testData/diagnostics/tests/callableReference/sam.kt");
      }

      @Test
      @TestMetadata("subtypeArgumentFromRHSForReference.kt")
      public void testSubtypeArgumentFromRHSForReference() {
        runTest("compiler/testData/diagnostics/tests/callableReference/subtypeArgumentFromRHSForReference.kt");
      }

      @Test
      @TestMetadata("suspendCallableReference.kt")
      public void testSuspendCallableReference() {
        runTest("compiler/testData/diagnostics/tests/callableReference/suspendCallableReference.kt");
      }

      @Test
      @TestMetadata("typealiases.kt")
      public void testTypealiases() {
        runTest("compiler/testData/diagnostics/tests/callableReference/typealiases.kt");
      }

      @Test
      @TestMetadata("unitAdaptationForReferenceCompatibility.kt")
      public void testUnitAdaptationForReferenceCompatibility() {
        runTest("compiler/testData/diagnostics/tests/callableReference/unitAdaptationForReferenceCompatibility.kt");
      }

      @Test
      @TestMetadata("unused.kt")
      public void testUnused() {
        runTest("compiler/testData/diagnostics/tests/callableReference/unused.kt");
      }

      @Test
      @TestMetadata("whitespacesInExpression.kt")
      public void testWhitespacesInExpression() {
        runTest("compiler/testData/diagnostics/tests/callableReference/whitespacesInExpression.kt");
      }

      @Test
      @TestMetadata("withQuestionMarks.kt")
      public void testWithQuestionMarks() {
        runTest("compiler/testData/diagnostics/tests/callableReference/withQuestionMarks.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/callableReference/adapted")
      @TestDataPath("$PROJECT_ROOT")
      public class Adapted {
        @Test
        @TestMetadata("adaptationByExpectTypeOutsideCall.kt")
        public void testAdaptationByExpectTypeOutsideCall() {
          runTest("compiler/testData/diagnostics/tests/callableReference/adapted/adaptationByExpectTypeOutsideCall.kt");
        }

        @Test
        @TestMetadata("adaptationInWhenWithMapOf.kt")
        public void testAdaptationInWhenWithMapOf() {
          runTest("compiler/testData/diagnostics/tests/callableReference/adapted/adaptationInWhenWithMapOf.kt");
        }

        @Test
        @TestMetadata("adaptationToOverridenWithoutDefault.kt")
        public void testAdaptationToOverridenWithoutDefault() {
          runTest("compiler/testData/diagnostics/tests/callableReference/adapted/adaptationToOverridenWithoutDefault.kt");
        }

        @Test
        public void testAllFilesPresentInAdapted() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/adapted"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("noKFunctionForAdaptation.kt")
        public void testNoKFunctionForAdaptation() {
          runTest("compiler/testData/diagnostics/tests/callableReference/adapted/noKFunctionForAdaptation.kt");
        }

        @Test
        @TestMetadata("simpleAdaptationOutsideOfCall.kt")
        public void testSimpleAdaptationOutsideOfCall() {
          runTest("compiler/testData/diagnostics/tests/callableReference/adapted/simpleAdaptationOutsideOfCall.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/callableReference/bound")
      @TestDataPath("$PROJECT_ROOT")
      public class Bound {
        @Test
        public void testAllFilesPresentInBound() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/bound"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("classVsStarImportedCompanion.kt")
        public void testClassVsStarImportedCompanion() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/classVsStarImportedCompanion.kt");
        }

        @Test
        @TestMetadata("classVsStarImportedObject.kt")
        public void testClassVsStarImportedObject() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/classVsStarImportedObject.kt");
        }

        @Test
        @TestMetadata("companionObject.kt")
        public void testCompanionObject() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/companionObject.kt");
        }

        @Test
        @TestMetadata("controlFlow.kt")
        public void testControlFlow() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/controlFlow.kt");
        }

        @Test
        @TestMetadata("dataFlow.kt")
        public void testDataFlow() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/dataFlow.kt");
        }

        @Test
        @TestMetadata("expectedType.kt")
        public void testExpectedType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/expectedType.kt");
        }

        @Test
        @TestMetadata("expressionWithNullableType.kt")
        public void testExpressionWithNullableType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/expressionWithNullableType.kt");
        }

        @Test
        @TestMetadata("functionCallWithoutArguments.kt")
        public void testFunctionCallWithoutArguments() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/functionCallWithoutArguments.kt");
        }

        @Test
        @TestMetadata("innerNested.kt")
        public void testInnerNested() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/innerNested.kt");
        }

        @Test
        @TestMetadata("kt12843.kt")
        public void testKt12843() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/kt12843.kt");
        }

        @Test
        @TestMetadata("noThisInSuperCall.kt")
        public void testNoThisInSuperCall() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/noThisInSuperCall.kt");
        }

        @Test
        @TestMetadata("object.kt")
        public void testObject() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/object.kt");
        }

        @Test
        @TestMetadata("privateToThis.kt")
        public void testPrivateToThis() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/privateToThis.kt");
        }

        @Test
        @TestMetadata("referenceToStaticMethodOnInstance.kt")
        public void testReferenceToStaticMethodOnInstance() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/referenceToStaticMethodOnInstance.kt");
        }

        @Test
        @TestMetadata("reservedExpressionSyntax.kt")
        public void testReservedExpressionSyntax() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/reservedExpressionSyntax.kt");
        }

        @Test
        @TestMetadata("reservedExpressionSyntax2.kt")
        public void testReservedExpressionSyntax2() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/reservedExpressionSyntax2.kt");
        }

        @Test
        @TestMetadata("reservedExpressionSyntax3.kt")
        public void testReservedExpressionSyntax3() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/reservedExpressionSyntax3.kt");
        }

        @Test
        @TestMetadata("reservedExpressionSyntax4.kt")
        public void testReservedExpressionSyntax4() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/reservedExpressionSyntax4.kt");
        }

        @Test
        @TestMetadata("syntheticExtensionOnLHS.kt")
        public void testSyntheticExtensionOnLHS() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/syntheticExtensionOnLHS.kt");
        }

        @Test
        @TestMetadata("valueOfTypeParameterType.kt")
        public void testValueOfTypeParameterType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/bound/valueOfTypeParameterType.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/callableReference/function")
      @TestDataPath("$PROJECT_ROOT")
      public class Function {
        @Test
        @TestMetadata("abstractClassConstructors.kt")
        public void testAbstractClassConstructors() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/abstractClassConstructors.kt");
        }

        @Test
        public void testAllFilesPresentInFunction() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/function"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("ambiguityTopLevelVsTopLevel.kt")
        public void testAmbiguityTopLevelVsTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/ambiguityTopLevelVsTopLevel.kt");
        }

        @Test
        @TestMetadata("ambiguityTopLevelVsTopLevelGeneric.kt")
        public void testAmbiguityTopLevelVsTopLevelGeneric() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/ambiguityTopLevelVsTopLevelGeneric.kt");
        }

        @Test
        @TestMetadata("annotationClassConstructor.kt")
        public void testAnnotationClassConstructor() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/annotationClassConstructor.kt");
        }

        @Test
        @TestMetadata("callableRefrenceOnNestedObject.kt")
        public void testCallableRefrenceOnNestedObject() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/callableRefrenceOnNestedObject.kt");
        }

        @Test
        @TestMetadata("classMemberVsConstructorLikeFunction.kt")
        public void testClassMemberVsConstructorLikeFunction() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/classMemberVsConstructorLikeFunction.kt");
        }

        @Test
        @TestMetadata("constructorFromClass.kt")
        public void testConstructorFromClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromClass.kt");
        }

        @Test
        @TestMetadata("constructorFromCompanion.kt")
        public void testConstructorFromCompanion() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromCompanion.kt");
        }

        @Test
        @TestMetadata("constructorFromExtension.kt")
        public void testConstructorFromExtension() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromExtension.kt");
        }

        @Test
        @TestMetadata("constructorFromExtensionInClass.kt")
        public void testConstructorFromExtensionInClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromExtensionInClass.kt");
        }

        @Test
        @TestMetadata("constructorFromTopLevel.kt")
        public void testConstructorFromTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromTopLevel.kt");
        }

        @Test
        @TestMetadata("constructorOfNestedClassInObject.kt")
        public void testConstructorOfNestedClassInObject() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorOfNestedClassInObject.kt");
        }

        @Test
        @TestMetadata("differentPackageClass.kt")
        public void testDifferentPackageClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/differentPackageClass.kt");
        }

        @Test
        @TestMetadata("differentPackageExtension.kt")
        public void testDifferentPackageExtension() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/differentPackageExtension.kt");
        }

        @Test
        @TestMetadata("differentPackageTopLevel.kt")
        public void testDifferentPackageTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/differentPackageTopLevel.kt");
        }

        @Test
        @TestMetadata("empty.kt")
        public void testEmpty() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/empty.kt");
        }

        @Test
        @TestMetadata("extensionFromTopLevel.kt")
        public void testExtensionFromTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/extensionFromTopLevel.kt");
        }

        @Test
        @TestMetadata("extensionInClassDisallowed.kt")
        public void testExtensionInClassDisallowed() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/extensionInClassDisallowed.kt");
        }

        @Test
        @TestMetadata("extensionOnNullable.kt")
        public void testExtensionOnNullable() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/extensionOnNullable.kt");
        }

        @Test
        @TestMetadata("extensionToSupertype.kt")
        public void testExtensionToSupertype() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/extensionToSupertype.kt");
        }

        @Test
        @TestMetadata("fakeOverrideType.kt")
        public void testFakeOverrideType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/fakeOverrideType.kt");
        }

        @Test
        @TestMetadata("genericClassFromTopLevel.kt")
        public void testGenericClassFromTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/genericClassFromTopLevel.kt");
        }

        @Test
        @TestMetadata("importedInnerConstructor.kt")
        public void testImportedInnerConstructor() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/importedInnerConstructor.kt");
        }

        @Test
        @TestMetadata("innerConstructorFromClass.kt")
        public void testInnerConstructorFromClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/innerConstructorFromClass.kt");
        }

        @Test
        @TestMetadata("innerConstructorFromExtension.kt")
        public void testInnerConstructorFromExtension() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/innerConstructorFromExtension.kt");
        }

        @Test
        @TestMetadata("innerConstructorFromTopLevel.kt")
        public void testInnerConstructorFromTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/innerConstructorFromTopLevel.kt");
        }

        @Test
        @TestMetadata("javaStaticMethod.kt")
        public void testJavaStaticMethod() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/javaStaticMethod.kt");
        }

        @Test
        @TestMetadata("lhsNotAClass.kt")
        public void testLhsNotAClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/lhsNotAClass.kt");
        }

        @Test
        @TestMetadata("localConstructor.kt")
        public void testLocalConstructor() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/localConstructor.kt");
        }

        @Test
        @TestMetadata("localConstructorFromExtensionInLocalClass.kt")
        public void testLocalConstructorFromExtensionInLocalClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/localConstructorFromExtensionInLocalClass.kt");
        }

        @Test
        @TestMetadata("localConstructorFromLocalClass.kt")
        public void testLocalConstructorFromLocalClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/localConstructorFromLocalClass.kt");
        }

        @Test
        @TestMetadata("localConstructorFromLocalExtension.kt")
        public void testLocalConstructorFromLocalExtension() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/localConstructorFromLocalExtension.kt");
        }

        @Test
        @TestMetadata("localNamedFun.kt")
        public void testLocalNamedFun() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/localNamedFun.kt");
        }

        @Test
        @TestMetadata("localNamedFunFromExtensionInLocalClass.kt")
        public void testLocalNamedFunFromExtensionInLocalClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/localNamedFunFromExtensionInLocalClass.kt");
        }

        @Test
        @TestMetadata("localNamedFunFromLocalClass.kt")
        public void testLocalNamedFunFromLocalClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/localNamedFunFromLocalClass.kt");
        }

        @Test
        @TestMetadata("localNamedFunFromLocalExtension.kt")
        public void testLocalNamedFunFromLocalExtension() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/localNamedFunFromLocalExtension.kt");
        }

        @Test
        @TestMetadata("longQualifiedName.kt")
        public void testLongQualifiedName() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/longQualifiedName.kt");
        }

        @Test
        @TestMetadata("longQualifiedNameGeneric.kt")
        public void testLongQualifiedNameGeneric() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/longQualifiedNameGeneric.kt");
        }

        @Test
        @TestMetadata("memberFromTopLevel.kt")
        public void testMemberFromTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/memberFromTopLevel.kt");
        }

        @Test
        @TestMetadata("nestedConstructorFromClass.kt")
        public void testNestedConstructorFromClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/nestedConstructorFromClass.kt");
        }

        @Test
        @TestMetadata("nestedConstructorFromExtension.kt")
        public void testNestedConstructorFromExtension() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/nestedConstructorFromExtension.kt");
        }

        @Test
        @TestMetadata("nestedConstructorFromTopLevel.kt")
        public void testNestedConstructorFromTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/nestedConstructorFromTopLevel.kt");
        }

        @Test
        @TestMetadata("noAmbiguityLocalVsTopLevel.kt")
        public void testNoAmbiguityLocalVsTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/noAmbiguityLocalVsTopLevel.kt");
        }

        @Test
        @TestMetadata("noAmbiguityMemberVsExtension.kt")
        public void testNoAmbiguityMemberVsExtension() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/noAmbiguityMemberVsExtension.kt");
        }

        @Test
        @TestMetadata("noAmbiguityMemberVsTopLevel.kt")
        public void testNoAmbiguityMemberVsTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/noAmbiguityMemberVsTopLevel.kt");
        }

        @Test
        @TestMetadata("privateStaticAndPublicMember.kt")
        public void testPrivateStaticAndPublicMember() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/privateStaticAndPublicMember.kt");
        }

        @Test
        @TestMetadata("renameOnImport.kt")
        public void testRenameOnImport() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/renameOnImport.kt");
        }

        @Test
        @TestMetadata("topLevelFromClass.kt")
        public void testTopLevelFromClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromClass.kt");
        }

        @Test
        @TestMetadata("topLevelFromExtension.kt")
        public void testTopLevelFromExtension() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromExtension.kt");
        }

        @Test
        @TestMetadata("topLevelFromExtensionInClass.kt")
        public void testTopLevelFromExtensionInClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromExtensionInClass.kt");
        }

        @Test
        @TestMetadata("topLevelFromTopLevel.kt")
        public void testTopLevelFromTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromTopLevel.kt");
        }

        @Test
        @TestMetadata("unresolved.kt")
        public void testUnresolved() {
          runTest("compiler/testData/diagnostics/tests/callableReference/function/unresolved.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/callableReference/generic")
      @TestDataPath("$PROJECT_ROOT")
      public class Generic {
        @Test
        public void testAllFilesPresentInGeneric() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/generic"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("argumentAndReturnExpectedType.kt")
        public void testArgumentAndReturnExpectedType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/argumentAndReturnExpectedType.kt");
        }

        @Test
        @TestMetadata("argumentExpectedType.kt")
        public void testArgumentExpectedType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/argumentExpectedType.kt");
        }

        @Test
        @TestMetadata("boundViolated.kt")
        public void testBoundViolated() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/boundViolated.kt");
        }

        @Test
        @TestMetadata("dependOnArgumentType.kt")
        public void testDependOnArgumentType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/dependOnArgumentType.kt");
        }

        @Test
        @TestMetadata("expectedFunctionType.kt")
        public void testExpectedFunctionType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/expectedFunctionType.kt");
        }

        @Test
        @TestMetadata("explicitTypeArguments.kt")
        public void testExplicitTypeArguments() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/explicitTypeArguments.kt");
        }

        @Test
        @TestMetadata("genericExtensionFunction.kt")
        public void testGenericExtensionFunction() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/genericExtensionFunction.kt");
        }

        @Test
        @TestMetadata("genericFunctionsWithNullableTypes.kt")
        public void testGenericFunctionsWithNullableTypes() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/genericFunctionsWithNullableTypes.kt");
        }

        @Test
        @TestMetadata("incorrectNumberOfTypeArguments.kt")
        public void testIncorrectNumberOfTypeArguments() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/incorrectNumberOfTypeArguments.kt");
        }

        @Test
        @TestMetadata("kt10968.kt")
        public void testKt10968() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt10968.kt");
        }

        @Test
        @TestMetadata("kt11075.kt")
        public void testKt11075() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt11075.kt");
        }

        @Test
        @TestMetadata("kt12286.kt")
        public void testKt12286() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt12286.kt");
        }

        @Test
        @TestMetadata("kt35896.kt")
        public void testKt35896() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt35896.kt");
        }

        @Test
        @TestMetadata("kt7470.kt")
        public void testKt7470() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt7470.kt");
        }

        @Test
        @TestMetadata("localClassWithCapturedTypeParameters.kt")
        public void testLocalClassWithCapturedTypeParameters() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/localClassWithCapturedTypeParameters.kt");
        }

        @Test
        @TestMetadata("nestedCallWithOverload.kt")
        public void testNestedCallWithOverload() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/nestedCallWithOverload.kt");
        }

        @Test
        @TestMetadata("resolutionGenericCallableWithNullableTypes.kt")
        public void testResolutionGenericCallableWithNullableTypes() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/resolutionGenericCallableWithNullableTypes.kt");
        }

        @Test
        @TestMetadata("resolutionWithGenericCallable.kt")
        public void testResolutionWithGenericCallable() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/resolutionWithGenericCallable.kt");
        }

        @Test
        @TestMetadata("specialCalls.kt")
        public void testSpecialCalls() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/specialCalls.kt");
        }

        @Test
        @TestMetadata("withExpectedGenericJavaFunction.kt")
        public void testWithExpectedGenericJavaFunction() {
          runTest("compiler/testData/diagnostics/tests/callableReference/generic/withExpectedGenericJavaFunction.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/callableReference/property")
      @TestDataPath("$PROJECT_ROOT")
      public class Property {
        @Test
        @TestMetadata("abstractPropertyViaSubclasses.kt")
        public void testAbstractPropertyViaSubclasses() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/abstractPropertyViaSubclasses.kt");
        }

        @Test
        @TestMetadata("accessViaSubclass.kt")
        public void testAccessViaSubclass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/accessViaSubclass.kt");
        }

        @Test
        public void testAllFilesPresentInProperty() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/property"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("backingField.kt")
        public void testBackingField() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/backingField.kt");
        }

        @Test
        @TestMetadata("classFromClass.kt")
        public void testClassFromClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/classFromClass.kt");
        }

        @Test
        @TestMetadata("extensionFromTopLevel.kt")
        public void testExtensionFromTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/extensionFromTopLevel.kt");
        }

        @Test
        @TestMetadata("extensionPropertyOnNullable.kt")
        public void testExtensionPropertyOnNullable() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/extensionPropertyOnNullable.kt");
        }

        @Test
        @TestMetadata("extensionsSameName.kt")
        public void testExtensionsSameName() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/extensionsSameName.kt");
        }

        @Test
        @TestMetadata("genericClass.kt")
        public void testGenericClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/genericClass.kt");
        }

        @Test
        @TestMetadata("javaInstanceField.kt")
        public void testJavaInstanceField() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/javaInstanceField.kt");
        }

        @Test
        @TestMetadata("javaStaticFieldViaImport.kt")
        public void testJavaStaticFieldViaImport() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/javaStaticFieldViaImport.kt");
        }

        @Test
        @TestMetadata("kt7564.kt")
        public void testKt7564() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/kt7564.kt");
        }

        @Test
        @TestMetadata("kt7945_unrelatedClass.kt")
        public void testKt7945_unrelatedClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/kt7945_unrelatedClass.kt");
        }

        @Test
        @TestMetadata("memberFromTopLevel.kt")
        public void testMemberFromTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/memberFromTopLevel.kt");
        }

        @Test
        @TestMetadata("mutablePropertyViaDelegation.kt")
        public void testMutablePropertyViaDelegation() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/mutablePropertyViaDelegation.kt");
        }

        @Test
        @TestMetadata("propertyFromAbstractSuperClass.kt")
        public void testPropertyFromAbstractSuperClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/propertyFromAbstractSuperClass.kt");
        }

        @Test
        @TestMetadata("protectedVarFromClass.kt")
        public void testProtectedVarFromClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/protectedVarFromClass.kt");
        }

        @Test
        @TestMetadata("returnTypeDependentOnGenericProperty.kt")
        public void testReturnTypeDependentOnGenericProperty() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/returnTypeDependentOnGenericProperty.kt");
        }

        @Test
        @TestMetadata("samePriorityForFunctionsAndProperties.kt")
        public void testSamePriorityForFunctionsAndProperties() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/samePriorityForFunctionsAndProperties.kt");
        }

        @Test
        @TestMetadata("topLevelFromTopLevel.kt")
        public void testTopLevelFromTopLevel() {
          runTest("compiler/testData/diagnostics/tests/callableReference/property/topLevelFromTopLevel.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/callableReference/resolve")
      @TestDataPath("$PROJECT_ROOT")
      public class Resolve {
        @Test
        @TestMetadata("adaptedReferenceAgainstKCallable.kt")
        public void testAdaptedReferenceAgainstKCallable() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/adaptedReferenceAgainstKCallable.kt");
        }

        @Test
        @TestMetadata("adaptedReferenceAgainstReflectionType.kt")
        public void testAdaptedReferenceAgainstReflectionType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/adaptedReferenceAgainstReflectionType.kt");
        }

        @Test
        public void testAllFilesPresentInResolve() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/resolve"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("ambiguityWhenNoApplicableCallableReferenceCandidate.kt")
        public void testAmbiguityWhenNoApplicableCallableReferenceCandidate() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/ambiguityWhenNoApplicableCallableReferenceCandidate.kt");
        }

        @Test
        @TestMetadata("ambiguityWithBoundExtensionReceiver.kt")
        public void testAmbiguityWithBoundExtensionReceiver() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/ambiguityWithBoundExtensionReceiver.kt");
        }

        @Test
        @TestMetadata("ambiguousWithVararg.kt")
        public void testAmbiguousWithVararg() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/ambiguousWithVararg.kt");
        }

        @Test
        @TestMetadata("applicableCallableReferenceFromDistantScope.kt")
        public void testApplicableCallableReferenceFromDistantScope() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/applicableCallableReferenceFromDistantScope.kt");
        }

        @Test
        @TestMetadata("byArgType.kt")
        public void testByArgType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/byArgType.kt");
        }

        @Test
        @TestMetadata("byGenericArgType.kt")
        public void testByGenericArgType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/byGenericArgType.kt");
        }

        @Test
        @TestMetadata("byValType.kt")
        public void testByValType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/byValType.kt");
        }

        @Test
        @TestMetadata("callableReferenceToVarargWithOverload.kt")
        public void testCallableReferenceToVarargWithOverload() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/callableReferenceToVarargWithOverload.kt");
        }

        @Test
        @TestMetadata("chooseCallableReferenceDependingOnInferredReceiver.kt")
        public void testChooseCallableReferenceDependingOnInferredReceiver() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/chooseCallableReferenceDependingOnInferredReceiver.kt");
        }

        @Test
        @TestMetadata("chooseMostSpecificCandidateUsingCandidateDescriptorNotReflectionType.kt")
        public void testChooseMostSpecificCandidateUsingCandidateDescriptorNotReflectionType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/chooseMostSpecificCandidateUsingCandidateDescriptorNotReflectionType.kt");
        }

        @Test
        @TestMetadata("chooseOuterCallBySingleCallableReference.kt")
        public void testChooseOuterCallBySingleCallableReference() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/chooseOuterCallBySingleCallableReference.kt");
        }

        @Test
        @TestMetadata("commonSupertypeFromReturnTypesOfCallableReference.kt")
        public void testCommonSupertypeFromReturnTypesOfCallableReference() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/commonSupertypeFromReturnTypesOfCallableReference.kt");
        }

        @Test
        @TestMetadata("compatibilityWarningOnReferenceAgainstReflectiveType.kt")
        public void testCompatibilityWarningOnReferenceAgainstReflectiveType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/compatibilityWarningOnReferenceAgainstReflectiveType.kt");
        }

        @Test
        @TestMetadata("constructor.kt")
        public void testConstructor() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/constructor.kt");
        }

        @Test
        @TestMetadata("eagerAndPostponedCallableReferences.kt")
        public void testEagerAndPostponedCallableReferences() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/eagerAndPostponedCallableReferences.kt");
        }

        @Test
        @TestMetadata("eagerResolveOfSingleCallableReference.kt")
        public void testEagerResolveOfSingleCallableReference() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/eagerResolveOfSingleCallableReference.kt");
        }

        @Test
        @TestMetadata("innerClassConstructorOnOuterClassInstance.kt")
        public void testInnerClassConstructorOnOuterClassInstance() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/innerClassConstructorOnOuterClassInstance.kt");
        }

        @Test
        @TestMetadata("intersectionTypeOverloadWithWrongParameter.kt")
        public void testIntersectionTypeOverloadWithWrongParameter() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/intersectionTypeOverloadWithWrongParameter.kt");
        }

        @Test
        @TestMetadata("kt10036.kt")
        public void testKt10036() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt10036.kt");
        }

        @Test
        @TestMetadata("kt10036_bound.kt")
        public void testKt10036_bound() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt10036_bound.kt");
        }

        @Test
        @TestMetadata("kt12338.kt")
        public void testKt12338() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt12338.kt");
        }

        @Test
        @TestMetadata("kt12751.kt")
        public void testKt12751() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt12751.kt");
        }

        @Test
        @TestMetadata("kt35887.kt")
        public void testKt35887() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt35887.kt");
        }

        @Test
        @TestMetadata("kt35887_simple.kt")
        public void testKt35887_simple() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt35887_simple.kt");
        }

        @Test
        @TestMetadata("kt35920.kt")
        public void testKt35920() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt35920.kt");
        }

        @Test
        @TestMetadata("kt8596.kt")
        public void testKt8596() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt8596.kt");
        }

        @Test
        @TestMetadata("kt9601.kt")
        public void testKt9601() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt9601.kt");
        }

        @Test
        @TestMetadata("moreSpecificAmbiguousExtensions.kt")
        public void testMoreSpecificAmbiguousExtensions() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/moreSpecificAmbiguousExtensions.kt");
        }

        @Test
        @TestMetadata("moreSpecificSimple.kt")
        public void testMoreSpecificSimple() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/moreSpecificSimple.kt");
        }

        @Test
        @TestMetadata("multipleOutersAndMultipleCallableReferences.kt")
        public void testMultipleOutersAndMultipleCallableReferences() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/multipleOutersAndMultipleCallableReferences.kt");
        }

        @Test
        @TestMetadata("nestedReferenceCallAgainstExpectedType.kt")
        public void testNestedReferenceCallAgainstExpectedType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/nestedReferenceCallAgainstExpectedType.kt");
        }

        @Test
        @TestMetadata("noAmbiguityBetweenTopLevelAndMemberProperty.kt")
        public void testNoAmbiguityBetweenTopLevelAndMemberProperty() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/noAmbiguityBetweenTopLevelAndMemberProperty.kt");
        }

        @Test
        @TestMetadata("noFakeDescriptorForObject.kt")
        public void testNoFakeDescriptorForObject() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/noFakeDescriptorForObject.kt");
        }

        @Test
        @TestMetadata("onlyInputTypesOnCallableReference.kt")
        public void testOnlyInputTypesOnCallableReference() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/onlyInputTypesOnCallableReference.kt");
        }

        @Test
        @TestMetadata("overloadAmbiguityForSimpleLastExpressionOfBlock.kt")
        public void testOverloadAmbiguityForSimpleLastExpressionOfBlock() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/overloadAmbiguityForSimpleLastExpressionOfBlock.kt");
        }

        @Test
        @TestMetadata("overloads.kt")
        public void testOverloads() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/overloads.kt");
        }

        @Test
        @TestMetadata("overloadsBound.kt")
        public void testOverloadsBound() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/overloadsBound.kt");
        }

        @Test
        @TestMetadata("overloadsMember.kt")
        public void testOverloadsMember() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/overloadsMember.kt");
        }

        @Test
        @TestMetadata("postponedResolveOfManyCallableReference.kt")
        public void testPostponedResolveOfManyCallableReference() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/postponedResolveOfManyCallableReference.kt");
        }

        @Test
        @TestMetadata("resolveCallableReferencesAfterAllSimpleArguments.kt")
        public void testResolveCallableReferencesAfterAllSimpleArguments() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/resolveCallableReferencesAfterAllSimpleArguments.kt");
        }

        @Test
        @TestMetadata("resolveEqualsOperatorWithAnyExpectedType.kt")
        public void testResolveEqualsOperatorWithAnyExpectedType() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/resolveEqualsOperatorWithAnyExpectedType.kt");
        }

        @Test
        @TestMetadata("resolveReferenceAgainstKFunctionAndKPrpoerty.kt")
        public void testResolveReferenceAgainstKFunctionAndKPrpoerty() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/resolveReferenceAgainstKFunctionAndKPrpoerty.kt");
        }

        @Test
        @TestMetadata("resolveTwoReferencesAgainstGenerics.kt")
        public void testResolveTwoReferencesAgainstGenerics() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/resolveTwoReferencesAgainstGenerics.kt");
        }

        @Test
        @TestMetadata("valVsFun.kt")
        public void testValVsFun() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/valVsFun.kt");
        }

        @Test
        @TestMetadata("withAs.kt")
        public void testWithAs() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withAs.kt");
        }

        @Test
        @TestMetadata("withExtFun.kt")
        public void testWithExtFun() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withExtFun.kt");
        }

        @Test
        @TestMetadata("withGenericFun.kt")
        public void testWithGenericFun() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withGenericFun.kt");
        }

        @Test
        @TestMetadata("withPlaceholderTypes.kt")
        public void testWithPlaceholderTypes() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withPlaceholderTypes.kt");
        }

        @Test
        @TestMetadata("withVararg.kt")
        public void testWithVararg() {
          runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withVararg.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/callableReference/unsupported")
      @TestDataPath("$PROJECT_ROOT")
      public class Unsupported {
        @Test
        public void testAllFilesPresentInUnsupported() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/unsupported"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("callableReferenceToLocalVariable.kt")
        public void testCallableReferenceToLocalVariable() {
          runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/callableReferenceToLocalVariable.kt");
        }

        @Test
        @TestMetadata("classLiteralsWithEmptyLHS.kt")
        public void testClassLiteralsWithEmptyLHS() {
          runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/classLiteralsWithEmptyLHS.kt");
        }

        @Test
        @TestMetadata("javaOverridesKotlinProperty.kt")
        public void testJavaOverridesKotlinProperty() {
          runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/javaOverridesKotlinProperty.kt");
        }

        @Test
        @TestMetadata("localVariable.kt")
        public void testLocalVariable() {
          runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/localVariable.kt");
        }

        @Test
        @TestMetadata("localVariableWithSubstitution.kt")
        public void testLocalVariableWithSubstitution() {
          runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/localVariableWithSubstitution.kt");
        }

        @Test
        @TestMetadata("parameterWithSubstitution.kt")
        public void testParameterWithSubstitution() {
          runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/parameterWithSubstitution.kt");
        }

        @Test
        @TestMetadata("referenceToKotlinPropertyViaIntermediateJavaClass.kt")
        public void testReferenceToKotlinPropertyViaIntermediateJavaClass() {
          runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/referenceToKotlinPropertyViaIntermediateJavaClass.kt");
        }

        @Test
        @TestMetadata("syntheticProperties.kt")
        public void testSyntheticProperties() {
          runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/syntheticProperties.kt");
        }

        @Test
        @TestMetadata("syntheticPropertiesOnJavaAnnotation.kt")
        public void testSyntheticPropertiesOnJavaAnnotation() {
          runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/syntheticPropertiesOnJavaAnnotation.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/cast")
    @TestDataPath("$PROJECT_ROOT")
    public class Cast {
      @Test
      public void testAllFilesPresentInCast() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/cast"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("AsArray.kt")
      public void testAsArray() {
        runTest("compiler/testData/diagnostics/tests/cast/AsArray.kt");
      }

      @Test
      @TestMetadata("AsErasedError.kt")
      public void testAsErasedError() {
        runTest("compiler/testData/diagnostics/tests/cast/AsErasedError.kt");
      }

      @Test
      @TestMetadata("AsErasedFine.kt")
      public void testAsErasedFine() {
        runTest("compiler/testData/diagnostics/tests/cast/AsErasedFine.kt");
      }

      @Test
      @TestMetadata("AsErasedStar.kt")
      public void testAsErasedStar() {
        runTest("compiler/testData/diagnostics/tests/cast/AsErasedStar.kt");
      }

      @Test
      @TestMetadata("AsErasedWarning.kt")
      public void testAsErasedWarning() {
        runTest("compiler/testData/diagnostics/tests/cast/AsErasedWarning.kt");
      }

      @Test
      @TestMetadata("AsInBinaryUnary.kt")
      public void testAsInBinaryUnary() {
        runTest("compiler/testData/diagnostics/tests/cast/AsInBinaryUnary.kt");
      }

      @Test
      @TestMetadata("AsInBlockWithReturnType.kt")
      public void testAsInBlockWithReturnType() {
        runTest("compiler/testData/diagnostics/tests/cast/AsInBlockWithReturnType.kt");
      }

      @Test
      @TestMetadata("AsInCompoundAssignment.kt")
      public void testAsInCompoundAssignment() {
        runTest("compiler/testData/diagnostics/tests/cast/AsInCompoundAssignment.kt");
      }

      @Test
      @TestMetadata("AsInExpressionBody.kt")
      public void testAsInExpressionBody() {
        runTest("compiler/testData/diagnostics/tests/cast/AsInExpressionBody.kt");
      }

      @Test
      @TestMetadata("AsInPropertyAndPropertyAccessor.kt")
      public void testAsInPropertyAndPropertyAccessor() {
        runTest("compiler/testData/diagnostics/tests/cast/AsInPropertyAndPropertyAccessor.kt");
      }

      @Test
      @TestMetadata("AsNothing.kt")
      public void testAsNothing() {
        runTest("compiler/testData/diagnostics/tests/cast/AsNothing.kt");
      }

      @Test
      @TestMetadata("AsTypeAlias.kt")
      public void testAsTypeAlias() {
        runTest("compiler/testData/diagnostics/tests/cast/AsTypeAlias.kt");
      }

      @Test
      @TestMetadata("AsWithOtherParameter.kt")
      public void testAsWithOtherParameter() {
        runTest("compiler/testData/diagnostics/tests/cast/AsWithOtherParameter.kt");
      }

      @Test
      @TestMetadata("checkCastToNullableType.kt")
      public void testCheckCastToNullableType() {
        runTest("compiler/testData/diagnostics/tests/cast/checkCastToNullableType.kt");
      }

      @Test
      @TestMetadata("constants.kt")
      public void testConstants() {
        runTest("compiler/testData/diagnostics/tests/cast/constants.kt");
      }

      @Test
      @TestMetadata("DowncastMap.kt")
      public void testDowncastMap() {
        runTest("compiler/testData/diagnostics/tests/cast/DowncastMap.kt");
      }

      @Test
      @TestMetadata("ExtensionAsNonExtension.kt")
      public void testExtensionAsNonExtension() {
        runTest("compiler/testData/diagnostics/tests/cast/ExtensionAsNonExtension.kt");
      }

      @Test
      @TestMetadata("FlexibleTargetType.kt")
      public void testFlexibleTargetType() {
        runTest("compiler/testData/diagnostics/tests/cast/FlexibleTargetType.kt");
      }

      @Test
      @TestMetadata("isAlwaysFalse.kt")
      public void testIsAlwaysFalse() {
        runTest("compiler/testData/diagnostics/tests/cast/isAlwaysFalse.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowForDerivedWithOneSubstitutedAndOneSameGeneric.kt")
      public void testIsErasedAllowForDerivedWithOneSubstitutedAndOneSameGeneric() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForDerivedWithOneSubstitutedAndOneSameGeneric.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowForExactSupertypeCheck.kt")
      public void testIsErasedAllowForExactSupertypeCheck() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForExactSupertypeCheck.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowForOverridenVarianceWithProjection.kt")
      public void testIsErasedAllowForOverridenVarianceWithProjection() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForOverridenVarianceWithProjection.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowForSupertypeCheckWithContrvariance.kt")
      public void testIsErasedAllowForSupertypeCheckWithContrvariance() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForSupertypeCheckWithContrvariance.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowForSupertypeCheckWithCovariance.kt")
      public void testIsErasedAllowForSupertypeCheckWithCovariance() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForSupertypeCheckWithCovariance.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowForTypeWithIrrelevantMixin.kt")
      public void testIsErasedAllowForTypeWithIrrelevantMixin() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForTypeWithIrrelevantMixin.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowForTypeWithTwoSameTypeSubstitutions.kt")
      public void testIsErasedAllowForTypeWithTwoSameTypeSubstitutions() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForTypeWithTwoSameTypeSubstitutions.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowForTypeWithoutTypeArguments.kt")
      public void testIsErasedAllowForTypeWithoutTypeArguments() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForTypeWithoutTypeArguments.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowFromOut.kt")
      public void testIsErasedAllowFromOut() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOut.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowFromOut2.kt")
      public void testIsErasedAllowFromOut2() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOut2.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowFromOut3.kt")
      public void testIsErasedAllowFromOut3() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOut3.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowFromOutAtClass.kt")
      public void testIsErasedAllowFromOutAtClass() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOutAtClass.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowParameterSubtype.kt")
      public void testIsErasedAllowParameterSubtype() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowParameterSubtype.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowSameClassParameter.kt")
      public void testIsErasedAllowSameClassParameter() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowSameClassParameter.kt");
      }

      @Test
      @TestMetadata("IsErasedAllowSameParameterParameter.kt")
      public void testIsErasedAllowSameParameterParameter() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowSameParameterParameter.kt");
      }

      @Test
      @TestMetadata("isErasedAnyAndStarred.kt")
      public void testIsErasedAnyAndStarred() {
        runTest("compiler/testData/diagnostics/tests/cast/isErasedAnyAndStarred.kt");
      }

      @Test
      @TestMetadata("IsErasedDisallowDifferentArgInvariantPosition.kt")
      public void testIsErasedDisallowDifferentArgInvariantPosition() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowDifferentArgInvariantPosition.kt");
      }

      @Test
      @TestMetadata("IsErasedDisallowForOverridenVariance.kt")
      public void testIsErasedDisallowForOverridenVariance() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowForOverridenVariance.kt");
      }

      @Test
      @TestMetadata("IsErasedDisallowForTypeWithConstraints.kt")
      public void testIsErasedDisallowForTypeWithConstraints() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowForTypeWithConstraints.kt");
      }

      @Test
      @TestMetadata("IsErasedDisallowFromAny.kt")
      public void testIsErasedDisallowFromAny() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromAny.kt");
      }

      @Test
      @TestMetadata("IsErasedDisallowFromIn.kt")
      public void testIsErasedDisallowFromIn() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromIn.kt");
      }

      @Test
      @TestMetadata("IsErasedDisallowFromOut.kt")
      public void testIsErasedDisallowFromOut() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromOut.kt");
      }

      @Test
      @TestMetadata("IsErasedDisallowFromOutAtClass.kt")
      public void testIsErasedDisallowFromOutAtClass() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromOutAtClass.kt");
      }

      @Test
      @TestMetadata("IsErasedDissallowForSubtypeMappedToTwoParamsWithFirstInvalid.kt")
      public void testIsErasedDissallowForSubtypeMappedToTwoParamsWithFirstInvalid() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedDissallowForSubtypeMappedToTwoParamsWithFirstInvalid.kt");
      }

      @Test
      @TestMetadata("IsErasedDissallowForSubtypeMappedToTwoParamsWithSecondInvalid.kt")
      public void testIsErasedDissallowForSubtypeMappedToTwoParamsWithSecondInvalid() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedDissallowForSubtypeMappedToTwoParamsWithSecondInvalid.kt");
      }

      @Test
      @TestMetadata("IsErasedNonGeneric.kt")
      public void testIsErasedNonGeneric() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedNonGeneric.kt");
      }

      @Test
      @TestMetadata("IsErasedNullableTasT.kt")
      public void testIsErasedNullableTasT() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedNullableTasT.kt");
      }

      @Test
      @TestMetadata("IsErasedStar.kt")
      public void testIsErasedStar() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedStar.kt");
      }

      @Test
      @TestMetadata("isErasedTAndStarred.kt")
      public void testIsErasedTAndStarred() {
        runTest("compiler/testData/diagnostics/tests/cast/isErasedTAndStarred.kt");
      }

      @Test
      @TestMetadata("IsErasedTasT.kt")
      public void testIsErasedTasT() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedTasT.kt");
      }

      @Test
      @TestMetadata("IsErasedToErrorType.kt")
      public void testIsErasedToErrorType() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedToErrorType.kt");
      }

      @Test
      @TestMetadata("isErasedUnrelatedAndStarred.kt")
      public void testIsErasedUnrelatedAndStarred() {
        runTest("compiler/testData/diagnostics/tests/cast/isErasedUnrelatedAndStarred.kt");
      }

      @Test
      @TestMetadata("IsErasedUpcastToNonReified.kt")
      public void testIsErasedUpcastToNonReified() {
        runTest("compiler/testData/diagnostics/tests/cast/IsErasedUpcastToNonReified.kt");
      }

      @Test
      @TestMetadata("IsForTypeWithComplexUpperBound.kt")
      public void testIsForTypeWithComplexUpperBound() {
        runTest("compiler/testData/diagnostics/tests/cast/IsForTypeWithComplexUpperBound.kt");
      }

      @Test
      @TestMetadata("IsRecursionSustainable.kt")
      public void testIsRecursionSustainable() {
        runTest("compiler/testData/diagnostics/tests/cast/IsRecursionSustainable.kt");
      }

      @Test
      @TestMetadata("IsTraits.kt")
      public void testIsTraits() {
        runTest("compiler/testData/diagnostics/tests/cast/IsTraits.kt");
      }

      @Test
      @TestMetadata("IsWithCycleUpperBounds.kt")
      public void testIsWithCycleUpperBounds() {
        runTest("compiler/testData/diagnostics/tests/cast/IsWithCycleUpperBounds.kt");
      }

      @Test
      @TestMetadata("kt15161.kt")
      public void testKt15161() {
        runTest("compiler/testData/diagnostics/tests/cast/kt15161.kt");
      }

      @Test
      @TestMetadata("kt47685.kt")
      public void testKt47685() {
        runTest("compiler/testData/diagnostics/tests/cast/kt47685.kt");
      }

      @Test
      @TestMetadata("kt56629.kt")
      public void testKt56629() {
        runTest("compiler/testData/diagnostics/tests/cast/kt56629.kt");
      }

      @Test
      @TestMetadata("kt614.kt")
      public void testKt614() {
        runTest("compiler/testData/diagnostics/tests/cast/kt614.kt");
      }

      @Test
      @TestMetadata("nonUselessCastInLambda.kt")
      public void testNonUselessCastInLambda() {
        runTest("compiler/testData/diagnostics/tests/cast/nonUselessCastInLambda.kt");
      }

      @Test
      @TestMetadata("nothingAs.kt")
      public void testNothingAs() {
        runTest("compiler/testData/diagnostics/tests/cast/nothingAs.kt");
      }

      @Test
      @TestMetadata("NullableToNullable.kt")
      public void testNullableToNullable() {
        runTest("compiler/testData/diagnostics/tests/cast/NullableToNullable.kt");
      }

      @Test
      @TestMetadata("StableTypeForUselessCast.kt")
      public void testStableTypeForUselessCast() {
        runTest("compiler/testData/diagnostics/tests/cast/StableTypeForUselessCast.kt");
      }

      @Test
      @TestMetadata("usefulCastInGetOperator.kt")
      public void testUsefulCastInGetOperator() {
        runTest("compiler/testData/diagnostics/tests/cast/usefulCastInGetOperator.kt");
      }

      @Test
      @TestMetadata("usefulCastInMap.kt")
      public void testUsefulCastInMap() {
        runTest("compiler/testData/diagnostics/tests/cast/usefulCastInMap.kt");
      }

      @Test
      @TestMetadata("UselessSafeCast.kt")
      public void testUselessSafeCast() {
        runTest("compiler/testData/diagnostics/tests/cast/UselessSafeCast.kt");
      }

      @Test
      @TestMetadata("WhenErasedDisallowFromAny.kt")
      public void testWhenErasedDisallowFromAny() {
        runTest("compiler/testData/diagnostics/tests/cast/WhenErasedDisallowFromAny.kt");
      }

      @Test
      @TestMetadata("WhenWithExpression.kt")
      public void testWhenWithExpression() {
        runTest("compiler/testData/diagnostics/tests/cast/WhenWithExpression.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/cast/bare")
      @TestDataPath("$PROJECT_ROOT")
      public class Bare {
        @Test
        public void testAllFilesPresentInBare() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/cast/bare"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("AsNestedBare.kt")
        public void testAsNestedBare() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/AsNestedBare.kt");
        }

        @Test
        @TestMetadata("AsNullable.kt")
        public void testAsNullable() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/AsNullable.kt");
        }

        @Test
        @TestMetadata("AsNullableNotEnough.kt")
        public void testAsNullableNotEnough() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/AsNullableNotEnough.kt");
        }

        @Test
        @TestMetadata("EitherAs.kt")
        public void testEitherAs() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/EitherAs.kt");
        }

        @Test
        @TestMetadata("EitherIs.kt")
        public void testEitherIs() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/EitherIs.kt");
        }

        @Test
        @TestMetadata("EitherNotIs.kt")
        public void testEitherNotIs() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/EitherNotIs.kt");
        }

        @Test
        @TestMetadata("EitherSafeAs.kt")
        public void testEitherSafeAs() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/EitherSafeAs.kt");
        }

        @Test
        @TestMetadata("EitherWhen.kt")
        public void testEitherWhen() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/EitherWhen.kt");
        }

        @Test
        @TestMetadata("ErrorsInSubstitution.kt")
        public void testErrorsInSubstitution() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/ErrorsInSubstitution.kt");
        }

        @Test
        @TestMetadata("FromErrorType.kt")
        public void testFromErrorType() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/FromErrorType.kt");
        }

        @Test
        @TestMetadata("NullableAs.kt")
        public void testNullableAs() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/NullableAs.kt");
        }

        @Test
        @TestMetadata("NullableAsNotEnough.kt")
        public void testNullableAsNotEnough() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/NullableAsNotEnough.kt");
        }

        @Test
        @TestMetadata("NullableAsNullable.kt")
        public void testNullableAsNullable() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/NullableAsNullable.kt");
        }

        @Test
        @TestMetadata("NullableAsNullableNotEnough.kt")
        public void testNullableAsNullableNotEnough() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/NullableAsNullableNotEnough.kt");
        }

        @Test
        @TestMetadata("RedundantNullable.kt")
        public void testRedundantNullable() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/RedundantNullable.kt");
        }

        @Test
        @TestMetadata("SupertypeChain.kt")
        public void testSupertypeChain() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/SupertypeChain.kt");
        }

        @Test
        @TestMetadata("ToErrorType.kt")
        public void testToErrorType() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/ToErrorType.kt");
        }

        @Test
        @TestMetadata("UnrelatedAs.kt")
        public void testUnrelatedAs() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/UnrelatedAs.kt");
        }

        @Test
        @TestMetadata("UnrelatedColon.kt")
        public void testUnrelatedColon() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/UnrelatedColon.kt");
        }

        @Test
        @TestMetadata("UnrelatedIs.kt")
        public void testUnrelatedIs() {
          runTest("compiler/testData/diagnostics/tests/cast/bare/UnrelatedIs.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/cast/neverSucceeds")
      @TestDataPath("$PROJECT_ROOT")
      public class NeverSucceeds {
        @Test
        public void testAllFilesPresentInNeverSucceeds() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/cast/neverSucceeds"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("CastToNotNullSuper.kt")
        public void testCastToNotNullSuper() {
          runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/CastToNotNullSuper.kt");
        }

        @Test
        @TestMetadata("DefinitelyNotNullTypes.kt")
        public void testDefinitelyNotNullTypes() {
          runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/DefinitelyNotNullTypes.kt");
        }

        @Test
        @TestMetadata("MappedDirect.kt")
        public void testMappedDirect() {
          runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/MappedDirect.kt");
        }

        @Test
        @TestMetadata("MappedSubtypes.kt")
        public void testMappedSubtypes() {
          runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/MappedSubtypes.kt");
        }

        @Test
        @TestMetadata("NoGenericsRelated.kt")
        public void testNoGenericsRelated() {
          runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/NoGenericsRelated.kt");
        }

        @Test
        @TestMetadata("NoGenericsUnrelated.kt")
        public void testNoGenericsUnrelated() {
          runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/NoGenericsUnrelated.kt");
        }

        @Test
        @TestMetadata("NullableExprToItsNonNullableGenericBaseClass.kt")
        public void testNullableExprToItsNonNullableGenericBaseClass() {
          runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/NullableExprToItsNonNullableGenericBaseClass.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/checkArguments")
    @TestDataPath("$PROJECT_ROOT")
    public class CheckArguments {
      @Test
      public void testAllFilesPresentInCheckArguments() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/checkArguments"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("arrayAccessSet.kt")
      public void testArrayAccessSet() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/arrayAccessSet.kt");
      }

      @Test
      @TestMetadata("arrayAccessSetNotEnoughArgs.kt")
      public void testArrayAccessSetNotEnoughArgs() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/arrayAccessSetNotEnoughArgs.kt");
      }

      @Test
      @TestMetadata("arrayAccessSetTooManyArgs.kt")
      public void testArrayAccessSetTooManyArgs() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/arrayAccessSetTooManyArgs.kt");
      }

      @Test
      @TestMetadata("booleanExpressions.kt")
      public void testBooleanExpressions() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/booleanExpressions.kt");
      }

      @Test
      @TestMetadata("kt17691WithEnabledFeature.kt")
      public void testKt17691WithEnabledFeature() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/kt17691WithEnabledFeature.kt");
      }

      @Test
      @TestMetadata("kt1897_diagnostic_part.kt")
      public void testKt1897_diagnostic_part() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/kt1897_diagnostic_part.kt");
      }

      @Test
      @TestMetadata("kt1940.kt")
      public void testKt1940() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/kt1940.kt");
      }

      @Test
      @TestMetadata("kt49276.kt")
      public void testKt49276() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/kt49276.kt");
      }

      @Test
      @TestMetadata("kt49276Disabled.kt")
      public void testKt49276Disabled() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/kt49276Disabled.kt");
      }

      @Test
      @TestMetadata("kt49276Error.kt")
      public void testKt49276Error() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/kt49276Error.kt");
      }

      @Test
      @TestMetadata("kt51062.kt")
      public void testKt51062() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/kt51062.kt");
      }

      @Test
      @TestMetadata("kt51062Error.kt")
      public void testKt51062Error() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/kt51062Error.kt");
      }

      @Test
      @TestMetadata("overloadedFunction.kt")
      public void testOverloadedFunction() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/overloadedFunction.kt");
      }

      @Test
      @TestMetadata("SpreadVarargs.kt")
      public void testSpreadVarargs() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/SpreadVarargs.kt");
      }

      @Test
      @TestMetadata("twoLambdasFunction.kt")
      public void testTwoLambdasFunction() {
        runTest("compiler/testData/diagnostics/tests/checkArguments/twoLambdasFunction.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/classLiteral")
    @TestDataPath("$PROJECT_ROOT")
    public class ClassLiteral {
      @Test
      public void testAllFilesPresentInClassLiteral() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/classLiteral"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("arrays.kt")
      public void testArrays() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/arrays.kt");
      }

      @Test
      @TestMetadata("classAndObjectLiteralType.kt")
      public void testClassAndObjectLiteralType() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/classAndObjectLiteralType.kt");
      }

      @Test
      @TestMetadata("classLiteralType.kt")
      public void testClassLiteralType() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/classLiteralType.kt");
      }

      @Test
      @TestMetadata("expressionWithNullableType.kt")
      public void testExpressionWithNullableType() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/expressionWithNullableType.kt");
      }

      @Test
      @TestMetadata("genericArrays.kt")
      public void testGenericArrays() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/genericArrays.kt");
      }

      @Test
      @TestMetadata("genericClasses.kt")
      public void testGenericClasses() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/genericClasses.kt");
      }

      @Test
      @TestMetadata("inAnnotationArguments.kt")
      public void testInAnnotationArguments() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/inAnnotationArguments.kt");
      }

      @Test
      @TestMetadata("integerValueType.kt")
      public void testIntegerValueType() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/integerValueType.kt");
      }

      @Test
      @TestMetadata("nonClassesOnLHS.kt")
      public void testNonClassesOnLHS() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/nonClassesOnLHS.kt");
      }

      @Test
      @TestMetadata("parameterizedTypeAlias.kt")
      public void testParameterizedTypeAlias() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/parameterizedTypeAlias.kt");
      }

      @Test
      @TestMetadata("qualifiedClassLiteral.kt")
      public void testQualifiedClassLiteral() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/qualifiedClassLiteral.kt");
      }

      @Test
      @TestMetadata("simpleClassLiteral.kt")
      public void testSimpleClassLiteral() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/simpleClassLiteral.kt");
      }

      @Test
      @TestMetadata("smartCast.kt")
      public void testSmartCast() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/smartCast.kt");
      }

      @Test
      @TestMetadata("typealiases.kt")
      public void testTypealiases() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/typealiases.kt");
      }

      @Test
      @TestMetadata("unresolvedClass.kt")
      public void testUnresolvedClass() {
        runTest("compiler/testData/diagnostics/tests/classLiteral/unresolvedClass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/classObjects")
    @TestDataPath("$PROJECT_ROOT")
    public class ClassObjects {
      @Test
      public void testAllFilesPresentInClassObjects() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/classObjects"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("builtInClassObjects.kt")
      public void testBuiltInClassObjects() {
        runTest("compiler/testData/diagnostics/tests/classObjects/builtInClassObjects.kt");
      }

      @Test
      @TestMetadata("ClassObjectCannotAccessClassFields.kt")
      public void testClassObjectCannotAccessClassFields() {
        runTest("compiler/testData/diagnostics/tests/classObjects/ClassObjectCannotAccessClassFields.kt");
      }

      @Test
      @TestMetadata("classObjectHeader.kt")
      public void testClassObjectHeader() {
        runTest("compiler/testData/diagnostics/tests/classObjects/classObjectHeader.kt");
      }

      @Test
      @TestMetadata("classObjectInLocalClass.kt")
      public void testClassObjectInLocalClass() {
        runTest("compiler/testData/diagnostics/tests/classObjects/classObjectInLocalClass.kt");
      }

      @Test
      @TestMetadata("classObjectRedeclaration.kt")
      public void testClassObjectRedeclaration() {
        runTest("compiler/testData/diagnostics/tests/classObjects/classObjectRedeclaration.kt");
      }

      @Test
      @TestMetadata("ClassObjectVisibility.kt")
      public void testClassObjectVisibility() {
        runTest("compiler/testData/diagnostics/tests/classObjects/ClassObjectVisibility.kt");
      }

      @Test
      @TestMetadata("ClassObjects.kt")
      public void testClassObjects() {
        runTest("compiler/testData/diagnostics/tests/classObjects/ClassObjects.kt");
      }

      @Test
      @TestMetadata("classWithFunctionSupertype_after.kt")
      public void testClassWithFunctionSupertype_after() {
        runTest("compiler/testData/diagnostics/tests/classObjects/classWithFunctionSupertype_after.kt");
      }

      @Test
      @TestMetadata("classWithFunctionSupertype_before.kt")
      public void testClassWithFunctionSupertype_before() {
        runTest("compiler/testData/diagnostics/tests/classObjects/classWithFunctionSupertype_before.kt");
      }

      @Test
      @TestMetadata("companionInInnerOfLocalClass.kt")
      public void testCompanionInInnerOfLocalClass() {
        runTest("compiler/testData/diagnostics/tests/classObjects/companionInInnerOfLocalClass.kt");
      }

      @Test
      @TestMetadata("companionInInnerOfLocalClassAfter.kt")
      public void testCompanionInInnerOfLocalClassAfter() {
        runTest("compiler/testData/diagnostics/tests/classObjects/companionInInnerOfLocalClassAfter.kt");
      }

      @Test
      @TestMetadata("companionInInnerOfObjectExpression.kt")
      public void testCompanionInInnerOfObjectExpression() {
        runTest("compiler/testData/diagnostics/tests/classObjects/companionInInnerOfObjectExpression.kt");
      }

      @Test
      @TestMetadata("companionInInnerOfObjectExpressionAfter.kt")
      public void testCompanionInInnerOfObjectExpressionAfter() {
        runTest("compiler/testData/diagnostics/tests/classObjects/companionInInnerOfObjectExpressionAfter.kt");
      }

      @Test
      @TestMetadata("companionObjectOfPrivateClassVisibility.kt")
      public void testCompanionObjectOfPrivateClassVisibility() {
        runTest("compiler/testData/diagnostics/tests/classObjects/companionObjectOfPrivateClassVisibility.kt");
      }

      @Test
      @TestMetadata("importClassInClassObject.kt")
      public void testImportClassInClassObject() {
        runTest("compiler/testData/diagnostics/tests/classObjects/importClassInClassObject.kt");
      }

      @Test
      @TestMetadata("InnerClassAccessThroughClassObject.kt")
      public void testInnerClassAccessThroughClassObject() {
        runTest("compiler/testData/diagnostics/tests/classObjects/InnerClassAccessThroughClassObject.kt");
      }

      @Test
      @TestMetadata("InnerClassAccessThroughEnum_after.kt")
      public void testInnerClassAccessThroughEnum_after() {
        runTest("compiler/testData/diagnostics/tests/classObjects/InnerClassAccessThroughEnum_after.kt");
      }

      @Test
      @TestMetadata("InnerClassAccessThroughEnum_before.kt")
      public void testInnerClassAccessThroughEnum_before() {
        runTest("compiler/testData/diagnostics/tests/classObjects/InnerClassAccessThroughEnum_before.kt");
      }

      @Test
      @TestMetadata("InnerClassClassObject.kt")
      public void testInnerClassClassObject() {
        runTest("compiler/testData/diagnostics/tests/classObjects/InnerClassClassObject.kt");
      }

      @Test
      @TestMetadata("invisibleClassObjects.kt")
      public void testInvisibleClassObjects() {
        runTest("compiler/testData/diagnostics/tests/classObjects/invisibleClassObjects.kt");
      }

      @Test
      @TestMetadata("kt3866.kt")
      public void testKt3866() {
        runTest("compiler/testData/diagnostics/tests/classObjects/kt3866.kt");
      }

      @Test
      @TestMetadata("multipleDissallowedDefaultObjects.kt")
      public void testMultipleDissallowedDefaultObjects() {
        runTest("compiler/testData/diagnostics/tests/classObjects/multipleDissallowedDefaultObjects.kt");
      }

      @Test
      @TestMetadata("nestedClassInPrivateClassObject.kt")
      public void testNestedClassInPrivateClassObject() {
        runTest("compiler/testData/diagnostics/tests/classObjects/nestedClassInPrivateClassObject.kt");
      }

      @Test
      @TestMetadata("protectedFieldFromSuperCompanion_after.kt")
      public void testProtectedFieldFromSuperCompanion_after() {
        runTest("compiler/testData/diagnostics/tests/classObjects/protectedFieldFromSuperCompanion_after.kt");
      }

      @Test
      @TestMetadata("protectedFieldFromSuperCompanion_before.kt")
      public void testProtectedFieldFromSuperCompanion_before() {
        runTest("compiler/testData/diagnostics/tests/classObjects/protectedFieldFromSuperCompanion_before.kt");
      }

      @Test
      @TestMetadata("resolveFunctionInsideClassObject.kt")
      public void testResolveFunctionInsideClassObject() {
        runTest("compiler/testData/diagnostics/tests/classObjects/resolveFunctionInsideClassObject.kt");
      }

      @Test
      @TestMetadata("selfCallsInCompanionSuperConstructor_error.kt")
      public void testSelfCallsInCompanionSuperConstructor_error() {
        runTest("compiler/testData/diagnostics/tests/classObjects/selfCallsInCompanionSuperConstructor_error.kt");
      }

      @Test
      @TestMetadata("selfCallsInCompanionSuperConstructor_warning.kt")
      public void testSelfCallsInCompanionSuperConstructor_warning() {
        runTest("compiler/testData/diagnostics/tests/classObjects/selfCallsInCompanionSuperConstructor_warning.kt");
      }

      @Test
      @TestMetadata("typeParametersInAnnonymousObject_after.kt")
      public void testTypeParametersInAnnonymousObject_after() {
        runTest("compiler/testData/diagnostics/tests/classObjects/typeParametersInAnnonymousObject_after.kt");
      }

      @Test
      @TestMetadata("typeParametersInObject.kt")
      public void testTypeParametersInObject() {
        runTest("compiler/testData/diagnostics/tests/classObjects/typeParametersInObject.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/collectionLiterals")
    @TestDataPath("$PROJECT_ROOT")
    public class CollectionLiterals {
      @Test
      public void testAllFilesPresentInCollectionLiterals() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/collectionLiterals"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("argumentsOfAnnotation.kt")
      public void testArgumentsOfAnnotation() {
        runTest("compiler/testData/diagnostics/tests/collectionLiterals/argumentsOfAnnotation.kt");
      }

      @Test
      @TestMetadata("argumentsOfAnnotationWithKClass.kt")
      public void testArgumentsOfAnnotationWithKClass() {
        runTest("compiler/testData/diagnostics/tests/collectionLiterals/argumentsOfAnnotationWithKClass.kt");
      }

      @Test
      @TestMetadata("arrayLiteralInNestedAnnotationCall.kt")
      public void testArrayLiteralInNestedAnnotationCall() {
        runTest("compiler/testData/diagnostics/tests/collectionLiterals/arrayLiteralInNestedAnnotationCall.kt");
      }

      @Test
      @TestMetadata("basicCollectionLiterals.kt")
      public void testBasicCollectionLiterals() {
        runTest("compiler/testData/diagnostics/tests/collectionLiterals/basicCollectionLiterals.kt");
      }

      @Test
      @TestMetadata("collectionLiteralsAsPrimitiveArrays.kt")
      public void testCollectionLiteralsAsPrimitiveArrays() {
        runTest("compiler/testData/diagnostics/tests/collectionLiterals/collectionLiteralsAsPrimitiveArrays.kt");
      }

      @Test
      @TestMetadata("collectionLiteralsOutsideOfAnnotations.kt")
      public void testCollectionLiteralsOutsideOfAnnotations() {
        runTest("compiler/testData/diagnostics/tests/collectionLiterals/collectionLiteralsOutsideOfAnnotations.kt");
      }

      @Test
      @TestMetadata("collectionLiteralsWithVarargs.kt")
      public void testCollectionLiteralsWithVarargs() {
        runTest("compiler/testData/diagnostics/tests/collectionLiterals/collectionLiteralsWithVarargs.kt");
      }

      @Test
      @TestMetadata("defaultValuesInAnnotation.kt")
      public void testDefaultValuesInAnnotation() {
        runTest("compiler/testData/diagnostics/tests/collectionLiterals/defaultValuesInAnnotation.kt");
      }

      @Test
      @TestMetadata("defaultValuesWithConstantsInAnnotation.kt")
      public void testDefaultValuesWithConstantsInAnnotation() {
        runTest("compiler/testData/diagnostics/tests/collectionLiterals/defaultValuesWithConstantsInAnnotation.kt");
      }

      @Test
      @TestMetadata("kt34515.kt")
      public void testKt34515() {
        runTest("compiler/testData/diagnostics/tests/collectionLiterals/kt34515.kt");
      }

      @Test
      @TestMetadata("noCollectionLiterals.kt")
      public void testNoCollectionLiterals() {
        runTest("compiler/testData/diagnostics/tests/collectionLiterals/noCollectionLiterals.kt");
      }

      @Test
      @TestMetadata("resolveToFunctionFromBuiltIns.kt")
      public void testResolveToFunctionFromBuiltIns() {
        runTest("compiler/testData/diagnostics/tests/collectionLiterals/resolveToFunctionFromBuiltIns.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/constantEvaluator")
    @TestDataPath("$PROJECT_ROOT")
    public class ConstantEvaluator {
      @Test
      public void testAllFilesPresentInConstantEvaluator() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/constantEvaluator"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/constantEvaluator/constant")
      @TestDataPath("$PROJECT_ROOT")
      public class Constant {
        @Test
        public void testAllFilesPresentInConstant() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/constantEvaluator/constant"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("classObjectProperty.kt")
        public void testClassObjectProperty() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/classObjectProperty.kt");
        }

        @Test
        @TestMetadata("compareTo.kt")
        public void testCompareTo() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/compareTo.kt");
        }

        @Test
        @TestMetadata("differentTypes.kt")
        public void testDifferentTypes() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/differentTypes.kt");
        }

        @Test
        @TestMetadata("divideByZero.kt")
        public void testDivideByZero() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/divideByZero.kt");
        }

        @Test
        @TestMetadata("duplicateLabelWithNonTrivialCondition_disabled.kt")
        public void testDuplicateLabelWithNonTrivialCondition_disabled() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/duplicateLabelWithNonTrivialCondition_disabled.kt");
        }

        @Test
        @TestMetadata("duplicateLabelWithNonTrivialCondition_enabled.kt")
        public void testDuplicateLabelWithNonTrivialCondition_enabled() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/duplicateLabelWithNonTrivialCondition_enabled.kt");
        }

        @Test
        @TestMetadata("equals.kt")
        public void testEquals() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/equals.kt");
        }

        @Test
        @TestMetadata("exceptionWhenEvaluate.kt")
        public void testExceptionWhenEvaluate() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/exceptionWhenEvaluate.kt");
        }

        @Test
        @TestMetadata("finalProperty.kt")
        public void testFinalProperty() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/finalProperty.kt");
        }

        @Test
        @TestMetadata("float.kt")
        public void testFloat() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/float.kt");
        }

        @Test
        @TestMetadata("floatsAndDoubles.kt")
        public void testFloatsAndDoubles() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/floatsAndDoubles.kt");
        }

        @Test
        @TestMetadata("identityCompare.kt")
        public void testIdentityCompare() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/identityCompare.kt");
        }

        @Test
        @TestMetadata("integer.kt")
        public void testInteger() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/integer.kt");
        }

        @Test
        @TestMetadata("integerOperations.kt")
        public void testIntegerOperations() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/integerOperations.kt");
        }

        @Test
        @TestMetadata("integers.kt")
        public void testIntegers() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/integers.kt");
        }

        @Test
        @TestMetadata("invAsCompileTimeCall.kt")
        public void testInvAsCompileTimeCall() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/invAsCompileTimeCall.kt");
        }

        @Test
        @TestMetadata("localVal.kt")
        public void testLocalVal() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/localVal.kt");
        }

        @Test
        @TestMetadata("localVar.kt")
        public void testLocalVar() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/localVar.kt");
        }

        @Test
        @TestMetadata("nonConstAnnotationConstructorParam.kt")
        public void testNonConstAnnotationConstructorParam() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/nonConstAnnotationConstructorParam.kt");
        }

        @Test
        @TestMetadata("nonConstValuesInConstContext.kt")
        public void testNonConstValuesInConstContext() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/nonConstValuesInConstContext.kt");
        }

        @Test
        @TestMetadata("nonFinalProperty.kt")
        public void testNonFinalProperty() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/nonFinalProperty.kt");
        }

        @Test
        @TestMetadata("objectProperty.kt")
        public void testObjectProperty() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/objectProperty.kt");
        }

        @Test
        @TestMetadata("strings.kt")
        public void testStrings() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/strings.kt");
        }

        @Test
        @TestMetadata("topLevelVal.kt")
        public void testTopLevelVal() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/topLevelVal.kt");
        }

        @Test
        @TestMetadata("topLevelVar.kt")
        public void testTopLevelVar() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/topLevelVar.kt");
        }

        @Test
        @TestMetadata("typeAliasToUnsigned.kt")
        public void testTypeAliasToUnsigned() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/typeAliasToUnsigned.kt");
        }

        @Test
        @TestMetadata("unaryMinusIndepWoExpType.kt")
        public void testUnaryMinusIndepWoExpType() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/unaryMinusIndepWoExpType.kt");
        }

        @Test
        @TestMetadata("unaryMinusIndependentExpType.kt")
        public void testUnaryMinusIndependentExpType() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/unaryMinusIndependentExpType.kt");
        }

        @Test
        @TestMetadata("unresolvedReference.kt")
        public void testUnresolvedReference() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/unresolvedReference.kt");
        }

        @Test
        @TestMetadata("unsignedOperations.kt")
        public void testUnsignedOperations() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/unsignedOperations.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/constantEvaluator/isPure")
      @TestDataPath("$PROJECT_ROOT")
      public class IsPure {
        @Test
        public void testAllFilesPresentInIsPure() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/constantEvaluator/isPure"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("innerToType.kt")
        public void testInnerToType() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/isPure/innerToType.kt");
        }

        @Test
        @TestMetadata("namedConstants.kt")
        public void testNamedConstants() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/isPure/namedConstants.kt");
        }

        @Test
        @TestMetadata("toType.kt")
        public void testToType() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/isPure/toType.kt");
        }

        @Test
        @TestMetadata("unaryMinusIndepWoExpType.kt")
        public void testUnaryMinusIndepWoExpType() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/isPure/unaryMinusIndepWoExpType.kt");
        }

        @Test
        @TestMetadata("unaryMinusIndependentExpType.kt")
        public void testUnaryMinusIndependentExpType() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/isPure/unaryMinusIndependentExpType.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/constantEvaluator/usesVariableAsConstant")
      @TestDataPath("$PROJECT_ROOT")
      public class UsesVariableAsConstant {
        @Test
        public void testAllFilesPresentInUsesVariableAsConstant() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/constantEvaluator/usesVariableAsConstant"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("binaryTypes.kt")
        public void testBinaryTypes() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/usesVariableAsConstant/binaryTypes.kt");
        }

        @Test
        @TestMetadata("NamedConstants.kt")
        public void testNamedConstants() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/usesVariableAsConstant/NamedConstants.kt");
        }

        @Test
        @TestMetadata("OtherTypes.kt")
        public void testOtherTypes() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/usesVariableAsConstant/OtherTypes.kt");
        }

        @Test
        @TestMetadata("simpleTypes.kt")
        public void testSimpleTypes() {
          runTest("compiler/testData/diagnostics/tests/constantEvaluator/usesVariableAsConstant/simpleTypes.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/constructorConsistency")
    @TestDataPath("$PROJECT_ROOT")
    public class ConstructorConsistency {
      @Test
      @TestMetadata("afterInitialization.kt")
      public void testAfterInitialization() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/afterInitialization.kt");
      }

      @Test
      @TestMetadata("aliencall.kt")
      public void testAliencall() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/aliencall.kt");
      }

      @Test
      public void testAllFilesPresentInConstructorConsistency() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/constructorConsistency"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("assignment.kt")
      public void testAssignment() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/assignment.kt");
      }

      @Test
      @TestMetadata("backing.kt")
      public void testBacking() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/backing.kt");
      }

      @Test
      @TestMetadata("basic.kt")
      public void testBasic() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/basic.kt");
      }

      @Test
      @TestMetadata("companion.kt")
      public void testCompanion() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/companion.kt");
      }

      @Test
      @TestMetadata("comparison.kt")
      public void testComparison() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/comparison.kt");
      }

      @Test
      @TestMetadata("delegate.kt")
      public void testDelegate() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/delegate.kt");
      }

      @Test
      @TestMetadata("derived.kt")
      public void testDerived() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/derived.kt");
      }

      @Test
      @TestMetadata("derivedProperty.kt")
      public void testDerivedProperty() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/derivedProperty.kt");
      }

      @Test
      @TestMetadata("errorInsideDelegationCallNoPrimary.kt")
      public void testErrorInsideDelegationCallNoPrimary() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/errorInsideDelegationCallNoPrimary.kt");
      }

      @Test
      @TestMetadata("getset.kt")
      public void testGetset() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/getset.kt");
      }

      @Test
      @TestMetadata("init.kt")
      public void testInit() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/init.kt");
      }

      @Test
      @TestMetadata("initializerWithSecondaryConstructor.kt")
      public void testInitializerWithSecondaryConstructor() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/initializerWithSecondaryConstructor.kt");
      }

      @Test
      @TestMetadata("initwithgetter.kt")
      public void testInitwithgetter() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/initwithgetter.kt");
      }

      @Test
      @TestMetadata("inspection.kt")
      public void testInspection() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/inspection.kt");
      }

      @Test
      @TestMetadata("lambdaInObject.kt")
      public void testLambdaInObject() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/lambdaInObject.kt");
      }

      @Test
      @TestMetadata("lateInit.kt")
      public void testLateInit() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/lateInit.kt");
      }

      @Test
      @TestMetadata("localObject.kt")
      public void testLocalObject() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/localObject.kt");
      }

      @Test
      @TestMetadata("multipleAreNull.kt")
      public void testMultipleAreNull() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/multipleAreNull.kt");
      }

      @Test
      @TestMetadata("nobacking.kt")
      public void testNobacking() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/nobacking.kt");
      }

      @Test
      @TestMetadata("open.kt")
      public void testOpen() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/open.kt");
      }

      @Test
      @TestMetadata("openProperty.kt")
      public void testOpenProperty() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/openProperty.kt");
      }

      @Test
      @TestMetadata("outer.kt")
      public void testOuter() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/outer.kt");
      }

      @Test
      @TestMetadata("parametersVsPropertiesFromPrimaryConstructor.kt")
      public void testParametersVsPropertiesFromPrimaryConstructor() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/parametersVsPropertiesFromPrimaryConstructor.kt");
      }

      @Test
      @TestMetadata("property.kt")
      public void testProperty() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/property.kt");
      }

      @Test
      @TestMetadata("propertyAccess.kt")
      public void testPropertyAccess() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/propertyAccess.kt");
      }

      @Test
      @TestMetadata("twoSecondaryConstructors.kt")
      public void testTwoSecondaryConstructors() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/twoSecondaryConstructors.kt");
      }

      @Test
      @TestMetadata("twoSuperTypeCalls.kt")
      public void testTwoSuperTypeCalls() {
        runTest("compiler/testData/diagnostics/tests/constructorConsistency/twoSuperTypeCalls.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/contextParameters")
    @TestDataPath("$PROJECT_ROOT")
    public class ContextParameters {
      @Test
      public void testAllFilesPresentInContextParameters() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/contextParameters"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("contextParameterUsage.kt")
      public void testContextParameterUsage() {
        runTest("compiler/testData/diagnostics/tests/contextParameters/contextParameterUsage.kt");
      }

      @Test
      @TestMetadata("dslMarker.kt")
      public void testDslMarker() {
        runTest("compiler/testData/diagnostics/tests/contextParameters/dslMarker.kt");
      }

      @Test
      @TestMetadata("invoke.kt")
      public void testInvoke() {
        runTest("compiler/testData/diagnostics/tests/contextParameters/invoke.kt");
      }

      @Test
      @TestMetadata("invokeWithReceiverAgainstContextFunctionTypeContextDisabled.kt")
      public void testInvokeWithReceiverAgainstContextFunctionTypeContextDisabled() {
        runTest("compiler/testData/diagnostics/tests/contextParameters/invokeWithReceiverAgainstContextFunctionTypeContextDisabled.kt");
      }

      @Test
      @TestMetadata("overloadAmbiguity.kt")
      public void testOverloadAmbiguity() {
        runTest("compiler/testData/diagnostics/tests/contextParameters/overloadAmbiguity.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/contracts")
    @TestDataPath("$PROJECT_ROOT")
    public class Contracts {
      @Test
      public void testAllFilesPresentInContracts() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/contracts"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("nonKotlinContractCall.kt")
      public void testNonKotlinContractCall() {
        runTest("compiler/testData/diagnostics/tests/contracts/nonKotlinContractCall.kt");
      }

      @Test
      @TestMetadata("nonKotlinContractCall2.kt")
      public void testNonKotlinContractCall2() {
        runTest("compiler/testData/diagnostics/tests/contracts/nonKotlinContractCall2.kt");
      }

      @Test
      @TestMetadata("suppressContractWarning.kt")
      public void testSuppressContractWarning() {
        runTest("compiler/testData/diagnostics/tests/contracts/suppressContractWarning.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/contracts/neg")
      @TestDataPath("$PROJECT_ROOT")
      public class Neg {
        @Test
        @TestMetadata("14.kt")
        public void test14() {
          runTest("compiler/testData/diagnostics/tests/contracts/neg/14.kt");
        }

        @Test
        public void testAllFilesPresentInNeg() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/contracts/neg"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/contracts/pos")
      @TestDataPath("$PROJECT_ROOT")
      public class Pos {
        @Test
        @TestMetadata("1.kt")
        public void test1() {
          runTest("compiler/testData/diagnostics/tests/contracts/pos/1.kt");
        }

        @Test
        @TestMetadata("14UserDefined.kt")
        public void test14UserDefined() {
          runTest("compiler/testData/diagnostics/tests/contracts/pos/14UserDefined.kt");
        }

        @Test
        public void testAllFilesPresentInPos() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/contracts/pos"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis")
    @TestDataPath("$PROJECT_ROOT")
    public class ControlFlowAnalysis {
      @Test
      @TestMetadata("accessEnumEntryInLazy.kt")
      public void testAccessEnumEntryInLazy() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/accessEnumEntryInLazy.kt");
      }

      @Test
      @TestMetadata("accessToCompanionInBaseEnumInitSection_function.kt")
      public void testAccessToCompanionInBaseEnumInitSection_function() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/accessToCompanionInBaseEnumInitSection_function.kt");
      }

      @Test
      @TestMetadata("accessToCompanionInBaseEnumInitSection_property.kt")
      public void testAccessToCompanionInBaseEnumInitSection_property() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/accessToCompanionInBaseEnumInitSection_property.kt");
      }

      @Test
      @TestMetadata("accessValueParameterInDefaultValue_after.kt")
      public void testAccessValueParameterInDefaultValue_after() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/accessValueParameterInDefaultValue_after.kt");
      }

      @Test
      @TestMetadata("accessValueParameterInDefaultValue_before.kt")
      public void testAccessValueParameterInDefaultValue_before() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/accessValueParameterInDefaultValue_before.kt");
      }

      @Test
      public void testAllFilesPresentInControlFlowAnalysis() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("assignedInFinally.kt")
      public void testAssignedInFinally() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignedInFinally.kt");
      }

      @Test
      @TestMetadata("assignedInIfElse.kt")
      public void testAssignedInIfElse() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignedInIfElse.kt");
      }

      @Test
      @TestMetadata("assignedInTryWithCatch.kt")
      public void testAssignedInTryWithCatch() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignedInTryWithCatch.kt");
      }

      @Test
      @TestMetadata("assignedInTryWithoutCatch.kt")
      public void testAssignedInTryWithoutCatch() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignedInTryWithoutCatch.kt");
      }

      @Test
      @TestMetadata("assignmentInLocalsInConstructor.kt")
      public void testAssignmentInLocalsInConstructor() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignmentInLocalsInConstructor.kt");
      }

      @Test
      @TestMetadata("assignmentOfSyntheticVarWithInconsistentNullability.kt")
      public void testAssignmentOfSyntheticVarWithInconsistentNullability() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignmentOfSyntheticVarWithInconsistentNullability.kt");
      }

      @Test
      @TestMetadata("backingFieldInsideGetter_after.kt")
      public void testBackingFieldInsideGetter_after() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/backingFieldInsideGetter_after.kt");
      }

      @Test
      @TestMetadata("backingFieldInsideGetter_before.kt")
      public void testBackingFieldInsideGetter_before() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/backingFieldInsideGetter_before.kt");
      }

      @Test
      @TestMetadata("breakContinueInTryFinally.kt")
      public void testBreakContinueInTryFinally() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakContinueInTryFinally.kt");
      }

      @Test
      @TestMetadata("breakContinueInTryFinallyInLoop.kt")
      public void testBreakContinueInTryFinallyInLoop() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakContinueInTryFinallyInLoop.kt");
      }

      @Test
      @TestMetadata("breakContinueNoinline.kt")
      public void testBreakContinueNoinline() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakContinueNoinline.kt");
      }

      @Test
      @TestMetadata("breakContinueWithElvisInLambda.kt")
      public void testBreakContinueWithElvisInLambda() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakContinueWithElvisInLambda.kt");
      }

      @Test
      @TestMetadata("breakInLambdaPassedToDirectInvoke.kt")
      public void testBreakInLambdaPassedToDirectInvoke() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakInLambdaPassedToDirectInvoke.kt");
      }

      @Test
      @TestMetadata("breakInsideLocal.kt")
      public void testBreakInsideLocal() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakInsideLocal.kt");
      }

      @Test
      @TestMetadata("breakOrContinueInLoopCondition.kt")
      public void testBreakOrContinueInLoopCondition() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakOrContinueInLoopCondition.kt");
      }

      @Test
      @TestMetadata("capturingUninitializedVariableInNonInPlaceLambda.kt")
      public void testCapturingUninitializedVariableInNonInPlaceLambda() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/capturingUninitializedVariableInNonInPlaceLambda.kt");
      }

      @Test
      @TestMetadata("cfgOfFullyIncorrectCode.kt")
      public void testCfgOfFullyIncorrectCode() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/cfgOfFullyIncorrectCode.kt");
      }

      @Test
      @TestMetadata("checkInnerLocalDeclarations.kt")
      public void testCheckInnerLocalDeclarations() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/checkInnerLocalDeclarations.kt");
      }

      @Test
      @TestMetadata("checkPropertyAccessor.kt")
      public void testCheckPropertyAccessor() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/checkPropertyAccessor.kt");
      }

      @Test
      @TestMetadata("constructorPropertyInterdependence.kt")
      public void testConstructorPropertyInterdependence() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/constructorPropertyInterdependence.kt");
      }

      @Test
      @TestMetadata("definiteReturnInWhen.kt")
      public void testDefiniteReturnInWhen() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturnInWhen.kt");
      }

      @Test
      @TestMetadata("delegatedConstructorArguments.kt")
      public void testDelegatedConstructorArguments() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/delegatedConstructorArguments.kt");
      }

      @Test
      @TestMetadata("delegatedConstructorOrder.kt")
      public void testDelegatedConstructorOrder() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/delegatedConstructorOrder.kt");
      }

      @Test
      @TestMetadata("delegatedMemberProperyWriteInInit.kt")
      public void testDelegatedMemberProperyWriteInInit() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/delegatedMemberProperyWriteInInit.kt");
      }

      @Test
      @TestMetadata("delegatedPropertyEarlyAccess.kt")
      public void testDelegatedPropertyEarlyAccess() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/delegatedPropertyEarlyAccess.kt");
      }

      @Test
      @TestMetadata("doWhileAssignment.kt")
      public void testDoWhileAssignment() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/doWhileAssignment.kt");
      }

      @Test
      @TestMetadata("doWhileNotDefined.kt")
      public void testDoWhileNotDefined() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/doWhileNotDefined.kt");
      }

      @Test
      @TestMetadata("elvisNotProcessed.kt")
      public void testElvisNotProcessed() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/elvisNotProcessed.kt");
      }

      @Test
      @TestMetadata("enumCompanionInterdependence.kt")
      public void testEnumCompanionInterdependence() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/enumCompanionInterdependence.kt");
      }

      @Test
      @TestMetadata("enumEntryAccessInCapturedBlock.kt")
      public void testEnumEntryAccessInCapturedBlock() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/enumEntryAccessInCapturedBlock.kt");
      }

      @Test
      @TestMetadata("enumEntryAccessInCapturedBlockWithProperAnalysis.kt")
      public void testEnumEntryAccessInCapturedBlockWithProperAnalysis() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/enumEntryAccessInCapturedBlockWithProperAnalysis.kt");
      }

      @Test
      @TestMetadata("enumEntryAssignment.kt")
      public void testEnumEntryAssignment() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/enumEntryAssignment.kt");
      }

      @Test
      @TestMetadata("enumInterdependence.kt")
      public void testEnumInterdependence() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/enumInterdependence.kt");
      }

      @Test
      @TestMetadata("fieldAsClassDelegate.kt")
      public void testFieldAsClassDelegate() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/fieldAsClassDelegate.kt");
      }

      @Test
      @TestMetadata("fieldInitialization.kt")
      public void testFieldInitialization() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/fieldInitialization.kt");
      }

      @Test
      @TestMetadata("infiniteLoops.kt")
      public void testInfiniteLoops() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/infiniteLoops.kt");
      }

      @Test
      @TestMetadata("initializationInLambda.kt")
      public void testInitializationInLambda() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLambda.kt");
      }

      @Test
      @TestMetadata("initializationInLocalClass.kt")
      public void testInitializationInLocalClass() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalClass.kt");
      }

      @Test
      @TestMetadata("initializationInLocalFun.kt")
      public void testInitializationInLocalFun() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalFun.kt");
      }

      @Test
      @TestMetadata("initializationInLocalInnerClassWithSecondaryConstructor.kt")
      public void testInitializationInLocalInnerClassWithSecondaryConstructor() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalInnerClassWithSecondaryConstructor.kt");
      }

      @Test
      @TestMetadata("initializationInLocalViaExplicitThis_after.kt")
      public void testInitializationInLocalViaExplicitThis_after() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalViaExplicitThis_after.kt");
      }

      @Test
      @TestMetadata("initializationInLocalViaExplicitThis_before.kt")
      public void testInitializationInLocalViaExplicitThis_before() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalViaExplicitThis_before.kt");
      }

      @Test
      @TestMetadata("inlinedBreakContinueFeatureDisabled.kt")
      public void testInlinedBreakContinueFeatureDisabled() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/inlinedBreakContinueFeatureDisabled.kt");
      }

      @Test
      @TestMetadata("kt1001.kt")
      public void testKt1001() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1001.kt");
      }

      @Test
      @TestMetadata("kt1027.kt")
      public void testKt1027() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1027.kt");
      }

      @Test
      @TestMetadata("kt1066.kt")
      public void testKt1066() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1066.kt");
      }

      @Test
      @TestMetadata("kt10805.kt")
      public void testKt10805() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt10805.kt");
      }

      @Test
      @TestMetadata("kt10823.kt")
      public void testKt10823() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt10823.kt");
      }

      @Test
      @TestMetadata("kt1156.kt")
      public void testKt1156() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1156.kt");
      }

      @Test
      @TestMetadata("kt1185enums.kt")
      public void testKt1185enums() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1185enums.kt");
      }

      @Test
      @TestMetadata("kt1189.kt")
      public void testKt1189() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1189.kt");
      }

      @Test
      @TestMetadata("kt1191.kt")
      public void testKt1191() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1191.kt");
      }

      @Test
      @TestMetadata("kt1219.1301.kt")
      public void testKt1219_1301() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1219.1301.kt");
      }

      @Test
      @TestMetadata("kt1571.kt")
      public void testKt1571() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1571.kt");
      }

      @Test
      @TestMetadata("kt1977.kt")
      public void testKt1977() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1977.kt");
      }

      @Test
      @TestMetadata("kt2166_kt2103.kt")
      public void testKt2166_kt2103() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2166_kt2103.kt");
      }

      @Test
      @TestMetadata("kt2226.kt")
      public void testKt2226() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2226.kt");
      }

      @Test
      @TestMetadata("kt2330.kt")
      public void testKt2330() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2330.kt");
      }

      @Test
      @TestMetadata("kt2334.kt")
      public void testKt2334() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2334.kt");
      }

      @Test
      @TestMetadata("kt2369.kt")
      public void testKt2369() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2369.kt");
      }

      @Test
      @TestMetadata("kt2845.kt")
      public void testKt2845() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2845.kt");
      }

      @Test
      @TestMetadata("kt2960.kt")
      public void testKt2960() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2960.kt");
      }

      @Test
      @TestMetadata("kt2972.kt")
      public void testKt2972() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2972.kt");
      }

      @Test
      @TestMetadata("kt3444.kt")
      public void testKt3444() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt3444.kt");
      }

      @Test
      @TestMetadata("kt3501.kt")
      public void testKt3501() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt3501.kt");
      }

      @Test
      @TestMetadata("kt4126.kt")
      public void testKt4126() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt4126.kt");
      }

      @Test
      @TestMetadata("kt4405.kt")
      public void testKt4405() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt4405.kt");
      }

      @Test
      @TestMetadata("kt510.kt")
      public void testKt510() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt510.kt");
      }

      @Test
      @TestMetadata("kt52131.kt")
      public void testKt52131() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt52131.kt");
      }

      @Test
      @TestMetadata("kt607.kt")
      public void testKt607() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt607.kt");
      }

      @Test
      @TestMetadata("kt609.kt")
      public void testKt609() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt609.kt");
      }

      @Test
      @TestMetadata("kt610.kt")
      public void testKt610() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt610.kt");
      }

      @Test
      @TestMetadata("kt6788.kt")
      public void testKt6788() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt6788.kt");
      }

      @Test
      @TestMetadata("kt776.kt")
      public void testKt776() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt776.kt");
      }

      @Test
      @TestMetadata("kt843.kt")
      public void testKt843() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt843.kt");
      }

      @Test
      @TestMetadata("kt897.kt")
      public void testKt897() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt897.kt");
      }

      @Test
      @TestMetadata("lambdaCaptureInConstructor.kt")
      public void testLambdaCaptureInConstructor() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/lambdaCaptureInConstructor.kt");
      }

      @Test
      @TestMetadata("lambdaCaptureInExtensionReceiver.kt")
      public void testLambdaCaptureInExtensionReceiver() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/lambdaCaptureInExtensionReceiver.kt");
      }

      @Test
      @TestMetadata("lambdaCaptureInJavaFunction.kt")
      public void testLambdaCaptureInJavaFunction() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/lambdaCaptureInJavaFunction.kt");
      }

      @Test
      @TestMetadata("lambdaCaptureInitializedPropertyInOtherArgument.kt")
      public void testLambdaCaptureInitializedPropertyInOtherArgument() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/lambdaCaptureInitializedPropertyInOtherArgument.kt");
      }

      @Test
      @TestMetadata("lambdaCaptureUninitializedInOtherArgument.kt")
      public void testLambdaCaptureUninitializedInOtherArgument() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/lambdaCaptureUninitializedInOtherArgument.kt");
      }

      @Test
      @TestMetadata("lambdaCaptureUninitializedProperty.kt")
      public void testLambdaCaptureUninitializedProperty() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/lambdaCaptureUninitializedProperty.kt");
      }

      @Test
      @TestMetadata("localClasses.kt")
      public void testLocalClasses() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/localClasses.kt");
      }

      @Test
      @TestMetadata("localObjectInConstructor.kt")
      public void testLocalObjectInConstructor() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/localObjectInConstructor.kt");
      }

      @Test
      @TestMetadata("loopWithNonTrivialBooleanConst_error.kt")
      public void testLoopWithNonTrivialBooleanConst_error() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/loopWithNonTrivialBooleanConst_error.kt");
      }

      @Test
      @TestMetadata("loopWithNonTrivialBooleanConst_warning.kt")
      public void testLoopWithNonTrivialBooleanConst_warning() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/loopWithNonTrivialBooleanConst_warning.kt");
      }

      @Test
      @TestMetadata("mainWithWarningOnUnusedParam.kt")
      public void testMainWithWarningOnUnusedParam() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/mainWithWarningOnUnusedParam.kt");
      }

      @Test
      @TestMetadata("nestedTryFinally.kt")
      public void testNestedTryFinally() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/nestedTryFinally.kt");
      }

      @Test
      @TestMetadata("nestedTryFinallyLambda.kt")
      public void testNestedTryFinallyLambda() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/nestedTryFinallyLambda.kt");
      }

      @Test
      @TestMetadata("nonLocalReturnUnreachable.kt")
      public void testNonLocalReturnUnreachable() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/nonLocalReturnUnreachable.kt");
      }

      @Test
      @TestMetadata("nonLocalReturnWithFinally.kt")
      public void testNonLocalReturnWithFinally() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/nonLocalReturnWithFinally.kt");
      }

      @Test
      @TestMetadata("privateSetter.kt")
      public void testPrivateSetter() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/privateSetter.kt");
      }

      @Test
      @TestMetadata("propertiesInitWithOtherInstance.kt")
      public void testPropertiesInitWithOtherInstance() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesInitWithOtherInstance.kt");
      }

      @Test
      @TestMetadata("propertiesInitWithOtherInstanceInner.kt")
      public void testPropertiesInitWithOtherInstanceInner() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesInitWithOtherInstanceInner.kt");
      }

      @Test
      @TestMetadata("propertiesInitWithOtherInstanceThisLabel.kt")
      public void testPropertiesInitWithOtherInstanceThisLabel() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesInitWithOtherInstanceThisLabel.kt");
      }

      @Test
      @TestMetadata("propertiesOrderInPackage.kt")
      public void testPropertiesOrderInPackage() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesOrderInPackage.kt");
      }

      @Test
      @TestMetadata("reassignmenGraphLoop.kt")
      public void testReassignmenGraphLoop() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmenGraphLoop.kt");
      }

      @Test
      @TestMetadata("reassignmentInCatch.kt")
      public void testReassignmentInCatch() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmentInCatch.kt");
      }

      @Test
      @TestMetadata("reassignmentInConcurrentLambdas.kt")
      public void testReassignmentInConcurrentLambdas() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmentInConcurrentLambdas.kt");
      }

      @Test
      @TestMetadata("reassignmentInLambda.kt")
      public void testReassignmentInLambda() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmentInLambda.kt");
      }

      @Test
      @TestMetadata("reassignmentInTryCatch.kt")
      public void testReassignmentInTryCatch() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmentInTryCatch.kt");
      }

      @Test
      @TestMetadata("reassignmentInTryCatchWithJumps.kt")
      public void testReassignmentInTryCatchWithJumps() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmentInTryCatchWithJumps.kt");
      }

      @Test
      @TestMetadata("reassignmentWithLambda.kt")
      public void testReassignmentWithLambda() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmentWithLambda.kt");
      }

      @Test
      @TestMetadata("referenceToPropertyInitializer.kt")
      public void testReferenceToPropertyInitializer() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/referenceToPropertyInitializer.kt");
      }

      @Test
      @TestMetadata("repeatUnitializedErrorOnlyForLocalVars.kt")
      public void testRepeatUnitializedErrorOnlyForLocalVars() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/repeatUnitializedErrorOnlyForLocalVars.kt");
      }

      @Test
      @TestMetadata("safeCallAfterVariableInitialization.kt")
      public void testSafeCallAfterVariableInitialization() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/safeCallAfterVariableInitialization.kt");
      }

      @Test
      @TestMetadata("scopeOfAnonymousInitializer.kt")
      public void testScopeOfAnonymousInitializer() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/scopeOfAnonymousInitializer.kt");
      }

      @Test
      @TestMetadata("smartCastInCatch.kt")
      public void testSmartCastInCatch() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/smartCastInCatch.kt");
      }

      @Test
      @TestMetadata("smartcastOnThisInInitializationSection.kt")
      public void testSmartcastOnThisInInitializationSection() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/smartcastOnThisInInitializationSection.kt");
      }

      @Test
      @TestMetadata("throwInLambda.kt")
      public void testThrowInLambda() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/throwInLambda.kt");
      }

      @Test
      @TestMetadata("tryCatchFinallyIfs.kt")
      public void testTryCatchFinallyIfs() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/tryCatchFinallyIfs.kt");
      }

      @Test
      @TestMetadata("tryWithAssignmentUsedInCatch.kt")
      public void testTryWithAssignmentUsedInCatch() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/tryWithAssignmentUsedInCatch.kt");
      }

      @Test
      @TestMetadata("uninintializedProperyWithDirectAndDelayedInitialization.kt")
      public void testUninintializedProperyWithDirectAndDelayedInitialization() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/uninintializedProperyWithDirectAndDelayedInitialization.kt");
      }

      @Test
      @TestMetadata("uninitializedCompanionOfEnum_after.kt")
      public void testUninitializedCompanionOfEnum_after() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/uninitializedCompanionOfEnum_after.kt");
      }

      @Test
      @TestMetadata("uninitializedCompanionOfEnum_before.kt")
      public void testUninitializedCompanionOfEnum_before() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/uninitializedCompanionOfEnum_before.kt");
      }

      @Test
      @TestMetadata("UninitializedEnumCompanionVals.kt")
      public void testUninitializedEnumCompanionVals() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/UninitializedEnumCompanionVals.kt");
      }

      @Test
      @TestMetadata("uninitializedInLocalDeclarations.kt")
      public void testUninitializedInLocalDeclarations() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/uninitializedInLocalDeclarations.kt");
      }

      @Test
      @TestMetadata("UninitializedOrReassignedVariables.kt")
      public void testUninitializedOrReassignedVariables() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/UninitializedOrReassignedVariables.kt");
      }

      @Test
      @TestMetadata("uninitializedQualifiedEnumEntry.kt")
      public void testUninitializedQualifiedEnumEntry() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/uninitializedQualifiedEnumEntry.kt");
      }

      @Test
      @TestMetadata("unmappedArgs.kt")
      public void testUnmappedArgs() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unmappedArgs.kt");
      }

      @Test
      @TestMetadata("unresolvedReference.kt")
      public void testUnresolvedReference() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unresolvedReference.kt");
      }

      @Test
      @TestMetadata("unusedPropertyWithCustomAccessors.kt")
      public void testUnusedPropertyWithCustomAccessors() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unusedPropertyWithCustomAccessors.kt");
      }

      @Test
      @TestMetadata("useUninitializedInLambda.kt")
      public void testUseUninitializedInLambda() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/useUninitializedInLambda.kt");
      }

      @Test
      @TestMetadata("varInitializationInIfInCycle.kt")
      public void testVarInitializationInIfInCycle() {
        runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/varInitializationInIfInCycle.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode")
      @TestDataPath("$PROJECT_ROOT")
      public class DeadCode {
        @Test
        public void testAllFilesPresentInDeadCode() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("commasAndWhitespaces.kt")
        public void testCommasAndWhitespaces() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/commasAndWhitespaces.kt");
        }

        @Test
        @TestMetadata("commentsInDeadCode.kt")
        public void testCommentsInDeadCode() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/commentsInDeadCode.kt");
        }

        @Test
        @TestMetadata("deadAnonymousObject.kt")
        public void testDeadAnonymousObject() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadAnonymousObject.kt");
        }

        @Test
        @TestMetadata("deadCallInInvokeCall.kt")
        public void testDeadCallInInvokeCall() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCallInInvokeCall.kt");
        }

        @Test
        @TestMetadata("deadCallInReceiver.kt")
        public void testDeadCallInReceiver() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCallInReceiver.kt");
        }

        @Test
        @TestMetadata("deadCodeDifferentExamples.kt")
        public void testDeadCodeDifferentExamples() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeDifferentExamples.kt");
        }

        @Test
        @TestMetadata("deadCodeFromDifferentSources.kt")
        public void testDeadCodeFromDifferentSources() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeFromDifferentSources.kt");
        }

        @Test
        @TestMetadata("deadCodeInArrayAccess.kt")
        public void testDeadCodeInArrayAccess() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInArrayAccess.kt");
        }

        @Test
        @TestMetadata("deadCodeInAssignment.kt")
        public void testDeadCodeInAssignment() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInAssignment.kt");
        }

        @Test
        @TestMetadata("deadCodeInBinaryExpressions.kt")
        public void testDeadCodeInBinaryExpressions() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInBinaryExpressions.kt");
        }

        @Test
        @TestMetadata("deadCodeInCalls.kt")
        public void testDeadCodeInCalls() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInCalls.kt");
        }

        @Test
        @TestMetadata("deadCodeInDeadCode.kt")
        public void testDeadCodeInDeadCode() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInDeadCode.kt");
        }

        @Test
        @TestMetadata("deadCodeInIf.kt")
        public void testDeadCodeInIf() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInIf.kt");
        }

        @Test
        @TestMetadata("deadCodeInInnerExpressions.kt")
        public void testDeadCodeInInnerExpressions() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInInnerExpressions.kt");
        }

        @Test
        @TestMetadata("deadCodeInLocalDeclarations.kt")
        public void testDeadCodeInLocalDeclarations() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInLocalDeclarations.kt");
        }

        @Test
        @TestMetadata("deadCodeInLoops.kt")
        public void testDeadCodeInLoops() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInLoops.kt");
        }

        @Test
        @TestMetadata("deadCodeInReturn.kt")
        public void testDeadCodeInReturn() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInReturn.kt");
        }

        @Test
        @TestMetadata("deadCodeInUnaryExpr.kt")
        public void testDeadCodeInUnaryExpr() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInUnaryExpr.kt");
        }

        @Test
        @TestMetadata("deadCodeInWhileFromBreak.kt")
        public void testDeadCodeInWhileFromBreak() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInWhileFromBreak.kt");
        }

        @Test
        @TestMetadata("deadLocalDeclaration.kt")
        public void testDeadLocalDeclaration() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadLocalDeclaration.kt");
        }

        @Test
        @TestMetadata("deadNestedDeclaration.kt")
        public void testDeadNestedDeclaration() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadNestedDeclaration.kt");
        }

        @Test
        @TestMetadata("deadPostponedLambda.kt")
        public void testDeadPostponedLambda() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadPostponedLambda.kt");
        }

        @Test
        @TestMetadata("expressionInUnitLiteral.kt")
        public void testExpressionInUnitLiteral() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/expressionInUnitLiteral.kt");
        }

        @Test
        @TestMetadata("initializationInUnreachableCode.kt")
        public void testInitializationInUnreachableCode() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/initializationInUnreachableCode.kt");
        }

        @Test
        @TestMetadata("kt2585_1.kt")
        public void testKt2585_1() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt2585_1.kt");
        }

        @Test
        @TestMetadata("kt2585_2.kt")
        public void testKt2585_2() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt2585_2.kt");
        }

        @Test
        @TestMetadata("kt2585_3.kt")
        public void testKt2585_3() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt2585_3.kt");
        }

        @Test
        @TestMetadata("kt3162tryAsInitializer.kt")
        public void testKt3162tryAsInitializer() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt3162tryAsInitializer.kt");
        }

        @Test
        @TestMetadata("kt5200DeadCodeInLambdas.kt")
        public void testKt5200DeadCodeInLambdas() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt5200DeadCodeInLambdas.kt");
        }

        @Test
        @TestMetadata("nonLocalJump.kt")
        public void testNonLocalJump() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/nonLocalJump.kt");
        }

        @Test
        @TestMetadata("reassignementInUnreachableCode.kt")
        public void testReassignementInUnreachableCode() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/reassignementInUnreachableCode.kt");
        }

        @Test
        @TestMetadata("returnInDeadLambda.kt")
        public void testReturnInDeadLambda() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/returnInDeadLambda.kt");
        }

        @Test
        @TestMetadata("smartCastAfterDeadCode.kt")
        public void testSmartCastAfterDeadCode() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/smartCastAfterDeadCode.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn")
      @TestDataPath("$PROJECT_ROOT")
      public class DefiniteReturn {
        @Test
        public void testAllFilesPresentInDefiniteReturn() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("elvisOperator.kt")
        public void testElvisOperator() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/elvisOperator.kt");
        }

        @Test
        @TestMetadata("InlineReturn.kt")
        public void testInlineReturn() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/InlineReturn.kt");
        }

        @Test
        @TestMetadata("kt3444_ReturnFromLocalFunctions.kt")
        public void testKt3444_ReturnFromLocalFunctions() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/kt3444_ReturnFromLocalFunctions.kt");
        }

        @Test
        @TestMetadata("kt4034.kt")
        public void testKt4034() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/kt4034.kt");
        }

        @Test
        @TestMetadata("lambdaInTryFalsePositive.kt")
        public void testLambdaInTryFalsePositive() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/lambdaInTryFalsePositive.kt");
        }

        @Test
        @TestMetadata("returnAliasedUnitNotRequired.kt")
        public void testReturnAliasedUnitNotRequired() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/returnAliasedUnitNotRequired.kt");
        }

        @Test
        @TestMetadata("ReturnFromFunctionInObject.kt")
        public void testReturnFromFunctionInObject() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/ReturnFromFunctionInObject.kt");
        }

        @Test
        @TestMetadata("simpleClass.kt")
        public void testSimpleClass() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/simpleClass.kt");
        }

        @Test
        @TestMetadata("singleReturnFromTry.kt")
        public void testSingleReturnFromTry() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/singleReturnFromTry.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/postponed")
      @TestDataPath("$PROJECT_ROOT")
      public class Postponed {
        @Test
        public void testAllFilesPresentInPostponed() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/postponed"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("postponedLambdaUnreachable.kt")
        public void testPostponedLambdaUnreachable() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/postponed/postponedLambdaUnreachable.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit")
      @TestDataPath("$PROJECT_ROOT")
      public class UnnecessaryLateinit {
        @Test
        public void testAllFilesPresentInUnnecessaryLateinit() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("lateinitRecursiveInLambda.kt")
        public void testLateinitRecursiveInLambda() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitRecursiveInLambda.kt");
        }

        @Test
        @TestMetadata("lateinitWithConstructor.kt")
        public void testLateinitWithConstructor() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithConstructor.kt");
        }

        @Test
        @TestMetadata("lateinitWithErroneousDelegation.kt")
        public void testLateinitWithErroneousDelegation() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithErroneousDelegation.kt");
        }

        @Test
        @TestMetadata("lateinitWithInit.kt")
        public void testLateinitWithInit() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithInit.kt");
        }

        @Test
        @TestMetadata("lateinitWithMultipleConstructors.kt")
        public void testLateinitWithMultipleConstructors() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithMultipleConstructors.kt");
        }

        @Test
        @TestMetadata("lateinitWithMultipleConstructorsAndDelegation.kt")
        public void testLateinitWithMultipleConstructorsAndDelegation() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithMultipleConstructorsAndDelegation.kt");
        }

        @Test
        @TestMetadata("lateinitWithPlusAssign.kt")
        public void testLateinitWithPlusAssign() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithPlusAssign.kt");
        }

        @Test
        @TestMetadata("lateinitWithPrimaryConstructorAndConstructor.kt")
        public void testLateinitWithPrimaryConstructorAndConstructor() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithPrimaryConstructorAndConstructor.kt");
        }

        @Test
        @TestMetadata("normalLateinit.kt")
        public void testNormalLateinit() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/normalLateinit.kt");
        }

        @Test
        @TestMetadata("normalLateinitWithTwoConstructors.kt")
        public void testNormalLateinitWithTwoConstructors() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/normalLateinitWithTwoConstructors.kt");
        }

        @Test
        @TestMetadata("secondaryConstructorDelegateItself.kt")
        public void testSecondaryConstructorDelegateItself() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/secondaryConstructorDelegateItself.kt");
        }

        @Test
        @TestMetadata("secondaryConstructorDelegateLoop.kt")
        public void testSecondaryConstructorDelegateLoop() {
          runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/secondaryConstructorDelegateLoop.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/controlStructures")
    @TestDataPath("$PROJECT_ROOT")
    public class ControlStructures {
      @Test
      public void testAllFilesPresentInControlStructures() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/controlStructures"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("breakContinueInCrossInlineLambda.kt")
      public void testBreakContinueInCrossInlineLambda() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/breakContinueInCrossInlineLambda.kt");
      }

      @Test
      @TestMetadata("breakContinueInNoInlineLambda.kt")
      public void testBreakContinueInNoInlineLambda() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/breakContinueInNoInlineLambda.kt");
      }

      @Test
      @TestMetadata("breakToLabel.kt")
      public void testBreakToLabel() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/breakToLabel.kt");
      }

      @Test
      @TestMetadata("catchGenerics.kt")
      public void testCatchGenerics() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/catchGenerics.kt");
      }

      @Test
      @TestMetadata("catchInnerClassesOfGenerics.kt")
      public void testCatchInnerClassesOfGenerics() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/catchInnerClassesOfGenerics.kt");
      }

      @Test
      @TestMetadata("catchInnerClassesOfGenerics_deprecation.kt")
      public void testCatchInnerClassesOfGenerics_deprecation() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/catchInnerClassesOfGenerics_deprecation.kt");
      }

      @Test
      @TestMetadata("catchOfTypeNothing.kt")
      public void testCatchOfTypeNothing() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/catchOfTypeNothing.kt");
      }

      @Test
      @TestMetadata("catchWithDefault.kt")
      public void testCatchWithDefault() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/catchWithDefault.kt");
      }

      @Test
      @TestMetadata("catchingLocalClassesCapturingTypeParameters.kt")
      public void testCatchingLocalClassesCapturingTypeParameters() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/catchingLocalClassesCapturingTypeParameters.kt");
      }

      @Test
      @TestMetadata("commonSupertypeOfT.kt")
      public void testCommonSupertypeOfT() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/commonSupertypeOfT.kt");
      }

      @Test
      @TestMetadata("continueAndBreakLabelWithSameFunctionName.kt")
      public void testContinueAndBreakLabelWithSameFunctionName() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/continueAndBreakLabelWithSameFunctionName.kt");
      }

      @Test
      @TestMetadata("continueInInitBlock.kt")
      public void testContinueInInitBlock() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/continueInInitBlock.kt");
      }

      @Test
      @TestMetadata("emptyIf.kt")
      public void testEmptyIf() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/emptyIf.kt");
      }

      @Test
      @TestMetadata("ForLoopWithExtensionIteratorOnNullable.kt")
      public void testForLoopWithExtensionIteratorOnNullable() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/ForLoopWithExtensionIteratorOnNullable.kt");
      }

      @Test
      @TestMetadata("forLoopWithNullableRange.kt")
      public void testForLoopWithNullableRange() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/forLoopWithNullableRange.kt");
      }

      @Test
      @TestMetadata("forWithIncorrectTypeSpecializer.kt")
      public void testForWithIncorrectTypeSpecializer() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/forWithIncorrectTypeSpecializer.kt");
      }

      @Test
      @TestMetadata("forWithNullableIterator.kt")
      public void testForWithNullableIterator() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/forWithNullableIterator.kt");
      }

      @Test
      @TestMetadata("ForWithoutBraces.kt")
      public void testForWithoutBraces() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/ForWithoutBraces.kt");
      }

      @Test
      @TestMetadata("ForbidStatementAsDirectFunctionBody.kt")
      public void testForbidStatementAsDirectFunctionBody() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/ForbidStatementAsDirectFunctionBody.kt");
      }

      @Test
      @TestMetadata("ifElseIntersection.kt")
      public void testIfElseIntersection() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/ifElseIntersection.kt");
      }

      @Test
      @TestMetadata("ifInResultOfLambda.kt")
      public void testIfInResultOfLambda() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/ifInResultOfLambda.kt");
      }

      @Test
      @TestMetadata("ifToAnyDiscriminatingUsages.kt")
      public void testIfToAnyDiscriminatingUsages() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/ifToAnyDiscriminatingUsages.kt");
      }

      @Test
      @TestMetadata("ifWhenToAnyComplexExpressions.kt")
      public void testIfWhenToAnyComplexExpressions() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/ifWhenToAnyComplexExpressions.kt");
      }

      @Test
      @TestMetadata("ifWhenWithoutElse.kt")
      public void testIfWhenWithoutElse() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/ifWhenWithoutElse.kt");
      }

      @Test
      @TestMetadata("improperElseInExpression.kt")
      public void testImproperElseInExpression() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/improperElseInExpression.kt");
      }

      @Test
      @TestMetadata("incorrectElvis.kt")
      public void testIncorrectElvis() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/incorrectElvis.kt");
      }

      @Test
      @TestMetadata("jumpAcrossFunctionBoundary.kt")
      public void testJumpAcrossFunctionBoundary() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/jumpAcrossFunctionBoundary.kt");
      }

      @Test
      @TestMetadata("kt10322.kt")
      public void testKt10322() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/kt10322.kt");
      }

      @Test
      @TestMetadata("kt10706.kt")
      public void testKt10706() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/kt10706.kt");
      }

      @Test
      @TestMetadata("kt10717.kt")
      public void testKt10717() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/kt10717.kt");
      }

      @Test
      @TestMetadata("kt1075.kt")
      public void testKt1075() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/kt1075.kt");
      }

      @Test
      @TestMetadata("kt30406.kt")
      public void testKt30406() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/kt30406.kt");
      }

      @Test
      @TestMetadata("kt4310.kt")
      public void testKt4310() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/kt4310.kt");
      }

      @Test
      @TestMetadata("kt51711.kt")
      public void testKt51711() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/kt51711.kt");
      }

      @Test
      @TestMetadata("kt657.kt")
      public void testKt657() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/kt657.kt");
      }

      @Test
      @TestMetadata("kt770.kt351.kt735_StatementType.kt")
      public void testKt770_kt351_kt735_StatementType() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/kt770.kt351.kt735_StatementType.kt");
      }

      @Test
      @TestMetadata("kt786.kt")
      public void testKt786() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/kt786.kt");
      }

      @Test
      @TestMetadata("kt799.kt")
      public void testKt799() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/kt799.kt");
      }

      @Test
      @TestMetadata("lambdasInExclExclAndElvis.kt")
      public void testLambdasInExclExclAndElvis() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/lambdasInExclExclAndElvis.kt");
      }

      @Test
      @TestMetadata("localReturnInsidePropertyAccessor.kt")
      public void testLocalReturnInsidePropertyAccessor() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/localReturnInsidePropertyAccessor.kt");
      }

      @Test
      @TestMetadata("nestedLoopsWithMultipleLabels.kt")
      public void testNestedLoopsWithMultipleLabels() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/nestedLoopsWithMultipleLabels.kt");
      }

      @Test
      @TestMetadata("noTypeMismatchWithWhenWithoutElse.kt")
      public void testNoTypeMismatchWithWhenWithoutElse() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/noTypeMismatchWithWhenWithoutElse.kt");
      }

      @Test
      @TestMetadata("nonExhaustiveIfInElvis_after.kt")
      public void testNonExhaustiveIfInElvis_after() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/nonExhaustiveIfInElvis_after.kt");
      }

      @Test
      @TestMetadata("nonExhaustiveIfInElvis_before.kt")
      public void testNonExhaustiveIfInElvis_before() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/nonExhaustiveIfInElvis_before.kt");
      }

      @Test
      @TestMetadata("notAFunctionLabel_after.kt")
      public void testNotAFunctionLabel_after() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/notAFunctionLabel_after.kt");
      }

      @Test
      @TestMetadata("redundantLabel.kt")
      public void testRedundantLabel() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/redundantLabel.kt");
      }

      @Test
      @TestMetadata("specialConstructsAndPlatformTypes.kt")
      public void testSpecialConstructsAndPlatformTypes() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/specialConstructsAndPlatformTypes.kt");
      }

      @Test
      @TestMetadata("specialConstructsWithNullableExpectedType.kt")
      public void testSpecialConstructsWithNullableExpectedType() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/specialConstructsWithNullableExpectedType.kt");
      }

      @Test
      @TestMetadata("tryReturnType.kt")
      public void testTryReturnType() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/tryReturnType.kt");
      }

      @Test
      @TestMetadata("typeInferenceForExclExcl.kt")
      public void testTypeInferenceForExclExcl() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/typeInferenceForExclExcl.kt");
      }

      @Test
      @TestMetadata("valVarCatchParameter.kt")
      public void testValVarCatchParameter() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/valVarCatchParameter.kt");
      }

      @Test
      @TestMetadata("valVarLoopParameter.kt")
      public void testValVarLoopParameter() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/valVarLoopParameter.kt");
      }

      @Test
      @TestMetadata("whenInResultOfLambda.kt")
      public void testWhenInResultOfLambda() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/whenInResultOfLambda.kt");
      }

      @Test
      @TestMetadata("whenToAnyDiscriminatingUsages.kt")
      public void testWhenToAnyDiscriminatingUsages() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/whenToAnyDiscriminatingUsages.kt");
      }

      @Test
      @TestMetadata("whenWithNoSubjectAndCommas.kt")
      public void testWhenWithNoSubjectAndCommas() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/whenWithNoSubjectAndCommas.kt");
      }

      @Test
      @TestMetadata("whenWithNothingTypedSubject.kt")
      public void testWhenWithNothingTypedSubject() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/whenWithNothingTypedSubject.kt");
      }

      @Test
      @TestMetadata("when.kt234.kt973.kt")
      public void testWhen_kt234_kt973() {
        runTest("compiler/testData/diagnostics/tests/controlStructures/when.kt234.kt973.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/coroutines")
    @TestDataPath("$PROJECT_ROOT")
    public class Coroutines {
      @Test
      public void testAllFilesPresentInCoroutines() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("inlineSuspendTypealias.kt")
      public void testInlineSuspendTypealias() {
        runTest("compiler/testData/diagnostics/tests/coroutines/inlineSuspendTypealias.kt");
      }

      @Test
      @TestMetadata("modifierFormBuiltinSuspendFun.kt")
      public void testModifierFormBuiltinSuspendFun() {
        runTest("compiler/testData/diagnostics/tests/coroutines/modifierFormBuiltinSuspendFun.kt");
      }

      @Test
      @TestMetadata("suspendCallInInit.kt")
      public void testSuspendCallInInit() {
        runTest("compiler/testData/diagnostics/tests/coroutines/suspendCallInInit.kt");
      }

      @Test
      @TestMetadata("suspendInvokeInsideTry.kt")
      public void testSuspendInvokeInsideTry() {
        runTest("compiler/testData/diagnostics/tests/coroutines/suspendInvokeInsideTry.kt");
      }

      @Test
      @TestMetadata("suspendInvokeInsideWhen.kt")
      public void testSuspendInvokeInsideWhen() {
        runTest("compiler/testData/diagnostics/tests/coroutines/suspendInvokeInsideWhen.kt");
      }

      @Test
      @TestMetadata("suspendInvokeWithReceiver.kt")
      public void testSuspendInvokeWithReceiver() {
        runTest("compiler/testData/diagnostics/tests/coroutines/suspendInvokeWithReceiver.kt");
      }

      @Test
      @TestMetadata("suspendLambdaFromExpectedType.kt")
      public void testSuspendLambdaFromExpectedType() {
        runTest("compiler/testData/diagnostics/tests/coroutines/suspendLambdaFromExpectedType.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/coroutines/callableReference")
      @TestDataPath("$PROJECT_ROOT")
      public class CallableReference {
        @Test
        public void testAllFilesPresentInCallableReference() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines/callableReference"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("invokeOutideSuspend.kt")
        public void testInvokeOutideSuspend() {
          runTest("compiler/testData/diagnostics/tests/coroutines/callableReference/invokeOutideSuspend.kt");
        }

        @Test
        @TestMetadata("outsideSuspend.kt")
        public void testOutsideSuspend() {
          runTest("compiler/testData/diagnostics/tests/coroutines/callableReference/outsideSuspend.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype")
      @TestDataPath("$PROJECT_ROOT")
      public class SuspendFunctionAsSupertype {
        @Test
        public void testAllFilesPresentInSuspendFunctionAsSupertype() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN")
        @TestDataPath("$PROJECT_ROOT")
        public class KSuspendFunctionN {
          @Test
          public void testAllFilesPresentInKSuspendFunctionN() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("mixingSuspendAndNonSuspendSupertypes.kt")
          public void testMixingSuspendAndNonSuspendSupertypes() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN/mixingSuspendAndNonSuspendSupertypes.kt");
          }

          @Test
          @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperClass.kt")
          public void testMixingSuspendAndNonSuspendSupertypesThruSuperClass() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN/mixingSuspendAndNonSuspendSupertypesThruSuperClass.kt");
          }

          @Test
          @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperFunInterface.kt")
          public void testMixingSuspendAndNonSuspendSupertypesThruSuperFunInterface() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN/mixingSuspendAndNonSuspendSupertypesThruSuperFunInterface.kt");
          }

          @Test
          @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperinterface.kt")
          public void testMixingSuspendAndNonSuspendSupertypesThruSuperinterface() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN/mixingSuspendAndNonSuspendSupertypesThruSuperinterface.kt");
          }

          @Test
          @TestMetadata("simple.kt")
          public void testSimple() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN/simple.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple")
        @TestDataPath("$PROJECT_ROOT")
        public class Simple {
          @Test
          public void testAllFilesPresentInSimple() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("mixingSuspendAndNonSuspendSupertypes.kt")
          public void testMixingSuspendAndNonSuspendSupertypes() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple/mixingSuspendAndNonSuspendSupertypes.kt");
          }

          @Test
          @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperClass.kt")
          public void testMixingSuspendAndNonSuspendSupertypesThruSuperClass() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple/mixingSuspendAndNonSuspendSupertypesThruSuperClass.kt");
          }

          @Test
          @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperFunInterface.kt")
          public void testMixingSuspendAndNonSuspendSupertypesThruSuperFunInterface() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple/mixingSuspendAndNonSuspendSupertypesThruSuperFunInterface.kt");
          }

          @Test
          @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperinterface.kt")
          public void testMixingSuspendAndNonSuspendSupertypesThruSuperinterface() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple/mixingSuspendAndNonSuspendSupertypesThruSuperinterface.kt");
          }

          @Test
          @TestMetadata("simple.kt")
          public void testSimple() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple/simple.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN")
        @TestDataPath("$PROJECT_ROOT")
        public class SuspendFunctionN {
          @Test
          public void testAllFilesPresentInSuspendFunctionN() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("mixingSuspendAndNonSuspendSupertypes.kt")
          public void testMixingSuspendAndNonSuspendSupertypes() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN/mixingSuspendAndNonSuspendSupertypes.kt");
          }

          @Test
          @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperClass.kt")
          public void testMixingSuspendAndNonSuspendSupertypesThruSuperClass() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN/mixingSuspendAndNonSuspendSupertypesThruSuperClass.kt");
          }

          @Test
          @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperFunInterface.kt")
          public void testMixingSuspendAndNonSuspendSupertypesThruSuperFunInterface() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN/mixingSuspendAndNonSuspendSupertypesThruSuperFunInterface.kt");
          }

          @Test
          @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperinterface.kt")
          public void testMixingSuspendAndNonSuspendSupertypesThruSuperinterface() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN/mixingSuspendAndNonSuspendSupertypesThruSuperinterface.kt");
          }

          @Test
          @TestMetadata("simple.kt")
          public void testSimple() {
            runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN/simple.kt");
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy")
    @TestDataPath("$PROJECT_ROOT")
    public class CyclicHierarchy {
      @Test
      public void testAllFilesPresentInCyclicHierarchy() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/cyclicHierarchy"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("classIndirectlyInheritsNested.kt")
      public void testClassIndirectlyInheritsNested() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/classIndirectlyInheritsNested.kt");
      }

      @Test
      @TestMetadata("classInheritsNested.kt")
      public void testClassInheritsNested() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/classInheritsNested.kt");
      }

      @Test
      @TestMetadata("commonSupertypeForCyclicAndUsualTypes.kt")
      public void testCommonSupertypeForCyclicAndUsualTypes() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/commonSupertypeForCyclicAndUsualTypes.kt");
      }

      @Test
      @TestMetadata("commonSupertypeForCyclicTypes.kt")
      public void testCommonSupertypeForCyclicTypes() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/commonSupertypeForCyclicTypes.kt");
      }

      @Test
      @TestMetadata("cyclicHierarchy.kt")
      public void testCyclicHierarchy() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/cyclicHierarchy.kt");
      }

      @Test
      @TestMetadata("javaJavaCycle.kt")
      public void testJavaJavaCycle() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/javaJavaCycle.kt");
      }

      @Test
      @TestMetadata("javaJavaNested.kt")
      public void testJavaJavaNested() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/javaJavaNested.kt");
      }

      @Test
      @TestMetadata("javaKotlinJavaCycle.kt")
      public void testJavaKotlinJavaCycle() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/javaKotlinJavaCycle.kt");
      }

      @Test
      @TestMetadata("kotlinJavaCycle.kt")
      public void testKotlinJavaCycle() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/kotlinJavaCycle.kt");
      }

      @Test
      @TestMetadata("kotlinJavaKotlinCycle.kt")
      public void testKotlinJavaKotlinCycle() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/kotlinJavaKotlinCycle.kt");
      }

      @Test
      @TestMetadata("kotlinJavaNestedCycle.kt")
      public void testKotlinJavaNestedCycle() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/kotlinJavaNestedCycle.kt");
      }

      @Test
      @TestMetadata("kt303.kt")
      public void testKt303() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/kt303.kt");
      }

      @Test
      @TestMetadata("nestedClassInSuperClassParameter.kt")
      public void testNestedClassInSuperClassParameter() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/nestedClassInSuperClassParameter.kt");
      }

      @Test
      @TestMetadata("objectInheritsNested.kt")
      public void testObjectInheritsNested() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/objectInheritsNested.kt");
      }

      @Test
      @TestMetadata("twoClassesWithNestedCycle.kt")
      public void testTwoClassesWithNestedCycle() {
        runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/twoClassesWithNestedCycle.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion")
      @TestDataPath("$PROJECT_ROOT")
      public class WithCompanion {
        @Test
        public void testAllFilesPresentInWithCompanion() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("everythingInOneScope_after.kt")
        public void testEverythingInOneScope_after() {
          runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/everythingInOneScope_after.kt");
        }

        @Test
        @TestMetadata("everythingInOneScope_before.kt")
        public void testEverythingInOneScope_before() {
          runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/everythingInOneScope_before.kt");
        }

        @Test
        @TestMetadata("noMembers_after.kt")
        public void testNoMembers_after() {
          runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/noMembers_after.kt");
        }

        @Test
        @TestMetadata("noMembers_before.kt")
        public void testNoMembers_before() {
          runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/noMembers_before.kt");
        }

        @Test
        @TestMetadata("onlyInterfaces_after.kt")
        public void testOnlyInterfaces_after() {
          runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/onlyInterfaces_after.kt");
        }

        @Test
        @TestMetadata("onlyInterfaces_before.kt")
        public void testOnlyInterfaces_before() {
          runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/onlyInterfaces_before.kt");
        }

        @Test
        @TestMetadata("typeIsLowEnough.kt")
        public void testTypeIsLowEnough() {
          runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/typeIsLowEnough.kt");
        }

        @Test
        @TestMetadata("withIrrelevantInterface_after.kt")
        public void testWithIrrelevantInterface_after() {
          runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withIrrelevantInterface_after.kt");
        }

        @Test
        @TestMetadata("withIrrelevantInterface_before.kt")
        public void testWithIrrelevantInterface_before() {
          runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withIrrelevantInterface_before.kt");
        }

        @Test
        @TestMetadata("withMembers_after.kt")
        public void testWithMembers_after() {
          runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withMembers_after.kt");
        }

        @Test
        @TestMetadata("withMembers_before.kt")
        public void testWithMembers_before() {
          runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withMembers_before.kt");
        }

        @Test
        @TestMetadata("withoutTypeReference.kt")
        public void testWithoutTypeReference() {
          runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withoutTypeReference.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor")
    @TestDataPath("$PROJECT_ROOT")
    public class DataClassNonPublicConstructor {
      @Test
      public void testAllFilesPresentInDataClassNonPublicConstructor() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("deprecationPhase1_incompatibleAnnotations.kt")
      public void testDeprecationPhase1_incompatibleAnnotations() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase1_incompatibleAnnotations.kt");
      }

      @Test
      @TestMetadata("deprecationPhase1_inlineFun.kt")
      public void testDeprecationPhase1_inlineFun() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase1_inlineFun.kt");
      }

      @Test
      @TestMetadata("deprecationPhase1_inlineFun_privateToThis.kt")
      public void testDeprecationPhase1_inlineFun_privateToThis() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase1_inlineFun_privateToThis.kt");
      }

      @Test
      @TestMetadata("deprecationPhase1_optIn.kt")
      public void testDeprecationPhase1_optIn() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase1_optIn.kt");
      }

      @Test
      @TestMetadata("deprecationPhase1_optOut.kt")
      public void testDeprecationPhase1_optOut() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase1_optOut.kt");
      }

      @Test
      @TestMetadata("deprecationPhase1_warning.kt")
      public void testDeprecationPhase1_warning() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase1_warning.kt");
      }

      @Test
      @TestMetadata("deprecationPhase1_wrongAnnotationTarget.kt")
      public void testDeprecationPhase1_wrongAnnotationTarget() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase1_wrongAnnotationTarget.kt");
      }

      @Test
      @TestMetadata("deprecationPhase2_customCopy.kt")
      public void testDeprecationPhase2_customCopy() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase2_customCopy.kt");
      }

      @Test
      @TestMetadata("deprecationPhase2_inlineFun.kt")
      public void testDeprecationPhase2_inlineFun() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase2_inlineFun.kt");
      }

      @Test
      @TestMetadata("deprecationPhase2_internalConstructor.kt")
      public void testDeprecationPhase2_internalConstructor() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase2_internalConstructor.kt");
      }

      @Test
      @TestMetadata("deprecationPhase2_optIn.kt")
      public void testDeprecationPhase2_optIn() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase2_optIn.kt");
      }

      @Test
      @TestMetadata("deprecationPhase2_optOut.kt")
      public void testDeprecationPhase2_optOut() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase2_optOut.kt");
      }

      @Test
      @TestMetadata("deprecationPhase2_privateConstructor.kt")
      public void testDeprecationPhase2_privateConstructor() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase2_privateConstructor.kt");
      }

      @Test
      @TestMetadata("deprecationPhase2_protectedConstructor.kt")
      public void testDeprecationPhase2_protectedConstructor() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase2_protectedConstructor.kt");
      }

      @Test
      @TestMetadata("deprecationPhase3_inlineFun.kt")
      public void testDeprecationPhase3_inlineFun() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase3_inlineFun.kt");
      }

      @Test
      @TestMetadata("deprecationPhase3_invisibleReference.kt")
      public void testDeprecationPhase3_invisibleReference() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase3_invisibleReference.kt");
      }

      @Test
      @TestMetadata("deprecationPhase3_optIn.kt")
      public void testDeprecationPhase3_optIn() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase3_optIn.kt");
      }

      @Test
      @TestMetadata("deprecationPhase3_optOut.kt")
      public void testDeprecationPhase3_optOut() {
        runTest("compiler/testData/diagnostics/tests/dataClassNonPublicConstructor/deprecationPhase3_optOut.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/dataClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class DataClasses {
      @Test
      public void testAllFilesPresentInDataClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataClasses"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("companionDataObject.kt")
      public void testCompanionDataObject() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/companionDataObject.kt");
      }

      @Test
      @TestMetadata("componentNamedComponent1.kt")
      public void testComponentNamedComponent1() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/componentNamedComponent1.kt");
      }

      @Test
      @TestMetadata("conflictingCopyOverloads.kt")
      public void testConflictingCopyOverloads() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/conflictingCopyOverloads.kt");
      }

      @Test
      @TestMetadata("conflictingOverloads.kt")
      public void testConflictingOverloads() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/conflictingOverloads.kt");
      }

      @Test
      @TestMetadata("copyInDataObject.kt")
      public void testCopyInDataObject() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/copyInDataObject.kt");
      }

      @Test
      @TestMetadata("copyOfPrivateClass.kt")
      public void testCopyOfPrivateClass() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/copyOfPrivateClass.kt");
      }

      @Test
      @TestMetadata("dataClassExplicitlyOverridingCopyNoDefaults.kt")
      public void testDataClassExplicitlyOverridingCopyNoDefaults() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassExplicitlyOverridingCopyNoDefaults.kt");
      }

      @Test
      @TestMetadata("dataClassExplicitlyOverridingCopyWithDefaults.kt")
      public void testDataClassExplicitlyOverridingCopyWithDefaults() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassExplicitlyOverridingCopyWithDefaults.kt");
      }

      @Test
      @TestMetadata("dataClassNoName.kt")
      public void testDataClassNoName() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassNoName.kt");
      }

      @Test
      @TestMetadata("dataClassNotOverridingCopy.kt")
      public void testDataClassNotOverridingCopy() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassNotOverridingCopy.kt");
      }

      @Test
      @TestMetadata("dataClassOverridingCopy_lv12.kt")
      public void testDataClassOverridingCopy_lv12() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassOverridingCopy_lv12.kt");
      }

      @Test
      @TestMetadata("dataClassOverridingCopy_lv13.kt")
      public void testDataClassOverridingCopy_lv13() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassOverridingCopy_lv13.kt");
      }

      @Test
      @TestMetadata("dataClassVarargParam.kt")
      public void testDataClassVarargParam() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassVarargParam.kt");
      }

      @Test
      @TestMetadata("dataInheritance.kt")
      public void testDataInheritance() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/dataInheritance.kt");
      }

      @Test
      @TestMetadata("dataObjectDisabled.kt")
      public void testDataObjectDisabled() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/dataObjectDisabled.kt");
      }

      @Test
      @TestMetadata("dataObjectEnabled.kt")
      public void testDataObjectEnabled() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/dataObjectEnabled.kt");
      }

      @Test
      @TestMetadata("dataObjectLiteral.kt")
      public void testDataObjectLiteral() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/dataObjectLiteral.kt");
      }

      @Test
      @TestMetadata("emptyConstructor.kt")
      public void testEmptyConstructor() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/emptyConstructor.kt");
      }

      @Test
      @TestMetadata("errorTypesInDataClasses.kt")
      public void testErrorTypesInDataClasses() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/errorTypesInDataClasses.kt");
      }

      @Test
      @TestMetadata("extensionComponentsOnNullable.kt")
      public void testExtensionComponentsOnNullable() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/extensionComponentsOnNullable.kt");
      }

      @Test
      @TestMetadata("finalMembersInBaseClass.kt")
      public void testFinalMembersInBaseClass() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/finalMembersInBaseClass.kt");
      }

      @Test
      @TestMetadata("implementMethodsFromInterface.kt")
      public void testImplementMethodsFromInterface() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/implementMethodsFromInterface.kt");
      }

      @Test
      @TestMetadata("implementTraitWhichHasComponent1.kt")
      public void testImplementTraitWhichHasComponent1() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/implementTraitWhichHasComponent1.kt");
      }

      @Test
      @TestMetadata("implementTraitWhichHasFinalComponent1.kt")
      public void testImplementTraitWhichHasFinalComponent1() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/implementTraitWhichHasFinalComponent1.kt");
      }

      @Test
      @TestMetadata("innerDataClass.kt")
      public void testInnerDataClass() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/innerDataClass.kt");
      }

      @Test
      @TestMetadata("innerOuterDataClass.kt")
      public void testInnerOuterDataClass() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/innerOuterDataClass.kt");
      }

      @Test
      @TestMetadata("multiDeclaration.kt")
      public void testMultiDeclaration() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/multiDeclaration.kt");
      }

      @Test
      @TestMetadata("multiDeclarationFor.kt")
      public void testMultiDeclarationFor() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/multiDeclarationFor.kt");
      }

      @Test
      @TestMetadata("noConstructor.kt")
      public void testNoConstructor() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/noConstructor.kt");
      }

      @Test
      @TestMetadata("notADataClass.kt")
      public void testNotADataClass() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/notADataClass.kt");
      }

      @Test
      @TestMetadata("oneValParam.kt")
      public void testOneValParam() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/oneValParam.kt");
      }

      @Test
      @TestMetadata("propertyTypeCollision.kt")
      public void testPropertyTypeCollision() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/propertyTypeCollision.kt");
      }

      @Test
      @TestMetadata("propertyTypeCollisionAndAnnotations.kt")
      public void testPropertyTypeCollisionAndAnnotations() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/propertyTypeCollisionAndAnnotations.kt");
      }

      @Test
      @TestMetadata("repeatedProperties.kt")
      public void testRepeatedProperties() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/repeatedProperties.kt");
      }

      @Test
      @TestMetadata("sealedDataClass.kt")
      public void testSealedDataClass() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/sealedDataClass.kt");
      }

      @Test
      @TestMetadata("strange.kt")
      public void testStrange() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/strange.kt");
      }

      @Test
      @TestMetadata("twoValParams.kt")
      public void testTwoValParams() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/twoValParams.kt");
      }

      @Test
      @TestMetadata("twoVarParams.kt")
      public void testTwoVarParams() {
        runTest("compiler/testData/diagnostics/tests/dataClasses/twoVarParams.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/dataFlow")
    @TestDataPath("$PROJECT_ROOT")
    public class DataFlow {
      @Test
      public void testAllFilesPresentInDataFlow() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlow"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("CalleeExpression.kt")
      public void testCalleeExpression() {
        runTest("compiler/testData/diagnostics/tests/dataFlow/CalleeExpression.kt");
      }

      @Test
      @TestMetadata("desugaredAssignment.kt")
      public void testDesugaredAssignment() {
        runTest("compiler/testData/diagnostics/tests/dataFlow/desugaredAssignment.kt");
      }

      @Test
      @TestMetadata("EmptyIf.kt")
      public void testEmptyIf() {
        runTest("compiler/testData/diagnostics/tests/dataFlow/EmptyIf.kt");
      }

      @Test
      @TestMetadata("IsExpression.kt")
      public void testIsExpression() {
        runTest("compiler/testData/diagnostics/tests/dataFlow/IsExpression.kt");
      }

      @Test
      @TestMetadata("MultipleBranchesInWhileLoopInInlinedLambda.kt")
      public void testMultipleBranchesInWhileLoopInInlinedLambda() {
        runTest("compiler/testData/diagnostics/tests/dataFlow/MultipleBranchesInWhileLoopInInlinedLambda.kt");
      }

      @Test
      @TestMetadata("smartCastWithLambdaAndCallableReference.kt")
      public void testSmartCastWithLambdaAndCallableReference() {
        runTest("compiler/testData/diagnostics/tests/dataFlow/smartCastWithLambdaAndCallableReference.kt");
      }

      @Test
      @TestMetadata("WhenSubject.kt")
      public void testWhenSubject() {
        runTest("compiler/testData/diagnostics/tests/dataFlow/WhenSubject.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/dataFlow/assignment")
      @TestDataPath("$PROJECT_ROOT")
      public class Assignment {
        @Test
        public void testAllFilesPresentInAssignment() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlow/assignment"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("assignToNewVal.kt")
        public void testAssignToNewVal() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/assignToNewVal.kt");
        }

        @Test
        @TestMetadata("kt6118.kt")
        public void testKt6118() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/kt6118.kt");
        }

        @Test
        @TestMetadata("uninitializedValIsCheck.kt")
        public void testUninitializedValIsCheck() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/uninitializedValIsCheck.kt");
        }

        @Test
        @TestMetadata("uninitializedValNullability.kt")
        public void testUninitializedValNullability() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/uninitializedValNullability.kt");
        }

        @Test
        @TestMetadata("when.kt")
        public void testWhen() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/when.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/dataFlow/local")
      @TestDataPath("$PROJECT_ROOT")
      public class Local {
        @Test
        public void testAllFilesPresentInLocal() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlow/local"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("kt2835.kt")
        public void testKt2835() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/local/kt2835.kt");
        }

        @Test
        @TestMetadata("LocalClassBase.kt")
        public void testLocalClassBase() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassBase.kt");
        }

        @Test
        @TestMetadata("LocalClassDefaultParameters.kt")
        public void testLocalClassDefaultParameters() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassDefaultParameters.kt");
        }

        @Test
        @TestMetadata("LocalClassDelegatedProperties.kt")
        public void testLocalClassDelegatedProperties() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassDelegatedProperties.kt");
        }

        @Test
        @TestMetadata("LocalClassDelegation.kt")
        public void testLocalClassDelegation() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassDelegation.kt");
        }

        @Test
        @TestMetadata("LocalClassFunctions.kt")
        public void testLocalClassFunctions() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassFunctions.kt");
        }

        @Test
        @TestMetadata("LocalClassInMemberOfLocalClass.kt")
        public void testLocalClassInMemberOfLocalClass() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassInMemberOfLocalClass.kt");
        }

        @Test
        @TestMetadata("LocalClassInitializer.kt")
        public void testLocalClassInitializer() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassInitializer.kt");
        }

        @Test
        @TestMetadata("LocalClassProperty.kt")
        public void testLocalClassProperty() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassProperty.kt");
        }

        @Test
        @TestMetadata("LocalObject.kt")
        public void testLocalObject() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalObject.kt");
        }

        @Test
        @TestMetadata("LocalObjectDelegation.kt")
        public void testLocalObjectDelegation() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalObjectDelegation.kt");
        }

        @Test
        @TestMetadata("NestedLocalClass.kt")
        public void testNestedLocalClass() {
          runTest("compiler/testData/diagnostics/tests/dataFlow/local/NestedLocalClass.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal")
    @TestDataPath("$PROJECT_ROOT")
    public class DataFlowInfoTraversal {
      @Test
      public void testAllFilesPresentInDataFlowInfoTraversal() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlowInfoTraversal"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("AndOr.kt")
      public void testAndOr() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AndOr.kt");
      }

      @Test
      @TestMetadata("ArrayAccess.kt")
      public void testArrayAccess() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayAccess.kt");
      }

      @Test
      @TestMetadata("ArrayExpression.kt")
      public void testArrayExpression() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayExpression.kt");
      }

      @Test
      @TestMetadata("ArrayGetSetConvention.kt")
      public void testArrayGetSetConvention() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayGetSetConvention.kt");
      }

      @Test
      @TestMetadata("ArrayIndices.kt")
      public void testArrayIndices() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayIndices.kt");
      }

      @Test
      @TestMetadata("Assignment.kt")
      public void testAssignment() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Assignment.kt");
      }

      @Test
      @TestMetadata("AssignmentInInitializer.kt")
      public void testAssignmentInInitializer() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AssignmentInInitializer.kt");
      }

      @Test
      @TestMetadata("AssignmentOperation.kt")
      public void testAssignmentOperation() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AssignmentOperation.kt");
      }

      @Test
      @TestMetadata("AssignmentToArrayElement.kt")
      public void testAssignmentToArrayElement() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AssignmentToArrayElement.kt");
      }

      @Test
      @TestMetadata("BinaryExpression.kt")
      public void testBinaryExpression() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpression.kt");
      }

      @Test
      @TestMetadata("BinaryExpressionBooleanOperations.kt")
      public void testBinaryExpressionBooleanOperations() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionBooleanOperations.kt");
      }

      @Test
      @TestMetadata("BinaryExpressionCompareToConvention.kt")
      public void testBinaryExpressionCompareToConvention() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionCompareToConvention.kt");
      }

      @Test
      @TestMetadata("BinaryExpressionContainsConvention.kt")
      public void testBinaryExpressionContainsConvention() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionContainsConvention.kt");
      }

      @Test
      @TestMetadata("BinaryExpressionElvis.kt")
      public void testBinaryExpressionElvis() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionElvis.kt");
      }

      @Test
      @TestMetadata("BinaryExpressionEqualsConvention.kt")
      public void testBinaryExpressionEqualsConvention() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionEqualsConvention.kt");
      }

      @Test
      @TestMetadata("BinaryExpressionIdentifier.kt")
      public void testBinaryExpressionIdentifier() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionIdentifier.kt");
      }

      @Test
      @TestMetadata("BinaryExpressionPlusConvention.kt")
      public void testBinaryExpressionPlusConvention() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionPlusConvention.kt");
      }

      @Test
      @TestMetadata("Condition.kt")
      public void testCondition() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Condition.kt");
      }

      @Test
      @TestMetadata("ContinueOuterLoop.kt")
      public void testContinueOuterLoop() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ContinueOuterLoop.kt");
      }

      @Test
      @TestMetadata("DeepIf.kt")
      public void testDeepIf() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/DeepIf.kt");
      }

      @Test
      @TestMetadata("DoWhile.kt")
      public void testDoWhile() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/DoWhile.kt");
      }

      @Test
      @TestMetadata("DoWhileCondition.kt")
      public void testDoWhileCondition() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/DoWhileCondition.kt");
      }

      @Test
      @TestMetadata("Elvis.kt")
      public void testElvis() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Elvis.kt");
      }

      @Test
      @TestMetadata("ExclExcl.kt")
      public void testExclExcl() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ExclExcl.kt");
      }

      @Test
      @TestMetadata("For.kt")
      public void testFor() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/For.kt");
      }

      @Test
      @TestMetadata("ForLoopRange.kt")
      public void testForLoopRange() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ForLoopRange.kt");
      }

      @Test
      @TestMetadata("FunctionLiteral.kt")
      public void testFunctionLiteral() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/FunctionLiteral.kt");
      }

      @Test
      @TestMetadata("IfStatement.kt")
      public void testIfStatement() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IfStatement.kt");
      }

      @Test
      @TestMetadata("IfThenElse.kt")
      public void testIfThenElse() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IfThenElse.kt");
      }

      @Test
      @TestMetadata("IfThenElseBothInvalid.kt")
      public void testIfThenElseBothInvalid() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IfThenElseBothInvalid.kt");
      }

      @Test
      @TestMetadata("IsExpression.kt")
      public void testIsExpression() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IsExpression.kt");
      }

      @Test
      @TestMetadata("kt4332WhenBranches.kt")
      public void testKt4332WhenBranches() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/kt4332WhenBranches.kt");
      }

      @Test
      @TestMetadata("kt5155WhenBranches.kt")
      public void testKt5155WhenBranches() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/kt5155WhenBranches.kt");
      }

      @Test
      @TestMetadata("kt5182WhenBranches.kt")
      public void testKt5182WhenBranches() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/kt5182WhenBranches.kt");
      }

      @Test
      @TestMetadata("ManyIfs.kt")
      public void testManyIfs() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ManyIfs.kt");
      }

      @Test
      @TestMetadata("MultiDeclaration.kt")
      public void testMultiDeclaration() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/MultiDeclaration.kt");
      }

      @Test
      @TestMetadata("ObjectExpression.kt")
      public void testObjectExpression() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ObjectExpression.kt");
      }

      @Test
      @TestMetadata("QualifiedExpression.kt")
      public void testQualifiedExpression() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/QualifiedExpression.kt");
      }

      @Test
      @TestMetadata("Return.kt")
      public void testReturn() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Return.kt");
      }

      @Test
      @TestMetadata("StringTemplate.kt")
      public void testStringTemplate() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/StringTemplate.kt");
      }

      @Test
      @TestMetadata("ThisSuper.kt")
      public void testThisSuper() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ThisSuper.kt");
      }

      @Test
      @TestMetadata("Throw.kt")
      public void testThrow() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Throw.kt");
      }

      @Test
      @TestMetadata("TryCatch.kt")
      public void testTryCatch() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/TryCatch.kt");
      }

      @Test
      @TestMetadata("TryFinally.kt")
      public void testTryFinally() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/TryFinally.kt");
      }

      @Test
      @TestMetadata("UnaryExpression.kt")
      public void testUnaryExpression() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/UnaryExpression.kt");
      }

      @Test
      @TestMetadata("When.kt")
      public void testWhen() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/When.kt");
      }

      @Test
      @TestMetadata("WhenEntryAs.kt")
      public void testWhenEntryAs() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenEntryAs.kt");
      }

      @Test
      @TestMetadata("WhenEntryIs.kt")
      public void testWhenEntryIs() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenEntryIs.kt");
      }

      @Test
      @TestMetadata("WhenIn.kt")
      public void testWhenIn() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenIn.kt");
      }

      @Test
      @TestMetadata("WhenSubject.kt")
      public void testWhenSubject() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenSubject.kt");
      }

      @Test
      @TestMetadata("While.kt")
      public void testWhile() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/While.kt");
      }

      @Test
      @TestMetadata("WhileCondition.kt")
      public void testWhileCondition() {
        runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhileCondition.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts")
      @TestDataPath("$PROJECT_ROOT")
      public class Smartcasts {
        @Test
        public void testAllFilesPresentInSmartcasts() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("SmartcastAmbiguitites.kt")
        public void testSmartcastAmbiguitites() {
          runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts/SmartcastAmbiguitites.kt");
        }

        @Test
        @TestMetadata("SmartcastsForStableIdentifiers.kt")
        public void testSmartcastsForStableIdentifiers() {
          runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts/SmartcastsForStableIdentifiers.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/dataObjects")
    @TestDataPath("$PROJECT_ROOT")
    public class DataObjects {
      @Test
      public void testAllFilesPresentInDataObjects() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataObjects"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("overrideEqualsAndHashCode.kt")
      public void testOverrideEqualsAndHashCode() {
        runTest("compiler/testData/diagnostics/tests/dataObjects/overrideEqualsAndHashCode.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks")
    @TestDataPath("$PROJECT_ROOT")
    public class DeclarationChecks {
      @Test
      public void testAllFilesPresentInDeclarationChecks() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("ambiguousObjectExpressionType.kt")
      public void testAmbiguousObjectExpressionType() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/ambiguousObjectExpressionType.kt");
      }

      @Test
      @TestMetadata("anonymousFunAsLastExpressionInBlock.kt")
      public void testAnonymousFunAsLastExpressionInBlock() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/anonymousFunAsLastExpressionInBlock.kt");
      }

      @Test
      @TestMetadata("anonymousFunUnusedLastExpressionInBlock.kt")
      public void testAnonymousFunUnusedLastExpressionInBlock() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/anonymousFunUnusedLastExpressionInBlock.kt");
      }

      @Test
      @TestMetadata("ComponentFunctionReturnTypeMismatch.kt")
      public void testComponentFunctionReturnTypeMismatch() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/ComponentFunctionReturnTypeMismatch.kt");
      }

      @Test
      @TestMetadata("ConflictingAndRedundantProjections.kt")
      public void testConflictingAndRedundantProjections() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/ConflictingAndRedundantProjections.kt");
      }

      @Test
      @TestMetadata("DataFlowInMultiDeclInFor.kt")
      public void testDataFlowInMultiDeclInFor() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/DataFlowInMultiDeclInFor.kt");
      }

      @Test
      @TestMetadata("DataFlowInfoInMultiDecl.kt")
      public void testDataFlowInfoInMultiDecl() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/DataFlowInfoInMultiDecl.kt");
      }

      @Test
      @TestMetadata("FunctionWithMissingNames.kt")
      public void testFunctionWithMissingNames() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/FunctionWithMissingNames.kt");
      }

      @Test
      @TestMetadata("illegalModifiersOnClass.kt")
      public void testIllegalModifiersOnClass() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/illegalModifiersOnClass.kt");
      }

      @Test
      @TestMetadata("kClassInSignature.kt")
      public void testKClassInSignature() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/kClassInSignature.kt");
      }

      @Test
      @TestMetadata("kt1141.kt")
      public void testKt1141() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/kt1141.kt");
      }

      @Test
      @TestMetadata("kt1193.kt")
      public void testKt1193() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/kt1193.kt");
      }

      @Test
      @TestMetadata("kt2096.kt")
      public void testKt2096() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2096.kt");
      }

      @Test
      @TestMetadata("kt2142.kt")
      public void testKt2142() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2142.kt");
      }

      @Test
      @TestMetadata("kt2397.kt")
      public void testKt2397() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2397.kt");
      }

      @Test
      @TestMetadata("kt2631_MultipleDeclaration.kt")
      public void testKt2631_MultipleDeclaration() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2631_MultipleDeclaration.kt");
      }

      @Test
      @TestMetadata("kt2643MultiDeclInControlFlow.kt")
      public void testKt2643MultiDeclInControlFlow() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2643MultiDeclInControlFlow.kt");
      }

      @Test
      @TestMetadata("kt47245.kt")
      public void testKt47245() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/kt47245.kt");
      }

      @Test
      @TestMetadata("kt559.kt")
      public void testKt559() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/kt559.kt");
      }

      @Test
      @TestMetadata("localDeclarationModifiers.kt")
      public void testLocalDeclarationModifiers() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/localDeclarationModifiers.kt");
      }

      @Test
      @TestMetadata("localFunctionNoInheritVisibility.kt")
      public void testLocalFunctionNoInheritVisibility() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/localFunctionNoInheritVisibility.kt");
      }

      @Test
      @TestMetadata("localObjectInInnerClass.kt")
      public void testLocalObjectInInnerClass() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/localObjectInInnerClass.kt");
      }

      @Test
      @TestMetadata("LocalVariableWithNoTypeInformation.kt")
      public void testLocalVariableWithNoTypeInformation() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/LocalVariableWithNoTypeInformation.kt");
      }

      @Test
      @TestMetadata("localVariablesWithTypeParameters_1_4.kt")
      public void testLocalVariablesWithTypeParameters_1_4() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/localVariablesWithTypeParameters_1_4.kt");
      }

      @Test
      @TestMetadata("mappedFunctionNotImplemented.kt")
      public void testMappedFunctionNotImplemented() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/mappedFunctionNotImplemented.kt");
      }

      @Test
      @TestMetadata("memberPropertyInitialized.kt")
      public void testMemberPropertyInitialized() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/memberPropertyInitialized.kt");
      }

      @Test
      @TestMetadata("mulitpleVarargParameters.kt")
      public void testMulitpleVarargParameters() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/mulitpleVarargParameters.kt");
      }

      @Test
      @TestMetadata("MultiDeclarationErrors.kt")
      public void testMultiDeclarationErrors() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/MultiDeclarationErrors.kt");
      }

      @Test
      @TestMetadata("nameWithDangerousCharacters.kt")
      public void testNameWithDangerousCharacters() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/nameWithDangerousCharacters.kt");
      }

      @Test
      @TestMetadata("namedFunAsLastExpressionInBlock.kt")
      public void testNamedFunAsLastExpressionInBlock() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/namedFunAsLastExpressionInBlock.kt");
      }

      @Test
      @TestMetadata("packageDeclarationModifiers.kt")
      public void testPackageDeclarationModifiers() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/packageDeclarationModifiers.kt");
      }

      @Test
      @TestMetadata("propertyInPackageHasNoInheritVisibility.kt")
      public void testPropertyInPackageHasNoInheritVisibility() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/propertyInPackageHasNoInheritVisibility.kt");
      }

      @Test
      @TestMetadata("RedeclarationsInMultiDecl.kt")
      public void testRedeclarationsInMultiDecl() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/RedeclarationsInMultiDecl.kt");
      }

      @Test
      @TestMetadata("ScalaLikeNamedFun.kt")
      public void testScalaLikeNamedFun() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/ScalaLikeNamedFun.kt");
      }

      @Test
      @TestMetadata("sealedOnMembers.kt")
      public void testSealedOnMembers() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/sealedOnMembers.kt");
      }

      @Test
      @TestMetadata("unambiguousObjectExpressionType.kt")
      public void testUnambiguousObjectExpressionType() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/unambiguousObjectExpressionType.kt");
      }

      @Test
      @TestMetadata("valVarFunctionParameter.kt")
      public void testValVarFunctionParameter() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/valVarFunctionParameter.kt");
      }

      @Test
      @TestMetadata("VarianceOnFunctionAndPropertyTypeParameters.kt")
      public void testVarianceOnFunctionAndPropertyTypeParameters() {
        runTest("compiler/testData/diagnostics/tests/declarationChecks/VarianceOnFunctionAndPropertyTypeParameters.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations")
      @TestDataPath("$PROJECT_ROOT")
      public class DestructuringDeclarations {
        @Test
        public void testAllFilesPresentInDestructuringDeclarations() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("destructuringDeclarationAssignedUnresolved.kt")
        public void testDestructuringDeclarationAssignedUnresolved() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/destructuringDeclarationAssignedUnresolved.kt");
        }

        @Test
        @TestMetadata("destructuringDeclarationMissingInitializer.kt")
        public void testDestructuringDeclarationMissingInitializer() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/destructuringDeclarationMissingInitializer.kt");
        }

        @Test
        @TestMetadata("DoubleDeclForLoop.kt")
        public void testDoubleDeclForLoop() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/DoubleDeclForLoop.kt");
        }

        @Test
        @TestMetadata("FolLoopTypeComponentTypeMismatch.kt")
        public void testFolLoopTypeComponentTypeMismatch() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/FolLoopTypeComponentTypeMismatch.kt");
        }

        @Test
        @TestMetadata("ForLoopComponentFunctionAmbiguity.kt")
        public void testForLoopComponentFunctionAmbiguity() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopComponentFunctionAmbiguity.kt");
        }

        @Test
        @TestMetadata("ForLoopComponentFunctionMissing.kt")
        public void testForLoopComponentFunctionMissing() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopComponentFunctionMissing.kt");
        }

        @Test
        @TestMetadata("ForLoopMissingLoopParameter.kt")
        public void testForLoopMissingLoopParameter() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopMissingLoopParameter.kt");
        }

        @Test
        @TestMetadata("ForLoopWithExtensions.kt")
        public void testForLoopWithExtensions() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopWithExtensions.kt");
        }

        @Test
        @TestMetadata("ForWithExplicitTypes.kt")
        public void testForWithExplicitTypes() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForWithExplicitTypes.kt");
        }

        @Test
        @TestMetadata("kt2829.kt")
        public void testKt2829() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/kt2829.kt");
        }

        @Test
        @TestMetadata("lastDestructuringDeclarationInBlock.kt")
        public void testLastDestructuringDeclarationInBlock() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/lastDestructuringDeclarationInBlock.kt");
        }

        @Test
        @TestMetadata("missingComponentN.kt")
        public void testMissingComponentN() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/missingComponentN.kt");
        }

        @Test
        @TestMetadata("RedeclarationInForLoop.kt")
        public void testRedeclarationInForLoop() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/RedeclarationInForLoop.kt");
        }

        @Test
        @TestMetadata("SingleDeclForLoop.kt")
        public void testSingleDeclForLoop() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/SingleDeclForLoop.kt");
        }

        @Test
        @TestMetadata("underscore.kt")
        public void testUnderscore() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/underscore.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction")
      @TestDataPath("$PROJECT_ROOT")
      public class FiniteBoundRestriction {
        @Test
        public void testAllFilesPresentInFiniteBoundRestriction() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("CasesWithOneTypeParameter.kt")
        public void testCasesWithOneTypeParameter() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction/CasesWithOneTypeParameter.kt");
        }

        @Test
        @TestMetadata("CasesWithTwoTypeParameters.kt")
        public void testCasesWithTwoTypeParameters() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction/CasesWithTwoTypeParameters.kt");
        }

        @Test
        @TestMetadata("JavaSuperType.kt")
        public void testJavaSuperType() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction/JavaSuperType.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction")
      @TestDataPath("$PROJECT_ROOT")
      public class NonExpansiveInheritanceRestriction {
        @Test
        public void testAllFilesPresentInNonExpansiveInheritanceRestriction() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("Comparable.kt")
        public void testComparable() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/Comparable.kt");
        }

        @Test
        @TestMetadata("JavaWithKotlin.kt")
        public void testJavaWithKotlin() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/JavaWithKotlin.kt");
        }

        @Test
        @TestMetadata("JavaWithKotlin2.kt")
        public void testJavaWithKotlin2() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/JavaWithKotlin2.kt");
        }

        @Test
        @TestMetadata("PureKotlin.kt")
        public void testPureKotlin() {
          runTest("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/PureKotlin.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/defaultArguments")
    @TestDataPath("$PROJECT_ROOT")
    public class DefaultArguments {
      @Test
      public void testAllFilesPresentInDefaultArguments() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/defaultArguments"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("kt5232.kt")
      public void testKt5232() {
        runTest("compiler/testData/diagnostics/tests/defaultArguments/kt5232.kt");
      }

      @Test
      @TestMetadata("overrideWithoutDefaultButBaseWithDefaultAndKMP.kt")
      public void testOverrideWithoutDefaultButBaseWithDefaultAndKMP() {
        runTest("compiler/testData/diagnostics/tests/defaultArguments/overrideWithoutDefaultButBaseWithDefaultAndKMP.kt");
      }

      @Test
      @TestMetadata("superCall.kt")
      public void testSuperCall() {
        runTest("compiler/testData/diagnostics/tests/defaultArguments/superCall.kt");
      }

      @Test
      @TestMetadata("superCallWithDelegation.kt")
      public void testSuperCallWithDelegation() {
        runTest("compiler/testData/diagnostics/tests/defaultArguments/superCallWithDelegation.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    public class DelegatedProperty {
      @Test
      @TestMetadata("absentErrorAboutInitializer.kt")
      public void testAbsentErrorAboutInitializer() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/absentErrorAboutInitializer.kt");
      }

      @Test
      @TestMetadata("absentErrorAboutType.kt")
      public void testAbsentErrorAboutType() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/absentErrorAboutType.kt");
      }

      @Test
      @TestMetadata("abstractDelegatedProperty.kt")
      public void testAbstractDelegatedProperty() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/abstractDelegatedProperty.kt");
      }

      @Test
      public void testAllFilesPresentInDelegatedProperty() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegatedProperty"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("backingField.kt")
      public void testBackingField() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/backingField.kt");
      }

      @Test
      @TestMetadata("defaultGetter.kt")
      public void testDefaultGetter() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/defaultGetter.kt");
      }

      @Test
      @TestMetadata("defaultSetter.kt")
      public void testDefaultSetter() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/defaultSetter.kt");
      }

      @Test
      @TestMetadata("delegateWithAnnotationOnAccessorWithExplicitType.kt")
      public void testDelegateWithAnnotationOnAccessorWithExplicitType() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/delegateWithAnnotationOnAccessorWithExplicitType.kt");
      }

      @Test
      @TestMetadata("delegateWithAnnotationOnAccessorWithImplicitType.kt")
      public void testDelegateWithAnnotationOnAccessorWithImplicitType() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/delegateWithAnnotationOnAccessorWithImplicitType.kt");
      }

      @Test
      @TestMetadata("delegatedPropertyOverridedInTrait.kt")
      public void testDelegatedPropertyOverridedInTrait() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/delegatedPropertyOverridedInTrait.kt");
      }

      @Test
      @TestMetadata("delegatedPropertyOverridedInTraitTypeMismatch.kt")
      public void testDelegatedPropertyOverridedInTraitTypeMismatch() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/delegatedPropertyOverridedInTraitTypeMismatch.kt");
      }

      @Test
      @TestMetadata("disallowImplInTypeParameter.kt")
      public void testDisallowImplInTypeParameter() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/disallowImplInTypeParameter.kt");
      }

      @Test
      @TestMetadata("genericGetter.kt")
      public void testGenericGetter() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/genericGetter.kt");
      }

      @Test
      @TestMetadata("getterWithSubtype.kt")
      public void testGetterWithSubtype() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/getterWithSubtype.kt");
      }

      @Test
      @TestMetadata("inTrait.kt")
      public void testInTrait() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/inTrait.kt");
      }

      @Test
      @TestMetadata("incompleteTypeInference.kt")
      public void testIncompleteTypeInference() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/incompleteTypeInference.kt");
      }

      @Test
      @TestMetadata("kt4640.kt")
      public void testKt4640() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/kt4640.kt");
      }

      @Test
      @TestMetadata("kt48546.kt")
      public void testKt48546() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/kt48546.kt");
      }

      @Test
      @TestMetadata("kt48546Strict.kt")
      public void testKt48546Strict() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/kt48546Strict.kt");
      }

      @Test
      @TestMetadata("localVariable.kt")
      public void testLocalVariable() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/localVariable.kt");
      }

      @Test
      @TestMetadata("localWithSmartCast.kt")
      public void testLocalWithSmartCast() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/localWithSmartCast.kt");
      }

      @Test
      @TestMetadata("missedGetter.kt")
      public void testMissedGetter() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/missedGetter.kt");
      }

      @Test
      @TestMetadata("missedSetter.kt")
      public void testMissedSetter() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/missedSetter.kt");
      }

      @Test
      @TestMetadata("noInferenceFromGetValueThroughSetValue.kt")
      public void testNoInferenceFromGetValueThroughSetValue() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/noInferenceFromGetValueThroughSetValue.kt");
      }

      @Test
      @TestMetadata("noInferenceFromWrappedDelegate.kt")
      public void testNoInferenceFromWrappedDelegate() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/noInferenceFromWrappedDelegate.kt");
      }

      @Test
      @TestMetadata("noPreliminarySetterInferenceForImplicitlyTypedVar.kt")
      public void testNoPreliminarySetterInferenceForImplicitlyTypedVar() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/noPreliminarySetterInferenceForImplicitlyTypedVar.kt");
      }

      @Test
      @TestMetadata("nonDefaultAccessors.kt")
      public void testNonDefaultAccessors() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/nonDefaultAccessors.kt");
      }

      @Test
      @TestMetadata("propertyDefferedType.kt")
      public void testPropertyDefferedType() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/propertyDefferedType.kt");
      }

      @Test
      @TestMetadata("recursiveType.kt")
      public void testRecursiveType() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/recursiveType.kt");
      }

      @Test
      @TestMetadata("redundantGetter.kt")
      public void testRedundantGetter() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/redundantGetter.kt");
      }

      @Test
      @TestMetadata("redundantSetter.kt")
      public void testRedundantSetter() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/redundantSetter.kt");
      }

      @Test
      @TestMetadata("setterThisTypeMismatch.kt")
      public void testSetterThisTypeMismatch() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/setterThisTypeMismatch.kt");
      }

      @Test
      @TestMetadata("setterWithSupertype.kt")
      public void testSetterWithSupertype() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/setterWithSupertype.kt");
      }

      @Test
      @TestMetadata("severalReceivers.kt")
      public void testSeveralReceivers() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/severalReceivers.kt");
      }

      @Test
      @TestMetadata("thisInDelegate.kt")
      public void testThisInDelegate() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/thisInDelegate.kt");
      }

      @Test
      @TestMetadata("thisOfAnyType.kt")
      public void testThisOfAnyType() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/thisOfAnyType.kt");
      }

      @Test
      @TestMetadata("thisOfNothingNullableType.kt")
      public void testThisOfNothingNullableType() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/thisOfNothingNullableType.kt");
      }

      @Test
      @TestMetadata("thisOfNothingType.kt")
      public void testThisOfNothingType() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/thisOfNothingType.kt");
      }

      @Test
      @TestMetadata("twoGetMethods.kt")
      public void testTwoGetMethods() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/twoGetMethods.kt");
      }

      @Test
      @TestMetadata("typeMismatchForGetReturnType.kt")
      public void testTypeMismatchForGetReturnType() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForGetReturnType.kt");
      }

      @Test
      @TestMetadata("typeMismatchForGetWithGeneric.kt")
      public void testTypeMismatchForGetWithGeneric() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForGetWithGeneric.kt");
      }

      @Test
      @TestMetadata("typeMismatchForSetParameter.kt")
      public void testTypeMismatchForSetParameter() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForSetParameter.kt");
      }

      @Test
      @TestMetadata("typeMismatchForThisGetParameter.kt")
      public void testTypeMismatchForThisGetParameter() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForThisGetParameter.kt");
      }

      @Test
      @TestMetadata("useTypeParameterOfExtensionProperty.kt")
      public void testUseTypeParameterOfExtensionProperty() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/useTypeParameterOfExtensionProperty.kt");
      }

      @Test
      @TestMetadata("useTypeParameterOfExtensionProperty2.kt")
      public void testUseTypeParameterOfExtensionProperty2() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/useTypeParameterOfExtensionProperty2.kt");
      }

      @Test
      @TestMetadata("useTypeParameterOfExtensionProperty3.kt")
      public void testUseTypeParameterOfExtensionProperty3() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/useTypeParameterOfExtensionProperty3.kt");
      }

      @Test
      @TestMetadata("useTypeParameterOfExtensionProperty_Disabled.kt")
      public void testUseTypeParameterOfExtensionProperty_Disabled() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/useTypeParameterOfExtensionProperty_Disabled.kt");
      }

      @Test
      @TestMetadata("withInvokes.kt")
      public void testWithInvokes() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/withInvokes.kt");
      }

      @Test
      @TestMetadata("wrongCountOfParametersInGet.kt")
      public void testWrongCountOfParametersInGet() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/wrongCountOfParametersInGet.kt");
      }

      @Test
      @TestMetadata("wrongCountOfParametersInSet.kt")
      public void testWrongCountOfParametersInSet() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/wrongCountOfParametersInSet.kt");
      }

      @Test
      @TestMetadata("wrongSetterReturnType.kt")
      public void testWrongSetterReturnType() {
        runTest("compiler/testData/diagnostics/tests/delegatedProperty/wrongSetterReturnType.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference")
      @TestDataPath("$PROJECT_ROOT")
      public class Inference {
        @Test
        public void testAllFilesPresentInInference() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegatedProperty/inference"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("annotatedAccessor.kt")
        public void testAnnotatedAccessor() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/annotatedAccessor.kt");
        }

        @Test
        @TestMetadata("callableReferenceArgumentInDelegatedExpression.kt")
        public void testCallableReferenceArgumentInDelegatedExpression() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/callableReferenceArgumentInDelegatedExpression.kt");
        }

        @Test
        @TestMetadata("decoratedLambda.kt")
        public void testDecoratedLambda() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/decoratedLambda.kt");
        }

        @Test
        @TestMetadata("delegateExpressionAsLambda.kt")
        public void testDelegateExpressionAsLambda() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/delegateExpressionAsLambda.kt");
        }

        @Test
        @TestMetadata("delegatedExpressionWithLabeledReturnInsideLambda.kt")
        public void testDelegatedExpressionWithLabeledReturnInsideLambda() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/delegatedExpressionWithLabeledReturnInsideLambda.kt");
        }

        @Test
        @TestMetadata("differentDelegatedExpressions.kt")
        public void testDifferentDelegatedExpressions() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/differentDelegatedExpressions.kt");
        }

        @Test
        @TestMetadata("elvisInDelegated.kt")
        public void testElvisInDelegated() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/elvisInDelegated.kt");
        }

        @Test
        @TestMetadata("extensionGet.kt")
        public void testExtensionGet() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/extensionGet.kt");
        }

        @Test
        @TestMetadata("extensionProperty.kt")
        public void testExtensionProperty() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/extensionProperty.kt");
        }

        @Test
        @TestMetadata("fullyCompleteDelegateWhenPossible.kt")
        public void testFullyCompleteDelegateWhenPossible() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/fullyCompleteDelegateWhenPossible.kt");
        }

        @Test
        @TestMetadata("genericMethodInGenericClass.kt")
        public void testGenericMethodInGenericClass() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/genericMethodInGenericClass.kt");
        }

        @Test
        @TestMetadata("genericMethods.kt")
        public void testGenericMethods() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/genericMethods.kt");
        }

        @Test
        @TestMetadata("ifInDelegated.kt")
        public void testIfInDelegated() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/ifInDelegated.kt");
        }

        @Test
        @TestMetadata("kt41952.kt")
        public void testKt41952() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/kt41952.kt");
        }

        @Test
        @TestMetadata("labeledDelegatedExpression.kt")
        public void testLabeledDelegatedExpression() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/labeledDelegatedExpression.kt");
        }

        @Test
        @TestMetadata("lambdaDelegate.kt")
        public void testLambdaDelegate() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/lambdaDelegate.kt");
        }

        @Test
        @TestMetadata("lambdaWithMultipleReturns.kt")
        public void testLambdaWithMultipleReturns() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/lambdaWithMultipleReturns.kt");
        }

        @Test
        @TestMetadata("manyIncompleteCandidates.kt")
        public void testManyIncompleteCandidates() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/manyIncompleteCandidates.kt");
        }

        @Test
        @TestMetadata("nestedPartiallyResolvedCalls.kt")
        public void testNestedPartiallyResolvedCalls() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/nestedPartiallyResolvedCalls.kt");
        }

        @Test
        @TestMetadata("nestedPartiallyResolvedCallsSimple.kt")
        public void testNestedPartiallyResolvedCallsSimple() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/nestedPartiallyResolvedCallsSimple.kt");
        }

        @Test
        @TestMetadata("noErrorsForImplicitConstraints.kt")
        public void testNoErrorsForImplicitConstraints() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/noErrorsForImplicitConstraints.kt");
        }

        @Test
        @TestMetadata("noExpectedTypeForSupertypeConstraint.kt")
        public void testNoExpectedTypeForSupertypeConstraint() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/noExpectedTypeForSupertypeConstraint.kt");
        }

        @Test
        @TestMetadata("notNullAssertionInLocalDelegated.kt")
        public void testNotNullAssertionInLocalDelegated() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/notNullAssertionInLocalDelegated.kt");
        }

        @Test
        @TestMetadata("nothingTypeThisRef.kt")
        public void testNothingTypeThisRef() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/nothingTypeThisRef.kt");
        }

        @Test
        @TestMetadata("provideDelegateFixationResultContainsOtherInnerVariable.kt")
        public void testProvideDelegateFixationResultContainsOtherInnerVariable() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/provideDelegateFixationResultContainsOtherInnerVariable.kt");
        }

        @Test
        @TestMetadata("provideDelegateReturningOuterTypeVariable.kt")
        public void testProvideDelegateReturningOuterTypeVariable() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/provideDelegateReturningOuterTypeVariable.kt");
        }

        @Test
        @TestMetadata("provideDelegateUsesOuterCS.kt")
        public void testProvideDelegateUsesOuterCS() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/provideDelegateUsesOuterCS.kt");
        }

        @Test
        @TestMetadata("resultTypeOfLambdaForConventionMethods.kt")
        public void testResultTypeOfLambdaForConventionMethods() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/resultTypeOfLambdaForConventionMethods.kt");
        }

        @Test
        @TestMetadata("successfulProvideDelegateLeadsToRedGetValue.kt")
        public void testSuccessfulProvideDelegateLeadsToRedGetValue() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/successfulProvideDelegateLeadsToRedGetValue.kt");
        }

        @Test
        @TestMetadata("tryInGenerated.kt")
        public void testTryInGenerated() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/tryInGenerated.kt");
        }

        @Test
        @TestMetadata("typeOfLazyDelegatedPropertyWithObject.kt")
        public void testTypeOfLazyDelegatedPropertyWithObject() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/typeOfLazyDelegatedPropertyWithObject.kt");
        }

        @Test
        @TestMetadata("typeVariablesFlow.kt")
        public void testTypeVariablesFlow() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/typeVariablesFlow.kt");
        }

        @Test
        @TestMetadata("typeVariablesFlowComplex.kt")
        public void testTypeVariablesFlowComplex() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/typeVariablesFlowComplex.kt");
        }

        @Test
        @TestMetadata("useCompleterWithoutExpectedType.kt")
        public void testUseCompleterWithoutExpectedType() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/useCompleterWithoutExpectedType.kt");
        }

        @Test
        @TestMetadata("useExpectedType.kt")
        public void testUseExpectedType() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/useExpectedType.kt");
        }

        @Test
        @TestMetadata("useExpectedTypeForVal.kt")
        public void testUseExpectedTypeForVal() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/useExpectedTypeForVal.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate")
      @TestDataPath("$PROJECT_ROOT")
      public class ProvideDelegate {
        @Test
        public void testAllFilesPresentInProvideDelegate() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("commonCaseForInference.kt")
        public void testCommonCaseForInference() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/commonCaseForInference.kt");
        }

        @Test
        @TestMetadata("commonSupertype.kt")
        public void testCommonSupertype() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/commonSupertype.kt");
        }

        @Test
        @TestMetadata("genericProvideDelegate.kt")
        public void testGenericProvideDelegate() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/genericProvideDelegate.kt");
        }

        @Test
        @TestMetadata("hostAndReceiver1.kt")
        public void testHostAndReceiver1() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/hostAndReceiver1.kt");
        }

        @Test
        @TestMetadata("hostAndReceiver2.kt")
        public void testHostAndReceiver2() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/hostAndReceiver2.kt");
        }

        @Test
        @TestMetadata("hostAndReceiver3.kt")
        public void testHostAndReceiver3() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/hostAndReceiver3.kt");
        }

        @Test
        @TestMetadata("inferenceFromReceiver1.kt")
        public void testInferenceFromReceiver1() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/inferenceFromReceiver1.kt");
        }

        @Test
        @TestMetadata("inferenceFromReceiver2.kt")
        public void testInferenceFromReceiver2() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/inferenceFromReceiver2.kt");
        }

        @Test
        @TestMetadata("kt38714.kt")
        public void testKt38714() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/kt38714.kt");
        }

        @Test
        @TestMetadata("localDelegatedProperty.kt")
        public void testLocalDelegatedProperty() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/localDelegatedProperty.kt");
        }

        @Test
        @TestMetadata("noOperatorModifierOnProvideDelegate.kt")
        public void testNoOperatorModifierOnProvideDelegate() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/noOperatorModifierOnProvideDelegate.kt");
        }

        @Test
        @TestMetadata("notNullAssertionInLocalDelegated.kt")
        public void testNotNullAssertionInLocalDelegated() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/notNullAssertionInLocalDelegated.kt");
        }

        @Test
        @TestMetadata("onObject.kt")
        public void testOnObject() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/onObject.kt");
        }

        @Test
        @TestMetadata("overloadResolutionForSeveralProvideDelegates.kt")
        public void testOverloadResolutionForSeveralProvideDelegates() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/overloadResolutionForSeveralProvideDelegates.kt");
        }

        @Test
        @TestMetadata("provideDelegateOnFunctionalTypeWithThis.kt")
        public void testProvideDelegateOnFunctionalTypeWithThis() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/provideDelegateOnFunctionalTypeWithThis.kt");
        }

        @Test
        @TestMetadata("provideDelegateOperatorDeclaration.kt")
        public void testProvideDelegateOperatorDeclaration() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/provideDelegateOperatorDeclaration.kt");
        }

        @Test
        @TestMetadata("provideDelegateResolutionWithStubTypes.kt")
        public void testProvideDelegateResolutionWithStubTypes() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/provideDelegateResolutionWithStubTypes.kt");
        }

        @Test
        @TestMetadata("provideDelegateResolutionWithStubTypesAndExtensionGetValue.kt")
        public void testProvideDelegateResolutionWithStubTypesAndExtensionGetValue() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/provideDelegateResolutionWithStubTypesAndExtensionGetValue.kt");
        }

        @Test
        @TestMetadata("setValue.kt")
        public void testSetValue() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/setValue.kt");
        }

        @Test
        @TestMetadata("simpleProvideDelegate.kt")
        public void testSimpleProvideDelegate() {
          runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/simpleProvideDelegate.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/delegation")
    @TestDataPath("$PROJECT_ROOT")
    public class Delegation {
      @Test
      public void testAllFilesPresentInDelegation() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("DelegationAndOverriding.kt")
      public void testDelegationAndOverriding() {
        runTest("compiler/testData/diagnostics/tests/delegation/DelegationAndOverriding.kt");
      }

      @Test
      @TestMetadata("DelegationExpectedType.kt")
      public void testDelegationExpectedType() {
        runTest("compiler/testData/diagnostics/tests/delegation/DelegationExpectedType.kt");
      }

      @Test
      @TestMetadata("DelegationNotTotrait.kt")
      public void testDelegationNotTotrait() {
        runTest("compiler/testData/diagnostics/tests/delegation/DelegationNotTotrait.kt");
      }

      @Test
      @TestMetadata("DelegationToJavaIface.kt")
      public void testDelegationToJavaIface() {
        runTest("compiler/testData/diagnostics/tests/delegation/DelegationToJavaIface.kt");
      }

      @Test
      @TestMetadata("Delegation_ClashingFunctions.kt")
      public void testDelegation_ClashingFunctions() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_ClashingFunctions.kt");
      }

      @Test
      @TestMetadata("Delegation_DifferentGenerics.kt")
      public void testDelegation_DifferentGenerics() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_DifferentGenerics.kt");
      }

      @Test
      @TestMetadata("Delegation_DifferentGenerics_After.kt")
      public void testDelegation_DifferentGenerics_After() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_DifferentGenerics_After.kt");
      }

      @Test
      @TestMetadata("Delegation_DifferentGenerics_Intersection.kt")
      public void testDelegation_DifferentGenerics_Intersection() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_DifferentGenerics_Intersection.kt");
      }

      @Test
      @TestMetadata("Delegation_DifferentGenerics_Intersection_After.kt")
      public void testDelegation_DifferentGenerics_Intersection_After() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_DifferentGenerics_Intersection_After.kt");
      }

      @Test
      @TestMetadata("Delegation_DifferentGenerics_MultipleDelegation.kt")
      public void testDelegation_DifferentGenerics_MultipleDelegation() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_DifferentGenerics_MultipleDelegation.kt");
      }

      @Test
      @TestMetadata("Delegation_DifferentGenerics_MultipleDelegation_After.kt")
      public void testDelegation_DifferentGenerics_MultipleDelegation_After() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_DifferentGenerics_MultipleDelegation_After.kt");
      }

      @Test
      @TestMetadata("Delegation_DifferentGenerics_RawType.kt")
      public void testDelegation_DifferentGenerics_RawType() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_DifferentGenerics_RawType.kt");
      }

      @Test
      @TestMetadata("Delegation_DifferentGenerics_RawType_After.kt")
      public void testDelegation_DifferentGenerics_RawType_After() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_DifferentGenerics_RawType_After.kt");
      }

      @Test
      @TestMetadata("Delegation_DifferentGenerics_Substitution.kt")
      public void testDelegation_DifferentGenerics_Substitution() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_DifferentGenerics_Substitution.kt");
      }

      @Test
      @TestMetadata("Delegation_GenericWithRawType.kt")
      public void testDelegation_GenericWithRawType() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_GenericWithRawType.kt");
      }

      @Test
      @TestMetadata("Delegation_Hierarchy.kt")
      public void testDelegation_Hierarchy() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_Hierarchy.kt");
      }

      @Test
      @TestMetadata("Delegation_MultipleDelegates.kt")
      public void testDelegation_MultipleDelegates() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_MultipleDelegates.kt");
      }

      @Test
      @TestMetadata("Delegation_ScopeInitializationOrder.kt")
      public void testDelegation_ScopeInitializationOrder() {
        runTest("compiler/testData/diagnostics/tests/delegation/Delegation_ScopeInitializationOrder.kt");
      }

      @Test
      @TestMetadata("kt40510.kt")
      public void testKt40510() {
        runTest("compiler/testData/diagnostics/tests/delegation/kt40510.kt");
      }

      @Test
      @TestMetadata("kt44843.kt")
      public void testKt44843() {
        runTest("compiler/testData/diagnostics/tests/delegation/kt44843.kt");
      }

      @Test
      @TestMetadata("kt48546.kt")
      public void testKt48546() {
        runTest("compiler/testData/diagnostics/tests/delegation/kt48546.kt");
      }

      @Test
      @TestMetadata("kt49477.kt")
      public void testKt49477() {
        runTest("compiler/testData/diagnostics/tests/delegation/kt49477.kt");
      }

      @Test
      @TestMetadata("kt49477Error.kt")
      public void testKt49477Error() {
        runTest("compiler/testData/diagnostics/tests/delegation/kt49477Error.kt");
      }

      @Test
      @TestMetadata("kt8154.kt")
      public void testKt8154() {
        runTest("compiler/testData/diagnostics/tests/delegation/kt8154.kt");
      }

      @Test
      @TestMetadata("multipleDelegationRegression.kt")
      public void testMultipleDelegationRegression() {
        runTest("compiler/testData/diagnostics/tests/delegation/multipleDelegationRegression.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/delegation/clashes")
      @TestDataPath("$PROJECT_ROOT")
      public class Clashes {
        @Test
        public void testAllFilesPresentInClashes() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation/clashes"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("delegateFieldWithAnnotationClash.kt")
        public void testDelegateFieldWithAnnotationClash() {
          runTest("compiler/testData/diagnostics/tests/delegation/clashes/delegateFieldWithAnnotationClash.kt");
        }

        @Test
        @TestMetadata("finalMemberOverridden.kt")
        public void testFinalMemberOverridden() {
          runTest("compiler/testData/diagnostics/tests/delegation/clashes/finalMemberOverridden.kt");
        }

        @Test
        @TestMetadata("nestedNameClash.kt")
        public void testNestedNameClash() {
          runTest("compiler/testData/diagnostics/tests/delegation/clashes/nestedNameClash.kt");
        }

        @Test
        @TestMetadata("nestedNameClash2.kt")
        public void testNestedNameClash2() {
          runTest("compiler/testData/diagnostics/tests/delegation/clashes/nestedNameClash2.kt");
        }

        @Test
        @TestMetadata("nestedNameClash3.kt")
        public void testNestedNameClash3() {
          runTest("compiler/testData/diagnostics/tests/delegation/clashes/nestedNameClash3.kt");
        }

        @Test
        @TestMetadata("nestedNameClashAndAnnotations.kt")
        public void testNestedNameClashAndAnnotations() {
          runTest("compiler/testData/diagnostics/tests/delegation/clashes/nestedNameClashAndAnnotations.kt");
        }

        @Test
        @TestMetadata("propertyTypeMismatch.kt")
        public void testPropertyTypeMismatch() {
          runTest("compiler/testData/diagnostics/tests/delegation/clashes/propertyTypeMismatch.kt");
        }

        @Test
        @TestMetadata("returnTypeMismatch.kt")
        public void testReturnTypeMismatch() {
          runTest("compiler/testData/diagnostics/tests/delegation/clashes/returnTypeMismatch.kt");
        }

        @Test
        @TestMetadata("varOverriddenByVal.kt")
        public void testVarOverriddenByVal() {
          runTest("compiler/testData/diagnostics/tests/delegation/clashes/varOverriddenByVal.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/delegation/covariantOverrides")
      @TestDataPath("$PROJECT_ROOT")
      public class CovariantOverrides {
        @Test
        public void testAllFilesPresentInCovariantOverrides() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation/covariantOverrides"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("fromClass.kt")
        public void testFromClass() {
          runTest("compiler/testData/diagnostics/tests/delegation/covariantOverrides/fromClass.kt");
        }

        @Test
        @TestMetadata("irrelevant.kt")
        public void testIrrelevant() {
          runTest("compiler/testData/diagnostics/tests/delegation/covariantOverrides/irrelevant.kt");
        }

        @Test
        @TestMetadata("kt13952.kt")
        public void testKt13952() {
          runTest("compiler/testData/diagnostics/tests/delegation/covariantOverrides/kt13952.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/diagnostics/tests/delegation/covariantOverrides/simple.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride")
      @TestDataPath("$PROJECT_ROOT")
      public class MemberHidesSupertypeOverride {
        @Test
        @TestMetadata("abstractOverride.kt")
        public void testAbstractOverride() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/abstractOverride.kt");
        }

        @Test
        public void testAllFilesPresentInMemberHidesSupertypeOverride() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("delegationToSubType.kt")
        public void testDelegationToSubType() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/delegationToSubType.kt");
        }

        @Test
        @TestMetadata("delegationToSubTypeProperty.kt")
        public void testDelegationToSubTypeProperty() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/delegationToSubTypeProperty.kt");
        }

        @Test
        @TestMetadata("delegationToSubTypeWithOverride.kt")
        public void testDelegationToSubTypeWithOverride() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/delegationToSubTypeWithOverride.kt");
        }

        @Test
        @TestMetadata("delegationToSubTypeWithOverrideProperty.kt")
        public void testDelegationToSubTypeWithOverrideProperty() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/delegationToSubTypeWithOverrideProperty.kt");
        }

        @Test
        @TestMetadata("diamond.kt")
        public void testDiamond() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/diamond.kt");
        }

        @Test
        @TestMetadata("explicitOverride.kt")
        public void testExplicitOverride() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/explicitOverride.kt");
        }

        @Test
        @TestMetadata("fakeOverrideInTheMiddle.kt")
        public void testFakeOverrideInTheMiddle() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/fakeOverrideInTheMiddle.kt");
        }

        @Test
        @TestMetadata("generic.kt")
        public void testGeneric() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/generic.kt");
        }

        @Test
        @TestMetadata("sameDelegationInHierarchy.kt")
        public void testSameDelegationInHierarchy() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/sameDelegationInHierarchy.kt");
        }

        @Test
        @TestMetadata("sameDelegationInHierarchy2.kt")
        public void testSameDelegationInHierarchy2() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/sameDelegationInHierarchy2.kt");
        }

        @Test
        @TestMetadata("severalDelegates.kt")
        public void testSeveralDelegates() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/severalDelegates.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/simple.kt");
        }

        @Test
        @TestMetadata("simpleNoOverride.kt")
        public void testSimpleNoOverride() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/simpleNoOverride.kt");
        }

        @Test
        @TestMetadata("simpleProp.kt")
        public void testSimpleProp() {
          runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/simpleProp.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/deparenthesize")
    @TestDataPath("$PROJECT_ROOT")
    public class Deparenthesize {
      @Test
      public void testAllFilesPresentInDeparenthesize() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/deparenthesize"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("annotatedSafeCall.kt")
      public void testAnnotatedSafeCall() {
        runTest("compiler/testData/diagnostics/tests/deparenthesize/annotatedSafeCall.kt");
      }

      @Test
      @TestMetadata("checkDeparenthesizedType.kt")
      public void testCheckDeparenthesizedType() {
        runTest("compiler/testData/diagnostics/tests/deparenthesize/checkDeparenthesizedType.kt");
      }

      @Test
      @TestMetadata("labeledSafeCall.kt")
      public void testLabeledSafeCall() {
        runTest("compiler/testData/diagnostics/tests/deparenthesize/labeledSafeCall.kt");
      }

      @Test
      @TestMetadata("multiParenthesizedSafeCall.kt")
      public void testMultiParenthesizedSafeCall() {
        runTest("compiler/testData/diagnostics/tests/deparenthesize/multiParenthesizedSafeCall.kt");
      }

      @Test
      @TestMetadata("parenthesizedSafeCall.kt")
      public void testParenthesizedSafeCall() {
        runTest("compiler/testData/diagnostics/tests/deparenthesize/parenthesizedSafeCall.kt");
      }

      @Test
      @TestMetadata("ParenthesizedVariable.kt")
      public void testParenthesizedVariable() {
        runTest("compiler/testData/diagnostics/tests/deparenthesize/ParenthesizedVariable.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/deprecated")
    @TestDataPath("$PROJECT_ROOT")
    public class Deprecated {
      @Test
      public void testAllFilesPresentInDeprecated() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/deprecated"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("annotationUsage.kt")
      public void testAnnotationUsage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/annotationUsage.kt");
      }

      @Test
      @TestMetadata("candidateBehindHiddenPropertyAccessors.kt")
      public void testCandidateBehindHiddenPropertyAccessors() {
        runTest("compiler/testData/diagnostics/tests/deprecated/candidateBehindHiddenPropertyAccessors.kt");
      }

      @Test
      @TestMetadata("classWithCompanionObject.kt")
      public void testClassWithCompanionObject() {
        runTest("compiler/testData/diagnostics/tests/deprecated/classWithCompanionObject.kt");
      }

      @Test
      @TestMetadata("companionObjectUsage.kt")
      public void testCompanionObjectUsage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/companionObjectUsage.kt");
      }

      @Test
      @TestMetadata("componentUsage.kt")
      public void testComponentUsage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/componentUsage.kt");
      }

      @Test
      @TestMetadata("deprecatedCompanionAndClassReference.kt")
      public void testDeprecatedCompanionAndClassReference() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedCompanionAndClassReference.kt");
      }

      @Test
      @TestMetadata("deprecatedConstructor.kt")
      public void testDeprecatedConstructor() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedConstructor.kt");
      }

      @Test
      @TestMetadata("deprecatedConstructorProperty.kt")
      public void testDeprecatedConstructorProperty() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedConstructorProperty.kt");
      }

      @Test
      @TestMetadata("deprecatedEnumEntry.kt")
      public void testDeprecatedEnumEntry() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedEnumEntry.kt");
      }

      @Test
      @TestMetadata("deprecatedError.kt")
      public void testDeprecatedError() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedError.kt");
      }

      @Test
      @TestMetadata("deprecatedErrorBuilder.kt")
      public void testDeprecatedErrorBuilder() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedErrorBuilder.kt");
      }

      @Test
      @TestMetadata("deprecatedField.kt")
      public void testDeprecatedField() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedField.kt");
      }

      @Test
      @TestMetadata("deprecatedGenericType.kt")
      public void testDeprecatedGenericType() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedGenericType.kt");
      }

      @Test
      @TestMetadata("deprecatedHidden.kt")
      public void testDeprecatedHidden() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedHidden.kt");
      }

      @Test
      @TestMetadata("deprecatedHiddenOnCallableReferenceArgument.kt")
      public void testDeprecatedHiddenOnCallableReferenceArgument() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedHiddenOnCallableReferenceArgument.kt");
      }

      @Test
      @TestMetadata("deprecatedInheritance_after.kt")
      public void testDeprecatedInheritance_after() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedInheritance_after.kt");
      }

      @Test
      @TestMetadata("deprecatedInheritance_before.kt")
      public void testDeprecatedInheritance_before() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedInheritance_before.kt");
      }

      @Test
      @TestMetadata("deprecatedPropertyInheritance_after.kt")
      public void testDeprecatedPropertyInheritance_after() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedPropertyInheritance_after.kt");
      }

      @Test
      @TestMetadata("deprecatedPropertyInheritance_before.kt")
      public void testDeprecatedPropertyInheritance_before() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedPropertyInheritance_before.kt");
      }

      @Test
      @TestMetadata("deprecationWithComplexMessage.kt")
      public void testDeprecationWithComplexMessage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/deprecationWithComplexMessage.kt");
      }

      @Test
      @TestMetadata("duplicatedOverrideDeprecationOnProperty.kt")
      public void testDuplicatedOverrideDeprecationOnProperty() {
        runTest("compiler/testData/diagnostics/tests/deprecated/duplicatedOverrideDeprecationOnProperty.kt");
      }

      @Test
      @TestMetadata("functionUsage.kt")
      public void testFunctionUsage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/functionUsage.kt");
      }

      @Test
      @TestMetadata("genericConstructorUsage.kt")
      public void testGenericConstructorUsage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/genericConstructorUsage.kt");
      }

      @Test
      @TestMetadata("hiddenComponentInDestructuringDeclaration.kt")
      public void testHiddenComponentInDestructuringDeclaration() {
        runTest("compiler/testData/diagnostics/tests/deprecated/hiddenComponentInDestructuringDeclaration.kt");
      }

      @Test
      @TestMetadata("hiddenPropertyAccessors.kt")
      public void testHiddenPropertyAccessors() {
        runTest("compiler/testData/diagnostics/tests/deprecated/hiddenPropertyAccessors.kt");
      }

      @Test
      @TestMetadata("hiddenPropertyAccessors2.kt")
      public void testHiddenPropertyAccessors2() {
        runTest("compiler/testData/diagnostics/tests/deprecated/hiddenPropertyAccessors2.kt");
      }

      @Test
      @TestMetadata("importJavaSamInterface.kt")
      public void testImportJavaSamInterface() {
        runTest("compiler/testData/diagnostics/tests/deprecated/importJavaSamInterface.kt");
      }

      @Test
      @TestMetadata("imports.kt")
      public void testImports() {
        runTest("compiler/testData/diagnostics/tests/deprecated/imports.kt");
      }

      @Test
      @TestMetadata("iteratorUsage.kt")
      public void testIteratorUsage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/iteratorUsage.kt");
      }

      @Test
      @TestMetadata("javaDeprecated.kt")
      public void testJavaDeprecated() {
        runTest("compiler/testData/diagnostics/tests/deprecated/javaDeprecated.kt");
      }

      @Test
      @TestMetadata("javaDeprecatedHidden.kt")
      public void testJavaDeprecatedHidden() {
        runTest("compiler/testData/diagnostics/tests/deprecated/javaDeprecatedHidden.kt");
      }

      @Test
      @TestMetadata("javaDeprecatedInheritance.kt")
      public void testJavaDeprecatedInheritance() {
        runTest("compiler/testData/diagnostics/tests/deprecated/javaDeprecatedInheritance.kt");
      }

      @Test
      @TestMetadata("javaDeprecatedOnStaticMethod.kt")
      public void testJavaDeprecatedOnStaticMethod() {
        runTest("compiler/testData/diagnostics/tests/deprecated/javaDeprecatedOnStaticMethod.kt");
      }

      @Test
      @TestMetadata("javaDocDeprecated.kt")
      public void testJavaDocDeprecated() {
        runTest("compiler/testData/diagnostics/tests/deprecated/javaDocDeprecated.kt");
      }

      @Test
      @TestMetadata("nestedTypesUsage.kt")
      public void testNestedTypesUsage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/nestedTypesUsage.kt");
      }

      @Test
      @TestMetadata("objectUsage.kt")
      public void testObjectUsage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/objectUsage.kt");
      }

      @Test
      @TestMetadata("propertyUsage.kt")
      public void testPropertyUsage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/propertyUsage.kt");
      }

      @Test
      @TestMetadata("propertyUseSiteTargetedAnnotations.kt")
      public void testPropertyUseSiteTargetedAnnotations() {
        runTest("compiler/testData/diagnostics/tests/deprecated/propertyUseSiteTargetedAnnotations.kt");
      }

      @Test
      @TestMetadata("propertyWithInvoke.kt")
      public void testPropertyWithInvoke() {
        runTest("compiler/testData/diagnostics/tests/deprecated/propertyWithInvoke.kt");
      }

      @Test
      @TestMetadata("thisUsage.kt")
      public void testThisUsage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/thisUsage.kt");
      }

      @Test
      @TestMetadata("typeUsage.kt")
      public void testTypeUsage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/typeUsage.kt");
      }

      @Test
      @TestMetadata("typealiasCompanionObject.kt")
      public void testTypealiasCompanionObject() {
        runTest("compiler/testData/diagnostics/tests/deprecated/typealiasCompanionObject.kt");
      }

      @Test
      @TestMetadata("typealiasConstructor.kt")
      public void testTypealiasConstructor() {
        runTest("compiler/testData/diagnostics/tests/deprecated/typealiasConstructor.kt");
      }

      @Test
      @TestMetadata("typealiasForDeprecatedClass.kt")
      public void testTypealiasForDeprecatedClass() {
        runTest("compiler/testData/diagnostics/tests/deprecated/typealiasForDeprecatedClass.kt");
      }

      @Test
      @TestMetadata("typealiasUsage.kt")
      public void testTypealiasUsage() {
        runTest("compiler/testData/diagnostics/tests/deprecated/typealiasUsage.kt");
      }

      @Test
      @TestMetadata("unusedImport.kt")
      public void testUnusedImport() {
        runTest("compiler/testData/diagnostics/tests/deprecated/unusedImport.kt");
      }

      @Test
      @TestMetadata("usageOnEnum.kt")
      public void testUsageOnEnum() {
        runTest("compiler/testData/diagnostics/tests/deprecated/usageOnEnum.kt");
      }

      @Test
      @TestMetadata("warningOnConstructorErrorOnClass.kt")
      public void testWarningOnConstructorErrorOnClass() {
        runTest("compiler/testData/diagnostics/tests/deprecated/warningOnConstructorErrorOnClass.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin")
      @TestDataPath("$PROJECT_ROOT")
      public class DeprecatedSinceKotlin {
        @Test
        public void testAllFilesPresentInDeprecatedSinceKotlin() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("checkValuesAreParseableAsVersion.kt")
        public void testCheckValuesAreParseableAsVersion() {
          runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/checkValuesAreParseableAsVersion.kt");
        }

        @Test
        @TestMetadata("deprecatedSinceKotlinDeclaration.kt")
        public void testDeprecatedSinceKotlinDeclaration() {
          runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/deprecatedSinceKotlinDeclaration.kt");
        }

        @Test
        @TestMetadata("deprecatedSinceKotlinHiddenOnReferenceArgument.kt")
        public void testDeprecatedSinceKotlinHiddenOnReferenceArgument() {
          runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/deprecatedSinceKotlinHiddenOnReferenceArgument.kt");
        }

        @Test
        @TestMetadata("deprecatedSinceKotlinOutsideKotlinPackage.kt")
        public void testDeprecatedSinceKotlinOutsideKotlinPackage() {
          runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/deprecatedSinceKotlinOutsideKotlinPackage.kt");
        }

        @Test
        @TestMetadata("deprecatedSinceKotlinWithoutArguments.kt")
        public void testDeprecatedSinceKotlinWithoutArguments() {
          runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/deprecatedSinceKotlinWithoutArguments.kt");
        }

        @Test
        @TestMetadata("error.kt")
        public void testError() {
          runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/error.kt");
        }

        @Test
        @TestMetadata("hidden.kt")
        public void testHidden() {
          runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/hidden.kt");
        }

        @Test
        @TestMetadata("messageFromDeprecatedAnnotation.kt")
        public void testMessageFromDeprecatedAnnotation() {
          runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/messageFromDeprecatedAnnotation.kt");
        }

        @Test
        @TestMetadata("warning.kt")
        public void testWarning() {
          runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/warning.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/destructuring")
    @TestDataPath("$PROJECT_ROOT")
    public class Destructuring {
      @Test
      public void testAllFilesPresentInDestructuring() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/destructuring"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("delegationInDestructuring.kt")
      public void testDelegationInDestructuring() {
        runTest("compiler/testData/diagnostics/tests/destructuring/delegationInDestructuring.kt");
      }

      @Test
      @TestMetadata("destructuringInInitializer.kt")
      public void testDestructuringInInitializer() {
        runTest("compiler/testData/diagnostics/tests/destructuring/destructuringInInitializer.kt");
      }

      @Test
      @TestMetadata("destructuringInWhenSubject.kt")
      public void testDestructuringInWhenSubject() {
        runTest("compiler/testData/diagnostics/tests/destructuring/destructuringInWhenSubject.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/dynamicTypes")
    @TestDataPath("$PROJECT_ROOT")
    public class DynamicTypes {
      @Test
      public void testAllFilesPresentInDynamicTypes() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dynamicTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("delegationBy.kt")
      public void testDelegationBy() {
        runTest("compiler/testData/diagnostics/tests/dynamicTypes/delegationBy.kt");
      }

      @Test
      @TestMetadata("unsupported.kt")
      public void testUnsupported() {
        runTest("compiler/testData/diagnostics/tests/dynamicTypes/unsupported.kt");
      }

      @Test
      @TestMetadata("withInvisibleSynthesized.kt")
      public void testWithInvisibleSynthesized() {
        runTest("compiler/testData/diagnostics/tests/dynamicTypes/withInvisibleSynthesized.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/enum")
    @TestDataPath("$PROJECT_ROOT")
    public class Enum {
      @Test
      @TestMetadata("AbstractEnum.kt")
      public void testAbstractEnum() {
        runTest("compiler/testData/diagnostics/tests/enum/AbstractEnum.kt");
      }

      @Test
      @TestMetadata("AbstractInEnum.kt")
      public void testAbstractInEnum() {
        runTest("compiler/testData/diagnostics/tests/enum/AbstractInEnum.kt");
      }

      @Test
      @TestMetadata("AbstractOverrideInEnum.kt")
      public void testAbstractOverrideInEnum() {
        runTest("compiler/testData/diagnostics/tests/enum/AbstractOverrideInEnum.kt");
      }

      @Test
      public void testAllFilesPresentInEnum() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/enum"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("classObjectInEnum.kt")
      public void testClassObjectInEnum() {
        runTest("compiler/testData/diagnostics/tests/enum/classObjectInEnum.kt");
      }

      @Test
      @TestMetadata("classObjectInEnumPrivate.kt")
      public void testClassObjectInEnumPrivate() {
        runTest("compiler/testData/diagnostics/tests/enum/classObjectInEnumPrivate.kt");
      }

      @Test
      @TestMetadata("commonSupertype.kt")
      public void testCommonSupertype() {
        runTest("compiler/testData/diagnostics/tests/enum/commonSupertype.kt");
      }

      @Test
      @TestMetadata("compareTwoDifferentEnums.kt")
      public void testCompareTwoDifferentEnums() {
        runTest("compiler/testData/diagnostics/tests/enum/compareTwoDifferentEnums.kt");
      }

      @Test
      @TestMetadata("ConstructorCallFromOutside.kt")
      public void testConstructorCallFromOutside() {
        runTest("compiler/testData/diagnostics/tests/enum/ConstructorCallFromOutside.kt");
      }

      @Test
      @TestMetadata("constructorWithDefaultParametersOnly.kt")
      public void testConstructorWithDefaultParametersOnly() {
        runTest("compiler/testData/diagnostics/tests/enum/constructorWithDefaultParametersOnly.kt");
      }

      @Test
      @TestMetadata("declaringClass.kt")
      public void testDeclaringClass() {
        runTest("compiler/testData/diagnostics/tests/enum/declaringClass.kt");
      }

      @Test
      @TestMetadata("dontCreatePackageTypeForEnumEntry_after.kt")
      public void testDontCreatePackageTypeForEnumEntry_after() {
        runTest("compiler/testData/diagnostics/tests/enum/dontCreatePackageTypeForEnumEntry_after.kt");
      }

      @Test
      @TestMetadata("dontCreatePackageTypeForEnumEntry_before.kt")
      public void testDontCreatePackageTypeForEnumEntry_before() {
        runTest("compiler/testData/diagnostics/tests/enum/dontCreatePackageTypeForEnumEntry_before.kt");
      }

      @Test
      @TestMetadata("emptyConstructor.kt")
      public void testEmptyConstructor() {
        runTest("compiler/testData/diagnostics/tests/enum/emptyConstructor.kt");
      }

      @Test
      @TestMetadata("entryShouldBeOfEnumType.kt")
      public void testEntryShouldBeOfEnumType() {
        runTest("compiler/testData/diagnostics/tests/enum/entryShouldBeOfEnumType.kt");
      }

      @Test
      @TestMetadata("enumEntryCannotHaveClassObject.kt")
      public void testEnumEntryCannotHaveClassObject() {
        runTest("compiler/testData/diagnostics/tests/enum/enumEntryCannotHaveClassObject.kt");
      }

      @Test
      @TestMetadata("enumEntryInAbstractEnum.kt")
      public void testEnumEntryInAbstractEnum() {
        runTest("compiler/testData/diagnostics/tests/enum/enumEntryInAbstractEnum.kt");
      }

      @Test
      @TestMetadata("enumImplementingTrait.kt")
      public void testEnumImplementingTrait() {
        runTest("compiler/testData/diagnostics/tests/enum/enumImplementingTrait.kt");
      }

      @Test
      @TestMetadata("enumInheritance.kt")
      public void testEnumInheritance() {
        runTest("compiler/testData/diagnostics/tests/enum/enumInheritance.kt");
      }

      @Test
      @TestMetadata("enumIsAssignableToBuiltInEnum.kt")
      public void testEnumIsAssignableToBuiltInEnum() {
        runTest("compiler/testData/diagnostics/tests/enum/enumIsAssignableToBuiltInEnum.kt");
      }

      @Test
      @TestMetadata("enumMissingName.kt")
      public void testEnumMissingName() {
        runTest("compiler/testData/diagnostics/tests/enum/enumMissingName.kt");
      }

      @Test
      @TestMetadata("enumModifier.kt")
      public void testEnumModifier() {
        runTest("compiler/testData/diagnostics/tests/enum/enumModifier.kt");
      }

      @Test
      @TestMetadata("enumStarImport.kt")
      public void testEnumStarImport() {
        runTest("compiler/testData/diagnostics/tests/enum/enumStarImport.kt");
      }

      @Test
      @TestMetadata("enumSubjectTypeCheck.kt")
      public void testEnumSubjectTypeCheck() {
        runTest("compiler/testData/diagnostics/tests/enum/enumSubjectTypeCheck.kt");
      }

      @Test
      @TestMetadata("EnumWOParenthesesConsistencyNestedScope.kt")
      public void testEnumWOParenthesesConsistencyNestedScope() {
        runTest("compiler/testData/diagnostics/tests/enum/EnumWOParenthesesConsistencyNestedScope.kt");
      }

      @Test
      @TestMetadata("EnumWOParenthesesConsistencyTopLevel.kt")
      public void testEnumWOParenthesesConsistencyTopLevel() {
        runTest("compiler/testData/diagnostics/tests/enum/EnumWOParenthesesConsistencyTopLevel.kt");
      }

      @Test
      @TestMetadata("enumWithAnnotationKeyword.kt")
      public void testEnumWithAnnotationKeyword() {
        runTest("compiler/testData/diagnostics/tests/enum/enumWithAnnotationKeyword.kt");
      }

      @Test
      @TestMetadata("enumWithEmptyName.kt")
      public void testEnumWithEmptyName() {
        runTest("compiler/testData/diagnostics/tests/enum/enumWithEmptyName.kt");
      }

      @Test
      @TestMetadata("equalityOfEnumAndParameter.kt")
      public void testEqualityOfEnumAndParameter() {
        runTest("compiler/testData/diagnostics/tests/enum/equalityOfEnumAndParameter.kt");
      }

      @Test
      @TestMetadata("equalityOfFlexibleTypeParameters.kt")
      public void testEqualityOfFlexibleTypeParameters() {
        runTest("compiler/testData/diagnostics/tests/enum/equalityOfFlexibleTypeParameters.kt");
      }

      @Test
      @TestMetadata("ExplicitConstructorCall.kt")
      public void testExplicitConstructorCall() {
        runTest("compiler/testData/diagnostics/tests/enum/ExplicitConstructorCall.kt");
      }

      @Test
      @TestMetadata("extendingEnumDirectly.kt")
      public void testExtendingEnumDirectly() {
        runTest("compiler/testData/diagnostics/tests/enum/extendingEnumDirectly.kt");
      }

      @Test
      @TestMetadata("extensionNamedAsEnumEntry.kt")
      public void testExtensionNamedAsEnumEntry() {
        runTest("compiler/testData/diagnostics/tests/enum/extensionNamedAsEnumEntry.kt");
      }

      @Test
      @TestMetadata("genericWithEnumBound.kt")
      public void testGenericWithEnumBound() {
        runTest("compiler/testData/diagnostics/tests/enum/genericWithEnumBound.kt");
      }

      @Test
      @TestMetadata("giantEnumWithConstructor.kt")
      public void testGiantEnumWithConstructor() {
        runTest("compiler/testData/diagnostics/tests/enum/giantEnumWithConstructor.kt");
      }

      @Test
      @TestMetadata("ifEnumEntry.kt")
      public void testIfEnumEntry() {
        runTest("compiler/testData/diagnostics/tests/enum/ifEnumEntry.kt");
      }

      @Test
      @TestMetadata("importEnumFromJava.kt")
      public void testImportEnumFromJava() {
        runTest("compiler/testData/diagnostics/tests/enum/importEnumFromJava.kt");
      }

      @Test
      @TestMetadata("incompatibleEnumEntryClasses.kt")
      public void testIncompatibleEnumEntryClasses() {
        runTest("compiler/testData/diagnostics/tests/enum/incompatibleEnumEntryClasses.kt");
      }

      @Test
      @TestMetadata("incompatibleEnums_1_4.kt")
      public void testIncompatibleEnums_1_4() {
        runTest("compiler/testData/diagnostics/tests/enum/incompatibleEnums_1_4.kt");
      }

      @Test
      @TestMetadata("inheritFromEnumEntry.kt")
      public void testInheritFromEnumEntry() {
        runTest("compiler/testData/diagnostics/tests/enum/inheritFromEnumEntry.kt");
      }

      @Test
      @TestMetadata("inheritanceFromEnum.kt")
      public void testInheritanceFromEnum() {
        runTest("compiler/testData/diagnostics/tests/enum/inheritanceFromEnum.kt");
      }

      @Test
      @TestMetadata("inline.kt")
      public void testInline() {
        runTest("compiler/testData/diagnostics/tests/enum/inline.kt");
      }

      @Test
      @TestMetadata("InsideEntryConstructorCall.kt")
      public void testInsideEntryConstructorCall() {
        runTest("compiler/testData/diagnostics/tests/enum/InsideEntryConstructorCall.kt");
      }

      @Test
      @TestMetadata("InsideSecondaryConstructorCall.kt")
      public void testInsideSecondaryConstructorCall() {
        runTest("compiler/testData/diagnostics/tests/enum/InsideSecondaryConstructorCall.kt");
      }

      @Test
      @TestMetadata("interfaceWithEnumKeyword.kt")
      public void testInterfaceWithEnumKeyword() {
        runTest("compiler/testData/diagnostics/tests/enum/interfaceWithEnumKeyword.kt");
      }

      @Test
      @TestMetadata("isEnumEntry.kt")
      public void testIsEnumEntry() {
        runTest("compiler/testData/diagnostics/tests/enum/isEnumEntry.kt");
      }

      @Test
      @TestMetadata("javaEnumValueOfMethod.kt")
      public void testJavaEnumValueOfMethod() {
        runTest("compiler/testData/diagnostics/tests/enum/javaEnumValueOfMethod.kt");
      }

      @Test
      @TestMetadata("javaEnumValuesMethod.kt")
      public void testJavaEnumValuesMethod() {
        runTest("compiler/testData/diagnostics/tests/enum/javaEnumValuesMethod.kt");
      }

      @Test
      @TestMetadata("javaEnumWithAbstractFun.kt")
      public void testJavaEnumWithAbstractFun() {
        runTest("compiler/testData/diagnostics/tests/enum/javaEnumWithAbstractFun.kt");
      }

      @Test
      @TestMetadata("javaEnumWithFuns.kt")
      public void testJavaEnumWithFuns() {
        runTest("compiler/testData/diagnostics/tests/enum/javaEnumWithFuns.kt");
      }

      @Test
      @TestMetadata("javaEnumWithNameClashing.kt")
      public void testJavaEnumWithNameClashing() {
        runTest("compiler/testData/diagnostics/tests/enum/javaEnumWithNameClashing.kt");
      }

      @Test
      @TestMetadata("javaEnumWithProperty.kt")
      public void testJavaEnumWithProperty() {
        runTest("compiler/testData/diagnostics/tests/enum/javaEnumWithProperty.kt");
      }

      @Test
      @TestMetadata("kt2834.kt")
      public void testKt2834() {
        runTest("compiler/testData/diagnostics/tests/enum/kt2834.kt");
      }

      @Test
      @TestMetadata("kt8972_cloneNotAllowed.kt")
      public void testKt8972_cloneNotAllowed() {
        runTest("compiler/testData/diagnostics/tests/enum/kt8972_cloneNotAllowed.kt");
      }

      @Test
      @TestMetadata("localEnums.kt")
      public void testLocalEnums() {
        runTest("compiler/testData/diagnostics/tests/enum/localEnums.kt");
      }

      @Test
      @TestMetadata("modifiersOnEnumEntry.kt")
      public void testModifiersOnEnumEntry() {
        runTest("compiler/testData/diagnostics/tests/enum/modifiersOnEnumEntry.kt");
      }

      @Test
      @TestMetadata("multipleConstructors.kt")
      public void testMultipleConstructors() {
        runTest("compiler/testData/diagnostics/tests/enum/multipleConstructors.kt");
      }

      @Test
      @TestMetadata("NonPrivateConstructor.kt")
      public void testNonPrivateConstructor() {
        runTest("compiler/testData/diagnostics/tests/enum/NonPrivateConstructor.kt");
      }

      @Test
      @TestMetadata("openMemberInEnum.kt")
      public void testOpenMemberInEnum() {
        runTest("compiler/testData/diagnostics/tests/enum/openMemberInEnum.kt");
      }

      @Test
      @TestMetadata("overrideFinalEnumMethods.kt")
      public void testOverrideFinalEnumMethods() {
        runTest("compiler/testData/diagnostics/tests/enum/overrideFinalEnumMethods.kt");
      }

      @Test
      @TestMetadata("referenceToEnumEntry.kt")
      public void testReferenceToEnumEntry() {
        runTest("compiler/testData/diagnostics/tests/enum/referenceToEnumEntry.kt");
      }

      @Test
      @TestMetadata("SecondaryConstructorCall.kt")
      public void testSecondaryConstructorCall() {
        runTest("compiler/testData/diagnostics/tests/enum/SecondaryConstructorCall.kt");
      }

      @Test
      @TestMetadata("secondaryConstructorWithoutDelegatingToPrimaryOneWithEnabledFeature.kt")
      public void testSecondaryConstructorWithoutDelegatingToPrimaryOneWithEnabledFeature() {
        runTest("compiler/testData/diagnostics/tests/enum/secondaryConstructorWithoutDelegatingToPrimaryOneWithEnabledFeature.kt");
      }

      @Test
      @TestMetadata("starImportNestedClassAndEntries.kt")
      public void testStarImportNestedClassAndEntries() {
        runTest("compiler/testData/diagnostics/tests/enum/starImportNestedClassAndEntries.kt");
      }

      @Test
      @TestMetadata("typeCompatibility.kt")
      public void testTypeCompatibility() {
        runTest("compiler/testData/diagnostics/tests/enum/typeCompatibility.kt");
      }

      @Test
      @TestMetadata("typeParametersInEnum.kt")
      public void testTypeParametersInEnum() {
        runTest("compiler/testData/diagnostics/tests/enum/typeParametersInEnum.kt");
      }

      @Test
      @TestMetadata("valuesValueOfAndEntriesAccessibility.kt")
      public void testValuesValueOfAndEntriesAccessibility() {
        runTest("compiler/testData/diagnostics/tests/enum/valuesValueOfAndEntriesAccessibility.kt");
      }

      @Test
      @TestMetadata("wrongUnitializedEnumCompanion.kt")
      public void testWrongUnitializedEnumCompanion() {
        runTest("compiler/testData/diagnostics/tests/enum/wrongUnitializedEnumCompanion.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/enum/entries")
      @TestDataPath("$PROJECT_ROOT")
      public class Entries {
        @Test
        public void testAllFilesPresentInEntries() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/enum/entries"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("conflictingPropertyEntriesAndReference.kt")
        public void testConflictingPropertyEntriesAndReference() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/conflictingPropertyEntriesAndReference.kt");
        }

        @Test
        @TestMetadata("conflictingPropertyEntriesAndReferenceOn.kt")
        public void testConflictingPropertyEntriesAndReferenceOn() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/conflictingPropertyEntriesAndReferenceOn.kt");
        }

        @Test
        @TestMetadata("conflictingPropertyEntriesAndReferencePrioritized.kt")
        public void testConflictingPropertyEntriesAndReferencePrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/conflictingPropertyEntriesAndReferencePrioritized.kt");
        }

        @Test
        @TestMetadata("entriesPropertyAsExtensionClash.kt")
        public void testEntriesPropertyAsExtensionClash() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyAsExtensionClash.kt");
        }

        @Test
        @TestMetadata("entriesPropertyAsExtensionClashOn.kt")
        public void testEntriesPropertyAsExtensionClashOn() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyAsExtensionClashOn.kt");
        }

        @Test
        @TestMetadata("entriesPropertyAsExtensionClashPrioritized.kt")
        public void testEntriesPropertyAsExtensionClashPrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyAsExtensionClashPrioritized.kt");
        }

        @Test
        @TestMetadata("entriesPropertyImport.kt")
        public void testEntriesPropertyImport() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyImport.kt");
        }

        @Test
        @TestMetadata("entriesPropertyImportPrioritized.kt")
        public void testEntriesPropertyImportPrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyImportPrioritized.kt");
        }

        @Test
        @TestMetadata("entriesPropertyImportedClash.kt")
        public void testEntriesPropertyImportedClash() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyImportedClash.kt");
        }

        @Test
        @TestMetadata("entriesPropertyImportedClashOn.kt")
        public void testEntriesPropertyImportedClashOn() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyImportedClashOn.kt");
        }

        @Test
        @TestMetadata("entriesPropertyImportedClashPrioritized.kt")
        public void testEntriesPropertyImportedClashPrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyImportedClashPrioritized.kt");
        }

        @Test
        @TestMetadata("entriesPropertyInCompanionClash.kt")
        public void testEntriesPropertyInCompanionClash() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyInCompanionClash.kt");
        }

        @Test
        @TestMetadata("entriesPropertyInCompanionClashOn.kt")
        public void testEntriesPropertyInCompanionClashOn() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyInCompanionClashOn.kt");
        }

        @Test
        @TestMetadata("entriesPropertyInCompanionClashPrioritized.kt")
        public void testEntriesPropertyInCompanionClashPrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyInCompanionClashPrioritized.kt");
        }

        @Test
        @TestMetadata("entriesPropertyWithJvmStaticClash.kt")
        public void testEntriesPropertyWithJvmStaticClash() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyWithJvmStaticClash.kt");
        }

        @Test
        @TestMetadata("entriesPropertyWithJvmStaticClashOn.kt")
        public void testEntriesPropertyWithJvmStaticClashOn() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyWithJvmStaticClashOn.kt");
        }

        @Test
        @TestMetadata("entriesPropertyWithJvmStaticClashPrioritized.kt")
        public void testEntriesPropertyWithJvmStaticClashPrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesPropertyWithJvmStaticClashPrioritized.kt");
        }

        @Test
        @TestMetadata("entriesUnsupported.kt")
        public void testEntriesUnsupported() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/entriesUnsupported.kt");
        }

        @Test
        @TestMetadata("enumEntriesAmbiguity.kt")
        public void testEnumEntriesAmbiguity() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/enumEntriesAmbiguity.kt");
        }

        @Test
        @TestMetadata("enumEntriesAmbiguityPrioritized.kt")
        public void testEnumEntriesAmbiguityPrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/enumEntriesAmbiguityPrioritized.kt");
        }

        @Test
        @TestMetadata("genericEntriesPropertyClash.kt")
        public void testGenericEntriesPropertyClash() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/genericEntriesPropertyClash.kt");
        }

        @Test
        @TestMetadata("genericEntriesPropertyClashOn.kt")
        public void testGenericEntriesPropertyClashOn() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/genericEntriesPropertyClashOn.kt");
        }

        @Test
        @TestMetadata("genericEntriesPropertyClashPrioritized.kt")
        public void testGenericEntriesPropertyClashPrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/genericEntriesPropertyClashPrioritized.kt");
        }

        @Test
        @TestMetadata("javaEnumAdditionalCases.kt")
        public void testJavaEnumAdditionalCases() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/javaEnumAdditionalCases.kt");
        }

        @Test
        @TestMetadata("javaEnumEntriesAmbiguity.kt")
        public void testJavaEnumEntriesAmbiguity() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/javaEnumEntriesAmbiguity.kt");
        }

        @Test
        @TestMetadata("javaEnumEntriesAmbiguityOn.kt")
        public void testJavaEnumEntriesAmbiguityOn() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/javaEnumEntriesAmbiguityOn.kt");
        }

        @Test
        @TestMetadata("javaEnumEntriesAmbiguityPrioritized.kt")
        public void testJavaEnumEntriesAmbiguityPrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/javaEnumEntriesAmbiguityPrioritized.kt");
        }

        @Test
        @TestMetadata("javaFakeEnumEntries.kt")
        public void testJavaFakeEnumEntries() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/javaFakeEnumEntries.kt");
        }

        @Test
        @TestMetadata("nameShadowingOfExternallyDefinedEntries.kt")
        public void testNameShadowingOfExternallyDefinedEntries() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/nameShadowingOfExternallyDefinedEntries.kt");
        }

        @Test
        @TestMetadata("nameShadowingOfExternallyDefinedEntriesOn.kt")
        public void testNameShadowingOfExternallyDefinedEntriesOn() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/nameShadowingOfExternallyDefinedEntriesOn.kt");
        }

        @Test
        @TestMetadata("nameShadowingOfExternallyDefinedEntriesPrioritized.kt")
        public void testNameShadowingOfExternallyDefinedEntriesPrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/nameShadowingOfExternallyDefinedEntriesPrioritized.kt");
        }

        @Test
        @TestMetadata("primitiveReference.kt")
        public void testPrimitiveReference() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/primitiveReference.kt");
        }

        @Test
        @TestMetadata("redeclarationOfEnumEntriesNameWithIntrinsic.kt")
        public void testRedeclarationOfEnumEntriesNameWithIntrinsic() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/redeclarationOfEnumEntriesNameWithIntrinsic.kt");
        }

        @Test
        @TestMetadata("redeclarationOfEnumEntriesNameWithIntrinsicOn.kt")
        public void testRedeclarationOfEnumEntriesNameWithIntrinsicOn() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/redeclarationOfEnumEntriesNameWithIntrinsicOn.kt");
        }

        @Test
        @TestMetadata("redeclarationOfEnumEntriesNameWithIntrinsicPrioritized.kt")
        public void testRedeclarationOfEnumEntriesNameWithIntrinsicPrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/redeclarationOfEnumEntriesNameWithIntrinsicPrioritized.kt");
        }

        @Test
        @TestMetadata("referenceFalsePositiveWarnings.kt")
        public void testReferenceFalsePositiveWarnings() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/referenceFalsePositiveWarnings.kt");
        }

        @Test
        @TestMetadata("referenceFalsePositiveWarningsPrioritized.kt")
        public void testReferenceFalsePositiveWarningsPrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/referenceFalsePositiveWarningsPrioritized.kt");
        }

        @Test
        @TestMetadata("toBeShadowed.kt")
        public void testToBeShadowed() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/toBeShadowed.kt");
        }

        @Test
        @TestMetadata("toBeShadowedPrioritized.kt")
        public void testToBeShadowedPrioritized() {
          runTest("compiler/testData/diagnostics/tests/enum/entries/toBeShadowedPrioritized.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/enum/inner")
      @TestDataPath("$PROJECT_ROOT")
      public class Inner {
        @Test
        public void testAllFilesPresentInInner() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/enum/inner"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("existingClassObject.kt")
        public void testExistingClassObject() {
          runTest("compiler/testData/diagnostics/tests/enum/inner/existingClassObject.kt");
        }

        @Test
        @TestMetadata("insideClass.kt")
        public void testInsideClass() {
          runTest("compiler/testData/diagnostics/tests/enum/inner/insideClass.kt");
        }

        @Test
        @TestMetadata("insideClassObject.kt")
        public void testInsideClassObject() {
          runTest("compiler/testData/diagnostics/tests/enum/inner/insideClassObject.kt");
        }

        @Test
        @TestMetadata("insideEnum.kt")
        public void testInsideEnum() {
          runTest("compiler/testData/diagnostics/tests/enum/inner/insideEnum.kt");
        }

        @Test
        @TestMetadata("insideEnumEntry_after.kt")
        public void testInsideEnumEntry_after() {
          runTest("compiler/testData/diagnostics/tests/enum/inner/insideEnumEntry_after.kt");
        }

        @Test
        @TestMetadata("insideEnumEntry_before.kt")
        public void testInsideEnumEntry_before() {
          runTest("compiler/testData/diagnostics/tests/enum/inner/insideEnumEntry_before.kt");
        }

        @Test
        @TestMetadata("insideInnerClassNotAllowed.kt")
        public void testInsideInnerClassNotAllowed() {
          runTest("compiler/testData/diagnostics/tests/enum/inner/insideInnerClassNotAllowed.kt");
        }

        @Test
        @TestMetadata("insideObject.kt")
        public void testInsideObject() {
          runTest("compiler/testData/diagnostics/tests/enum/inner/insideObject.kt");
        }

        @Test
        @TestMetadata("insideTrait.kt")
        public void testInsideTrait() {
          runTest("compiler/testData/diagnostics/tests/enum/inner/insideTrait.kt");
        }

        @Test
        @TestMetadata("redeclarationInClassObject.kt")
        public void testRedeclarationInClassObject() {
          runTest("compiler/testData/diagnostics/tests/enum/inner/redeclarationInClassObject.kt");
        }

        @Test
        @TestMetadata("twoEnums.kt")
        public void testTwoEnums() {
          runTest("compiler/testData/diagnostics/tests/enum/inner/twoEnums.kt");
        }

        @Test
        @TestMetadata("twoEnumsInClassObjectAndInnerClass.kt")
        public void testTwoEnumsInClassObjectAndInnerClass() {
          runTest("compiler/testData/diagnostics/tests/enum/inner/twoEnumsInClassObjectAndInnerClass.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/evaluate")
    @TestDataPath("$PROJECT_ROOT")
    public class Evaluate {
      @Test
      public void testAllFilesPresentInEvaluate() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/evaluate"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("binaryMinusDepOnExpType.kt")
      public void testBinaryMinusDepOnExpType() {
        runTest("compiler/testData/diagnostics/tests/evaluate/binaryMinusDepOnExpType.kt");
      }

      @Test
      @TestMetadata("binaryMinusIndepWoExpType.kt")
      public void testBinaryMinusIndepWoExpType() {
        runTest("compiler/testData/diagnostics/tests/evaluate/binaryMinusIndepWoExpType.kt");
      }

      @Test
      @TestMetadata("binaryMinusIndependentExpType.kt")
      public void testBinaryMinusIndependentExpType() {
        runTest("compiler/testData/diagnostics/tests/evaluate/binaryMinusIndependentExpType.kt");
      }

      @Test
      @TestMetadata("customExtensionOverKotlinExtensionInConst.kt")
      public void testCustomExtensionOverKotlinExtensionInConst() {
        runTest("compiler/testData/diagnostics/tests/evaluate/customExtensionOverKotlinExtensionInConst.kt");
      }

      @Test
      @TestMetadata("divisionByZero.kt")
      public void testDivisionByZero() {
        runTest("compiler/testData/diagnostics/tests/evaluate/divisionByZero.kt");
      }

      @Test
      @TestMetadata("float.kt")
      public void testFloat() {
        runTest("compiler/testData/diagnostics/tests/evaluate/float.kt");
      }

      @Test
      @TestMetadata("floatLiteralOutOfRange.kt")
      public void testFloatLiteralOutOfRange() {
        runTest("compiler/testData/diagnostics/tests/evaluate/floatLiteralOutOfRange.kt");
      }

      @Test
      @TestMetadata("infixFunOverBuiltinMemberInConst.kt")
      public void testInfixFunOverBuiltinMemberInConst() {
        runTest("compiler/testData/diagnostics/tests/evaluate/infixFunOverBuiltinMemberInConst.kt");
      }

      @Test
      @TestMetadata("intOverflow.kt")
      public void testIntOverflow() {
        runTest("compiler/testData/diagnostics/tests/evaluate/intOverflow.kt");
      }

      @Test
      @TestMetadata("intOverflowWithJavaProperties.kt")
      public void testIntOverflowWithJavaProperties() {
        runTest("compiler/testData/diagnostics/tests/evaluate/intOverflowWithJavaProperties.kt");
      }

      @Test
      @TestMetadata("integer.kt")
      public void testInteger() {
        runTest("compiler/testData/diagnostics/tests/evaluate/integer.kt");
      }

      @Test
      @TestMetadata("logicWithNumber.kt")
      public void testLogicWithNumber() {
        runTest("compiler/testData/diagnostics/tests/evaluate/logicWithNumber.kt");
      }

      @Test
      @TestMetadata("longOverflow.kt")
      public void testLongOverflow() {
        runTest("compiler/testData/diagnostics/tests/evaluate/longOverflow.kt");
      }

      @Test
      @TestMetadata("noOverflowWithZero.kt")
      public void testNoOverflowWithZero() {
        runTest("compiler/testData/diagnostics/tests/evaluate/noOverflowWithZero.kt");
      }

      @Test
      @TestMetadata("numberBinaryOperations.kt")
      public void testNumberBinaryOperations() {
        runTest("compiler/testData/diagnostics/tests/evaluate/numberBinaryOperations.kt");
      }

      @Test
      @TestMetadata("numberBinaryOperationsCall.kt")
      public void testNumberBinaryOperationsCall() {
        runTest("compiler/testData/diagnostics/tests/evaluate/numberBinaryOperationsCall.kt");
      }

      @Test
      @TestMetadata("numberBinaryOperationsInfixCall.kt")
      public void testNumberBinaryOperationsInfixCall() {
        runTest("compiler/testData/diagnostics/tests/evaluate/numberBinaryOperationsInfixCall.kt");
      }

      @Test
      @TestMetadata("otherOverflow.kt")
      public void testOtherOverflow() {
        runTest("compiler/testData/diagnostics/tests/evaluate/otherOverflow.kt");
      }

      @Test
      @TestMetadata("parentesized.kt")
      public void testParentesized() {
        runTest("compiler/testData/diagnostics/tests/evaluate/parentesized.kt");
      }

      @Test
      @TestMetadata("qualifiedExpressions.kt")
      public void testQualifiedExpressions() {
        runTest("compiler/testData/diagnostics/tests/evaluate/qualifiedExpressions.kt");
      }

      @Test
      @TestMetadata("unaryMinusDepOnExpType.kt")
      public void testUnaryMinusDepOnExpType() {
        runTest("compiler/testData/diagnostics/tests/evaluate/unaryMinusDepOnExpType.kt");
      }

      @Test
      @TestMetadata("unaryMinusIndepWoExpType.kt")
      public void testUnaryMinusIndepWoExpType() {
        runTest("compiler/testData/diagnostics/tests/evaluate/unaryMinusIndepWoExpType.kt");
      }

      @Test
      @TestMetadata("unaryMinusIndependentExpType.kt")
      public void testUnaryMinusIndependentExpType() {
        runTest("compiler/testData/diagnostics/tests/evaluate/unaryMinusIndependentExpType.kt");
      }

      @Test
      @TestMetadata("wrongLongSuffix.kt")
      public void testWrongLongSuffix() {
        runTest("compiler/testData/diagnostics/tests/evaluate/wrongLongSuffix.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/evaluate/inlineClasses")
      @TestDataPath("$PROJECT_ROOT")
      public class InlineClasses {
        @Test
        public void testAllFilesPresentInInlineClasses() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/evaluate/inlineClasses"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("constructorOfUnsignedType.kt")
        public void testConstructorOfUnsignedType() {
          runTest("compiler/testData/diagnostics/tests/evaluate/inlineClasses/constructorOfUnsignedType.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/exceptions")
    @TestDataPath("$PROJECT_ROOT")
    public class Exceptions {
      @Test
      public void testAllFilesPresentInExceptions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/exceptions"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("annotationWithWrongArgInDanglingModifierList.kt")
      public void testAnnotationWithWrongArgInDanglingModifierList() {
        runTest("compiler/testData/diagnostics/tests/exceptions/annotationWithWrongArgInDanglingModifierList.kt");
      }

      @Test
      @TestMetadata("assignmentWithIncorrectLValue.kt")
      public void testAssignmentWithIncorrectLValue() {
        runTest("compiler/testData/diagnostics/tests/exceptions/assignmentWithIncorrectLValue.kt");
      }

      @Test
      @TestMetadata("expectedSomeTypesOnBranchForWhenExpressionOfErroneousType.kt")
      public void testExpectedSomeTypesOnBranchForWhenExpressionOfErroneousType() {
        runTest("compiler/testData/diagnostics/tests/exceptions/expectedSomeTypesOnBranchForWhenExpressionOfErroneousType.kt");
      }

      @Test
      @TestMetadata("incorrectCallOnILT.kt")
      public void testIncorrectCallOnILT() {
        runTest("compiler/testData/diagnostics/tests/exceptions/incorrectCallOnILT.kt");
      }

      @Test
      @TestMetadata("keywordsInsteadOfIdentifiers.kt")
      public void testKeywordsInsteadOfIdentifiers() {
        runTest("compiler/testData/diagnostics/tests/exceptions/keywordsInsteadOfIdentifiers.kt");
      }

      @Test
      @TestMetadata("kt24158.kt")
      public void testKt24158() {
        runTest("compiler/testData/diagnostics/tests/exceptions/kt24158.kt");
      }

      @Test
      @TestMetadata("stackOverflowOnDoUnify.kt")
      public void testStackOverflowOnDoUnify() {
        runTest("compiler/testData/diagnostics/tests/exceptions/stackOverflowOnDoUnify.kt");
      }

      @Test
      @TestMetadata("transformErrorTypeChildrenWhileTransformingPartiallyResolvedType.kt")
      public void testTransformErrorTypeChildrenWhileTransformingPartiallyResolvedType() {
        runTest("compiler/testData/diagnostics/tests/exceptions/transformErrorTypeChildrenWhileTransformingPartiallyResolvedType.kt");
      }

      @Test
      @TestMetadata("uninitializedTypeArgumentsMappingIfErrorCandidates.kt")
      public void testUninitializedTypeArgumentsMappingIfErrorCandidates() {
        runTest("compiler/testData/diagnostics/tests/exceptions/uninitializedTypeArgumentsMappingIfErrorCandidates.kt");
      }

      @Test
      @TestMetadata("unresolvedReferenceDuringProjectionRelationChecking.kt")
      public void testUnresolvedReferenceDuringProjectionRelationChecking() {
        runTest("compiler/testData/diagnostics/tests/exceptions/unresolvedReferenceDuringProjectionRelationChecking.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection")
    @TestDataPath("$PROJECT_ROOT")
    public class ExplicitDefinitelyNotNullableViaIntersection {
      @Test
      public void testAllFilesPresentInExplicitDefinitelyNotNullableViaIntersection() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("approximation.kt")
      public void testApproximation() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/approximation.kt");
      }

      @Test
      @TestMetadata("bareTypes.kt")
      public void testBareTypes() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/bareTypes.kt");
      }

      @Test
      @TestMetadata("disabledFeature.kt")
      public void testDisabledFeature() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/disabledFeature.kt");
      }

      @Test
      @TestMetadata("dnnAgainstSam.kt")
      public void testDnnAgainstSam() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/dnnAgainstSam.kt");
      }

      @Test
      @TestMetadata("dnnTypeProjectionInParameter.kt")
      public void testDnnTypeProjectionInParameter() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/dnnTypeProjectionInParameter.kt");
      }

      @Test
      @TestMetadata("dnnTypeProjectionInReceiver.kt")
      public void testDnnTypeProjectionInReceiver() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/dnnTypeProjectionInReceiver.kt");
      }

      @Test
      @TestMetadata("inference.kt")
      public void testInference() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/inference.kt");
      }

      @Test
      @TestMetadata("isAsOperators.kt")
      public void testIsAsOperators() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/isAsOperators.kt");
      }

      @Test
      @TestMetadata("isAsOperatorsEnabled.kt")
      public void testIsAsOperatorsEnabled() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/isAsOperatorsEnabled.kt");
      }

      @Test
      @TestMetadata("kt59493.kt")
      public void testKt59493() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/kt59493.kt");
      }

      @Test
      @TestMetadata("notApplicable.kt")
      public void testNotApplicable() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/notApplicable.kt");
      }

      @Test
      @TestMetadata("overrides.kt")
      public void testOverrides() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/overrides.kt");
      }

      @Test
      @TestMetadata("overridesJavaAnnotated.kt")
      public void testOverridesJavaAnnotated() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/overridesJavaAnnotated.kt");
      }

      @Test
      @TestMetadata("recursiveBounds.kt")
      public void testRecursiveBounds() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/recursiveBounds.kt");
      }

      @Test
      @TestMetadata("reifiedArguments.kt")
      public void testReifiedArguments() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/reifiedArguments.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/simple.kt");
      }

      @Test
      @TestMetadata("starProjection.kt")
      public void testStarProjection() {
        runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/starProjection.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/exposed")
    @TestDataPath("$PROJECT_ROOT")
    public class Exposed {
      @Test
      public void testAllFilesPresentInExposed() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/exposed"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("ambiguousAnonymousExposed.kt")
      public void testAmbiguousAnonymousExposed() {
        runTest("compiler/testData/diagnostics/tests/exposed/ambiguousAnonymousExposed.kt");
      }

      @Test
      @TestMetadata("delegate.kt")
      public void testDelegate() {
        runTest("compiler/testData/diagnostics/tests/exposed/delegate.kt");
      }

      @Test
      @TestMetadata("exceptionOnFakeInvisible.kt")
      public void testExceptionOnFakeInvisible() {
        runTest("compiler/testData/diagnostics/tests/exposed/exceptionOnFakeInvisible.kt");
      }

      @Test
      @TestMetadata("functional.kt")
      public void testFunctional() {
        runTest("compiler/testData/diagnostics/tests/exposed/functional.kt");
      }

      @Test
      @TestMetadata("implements.kt")
      public void testImplements() {
        runTest("compiler/testData/diagnostics/tests/exposed/implements.kt");
      }

      @Test
      @TestMetadata("implictlyExposedAndSuppressed.kt")
      public void testImplictlyExposedAndSuppressed() {
        runTest("compiler/testData/diagnostics/tests/exposed/implictlyExposedAndSuppressed.kt");
      }

      @Test
      @TestMetadata("inaccessibleType.kt")
      public void testInaccessibleType() {
        runTest("compiler/testData/diagnostics/tests/exposed/inaccessibleType.kt");
      }

      @Test
      @TestMetadata("internal.kt")
      public void testInternal() {
        runTest("compiler/testData/diagnostics/tests/exposed/internal.kt");
      }

      @Test
      @TestMetadata("internalAndProtected.kt")
      public void testInternalAndProtected() {
        runTest("compiler/testData/diagnostics/tests/exposed/internalAndProtected.kt");
      }

      @Test
      @TestMetadata("internalFromLocal.kt")
      public void testInternalFromLocal() {
        runTest("compiler/testData/diagnostics/tests/exposed/internalFromLocal.kt");
      }

      @Test
      @TestMetadata("local.kt")
      public void testLocal() {
        runTest("compiler/testData/diagnostics/tests/exposed/local.kt");
      }

      @Test
      @TestMetadata("localFromInternal.kt")
      public void testLocalFromInternal() {
        runTest("compiler/testData/diagnostics/tests/exposed/localFromInternal.kt");
      }

      @Test
      @TestMetadata("localFromPrivate.kt")
      public void testLocalFromPrivate() {
        runTest("compiler/testData/diagnostics/tests/exposed/localFromPrivate.kt");
      }

      @Test
      @TestMetadata("localInFunReturnType.kt")
      public void testLocalInFunReturnType() {
        runTest("compiler/testData/diagnostics/tests/exposed/localInFunReturnType.kt");
      }

      @Test
      @TestMetadata("localInMemberType.kt")
      public void testLocalInMemberType() {
        runTest("compiler/testData/diagnostics/tests/exposed/localInMemberType.kt");
      }

      @Test
      @TestMetadata("localInPropertyType.kt")
      public void testLocalInPropertyType() {
        runTest("compiler/testData/diagnostics/tests/exposed/localInPropertyType.kt");
      }

      @Test
      @TestMetadata("nested.kt")
      public void testNested() {
        runTest("compiler/testData/diagnostics/tests/exposed/nested.kt");
      }

      @Test
      @TestMetadata("nestedInheritance.kt")
      public void testNestedInheritance() {
        runTest("compiler/testData/diagnostics/tests/exposed/nestedInheritance.kt");
      }

      @Test
      @TestMetadata("object.kt")
      public void testObject() {
        runTest("compiler/testData/diagnostics/tests/exposed/object.kt");
      }

      @Test
      @TestMetadata("packagePrivate.kt")
      public void testPackagePrivate() {
        runTest("compiler/testData/diagnostics/tests/exposed/packagePrivate.kt");
      }

      @Test
      @TestMetadata("privateFromLocal.kt")
      public void testPrivateFromLocal() {
        runTest("compiler/testData/diagnostics/tests/exposed/privateFromLocal.kt");
      }

      @Test
      @TestMetadata("privateInFile.kt")
      public void testPrivateInFile() {
        runTest("compiler/testData/diagnostics/tests/exposed/privateInFile.kt");
      }

      @Test
      @TestMetadata("privateInFileDisabled.kt")
      public void testPrivateInFileDisabled() {
        runTest("compiler/testData/diagnostics/tests/exposed/privateInFileDisabled.kt");
      }

      @Test
      @TestMetadata("privatePropertyInPrivateConstructor.kt")
      public void testPrivatePropertyInPrivateConstructor() {
        runTest("compiler/testData/diagnostics/tests/exposed/privatePropertyInPrivateConstructor.kt");
      }

      @Test
      @TestMetadata("propertyInConstructorOfPrivateClass.kt")
      public void testPropertyInConstructorOfPrivateClass() {
        runTest("compiler/testData/diagnostics/tests/exposed/propertyInConstructorOfPrivateClass.kt");
      }

      @Test
      @TestMetadata("propertyInPrivateConstructor.kt")
      public void testPropertyInPrivateConstructor() {
        runTest("compiler/testData/diagnostics/tests/exposed/propertyInPrivateConstructor.kt");
      }

      @Test
      @TestMetadata("propertyInPrivateConstructorError.kt")
      public void testPropertyInPrivateConstructorError() {
        runTest("compiler/testData/diagnostics/tests/exposed/propertyInPrivateConstructorError.kt");
      }

      @Test
      @TestMetadata("propertyInSimpleConstructor.kt")
      public void testPropertyInSimpleConstructor() {
        runTest("compiler/testData/diagnostics/tests/exposed/propertyInSimpleConstructor.kt");
      }

      @Test
      @TestMetadata("protected.kt")
      public void testProtected() {
        runTest("compiler/testData/diagnostics/tests/exposed/protected.kt");
      }

      @Test
      @TestMetadata("protectedInProtected.kt")
      public void testProtectedInProtected() {
        runTest("compiler/testData/diagnostics/tests/exposed/protectedInProtected.kt");
      }

      @Test
      @TestMetadata("protectedJava.kt")
      public void testProtectedJava() {
        runTest("compiler/testData/diagnostics/tests/exposed/protectedJava.kt");
      }

      @Test
      @TestMetadata("protectedSameWay.kt")
      public void testProtectedSameWay() {
        runTest("compiler/testData/diagnostics/tests/exposed/protectedSameWay.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/diagnostics/tests/exposed/simple.kt");
      }

      @Test
      @TestMetadata("typeArgs.kt")
      public void testTypeArgs() {
        runTest("compiler/testData/diagnostics/tests/exposed/typeArgs.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/expressions")
    @TestDataPath("$PROJECT_ROOT")
    public class Expressions {
      @Test
      public void testAllFilesPresentInExpressions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/expressions"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("UnusedExpressionByLocation.kt")
      public void testUnusedExpressionByLocation() {
        runTest("compiler/testData/diagnostics/tests/expressions/UnusedExpressionByLocation.kt");
      }

      @Test
      @TestMetadata("UnusedExpressionByType.kt")
      public void testUnusedExpressionByType() {
        runTest("compiler/testData/diagnostics/tests/expressions/UnusedExpressionByType.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/extensions")
    @TestDataPath("$PROJECT_ROOT")
    public class Extensions {
      @Test
      public void testAllFilesPresentInExtensions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/extensions"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("classObject.kt")
      public void testClassObject() {
        runTest("compiler/testData/diagnostics/tests/extensions/classObject.kt");
      }

      @Test
      @TestMetadata("ExtensionFunctions.kt")
      public void testExtensionFunctions() {
        runTest("compiler/testData/diagnostics/tests/extensions/ExtensionFunctions.kt");
      }

      @Test
      @TestMetadata("extensionMemberInClassObject.kt")
      public void testExtensionMemberInClassObject() {
        runTest("compiler/testData/diagnostics/tests/extensions/extensionMemberInClassObject.kt");
      }

      @Test
      @TestMetadata("extensionPropertyVsParameter.kt")
      public void testExtensionPropertyVsParameter() {
        runTest("compiler/testData/diagnostics/tests/extensions/extensionPropertyVsParameter.kt");
      }

      @Test
      @TestMetadata("ExtensionsCalledOnSuper.kt")
      public void testExtensionsCalledOnSuper() {
        runTest("compiler/testData/diagnostics/tests/extensions/ExtensionsCalledOnSuper.kt");
      }

      @Test
      @TestMetadata("GenericIterator.kt")
      public void testGenericIterator() {
        runTest("compiler/testData/diagnostics/tests/extensions/GenericIterator.kt");
      }

      @Test
      @TestMetadata("GenericIterator2.kt")
      public void testGenericIterator2() {
        runTest("compiler/testData/diagnostics/tests/extensions/GenericIterator2.kt");
      }

      @Test
      @TestMetadata("kt1875.kt")
      public void testKt1875() {
        runTest("compiler/testData/diagnostics/tests/extensions/kt1875.kt");
      }

      @Test
      @TestMetadata("kt2317.kt")
      public void testKt2317() {
        runTest("compiler/testData/diagnostics/tests/extensions/kt2317.kt");
      }

      @Test
      @TestMetadata("kt3470.kt")
      public void testKt3470() {
        runTest("compiler/testData/diagnostics/tests/extensions/kt3470.kt");
      }

      @Test
      @TestMetadata("kt3563.kt")
      public void testKt3563() {
        runTest("compiler/testData/diagnostics/tests/extensions/kt3563.kt");
      }

      @Test
      @TestMetadata("kt819ExtensionProperties.kt")
      public void testKt819ExtensionProperties() {
        runTest("compiler/testData/diagnostics/tests/extensions/kt819ExtensionProperties.kt");
      }

      @Test
      @TestMetadata("noClassObjectsInJava.kt")
      public void testNoClassObjectsInJava() {
        runTest("compiler/testData/diagnostics/tests/extensions/noClassObjectsInJava.kt");
      }

      @Test
      @TestMetadata("object.kt")
      public void testObject() {
        runTest("compiler/testData/diagnostics/tests/extensions/object.kt");
      }

      @Test
      @TestMetadata("throwOutCandidatesByReceiver.kt")
      public void testThrowOutCandidatesByReceiver() {
        runTest("compiler/testData/diagnostics/tests/extensions/throwOutCandidatesByReceiver.kt");
      }

      @Test
      @TestMetadata("throwOutCandidatesByReceiver2.kt")
      public void testThrowOutCandidatesByReceiver2() {
        runTest("compiler/testData/diagnostics/tests/extensions/throwOutCandidatesByReceiver2.kt");
      }

      @Test
      @TestMetadata("variableInvoke.kt")
      public void testVariableInvoke() {
        runTest("compiler/testData/diagnostics/tests/extensions/variableInvoke.kt");
      }

      @Test
      @TestMetadata("ViolatedUpperBoundInExtensionReceiver.kt")
      public void testViolatedUpperBoundInExtensionReceiver() {
        runTest("compiler/testData/diagnostics/tests/extensions/ViolatedUpperBoundInExtensionReceiver.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/extensions/contextReceivers")
      @TestDataPath("$PROJECT_ROOT")
      public class ContextReceivers {
        @Test
        public void testAllFilesPresentInContextReceivers() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/extensions/contextReceivers"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("ambiguityInGroup.kt")
        public void testAmbiguityInGroup() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/ambiguityInGroup.kt");
        }

        @Test
        @TestMetadata("conflicting.kt")
        public void testConflicting() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/conflicting.kt");
        }

        @Test
        @TestMetadata("conflictingWithDifferentOrder.kt")
        public void testConflictingWithDifferentOrder() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/conflictingWithDifferentOrder.kt");
        }

        @Test
        @TestMetadata("contextAndNoContextOverloads.kt")
        public void testContextAndNoContextOverloads() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/contextAndNoContextOverloads.kt");
        }

        @Test
        @TestMetadata("contextKeywordWithElvis.kt")
        public void testContextKeywordWithElvis() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/contextKeywordWithElvis.kt");
        }

        @Test
        @TestMetadata("contextReceiverAmbiguity.kt")
        public void testContextReceiverAmbiguity() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/contextReceiverAmbiguity.kt");
        }

        @Test
        @TestMetadata("contextReceiverTypeParamsUsage.kt")
        public void testContextReceiverTypeParamsUsage() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/contextReceiverTypeParamsUsage.kt");
        }

        @Test
        @TestMetadata("contextReceiverTypeParamsUsageError.kt")
        public void testContextReceiverTypeParamsUsageError() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/contextReceiverTypeParamsUsageError.kt");
        }

        @Test
        @TestMetadata("contextualFunctionalTypeConversion.kt")
        public void testContextualFunctionalTypeConversion() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/contextualFunctionalTypeConversion.kt");
        }

        @Test
        @TestMetadata("deprecated.kt")
        public void testDeprecated() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/deprecated.kt");
        }

        @Test
        @TestMetadata("functionalType.kt")
        public void testFunctionalType() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/functionalType.kt");
        }

        @Test
        @TestMetadata("genericOuterClass.kt")
        public void testGenericOuterClass() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/genericOuterClass.kt");
        }

        @Test
        @TestMetadata("insideDeclaration.kt")
        public void testInsideDeclaration() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/insideDeclaration.kt");
        }

        @Test
        @TestMetadata("labelFromFunctionName.kt")
        public void testLabelFromFunctionName() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/labelFromFunctionName.kt");
        }

        @Test
        @TestMetadata("labelsFromClassNameForbidden.kt")
        public void testLabelsFromClassNameForbidden() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/labelsFromClassNameForbidden.kt");
        }

        @Test
        @TestMetadata("lambdaReceiverFromContext.kt")
        public void testLambdaReceiverFromContext() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/lambdaReceiverFromContext.kt");
        }

        @Test
        @TestMetadata("lambdaReceiverFromContextWithSameFunctions.kt")
        public void testLambdaReceiverFromContextWithSameFunctions() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/lambdaReceiverFromContextWithSameFunctions.kt");
        }

        @Test
        @TestMetadata("lazy.kt")
        public void testLazy() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/lazy.kt");
        }

        @Test
        @TestMetadata("manyReceivers.kt")
        public void testManyReceivers() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/manyReceivers.kt");
        }

        @Test
        @TestMetadata("noBackingField.kt")
        public void testNoBackingField() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/noBackingField.kt");
        }

        @Test
        @TestMetadata("noContextReceiversOnValueClasses.kt")
        public void testNoContextReceiversOnValueClasses() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/noContextReceiversOnValueClasses.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithUniversal());
        }

        @Test
        @TestMetadata("noExplicitReceiver.kt")
        public void testNoExplicitReceiver() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/noExplicitReceiver.kt");
        }

        @Test
        @TestMetadata("noLabelsByClassName.kt")
        public void testNoLabelsByClassName() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/noLabelsByClassName.kt");
        }

        @Test
        @TestMetadata("nonConflicting.kt")
        public void testNonConflicting() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/nonConflicting.kt");
        }

        @Test
        @TestMetadata("outerClass.kt")
        public void testOuterClass() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/outerClass.kt");
        }

        @Test
        @TestMetadata("overloadPriority.kt")
        public void testOverloadPriority() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/overloadPriority.kt");
        }

        @Test
        @TestMetadata("overloading.kt")
        public void testOverloading() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/overloading.kt");
        }

        @Test
        @TestMetadata("parameterizedContextualLambda.kt")
        public void testParameterizedContextualLambda() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/parameterizedContextualLambda.kt");
        }

        @Test
        @TestMetadata("plusMatrix.kt")
        public void testPlusMatrix() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/plusMatrix.kt");
        }

        @Test
        @TestMetadata("priorityInTower.kt")
        public void testPriorityInTower() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/priorityInTower.kt");
        }

        @Test
        @TestMetadata("resolutionByName.kt")
        public void testResolutionByName() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/resolutionByName.kt");
        }

        @Test
        @TestMetadata("subtypingBetweenContextReceivers.kt")
        public void testSubtypingBetweenContextReceivers() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/subtypingBetweenContextReceivers.kt");
        }

        @Test
        @TestMetadata("superWithContext.kt")
        public void testSuperWithContext() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/superWithContext.kt");
        }

        @Test
        @TestMetadata("syntaxError.kt")
        public void testSyntaxError() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/syntaxError.kt");
        }

        @Test
        @TestMetadata("thisIdentifierInfo.kt")
        public void testThisIdentifierInfo() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/thisIdentifierInfo.kt");
        }

        @Test
        @TestMetadata("thisWithCustomLabel.kt")
        public void testThisWithCustomLabel() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/thisWithCustomLabel.kt");
        }

        @Test
        @TestMetadata("thisWithReceiverLabelsClasses.kt")
        public void testThisWithReceiverLabelsClasses() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/thisWithReceiverLabelsClasses.kt");
        }

        @Test
        @TestMetadata("thisWithReceiverLabelsFunctions.kt")
        public void testThisWithReceiverLabelsFunctions() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/thisWithReceiverLabelsFunctions.kt");
        }

        @Test
        @TestMetadata("thisWithReceiverLabelsProperties.kt")
        public void testThisWithReceiverLabelsProperties() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/thisWithReceiverLabelsProperties.kt");
        }

        @Test
        @TestMetadata("twoReceiverCandidatesError.kt")
        public void testTwoReceiverCandidatesError() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/twoReceiverCandidatesError.kt");
        }

        @Test
        @TestMetadata("typeParameterAsContextReceiver.kt")
        public void testTypeParameterAsContextReceiver() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/typeParameterAsContextReceiver.kt");
        }

        @Test
        @TestMetadata("typeParameterized.kt")
        public void testTypeParameterized() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/typeParameterized.kt");
        }

        @Test
        @TestMetadata("typeParameterizedList.kt")
        public void testTypeParameterizedList() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/typeParameterizedList.kt");
        }

        @Test
        @TestMetadata("unsupported.kt")
        public void testUnsupported() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/unsupported.kt");
        }

        @Test
        @TestMetadata("withAnnotations.kt")
        public void testWithAnnotations() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/withAnnotations.kt");
        }

        @Test
        @TestMetadata("withDelegatedProperty.kt")
        public void testWithDelegatedProperty() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/withDelegatedProperty.kt");
        }

        @Test
        @TestMetadata("withExplicitReceiver.kt")
        public void testWithExplicitReceiver() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/withExplicitReceiver.kt");
        }

        @Test
        @TestMetadata("withExplicitReceiverError.kt")
        public void testWithExplicitReceiverError() {
          runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/withExplicitReceiverError.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP")
        @TestDataPath("$PROJECT_ROOT")
        public class FromKEEP {
          @Test
          public void testAllFilesPresentInFromKEEP() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("autoCloseScope.kt")
          public void testAutoCloseScope() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/autoCloseScope.kt");
          }

          @Test
          @TestMetadata("canvas.kt")
          public void testCanvas() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/canvas.kt");
          }

          @Test
          @TestMetadata("clickHandler.kt")
          public void testClickHandler() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/clickHandler.kt");
          }

          @Test
          @TestMetadata("compareTo.kt")
          public void testCompareTo() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/compareTo.kt");
          }

          @Test
          @TestMetadata("decimateEveryEvenThird.kt")
          public void testDecimateEveryEvenThird() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/decimateEveryEvenThird.kt");
          }

          @Test
          @TestMetadata("dp.kt")
          public void testDp() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/dp.kt");
          }

          @Test
          @TestMetadata("functionalType.kt")
          public void testFunctionalType() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/functionalType.kt");
          }

          @Test
          @TestMetadata("iterableClass.kt")
          public void testIterableClass() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/iterableClass.kt");
          }

          @Test
          @TestMetadata("json.kt")
          public void testJson() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/json.kt");
          }

          @Test
          @TestMetadata("loggingContext.kt")
          public void testLoggingContext() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/loggingContext.kt");
          }

          @Test
          @TestMetadata("monoidSum.kt")
          public void testMonoidSum() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/monoidSum.kt");
          }

          @Test
          @TestMetadata("transaction.kt")
          public void testTransaction() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/transaction.kt");
          }

          @Test
          @TestMetadata("userStorage.kt")
          public void testUserStorage() {
            runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/userStorage.kt");
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/external")
    @TestDataPath("$PROJECT_ROOT")
    public class External {
      @Test
      public void testAllFilesPresentInExternal() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/external"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("noExternalModifierInheritance.kt")
      public void testNoExternalModifierInheritance() {
        runTest("compiler/testData/diagnostics/tests/external/noExternalModifierInheritance.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/fieldRename")
    @TestDataPath("$PROJECT_ROOT")
    public class FieldRename {
      @Test
      public void testAllFilesPresentInFieldRename() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/fieldRename"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("derivedClassPropertyShadowsBaseClassField.kt")
      public void testDerivedClassPropertyShadowsBaseClassField() {
        runTest("compiler/testData/diagnostics/tests/fieldRename/derivedClassPropertyShadowsBaseClassField.kt");
      }

      @Test
      @TestMetadata("javaFieldKotlinPropertyDifferentType.kt")
      public void testJavaFieldKotlinPropertyDifferentType() {
        runTest("compiler/testData/diagnostics/tests/fieldRename/javaFieldKotlinPropertyDifferentType.kt");
      }

      @Test
      @TestMetadata("javaFieldKotlinPropertyDifferentType2.kt")
      public void testJavaFieldKotlinPropertyDifferentType2() {
        runTest("compiler/testData/diagnostics/tests/fieldRename/javaFieldKotlinPropertyDifferentType2.kt");
      }

      @Test
      @TestMetadata("javaFieldKotlinPropertyJavaFieldInPackagePrivate.kt")
      public void testJavaFieldKotlinPropertyJavaFieldInPackagePrivate() {
        runTest("compiler/testData/diagnostics/tests/fieldRename/javaFieldKotlinPropertyJavaFieldInPackagePrivate.kt");
      }

      @Test
      @TestMetadata("javaFieldKotlinPropertyJavaPackagePrivateField.kt")
      public void testJavaFieldKotlinPropertyJavaPackagePrivateField() {
        runTest("compiler/testData/diagnostics/tests/fieldRename/javaFieldKotlinPropertyJavaPackagePrivateField.kt");
      }

      @Test
      @TestMetadata("javaProtectedFieldAndKotlinInvisiblePropertyReference.kt")
      public void testJavaProtectedFieldAndKotlinInvisiblePropertyReference() {
        runTest("compiler/testData/diagnostics/tests/fieldRename/javaProtectedFieldAndKotlinInvisiblePropertyReference.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/funInterface")
    @TestDataPath("$PROJECT_ROOT")
    public class FunInterface {
      @Test
      public void testAllFilesPresentInFunInterface() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/funInterface"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("basicFunInterface.kt")
      public void testBasicFunInterface() {
        runTest("compiler/testData/diagnostics/tests/funInterface/basicFunInterface.kt");
      }

      @Test
      @TestMetadata("basicFunInterfaceConversion.kt")
      public void testBasicFunInterfaceConversion() {
        runTest("compiler/testData/diagnostics/tests/funInterface/basicFunInterfaceConversion.kt");
      }

      @Test
      @TestMetadata("funInterfaceConstructorReferences_after.kt")
      public void testFunInterfaceConstructorReferences_after() {
        runTest("compiler/testData/diagnostics/tests/funInterface/funInterfaceConstructorReferences_after.kt");
      }

      @Test
      @TestMetadata("funInterfaceConstructorReferences_before.kt")
      public void testFunInterfaceConstructorReferences_before() {
        runTest("compiler/testData/diagnostics/tests/funInterface/funInterfaceConstructorReferences_before.kt");
      }

      @Test
      @TestMetadata("funInterfaceConversionOnReceiver.kt")
      public void testFunInterfaceConversionOnReceiver() {
        runTest("compiler/testData/diagnostics/tests/funInterface/funInterfaceConversionOnReceiver.kt");
      }

      @Test
      @TestMetadata("funInterfaceDeclarationCheck.kt")
      public void testFunInterfaceDeclarationCheck() {
        runTest("compiler/testData/diagnostics/tests/funInterface/funInterfaceDeclarationCheck.kt");
      }

      @Test
      @TestMetadata("funInterfaceSyntheticConstructors.kt")
      public void testFunInterfaceSyntheticConstructors() {
        runTest("compiler/testData/diagnostics/tests/funInterface/funInterfaceSyntheticConstructors.kt");
      }

      @Test
      @TestMetadata("funInterfaceWithAnyOverrides.kt")
      public void testFunInterfaceWithAnyOverrides() {
        runTest("compiler/testData/diagnostics/tests/funInterface/funInterfaceWithAnyOverrides.kt");
      }

      @Test
      @TestMetadata("funIsNotInheritedFromBaseInterface.kt")
      public void testFunIsNotInheritedFromBaseInterface() {
        runTest("compiler/testData/diagnostics/tests/funInterface/funIsNotInheritedFromBaseInterface.kt");
      }

      @Test
      @TestMetadata("functionDelegateClashOnJvm.kt")
      public void testFunctionDelegateClashOnJvm() {
        runTest("compiler/testData/diagnostics/tests/funInterface/functionDelegateClashOnJvm.kt");
      }

      @Test
      @TestMetadata("genericSubstitutionForFunInterface.kt")
      public void testGenericSubstitutionForFunInterface() {
        runTest("compiler/testData/diagnostics/tests/funInterface/genericSubstitutionForFunInterface.kt");
      }

      @Test
      @TestMetadata("noCompatibilityResolveForFunInterfaces.kt")
      public void testNoCompatibilityResolveForFunInterfaces() {
        runTest("compiler/testData/diagnostics/tests/funInterface/noCompatibilityResolveForFunInterfaces.kt");
      }

      @Test
      @TestMetadata("resolveFunInterfaceWithoutMainMethod.kt")
      public void testResolveFunInterfaceWithoutMainMethod() {
        runTest("compiler/testData/diagnostics/tests/funInterface/resolveFunInterfaceWithoutMainMethod.kt");
      }

      @Test
      @TestMetadata("severalConversionsForFunInterface.kt")
      public void testSeveralConversionsForFunInterface() {
        runTest("compiler/testData/diagnostics/tests/funInterface/severalConversionsForFunInterface.kt");
      }

      @Test
      @TestMetadata("suspendFunInterfaceConversion.kt")
      public void testSuspendFunInterfaceConversion() {
        runTest("compiler/testData/diagnostics/tests/funInterface/suspendFunInterfaceConversion.kt");
      }

      @Test
      @TestMetadata("unitInContravariantPosition.kt")
      public void testUnitInContravariantPosition() {
        runTest("compiler/testData/diagnostics/tests/funInterface/unitInContravariantPosition.kt");
      }

      @Test
      @TestMetadata("unitInCovariantPosition.kt")
      public void testUnitInCovariantPosition() {
        runTest("compiler/testData/diagnostics/tests/funInterface/unitInCovariantPosition.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/functionAsExpression")
    @TestDataPath("$PROJECT_ROOT")
    public class FunctionAsExpression {
      @Test
      public void testAllFilesPresentInFunctionAsExpression() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/functionAsExpression"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("AutoLabels.kt")
      public void testAutoLabels() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/AutoLabels.kt");
      }

      @Test
      @TestMetadata("Common.kt")
      public void testCommon() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/Common.kt");
      }

      @Test
      @TestMetadata("DifficultInferenceForParameter.kt")
      public void testDifficultInferenceForParameter() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/DifficultInferenceForParameter.kt");
      }

      @Test
      @TestMetadata("ForbiddenNonLocalReturn.kt")
      public void testForbiddenNonLocalReturn() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/ForbiddenNonLocalReturn.kt");
      }

      @Test
      @TestMetadata("FunctionType.kt")
      public void testFunctionType() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/FunctionType.kt");
      }

      @Test
      @TestMetadata("InferenceParametersTypes.kt")
      public void testInferenceParametersTypes() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/InferenceParametersTypes.kt");
      }

      @Test
      @TestMetadata("MissingParameterTypes.kt")
      public void testMissingParameterTypes() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/MissingParameterTypes.kt");
      }

      @Test
      @TestMetadata("NameDeprecation.kt")
      public void testNameDeprecation() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/NameDeprecation.kt");
      }

      @Test
      @TestMetadata("NoOverloadError.kt")
      public void testNoOverloadError() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/NoOverloadError.kt");
      }

      @Test
      @TestMetadata("NonSuspendAnonFuncAsInitializerOfSuspendFunctionType.kt")
      public void testNonSuspendAnonFuncAsInitializerOfSuspendFunctionType() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/NonSuspendAnonFuncAsInitializerOfSuspendFunctionType.kt");
      }

      @Test
      @TestMetadata("NonSuspendAnonFuncAsReturnValueOfSuspendFunctionTypeInConcreteFunction.kt")
      public void testNonSuspendAnonFuncAsReturnValueOfSuspendFunctionTypeInConcreteFunction() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/NonSuspendAnonFuncAsReturnValueOfSuspendFunctionTypeInConcreteFunction.kt");
      }

      @Test
      @TestMetadata("parameterAsReceiverInference.kt")
      public void testParameterAsReceiverInference() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/parameterAsReceiverInference.kt");
      }

      @Test
      @TestMetadata("Parameters.kt")
      public void testParameters() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/Parameters.kt");
      }

      @Test
      @TestMetadata("ReceiverByExpectedType.kt")
      public void testReceiverByExpectedType() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/ReceiverByExpectedType.kt");
      }

      @Test
      @TestMetadata("ReturnAndLabels.kt")
      public void testReturnAndLabels() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/ReturnAndLabels.kt");
      }

      @Test
      @TestMetadata("ReturnTypeCheck.kt")
      public void testReturnTypeCheck() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/ReturnTypeCheck.kt");
      }

      @Test
      @TestMetadata("ScopeCheck.kt")
      public void testScopeCheck() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/ScopeCheck.kt");
      }

      @Test
      @TestMetadata("WithGenericParameters.kt")
      public void testWithGenericParameters() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/WithGenericParameters.kt");
      }

      @Test
      @TestMetadata("WithOuterGeneric.kt")
      public void testWithOuterGeneric() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/WithOuterGeneric.kt");
      }

      @Test
      @TestMetadata("WithoutBody.kt")
      public void testWithoutBody() {
        runTest("compiler/testData/diagnostics/tests/functionAsExpression/WithoutBody.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/functionLiterals")
    @TestDataPath("$PROJECT_ROOT")
    public class FunctionLiterals {
      @Test
      public void testAllFilesPresentInFunctionLiterals() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/functionLiterals"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("assignmentOperationInLambda.kt")
      public void testAssignmentOperationInLambda() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/assignmentOperationInLambda.kt");
      }

      @Test
      @TestMetadata("assignmentOperationInLambdaWithExpectedType.kt")
      public void testAssignmentOperationInLambdaWithExpectedType() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/assignmentOperationInLambdaWithExpectedType.kt");
      }

      @Test
      @TestMetadata("DeprecatedSyntax.kt")
      public void testDeprecatedSyntax() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/DeprecatedSyntax.kt");
      }

      @Test
      @TestMetadata("emptyLambdaTypeMismatchDiagnostic.kt")
      public void testEmptyLambdaTypeMismatchDiagnostic() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/emptyLambdaTypeMismatchDiagnostic.kt");
      }

      @Test
      @TestMetadata("ExpectedParameterTypeMismatchVariance.kt")
      public void testExpectedParameterTypeMismatchVariance() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/ExpectedParameterTypeMismatchVariance.kt");
      }

      @Test
      @TestMetadata("ExpectedParametersTypesMismatch.kt")
      public void testExpectedParametersTypesMismatch() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/ExpectedParametersTypesMismatch.kt");
      }

      @Test
      @TestMetadata("functionExpressionAsLastExpressionInBlock.kt")
      public void testFunctionExpressionAsLastExpressionInBlock() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/functionExpressionAsLastExpressionInBlock.kt");
      }

      @Test
      @TestMetadata("functionLIteralInBlockInIf.kt")
      public void testFunctionLIteralInBlockInIf() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/functionLIteralInBlockInIf.kt");
      }

      @Test
      @TestMetadata("functionLiteralAsArgumentForFunction.kt")
      public void testFunctionLiteralAsArgumentForFunction() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/functionLiteralAsArgumentForFunction.kt");
      }

      @Test
      @TestMetadata("functionLiteralInIf.kt")
      public void testFunctionLiteralInIf() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/functionLiteralInIf.kt");
      }

      @Test
      @TestMetadata("functionLiteralWithoutArgumentList.kt")
      public void testFunctionLiteralWithoutArgumentList() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/functionLiteralWithoutArgumentList.kt");
      }

      @Test
      @TestMetadata("genericFunctionalTypeOnRHSOfPlusAssign.kt")
      public void testGenericFunctionalTypeOnRHSOfPlusAssign() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/genericFunctionalTypeOnRHSOfPlusAssign.kt");
      }

      @Test
      @TestMetadata("higherOrderCallMissingParameters.kt")
      public void testHigherOrderCallMissingParameters() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/higherOrderCallMissingParameters.kt");
      }

      @Test
      @TestMetadata("kt11733.kt")
      public void testKt11733() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/kt11733.kt");
      }

      @Test
      @TestMetadata("kt11733_1.kt")
      public void testKt11733_1() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/kt11733_1.kt");
      }

      @Test
      @TestMetadata("kt16016.kt")
      public void testKt16016() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/kt16016.kt");
      }

      @Test
      @TestMetadata("kt2906.kt")
      public void testKt2906() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/kt2906.kt");
      }

      @Test
      @TestMetadata("kt3343.kt")
      public void testKt3343() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/kt3343.kt");
      }

      @Test
      @TestMetadata("kt4529.kt")
      public void testKt4529() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/kt4529.kt");
      }

      @Test
      @TestMetadata("kt47493.kt")
      public void testKt47493() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/kt47493.kt");
      }

      @Test
      @TestMetadata("kt51317.kt")
      public void testKt51317() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/kt51317.kt");
      }

      @Test
      @TestMetadata("kt56138.kt")
      public void testKt56138() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/kt56138.kt");
      }

      @Test
      @TestMetadata("kt6541_extensionForExtensionFunction.kt")
      public void testKt6541_extensionForExtensionFunction() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/kt6541_extensionForExtensionFunction.kt");
      }

      @Test
      @TestMetadata("kt6869.kt")
      public void testKt6869() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/kt6869.kt");
      }

      @Test
      @TestMetadata("kt7383_starProjectedFunction.kt")
      public void testKt7383_starProjectedFunction() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/kt7383_starProjectedFunction.kt");
      }

      @Test
      @TestMetadata("LabeledFunctionLiterals.kt")
      public void testLabeledFunctionLiterals() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/LabeledFunctionLiterals.kt");
      }

      @Test
      @TestMetadata("lambdaInLambda2.kt")
      public void testLambdaInLambda2() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/lambdaInLambda2.kt");
      }

      @Test
      @TestMetadata("missedTypeMismatch.kt")
      public void testMissedTypeMismatch() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/missedTypeMismatch.kt");
      }

      @Test
      @TestMetadata("prematurelyAnalyzingLambdaWhileFixingTypeVariableForAnotherArgument.kt")
      public void testPrematurelyAnalyzingLambdaWhileFixingTypeVariableForAnotherArgument() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/prematurelyAnalyzingLambdaWhileFixingTypeVariableForAnotherArgument.kt");
      }

      @Test
      @TestMetadata("returnNull.kt")
      public void testReturnNull() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/returnNull.kt");
      }

      @Test
      @TestMetadata("returnNullWithReturn.kt")
      public void testReturnNullWithReturn() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/returnNullWithReturn.kt");
      }

      @Test
      @TestMetadata("underscopeParameters.kt")
      public void testUnderscopeParameters() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/underscopeParameters.kt");
      }

      @Test
      @TestMetadata("unusedLiteral.kt")
      public void testUnusedLiteral() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/unusedLiteral.kt");
      }

      @Test
      @TestMetadata("unusedLiteralInsideUnitLiteral.kt")
      public void testUnusedLiteralInsideUnitLiteral() {
        runTest("compiler/testData/diagnostics/tests/functionLiterals/unusedLiteralInsideUnitLiteral.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas")
      @TestDataPath("$PROJECT_ROOT")
      public class DestructuringInLambdas {
        @Test
        public void testAllFilesPresentInDestructuringInLambdas() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("complexInference.kt")
        public void testComplexInference() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/complexInference.kt");
        }

        @Test
        @TestMetadata("extensionComponents.kt")
        public void testExtensionComponents() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/extensionComponents.kt");
        }

        @Test
        @TestMetadata("inferredFunctionalType.kt")
        public void testInferredFunctionalType() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/inferredFunctionalType.kt");
        }

        @Test
        @TestMetadata("modifiers.kt")
        public void testModifiers() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/modifiers.kt");
        }

        @Test
        @TestMetadata("noExpectedType.kt")
        public void testNoExpectedType() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/noExpectedType.kt");
        }

        @Test
        @TestMetadata("redeclaration.kt")
        public void testRedeclaration() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/redeclaration.kt");
        }

        @Test
        @TestMetadata("shadowing.kt")
        public void testShadowing() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/shadowing.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/simple.kt");
        }

        @Test
        @TestMetadata("underscore.kt")
        public void testUnderscore() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/underscore.kt");
        }

        @Test
        @TestMetadata("unusedParameters.kt")
        public void testUnusedParameters() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/unusedParameters.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/functionLiterals/return")
      @TestDataPath("$PROJECT_ROOT")
      public class Return {
        @Test
        public void testAllFilesPresentInReturn() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/functionLiterals/return"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("AutoLabels.kt")
        public void testAutoLabels() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/AutoLabels.kt");
        }

        @Test
        @TestMetadata("AutoLabelsNonLocal.kt")
        public void testAutoLabelsNonLocal() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/AutoLabelsNonLocal.kt");
        }

        @Test
        @TestMetadata("ForbiddenNonLocalReturnNoType.kt")
        public void testForbiddenNonLocalReturnNoType() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/ForbiddenNonLocalReturnNoType.kt");
        }

        @Test
        @TestMetadata("IfInReturnedExpression.kt")
        public void testIfInReturnedExpression() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/IfInReturnedExpression.kt");
        }

        @Test
        @TestMetadata("IfWithoutElse.kt")
        public void testIfWithoutElse() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/IfWithoutElse.kt");
        }

        @Test
        @TestMetadata("IfWithoutElseWithExplicitType.kt")
        public void testIfWithoutElseWithExplicitType() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/IfWithoutElseWithExplicitType.kt");
        }

        @Test
        @TestMetadata("kt66277.kt")
        public void testKt66277() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/kt66277.kt");
        }

        @Test
        @TestMetadata("kt66279.kt")
        public void testKt66279() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/kt66279.kt");
        }

        @Test
        @TestMetadata("kt66512.kt")
        public void testKt66512() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/kt66512.kt");
        }

        @Test
        @TestMetadata("kt66534.kt")
        public void testKt66534() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/kt66534.kt");
        }

        @Test
        @TestMetadata("LambdaReturnTypeIsUnitIfImplicitReturnExists.kt")
        public void testLambdaReturnTypeIsUnitIfImplicitReturnExists() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LambdaReturnTypeIsUnitIfImplicitReturnExists.kt");
        }

        @Test
        @TestMetadata("LambdaWithParameter.kt")
        public void testLambdaWithParameter() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LambdaWithParameter.kt");
        }

        @Test
        @TestMetadata("LocalAndNonLocalReturnInLambda.kt")
        public void testLocalAndNonLocalReturnInLambda() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalAndNonLocalReturnInLambda.kt");
        }

        @Test
        @TestMetadata("LocalReturnExplicitLabelNoParens.kt")
        public void testLocalReturnExplicitLabelNoParens() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnExplicitLabelNoParens.kt");
        }

        @Test
        @TestMetadata("LocalReturnExplicitLabelParens.kt")
        public void testLocalReturnExplicitLabelParens() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnExplicitLabelParens.kt");
        }

        @Test
        @TestMetadata("LocalReturnHasTypeNothing.kt")
        public void testLocalReturnHasTypeNothing() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnHasTypeNothing.kt");
        }

        @Test
        @TestMetadata("LocalReturnInNestedFunction.kt")
        public void testLocalReturnInNestedFunction() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnInNestedFunction.kt");
        }

        @Test
        @TestMetadata("LocalReturnInNestedLambda.kt")
        public void testLocalReturnInNestedLambda() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnInNestedLambda.kt");
        }

        @Test
        @TestMetadata("LocalReturnNoCoercionToUnit.kt")
        public void testLocalReturnNoCoercionToUnit() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnNoCoercionToUnit.kt");
        }

        @Test
        @TestMetadata("LocalReturnNull.kt")
        public void testLocalReturnNull() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnNull.kt");
        }

        @Test
        @TestMetadata("LocalReturnSecondUnit.kt")
        public void testLocalReturnSecondUnit() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnSecondUnit.kt");
        }

        @Test
        @TestMetadata("LocalReturnUnit.kt")
        public void testLocalReturnUnit() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnUnit.kt");
        }

        @Test
        @TestMetadata("LocalReturnUnitAndDontCareType.kt")
        public void testLocalReturnUnitAndDontCareType() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnUnitAndDontCareType.kt");
        }

        @Test
        @TestMetadata("LocalReturnUnitWithBodyExpression.kt")
        public void testLocalReturnUnitWithBodyExpression() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnUnitWithBodyExpression.kt");
        }

        @Test
        @TestMetadata("LocalReturnWithExpectedType.kt")
        public void testLocalReturnWithExpectedType() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnWithExpectedType.kt");
        }

        @Test
        @TestMetadata("LocalReturnWithExplicitUnit.kt")
        public void testLocalReturnWithExplicitUnit() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnWithExplicitUnit.kt");
        }

        @Test
        @TestMetadata("LocalReturnWithFlexibleUnitType.kt")
        public void testLocalReturnWithFlexibleUnitType() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnWithFlexibleUnitType.kt");
        }

        @Test
        @TestMetadata("LocalReturnsWithExplicitReturnType.kt")
        public void testLocalReturnsWithExplicitReturnType() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnsWithExplicitReturnType.kt");
        }

        @Test
        @TestMetadata("MixedReturnsFromLambda.kt")
        public void testMixedReturnsFromLambda() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/MixedReturnsFromLambda.kt");
        }

        @Test
        @TestMetadata("MultipleLocalUnitReturns.kt")
        public void testMultipleLocalUnitReturns() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/MultipleLocalUnitReturns.kt");
        }

        @Test
        @TestMetadata("NoCommonSystem.kt")
        public void testNoCommonSystem() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/NoCommonSystem.kt");
        }

        @Test
        @TestMetadata("SmartCast.kt")
        public void testSmartCast() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/SmartCast.kt");
        }

        @Test
        @TestMetadata("SmartCastWithExplicitType.kt")
        public void testSmartCastWithExplicitType() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/SmartCastWithExplicitType.kt");
        }

        @Test
        @TestMetadata("unresolvedReferenceInReturnBlock.kt")
        public void testUnresolvedReferenceInReturnBlock() {
          runTest("compiler/testData/diagnostics/tests/functionLiterals/return/unresolvedReferenceInReturnBlock.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/generics")
    @TestDataPath("$PROJECT_ROOT")
    public class Generics {
      @Test
      public void testAllFilesPresentInGenerics() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("anonymousObjectSupertypeWithTypeParameterFromFunction.kt")
      public void testAnonymousObjectSupertypeWithTypeParameterFromFunction() {
        runTest("compiler/testData/diagnostics/tests/generics/anonymousObjectSupertypeWithTypeParameterFromFunction.kt");
      }

      @Test
      @TestMetadata("approximationOfBoundedProjection.kt")
      public void testApproximationOfBoundedProjection() {
        runTest("compiler/testData/diagnostics/tests/generics/approximationOfBoundedProjection.kt");
      }

      @Test
      @TestMetadata("approximationOfInProjection.kt")
      public void testApproximationOfInProjection() {
        runTest("compiler/testData/diagnostics/tests/generics/approximationOfInProjection.kt");
      }

      @Test
      @TestMetadata("argumentsForT.kt")
      public void testArgumentsForT() {
        runTest("compiler/testData/diagnostics/tests/generics/argumentsForT.kt");
      }

      @Test
      @TestMetadata("bareTypesWithStarProjections.kt")
      public void testBareTypesWithStarProjections() {
        runTest("compiler/testData/diagnostics/tests/generics/bareTypesWithStarProjections.kt");
      }

      @Test
      @TestMetadata("commonSupertypeContravariant.kt")
      public void testCommonSupertypeContravariant() {
        runTest("compiler/testData/diagnostics/tests/generics/commonSupertypeContravariant.kt");
      }

      @Test
      @TestMetadata("commonSupertypeContravariant2.kt")
      public void testCommonSupertypeContravariant2() {
        runTest("compiler/testData/diagnostics/tests/generics/commonSupertypeContravariant2.kt");
      }

      @Test
      @TestMetadata("conflictingStarAndTypeParameterBounds.kt")
      public void testConflictingStarAndTypeParameterBounds() {
        runTest("compiler/testData/diagnostics/tests/generics/conflictingStarAndTypeParameterBounds.kt");
      }

      @Test
      @TestMetadata("constructorOnGenericQualifier.kt")
      public void testConstructorOnGenericQualifier() {
        runTest("compiler/testData/diagnostics/tests/generics/constructorOnGenericQualifier.kt");
      }

      @Test
      @TestMetadata("constructorOnGenericQualifierForbidden.kt")
      public void testConstructorOnGenericQualifierForbidden() {
        runTest("compiler/testData/diagnostics/tests/generics/constructorOnGenericQualifierForbidden.kt");
      }

      @Test
      @TestMetadata("doNotCaptureSupertype.kt")
      public void testDoNotCaptureSupertype() {
        runTest("compiler/testData/diagnostics/tests/generics/doNotCaptureSupertype.kt");
      }

      @Test
      @TestMetadata("finalUpperBoundWithOverride.kt")
      public void testFinalUpperBoundWithOverride() {
        runTest("compiler/testData/diagnostics/tests/generics/finalUpperBoundWithOverride.kt");
      }

      @Test
      @TestMetadata("finalUpperBoundWithoutOverride.kt")
      public void testFinalUpperBoundWithoutOverride() {
        runTest("compiler/testData/diagnostics/tests/generics/finalUpperBoundWithoutOverride.kt");
      }

      @Test
      @TestMetadata("genericsInType.kt")
      public void testGenericsInType() {
        runTest("compiler/testData/diagnostics/tests/generics/genericsInType.kt");
      }

      @Test
      @TestMetadata("InconsistentTypeParameterBounds.kt")
      public void testInconsistentTypeParameterBounds() {
        runTest("compiler/testData/diagnostics/tests/generics/InconsistentTypeParameterBounds.kt");
      }

      @Test
      @TestMetadata("invalidArgumentsNumberInWhere.kt")
      public void testInvalidArgumentsNumberInWhere() {
        runTest("compiler/testData/diagnostics/tests/generics/invalidArgumentsNumberInWhere.kt");
      }

      @Test
      @TestMetadata("kt1575-Class.kt")
      public void testKt1575_Class() {
        runTest("compiler/testData/diagnostics/tests/generics/kt1575-Class.kt");
      }

      @Test
      @TestMetadata("kt1575-Function.kt")
      public void testKt1575_Function() {
        runTest("compiler/testData/diagnostics/tests/generics/kt1575-Function.kt");
      }

      @Test
      @TestMetadata("kt30590.kt")
      public void testKt30590() {
        runTest("compiler/testData/diagnostics/tests/generics/kt30590.kt");
      }

      @Test
      @TestMetadata("kt34729.kt")
      public void testKt34729() {
        runTest("compiler/testData/diagnostics/tests/generics/kt34729.kt");
      }

      @Test
      @TestMetadata("kt53656.kt")
      public void testKt53656() {
        runTest("compiler/testData/diagnostics/tests/generics/kt53656.kt");
      }

      @Test
      @TestMetadata("kt5508.kt")
      public void testKt5508() {
        runTest("compiler/testData/diagnostics/tests/generics/kt5508.kt");
      }

      @Test
      @TestMetadata("kt9203.kt")
      public void testKt9203() {
        runTest("compiler/testData/diagnostics/tests/generics/kt9203.kt");
      }

      @Test
      @TestMetadata("kt9203_1.kt")
      public void testKt9203_1() {
        runTest("compiler/testData/diagnostics/tests/generics/kt9203_1.kt");
      }

      @Test
      @TestMetadata("kt9985.kt")
      public void testKt9985() {
        runTest("compiler/testData/diagnostics/tests/generics/kt9985.kt");
      }

      @Test
      @TestMetadata("localClassTypeRefWithTypeParameterFromFunction.kt")
      public void testLocalClassTypeRefWithTypeParameterFromFunction() {
        runTest("compiler/testData/diagnostics/tests/generics/localClassTypeRefWithTypeParameterFromFunction.kt");
      }

      @Test
      @TestMetadata("noInconsistentTypeParameterBoundsWithDifferentProjectionKinds.kt")
      public void testNoInconsistentTypeParameterBoundsWithDifferentProjectionKinds() {
        runTest("compiler/testData/diagnostics/tests/generics/noInconsistentTypeParameterBoundsWithDifferentProjectionKinds.kt");
      }

      @Test
      @TestMetadata("noInconsistentTypeParameterBoundsWithStarProjections.kt")
      public void testNoInconsistentTypeParameterBoundsWithStarProjections() {
        runTest("compiler/testData/diagnostics/tests/generics/noInconsistentTypeParameterBoundsWithStarProjections.kt");
      }

      @Test
      @TestMetadata("nullableTypeParameterScope.kt")
      public void testNullableTypeParameterScope() {
        runTest("compiler/testData/diagnostics/tests/generics/nullableTypeParameterScope.kt");
      }

      @Test
      @TestMetadata("outerTypeParametersInNestedClasses.kt")
      public void testOuterTypeParametersInNestedClasses() {
        runTest("compiler/testData/diagnostics/tests/generics/outerTypeParametersInNestedClasses.kt");
      }

      @Test
      @TestMetadata("Projections.kt")
      public void testProjections() {
        runTest("compiler/testData/diagnostics/tests/generics/Projections.kt");
      }

      @Test
      @TestMetadata("protectedSuperCall.kt")
      public void testProtectedSuperCall() {
        runTest("compiler/testData/diagnostics/tests/generics/protectedSuperCall.kt");
      }

      @Test
      @TestMetadata("PseudoRawTypes.kt")
      public void testPseudoRawTypes() {
        runTest("compiler/testData/diagnostics/tests/generics/PseudoRawTypes.kt");
      }

      @Test
      @TestMetadata("RawTypeInIsExpression.kt")
      public void testRawTypeInIsExpression() {
        runTest("compiler/testData/diagnostics/tests/generics/RawTypeInIsExpression.kt");
      }

      @Test
      @TestMetadata("RawTypeInIsPattern.kt")
      public void testRawTypeInIsPattern() {
        runTest("compiler/testData/diagnostics/tests/generics/RawTypeInIsPattern.kt");
      }

      @Test
      @TestMetadata("recursive.kt")
      public void testRecursive() {
        runTest("compiler/testData/diagnostics/tests/generics/recursive.kt");
      }

      @Test
      @TestMetadata("RecursiveUpperBoundCheck.kt")
      public void testRecursiveUpperBoundCheck() {
        runTest("compiler/testData/diagnostics/tests/generics/RecursiveUpperBoundCheck.kt");
      }

      @Test
      @TestMetadata("RecursiveUpperBoundWithTwoArguments.kt")
      public void testRecursiveUpperBoundWithTwoArguments() {
        runTest("compiler/testData/diagnostics/tests/generics/RecursiveUpperBoundWithTwoArguments.kt");
      }

      @Test
      @TestMetadata("resolveGenericBoundsBeforeSupertypes.kt")
      public void testResolveGenericBoundsBeforeSupertypes() {
        runTest("compiler/testData/diagnostics/tests/generics/resolveGenericBoundsBeforeSupertypes.kt");
      }

      @Test
      @TestMetadata("sameTypeParameterUse.kt")
      public void testSameTypeParameterUse() {
        runTest("compiler/testData/diagnostics/tests/generics/sameTypeParameterUse.kt");
      }

      @Test
      @TestMetadata("suppressVarianceConflict.kt")
      public void testSuppressVarianceConflict() {
        runTest("compiler/testData/diagnostics/tests/generics/suppressVarianceConflict.kt");
      }

      @Test
      @TestMetadata("TypeParameterBounds.kt")
      public void testTypeParameterBounds() {
        runTest("compiler/testData/diagnostics/tests/generics/TypeParameterBounds.kt");
      }

      @Test
      @TestMetadata("TypeParametersInTypeParameterBounds.kt")
      public void testTypeParametersInTypeParameterBounds() {
        runTest("compiler/testData/diagnostics/tests/generics/TypeParametersInTypeParameterBounds.kt");
      }

      @Test
      @TestMetadata("unclearTypeMismatch.kt")
      public void testUnclearTypeMismatch() {
        runTest("compiler/testData/diagnostics/tests/generics/unclearTypeMismatch.kt");
      }

      @Test
      @TestMetadata("unclearTypeMismatchWithCapturedTypes.kt")
      public void testUnclearTypeMismatchWithCapturedTypes() {
        runTest("compiler/testData/diagnostics/tests/generics/unclearTypeMismatchWithCapturedTypes.kt");
      }

      @Test
      @TestMetadata("unresolvedClassifierInWhere.kt")
      public void testUnresolvedClassifierInWhere() {
        runTest("compiler/testData/diagnostics/tests/generics/unresolvedClassifierInWhere.kt");
      }

      @Test
      @TestMetadata("whereClauseSyntax.kt")
      public void testWhereClauseSyntax() {
        runTest("compiler/testData/diagnostics/tests/generics/whereClauseSyntax.kt");
      }

      @Test
      @TestMetadata("wildcardInValueParameter.kt")
      public void testWildcardInValueParameter() {
        runTest("compiler/testData/diagnostics/tests/generics/wildcardInValueParameter.kt");
      }

      @Test
      @TestMetadata("wrongNumberOfTypeArgumentsDiagnostic.kt")
      public void testWrongNumberOfTypeArgumentsDiagnostic() {
        runTest("compiler/testData/diagnostics/tests/generics/wrongNumberOfTypeArgumentsDiagnostic.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/generics/capturedParameters")
      @TestDataPath("$PROJECT_ROOT")
      public class CapturedParameters {
        @Test
        public void testAllFilesPresentInCapturedParameters() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/capturedParameters"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("captured.kt")
        public void testCaptured() {
          runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/captured.kt");
        }

        @Test
        @TestMetadata("innerLocalClass.kt")
        public void testInnerLocalClass() {
          runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/innerLocalClass.kt");
        }

        @Test
        @TestMetadata("localClass.kt")
        public void testLocalClass() {
          runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/localClass.kt");
        }

        @Test
        @TestMetadata("localWithTypeParameter.kt")
        public void testLocalWithTypeParameter() {
          runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/localWithTypeParameter.kt");
        }

        @Test
        @TestMetadata("objectLiteral.kt")
        public void testObjectLiteral() {
          runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/objectLiteral.kt");
        }

        @Test
        @TestMetadata("uncheckedCast.kt")
        public void testUncheckedCast() {
          runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/uncheckedCast.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/generics/cyclicBounds")
      @TestDataPath("$PROJECT_ROOT")
      public class CyclicBounds {
        @Test
        public void testAllFilesPresentInCyclicBounds() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/cyclicBounds"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("functions.kt")
        public void testFunctions() {
          runTest("compiler/testData/diagnostics/tests/generics/cyclicBounds/functions.kt");
        }

        @Test
        @TestMetadata("inClass.kt")
        public void testInClass() {
          runTest("compiler/testData/diagnostics/tests/generics/cyclicBounds/inClass.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/generics/innerClasses")
      @TestDataPath("$PROJECT_ROOT")
      public class InnerClasses {
        @Test
        public void testAllFilesPresentInInnerClasses() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/innerClasses"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("bareTypes.kt")
        public void testBareTypes() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/bareTypes.kt");
        }

        @Test
        @TestMetadata("bareTypesComplex.kt")
        public void testBareTypesComplex() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/bareTypesComplex.kt");
        }

        @Test
        @TestMetadata("castAnElementToInnerClassWithTypeParameter.kt")
        public void testCastAnElementToInnerClassWithTypeParameter() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/castAnElementToInnerClassWithTypeParameter.kt");
        }

        @Test
        @TestMetadata("checkBoundsOuter.kt")
        public void testCheckBoundsOuter() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/checkBoundsOuter.kt");
        }

        @Test
        @TestMetadata("importedInner.kt")
        public void testImportedInner() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/importedInner.kt");
        }

        @Test
        @TestMetadata("innerClassGenericBounds.kt")
        public void testInnerClassGenericBounds() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerClassGenericBounds.kt");
        }

        @Test
        @TestMetadata("innerSuperCall.kt")
        public void testInnerSuperCall() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerSuperCall.kt");
        }

        @Test
        @TestMetadata("innerSuperCallSecondary.kt")
        public void testInnerSuperCallSecondary() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerSuperCallSecondary.kt");
        }

        @Test
        @TestMetadata("innerTP.kt")
        public void testInnerTP() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerTP.kt");
        }

        @Test
        @TestMetadata("innerUncheckedCast.kt")
        public void testInnerUncheckedCast() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerUncheckedCast.kt");
        }

        @Test
        @TestMetadata("innerVariance.kt")
        public void testInnerVariance() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerVariance.kt");
        }

        @Test
        @TestMetadata("iterator.kt")
        public void testIterator() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/iterator.kt");
        }

        @Test
        @TestMetadata("j+k.kt")
        public void testJ_k() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/j+k.kt");
        }

        @Test
        @TestMetadata("j+k_complex.kt")
        public void testJ_k_complex() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/j+k_complex.kt");
        }

        @Test
        @TestMetadata("kt3357.kt")
        public void testKt3357() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/kt3357.kt");
        }

        @Test
        @TestMetadata("kt408.kt")
        public void testKt408() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/kt408.kt");
        }

        @Test
        @TestMetadata("kt6325.kt")
        public void testKt6325() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/kt6325.kt");
        }

        @Test
        @TestMetadata("noTypeVarianceConflictInNestedClass.kt")
        public void testNoTypeVarianceConflictInNestedClass() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/noTypeVarianceConflictInNestedClass.kt");
        }

        @Test
        @TestMetadata("outerArgumentsRequired.kt")
        public void testOuterArgumentsRequired() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/outerArgumentsRequired.kt");
        }

        @Test
        @TestMetadata("parameterShadowing.kt")
        public void testParameterShadowing() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/parameterShadowing.kt");
        }

        @Test
        @TestMetadata("qualifiedOuter.kt")
        public void testQualifiedOuter() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/qualifiedOuter.kt");
        }

        @Test
        @TestMetadata("qualifiedTypesResolution.kt")
        public void testQualifiedTypesResolution() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/qualifiedTypesResolution.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/simple.kt");
        }

        @Test
        @TestMetadata("simpleIn.kt")
        public void testSimpleIn() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/simpleIn.kt");
        }

        @Test
        @TestMetadata("simpleOut.kt")
        public void testSimpleOut() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/simpleOut.kt");
        }

        @Test
        @TestMetadata("simpleOutUseSite.kt")
        public void testSimpleOutUseSite() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/simpleOutUseSite.kt");
        }

        @Test
        @TestMetadata("substitutedMemberScope.kt")
        public void testSubstitutedMemberScope() {
          runTest("compiler/testData/diagnostics/tests/generics/innerClasses/substitutedMemberScope.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments")
        @TestDataPath("$PROJECT_ROOT")
        public class ImplicitArguments {
          @Test
          public void testAllFilesPresentInImplicitArguments() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("fromCompanionObject_after.kt")
          public void testFromCompanionObject_after() {
            runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromCompanionObject_after.kt");
          }

          @Test
          @TestMetadata("fromCompanionObject_before.kt")
          public void testFromCompanionObject_before() {
            runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromCompanionObject_before.kt");
          }

          @Test
          @TestMetadata("fromOuterClassInObjectLiteral.kt")
          public void testFromOuterClassInObjectLiteral() {
            runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromOuterClassInObjectLiteral.kt");
          }

          @Test
          @TestMetadata("fromSuperClasses.kt")
          public void testFromSuperClasses() {
            runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClasses.kt");
          }

          @Test
          @TestMetadata("fromSuperClassesLocal.kt")
          public void testFromSuperClassesLocal() {
            runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClassesLocal.kt");
          }

          @Test
          @TestMetadata("fromSuperClassesLocalInsideInner.kt")
          public void testFromSuperClassesLocalInsideInner() {
            runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClassesLocalInsideInner.kt");
          }

          @Test
          @TestMetadata("fromSuperClassesTransitive.kt")
          public void testFromSuperClassesTransitive() {
            runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClassesTransitive.kt");
          }

          @Test
          @TestMetadata("inStaticScope.kt")
          public void testInStaticScope() {
            runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/inStaticScope.kt");
          }

          @Test
          @TestMetadata("runtimeCrashOnInnerWithImplicitInArgument.kt")
          public void testRuntimeCrashOnInnerWithImplicitInArgument() {
            runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/runtimeCrashOnInnerWithImplicitInArgument.kt");
          }

          @Test
          @TestMetadata("runtimeCrashOnInnerWithImplicitOutArgument.kt")
          public void testRuntimeCrashOnInnerWithImplicitOutArgument() {
            runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/runtimeCrashOnInnerWithImplicitOutArgument.kt");
          }

          @Test
          @TestMetadata("secondLevelDepth.kt")
          public void testSecondLevelDepth() {
            runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/secondLevelDepth.kt");
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope")
      @TestDataPath("$PROJECT_ROOT")
      public class MultipleBoundsMemberScope {
        @Test
        public void testAllFilesPresentInMultipleBoundsMemberScope() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("conflictingReturnType.kt")
        public void testConflictingReturnType() {
          runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/conflictingReturnType.kt");
        }

        @Test
        @TestMetadata("flexibleTypes.kt")
        public void testFlexibleTypes() {
          runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/flexibleTypes.kt");
        }

        @Test
        @TestMetadata("mostSpecific.kt")
        public void testMostSpecific() {
          runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/mostSpecific.kt");
        }

        @Test
        @TestMetadata("properties.kt")
        public void testProperties() {
          runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/properties.kt");
        }

        @Test
        @TestMetadata("propertiesConflict.kt")
        public void testPropertiesConflict() {
          runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/propertiesConflict.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/simple.kt");
        }

        @Test
        @TestMetadata("validTypeParameters.kt")
        public void testValidTypeParameters() {
          runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/validTypeParameters.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/generics/nullability")
      @TestDataPath("$PROJECT_ROOT")
      public class Nullability {
        @Test
        public void testAllFilesPresentInNullability() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/nullability"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("capturedTypeWithPlatformSupertype.kt")
        public void testCapturedTypeWithPlatformSupertype() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/capturedTypeWithPlatformSupertype.kt");
        }

        @Test
        @TestMetadata("considerTypeNotNullOnlyIfItHasNotNullBound.kt")
        public void testConsiderTypeNotNullOnlyIfItHasNotNullBound() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/considerTypeNotNullOnlyIfItHasNotNullBound.kt");
        }

        @Test
        @TestMetadata("correctSubstitutionForIncorporationConstraint.kt")
        public void testCorrectSubstitutionForIncorporationConstraint() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/correctSubstitutionForIncorporationConstraint.kt");
        }

        @Test
        @TestMetadata("declarationsBoundsViolation.kt")
        public void testDeclarationsBoundsViolation() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/declarationsBoundsViolation.kt");
        }

        @Test
        @TestMetadata("expressionsBoundsViolation.kt")
        public void testExpressionsBoundsViolation() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/expressionsBoundsViolation.kt");
        }

        @Test
        @TestMetadata("functionalBound.kt")
        public void testFunctionalBound() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/functionalBound.kt");
        }

        @Test
        @TestMetadata("inferNotNullTypeFromIntersectionOfNullableTypes.kt")
        public void testInferNotNullTypeFromIntersectionOfNullableTypes() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/inferNotNullTypeFromIntersectionOfNullableTypes.kt");
        }

        @Test
        @TestMetadata("kt25182.kt")
        public void testKt25182() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/kt25182.kt");
        }

        @Test
        @TestMetadata("notNullSmartcastOnIntersectionOfNullables.kt")
        public void testNotNullSmartcastOnIntersectionOfNullables() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/notNullSmartcastOnIntersectionOfNullables.kt");
        }

        @Test
        @TestMetadata("nullToGeneric.kt")
        public void testNullToGeneric() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/nullToGeneric.kt");
        }

        @Test
        @TestMetadata("smartCastRefinedClass.kt")
        public void testSmartCastRefinedClass() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/smartCastRefinedClass.kt");
        }

        @Test
        @TestMetadata("smartCasts.kt")
        public void testSmartCasts() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/smartCasts.kt");
        }

        @Test
        @TestMetadata("smartCastsOnThis.kt")
        public void testSmartCastsOnThis() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/smartCastsOnThis.kt");
        }

        @Test
        @TestMetadata("smartCastsValueArgument.kt")
        public void testSmartCastsValueArgument() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/smartCastsValueArgument.kt");
        }

        @Test
        @TestMetadata("tpBoundsViolation.kt")
        public void testTpBoundsViolation() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/tpBoundsViolation.kt");
        }

        @Test
        @TestMetadata("tpBoundsViolationVariance.kt")
        public void testTpBoundsViolationVariance() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/tpBoundsViolationVariance.kt");
        }

        @Test
        @TestMetadata("tpInBounds.kt")
        public void testTpInBounds() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/tpInBounds.kt");
        }

        @Test
        @TestMetadata("useAsReceiver.kt")
        public void testUseAsReceiver() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/useAsReceiver.kt");
        }

        @Test
        @TestMetadata("useAsValueArgument.kt")
        public void testUseAsValueArgument() {
          runTest("compiler/testData/diagnostics/tests/generics/nullability/useAsValueArgument.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope")
      @TestDataPath("$PROJECT_ROOT")
      public class ProjectionsScope {
        @Test
        @TestMetadata("addAll.kt")
        public void testAddAll() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/addAll.kt");
        }

        @Test
        public void testAllFilesPresentInProjectionsScope() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/projectionsScope"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("approximateDispatchReceiver.kt")
        public void testApproximateDispatchReceiver() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/approximateDispatchReceiver.kt");
        }

        @Test
        @TestMetadata("extensionReceiverTypeMismatch.kt")
        public void testExtensionReceiverTypeMismatch() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/extensionReceiverTypeMismatch.kt");
        }

        @Test
        @TestMetadata("extensionResultSubstitution.kt")
        public void testExtensionResultSubstitution() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/extensionResultSubstitution.kt");
        }

        @Test
        @TestMetadata("flexibleProjectedScope.kt")
        public void testFlexibleProjectedScope() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/flexibleProjectedScope.kt");
        }

        @Test
        @TestMetadata("inValueParameter.kt")
        public void testInValueParameter() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/inValueParameter.kt");
        }

        @Test
        @TestMetadata("iterateOnExtension.kt")
        public void testIterateOnExtension() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/iterateOnExtension.kt");
        }

        @Test
        @TestMetadata("kt7296.kt")
        public void testKt7296() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/kt7296.kt");
        }

        @Test
        @TestMetadata("kt8647.kt")
        public void testKt8647() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/kt8647.kt");
        }

        @Test
        @TestMetadata("lambdaArgument.kt")
        public void testLambdaArgument() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/lambdaArgument.kt");
        }

        @Test
        @TestMetadata("leakedApproximatedType.kt")
        public void testLeakedApproximatedType() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/leakedApproximatedType.kt");
        }

        @Test
        @TestMetadata("MLOut.kt")
        public void testMLOut() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/MLOut.kt");
        }

        @Test
        @TestMetadata("multipleArgumentProjectedOut.kt")
        public void testMultipleArgumentProjectedOut() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/multipleArgumentProjectedOut.kt");
        }

        @Test
        @TestMetadata("platformSuperClass.kt")
        public void testPlatformSuperClass() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/platformSuperClass.kt");
        }

        @Test
        @TestMetadata("projectedOutConventions.kt")
        public void testProjectedOutConventions() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/projectedOutConventions.kt");
        }

        @Test
        @TestMetadata("projectedOutSmartCast.kt")
        public void testProjectedOutSmartCast() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/projectedOutSmartCast.kt");
        }

        @Test
        @TestMetadata("recursiveUpperBoundStar.kt")
        public void testRecursiveUpperBoundStar() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/recursiveUpperBoundStar.kt");
        }

        @Test
        @TestMetadata("recursiveUpperBoundStarOut.kt")
        public void testRecursiveUpperBoundStarOut() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/recursiveUpperBoundStarOut.kt");
        }

        @Test
        @TestMetadata("starNullability.kt")
        public void testStarNullability() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/starNullability.kt");
        }

        @Test
        @TestMetadata("starNullabilityRecursive.kt")
        public void testStarNullabilityRecursive() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/starNullabilityRecursive.kt");
        }

        @Test
        @TestMetadata("superClass.kt")
        public void testSuperClass() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/superClass.kt");
        }

        @Test
        @TestMetadata("typeMismatchConventions.kt")
        public void testTypeMismatchConventions() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/typeMismatchConventions.kt");
        }

        @Test
        @TestMetadata("typeMismatchInLambda.kt")
        public void testTypeMismatchInLambda() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/typeMismatchInLambda.kt");
        }

        @Test
        @TestMetadata("typeParameterBounds.kt")
        public void testTypeParameterBounds() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/typeParameterBounds.kt");
        }

        @Test
        @TestMetadata("unsafeVarianceInAliasedFunctionalType.kt")
        public void testUnsafeVarianceInAliasedFunctionalType() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/unsafeVarianceInAliasedFunctionalType.kt");
        }

        @Test
        @TestMetadata("unsafeVarianceOnInputTypeOfFunctionalType.kt")
        public void testUnsafeVarianceOnInputTypeOfFunctionalType() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/unsafeVarianceOnInputTypeOfFunctionalType.kt");
        }

        @Test
        @TestMetadata("unsafeVarianceStar.kt")
        public void testUnsafeVarianceStar() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/unsafeVarianceStar.kt");
        }

        @Test
        @TestMetadata("unsafeVarianceWithRecursiveGenerics.kt")
        public void testUnsafeVarianceWithRecursiveGenerics() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/unsafeVarianceWithRecursiveGenerics.kt");
        }

        @Test
        @TestMetadata("varargs.kt")
        public void testVarargs() {
          runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/varargs.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/generics/starProjections")
      @TestDataPath("$PROJECT_ROOT")
      public class StarProjections {
        @Test
        public void testAllFilesPresentInStarProjections() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/starProjections"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("checkBounds.kt")
        public void testCheckBounds() {
          runTest("compiler/testData/diagnostics/tests/generics/starProjections/checkBounds.kt");
        }

        @Test
        @TestMetadata("collectionInheritedFromJava.kt")
        public void testCollectionInheritedFromJava() {
          runTest("compiler/testData/diagnostics/tests/generics/starProjections/collectionInheritedFromJava.kt");
        }

        @Test
        @TestMetadata("foldRecursiveTypesToStarProjection.kt")
        public void testFoldRecursiveTypesToStarProjection() {
          runTest("compiler/testData/diagnostics/tests/generics/starProjections/foldRecursiveTypesToStarProjection.kt");
        }

        @Test
        @TestMetadata("inheritedFromJava.kt")
        public void testInheritedFromJava() {
          runTest("compiler/testData/diagnostics/tests/generics/starProjections/inheritedFromJava.kt");
        }

        @Test
        @TestMetadata("inheritedFromKotlin.kt")
        public void testInheritedFromKotlin() {
          runTest("compiler/testData/diagnostics/tests/generics/starProjections/inheritedFromKotlin.kt");
        }

        @Test
        @TestMetadata("invalid.kt")
        public void testInvalid() {
          runTest("compiler/testData/diagnostics/tests/generics/starProjections/invalid.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified")
      @TestDataPath("$PROJECT_ROOT")
      public class TpAsReified {
        @Test
        public void testAllFilesPresentInTpAsReified() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/tpAsReified"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("CapturedAsReified.kt")
        public void testCapturedAsReified() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/CapturedAsReified.kt");
        }

        @Test
        @TestMetadata("ClassDereference.kt")
        public void testClassDereference() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/ClassDereference.kt");
        }

        @Test
        @TestMetadata("Conventions.kt")
        public void testConventions() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/Conventions.kt");
        }

        @Test
        @TestMetadata("GenericArrayAsReifiedArgument.kt")
        public void testGenericArrayAsReifiedArgument() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/GenericArrayAsReifiedArgument.kt");
        }

        @Test
        @TestMetadata("GenericAsReifiedArgument.kt")
        public void testGenericAsReifiedArgument() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/GenericAsReifiedArgument.kt");
        }

        @Test
        @TestMetadata("InConstructor.kt")
        public void testInConstructor() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InConstructor.kt");
        }

        @Test
        @TestMetadata("InFunction.kt")
        public void testInFunction() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InFunction.kt");
        }

        @Test
        @TestMetadata("InProperty.kt")
        public void testInProperty() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InProperty.kt");
        }

        @Test
        @TestMetadata("InType.kt")
        public void testInType() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InType.kt");
        }

        @Test
        @TestMetadata("InlineableReified.kt")
        public void testInlineableReified() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InlineableReified.kt");
        }

        @Test
        @TestMetadata("LocalFun.kt")
        public void testLocalFun() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/LocalFun.kt");
        }

        @Test
        @TestMetadata("NotInlineableReified.kt")
        public void testNotInlineableReified() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/NotInlineableReified.kt");
        }

        @Test
        @TestMetadata("ReifiedClass.kt")
        public void testReifiedClass() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/ReifiedClass.kt");
        }

        @Test
        @TestMetadata("ReifiedTypeAliasDisabled.kt")
        public void testReifiedTypeAliasDisabled() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/ReifiedTypeAliasDisabled.kt");
        }

        @Test
        @TestMetadata("ReifiedTypeAliasEnabled.kt")
        public void testReifiedTypeAliasEnabled() {
          runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/ReifiedTypeAliasEnabled.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/generics/varProjection")
      @TestDataPath("$PROJECT_ROOT")
      public class VarProjection {
        @Test
        public void testAllFilesPresentInVarProjection() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/varProjection"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("setterNotProjectedOutAssign.kt")
        public void testSetterNotProjectedOutAssign() {
          runTest("compiler/testData/diagnostics/tests/generics/varProjection/setterNotProjectedOutAssign.kt");
        }

        @Test
        @TestMetadata("setterProjectedOutAssign.kt")
        public void testSetterProjectedOutAssign() {
          runTest("compiler/testData/diagnostics/tests/generics/varProjection/setterProjectedOutAssign.kt");
        }

        @Test
        @TestMetadata("setterProjectedOutNoPlusAssign.kt")
        public void testSetterProjectedOutNoPlusAssign() {
          runTest("compiler/testData/diagnostics/tests/generics/varProjection/setterProjectedOutNoPlusAssign.kt");
        }

        @Test
        @TestMetadata("setterProjectedOutPlusAssignDefined.kt")
        public void testSetterProjectedOutPlusAssignDefined() {
          runTest("compiler/testData/diagnostics/tests/generics/varProjection/setterProjectedOutPlusAssignDefined.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/imports")
    @TestDataPath("$PROJECT_ROOT")
    public class Imports {
      @Test
      @TestMetadata("aliasedImportOfEnumConstructor.kt")
      public void testAliasedImportOfEnumConstructor() {
        runTest("compiler/testData/diagnostics/tests/imports/aliasedImportOfEnumConstructor.kt");
      }

      @Test
      public void testAllFilesPresentInImports() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/imports"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("AllUnderImportsAmbiguity.kt")
      public void testAllUnderImportsAmbiguity() {
        runTest("compiler/testData/diagnostics/tests/imports/AllUnderImportsAmbiguity.kt");
      }

      @Test
      @TestMetadata("AllUnderImportsLessPriority.kt")
      public void testAllUnderImportsLessPriority() {
        runTest("compiler/testData/diagnostics/tests/imports/AllUnderImportsLessPriority.kt");
      }

      @Test
      @TestMetadata("AllUnderImportsSamePriorityForFunction.kt")
      public void testAllUnderImportsSamePriorityForFunction() {
        runTest("compiler/testData/diagnostics/tests/imports/AllUnderImportsSamePriorityForFunction.kt");
      }

      @Test
      @TestMetadata("AllUnderImportsSamePriorityForProperty.kt")
      public void testAllUnderImportsSamePriorityForProperty() {
        runTest("compiler/testData/diagnostics/tests/imports/AllUnderImportsSamePriorityForProperty.kt");
      }

      @Test
      @TestMetadata("brokenImport.kt")
      public void testBrokenImport() {
        runTest("compiler/testData/diagnostics/tests/imports/brokenImport.kt");
      }

      @Test
      @TestMetadata("CheckJavaVisibility.kt")
      public void testCheckJavaVisibility() {
        runTest("compiler/testData/diagnostics/tests/imports/CheckJavaVisibility.kt");
      }

      @Test
      @TestMetadata("CheckJavaVisibility2.kt")
      public void testCheckJavaVisibility2() {
        runTest("compiler/testData/diagnostics/tests/imports/CheckJavaVisibility2.kt");
      }

      @Test
      @TestMetadata("CheckVisibility_differentModule.kt")
      public void testCheckVisibility_differentModule() {
        runTest("compiler/testData/diagnostics/tests/imports/CheckVisibility_differentModule.kt");
      }

      @Test
      @TestMetadata("CheckVisibility_sameModule.kt")
      public void testCheckVisibility_sameModule() {
        runTest("compiler/testData/diagnostics/tests/imports/CheckVisibility_sameModule.kt");
      }

      @Test
      @TestMetadata("ClassClash.kt")
      public void testClassClash() {
        runTest("compiler/testData/diagnostics/tests/imports/ClassClash.kt");
      }

      @Test
      @TestMetadata("ClassClashStarImport.kt")
      public void testClassClashStarImport() {
        runTest("compiler/testData/diagnostics/tests/imports/ClassClashStarImport.kt");
      }

      @Test
      @TestMetadata("ClassClashStarImport_topLevel.kt")
      public void testClassClashStarImport_topLevel() {
        runTest("compiler/testData/diagnostics/tests/imports/ClassClashStarImport_topLevel.kt");
      }

      @Test
      @TestMetadata("ClassClash_topLevel.kt")
      public void testClassClash_topLevel() {
        runTest("compiler/testData/diagnostics/tests/imports/ClassClash_topLevel.kt");
      }

      @Test
      @TestMetadata("ClassImportsConflicting.kt")
      public void testClassImportsConflicting() {
        runTest("compiler/testData/diagnostics/tests/imports/ClassImportsConflicting.kt");
      }

      @Test
      @TestMetadata("CurrentPackageAndAllUnderImport.kt")
      public void testCurrentPackageAndAllUnderImport() {
        runTest("compiler/testData/diagnostics/tests/imports/CurrentPackageAndAllUnderImport.kt");
      }

      @Test
      @TestMetadata("CurrentPackageAndExplicitImport.kt")
      public void testCurrentPackageAndExplicitImport() {
        runTest("compiler/testData/diagnostics/tests/imports/CurrentPackageAndExplicitImport.kt");
      }

      @Test
      @TestMetadata("DefaultImportsPriority.kt")
      public void testDefaultImportsPriority() {
        runTest("compiler/testData/diagnostics/tests/imports/DefaultImportsPriority.kt");
      }

      @Test
      @TestMetadata("DoubleImports.kt")
      public void testDoubleImports() {
        runTest("compiler/testData/diagnostics/tests/imports/DoubleImports.kt");
      }

      @Test
      @TestMetadata("EnumEntryVsStaticAmbiguity.kt")
      public void testEnumEntryVsStaticAmbiguity() {
        runTest("compiler/testData/diagnostics/tests/imports/EnumEntryVsStaticAmbiguity.kt");
      }

      @Test
      @TestMetadata("EnumEntryVsStaticAmbiguity2.kt")
      public void testEnumEntryVsStaticAmbiguity2() {
        runTest("compiler/testData/diagnostics/tests/imports/EnumEntryVsStaticAmbiguity2.kt");
      }

      @Test
      @TestMetadata("EnumEntryVsStaticAmbiguity3.kt")
      public void testEnumEntryVsStaticAmbiguity3() {
        runTest("compiler/testData/diagnostics/tests/imports/EnumEntryVsStaticAmbiguity3.kt");
      }

      @Test
      @TestMetadata("EnumEntryVsStaticAmbiguity4.kt")
      public void testEnumEntryVsStaticAmbiguity4() {
        runTest("compiler/testData/diagnostics/tests/imports/EnumEntryVsStaticAmbiguity4.kt");
      }

      @Test
      @TestMetadata("ExplicitImportsAmbiguity.kt")
      public void testExplicitImportsAmbiguity() {
        runTest("compiler/testData/diagnostics/tests/imports/ExplicitImportsAmbiguity.kt");
      }

      @Test
      @TestMetadata("ExplicitImportsUnambiguityForFunction.kt")
      public void testExplicitImportsUnambiguityForFunction() {
        runTest("compiler/testData/diagnostics/tests/imports/ExplicitImportsUnambiguityForFunction.kt");
      }

      @Test
      @TestMetadata("ExplicitPackageImportsAmbiguity.kt")
      public void testExplicitPackageImportsAmbiguity() {
        runTest("compiler/testData/diagnostics/tests/imports/ExplicitPackageImportsAmbiguity.kt");
      }

      @Test
      @TestMetadata("ImportClassClash.kt")
      public void testImportClassClash() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportClassClash.kt");
      }

      @Test
      @TestMetadata("ImportFromCompanionObject.kt")
      public void testImportFromCompanionObject() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportFromCompanionObject.kt");
      }

      @Test
      @TestMetadata("ImportFromCurrentWithDifferentName.kt")
      public void testImportFromCurrentWithDifferentName() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportFromCurrentWithDifferentName.kt");
      }

      @Test
      @TestMetadata("ImportFromCurrentWithDifferentNameComplex.kt")
      public void testImportFromCurrentWithDifferentNameComplex() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportFromCurrentWithDifferentNameComplex.kt");
      }

      @Test
      @TestMetadata("ImportFromObject.kt")
      public void testImportFromObject() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportFromObject.kt");
      }

      @Test
      @TestMetadata("importFunctionWithAllUnderImport.kt")
      public void testImportFunctionWithAllUnderImport() {
        runTest("compiler/testData/diagnostics/tests/imports/importFunctionWithAllUnderImport.kt");
      }

      @Test
      @TestMetadata("importFunctionWithAllUnderImportAfterNamedImport.kt")
      public void testImportFunctionWithAllUnderImportAfterNamedImport() {
        runTest("compiler/testData/diagnostics/tests/imports/importFunctionWithAllUnderImportAfterNamedImport.kt");
      }

      @Test
      @TestMetadata("ImportFunctionWithPackageName.kt")
      public void testImportFunctionWithPackageName() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportFunctionWithPackageName.kt");
      }

      @Test
      @TestMetadata("ImportHidingDefinitionInTheSameFile.kt")
      public void testImportHidingDefinitionInTheSameFile() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportHidingDefinitionInTheSameFile.kt");
      }

      @Test
      @TestMetadata("ImportNestedWithDifferentName.kt")
      public void testImportNestedWithDifferentName() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportNestedWithDifferentName.kt");
      }

      @Test
      @TestMetadata("ImportObjectAndUseAsSupertype.kt")
      public void testImportObjectAndUseAsSupertype() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportObjectAndUseAsSupertype.kt");
      }

      @Test
      @TestMetadata("ImportObjectHidesCurrentPackage.kt")
      public void testImportObjectHidesCurrentPackage() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportObjectHidesCurrentPackage.kt");
      }

      @Test
      @TestMetadata("ImportOverloadFunctions.kt")
      public void testImportOverloadFunctions() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportOverloadFunctions.kt");
      }

      @Test
      @TestMetadata("ImportPrivateMember.kt")
      public void testImportPrivateMember() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportPrivateMember.kt");
      }

      @Test
      @TestMetadata("ImportPrivateMemberFromOtherFile.kt")
      public void testImportPrivateMemberFromOtherFile() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportPrivateMemberFromOtherFile.kt");
      }

      @Test
      @TestMetadata("ImportPrivateMembersWithStar.kt")
      public void testImportPrivateMembersWithStar() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportPrivateMembersWithStar.kt");
      }

      @Test
      @TestMetadata("ImportProtectedClass.kt")
      public void testImportProtectedClass() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportProtectedClass.kt");
      }

      @Test
      @TestMetadata("ImportResolutionOrder.kt")
      public void testImportResolutionOrder() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportResolutionOrder.kt");
      }

      @Test
      @TestMetadata("ImportStaticFunctionWithNonStaticSibling.kt")
      public void testImportStaticFunctionWithNonStaticSibling() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportStaticFunctionWithNonStaticSibling.kt");
      }

      @Test
      @TestMetadata("ImportTwoTimes.kt")
      public void testImportTwoTimes() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportTwoTimes.kt");
      }

      @Test
      @TestMetadata("ImportTwoTimesStar.kt")
      public void testImportTwoTimesStar() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportTwoTimesStar.kt");
      }

      @Test
      @TestMetadata("Imports.kt")
      public void testImports() {
        runTest("compiler/testData/diagnostics/tests/imports/Imports.kt");
      }

      @Test
      @TestMetadata("ImportsConflicting.kt")
      public void testImportsConflicting() {
        runTest("compiler/testData/diagnostics/tests/imports/ImportsConflicting.kt");
      }

      @Test
      @TestMetadata("InaccessiblePrivateClass.kt")
      public void testInaccessiblePrivateClass() {
        runTest("compiler/testData/diagnostics/tests/imports/InaccessiblePrivateClass.kt");
      }

      @Test
      @TestMetadata("InaccessiblePrivateInFile.kt")
      public void testInaccessiblePrivateInFile() {
        runTest("compiler/testData/diagnostics/tests/imports/InaccessiblePrivateInFile.kt");
      }

      @Test
      @TestMetadata("invisibleFakeReferenceInImport.kt")
      public void testInvisibleFakeReferenceInImport() {
        runTest("compiler/testData/diagnostics/tests/imports/invisibleFakeReferenceInImport.kt");
      }

      @Test
      @TestMetadata("JavaPackageLocalClassNotImported.kt")
      public void testJavaPackageLocalClassNotImported() {
        runTest("compiler/testData/diagnostics/tests/imports/JavaPackageLocalClassNotImported.kt");
      }

      @Test
      @TestMetadata("kt13112.kt")
      public void testKt13112() {
        runTest("compiler/testData/diagnostics/tests/imports/kt13112.kt");
      }

      @Test
      @TestMetadata("MalformedImports.kt")
      public void testMalformedImports() {
        runTest("compiler/testData/diagnostics/tests/imports/MalformedImports.kt");
      }

      @Test
      @TestMetadata("NestedClassClash.kt")
      public void testNestedClassClash() {
        runTest("compiler/testData/diagnostics/tests/imports/NestedClassClash.kt");
      }

      @Test
      @TestMetadata("OperatorRenameOnImport.kt")
      public void testOperatorRenameOnImport() {
        runTest("compiler/testData/diagnostics/tests/imports/OperatorRenameOnImport.kt");
      }

      @Test
      @TestMetadata("OptionalAnnotationClasses.kt")
      public void testOptionalAnnotationClasses() {
        runTest("compiler/testData/diagnostics/tests/imports/OptionalAnnotationClasses.kt");
      }

      @Test
      @TestMetadata("PackageLocalClassNotImported.kt")
      public void testPackageLocalClassNotImported() {
        runTest("compiler/testData/diagnostics/tests/imports/PackageLocalClassNotImported.kt");
      }

      @Test
      @TestMetadata("PackageLocalClassReferencedError.kt")
      public void testPackageLocalClassReferencedError() {
        runTest("compiler/testData/diagnostics/tests/imports/PackageLocalClassReferencedError.kt");
      }

      @Test
      @TestMetadata("PackageVsClass.kt")
      public void testPackageVsClass() {
        runTest("compiler/testData/diagnostics/tests/imports/PackageVsClass.kt");
      }

      @Test
      @TestMetadata("PrivateClassNotImported.kt")
      public void testPrivateClassNotImported() {
        runTest("compiler/testData/diagnostics/tests/imports/PrivateClassNotImported.kt");
      }

      @Test
      @TestMetadata("PrivateClassReferencedError.kt")
      public void testPrivateClassReferencedError() {
        runTest("compiler/testData/diagnostics/tests/imports/PrivateClassReferencedError.kt");
      }

      @Test
      @TestMetadata("propertyClassFileDependencyRecursion.kt")
      public void testPropertyClassFileDependencyRecursion() {
        runTest("compiler/testData/diagnostics/tests/imports/propertyClassFileDependencyRecursion.kt");
      }

      @Test
      @TestMetadata("RenameOnImport.kt")
      public void testRenameOnImport() {
        runTest("compiler/testData/diagnostics/tests/imports/RenameOnImport.kt");
      }

      @Test
      @TestMetadata("renamedImportInDifferentFile.kt")
      public void testRenamedImportInDifferentFile() {
        runTest("compiler/testData/diagnostics/tests/imports/renamedImportInDifferentFile.kt");
      }

      @Test
      @TestMetadata("RootPackage.kt")
      public void testRootPackage() {
        runTest("compiler/testData/diagnostics/tests/imports/RootPackage.kt");
      }

      @Test
      @TestMetadata("RootPackageImportsA.kt")
      public void testRootPackageImportsA() {
        runTest("compiler/testData/diagnostics/tests/imports/RootPackageImportsA.kt");
      }

      @Test
      @TestMetadata("RootPackageImportsB.kt")
      public void testRootPackageImportsB() {
        runTest("compiler/testData/diagnostics/tests/imports/RootPackageImportsB.kt");
      }

      @Test
      @TestMetadata("RootPackageNoImports_differentModule.kt")
      public void testRootPackageNoImports_differentModule() {
        runTest("compiler/testData/diagnostics/tests/imports/RootPackageNoImports_differentModule.kt");
      }

      @Test
      @TestMetadata("RootPackageNoImports_sameModule.kt")
      public void testRootPackageNoImports_sameModule() {
        runTest("compiler/testData/diagnostics/tests/imports/RootPackageNoImports_sameModule.kt");
      }

      @Test
      @TestMetadata("StarImportFromObject.kt")
      public void testStarImportFromObject() {
        runTest("compiler/testData/diagnostics/tests/imports/StarImportFromObject.kt");
      }

      @Test
      @TestMetadata("SyntaxError.kt")
      public void testSyntaxError() {
        runTest("compiler/testData/diagnostics/tests/imports/SyntaxError.kt");
      }

      @Test
      @TestMetadata("TopLevelClassVsPackage.kt")
      public void testTopLevelClassVsPackage() {
        runTest("compiler/testData/diagnostics/tests/imports/TopLevelClassVsPackage.kt");
      }

      @Test
      @TestMetadata("twoImportLists.kt")
      public void testTwoImportLists() {
        runTest("compiler/testData/diagnostics/tests/imports/twoImportLists.kt");
      }

      @Test
      @TestMetadata("WrongImport.kt")
      public void testWrongImport() {
        runTest("compiler/testData/diagnostics/tests/imports/WrongImport.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/incompleteCode")
    @TestDataPath("$PROJECT_ROOT")
    public class IncompleteCode {
      @Test
      public void testAllFilesPresentInIncompleteCode() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/incompleteCode"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("arrayBracketsRange.kt")
      public void testArrayBracketsRange() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/arrayBracketsRange.kt");
      }

      @Test
      @TestMetadata("checkNothingIsSubtype.kt")
      public void testCheckNothingIsSubtype() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/checkNothingIsSubtype.kt");
      }

      @Test
      @TestMetadata("controlStructuresErrors.kt")
      public void testControlStructuresErrors() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/controlStructuresErrors.kt");
      }

      @Test
      @TestMetadata("illegalSelectorCallableReference.kt")
      public void testIllegalSelectorCallableReference() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/illegalSelectorCallableReference.kt");
      }

      @Test
      @TestMetadata("inExpr.kt")
      public void testInExpr() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/inExpr.kt");
      }

      @Test
      @TestMetadata("incompleteAssignment.kt")
      public void testIncompleteAssignment() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/incompleteAssignment.kt");
      }

      @Test
      @TestMetadata("incompleteConstructorCall.kt")
      public void testIncompleteConstructorCall() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/incompleteConstructorCall.kt");
      }

      @Test
      @TestMetadata("incompleteEquals.kt")
      public void testIncompleteEquals() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/incompleteEquals.kt");
      }

      @Test
      @TestMetadata("incompleteTryCatchBlock.kt")
      public void testIncompleteTryCatchBlock() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/incompleteTryCatchBlock.kt");
      }

      @Test
      @TestMetadata("kt1955.kt")
      public void testKt1955() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/kt1955.kt");
      }

      @Test
      @TestMetadata("kt2014.kt")
      public void testKt2014() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/kt2014.kt");
      }

      @Test
      @TestMetadata("kt4866UnresolvedArrayAccess.kt")
      public void testKt4866UnresolvedArrayAccess() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/kt4866UnresolvedArrayAccess.kt");
      }

      @Test
      @TestMetadata("kt59041.kt")
      public void testKt59041() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/kt59041.kt");
      }

      @Test
      @TestMetadata("missingNames.kt")
      public void testMissingNames() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/missingNames.kt");
      }

      @Test
      @TestMetadata("NoSenselessComparisonForErrorType.kt")
      public void testNoSenselessComparisonForErrorType() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/NoSenselessComparisonForErrorType.kt");
      }

      @Test
      @TestMetadata("plusOnTheRight.kt")
      public void testPlusOnTheRight() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/plusOnTheRight.kt");
      }

      @Test
      @TestMetadata("pseudocodeTraverseNextInstructions.kt")
      public void testPseudocodeTraverseNextInstructions() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/pseudocodeTraverseNextInstructions.kt");
      }

      @Test
      @TestMetadata("senselessComparisonWithNull.kt")
      public void testSenselessComparisonWithNull() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/senselessComparisonWithNull.kt");
      }

      @Test
      @TestMetadata("SupertypeOfErrorType.kt")
      public void testSupertypeOfErrorType() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/SupertypeOfErrorType.kt");
      }

      @Test
      @TestMetadata("typeParameterOnLhsOfDot.kt")
      public void testTypeParameterOnLhsOfDot() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/typeParameterOnLhsOfDot.kt");
      }

      @Test
      @TestMetadata("unresolvedArguments.kt")
      public void testUnresolvedArguments() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/unresolvedArguments.kt");
      }

      @Test
      @TestMetadata("unresolvedOperation.kt")
      public void testUnresolvedOperation() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/unresolvedOperation.kt");
      }

      @Test
      @TestMetadata("unresolvedTypeWithTypeArguments.kt")
      public void testUnresolvedTypeWithTypeArguments() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/unresolvedTypeWithTypeArguments.kt");
      }

      @Test
      @TestMetadata("variableDeclarationInSelector.kt")
      public void testVariableDeclarationInSelector() {
        runTest("compiler/testData/diagnostics/tests/incompleteCode/variableDeclarationInSelector.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError")
      @TestDataPath("$PROJECT_ROOT")
      public class DiagnosticWithSyntaxError {
        @Test
        public void testAllFilesPresentInDiagnosticWithSyntaxError() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("arrayExpression.kt")
        public void testArrayExpression() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/arrayExpression.kt");
        }

        @Test
        @TestMetadata("checkBackingFieldException.kt")
        public void testCheckBackingFieldException() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/checkBackingFieldException.kt");
        }

        @Test
        @TestMetadata("completeFunctionArgumentsOfNestedCalls.kt")
        public void testCompleteFunctionArgumentsOfNestedCalls() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/completeFunctionArgumentsOfNestedCalls.kt");
        }

        @Test
        @TestMetadata("declarationAfterDotSelectorExpected.kt")
        public void testDeclarationAfterDotSelectorExpected() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/declarationAfterDotSelectorExpected.kt");
        }

        @Test
        @TestMetadata("declarationAfterIncompleteElvis.kt")
        public void testDeclarationAfterIncompleteElvis() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/declarationAfterIncompleteElvis.kt");
        }

        @Test
        @TestMetadata("funEquals.kt")
        public void testFunEquals() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/funEquals.kt");
        }

        @Test
        @TestMetadata("funKeyword.kt")
        public void testFunKeyword() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/funKeyword.kt");
        }

        @Test
        @TestMetadata("funcitonTypes.kt")
        public void testFuncitonTypes() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/funcitonTypes.kt");
        }

        @Test
        @TestMetadata("incompleteEnumReference.kt")
        public void testIncompleteEnumReference() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteEnumReference.kt");
        }

        @Test
        @TestMetadata("incompleteVal.kt")
        public void testIncompleteVal() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteVal.kt");
        }

        @Test
        @TestMetadata("incompleteValWithAccessor.kt")
        public void testIncompleteValWithAccessor() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteValWithAccessor.kt");
        }

        @Test
        @TestMetadata("incompleteWhen.kt")
        public void testIncompleteWhen() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteWhen.kt");
        }

        @Test
        @TestMetadata("namedFun.kt")
        public void testNamedFun() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/namedFun.kt");
        }

        @Test
        @TestMetadata("noTypeParamsInReturnType.kt")
        public void testNoTypeParamsInReturnType() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/noTypeParamsInReturnType.kt");
        }

        @Test
        @TestMetadata("typeReferenceError.kt")
        public void testTypeReferenceError() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/typeReferenceError.kt");
        }

        @Test
        @TestMetadata("valNoName.kt")
        public void testValNoName() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/valNoName.kt");
        }

        @Test
        @TestMetadata("valWithNoNameBeforeNextDeclarationWithModifiers.kt")
        public void testValWithNoNameBeforeNextDeclarationWithModifiers() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/valWithNoNameBeforeNextDeclarationWithModifiers.kt");
        }

        @Test
        @TestMetadata("valWithNoNameInBlock.kt")
        public void testValWithNoNameInBlock() {
          runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/valWithNoNameInBlock.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/inference")
    @TestDataPath("$PROJECT_ROOT")
    public class Inference {
      @Test
      public void testAllFilesPresentInInference() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("annotatedUnderscoredTypeArgument.kt")
      public void testAnnotatedUnderscoredTypeArgument() {
        runTest("compiler/testData/diagnostics/tests/inference/annotatedUnderscoredTypeArgument.kt");
      }

      @Test
      @TestMetadata("assertThatInNumerousIf.kt")
      public void testAssertThatInNumerousIf() {
        runTest("compiler/testData/diagnostics/tests/inference/assertThatInNumerousIf.kt");
      }

      @Test
      @TestMetadata("cannotCompleteResolveAmbiguity.kt")
      public void testCannotCompleteResolveAmbiguity() {
        runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveAmbiguity.kt");
      }

      @Test
      @TestMetadata("cannotCompleteResolveFunctionLiteralsNoUse.kt")
      public void testCannotCompleteResolveFunctionLiteralsNoUse() {
        runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveFunctionLiteralsNoUse.kt");
      }

      @Test
      @TestMetadata("cannotCompleteResolveNoInfoForParameter.kt")
      public void testCannotCompleteResolveNoInfoForParameter() {
        runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveNoInfoForParameter.kt");
      }

      @Test
      @TestMetadata("cannotCompleteResolveNoneApplicable.kt")
      public void testCannotCompleteResolveNoneApplicable() {
        runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveNoneApplicable.kt");
      }

      @Test
      @TestMetadata("cannotCompleteResolveWithFunctionLiterals.kt")
      public void testCannotCompleteResolveWithFunctionLiterals() {
        runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveWithFunctionLiterals.kt");
      }

      @Test
      @TestMetadata("capturedInProjectedFlexibleType.kt")
      public void testCapturedInProjectedFlexibleType() {
        runTest("compiler/testData/diagnostics/tests/inference/capturedInProjectedFlexibleType.kt");
      }

      @Test
      @TestMetadata("capturedTypesInSelfType.kt")
      public void testCapturedTypesInSelfType() {
        runTest("compiler/testData/diagnostics/tests/inference/capturedTypesInSelfType.kt");
      }

      @Test
      @TestMetadata("checkNotNullWithNullableExpectedType.kt")
      public void testCheckNotNullWithNullableExpectedType() {
        runTest("compiler/testData/diagnostics/tests/inference/checkNotNullWithNullableExpectedType.kt");
      }

      @Test
      @TestMetadata("coerceFunctionLiteralToSuspend.kt")
      public void testCoerceFunctionLiteralToSuspend() {
        runTest("compiler/testData/diagnostics/tests/inference/coerceFunctionLiteralToSuspend.kt");
      }

      @Test
      @TestMetadata("commonSuperTypeOfErrorTypes.kt")
      public void testCommonSuperTypeOfErrorTypes() {
        runTest("compiler/testData/diagnostics/tests/inference/commonSuperTypeOfErrorTypes.kt");
      }

      @Test
      @TestMetadata("commonSuperTypeOfTypesWithErrorSupertypes.kt")
      public void testCommonSuperTypeOfTypesWithErrorSupertypes() {
        runTest("compiler/testData/diagnostics/tests/inference/commonSuperTypeOfTypesWithErrorSupertypes.kt");
      }

      @Test
      @TestMetadata("completeInferenceIfManyFailed.kt")
      public void testCompleteInferenceIfManyFailed() {
        runTest("compiler/testData/diagnostics/tests/inference/completeInferenceIfManyFailed.kt");
      }

      @Test
      @TestMetadata("completionOfMultipleLambdas.kt")
      public void testCompletionOfMultipleLambdas() {
        runTest("compiler/testData/diagnostics/tests/inference/completionOfMultipleLambdas.kt");
      }

      @Test
      @TestMetadata("complexInferenceOnParentizedExpression.kt")
      public void testComplexInferenceOnParentizedExpression() {
        runTest("compiler/testData/diagnostics/tests/inference/complexInferenceOnParentizedExpression.kt");
      }

      @Test
      @TestMetadata("conflictingSubstitutions.kt")
      public void testConflictingSubstitutions() {
        runTest("compiler/testData/diagnostics/tests/inference/conflictingSubstitutions.kt");
      }

      @Test
      @TestMetadata("crashWithNestedLambdasRedCode.kt")
      public void testCrashWithNestedLambdasRedCode() {
        runTest("compiler/testData/diagnostics/tests/inference/crashWithNestedLambdasRedCode.kt");
      }

      @Test
      @TestMetadata("cstFromErrorAndNonErrorTypes.kt")
      public void testCstFromErrorAndNonErrorTypes() {
        runTest("compiler/testData/diagnostics/tests/inference/cstFromErrorAndNonErrorTypes.kt");
      }

      @Test
      @TestMetadata("dependOnExpectedType.kt")
      public void testDependOnExpectedType() {
        runTest("compiler/testData/diagnostics/tests/inference/dependOnExpectedType.kt");
      }

      @Test
      @TestMetadata("dependantOnVariance.kt")
      public void testDependantOnVariance() {
        runTest("compiler/testData/diagnostics/tests/inference/dependantOnVariance.kt");
      }

      @Test
      @TestMetadata("dependantOnVarianceNullable.kt")
      public void testDependantOnVarianceNullable() {
        runTest("compiler/testData/diagnostics/tests/inference/dependantOnVarianceNullable.kt");
      }

      @Test
      @TestMetadata("discardInapplicableCandidateWithNotSatisfyingSelfType.kt")
      public void testDiscardInapplicableCandidateWithNotSatisfyingSelfType() {
        runTest("compiler/testData/diagnostics/tests/inference/discardInapplicableCandidateWithNotSatisfyingSelfType.kt");
      }

      @Test
      @TestMetadata("dnnArgumentInferred.kt")
      public void testDnnArgumentInferred() {
        runTest("compiler/testData/diagnostics/tests/inference/dnnArgumentInferred.kt");
      }

      @Test
      @TestMetadata("dontThrowEmptyIntersectionException.kt")
      public void testDontThrowEmptyIntersectionException() {
        runTest("compiler/testData/diagnostics/tests/inference/dontThrowEmptyIntersectionException.kt");
      }

      @Test
      @TestMetadata("elvisInsideWhen.kt")
      public void testElvisInsideWhen() {
        runTest("compiler/testData/diagnostics/tests/inference/elvisInsideWhen.kt");
      }

      @Test
      @TestMetadata("elvisWithNothingInRhs.kt")
      public void testElvisWithNothingInRhs() {
        runTest("compiler/testData/diagnostics/tests/inference/elvisWithNothingInRhs.kt");
      }

      @Test
      @TestMetadata("equalitySubstitutionInsideNonInvariantType.kt")
      public void testEqualitySubstitutionInsideNonInvariantType() {
        runTest("compiler/testData/diagnostics/tests/inference/equalitySubstitutionInsideNonInvariantType.kt");
      }

      @Test
      @TestMetadata("errorsOnImplicitInvokeInSimpleCall.kt")
      public void testErrorsOnImplicitInvokeInSimpleCall() {
        runTest("compiler/testData/diagnostics/tests/inference/errorsOnImplicitInvokeInSimpleCall.kt");
      }

      @Test
      @TestMetadata("exclExclInference.kt")
      public void testExclExclInference() {
        runTest("compiler/testData/diagnostics/tests/inference/exclExclInference.kt");
      }

      @Test
      @TestMetadata("expectedTypeAdditionalTest.kt")
      public void testExpectedTypeAdditionalTest() {
        runTest("compiler/testData/diagnostics/tests/inference/expectedTypeAdditionalTest.kt");
      }

      @Test
      @TestMetadata("expectedTypeDoubleReceiver.kt")
      public void testExpectedTypeDoubleReceiver() {
        runTest("compiler/testData/diagnostics/tests/inference/expectedTypeDoubleReceiver.kt");
      }

      @Test
      @TestMetadata("expectedTypeFromCast.kt")
      public void testExpectedTypeFromCast() {
        runTest("compiler/testData/diagnostics/tests/inference/expectedTypeFromCast.kt");
      }

      @Test
      @TestMetadata("expectedTypeFromCastComplexExpression.kt")
      public void testExpectedTypeFromCastComplexExpression() {
        runTest("compiler/testData/diagnostics/tests/inference/expectedTypeFromCastComplexExpression.kt");
      }

      @Test
      @TestMetadata("expectedTypeFromCastParenthesized.kt")
      public void testExpectedTypeFromCastParenthesized() {
        runTest("compiler/testData/diagnostics/tests/inference/expectedTypeFromCastParenthesized.kt");
      }

      @Test
      @TestMetadata("expectedTypeWithGenerics.kt")
      public void testExpectedTypeWithGenerics() {
        runTest("compiler/testData/diagnostics/tests/inference/expectedTypeWithGenerics.kt");
      }

      @Test
      @TestMetadata("expectedTypeWithGenericsSafeCalls.kt")
      public void testExpectedTypeWithGenericsSafeCalls() {
        runTest("compiler/testData/diagnostics/tests/inference/expectedTypeWithGenericsSafeCalls.kt");
      }

      @Test
      @TestMetadata("extensionLambdasAndArrow.kt")
      public void testExtensionLambdasAndArrow() {
        runTest("compiler/testData/diagnostics/tests/inference/extensionLambdasAndArrow.kt");
      }

      @Test
      @TestMetadata("findViewById.kt")
      public void testFindViewById() {
        runTest("compiler/testData/diagnostics/tests/inference/findViewById.kt");
      }

      @Test
      @TestMetadata("fixVariableToNothing.kt")
      public void testFixVariableToNothing() {
        runTest("compiler/testData/diagnostics/tests/inference/fixVariableToNothing.kt");
      }

      @Test
      @TestMetadata("fixationOrderForProperConstraints.kt")
      public void testFixationOrderForProperConstraints() {
        runTest("compiler/testData/diagnostics/tests/inference/fixationOrderForProperConstraints.kt");
      }

      @Test
      @TestMetadata("flexibleTypesAsUpperBound.kt")
      public void testFlexibleTypesAsUpperBound() {
        runTest("compiler/testData/diagnostics/tests/inference/flexibleTypesAsUpperBound.kt");
      }

      @Test
      @TestMetadata("functionPlaceholderError.kt")
      public void testFunctionPlaceholderError() {
        runTest("compiler/testData/diagnostics/tests/inference/functionPlaceholderError.kt");
      }

      @Test
      @TestMetadata("genericAssignmentOperator.kt")
      public void testGenericAssignmentOperator() {
        runTest("compiler/testData/diagnostics/tests/inference/genericAssignmentOperator.kt");
      }

      @Test
      @TestMetadata("genericCallInThrow.kt")
      public void testGenericCallInThrow() {
        runTest("compiler/testData/diagnostics/tests/inference/genericCallInThrow.kt");
      }

      @Test
      @TestMetadata("genericInvokeInCompanion.kt")
      public void testGenericInvokeInCompanion() {
        runTest("compiler/testData/diagnostics/tests/inference/genericInvokeInCompanion.kt");
      }

      @Test
      @TestMetadata("genericOnJavaWildcardBoundedByRaw.kt")
      public void testGenericOnJavaWildcardBoundedByRaw() {
        runTest("compiler/testData/diagnostics/tests/inference/genericOnJavaWildcardBoundedByRaw.kt");
      }

      @Test
      @TestMetadata("genericWithUnmatchedNullabilityDelegate.kt")
      public void testGenericWithUnmatchedNullabilityDelegate() {
        runTest("compiler/testData/diagnostics/tests/inference/genericWithUnmatchedNullabilityDelegate.kt");
      }

      @Test
      @TestMetadata("genericsWithUnmatchedNullabilityNested.kt")
      public void testGenericsWithUnmatchedNullabilityNested() {
        runTest("compiler/testData/diagnostics/tests/inference/genericsWithUnmatchedNullabilityNested.kt");
      }

      @Test
      @TestMetadata("hasErrorInConstrainingTypes.kt")
      public void testHasErrorInConstrainingTypes() {
        runTest("compiler/testData/diagnostics/tests/inference/hasErrorInConstrainingTypes.kt");
      }

      @Test
      @TestMetadata("ifWithDependentBranches.kt")
      public void testIfWithDependentBranches() {
        runTest("compiler/testData/diagnostics/tests/inference/ifWithDependentBranches.kt");
      }

      @Test
      @TestMetadata("illegalUnderscoredTypeArgument.kt")
      public void testIllegalUnderscoredTypeArgument() {
        runTest("compiler/testData/diagnostics/tests/inference/illegalUnderscoredTypeArgument.kt");
      }

      @Test
      @TestMetadata("immutableArrayList.kt")
      public void testImmutableArrayList() {
        runTest("compiler/testData/diagnostics/tests/inference/immutableArrayList.kt");
      }

      @Test
      @TestMetadata("implicitInvokeExtensionWithFunctionalArgument.kt")
      public void testImplicitInvokeExtensionWithFunctionalArgument() {
        runTest("compiler/testData/diagnostics/tests/inference/implicitInvokeExtensionWithFunctionalArgument.kt");
      }

      @Test
      @TestMetadata("implicitInvokeInCompanionObjectWithFunctionalArgument.kt")
      public void testImplicitInvokeInCompanionObjectWithFunctionalArgument() {
        runTest("compiler/testData/diagnostics/tests/inference/implicitInvokeInCompanionObjectWithFunctionalArgument.kt");
      }

      @Test
      @TestMetadata("implicitInvokeInObjectWithFunctionalArgument.kt")
      public void testImplicitInvokeInObjectWithFunctionalArgument() {
        runTest("compiler/testData/diagnostics/tests/inference/implicitInvokeInObjectWithFunctionalArgument.kt");
      }

      @Test
      @TestMetadata("implicitInvokeWithFunctionLiteralArgument.kt")
      public void testImplicitInvokeWithFunctionLiteralArgument() {
        runTest("compiler/testData/diagnostics/tests/inference/implicitInvokeWithFunctionLiteralArgument.kt");
      }

      @Test
      @TestMetadata("inferInFunctionLiterals.kt")
      public void testInferInFunctionLiterals() {
        runTest("compiler/testData/diagnostics/tests/inference/inferInFunctionLiterals.kt");
      }

      @Test
      @TestMetadata("inferInFunctionLiteralsWithReturn.kt")
      public void testInferInFunctionLiteralsWithReturn() {
        runTest("compiler/testData/diagnostics/tests/inference/inferInFunctionLiteralsWithReturn.kt");
      }

      @Test
      @TestMetadata("inferenceForkRegression.kt")
      public void testInferenceForkRegression() {
        runTest("compiler/testData/diagnostics/tests/inference/inferenceForkRegression.kt");
      }

      @Test
      @TestMetadata("inferenceForkRegressionSimple.kt")
      public void testInferenceForkRegressionSimple() {
        runTest("compiler/testData/diagnostics/tests/inference/inferenceForkRegressionSimple.kt");
      }

      @Test
      @TestMetadata("intersectionTypeMultipleBoundsAsReceiver.kt")
      public void testIntersectionTypeMultipleBoundsAsReceiver() {
        runTest("compiler/testData/diagnostics/tests/inference/intersectionTypeMultipleBoundsAsReceiver.kt");
      }

      @Test
      @TestMetadata("intersectionTypeOnWhenCall.kt")
      public void testIntersectionTypeOnWhenCall() {
        runTest("compiler/testData/diagnostics/tests/inference/intersectionTypeOnWhenCall.kt");
      }

      @Test
      @TestMetadata("intersectionTypesWithContravariantTypes.kt")
      public void testIntersectionTypesWithContravariantTypes() {
        runTest("compiler/testData/diagnostics/tests/inference/intersectionTypesWithContravariantTypes.kt");
      }

      @Test
      @TestMetadata("intersectionWithEnum.kt")
      public void testIntersectionWithEnum() {
        runTest("compiler/testData/diagnostics/tests/inference/intersectionWithEnum.kt");
      }

      @Test
      @TestMetadata("invokeLambdaAsFunction.kt")
      public void testInvokeLambdaAsFunction() {
        runTest("compiler/testData/diagnostics/tests/inference/invokeLambdaAsFunction.kt");
      }

      @Test
      @TestMetadata("knownTypeParameters.kt")
      public void testKnownTypeParameters() {
        runTest("compiler/testData/diagnostics/tests/inference/knownTypeParameters.kt");
      }

      @Test
      @TestMetadata("kt11963.kt")
      public void testKt11963() {
        runTest("compiler/testData/diagnostics/tests/inference/kt11963.kt");
      }

      @Test
      @TestMetadata("kt12399.kt")
      public void testKt12399() {
        runTest("compiler/testData/diagnostics/tests/inference/kt12399.kt");
      }

      @Test
      @TestMetadata("kt1293.kt")
      public void testKt1293() {
        runTest("compiler/testData/diagnostics/tests/inference/kt1293.kt");
      }

      @Test
      @TestMetadata("kt28598.kt")
      public void testKt28598() {
        runTest("compiler/testData/diagnostics/tests/inference/kt28598.kt");
      }

      @Test
      @TestMetadata("kt28654.kt")
      public void testKt28654() {
        runTest("compiler/testData/diagnostics/tests/inference/kt28654.kt");
      }

      @Test
      @TestMetadata("kt30405.kt")
      public void testKt30405() {
        runTest("compiler/testData/diagnostics/tests/inference/kt30405.kt");
      }

      @Test
      @TestMetadata("kt3184.kt")
      public void testKt3184() {
        runTest("compiler/testData/diagnostics/tests/inference/kt3184.kt");
      }

      @Test
      @TestMetadata("kt32196.kt")
      public void testKt32196() {
        runTest("compiler/testData/diagnostics/tests/inference/kt32196.kt");
      }

      @Test
      @TestMetadata("kt32415.kt")
      public void testKt32415() {
        runTest("compiler/testData/diagnostics/tests/inference/kt32415.kt");
      }

      @Test
      @TestMetadata("kt32434.kt")
      public void testKt32434() {
        runTest("compiler/testData/diagnostics/tests/inference/kt32434.kt");
      }

      @Test
      @TestMetadata("kt32462.kt")
      public void testKt32462() {
        runTest("compiler/testData/diagnostics/tests/inference/kt32462.kt");
      }

      @Test
      @TestMetadata("kt33263.kt")
      public void testKt33263() {
        runTest("compiler/testData/diagnostics/tests/inference/kt33263.kt");
      }

      @Test
      @TestMetadata("kt35702.kt")
      public void testKt35702() {
        runTest("compiler/testData/diagnostics/tests/inference/kt35702.kt");
      }

      @Test
      @TestMetadata("kt36044.kt")
      public void testKt36044() {
        runTest("compiler/testData/diagnostics/tests/inference/kt36044.kt");
      }

      @Test
      @TestMetadata("kt36819.kt")
      public void testKt36819() {
        runTest("compiler/testData/diagnostics/tests/inference/kt36819.kt");
      }

      @Test
      @TestMetadata("kt37853.kt")
      public void testKt37853() {
        runTest("compiler/testData/diagnostics/tests/inference/kt37853.kt");
      }

      @Test
      @TestMetadata("kt39220.kt")
      public void testKt39220() {
        runTest("compiler/testData/diagnostics/tests/inference/kt39220.kt");
      }

      @Test
      @TestMetadata("kt40396.kt")
      public void testKt40396() {
        runTest("compiler/testData/diagnostics/tests/inference/kt40396.kt");
      }

      @Test
      @TestMetadata("kt46515.kt")
      public void testKt46515() {
        runTest("compiler/testData/diagnostics/tests/inference/kt46515.kt");
      }

      @Test
      @TestMetadata("kt47316.kt")
      public void testKt47316() {
        runTest("compiler/testData/diagnostics/tests/inference/kt47316.kt");
      }

      @Test
      @TestMetadata("kt49658.kt")
      public void testKt49658() {
        runTest("compiler/testData/diagnostics/tests/inference/kt49658.kt");
      }

      @Test
      @TestMetadata("kt49658Strict.kt")
      public void testKt49658Strict() {
        runTest("compiler/testData/diagnostics/tests/inference/kt49658Strict.kt");
      }

      @Test
      @TestMetadata("kt49961.kt")
      public void testKt49961() {
        runTest("compiler/testData/diagnostics/tests/inference/kt49961.kt");
      }

      @Test
      @TestMetadata("kt50232a.kt")
      public void testKt50232a() {
        runTest("compiler/testData/diagnostics/tests/inference/kt50232a.kt");
      }

      @Test
      @TestMetadata("kt53124.kt")
      public void testKt53124() {
        runTest("compiler/testData/diagnostics/tests/inference/kt53124.kt");
      }

      @Test
      @TestMetadata("kt6175.kt")
      public void testKt6175() {
        runTest("compiler/testData/diagnostics/tests/inference/kt6175.kt");
      }

      @Test
      @TestMetadata("kt619.kt")
      public void testKt619() {
        runTest("compiler/testData/diagnostics/tests/inference/kt619.kt");
      }

      @Test
      @TestMetadata("kt62609.kt")
      public void testKt62609() {
        runTest("compiler/testData/diagnostics/tests/inference/kt62609.kt");
      }

      @Test
      @TestMetadata("kt63577.kt")
      public void testKt63577() {
        runTest("compiler/testData/diagnostics/tests/inference/kt63577.kt");
      }

      @Test
      @TestMetadata("kt63982.kt")
      public void testKt63982() {
        runTest("compiler/testData/diagnostics/tests/inference/kt63982.kt");
      }

      @Test
      @TestMetadata("kt68570.kt")
      public void testKt68570() {
        runTest("compiler/testData/diagnostics/tests/inference/kt68570.kt");
      }

      @Test
      @TestMetadata("kt69159Simplified.kt")
      public void testKt69159Simplified() {
        runTest("compiler/testData/diagnostics/tests/inference/kt69159Simplified.kt");
      }

      @Test
      @TestMetadata("kt69159WithComparable.kt")
      public void testKt69159WithComparable() {
        runTest("compiler/testData/diagnostics/tests/inference/kt69159WithComparable.kt");
      }

      @Test
      @TestMetadata("kt69326.kt")
      public void testKt69326() {
        runTest("compiler/testData/diagnostics/tests/inference/kt69326.kt");
      }

      @Test
      @TestMetadata("lambdaAgainstSimpleTypeMismatch.kt")
      public void testLambdaAgainstSimpleTypeMismatch() {
        runTest("compiler/testData/diagnostics/tests/inference/lambdaAgainstSimpleTypeMismatch.kt");
      }

      @Test
      @TestMetadata("lambdaArgumentWithLabel.kt")
      public void testLambdaArgumentWithLabel() {
        runTest("compiler/testData/diagnostics/tests/inference/lambdaArgumentWithLabel.kt");
      }

      @Test
      @TestMetadata("lambdaInValInitializerWithAnonymousFunctions.kt")
      public void testLambdaInValInitializerWithAnonymousFunctions() {
        runTest("compiler/testData/diagnostics/tests/inference/lambdaInValInitializerWithAnonymousFunctions.kt");
      }

      @Test
      @TestMetadata("lambdaParameterTypeInElvis.kt")
      public void testLambdaParameterTypeInElvis() {
        runTest("compiler/testData/diagnostics/tests/inference/lambdaParameterTypeInElvis.kt");
      }

      @Test
      @TestMetadata("listConstructor.kt")
      public void testListConstructor() {
        runTest("compiler/testData/diagnostics/tests/inference/listConstructor.kt");
      }

      @Test
      @TestMetadata("localFunctionInsideIfBlock.kt")
      public void testLocalFunctionInsideIfBlock() {
        runTest("compiler/testData/diagnostics/tests/inference/localFunctionInsideIfBlock.kt");
      }

      @Test
      @TestMetadata("mapFunction.kt")
      public void testMapFunction() {
        runTest("compiler/testData/diagnostics/tests/inference/mapFunction.kt");
      }

      @Test
      @TestMetadata("mostSpecificAfterInference.kt")
      public void testMostSpecificAfterInference() {
        runTest("compiler/testData/diagnostics/tests/inference/mostSpecificAfterInference.kt");
      }

      @Test
      @TestMetadata("nestedIfWithExpectedType.kt")
      public void testNestedIfWithExpectedType() {
        runTest("compiler/testData/diagnostics/tests/inference/nestedIfWithExpectedType.kt");
      }

      @Test
      @TestMetadata("NoInferenceFromDeclaredBounds.kt")
      public void testNoInferenceFromDeclaredBounds() {
        runTest("compiler/testData/diagnostics/tests/inference/NoInferenceFromDeclaredBounds.kt");
      }

      @Test
      @TestMetadata("noInformationForParameter.kt")
      public void testNoInformationForParameter() {
        runTest("compiler/testData/diagnostics/tests/inference/noInformationForParameter.kt");
      }

      @Test
      @TestMetadata("noInformationForStarProjectionCase.kt")
      public void testNoInformationForStarProjectionCase() {
        runTest("compiler/testData/diagnostics/tests/inference/noInformationForStarProjectionCase.kt");
      }

      @Test
      @TestMetadata("nonFunctionalExpectedTypeForLambdaArgument.kt")
      public void testNonFunctionalExpectedTypeForLambdaArgument() {
        runTest("compiler/testData/diagnostics/tests/inference/nonFunctionalExpectedTypeForLambdaArgument.kt");
      }

      @Test
      @TestMetadata("notFixedTopLevelLambdaParameter.kt")
      public void testNotFixedTopLevelLambdaParameter() {
        runTest("compiler/testData/diagnostics/tests/inference/notFixedTopLevelLambdaParameter.kt");
      }

      @Test
      @TestMetadata("nothingVsParameterBound.kt")
      public void testNothingVsParameterBound() {
        runTest("compiler/testData/diagnostics/tests/inference/nothingVsParameterBound.kt");
      }

      @Test
      @TestMetadata("nullableArgumentForDnn.kt")
      public void testNullableArgumentForDnn() {
        runTest("compiler/testData/diagnostics/tests/inference/nullableArgumentForDnn.kt");
      }

      @Test
      @TestMetadata("nullableTypeArgumentWithNotNullUpperBound.kt")
      public void testNullableTypeArgumentWithNotNullUpperBound() {
        runTest("compiler/testData/diagnostics/tests/inference/nullableTypeArgumentWithNotNullUpperBound.kt");
      }

      @Test
      @TestMetadata("nullableUpperBound.kt")
      public void testNullableUpperBound() {
        runTest("compiler/testData/diagnostics/tests/inference/nullableUpperBound.kt");
      }

      @Test
      @TestMetadata("nullableVsDnnVariations.kt")
      public void testNullableVsDnnVariations() {
        runTest("compiler/testData/diagnostics/tests/inference/nullableVsDnnVariations.kt");
      }

      @Test
      @TestMetadata("nullableVsDnnVariationsDisabled.kt")
      public void testNullableVsDnnVariationsDisabled() {
        runTest("compiler/testData/diagnostics/tests/inference/nullableVsDnnVariationsDisabled.kt");
      }

      @Test
      @TestMetadata("onlyInputTypesWithMultilevelIncorporation.kt")
      public void testOnlyInputTypesWithMultilevelIncorporation() {
        runTest("compiler/testData/diagnostics/tests/inference/onlyInputTypesWithMultilevelIncorporation.kt");
      }

      @Test
      @TestMetadata("opposite.kt")
      public void testOpposite() {
        runTest("compiler/testData/diagnostics/tests/inference/opposite.kt");
      }

      @Test
      @TestMetadata("possibleCycleOnConstraints.kt")
      public void testPossibleCycleOnConstraints() {
        runTest("compiler/testData/diagnostics/tests/inference/possibleCycleOnConstraints.kt");
      }

      @Test
      @TestMetadata("receiverTypeMismatch_withProper.kt")
      public void testReceiverTypeMismatch_withProper() {
        runTest("compiler/testData/diagnostics/tests/inference/receiverTypeMismatch_withProper.kt");
      }

      @Test
      @TestMetadata("receiverTypeMismatch_withoutProper.kt")
      public void testReceiverTypeMismatch_withoutProper() {
        runTest("compiler/testData/diagnostics/tests/inference/receiverTypeMismatch_withoutProper.kt");
      }

      @Test
      @TestMetadata("recursiveGenericExtensionReceiver.kt")
      public void testRecursiveGenericExtensionReceiver() {
        runTest("compiler/testData/diagnostics/tests/inference/recursiveGenericExtensionReceiver.kt");
      }

      @Test
      @TestMetadata("reportAboutUnresolvedReferenceAsUnresolved.kt")
      public void testReportAboutUnresolvedReferenceAsUnresolved() {
        runTest("compiler/testData/diagnostics/tests/inference/reportAboutUnresolvedReferenceAsUnresolved.kt");
      }

      @Test
      @TestMetadata("reportNotEnoughTypeInformationErrorsOnBlockExpressions.kt")
      public void testReportNotEnoughTypeInformationErrorsOnBlockExpressions() {
        runTest("compiler/testData/diagnostics/tests/inference/reportNotEnoughTypeInformationErrorsOnBlockExpressions.kt");
      }

      @Test
      @TestMetadata("resolveWithUnknownLambdaParameterType.kt")
      public void testResolveWithUnknownLambdaParameterType() {
        runTest("compiler/testData/diagnostics/tests/inference/resolveWithUnknownLambdaParameterType.kt");
      }

      @Test
      @TestMetadata("returningLambdaInSuspendContext.kt")
      public void testReturningLambdaInSuspendContext() {
        runTest("compiler/testData/diagnostics/tests/inference/returningLambdaInSuspendContext.kt");
      }

      @Test
      @TestMetadata("selectOfLambdaWithExtension.kt")
      public void testSelectOfLambdaWithExtension() {
        runTest("compiler/testData/diagnostics/tests/inference/selectOfLambdaWithExtension.kt");
      }

      @Test
      @TestMetadata("selectOfLambdaWithExtensionDisabled.kt")
      public void testSelectOfLambdaWithExtensionDisabled() {
        runTest("compiler/testData/diagnostics/tests/inference/selectOfLambdaWithExtensionDisabled.kt");
      }

      @Test
      @TestMetadata("selectOfLambdaWithExtensionEnabled.kt")
      public void testSelectOfLambdaWithExtensionEnabled() {
        runTest("compiler/testData/diagnostics/tests/inference/selectOfLambdaWithExtensionEnabled.kt");
      }

      @Test
      @TestMetadata("smartCastFork.kt")
      public void testSmartCastFork() {
        runTest("compiler/testData/diagnostics/tests/inference/smartCastFork.kt");
      }

      @Test
      @TestMetadata("smartCastForkForExpectType.kt")
      public void testSmartCastForkForExpectType() {
        runTest("compiler/testData/diagnostics/tests/inference/smartCastForkForExpectType.kt");
      }

      @Test
      @TestMetadata("smartCastForkForExpectedTypeNested.kt")
      public void testSmartCastForkForExpectedTypeNested() {
        runTest("compiler/testData/diagnostics/tests/inference/smartCastForkForExpectedTypeNested.kt");
      }

      @Test
      @TestMetadata("specialCallsWithCallableReferences.kt")
      public void testSpecialCallsWithCallableReferences() {
        runTest("compiler/testData/diagnostics/tests/inference/specialCallsWithCallableReferences.kt");
      }

      @Test
      @TestMetadata("specialCallsWithLambdas.kt")
      public void testSpecialCallsWithLambdas() {
        runTest("compiler/testData/diagnostics/tests/inference/specialCallsWithLambdas.kt");
      }

      @Test
      @TestMetadata("starApproximation.kt")
      public void testStarApproximation() {
        runTest("compiler/testData/diagnostics/tests/inference/starApproximation.kt");
      }

      @Test
      @TestMetadata("starApproximationBangBang.kt")
      public void testStarApproximationBangBang() {
        runTest("compiler/testData/diagnostics/tests/inference/starApproximationBangBang.kt");
      }

      @Test
      @TestMetadata("starApproximationFlexible.kt")
      public void testStarApproximationFlexible() {
        runTest("compiler/testData/diagnostics/tests/inference/starApproximationFlexible.kt");
      }

      @Test
      @TestMetadata("starApproximationFromDifferentTypeParameter.kt")
      public void testStarApproximationFromDifferentTypeParameter() {
        runTest("compiler/testData/diagnostics/tests/inference/starApproximationFromDifferentTypeParameter.kt");
      }

      @Test
      @TestMetadata("stubTypeForSubtyping.kt")
      public void testStubTypeForSubtyping() {
        runTest("compiler/testData/diagnostics/tests/inference/stubTypeForSubtyping.kt");
      }

      @Test
      @TestMetadata("tooEagerSmartcast.kt")
      public void testTooEagerSmartcast() {
        runTest("compiler/testData/diagnostics/tests/inference/tooEagerSmartcast.kt");
      }

      @Test
      @TestMetadata("topLevelIntersection.kt")
      public void testTopLevelIntersection() {
        runTest("compiler/testData/diagnostics/tests/inference/topLevelIntersection.kt");
      }

      @Test
      @TestMetadata("tryNumberLowerBoundsBeforeUpperBounds.kt")
      public void testTryNumberLowerBoundsBeforeUpperBounds() {
        runTest("compiler/testData/diagnostics/tests/inference/tryNumberLowerBoundsBeforeUpperBounds.kt");
      }

      @Test
      @TestMetadata("typeConstructorMismatch.kt")
      public void testTypeConstructorMismatch() {
        runTest("compiler/testData/diagnostics/tests/inference/typeConstructorMismatch.kt");
      }

      @Test
      @TestMetadata("typeInferenceExpectedTypeMismatch.kt")
      public void testTypeInferenceExpectedTypeMismatch() {
        runTest("compiler/testData/diagnostics/tests/inference/typeInferenceExpectedTypeMismatch.kt");
      }

      @Test
      @TestMetadata("typeParameterInConstructor.kt")
      public void testTypeParameterInConstructor() {
        runTest("compiler/testData/diagnostics/tests/inference/typeParameterInConstructor.kt");
      }

      @Test
      @TestMetadata("underscoredInEnumMap.kt")
      public void testUnderscoredInEnumMap() {
        runTest("compiler/testData/diagnostics/tests/inference/underscoredInEnumMap.kt");
      }

      @Test
      @TestMetadata("underscoredTypeArgument.kt")
      public void testUnderscoredTypeArgument() {
        runTest("compiler/testData/diagnostics/tests/inference/underscoredTypeArgument.kt");
      }

      @Test
      @TestMetadata("underscoredTypeArgumentInErroneousCall.kt")
      public void testUnderscoredTypeArgumentInErroneousCall() {
        runTest("compiler/testData/diagnostics/tests/inference/underscoredTypeArgumentInErroneousCall.kt");
      }

      @Test
      @TestMetadata("underscoredTypeArgumentInTypeAliasedConstructor.kt")
      public void testUnderscoredTypeArgumentInTypeAliasedConstructor() {
        runTest("compiler/testData/diagnostics/tests/inference/underscoredTypeArgumentInTypeAliasedConstructor.kt");
      }

      @Test
      @TestMetadata("underscoredTypeArgumentInTypeAliasedSamConstructor.kt")
      public void testUnderscoredTypeArgumentInTypeAliasedSamConstructor() {
        runTest("compiler/testData/diagnostics/tests/inference/underscoredTypeArgumentInTypeAliasedSamConstructor.kt");
      }

      @Test
      @TestMetadata("underscoredTypeInForbiddenPositions.kt")
      public void testUnderscoredTypeInForbiddenPositions() {
        runTest("compiler/testData/diagnostics/tests/inference/underscoredTypeInForbiddenPositions.kt");
      }

      @Test
      @TestMetadata("UnitUpperboundLambdaReturnType.kt")
      public void testUnitUpperboundLambdaReturnType() {
        runTest("compiler/testData/diagnostics/tests/inference/UnitUpperboundLambdaReturnType.kt");
      }

      @Test
      @TestMetadata("UnitUpperboundLambdaReturnTypeWithExplicitReturn.kt")
      public void testUnitUpperboundLambdaReturnTypeWithExplicitReturn() {
        runTest("compiler/testData/diagnostics/tests/inference/UnitUpperboundLambdaReturnTypeWithExplicitReturn.kt");
      }

      @Test
      @TestMetadata("unsoundness1.kt")
      public void testUnsoundness1() {
        runTest("compiler/testData/diagnostics/tests/inference/unsoundness1.kt");
      }

      @Test
      @TestMetadata("unsoundness2.kt")
      public void testUnsoundness2() {
        runTest("compiler/testData/diagnostics/tests/inference/unsoundness2.kt");
      }

      @Test
      @TestMetadata("useFunctionLiteralsToInferType.kt")
      public void testUseFunctionLiteralsToInferType() {
        runTest("compiler/testData/diagnostics/tests/inference/useFunctionLiteralsToInferType.kt");
      }

      @Test
      @TestMetadata("violatingUpperBoundForSelfType.kt")
      public void testViolatingUpperBoundForSelfType() {
        runTest("compiler/testData/diagnostics/tests/inference/violatingUpperBoundForSelfType.kt");
      }

      @Test
      @TestMetadata("violatingUpperBoundForSelfTypeError.kt")
      public void testViolatingUpperBoundForSelfTypeError() {
        runTest("compiler/testData/diagnostics/tests/inference/violatingUpperBoundForSelfTypeError.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/callableReferences")
      @TestDataPath("$PROJECT_ROOT")
      public class CallableReferences {
        @Test
        public void testAllFilesPresentInCallableReferences() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/callableReferences"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("conversionLastStatementInLambda.kt")
        public void testConversionLastStatementInLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/callableReferences/conversionLastStatementInLambda.kt");
        }

        @Test
        @TestMetadata("conversionLastStatementInLambdaGeneric.kt")
        public void testConversionLastStatementInLambdaGeneric() {
          runTest("compiler/testData/diagnostics/tests/inference/callableReferences/conversionLastStatementInLambdaGeneric.kt");
        }

        @Test
        @TestMetadata("fromExpectedTypeInLambda.kt")
        public void testFromExpectedTypeInLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/callableReferences/fromExpectedTypeInLambda.kt");
        }

        @Test
        @TestMetadata("kt55931.kt")
        public void testKt55931() {
          runTest("compiler/testData/diagnostics/tests/inference/callableReferences/kt55931.kt");
        }

        @Test
        @TestMetadata("kt56227.kt")
        public void testKt56227() {
          runTest("compiler/testData/diagnostics/tests/inference/callableReferences/kt56227.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes")
      @TestDataPath("$PROJECT_ROOT")
      public class CapturedTypes {
        @Test
        public void testAllFilesPresentInCapturedTypes() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/capturedTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("approximateBeforeFixation.kt")
        public void testApproximateBeforeFixation() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/approximateBeforeFixation.kt");
        }

        @Test
        @TestMetadata("approximateContravariantCapturedTypes.kt")
        public void testApproximateContravariantCapturedTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/approximateContravariantCapturedTypes.kt");
        }

        @Test
        @TestMetadata("approximationLeavesNonTrivialLowerBound.kt")
        public void testApproximationLeavesNonTrivialLowerBound() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/approximationLeavesNonTrivialLowerBound.kt");
        }

        @Test
        @TestMetadata("avoidCreatingUselessCapturedTypes.kt")
        public void testAvoidCreatingUselessCapturedTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/avoidCreatingUselessCapturedTypes.kt");
        }

        @Test
        @TestMetadata("cannotCaptureInProjection.kt")
        public void testCannotCaptureInProjection() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/cannotCaptureInProjection.kt");
        }

        @Test
        @TestMetadata("captureForNullableTypes.kt")
        public void testCaptureForNullableTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureForNullableTypes.kt");
        }

        @Test
        @TestMetadata("captureForPlatformTypes.kt")
        public void testCaptureForPlatformTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureForPlatformTypes.kt");
        }

        @Test
        @TestMetadata("captureFromNullableTypeInScope.kt")
        public void testCaptureFromNullableTypeInScope() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureFromNullableTypeInScope.kt");
        }

        @Test
        @TestMetadata("captureFromNullableTypeInScopeAny.kt")
        public void testCaptureFromNullableTypeInScopeAny() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureFromNullableTypeInScopeAny.kt");
        }

        @Test
        @TestMetadata("captureFromNullableTypeVariable.kt")
        public void testCaptureFromNullableTypeVariable() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureFromNullableTypeVariable.kt");
        }

        @Test
        @TestMetadata("captureFromSubtyping.kt")
        public void testCaptureFromSubtyping() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureFromSubtyping.kt");
        }

        @Test
        @TestMetadata("captureFromTypeParameterUpperBound.kt")
        public void testCaptureFromTypeParameterUpperBound() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureFromTypeParameterUpperBound.kt");
        }

        @Test
        @TestMetadata("captureTypeOnlyOnTopLevel.kt")
        public void testCaptureTypeOnlyOnTopLevel() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureTypeOnlyOnTopLevel.kt");
        }

        @Test
        @TestMetadata("capturedApproximationWithInproperUpperConstraint.kt")
        public void testCapturedApproximationWithInproperUpperConstraint() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedApproximationWithInproperUpperConstraint.kt");
        }

        @Test
        @TestMetadata("capturedAssignment.kt")
        public void testCapturedAssignment() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedAssignment.kt");
        }

        @Test
        @TestMetadata("capturedAssignmentAfter.kt")
        public void testCapturedAssignmentAfter() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedAssignmentAfter.kt");
        }

        @Test
        @TestMetadata("capturedFlexibleIntersectionTypesWithDifferentBounds.kt")
        public void testCapturedFlexibleIntersectionTypesWithDifferentBounds() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedFlexibleIntersectionTypesWithDifferentBounds.kt");
        }

        @Test
        @TestMetadata("capturedFlexibleIntersectionTypesWithDifferentConstructors.kt")
        public void testCapturedFlexibleIntersectionTypesWithDifferentConstructors() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedFlexibleIntersectionTypesWithDifferentConstructors.kt");
        }

        @Test
        @TestMetadata("capturedForIncorporationEscapes.kt")
        public void testCapturedForIncorporationEscapes() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedForIncorporationEscapes.kt");
        }

        @Test
        @TestMetadata("capturedFunctionalType.kt")
        public void testCapturedFunctionalType() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedFunctionalType.kt");
        }

        @Test
        @TestMetadata("capturedInTypeInference.kt")
        public void testCapturedInTypeInference() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedInTypeInference.kt");
        }

        @Test
        @TestMetadata("capturedType.kt")
        public void testCapturedType() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedType.kt");
        }

        @Test
        @TestMetadata("capturedTypeAndApproximation.kt")
        public void testCapturedTypeAndApproximation() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeAndApproximation.kt");
        }

        @Test
        @TestMetadata("capturedTypeSubstitutedIntoOppositeProjection.kt")
        public void testCapturedTypeSubstitutedIntoOppositeProjection() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeSubstitutedIntoOppositeProjection.kt");
        }

        @Test
        @TestMetadata("capturedTypeWithInnerTypealias.kt")
        public void testCapturedTypeWithInnerTypealias() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeWithInnerTypealias.kt");
        }

        @Test
        @TestMetadata("capturedTypeWithTypeVariableSubtyping.kt")
        public void testCapturedTypeWithTypeVariableSubtyping() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeWithTypeVariableSubtyping.kt");
        }

        @Test
        @TestMetadata("capturedTypesSubstitutionIntoAbbreviation.kt")
        public void testCapturedTypesSubstitutionIntoAbbreviation() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypesSubstitutionIntoAbbreviation.kt");
        }

        @Test
        @TestMetadata("capturedUpperBound.kt")
        public void testCapturedUpperBound() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedUpperBound.kt");
        }

        @Test
        @TestMetadata("capturingFromArgumentOfFlexibleType.kt")
        public void testCapturingFromArgumentOfFlexibleType() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturingFromArgumentOfFlexibleType.kt");
        }

        @Test
        @TestMetadata("capturingOfDnn.kt")
        public void testCapturingOfDnn() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturingOfDnn.kt");
        }

        @Test
        @TestMetadata("differentCapturedTypes.kt")
        public void testDifferentCapturedTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/differentCapturedTypes.kt");
        }

        @Test
        @TestMetadata("dontCheckNewCapturedTypeSpecificChecksForOldOnes.kt")
        public void testDontCheckNewCapturedTypeSpecificChecksForOldOnes() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/dontCheckNewCapturedTypeSpecificChecksForOldOnes.kt");
        }

        @Test
        @TestMetadata("expectedTypeHasCapturedStarArgument.kt")
        public void testExpectedTypeHasCapturedStarArgument() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/expectedTypeHasCapturedStarArgument.kt");
        }

        @Test
        @TestMetadata("expectedTypeMismatchWithInVariance.kt")
        public void testExpectedTypeMismatchWithInVariance() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/expectedTypeMismatchWithInVariance.kt");
        }

        @Test
        @TestMetadata("genericWildcardUpperBound.kt")
        public void testGenericWildcardUpperBound() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/genericWildcardUpperBound.kt");
        }

        @Test
        @TestMetadata("invokeCallWithCapturedReceiver.kt")
        public void testInvokeCallWithCapturedReceiver() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/invokeCallWithCapturedReceiver.kt");
        }

        @Test
        @TestMetadata("kt25302.kt")
        public void testKt25302() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt25302.kt");
        }

        @Test
        @TestMetadata("kt2570.kt")
        public void testKt2570() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt2570.kt");
        }

        @Test
        @TestMetadata("kt2872.kt")
        public void testKt2872() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt2872.kt");
        }

        @Test
        @TestMetadata("kt46727.kt")
        public void testKt46727() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt46727.kt");
        }

        @Test
        @TestMetadata("kt46727Warnings.kt")
        public void testKt46727Warnings() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt46727Warnings.kt");
        }

        @Test
        @TestMetadata("kt49101.kt")
        public void testKt49101() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt49101.kt");
        }

        @Test
        @TestMetadata("kt52782.kt")
        public void testKt52782() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt52782.kt");
        }

        @Test
        @TestMetadata("kt72177.kt")
        public void testKt72177() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt72177.kt");
        }

        @Test
        @TestMetadata("memberScopeOfCaptured.kt")
        public void testMemberScopeOfCaptured() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/memberScopeOfCaptured.kt");
        }

        @Test
        @TestMetadata("noCaptureTypeErrorForNonTopLevel.kt")
        public void testNoCaptureTypeErrorForNonTopLevel() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/noCaptureTypeErrorForNonTopLevel.kt");
        }

        @Test
        @TestMetadata("notApproximateWhenCopyDescriptors.kt")
        public void testNotApproximateWhenCopyDescriptors() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/notApproximateWhenCopyDescriptors.kt");
        }

        @Test
        @TestMetadata("nullableCaptruredTypeAgainstNullableVariable.kt")
        public void testNullableCaptruredTypeAgainstNullableVariable() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/nullableCaptruredTypeAgainstNullableVariable.kt");
        }

        @Test
        @TestMetadata("overApproximationForInCaptured.kt")
        public void testOverApproximationForInCaptured() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/overApproximationForInCaptured.kt");
        }

        @Test
        @TestMetadata("overApproximationForOutCaptured.kt")
        public void testOverApproximationForOutCaptured() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/overApproximationForOutCaptured.kt");
        }

        @Test
        @TestMetadata("projectedOutTypeMismatch.kt")
        public void testProjectedOutTypeMismatch() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/projectedOutTypeMismatch.kt");
        }

        @Test
        @TestMetadata("propagateNullailityOnSupertypesWhenCaptureTypes.kt")
        public void testPropagateNullailityOnSupertypesWhenCaptureTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/propagateNullailityOnSupertypesWhenCaptureTypes.kt");
        }

        @Test
        @TestMetadata("selfTypeTypeHole.kt")
        public void testSelfTypeTypeHole() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/selfTypeTypeHole.kt");
        }

        @Test
        @TestMetadata("starProjectionRegression.kt")
        public void testStarProjectionRegression() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/starProjectionRegression.kt");
        }

        @Test
        @TestMetadata("substituteCapturedTypesWithTypeVariables.kt")
        public void testSubstituteCapturedTypesWithTypeVariables() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/substituteCapturedTypesWithTypeVariables.kt");
        }

        @Test
        @TestMetadata("topLevelCapturingInsideReturnType.kt")
        public void testTopLevelCapturingInsideReturnType() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/topLevelCapturingInsideReturnType.kt");
        }

        @Test
        @TestMetadata("upperBoundOfCapturedInProjectionInOutPosition.kt")
        public void testUpperBoundOfCapturedInProjectionInOutPosition() {
          runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/upperBoundOfCapturedInProjectionInOutPosition.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/coercionToUnit")
      @TestDataPath("$PROJECT_ROOT")
      public class CoercionToUnit {
        @Test
        @TestMetadata("afterBareReturn.kt")
        public void testAfterBareReturn() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/afterBareReturn.kt");
        }

        @Test
        public void testAllFilesPresentInCoercionToUnit() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/coercionToUnit"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("coercionToUnitForIfAsLastExpressionInLambda.kt")
        public void testCoercionToUnitForIfAsLastExpressionInLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionToUnitForIfAsLastExpressionInLambda.kt");
        }

        @Test
        @TestMetadata("coercionToUnitForLastLambdaInLambda.kt")
        public void testCoercionToUnitForLastLambdaInLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionToUnitForLastLambdaInLambda.kt");
        }

        @Test
        @TestMetadata("coercionToUnitReference.kt")
        public void testCoercionToUnitReference() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionToUnitReference.kt");
        }

        @Test
        @TestMetadata("coercionToUnitWithNothingType.kt")
        public void testCoercionToUnitWithNothingType() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionToUnitWithNothingType.kt");
        }

        @Test
        @TestMetadata("coercionWithExpectedType.kt")
        public void testCoercionWithExpectedType() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionWithExpectedType.kt");
        }

        @Test
        @TestMetadata("coercionWithExpectedTypeAndBound.kt")
        public void testCoercionWithExpectedTypeAndBound() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionWithExpectedTypeAndBound.kt");
        }

        @Test
        @TestMetadata("coercionWithExplicitTypeArgument.kt")
        public void testCoercionWithExplicitTypeArgument() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionWithExplicitTypeArgument.kt");
        }

        @Test
        @TestMetadata("coercionWithoutExpectedType.kt")
        public void testCoercionWithoutExpectedType() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionWithoutExpectedType.kt");
        }

        @Test
        @TestMetadata("coerctionToUnitForATypeWithUpperBound.kt")
        public void testCoerctionToUnitForATypeWithUpperBound() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coerctionToUnitForATypeWithUpperBound.kt");
        }

        @Test
        @TestMetadata("coersionWithAnonymousFunctionsAndUnresolved.kt")
        public void testCoersionWithAnonymousFunctionsAndUnresolved() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coersionWithAnonymousFunctionsAndUnresolved.kt");
        }

        @Test
        @TestMetadata("genericInApply.kt")
        public void testGenericInApply() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/genericInApply.kt");
        }

        @Test
        @TestMetadata("indirectCoercionWithExpectedType.kt")
        public void testIndirectCoercionWithExpectedType() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/indirectCoercionWithExpectedType.kt");
        }

        @Test
        @TestMetadata("kt30242.kt")
        public void testKt30242() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/kt30242.kt");
        }

        @Test
        @TestMetadata("lambdaWithNullableUnitInElvis.kt")
        public void testLambdaWithNullableUnitInElvis() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/lambdaWithNullableUnitInElvis.kt");
        }

        @Test
        @TestMetadata("lastStatementInNonUnitLambda.kt")
        public void testLastStatementInNonUnitLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/lastStatementInNonUnitLambda.kt");
        }

        @Test
        @TestMetadata("lastStatementInNonUnitLambdaWithRegularReturn.kt")
        public void testLastStatementInNonUnitLambdaWithRegularReturn() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/lastStatementInNonUnitLambdaWithRegularReturn.kt");
        }

        @Test
        @TestMetadata("nestedLambda.kt")
        public void testNestedLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/nestedLambda.kt");
        }

        @Test
        @TestMetadata("noCoercion.kt")
        public void testNoCoercion() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/noCoercion.kt");
        }

        @Test
        @TestMetadata("nonPropagationOfCoercionToUnitInsideNestedLambda.kt")
        public void testNonPropagationOfCoercionToUnitInsideNestedLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/nonPropagationOfCoercionToUnitInsideNestedLambda.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/commonSystem")
      @TestDataPath("$PROJECT_ROOT")
      public class CommonSystem {
        @Test
        public void testAllFilesPresentInCommonSystem() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/commonSystem"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("boundOnNullableVariable.kt")
        public void testBoundOnNullableVariable() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/boundOnNullableVariable.kt");
        }

        @Test
        @TestMetadata("castToSubtype.kt")
        public void testCastToSubtype() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/castToSubtype.kt");
        }

        @Test
        @TestMetadata("cstFromNullableChildAndNonParameterizedType.kt")
        public void testCstFromNullableChildAndNonParameterizedType() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/cstFromNullableChildAndNonParameterizedType.kt");
        }

        @Test
        @TestMetadata("cstWithTypeContainingNonFixedVariable.kt")
        public void testCstWithTypeContainingNonFixedVariable() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/cstWithTypeContainingNonFixedVariable.kt");
        }

        @Test
        @TestMetadata("dontCaptureTypeVariable.kt")
        public void testDontCaptureTypeVariable() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/dontCaptureTypeVariable.kt");
        }

        @Test
        @TestMetadata("exactOnElvis.kt")
        public void testExactOnElvis() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/exactOnElvis.kt");
        }

        @Test
        @TestMetadata("fixVariablesInRightOrder.kt")
        public void testFixVariablesInRightOrder() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/fixVariablesInRightOrder.kt");
        }

        @Test
        @TestMetadata("genericCandidateInGenericClass.kt")
        public void testGenericCandidateInGenericClass() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/genericCandidateInGenericClass.kt");
        }

        @Test
        @TestMetadata("iltInsideSeveralCalls.kt")
        public void testIltInsideSeveralCalls() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/iltInsideSeveralCalls.kt");
        }

        @Test
        @TestMetadata("inferenceWithUpperBoundsInLambda.kt")
        public void testInferenceWithUpperBoundsInLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/inferenceWithUpperBoundsInLambda.kt");
        }

        @Test
        @TestMetadata("kt30300.kt")
        public void testKt30300() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/kt30300.kt");
        }

        @Test
        @TestMetadata("kt31969.kt")
        public void testKt31969() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/kt31969.kt");
        }

        @Test
        @TestMetadata("kt32818.kt")
        public void testKt32818() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/kt32818.kt");
        }

        @Test
        @TestMetadata("kt33197.kt")
        public void testKt33197() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/kt33197.kt");
        }

        @Test
        @TestMetadata("kt3372toCollection.kt")
        public void testKt3372toCollection() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/kt3372toCollection.kt");
        }

        @Test
        @TestMetadata("lessSpecificTypeForArgumentCallWithExactAnnotation.kt")
        public void testLessSpecificTypeForArgumentCallWithExactAnnotation() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/lessSpecificTypeForArgumentCallWithExactAnnotation.kt");
        }

        @Test
        @TestMetadata("lessSpecificTypeForArgumentCallWithExactAnnotation_ni.kt")
        public void testLessSpecificTypeForArgumentCallWithExactAnnotation_ni() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/lessSpecificTypeForArgumentCallWithExactAnnotation_ni.kt");
        }

        @Test
        @TestMetadata("manyArgumentsForVararg.kt")
        public void testManyArgumentsForVararg() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/manyArgumentsForVararg.kt");
        }

        @Test
        @TestMetadata("nestedLambdas.kt")
        public void testNestedLambdas() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/nestedLambdas.kt");
        }

        @Test
        @TestMetadata("nonFixedVariableFromBothBranches.kt")
        public void testNonFixedVariableFromBothBranches() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/nonFixedVariableFromBothBranches.kt");
        }

        @Test
        @TestMetadata("nonFixedVariableInsideFlexibleType.kt")
        public void testNonFixedVariableInsideFlexibleType() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/nonFixedVariableInsideFlexibleType.kt");
        }

        @Test
        @TestMetadata("outProjectedTypeToOutProjected.kt")
        public void testOutProjectedTypeToOutProjected() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/outProjectedTypeToOutProjected.kt");
        }

        @Test
        @TestMetadata("postponedCompletionWithExactAnnotation.kt")
        public void testPostponedCompletionWithExactAnnotation() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/postponedCompletionWithExactAnnotation.kt");
        }

        @Test
        @TestMetadata("postponedCompletionWithExactAnnotation_ni.kt")
        public void testPostponedCompletionWithExactAnnotation_ni() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/postponedCompletionWithExactAnnotation_ni.kt");
        }

        @Test
        @TestMetadata("selectFromTwoIncompatibleTypes.kt")
        public void testSelectFromTwoIncompatibleTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/selectFromTwoIncompatibleTypes.kt");
        }

        @Test
        @TestMetadata("selectIntegerValueTypeFromIf.kt")
        public void testSelectIntegerValueTypeFromIf() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/selectIntegerValueTypeFromIf.kt");
        }

        @Test
        @TestMetadata("theSameFunctionInArgs.kt")
        public void testTheSameFunctionInArgs() {
          runTest("compiler/testData/diagnostics/tests/inference/commonSystem/theSameFunctionInArgs.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/completion")
      @TestDataPath("$PROJECT_ROOT")
      public class Completion {
        @Test
        public void testAllFilesPresentInCompletion() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/completion"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("anonymousFunction.kt")
        public void testAnonymousFunction() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/anonymousFunction.kt");
        }

        @Test
        @TestMetadata("basic.kt")
        public void testBasic() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/basic.kt");
        }

        @Test
        @TestMetadata("definitelyNotNullType.kt")
        public void testDefinitelyNotNullType() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/definitelyNotNullType.kt");
        }

        @Test
        @TestMetadata("equalityConstraintUpstairs.kt")
        public void testEqualityConstraintUpstairs() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/equalityConstraintUpstairs.kt");
        }

        @Test
        @TestMetadata("errorAfterCompletion.kt")
        public void testErrorAfterCompletion() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/errorAfterCompletion.kt");
        }

        @Test
        @TestMetadata("flexibleType.kt")
        public void testFlexibleType() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/flexibleType.kt");
        }

        @Test
        @TestMetadata("inferLabeledElementTypeForLambdaInReturnInCatch.kt")
        public void testInferLabeledElementTypeForLambdaInReturnInCatch() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/inferLabeledElementTypeForLambdaInReturnInCatch.kt");
        }

        @Test
        @TestMetadata("intersectionType.kt")
        public void testIntersectionType() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/intersectionType.kt");
        }

        @Test
        @TestMetadata("kt33166.kt")
        public void testKt33166() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/kt33166.kt");
        }

        @Test
        @TestMetadata("kt36233.kt")
        public void testKt36233() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/kt36233.kt");
        }

        @Test
        @TestMetadata("lambdaWithVariableAndNothing.kt")
        public void testLambdaWithVariableAndNothing() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/lambdaWithVariableAndNothing.kt");
        }

        @Test
        @TestMetadata("nestedVariance.kt")
        public void testNestedVariance() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/nestedVariance.kt");
        }

        @Test
        @TestMetadata("nothingFromNestedCall.kt")
        public void testNothingFromNestedCall() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/nothingFromNestedCall.kt");
        }

        @Test
        @TestMetadata("partialForIlt.kt")
        public void testPartialForIlt() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/partialForIlt.kt");
        }

        @Test
        @TestMetadata("partialForIltWithNothing.kt")
        public void testPartialForIltWithNothing() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/partialForIltWithNothing.kt");
        }

        @Test
        @TestMetadata("transitiveConstraint.kt")
        public void testTransitiveConstraint() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/transitiveConstraint.kt");
        }

        @Test
        @TestMetadata("withExact.kt")
        public void testWithExact() {
          runTest("compiler/testData/diagnostics/tests/inference/completion/withExact.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis")
        @TestDataPath("$PROJECT_ROOT")
        public class PostponedArgumentsAnalysis {
          @Test
          public void testAllFilesPresentInPostponedArgumentsAnalysis() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("basic.kt")
          public void testBasic() {
            runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/basic.kt");
          }

          @Test
          @TestMetadata("callableReferenceLambdaCombinationInsideCall.kt")
          public void testCallableReferenceLambdaCombinationInsideCall() {
            runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/callableReferenceLambdaCombinationInsideCall.kt");
          }

          @Test
          @TestMetadata("callableReferences.kt")
          public void testCallableReferences() {
            runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/callableReferences.kt");
          }

          @Test
          @TestMetadata("fixingVariableDuringAddingConstraintForFirstPosponedArgument.kt")
          public void testFixingVariableDuringAddingConstraintForFirstPosponedArgument() {
            runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/fixingVariableDuringAddingConstraintForFirstPosponedArgument.kt");
          }

          @Test
          @TestMetadata("lackOfDeepIncorporation.kt")
          public void testLackOfDeepIncorporation() {
            runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/lackOfDeepIncorporation.kt");
          }

          @Test
          @TestMetadata("lambdasInTryCatch.kt")
          public void testLambdasInTryCatch() {
            runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/lambdasInTryCatch.kt");
          }

          @Test
          @TestMetadata("notInferableParameterOfAnonymousFunction.kt")
          public void testNotInferableParameterOfAnonymousFunction() {
            runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/notInferableParameterOfAnonymousFunction.kt");
          }

          @Test
          @TestMetadata("takingExtensibilityFromDeclarationOfAnonymousFunction.kt")
          public void testTakingExtensibilityFromDeclarationOfAnonymousFunction() {
            runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/takingExtensibilityFromDeclarationOfAnonymousFunction.kt");
          }

          @Test
          @TestMetadata("wrongVariableFixationOrder.kt")
          public void testWrongVariableFixationOrder() {
            runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/wrongVariableFixationOrder.kt");
          }

          @Test
          @TestMetadata("wrongVariableFixationOrder2.kt")
          public void testWrongVariableFixationOrder2() {
            runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/wrongVariableFixationOrder2.kt");
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/constraints")
      @TestDataPath("$PROJECT_ROOT")
      public class Constraints {
        @Test
        public void testAllFilesPresentInConstraints() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/constraints"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("approximationWithDefNotNullInInvPositionDuringInference.kt")
        public void testApproximationWithDefNotNullInInvPositionDuringInference() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/approximationWithDefNotNullInInvPositionDuringInference.kt");
        }

        @Test
        @TestMetadata("complexDependencyWihtoutProperConstraints.kt")
        public void testComplexDependencyWihtoutProperConstraints() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/complexDependencyWihtoutProperConstraints.kt");
        }

        @Test
        @TestMetadata("constraintFromVariantTypeWithNestedProjection.kt")
        public void testConstraintFromVariantTypeWithNestedProjection() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/constraintFromVariantTypeWithNestedProjection.kt");
        }

        @Test
        @TestMetadata("constraintOnFunctionLiteral.kt")
        public void testConstraintOnFunctionLiteral() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/constraintOnFunctionLiteral.kt");
        }

        @Test
        @TestMetadata("definitelyNotNullTypeInArguments.kt")
        public void testDefinitelyNotNullTypeInArguments() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/definitelyNotNullTypeInArguments.kt");
        }

        @Test
        @TestMetadata("definitelyNotNullTypeInArgumentsDisabled.kt")
        public void testDefinitelyNotNullTypeInArgumentsDisabled() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/definitelyNotNullTypeInArgumentsDisabled.kt");
        }

        @Test
        @TestMetadata("definitelyNotNullTypeInReturnPosition.kt")
        public void testDefinitelyNotNullTypeInReturnPosition() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/definitelyNotNullTypeInReturnPosition.kt");
        }

        @Test
        @TestMetadata("definitelyNotNullTypeInvariantPosition.kt")
        public void testDefinitelyNotNullTypeInvariantPosition() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/definitelyNotNullTypeInvariantPosition.kt");
        }

        @Test
        @TestMetadata("earlyCompletionForCalls.kt")
        public void testEarlyCompletionForCalls() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/earlyCompletionForCalls.kt");
        }

        @Test
        @TestMetadata("equalityConstraintOnNullableType.kt")
        public void testEqualityConstraintOnNullableType() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/equalityConstraintOnNullableType.kt");
        }

        @Test
        @TestMetadata("errorUpperBoundConstraint.kt")
        public void testErrorUpperBoundConstraint() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/errorUpperBoundConstraint.kt");
        }

        @Test
        @TestMetadata("fixTypeVariableWithNothingConstraintEarlierThanComplexVariable.kt")
        public void testFixTypeVariableWithNothingConstraintEarlierThanComplexVariable() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/fixTypeVariableWithNothingConstraintEarlierThanComplexVariable.kt");
        }

        @Test
        @TestMetadata("ignoreConstraintFromImplicitInNothing.kt")
        public void testIgnoreConstraintFromImplicitInNothing() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/ignoreConstraintFromImplicitInNothing.kt");
        }

        @Test
        @TestMetadata("inferTypeFromCapturedStarProjection.kt")
        public void testInferTypeFromCapturedStarProjection() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/inferTypeFromCapturedStarProjection.kt");
        }

        @Test
        @TestMetadata("kt6320.kt")
        public void testKt6320() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/kt6320.kt");
        }

        @Test
        @TestMetadata("kt7351ConstraintFromUnitExpectedType.kt")
        public void testKt7351ConstraintFromUnitExpectedType() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/kt7351ConstraintFromUnitExpectedType.kt");
        }

        @Test
        @TestMetadata("kt7433.kt")
        public void testKt7433() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/kt7433.kt");
        }

        @Test
        @TestMetadata("kt8879.kt")
        public void testKt8879() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/kt8879.kt");
        }

        @Test
        @TestMetadata("manyConstraintsDueToFlexibleRawTypes.kt")
        public void testManyConstraintsDueToFlexibleRawTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/manyConstraintsDueToFlexibleRawTypes.kt");
        }

        @Test
        @TestMetadata("manyConstraintsDueToRecursiveFlexibleTypesWithWildcards.kt")
        public void testManyConstraintsDueToRecursiveFlexibleTypesWithWildcards() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/manyConstraintsDueToRecursiveFlexibleTypesWithWildcards.kt");
        }

        @Test
        @TestMetadata("notNullConstraintOnNullableType.kt")
        public void testNotNullConstraintOnNullableType() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/notNullConstraintOnNullableType.kt");
        }

        @Test
        @TestMetadata("operationsOnIntegerValueTypes.kt")
        public void testOperationsOnIntegerValueTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/operationsOnIntegerValueTypes.kt");
        }

        @Test
        @TestMetadata("recursiveJavaTypeWithStarProjection.kt")
        public void testRecursiveJavaTypeWithStarProjection() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/recursiveJavaTypeWithStarProjection.kt");
        }

        @Test
        @TestMetadata("remainConstraintContainingTypeWithoutProjection.kt")
        public void testRemainConstraintContainingTypeWithoutProjection() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/remainConstraintContainingTypeWithoutProjection.kt");
        }

        @Test
        @TestMetadata("returnLambdaFromLambda.kt")
        public void testReturnLambdaFromLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/returnLambdaFromLambda.kt");
        }

        @Test
        @TestMetadata("subtypeConstraintOnNullableType.kt")
        public void testSubtypeConstraintOnNullableType() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/subtypeConstraintOnNullableType.kt");
        }

        @Test
        @TestMetadata("supertypeConstraintOnNullableType.kt")
        public void testSupertypeConstraintOnNullableType() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/supertypeConstraintOnNullableType.kt");
        }

        @Test
        @TestMetadata("wrongApproximationWithDefNotNullTypesAndDelegates.kt")
        public void testWrongApproximationWithDefNotNullTypesAndDelegates() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/wrongApproximationWithDefNotNullTypesAndDelegates.kt");
        }

        @Test
        @TestMetadata("wrongExpectedTypeForWhen.kt")
        public void testWrongExpectedTypeForWhen() {
          runTest("compiler/testData/diagnostics/tests/inference/constraints/wrongExpectedTypeForWhen.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes")
      @TestDataPath("$PROJECT_ROOT")
      public class EmptyIntersectionTypes {
        @Test
        public void testAllFilesPresentInEmptyIntersectionTypes() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("compatibilityResolveWhenVariableHasComplexIntersectionType.kt")
        public void testCompatibilityResolveWhenVariableHasComplexIntersectionType() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/compatibilityResolveWhenVariableHasComplexIntersectionType.kt");
        }

        @Test
        @TestMetadata("contravariance.kt")
        public void testContravariance() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/contravariance.kt");
        }

        @Test
        @TestMetadata("covariance.kt")
        public void testCovariance() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/covariance.kt");
        }

        @Test
        @TestMetadata("emptyIntersectionOnIf.kt")
        public void testEmptyIntersectionOnIf() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/emptyIntersectionOnIf.kt");
        }

        @Test
        @TestMetadata("kt45461.kt")
        public void testKt45461() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461.kt");
        }

        @Test
        @TestMetadata("kt45461_10.kt")
        public void testKt45461_10() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_10.kt");
        }

        @Test
        @TestMetadata("kt45461_11.kt")
        public void testKt45461_11() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_11.kt");
        }

        @Test
        @TestMetadata("kt45461_12.kt")
        public void testKt45461_12() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_12.kt");
        }

        @Test
        @TestMetadata("kt45461_13.kt")
        public void testKt45461_13() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_13.kt");
        }

        @Test
        @TestMetadata("kt45461_14.kt")
        public void testKt45461_14() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_14.kt");
        }

        @Test
        @TestMetadata("kt45461_15.kt")
        public void testKt45461_15() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_15.kt");
        }

        @Test
        @TestMetadata("kt45461_16.kt")
        public void testKt45461_16() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_16.kt");
        }

        @Test
        @TestMetadata("kt45461_17.kt")
        public void testKt45461_17() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_17.kt");
        }

        @Test
        @TestMetadata("kt45461_18.kt")
        public void testKt45461_18() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_18.kt");
        }

        @Test
        @TestMetadata("kt45461_19.kt")
        public void testKt45461_19() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_19.kt");
        }

        @Test
        @TestMetadata("kt45461_2.kt")
        public void testKt45461_2() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_2.kt");
        }

        @Test
        @TestMetadata("kt45461_20.kt")
        public void testKt45461_20() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_20.kt");
        }

        @Test
        @TestMetadata("kt45461_21.kt")
        public void testKt45461_21() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_21.kt");
        }

        @Test
        @TestMetadata("kt45461_22.kt")
        public void testKt45461_22() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_22.kt");
        }

        @Test
        @TestMetadata("kt45461_23.kt")
        public void testKt45461_23() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_23.kt");
        }

        @Test
        @TestMetadata("kt45461_24.kt")
        public void testKt45461_24() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_24.kt");
        }

        @Test
        @TestMetadata("kt45461_25.kt")
        public void testKt45461_25() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_25.kt");
        }

        @Test
        @TestMetadata("kt45461_26.kt")
        public void testKt45461_26() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_26.kt");
        }

        @Test
        @TestMetadata("kt45461_27.kt")
        public void testKt45461_27() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_27.kt");
        }

        @Test
        @TestMetadata("kt45461_28.kt")
        public void testKt45461_28() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_28.kt");
        }

        @Test
        @TestMetadata("kt45461_29.kt")
        public void testKt45461_29() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_29.kt");
        }

        @Test
        @TestMetadata("kt45461_3.kt")
        public void testKt45461_3() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_3.kt");
        }

        @Test
        @TestMetadata("kt45461_30.kt")
        public void testKt45461_30() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_30.kt");
        }

        @Test
        @TestMetadata("kt45461_31.kt")
        public void testKt45461_31() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_31.kt");
        }

        @Test
        @TestMetadata("kt45461_32.kt")
        public void testKt45461_32() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_32.kt");
        }

        @Test
        @TestMetadata("kt45461_33.kt")
        public void testKt45461_33() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_33.kt");
        }

        @Test
        @TestMetadata("kt45461_34.kt")
        public void testKt45461_34() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_34.kt");
        }

        @Test
        @TestMetadata("kt45461_35.kt")
        public void testKt45461_35() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_35.kt");
        }

        @Test
        @TestMetadata("kt45461_35_Enabled.kt")
        public void testKt45461_35_Enabled() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_35_Enabled.kt");
        }

        @Test
        @TestMetadata("kt45461_4.kt")
        public void testKt45461_4() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_4.kt");
        }

        @Test
        @TestMetadata("kt45461_5.kt")
        public void testKt45461_5() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_5.kt");
        }

        @Test
        @TestMetadata("kt45461_6.kt")
        public void testKt45461_6() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_6.kt");
        }

        @Test
        @TestMetadata("kt45461_7.kt")
        public void testKt45461_7() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_7.kt");
        }

        @Test
        @TestMetadata("kt45461_8.kt")
        public void testKt45461_8() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_8.kt");
        }

        @Test
        @TestMetadata("kt45461_9.kt")
        public void testKt45461_9() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_9.kt");
        }

        @Test
        @TestMetadata("kt48765.kt")
        public void testKt48765() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48765.kt");
        }

        @Test
        @TestMetadata("kt48935.kt")
        public void testKt48935() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48935.kt");
        }

        @Test
        @TestMetadata("kt48935_2.kt")
        public void testKt48935_2() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48935_2.kt");
        }

        @Test
        @TestMetadata("kt48935_3.kt")
        public void testKt48935_3() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48935_3.kt");
        }

        @Test
        @TestMetadata("kt48935_4.kt")
        public void testKt48935_4() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48935_4.kt");
        }

        @Test
        @TestMetadata("kt48935_5.kt")
        public void testKt48935_5() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48935_5.kt");
        }

        @Test
        @TestMetadata("kt48935_6.kt")
        public void testKt48935_6() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48935_6.kt");
        }

        @Test
        @TestMetadata("kt48987.kt")
        public void testKt48987() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48987.kt");
        }

        @Test
        @TestMetadata("kt49661.kt")
        public void testKt49661() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt49661.kt");
        }

        @Test
        @TestMetadata("kt51016.kt")
        public void testKt51016() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt51016.kt");
        }

        @Test
        @TestMetadata("kt52364.kt")
        public void testKt52364() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt52364.kt");
        }

        @Test
        @TestMetadata("kt52393.kt")
        public void testKt52393() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt52393.kt");
        }

        @Test
        @TestMetadata("kt52431.kt")
        public void testKt52431() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt52431.kt");
        }

        @Test
        @TestMetadata("kt54411.kt")
        public void testKt54411() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt54411.kt");
        }

        @Test
        @TestMetadata("nullableEmptyIntersection.kt")
        public void testNullableEmptyIntersection() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/nullableEmptyIntersection.kt");
        }

        @Test
        @TestMetadata("recursiveTypeParameters.kt")
        public void testRecursiveTypeParameters() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/recursiveTypeParameters.kt");
        }

        @Test
        @TestMetadata("selectFromCovariantAndContravariantTypes.kt")
        public void testSelectFromCovariantAndContravariantTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/selectFromCovariantAndContravariantTypes.kt");
        }

        @Test
        @TestMetadata("substitutingSuperTypes.kt")
        public void testSubstitutingSuperTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/substitutingSuperTypes.kt");
        }

        @Test
        @TestMetadata("substitutingSuperTypes2.kt")
        public void testSubstitutingSuperTypes2() {
          runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/substitutingSuperTypes2.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/forks")
      @TestDataPath("$PROJECT_ROOT")
      public class Forks {
        @Test
        public void testAllFilesPresentInForks() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/forks"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("failForkPointWhenNoneOfThemSuccessful.kt")
        public void testFailForkPointWhenNoneOfThemSuccessful() {
          runTest("compiler/testData/diagnostics/tests/inference/forks/failForkPointWhenNoneOfThemSuccessful.kt");
        }

        @Test
        @TestMetadata("forkInWhen.kt")
        public void testForkInWhen() {
          runTest("compiler/testData/diagnostics/tests/inference/forks/forkInWhen.kt");
        }

        @Test
        @TestMetadata("kt75444Original.kt")
        public void testKt75444Original() {
          runTest("compiler/testData/diagnostics/tests/inference/forks/kt75444Original.kt");
        }

        @Test
        @TestMetadata("nestedCallVariableFixation.kt")
        public void testNestedCallVariableFixation() {
          runTest("compiler/testData/diagnostics/tests/inference/forks/nestedCallVariableFixation.kt");
        }

        @Test
        @TestMetadata("nestedCallVariableFixationSimple.kt")
        public void testNestedCallVariableFixationSimple() {
          runTest("compiler/testData/diagnostics/tests/inference/forks/nestedCallVariableFixationSimple.kt");
        }

        @Test
        @TestMetadata("overloadResolutionByLambdaReturnTypeAndExpectedType.kt")
        public void testOverloadResolutionByLambdaReturnTypeAndExpectedType() {
          runTest("compiler/testData/diagnostics/tests/inference/forks/overloadResolutionByLambdaReturnTypeAndExpectedType.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/incorporation")
      @TestDataPath("$PROJECT_ROOT")
      public class Incorporation {
        @Test
        public void testAllFilesPresentInIncorporation() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/incorporation"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("allowBigIncorporatedConstraints.kt")
        public void testAllowBigIncorporatedConstraints() {
          runTest("compiler/testData/diagnostics/tests/inference/incorporation/allowBigIncorporatedConstraints.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls")
      @TestDataPath("$PROJECT_ROOT")
      public class NestedCalls {
        @Test
        public void testAllFilesPresentInNestedCalls() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/nestedCalls"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("arrayAccess.kt")
        public void testArrayAccess() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/arrayAccess.kt");
        }

        @Test
        @TestMetadata("binaryExpressions.kt")
        public void testBinaryExpressions() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/binaryExpressions.kt");
        }

        @Test
        @TestMetadata("checkTypesForQualifiedProperties.kt")
        public void testCheckTypesForQualifiedProperties() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/checkTypesForQualifiedProperties.kt");
        }

        @Test
        @TestMetadata("completeNestedCallsForArraySetExpression.kt")
        public void testCompleteNestedCallsForArraySetExpression() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/completeNestedCallsForArraySetExpression.kt");
        }

        @Test
        @TestMetadata("completeNestedCallsInference.kt")
        public void testCompleteNestedCallsInference() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/completeNestedCallsInference.kt");
        }

        @Test
        @TestMetadata("completeNestedForVariableAsFunctionCall.kt")
        public void testCompleteNestedForVariableAsFunctionCall() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/completeNestedForVariableAsFunctionCall.kt");
        }

        @Test
        @TestMetadata("externalTypeParameter.kt")
        public void testExternalTypeParameter() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/externalTypeParameter.kt");
        }

        @Test
        @TestMetadata("inferenceForNestedBinaryCall.kt")
        public void testInferenceForNestedBinaryCall() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/inferenceForNestedBinaryCall.kt");
        }

        @Test
        @TestMetadata("kt3395.kt")
        public void testKt3395() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/kt3395.kt");
        }

        @Test
        @TestMetadata("kt3461checkTypes.kt")
        public void testKt3461checkTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/kt3461checkTypes.kt");
        }

        @Test
        @TestMetadata("makeNullableIfSafeCall.kt")
        public void testMakeNullableIfSafeCall() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/makeNullableIfSafeCall.kt");
        }

        @Test
        @TestMetadata("nontrivialCallExpression.kt")
        public void testNontrivialCallExpression() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/nontrivialCallExpression.kt");
        }

        @Test
        @TestMetadata("preferArgumentToNullability.kt")
        public void testPreferArgumentToNullability() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/preferArgumentToNullability.kt");
        }

        @Test
        @TestMetadata("preferNothingToBound.kt")
        public void testPreferNothingToBound() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/preferNothingToBound.kt");
        }

        @Test
        @TestMetadata("secondLambdaWithRevisableExpectedType.kt")
        public void testSecondLambdaWithRevisableExpectedType() {
          runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/secondLambdaWithRevisableExpectedType.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/nothingType")
      @TestDataPath("$PROJECT_ROOT")
      public class NothingType {
        @Test
        public void testAllFilesPresentInNothingType() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/nothingType"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("complexDependancyOnVariableWithTrivialConstraint.kt")
        public void testComplexDependancyOnVariableWithTrivialConstraint() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/complexDependancyOnVariableWithTrivialConstraint.kt");
        }

        @Test
        @TestMetadata("discriminateNothingForReifiedParameter.kt")
        public void testDiscriminateNothingForReifiedParameter() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/discriminateNothingForReifiedParameter.kt");
        }

        @Test
        @TestMetadata("discriminatedNothingAndSmartCast.kt")
        public void testDiscriminatedNothingAndSmartCast() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/discriminatedNothingAndSmartCast.kt");
        }

        @Test
        @TestMetadata("discriminatedNothingInsideComplexNestedCall.kt")
        public void testDiscriminatedNothingInsideComplexNestedCall() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/discriminatedNothingInsideComplexNestedCall.kt");
        }

        @Test
        @TestMetadata("generateConstraintWithInnerNothingType.kt")
        public void testGenerateConstraintWithInnerNothingType() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/generateConstraintWithInnerNothingType.kt");
        }

        @Test
        @TestMetadata("genericOverride.kt")
        public void testGenericOverride() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/genericOverride.kt");
        }

        @Test
        @TestMetadata("implicitInferenceTToFlexibleNothing.kt")
        public void testImplicitInferenceTToFlexibleNothing() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/implicitInferenceTToFlexibleNothing.kt");
        }

        @Test
        @TestMetadata("implicitNothingConstraintFromReturn.kt")
        public void testImplicitNothingConstraintFromReturn() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/implicitNothingConstraintFromReturn.kt");
        }

        @Test
        @TestMetadata("inferArgumentToNothingFromNullConstant.kt")
        public void testInferArgumentToNothingFromNullConstant() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/inferArgumentToNothingFromNullConstant.kt");
        }

        @Test
        @TestMetadata("inferenceWithRecursiveGenericsAndNothing.kt")
        public void testInferenceWithRecursiveGenericsAndNothing() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/inferenceWithRecursiveGenericsAndNothing.kt");
        }

        @Test
        @TestMetadata("kt24490.kt")
        public void testKt24490() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt24490.kt");
        }

        @Test
        @TestMetadata("kt32051.kt")
        public void testKt32051() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt32051.kt");
        }

        @Test
        @TestMetadata("kt32081.kt")
        public void testKt32081() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt32081.kt");
        }

        @Test
        @TestMetadata("kt32207.kt")
        public void testKt32207() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt32207.kt");
        }

        @Test
        @TestMetadata("kt32388.kt")
        public void testKt32388() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt32388.kt");
        }

        @Test
        @TestMetadata("kt34335.kt")
        public void testKt34335() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt34335.kt");
        }

        @Test
        @TestMetadata("kt56448.kt")
        public void testKt56448() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt56448.kt");
        }

        @Test
        @TestMetadata("lambdaNothingAndExpectedType.kt")
        public void testLambdaNothingAndExpectedType() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/lambdaNothingAndExpectedType.kt");
        }

        @Test
        @TestMetadata("nestedLambdaInferenceWithIncorporationOfVariables.kt")
        public void testNestedLambdaInferenceWithIncorporationOfVariables() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/nestedLambdaInferenceWithIncorporationOfVariables.kt");
        }

        @Test
        @TestMetadata("notEnoughInformationAndNothing.kt")
        public void testNotEnoughInformationAndNothing() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/notEnoughInformationAndNothing.kt");
        }

        @Test
        @TestMetadata("notEnoughInformationFromNullabilityConstraint.kt")
        public void testNotEnoughInformationFromNullabilityConstraint() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/notEnoughInformationFromNullabilityConstraint.kt");
        }

        @Test
        @TestMetadata("nothingWithCallableReference.kt")
        public void testNothingWithCallableReference() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/nothingWithCallableReference.kt");
        }

        @Test
        @TestMetadata("nullableExpectedTypeFromVariable.kt")
        public void testNullableExpectedTypeFromVariable() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/nullableExpectedTypeFromVariable.kt");
        }

        @Test
        @TestMetadata("platformNothingAsUsefulConstraint.kt")
        public void testPlatformNothingAsUsefulConstraint() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/platformNothingAsUsefulConstraint.kt");
        }

        @Test
        @TestMetadata("reifiedParameterWithRecursiveBound.kt")
        public void testReifiedParameterWithRecursiveBound() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/reifiedParameterWithRecursiveBound.kt");
        }

        @Test
        @TestMetadata("reportImplicitNothingOnlyForOwnTypeParameters.kt")
        public void testReportImplicitNothingOnlyForOwnTypeParameters() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/reportImplicitNothingOnlyForOwnTypeParameters.kt");
        }

        @Test
        @TestMetadata("returnAsLastStatementInLambda.kt")
        public void testReturnAsLastStatementInLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/returnAsLastStatementInLambda.kt");
        }

        @Test
        @TestMetadata("selectWithNull.kt")
        public void testSelectWithNull() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/selectWithNull.kt");
        }

        @Test
        @TestMetadata("specialCallWithMaterializeAndExpectedType.kt")
        public void testSpecialCallWithMaterializeAndExpectedType() {
          runTest("compiler/testData/diagnostics/tests/inference/nothingType/specialCallWithMaterializeAndExpectedType.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/operators")
      @TestDataPath("$PROJECT_ROOT")
      public class Operators {
        @Test
        public void testAllFilesPresentInOperators() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/operators"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("elvisWithExpectedType.kt")
        public void testElvisWithExpectedType() {
          runTest("compiler/testData/diagnostics/tests/inference/operators/elvisWithExpectedType.kt");
        }

        @Test
        @TestMetadata("elvisWithExpectedTypeComplex.kt")
        public void testElvisWithExpectedTypeComplex() {
          runTest("compiler/testData/diagnostics/tests/inference/operators/elvisWithExpectedTypeComplex.kt");
        }

        @Test
        @TestMetadata("elvisWithUnitExpectedTypeAndNonUnitLHS.kt")
        public void testElvisWithUnitExpectedTypeAndNonUnitLHS() {
          runTest("compiler/testData/diagnostics/tests/inference/operators/elvisWithUnitExpectedTypeAndNonUnitLHS.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla")
      @TestDataPath("$PROJECT_ROOT")
      public class Pcla {
        @Test
        public void testAllFilesPresentInPcla() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("assignmentOperatorAmbiguity.kt")
        public void testAssignmentOperatorAmbiguity() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/assignmentOperatorAmbiguity.kt");
        }

        @Test
        @TestMetadata("assignmentPlusOperator.kt")
        public void testAssignmentPlusOperator() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/assignmentPlusOperator.kt");
        }

        @Test
        @TestMetadata("assignmentUsingIncompletePCLACall.kt")
        public void testAssignmentUsingIncompletePCLACall() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/assignmentUsingIncompletePCLACall.kt");
        }

        @Test
        @TestMetadata("bothOuterAndProperConstraints.kt")
        public void testBothOuterAndProperConstraints() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/bothOuterAndProperConstraints.kt");
        }

        @Test
        @TestMetadata("bothReceiverAndValueParameterNotFixed.kt")
        public void testBothReceiverAndValueParameterNotFixed() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/bothReceiverAndValueParameterNotFixed.kt");
        }

        @Test
        @TestMetadata("builderInferenceAnnotationInLambdaWithTVExpectedType.kt")
        public void testBuilderInferenceAnnotationInLambdaWithTVExpectedType() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/builderInferenceAnnotationInLambdaWithTVExpectedType.kt");
        }

        @Test
        @TestMetadata("builderPassedAsNamedArgument.kt")
        public void testBuilderPassedAsNamedArgument() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/builderPassedAsNamedArgument.kt");
        }

        @Test
        @TestMetadata("callableReferenceAsArgumentForTransaction.kt")
        public void testCallableReferenceAsArgumentForTransaction() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/callableReferenceAsArgumentForTransaction.kt");
        }

        @Test
        @TestMetadata("callableReferenceInsideInvokeCall.kt")
        public void testCallableReferenceInsideInvokeCall() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/callableReferenceInsideInvokeCall.kt");
        }

        @Test
        @TestMetadata("changingResolveIfDontUseBuilderInference.kt")
        public void testChangingResolveIfDontUseBuilderInference() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/changingResolveIfDontUseBuilderInference.kt");
        }

        @Test
        @TestMetadata("considerContractsOfIncompleteCalls.kt")
        public void testConsiderContractsOfIncompleteCalls() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/considerContractsOfIncompleteCalls.kt");
        }

        @Test
        @TestMetadata("contextReceivers.kt")
        public void testContextReceivers() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/contextReceivers.kt");
        }

        @Test
        @TestMetadata("elvisWithNothingRHS.kt")
        public void testElvisWithNothingRHS() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/elvisWithNothingRHS.kt");
        }

        @Test
        @TestMetadata("elvisWithReturnInLastStatementOfLastLambda.kt")
        public void testElvisWithReturnInLastStatementOfLastLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/elvisWithReturnInLastStatementOfLastLambda.kt");
        }

        @Test
        @TestMetadata("equalityChecksOnIntegerTypes.kt")
        public void testEqualityChecksOnIntegerTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/equalityChecksOnIntegerTypes.kt");
        }

        @Test
        @TestMetadata("equalityChecksOnIntegerTypesProgressive.kt")
        public void testEqualityChecksOnIntegerTypesProgressive() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/equalityChecksOnIntegerTypesProgressive.kt");
        }

        @Test
        @TestMetadata("errorOnStubReceiver.kt")
        public void testErrorOnStubReceiver() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/errorOnStubReceiver.kt");
        }

        @Test
        @TestMetadata("fixingDependentVariablesForReceivers.kt")
        public void testFixingDependentVariablesForReceivers() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/fixingDependentVariablesForReceivers.kt");
        }

        @Test
        @TestMetadata("fixingDependentVariablesForReceiversInitial.kt")
        public void testFixingDependentVariablesForReceiversInitial() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/fixingDependentVariablesForReceiversInitial.kt");
        }

        @Test
        @TestMetadata("fixingTVForLambadaWithShallowDependencyToOuter.kt")
        public void testFixingTVForLambadaWithShallowDependencyToOuter() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/fixingTVForLambadaWithShallowDependencyToOuter.kt");
        }

        @Test
        @TestMetadata("fixingTVForLambadaWithShallowDependencyToOuter2.kt")
        public void testFixingTVForLambadaWithShallowDependencyToOuter2() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/fixingTVForLambadaWithShallowDependencyToOuter2.kt");
        }

        @Test
        @TestMetadata("fixingTVForLambadaWithShallowDependencyToOuter3.kt")
        public void testFixingTVForLambadaWithShallowDependencyToOuter3() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/fixingTVForLambadaWithShallowDependencyToOuter3.kt");
        }

        @Test
        @TestMetadata("incompleteCallInReturnArgumentsWithProperExpectType.kt")
        public void testIncompleteCallInReturnArgumentsWithProperExpectType() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/incompleteCallInReturnArgumentsWithProperExpectType.kt");
        }

        @Test
        @TestMetadata("innerTvFixationFromLowerConstraints.kt")
        public void testInnerTvFixationFromLowerConstraints() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/innerTvFixationFromLowerConstraints.kt");
        }

        @Test
        @TestMetadata("invalidateKeys.kt")
        public void testInvalidateKeys() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/invalidateKeys.kt");
        }

        @Test
        @TestMetadata("invokeExtensionReceiverWithNotFixedVariables.kt")
        public void testInvokeExtensionReceiverWithNotFixedVariables() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/invokeExtensionReceiverWithNotFixedVariables.kt");
        }

        @Test
        @TestMetadata("invokeExtensionReceiverWithNotFixedVariablesInitial.kt")
        public void testInvokeExtensionReceiverWithNotFixedVariablesInitial() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/invokeExtensionReceiverWithNotFixedVariablesInitial.kt");
        }

        @Test
        @TestMetadata("kt69040.kt")
        public void testKt69040() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/kt69040.kt");
        }

        @Test
        @TestMetadata("labaledCall.kt")
        public void testLabaledCall() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/labaledCall.kt");
        }

        @Test
        @TestMetadata("lambdaBelongsToOuterCall.kt")
        public void testLambdaBelongsToOuterCall() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/lambdaBelongsToOuterCall.kt");
        }

        @Test
        @TestMetadata("lambdaBelongsToOuterCallAdditionalFixedVariable.kt")
        public void testLambdaBelongsToOuterCallAdditionalFixedVariable() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/lambdaBelongsToOuterCallAdditionalFixedVariable.kt");
        }

        @Test
        @TestMetadata("lambdaBelongsToOuterCallUnitConstraint.kt")
        public void testLambdaBelongsToOuterCallUnitConstraint() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/lambdaBelongsToOuterCallUnitConstraint.kt");
        }

        @Test
        @TestMetadata("lambdaParameterForBareType.kt")
        public void testLambdaParameterForBareType() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/lambdaParameterForBareType.kt");
        }

        @Test
        @TestMetadata("lambdaParameterForBareTypeAs.kt")
        public void testLambdaParameterForBareTypeAs() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/lambdaParameterForBareTypeAs.kt");
        }

        @Test
        @TestMetadata("lambdaParameterForBareTypeEarlyFixationAffectsBehavior.kt")
        public void testLambdaParameterForBareTypeEarlyFixationAffectsBehavior() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/lambdaParameterForBareTypeEarlyFixationAffectsBehavior.kt");
        }

        @Test
        @TestMetadata("lambdaParameterForBareTypeOnOuterTypeVariable.kt")
        public void testLambdaParameterForBareTypeOnOuterTypeVariable() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/lambdaParameterForBareTypeOnOuterTypeVariable.kt");
        }

        @Test
        @TestMetadata("lambdaParameterForNonBareType.kt")
        public void testLambdaParameterForNonBareType() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/lambdaParameterForNonBareType.kt");
        }

        @Test
        @TestMetadata("lambdaParameterTypeFixation.kt")
        public void testLambdaParameterTypeFixation() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/lambdaParameterTypeFixation.kt");
        }

        @Test
        @TestMetadata("lastLambdaStatementWithFixedVariables.kt")
        public void testLastLambdaStatementWithFixedVariables() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/lastLambdaStatementWithFixedVariables.kt");
        }

        @Test
        @TestMetadata("manyArgsDifferentYields.kt")
        public void testManyArgsDifferentYields() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/manyArgsDifferentYields.kt");
        }

        @Test
        @TestMetadata("memberScopeOfCapturedTypeForPostponedCall.kt")
        public void testMemberScopeOfCapturedTypeForPostponedCall() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/memberScopeOfCapturedTypeForPostponedCall.kt");
        }

        @Test
        @TestMetadata("multiLambdaRestriction.kt")
        public void testMultiLambdaRestriction() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/multiLambdaRestriction.kt");
        }

        @Test
        @TestMetadata("multiLambdaRestrictionDisabled.kt")
        public void testMultiLambdaRestrictionDisabled() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/multiLambdaRestrictionDisabled.kt");
        }

        @Test
        @TestMetadata("namedArgumentToBeResolved.kt")
        public void testNamedArgumentToBeResolved() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/namedArgumentToBeResolved.kt");
        }

        @Test
        @TestMetadata("namedArgumentTypeSubstitution.kt")
        public void testNamedArgumentTypeSubstitution() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/namedArgumentTypeSubstitution.kt");
        }

        @Test
        @TestMetadata("nestedLambdaWithLastLambdaContainingCall.kt")
        public void testNestedLambdaWithLastLambdaContainingCall() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/nestedLambdaWithLastLambdaContainingCall.kt");
        }

        @Test
        @TestMetadata("nestedLambdaWithNonLastYieldStatement.kt")
        public void testNestedLambdaWithNonLastYieldStatement() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/nestedLambdaWithNonLastYieldStatement.kt");
        }

        @Test
        @TestMetadata("nestedLambdasWithOverloadResolutionByReturnType.kt")
        public void testNestedLambdasWithOverloadResolutionByReturnType() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/nestedLambdasWithOverloadResolutionByReturnType.kt");
        }

        @Test
        @TestMetadata("newTvFromLamdaAreNotCountedAsProper.kt")
        public void testNewTvFromLamdaAreNotCountedAsProper() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/newTvFromLamdaAreNotCountedAsProper.kt");
        }

        @Test
        @TestMetadata("noBuilderInferenceRestrictionReceiverInconsistency.kt")
        public void testNoBuilderInferenceRestrictionReceiverInconsistency() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/noBuilderInferenceRestrictionReceiverInconsistency.kt");
        }

        @Test
        @TestMetadata("overloadResolutionByLambdaReturnType.kt")
        public void testOverloadResolutionByLambdaReturnType() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/overloadResolutionByLambdaReturnType.kt");
        }

        @Test
        @TestMetadata("overloadResolutionByLambdaReturnTypeInsideBI.kt")
        public void testOverloadResolutionByLambdaReturnTypeInsideBI() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/overloadResolutionByLambdaReturnTypeInsideBI.kt");
        }

        @Test
        @TestMetadata("overloadResolutionWithTypeVariables.kt")
        public void testOverloadResolutionWithTypeVariables() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/overloadResolutionWithTypeVariables.kt");
        }

        @Test
        @TestMetadata("propertyInvokeInsidePCLALambda.kt")
        public void testPropertyInvokeInsidePCLALambda() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/propertyInvokeInsidePCLALambda.kt");
        }

        @Test
        @TestMetadata("propertySubstitution.kt")
        public void testPropertySubstitution() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/propertySubstitution.kt");
        }

        @Test
        @TestMetadata("semifixOuterVariable.kt")
        public void testSemifixOuterVariable() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/semifixOuterVariable.kt");
        }

        @Test
        @TestMetadata("semifixOuterVariableFeatureDisabled.kt")
        public void testSemifixOuterVariableFeatureDisabled() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/semifixOuterVariableFeatureDisabled.kt");
        }

        @Test
        @TestMetadata("simpleLambdaInCallWithAnotherLambdaWithBuilderInference.kt")
        public void testSimpleLambdaInCallWithAnotherLambdaWithBuilderInference() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/simpleLambdaInCallWithAnotherLambdaWithBuilderInference.kt");
        }

        @Test
        @TestMetadata("singleBranchConditionLastStatementInLambda.kt")
        public void testSingleBranchConditionLastStatementInLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/singleBranchConditionLastStatementInLambda.kt");
        }

        @Test
        @TestMetadata("skipedUnresolvedInBuilderInferenceWithStubReceiverType.kt")
        public void testSkipedUnresolvedInBuilderInferenceWithStubReceiverType() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/skipedUnresolvedInBuilderInferenceWithStubReceiverType.kt");
        }

        @Test
        @TestMetadata("smartCastOnBuilderController.kt")
        public void testSmartCastOnBuilderController() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/smartCastOnBuilderController.kt");
        }

        @Test
        @TestMetadata("specialCallsWithCallableReferences.kt")
        public void testSpecialCallsWithCallableReferences() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/specialCallsWithCallableReferences.kt");
        }

        @Test
        @TestMetadata("specialCallsWithCallableReferencesDontCareTypeInBlockExression.kt")
        public void testSpecialCallsWithCallableReferencesDontCareTypeInBlockExression() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/specialCallsWithCallableReferencesDontCareTypeInBlockExression.kt");
        }

        @Test
        @TestMetadata("specialCallsWithCallableReferencesDontRewriteAtSlice.kt")
        public void testSpecialCallsWithCallableReferencesDontRewriteAtSlice() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/specialCallsWithCallableReferencesDontRewriteAtSlice.kt");
        }

        @Test
        @TestMetadata("specialCallsWithCallableReferencesErrorType.kt")
        public void testSpecialCallsWithCallableReferencesErrorType() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/specialCallsWithCallableReferencesErrorType.kt");
        }

        @Test
        @TestMetadata("specialCallsWithCallableReferencesErrorTypeUnrestricted.kt")
        public void testSpecialCallsWithCallableReferencesErrorTypeUnrestricted() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/specialCallsWithCallableReferencesErrorTypeUnrestricted.kt");
        }

        @Test
        @TestMetadata("specialCallsWithCallableReferencesNonStrictOnlyInputTypes.kt")
        public void testSpecialCallsWithCallableReferencesNonStrictOnlyInputTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/specialCallsWithCallableReferencesNonStrictOnlyInputTypes.kt");
        }

        @Test
        @TestMetadata("specialCallsWithCallableReferencesUnrestricted.kt")
        public void testSpecialCallsWithCallableReferencesUnrestricted() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/specialCallsWithCallableReferencesUnrestricted.kt");
        }

        @Test
        @TestMetadata("specialCallsWithLambdas.kt")
        public void testSpecialCallsWithLambdas() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/specialCallsWithLambdas.kt");
        }

        @Test
        @TestMetadata("substitutedSyntheticPropertyUsage.kt")
        public void testSubstitutedSyntheticPropertyUsage() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/substitutedSyntheticPropertyUsage.kt");
        }

        @Test
        @TestMetadata("theSimplestBuilder.kt")
        public void testTheSimplestBuilder() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/theSimplestBuilder.kt");
        }

        @Test
        @TestMetadata("unitElvisLikeWithRun.kt")
        public void testUnitElvisLikeWithRun() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/unitElvisLikeWithRun.kt");
        }

        @Test
        @TestMetadata("unitElvisWithRun.kt")
        public void testUnitElvisWithRun() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/unitElvisWithRun.kt");
        }

        @Test
        @TestMetadata("whenWithPropertyHavingSomePCLACallsWithinInitializer.kt")
        public void testWhenWithPropertyHavingSomePCLACallsWithinInitializer() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/whenWithPropertyHavingSomePCLACallsWithinInitializer.kt");
        }

        @Test
        @TestMetadata("withoutAnnotationDisabledFeature.kt")
        public void testWithoutAnnotationDisabledFeature() {
          runTest("compiler/testData/diagnostics/tests/inference/pcla/withoutAnnotationDisabledFeature.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/additional")
        @TestDataPath("$PROJECT_ROOT")
        public class Additional {
          @Test
          public void testAllFilesPresentInAdditional() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/additional"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("BuildeeSupertypeAsTypeVariableSourceInClassifiers.kt")
          public void testBuildeeSupertypeAsTypeVariableSourceInClassifiers() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/additional/BuildeeSupertypeAsTypeVariableSourceInClassifiers.kt");
          }

          @Test
          @TestMetadata("BuildeeSupertypeAsTypeVariableSourceInFunctions.kt")
          public void testBuildeeSupertypeAsTypeVariableSourceInFunctions() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/additional/BuildeeSupertypeAsTypeVariableSourceInFunctions.kt");
          }

          @Test
          @TestMetadata("BuildeeSupertypeAsTypeVariableSourceInProperties.kt")
          public void testBuildeeSupertypeAsTypeVariableSourceInProperties() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/additional/BuildeeSupertypeAsTypeVariableSourceInProperties.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/constraints")
        @TestDataPath("$PROJECT_ROOT")
        public class Constraints {
          @Test
          public void testAllFilesPresentInConstraints() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/constraints"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("violating.kt")
          public void testViolating() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/constraints/violating.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/csForks")
        @TestDataPath("$PROJECT_ROOT")
        public class CsForks {
          @Test
          public void testAllFilesPresentInCsForks() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/csForks"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("postponingForksNecessary.kt")
          public void testPostponingForksNecessary() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/csForks/postponingForksNecessary.kt");
          }

          @Test
          @TestMetadata("postponingForksNecessaryWithLambda.kt")
          public void testPostponingForksNecessaryWithLambda() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/csForks/postponingForksNecessaryWithLambda.kt");
          }

          @Test
          @TestMetadata("relatedToOuter.kt")
          public void testRelatedToOuter() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/csForks/relatedToOuter.kt");
          }

          @Test
          @TestMetadata("relatedToOuterGreen.kt")
          public void testRelatedToOuterGreen() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/csForks/relatedToOuterGreen.kt");
          }

          @Test
          @TestMetadata("simple.kt")
          public void testSimple() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/csForks/simple.kt");
          }

          @Test
          @TestMetadata("simpleGreen.kt")
          public void testSimpleGreen() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/csForks/simpleGreen.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand")
        @TestDataPath("$PROJECT_ROOT")
        public class FixationOnDemand {
          @Test
          public void testAllFilesPresentInFixationOnDemand() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Nested
          @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/derivativeTypeVariables")
          @TestDataPath("$PROJECT_ROOT")
          public class DerivativeTypeVariables {
            @Test
            public void testAllFilesPresentInDerivativeTypeVariables() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/derivativeTypeVariables"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
            }

            @Test
            @TestMetadata("ArgumentForSubtypeOfPCLALambdaTV.kt")
            public void testArgumentForSubtypeOfPCLALambdaTV() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/derivativeTypeVariables/ArgumentForSubtypeOfPCLALambdaTV.kt");
            }

            @Test
            @TestMetadata("ArgumentForSupertypeOfPCLALambdaTV.kt")
            public void testArgumentForSupertypeOfPCLALambdaTV() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/derivativeTypeVariables/ArgumentForSupertypeOfPCLALambdaTV.kt");
            }

            @Test
            @TestMetadata("DeepEquivalent.kt")
            public void testDeepEquivalent() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/derivativeTypeVariables/DeepEquivalent.kt");
            }

            @Test
            @TestMetadata("DeepSubtypeOfPCLALambdaTV.kt")
            public void testDeepSubtypeOfPCLALambdaTV() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/derivativeTypeVariables/DeepSubtypeOfPCLALambdaTV.kt");
            }

            @Test
            @TestMetadata("DeepSupertypeOfPCLALambdaTV.kt")
            public void testDeepSupertypeOfPCLALambdaTV() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/derivativeTypeVariables/DeepSupertypeOfPCLALambdaTV.kt");
            }

            @Test
            @TestMetadata("PCLALambdaTVAsArgumentForSubtype.kt")
            public void testPCLALambdaTVAsArgumentForSubtype() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/derivativeTypeVariables/PCLALambdaTVAsArgumentForSubtype.kt");
            }

            @Test
            @TestMetadata("PCLALambdaTVAsArgumentForSupertype.kt")
            public void testPCLALambdaTVAsArgumentForSupertype() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/derivativeTypeVariables/PCLALambdaTVAsArgumentForSupertype.kt");
            }

            @Test
            @TestMetadata("ShallowEquivalent.kt")
            public void testShallowEquivalent() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/derivativeTypeVariables/ShallowEquivalent.kt");
            }

            @Test
            @TestMetadata("ShallowSubtypeOfPCLALambdaTV.kt")
            public void testShallowSubtypeOfPCLALambdaTV() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/derivativeTypeVariables/ShallowSubtypeOfPCLALambdaTV.kt");
            }

            @Test
            @TestMetadata("ShallowSupertypeOfPCLALambdaTV.kt")
            public void testShallowSupertypeOfPCLALambdaTV() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/derivativeTypeVariables/ShallowSupertypeOfPCLALambdaTV.kt");
            }
          }

          @Nested
          @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/miscellaneous")
          @TestDataPath("$PROJECT_ROOT")
          public class Miscellaneous {
            @Test
            public void testAllFilesPresentInMiscellaneous() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/miscellaneous"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
            }

            @Test
            @TestMetadata("BasicErrors.kt")
            public void testBasicErrors() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/miscellaneous/BasicErrors.kt");
            }

            @Test
            @TestMetadata("InnerDeclarationScope.kt")
            public void testInnerDeclarationScope() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/miscellaneous/InnerDeclarationScope.kt");
            }

            @Test
            @TestMetadata("NestedDependentPCLACall.kt")
            public void testNestedDependentPCLACall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/miscellaneous/NestedDependentPCLACall.kt");
            }

            @Test
            @TestMetadata("NestedIndependentPCLACall.kt")
            public void testNestedIndependentPCLACall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/miscellaneous/NestedIndependentPCLACall.kt");
            }

            @Test
            @TestMetadata("PCLACandidateShape.kt")
            public void testPCLACandidateShape() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/miscellaneous/PCLACandidateShape.kt");
            }

            @Test
            @TestMetadata("ResolutionToMemberOverExtension.kt")
            public void testResolutionToMemberOverExtension() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/miscellaneous/ResolutionToMemberOverExtension.kt");
            }
          }

          @Nested
          @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation")
          @TestDataPath("$PROJECT_ROOT")
          public class ScopeNavigation {
            @Test
            public void testAllFilesPresentInScopeNavigation() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/compositeTypes")
            @TestDataPath("$PROJECT_ROOT")
            public class CompositeTypes {
              @Test
              public void testAllFilesPresentInCompositeTypes() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/compositeTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
              }

              @Test
              @TestMetadata("ContravariantTypeVariableCapture.kt")
              public void testContravariantTypeVariableCapture() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/compositeTypes/ContravariantTypeVariableCapture.kt");
              }

              @Test
              @TestMetadata("CovariantTypeVariableCapture.kt")
              public void testCovariantTypeVariableCapture() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/compositeTypes/CovariantTypeVariableCapture.kt");
              }

              @Test
              @TestMetadata("DefinitelyNonNullTypeVariable.kt")
              public void testDefinitelyNonNullTypeVariable() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/compositeTypes/DefinitelyNonNullTypeVariable.kt");
              }

              @Test
              @TestMetadata("FlexibleTypeVariable.kt")
              public void testFlexibleTypeVariable() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/compositeTypes/FlexibleTypeVariable.kt");
              }

              @Test
              @TestMetadata("IntersectedTypeVariable.kt")
              public void testIntersectedTypeVariable() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/compositeTypes/IntersectedTypeVariable.kt");
              }

              @Test
              @TestMetadata("NullableTypeVariable.kt")
              public void testNullableTypeVariable() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/compositeTypes/NullableTypeVariable.kt");
              }

              @Test
              @TestMetadata("TypeVariableStarCapture.kt")
              public void testTypeVariableStarCapture() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/compositeTypes/TypeVariableStarCapture.kt");
              }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner")
            @TestDataPath("$PROJECT_ROOT")
            public class ConcreteScopeOwner {
              @Test
              public void testAllFilesPresentInConcreteScopeOwner() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
              }

              @Test
              @TestMetadata("AnyReceiverFunctionCall.kt")
              public void testAnyReceiverFunctionCall() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/AnyReceiverFunctionCall.kt");
              }

              @Test
              @TestMetadata("BasicCallableReference.kt")
              public void testBasicCallableReference() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/BasicCallableReference.kt");
              }

              @Test
              @TestMetadata("BasicPropertyAccess.kt")
              public void testBasicPropertyAccess() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/BasicPropertyAccess.kt");
              }

              @Test
              @TestMetadata("BasicPropertyAssignment.kt")
              public void testBasicPropertyAssignment() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/BasicPropertyAssignment.kt");
              }

              @Test
              @TestMetadata("ComplexCallableReference.kt")
              public void testComplexCallableReference() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/ComplexCallableReference.kt");
              }

              @Test
              @TestMetadata("ComplexPropertyAccess.kt")
              public void testComplexPropertyAccess() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/ComplexPropertyAccess.kt");
              }

              @Test
              @TestMetadata("ComplexPropertyAssignment.kt")
              public void testComplexPropertyAssignment() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/ComplexPropertyAssignment.kt");
              }

              @Test
              @TestMetadata("FunctionCall.kt")
              public void testFunctionCall() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/FunctionCall.kt");
              }

              @Test
              @TestMetadata("GenericCallableReference.kt")
              public void testGenericCallableReference() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/GenericCallableReference.kt");
              }

              @Test
              @TestMetadata("GenericFunctionCall.kt")
              public void testGenericFunctionCall() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/GenericFunctionCall.kt");
              }

              @Test
              @TestMetadata("GenericInnerClassConstructorCall.kt")
              public void testGenericInnerClassConstructorCall() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/GenericInnerClassConstructorCall.kt");
              }

              @Test
              @TestMetadata("GenericPropertyAccess.kt")
              public void testGenericPropertyAccess() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/GenericPropertyAccess.kt");
              }

              @Test
              @TestMetadata("GenericPropertyAssignment.kt")
              public void testGenericPropertyAssignment() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/GenericPropertyAssignment.kt");
              }

              @Test
              @TestMetadata("InnerClassConstructorCall.kt")
              public void testInnerClassConstructorCall() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/concreteScopeOwner/InnerClassConstructorCall.kt");
              }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner")
            @TestDataPath("$PROJECT_ROOT")
            public class GenericScopeOwner {
              @Test
              public void testAllFilesPresentInGenericScopeOwner() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
              }

              @Test
              @TestMetadata("AnyReceiverFunctionCall.kt")
              public void testAnyReceiverFunctionCall() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/AnyReceiverFunctionCall.kt");
              }

              @Test
              @TestMetadata("BasicCallableReference.kt")
              public void testBasicCallableReference() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/BasicCallableReference.kt");
              }

              @Test
              @TestMetadata("BasicPropertyAccess.kt")
              public void testBasicPropertyAccess() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/BasicPropertyAccess.kt");
              }

              @Test
              @TestMetadata("BasicPropertyAssignment.kt")
              public void testBasicPropertyAssignment() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/BasicPropertyAssignment.kt");
              }

              @Test
              @TestMetadata("ComplexCallableReference.kt")
              public void testComplexCallableReference() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/ComplexCallableReference.kt");
              }

              @Test
              @TestMetadata("ComplexPropertyAccess.kt")
              public void testComplexPropertyAccess() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/ComplexPropertyAccess.kt");
              }

              @Test
              @TestMetadata("ComplexPropertyAssignment.kt")
              public void testComplexPropertyAssignment() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/ComplexPropertyAssignment.kt");
              }

              @Test
              @TestMetadata("FunctionCall.kt")
              public void testFunctionCall() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/FunctionCall.kt");
              }

              @Test
              @TestMetadata("GenericCallableReference.kt")
              public void testGenericCallableReference() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/GenericCallableReference.kt");
              }

              @Test
              @TestMetadata("GenericFunctionCall.kt")
              public void testGenericFunctionCall() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/GenericFunctionCall.kt");
              }

              @Test
              @TestMetadata("GenericInnerClassConstructorCall.kt")
              public void testGenericInnerClassConstructorCall() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/GenericInnerClassConstructorCall.kt");
              }

              @Test
              @TestMetadata("GenericPropertyAccess.kt")
              public void testGenericPropertyAccess() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/GenericPropertyAccess.kt");
              }

              @Test
              @TestMetadata("GenericPropertyAssignment.kt")
              public void testGenericPropertyAssignment() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/GenericPropertyAssignment.kt");
              }

              @Test
              @TestMetadata("InnerClassConstructorCall.kt")
              public void testInnerClassConstructorCall() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/scopeNavigation/genericScopeOwner/InnerClassConstructorCall.kt");
              }
            }
          }

          @Nested
          @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms")
          @TestDataPath("$PROJECT_ROOT")
          public class SyntaxForms {
            @Test
            public void testAllFilesPresentInSyntaxForms() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
            }

            @Test
            @TestMetadata("CompareToOperatorCall.kt")
            public void testCompareToOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/CompareToOperatorCall.kt");
            }

            @Test
            @TestMetadata("ContainsOperatorCall.kt")
            public void testContainsOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/ContainsOperatorCall.kt");
            }

            @Test
            @TestMetadata("DestructuringDeclaration.kt")
            public void testDestructuringDeclaration() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/DestructuringDeclaration.kt");
            }

            @Test
            @TestMetadata("ForLoopContainerExpression.kt")
            public void testForLoopContainerExpression() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/ForLoopContainerExpression.kt");
            }

            @Test
            @TestMetadata("IndexingAssignment.kt")
            public void testIndexingAssignment() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/IndexingAssignment.kt");
            }

            @Test
            @TestMetadata("IndexingOperatorCall.kt")
            public void testIndexingOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/IndexingOperatorCall.kt");
            }

            @Test
            @TestMetadata("IndexingPlusAssignOperatorCall.kt")
            public void testIndexingPlusAssignOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/IndexingPlusAssignOperatorCall.kt");
            }

            @Test
            @TestMetadata("IndexingPlusOperatorAssignment.kt")
            public void testIndexingPlusOperatorAssignment() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/IndexingPlusOperatorAssignment.kt");
            }

            @Test
            @TestMetadata("InfixFunctionCall.kt")
            public void testInfixFunctionCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/InfixFunctionCall.kt");
            }

            @Test
            @TestMetadata("InvokeOperatorCall.kt")
            public void testInvokeOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/InvokeOperatorCall.kt");
            }

            @Test
            @TestMetadata("LogicalNotOperatorCall.kt")
            public void testLogicalNotOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/LogicalNotOperatorCall.kt");
            }

            @Test
            @TestMetadata("PlusAssignOperatorCall.kt")
            public void testPlusAssignOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/PlusAssignOperatorCall.kt");
            }

            @Test
            @TestMetadata("PlusOperatorAssignment.kt")
            public void testPlusOperatorAssignment() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/PlusOperatorAssignment.kt");
            }

            @Test
            @TestMetadata("PlusOperatorCall.kt")
            public void testPlusOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/PlusOperatorCall.kt");
            }

            @Test
            @TestMetadata("PostfixIncrementOperatorCall.kt")
            public void testPostfixIncrementOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/PostfixIncrementOperatorCall.kt");
            }

            @Test
            @TestMetadata("PrefixIncrementOperatorCall.kt")
            public void testPrefixIncrementOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/PrefixIncrementOperatorCall.kt");
            }

            @Test
            @TestMetadata("RangeOperatorCall.kt")
            public void testRangeOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/RangeOperatorCall.kt");
            }

            @Test
            @TestMetadata("ReferenceEqualityExpression.kt")
            public void testReferenceEqualityExpression() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/ReferenceEqualityExpression.kt");
            }

            @Test
            @TestMetadata("StringInterpolationExpression.kt")
            public void testStringInterpolationExpression() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/StringInterpolationExpression.kt");
            }

            @Test
            @TestMetadata("TypeCastExpression.kt")
            public void testTypeCastExpression() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/TypeCastExpression.kt");
            }

            @Test
            @TestMetadata("TypeCheckExpression.kt")
            public void testTypeCheckExpression() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/TypeCheckExpression.kt");
            }

            @Test
            @TestMetadata("UnarySignOperatorCall.kt")
            public void testUnarySignOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/UnarySignOperatorCall.kt");
            }

            @Test
            @TestMetadata("ValueEqualityOperatorCall.kt")
            public void testValueEqualityOperatorCall() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/ValueEqualityOperatorCall.kt");
            }

            @Test
            @TestMetadata("WhenExpression.kt")
            public void testWhenExpression() {
              runTest("compiler/testData/diagnostics/tests/inference/pcla/fixationOnDemand/syntaxForms/WhenExpression.kt");
            }
          }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/forceLambdaCompletionFromReturnStatement")
        @TestDataPath("$PROJECT_ROOT")
        public class ForceLambdaCompletionFromReturnStatement {
          @Test
          public void testAllFilesPresentInForceLambdaCompletionFromReturnStatement() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/forceLambdaCompletionFromReturnStatement"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("differentBehaviorWhenSpecifiedArgument.kt")
          public void testDifferentBehaviorWhenSpecifiedArgument() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/forceLambdaCompletionFromReturnStatement/differentBehaviorWhenSpecifiedArgument.kt");
          }

          @Test
          @TestMetadata("differentBehaviorWhenSpecifiedArgument20.kt")
          public void testDifferentBehaviorWhenSpecifiedArgument20() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/forceLambdaCompletionFromReturnStatement/differentBehaviorWhenSpecifiedArgument20.kt");
          }

          @Test
          @TestMetadata("earlyReturn.kt")
          public void testEarlyReturn() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/forceLambdaCompletionFromReturnStatement/earlyReturn.kt");
          }

          @Test
          @TestMetadata("earlyReturn20.kt")
          public void testEarlyReturn20() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/forceLambdaCompletionFromReturnStatement/earlyReturn20.kt");
          }

          @Test
          @TestMetadata("multiLambdas.kt")
          public void testMultiLambdas() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/forceLambdaCompletionFromReturnStatement/multiLambdas.kt");
          }

          @Test
          @TestMetadata("multiLambdas20.kt")
          public void testMultiLambdas20() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/forceLambdaCompletionFromReturnStatement/multiLambdas20.kt");
          }

          @Test
          @TestMetadata("noPostponedAtomForNestedLambda.kt")
          public void testNoPostponedAtomForNestedLambda() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/forceLambdaCompletionFromReturnStatement/noPostponedAtomForNestedLambda.kt");
          }

          @Test
          @TestMetadata("noPostponedAtomForNestedLambda20.kt")
          public void testNoPostponedAtomForNestedLambda20() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/forceLambdaCompletionFromReturnStatement/noPostponedAtomForNestedLambda20.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/issues")
        @TestDataPath("$PROJECT_ROOT")
        public class Issues {
          @Test
          public void testAllFilesPresentInIssues() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/issues"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("kt43710.kt")
          public void testKt43710() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt43710.kt");
          }

          @Test
          @TestMetadata("kt43710b.kt")
          public void testKt43710b() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt43710b.kt");
          }

          @Test
          @TestMetadata("kt47744.kt")
          public void testKt47744() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt47744.kt");
          }

          @Test
          @TestMetadata("kt47986Default.kt")
          public void testKt47986Default() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt47986Default.kt");
          }

          @Test
          @TestMetadata("kt47986Disabled.kt")
          public void testKt47986Disabled() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt47986Disabled.kt");
          }

          @Test
          @TestMetadata("kt47986Enabled.kt")
          public void testKt47986Enabled() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt47986Enabled.kt");
          }

          @Test
          @TestMetadata("kt47986_2.kt")
          public void testKt47986_2() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt47986_2.kt");
          }

          @Test
          @TestMetadata("kt47986_3.kt")
          public void testKt47986_3() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt47986_3.kt");
          }

          @Test
          @TestMetadata("kt47986_4.kt")
          public void testKt47986_4() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt47986_4.kt");
          }

          @Test
          @TestMetadata("kt47989a.kt")
          public void testKt47989a() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt47989a.kt");
          }

          @Test
          @TestMetadata("kt47989b.kt")
          public void testKt47989b() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt47989b.kt");
          }

          @Test
          @TestMetadata("kt48031.kt")
          public void testKt48031() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt48031.kt");
          }

          @Test
          @TestMetadata("kt49160a.kt")
          public void testKt49160a() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt49160a.kt");
          }

          @Test
          @TestMetadata("kt49160b.kt")
          public void testKt49160b() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt49160b.kt");
          }

          @Test
          @TestMetadata("kt49160c.kt")
          public void testKt49160c() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt49160c.kt");
          }

          @Test
          @TestMetadata("kt49160d.kt")
          public void testKt49160d() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt49160d.kt");
          }

          @Test
          @TestMetadata("kt49160e.kt")
          public void testKt49160e() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt49160e.kt");
          }

          @Test
          @TestMetadata("kt49263.kt")
          public void testKt49263() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt49263.kt");
          }

          @Test
          @TestMetadata("kt49285.kt")
          public void testKt49285() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt49285.kt");
          }

          @Test
          @TestMetadata("kt49828.kt")
          public void testKt49828() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt49828.kt");
          }

          @Test
          @TestMetadata("kt49829.kt")
          public void testKt49829() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt49829.kt");
          }

          @Test
          @TestMetadata("kt49829_noCast.kt")
          public void testKt49829_noCast() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt49829_noCast.kt");
          }

          @Test
          @TestMetadata("kt50453.kt")
          public void testKt50453() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt50453.kt");
          }

          @Test
          @TestMetadata("kt50498.kt")
          public void testKt50498() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt50498.kt");
          }

          @Test
          @TestMetadata("kt50827.kt")
          public void testKt50827() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt50827.kt");
          }

          @Test
          @TestMetadata("kt50989.kt")
          public void testKt50989() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt50989.kt");
          }

          @Test
          @TestMetadata("kt51148.kt")
          public void testKt51148() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt51148.kt");
          }

          @Test
          @TestMetadata("kt51464.kt")
          public void testKt51464() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt51464.kt");
          }

          @Test
          @TestMetadata("kt52757.kt")
          public void testKt52757() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt52757.kt");
          }

          @Test
          @TestMetadata("kt52838a.kt")
          public void testKt52838a() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt52838a.kt");
          }

          @Test
          @TestMetadata("kt52838b.kt")
          public void testKt52838b() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt52838b.kt");
          }

          @Test
          @TestMetadata("kt52838c.kt")
          public void testKt52838c() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt52838c.kt");
          }

          @Test
          @TestMetadata("kt53109.kt")
          public void testKt53109() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt53109.kt");
          }

          @Test
          @TestMetadata("kt53422.kt")
          public void testKt53422() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt53422.kt");
          }

          @Test
          @TestMetadata("kt53422a.kt")
          public void testKt53422a() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt53422a.kt");
          }

          @Test
          @TestMetadata("kt53422b.kt")
          public void testKt53422b() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt53422b.kt");
          }

          @Test
          @TestMetadata("kt53478.kt")
          public void testKt53478() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt53478.kt");
          }

          @Test
          @TestMetadata("kt53553.kt")
          public void testKt53553() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt53553.kt");
          }

          @Test
          @TestMetadata("kt53639.kt")
          public void testKt53639() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt53639.kt");
          }

          @Test
          @TestMetadata("kt53639Simple.kt")
          public void testKt53639Simple() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt53639Simple.kt");
          }

          @Test
          @TestMetadata("kt53740a.kt")
          public void testKt53740a() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt53740a.kt");
          }

          @Test
          @TestMetadata("kt53740b.kt")
          public void testKt53740b() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt53740b.kt");
          }

          @Test
          @TestMetadata("kt54400a.kt")
          public void testKt54400a() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt54400a.kt");
          }

          @Test
          @TestMetadata("kt54400b.kt")
          public void testKt54400b() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt54400b.kt");
          }

          @Test
          @TestMetadata("kt54400c.kt")
          public void testKt54400c() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt54400c.kt");
          }

          @Test
          @TestMetadata("kt54664.kt")
          public void testKt54664() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt54664.kt");
          }

          @Test
          @TestMetadata("kt54767a.kt")
          public void testKt54767a() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt54767a.kt");
          }

          @Test
          @TestMetadata("kt54767b.kt")
          public void testKt54767b() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt54767b.kt");
          }

          @Test
          @TestMetadata("kt55056.kt")
          public void testKt55056() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt55056.kt");
          }

          @Test
          @TestMetadata("kt55057.kt")
          public void testKt55057() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt55057.kt");
          }

          @Test
          @TestMetadata("kt55281.kt")
          public void testKt55281() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt55281.kt");
          }

          @Test
          @TestMetadata("kt56949.kt")
          public void testKt56949() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt56949.kt");
          }

          @Test
          @TestMetadata("kt57707.kt")
          public void testKt57707() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt57707.kt");
          }

          @Test
          @TestMetadata("kt57709.kt")
          public void testKt57709() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt57709.kt");
          }

          @Test
          @TestMetadata("kt57834.kt")
          public void testKt57834() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt57834.kt");
          }

          @Test
          @TestMetadata("kt59426.kt")
          public void testKt59426() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt59426.kt");
          }

          @Test
          @TestMetadata("kt59798.kt")
          public void testKt59798() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt59798.kt");
          }

          @Test
          @TestMetadata("kt60291a.kt")
          public void testKt60291a() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt60291a.kt");
          }

          @Test
          @TestMetadata("kt60291b.kt")
          public void testKt60291b() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt60291b.kt");
          }

          @Test
          @TestMetadata("kt60291c.kt")
          public void testKt60291c() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt60291c.kt");
          }

          @Test
          @TestMetadata("kt60447a.kt")
          public void testKt60447a() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt60447a.kt");
          }

          @Test
          @TestMetadata("kt60447b.kt")
          public void testKt60447b() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt60447b.kt");
          }

          @Test
          @TestMetadata("kt61310.kt")
          public void testKt61310() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt61310.kt");
          }

          @Test
          @TestMetadata("kt63648.kt")
          public void testKt63648() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt63648.kt");
          }

          @Test
          @TestMetadata("kt63733.kt")
          public void testKt63733() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt63733.kt");
          }

          @Test
          @TestMetadata("kt63840a.kt")
          public void testKt63840a() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt63840a.kt");
          }

          @Test
          @TestMetadata("kt63840b.kt")
          public void testKt63840b() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt63840b.kt");
          }

          @Test
          @TestMetadata("kt63840c.kt")
          public void testKt63840c() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt63840c.kt");
          }

          @Test
          @TestMetadata("kt63841.kt")
          public void testKt63841() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt63841.kt");
          }

          @Test
          @TestMetadata("kt64066.kt")
          public void testKt64066() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt64066.kt");
          }

          @Test
          @TestMetadata("kt64066disabled.kt")
          public void testKt64066disabled() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt64066disabled.kt");
          }

          @Test
          @TestMetadata("kt64077.kt")
          public void testKt64077() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt64077.kt");
          }

          @Test
          @TestMetadata("kt64222.kt")
          public void testKt64222() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt64222.kt");
          }

          @Test
          @TestMetadata("kt65300a.kt")
          public void testKt65300a() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt65300a.kt");
          }

          @Test
          @TestMetadata("kt65300b.kt")
          public void testKt65300b() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt65300b.kt");
          }

          @Test
          @TestMetadata("kt65300c.kt")
          public void testKt65300c() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt65300c.kt");
          }

          @Test
          @TestMetadata("kt65300d.kt")
          public void testKt65300d() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt65300d.kt");
          }

          @Test
          @TestMetadata("kt65300e.kt")
          public void testKt65300e() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt65300e.kt");
          }

          @Test
          @TestMetadata("kt65300f.kt")
          public void testKt65300f() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt65300f.kt");
          }

          @Test
          @TestMetadata("kt65300g.kt")
          public void testKt65300g() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt65300g.kt");
          }

          @Test
          @TestMetadata("kt65300h.kt")
          public void testKt65300h() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt65300h.kt");
          }

          @Test
          @TestMetadata("kt65300i.kt")
          public void testKt65300i() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt65300i.kt");
          }

          @Test
          @TestMetadata("kt65300j.kt")
          public void testKt65300j() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt65300j.kt");
          }

          @Test
          @TestMetadata("kt66229.kt")
          public void testKt66229() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt66229.kt");
          }

          @Test
          @TestMetadata("kt66243.kt")
          public void testKt66243() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt66243.kt");
          }

          @Test
          @TestMetadata("kt66272.kt")
          public void testKt66272() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt66272.kt");
          }

          @Test
          @TestMetadata("kt67875.kt")
          public void testKt67875() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt67875.kt");
          }

          @Test
          @TestMetadata("kt67993.kt")
          public void testKt67993() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt67993.kt");
          }

          @Test
          @TestMetadata("kt68889.kt")
          public void testKt68889() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt68889.kt");
          }

          @Test
          @TestMetadata("kt69170.kt")
          public void testKt69170() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt69170.kt");
          }

          @Test
          @TestMetadata("kt69170Original.kt")
          public void testKt69170Original() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt69170Original.kt");
          }

          @Test
          @TestMetadata("kt71662.kt")
          public void testKt71662() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt71662.kt");
          }

          @Test
          @TestMetadata("kt72238.kt")
          public void testKt72238() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt72238.kt");
          }

          @Test
          @TestMetadata("kt72272.kt")
          public void testKt72272() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/issues/kt72272.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/oneParameter")
        @TestDataPath("$PROJECT_ROOT")
        public class OneParameter {
          @Test
          public void testAllFilesPresentInOneParameter() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/oneParameter"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Nested
          @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable")
          @TestDataPath("$PROJECT_ROOT")
          public class OneTypeVariable {
            @Test
            public void testAllFilesPresentInOneTypeVariable() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin")
            @TestDataPath("$PROJECT_ROOT")
            public class OneTypeInfoOrigin {
              @Test
              public void testAllFilesPresentInOneTypeInfoOrigin() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
              }

              @Test
              @TestMetadata("AnonymousFunctionArgumentAndBuildeeReceiver.kt")
              public void testAnonymousFunctionArgumentAndBuildeeReceiver() {
                runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/AnonymousFunctionArgumentAndBuildeeReceiver.kt");
              }

              @Nested
              @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts")
              @TestDataPath("$PROJECT_ROOT")
              public class SourceSinkFeedContexts {
                @Test
                public void testAllFilesPresentInSourceSinkFeedContexts() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
                }

                @Test
                @TestMetadata("ByAssignmentToALocalVariableMaterializeCase.kt")
                public void testByAssignmentToALocalVariableMaterializeCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/ByAssignmentToALocalVariableMaterializeCase.kt");
                }

                @Test
                @TestMetadata("ByAssignmentToALocalVariableYieldCase.kt")
                public void testByAssignmentToALocalVariableYieldCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/ByAssignmentToALocalVariableYieldCase.kt");
                }

                @Test
                @TestMetadata("InsideLocalClass.kt")
                public void testInsideLocalClass() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/InsideLocalClass.kt");
                }

                @Test
                @TestMetadata("InsideNestedBuilderInferenceLambda.kt")
                public void testInsideNestedBuilderInferenceLambda() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/InsideNestedBuilderInferenceLambda.kt");
                }

                @Test
                @TestMetadata("ThroughDelegatedLocalVariableMaterializeCase.kt")
                public void testThroughDelegatedLocalVariableMaterializeCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/ThroughDelegatedLocalVariableMaterializeCase.kt");
                }

                @Test
                @TestMetadata("ThroughGenericFunctionCall.kt")
                public void testThroughGenericFunctionCall() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/ThroughGenericFunctionCall.kt");
                }
              }

              @Nested
              @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes")
              @TestDataPath("$PROJECT_ROOT")
              public class TargetTypes {
                @Test
                public void testAllFilesPresentInTargetTypes() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
                }

                @Test
                @TestMetadata("FunctionWithParameterToUnitImplicitLiteralsCase.kt")
                public void testFunctionWithParameterToUnitImplicitLiteralsCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/FunctionWithParameterToUnitImplicitLiteralsCase.kt");
                }

                @Test
                @TestMetadata("FunctionWithReceiverToUnitImplicitLiteralsCase.kt")
                public void testFunctionWithReceiverToUnitImplicitLiteralsCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/FunctionWithReceiverToUnitImplicitLiteralsCase.kt");
                }

                @Test
                @TestMetadata("NothingMaterializeCase.kt")
                public void testNothingMaterializeCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/NothingMaterializeCase.kt");
                }

                @Test
                @TestMetadata("NullableNothingNullLiteralMaterializeCase.kt")
                public void testNullableNothingNullLiteralMaterializeCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/NullableNothingNullLiteralMaterializeCase.kt");
                }
              }

              @Nested
              @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks")
              @TestDataPath("$PROJECT_ROOT")
              public class TypeInfoSinks {
                @Test
                public void testAllFilesPresentInTypeInfoSinks() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
                }

                @Test
                @TestMetadata("ExtensionFunctions.kt")
                public void testExtensionFunctions() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/ExtensionFunctions.kt");
                }

                @Test
                @TestMetadata("ImmutableExtensionProperties.kt")
                public void testImmutableExtensionProperties() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/ImmutableExtensionProperties.kt");
                }

                @Test
                @TestMetadata("ImmutableProperties.kt")
                public void testImmutableProperties() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/ImmutableProperties.kt");
                }

                @Test
                @TestMetadata("MutableExtensionPropertiesMaterializeCase.kt")
                public void testMutableExtensionPropertiesMaterializeCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/MutableExtensionPropertiesMaterializeCase.kt");
                }

                @Test
                @TestMetadata("MutableExtensionPropertiesYieldCase.kt")
                public void testMutableExtensionPropertiesYieldCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/MutableExtensionPropertiesYieldCase.kt");
                }

                @Test
                @TestMetadata("MutablePropertiesMaterializeCase.kt")
                public void testMutablePropertiesMaterializeCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/MutablePropertiesMaterializeCase.kt");
                }

                @Test
                @TestMetadata("MutablePropertiesYieldCase.kt")
                public void testMutablePropertiesYieldCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/MutablePropertiesYieldCase.kt");
                }

                @Test
                @TestMetadata("ParametersOfBuilderArguments.kt")
                public void testParametersOfBuilderArguments() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/ParametersOfBuilderArguments.kt");
                }

                @Test
                @TestMetadata("ReceiversOfBuilderArguments.kt")
                public void testReceiversOfBuilderArguments() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/ReceiversOfBuilderArguments.kt");
                }
              }

              @Nested
              @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources")
              @TestDataPath("$PROJECT_ROOT")
              public class TypeInfoSources {
                @Test
                public void testAllFilesPresentInTypeInfoSources() {
                  KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
                }

                @Test
                @TestMetadata("ExtensionFunctions.kt")
                public void testExtensionFunctions() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/ExtensionFunctions.kt");
                }

                @Test
                @TestMetadata("ExtensionProperties.kt")
                public void testExtensionProperties() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/ExtensionProperties.kt");
                }

                @Test
                @TestMetadata("ParametersOfBuilderArguments.kt")
                public void testParametersOfBuilderArguments() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/ParametersOfBuilderArguments.kt");
                }

                @Test
                @TestMetadata("ReceiversOfBuilderArguments.kt")
                public void testReceiversOfBuilderArguments() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/ReceiversOfBuilderArguments.kt");
                }

                @Test
                @TestMetadata("ReturnTypesOfBuilderParameters.kt")
                public void testReturnTypesOfBuilderParameters() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/ReturnTypesOfBuilderParameters.kt");
                }

                @Test
                @TestMetadata("UnitReturnTypeOfBuilderParametersExplicitReturnCase.kt")
                public void testUnitReturnTypeOfBuilderParametersExplicitReturnCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/UnitReturnTypeOfBuilderParametersExplicitReturnCase.kt");
                }

                @Test
                @TestMetadata("UnitReturnTypeOfBuilderParametersLastStatementReturnCase.kt")
                public void testUnitReturnTypeOfBuilderParametersLastStatementReturnCase() {
                  runTest("compiler/testData/diagnostics/tests/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/UnitReturnTypeOfBuilderParametersLastStatementReturnCase.kt");
                }
              }
            }
          }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/regresssions")
        @TestDataPath("$PROJECT_ROOT")
        public class Regresssions {
          @Test
          public void testAllFilesPresentInRegresssions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/regresssions"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("exponentialErrorsInCS.kt")
          public void testExponentialErrorsInCS() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/regresssions/exponentialErrorsInCS.kt");
          }

          @Test
          @TestMetadata("exponentialErrorsInCSInitial.kt")
          public void testExponentialErrorsInCSInitial() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/regresssions/exponentialErrorsInCSInitial.kt");
          }

          @Test
          @TestMetadata("exponentialForksInCS.kt")
          public void testExponentialForksInCS() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/regresssions/exponentialForksInCS.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inference/pcla/stubTypes")
        @TestDataPath("$PROJECT_ROOT")
        public class StubTypes {
          @Test
          public void testAllFilesPresentInStubTypes() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/pcla/stubTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Test
          @TestMetadata("capturedTypes.kt")
          public void testCapturedTypes() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/capturedTypes.kt");
          }

          @Test
          @TestMetadata("capturedTypesId.kt")
          public void testCapturedTypesId() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/capturedTypesId.kt");
          }

          @Test
          @TestMetadata("commonSuperType.kt")
          public void testCommonSuperType() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/commonSuperType.kt");
          }

          @Test
          @TestMetadata("commonSuperTypeContravariant.kt")
          public void testCommonSuperTypeContravariant() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/commonSuperTypeContravariant.kt");
          }

          @Test
          @TestMetadata("commonSuperTypeCovariant.kt")
          public void testCommonSuperTypeCovariant() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/commonSuperTypeCovariant.kt");
          }

          @Test
          @TestMetadata("commonSuperTypeInvariant.kt")
          public void testCommonSuperTypeInvariant() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/commonSuperTypeInvariant.kt");
          }

          @Test
          @TestMetadata("commonSuperTypeNullable.kt")
          public void testCommonSuperTypeNullable() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/commonSuperTypeNullable.kt");
          }

          @Test
          @TestMetadata("intersect.kt")
          public void testIntersect() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/intersect.kt");
          }

          @Test
          @TestMetadata("memberScope.kt")
          public void testMemberScope() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/memberScope.kt");
          }

          @Test
          @TestMetadata("nullability.kt")
          public void testNullability() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/nullability.kt");
          }

          @Test
          @TestMetadata("renderingStubTypes.kt")
          public void testRenderingStubTypes() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/renderingStubTypes.kt");
          }

          @Test
          @TestMetadata("simpleIntersection.kt")
          public void testSimpleIntersection() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/simpleIntersection.kt");
          }

          @Test
          @TestMetadata("stubTypeReceiverRestriction.kt")
          public void testStubTypeReceiverRestriction() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/stubTypeReceiverRestriction.kt");
          }

          @Test
          @TestMetadata("stubTypeReceiverRestrictionDisabled.kt")
          public void testStubTypeReceiverRestrictionDisabled() {
            runTest("compiler/testData/diagnostics/tests/inference/pcla/stubTypes/stubTypeReceiverRestrictionDisabled.kt");
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/publicApproximation")
      @TestDataPath("$PROJECT_ROOT")
      public class PublicApproximation {
        @Test
        public void testAllFilesPresentInPublicApproximation() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/publicApproximation"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("approximatedIntersectionMorePreciseThanBound.kt")
        public void testApproximatedIntersectionMorePreciseThanBound() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/approximatedIntersectionMorePreciseThanBound.kt");
        }

        @Test
        @TestMetadata("chainedLambdas.kt")
        public void testChainedLambdas() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/chainedLambdas.kt");
        }

        @Test
        @TestMetadata("declarationTypes.kt")
        public void testDeclarationTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/declarationTypes.kt");
        }

        @Test
        @TestMetadata("intersectionAfterSmartCastInLambdaReturn.kt")
        public void testIntersectionAfterSmartCastInLambdaReturn() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/intersectionAfterSmartCastInLambdaReturn.kt");
        }

        @Test
        @TestMetadata("intersectionAlternative.kt")
        public void testIntersectionAlternative() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/intersectionAlternative.kt");
        }

        @Test
        @TestMetadata("intersectionLocations.kt")
        public void testIntersectionLocations() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/intersectionLocations.kt");
        }

        @Test
        @TestMetadata("lambdaReturnArgumentCall.kt")
        public void testLambdaReturnArgumentCall() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/lambdaReturnArgumentCall.kt");
        }

        @Test
        @TestMetadata("lambdaReturnTypeApproximation.kt")
        public void testLambdaReturnTypeApproximation() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/lambdaReturnTypeApproximation.kt");
        }

        @Test
        @TestMetadata("localTypeNullability.kt")
        public void testLocalTypeNullability() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/localTypeNullability.kt");
        }

        @Test
        @TestMetadata("localTypeNullability_after.kt")
        public void testLocalTypeNullability_after() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/localTypeNullability_after.kt");
        }

        @Test
        @TestMetadata("localTypeNullability_before.kt")
        public void testLocalTypeNullability_before() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/localTypeNullability_before.kt");
        }

        @Test
        @TestMetadata("nonTrivialVariance.kt")
        public void testNonTrivialVariance() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/nonTrivialVariance.kt");
        }

        @Test
        @TestMetadata("parameterInBound.kt")
        public void testParameterInBound() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/parameterInBound.kt");
        }

        @Test
        @TestMetadata("projections.kt")
        public void testProjections() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/projections.kt");
        }

        @Test
        @TestMetadata("smartCastInLambdaReturnAfterIntersection.kt")
        public void testSmartCastInLambdaReturnAfterIntersection() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/smartCastInLambdaReturnAfterIntersection.kt");
        }

        @Test
        @TestMetadata("twoIntersections.kt")
        public void testTwoIntersections() {
          runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/twoIntersections.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveCalls")
      @TestDataPath("$PROJECT_ROOT")
      public class RecursiveCalls {
        @Test
        public void testAllFilesPresentInRecursiveCalls() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveCalls"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("kt23531.kt")
        public void testKt23531() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveCalls/kt23531.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns")
      @TestDataPath("$PROJECT_ROOT")
      public class RecursiveLocalFuns {
        @Test
        public void testAllFilesPresentInRecursiveLocalFuns() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("localFactorial.kt")
        public void testLocalFactorial() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/localFactorial.kt");
        }

        @Test
        @TestMetadata("recursiveFun.kt")
        public void testRecursiveFun() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/recursiveFun.kt");
        }

        @Test
        @TestMetadata("recursiveLambda.kt")
        public void testRecursiveLambda() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/recursiveLambda.kt");
        }

        @Test
        @TestMetadata("selfCall.kt")
        public void testSelfCall() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/selfCall.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveTypes")
      @TestDataPath("$PROJECT_ROOT")
      public class RecursiveTypes {
        @Test
        public void testAllFilesPresentInRecursiveTypes() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("complexTypeUnwrapping.kt")
        public void testComplexTypeUnwrapping() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/complexTypeUnwrapping.kt");
        }

        @Test
        @TestMetadata("complexTypeUnwrapping2.kt")
        public void testComplexTypeUnwrapping2() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/complexTypeUnwrapping2.kt");
        }

        @Test
        @TestMetadata("kt61717.kt")
        public void testKt61717() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/kt61717.kt");
        }

        @Test
        @TestMetadata("multirecursion.kt")
        public void testMultirecursion() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/multirecursion.kt");
        }

        @Test
        @TestMetadata("nestedClassesWithSelfTypes.kt")
        public void testNestedClassesWithSelfTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/nestedClassesWithSelfTypes.kt");
        }

        @Test
        @TestMetadata("recursiveInIn.kt")
        public void testRecursiveInIn() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveInIn.kt");
        }

        @Test
        @TestMetadata("recursiveInInv.kt")
        public void testRecursiveInInv() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveInInv.kt");
        }

        @Test
        @TestMetadata("recursiveInOut.kt")
        public void testRecursiveInOut() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveInOut.kt");
        }

        @Test
        @TestMetadata("recursiveInvIn.kt")
        public void testRecursiveInvIn() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveInvIn.kt");
        }

        @Test
        @TestMetadata("recursiveInvOut.kt")
        public void testRecursiveInvOut() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveInvOut.kt");
        }

        @Test
        @TestMetadata("recursiveOutIn.kt")
        public void testRecursiveOutIn() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveOutIn.kt");
        }

        @Test
        @TestMetadata("recursiveOutInv.kt")
        public void testRecursiveOutInv() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveOutInv.kt");
        }

        @Test
        @TestMetadata("recursiveOutOut.kt")
        public void testRecursiveOutOut() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveOutOut.kt");
        }

        @Test
        @TestMetadata("recursiveTypeWithNonStarResult.kt")
        public void testRecursiveTypeWithNonStarResult() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveTypeWithNonStarResult.kt");
        }

        @Test
        @TestMetadata("recursiveTypes.kt")
        public void testRecursiveTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveTypes.kt");
        }

        @Test
        @TestMetadata("starProjectionOfRecursiveTypeParameterAsReifiedTypeArgument.kt")
        public void testStarProjectionOfRecursiveTypeParameterAsReifiedTypeArgument() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/starProjectionOfRecursiveTypeParameterAsReifiedTypeArgument.kt");
        }

        @Test
        @TestMetadata("twoTypeConstructors.kt")
        public void testTwoTypeConstructors() {
          runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/twoTypeConstructors.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes")
        @TestDataPath("$PROJECT_ROOT")
        public class SelfTypes {
          @Test
          public void testAllFilesPresentInSelfTypes() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
          }

          @Nested
          @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/disabledInferenceOnSelfTypes")
          @TestDataPath("$PROJECT_ROOT")
          public class DisabledInferenceOnSelfTypes {
            @Test
            public void testAllFilesPresentInDisabledInferenceOnSelfTypes() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/disabledInferenceOnSelfTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
            }

            @Test
            @TestMetadata("basicInferenceForImplicitSelfType.kt")
            public void testBasicInferenceForImplicitSelfType() {
              runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/disabledInferenceOnSelfTypes/basicInferenceForImplicitSelfType.kt");
            }

            @Test
            @TestMetadata("recursiveTypeWithTwoTypeParams.kt")
            public void testRecursiveTypeWithTwoTypeParams() {
              runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/disabledInferenceOnSelfTypes/recursiveTypeWithTwoTypeParams.kt");
            }

            @Test
            @TestMetadata("writerAppenderExampleRecursive.kt")
            public void testWriterAppenderExampleRecursive() {
              runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/disabledInferenceOnSelfTypes/writerAppenderExampleRecursive.kt");
            }
          }

          @Nested
          @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes")
          @TestDataPath("$PROJECT_ROOT")
          public class EnabledInferenceOnSelfTypes {
            @Test
            public void testAllFilesPresentInEnabledInferenceOnSelfTypes() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
            }

            @Test
            @TestMetadata("basicInferenceForImplicitSelfType.kt")
            public void testBasicInferenceForImplicitSelfType() {
              runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes/basicInferenceForImplicitSelfType.kt");
            }

            @Test
            @TestMetadata("enumExtensionFunction.kt")
            public void testEnumExtensionFunction() {
              runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes/enumExtensionFunction.kt");
            }

            @Test
            @TestMetadata("overridingJKCases.kt")
            public void testOverridingJKCases() {
              runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes/overridingJKCases.kt");
            }

            @Test
            @TestMetadata("recursiveTypeWithTwoTypeParams.kt")
            public void testRecursiveTypeWithTwoTypeParams() {
              runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes/recursiveTypeWithTwoTypeParams.kt");
            }

            @Test
            @TestMetadata("whereAndWithCases.kt")
            public void testWhereAndWithCases() {
              runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes/whereAndWithCases.kt");
            }

            @Test
            @TestMetadata("writerAppenderExampleRecursive.kt")
            public void testWriterAppenderExampleRecursive() {
              runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes/writerAppenderExampleRecursive.kt");
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/regressions")
      @TestDataPath("$PROJECT_ROOT")
      public class Regressions {
        @Test
        public void testAllFilesPresentInRegressions() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/regressions"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("classSubstitutedWithOwnFunctionTypeParameter.kt")
        public void testClassSubstitutedWithOwnFunctionTypeParameter() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/classSubstitutedWithOwnFunctionTypeParameter.kt");
        }

        @Test
        @TestMetadata("compareBy.kt")
        public void testCompareBy() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/compareBy.kt");
        }

        @Test
        @TestMetadata("functionalSuperTypeOfIntersectionType.kt")
        public void testFunctionalSuperTypeOfIntersectionType() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/functionalSuperTypeOfIntersectionType.kt");
        }

        @Test
        @TestMetadata("kt1029.kt")
        public void testKt1029() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1029.kt");
        }

        @Test
        @TestMetadata("kt1031.kt")
        public void testKt1031() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1031.kt");
        }

        @Test
        @TestMetadata("kt1127.kt")
        public void testKt1127() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1127.kt");
        }

        @Test
        @TestMetadata("kt1145.kt")
        public void testKt1145() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1145.kt");
        }

        @Test
        @TestMetadata("kt1358.kt")
        public void testKt1358() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1358.kt");
        }

        @Test
        @TestMetadata("kt1410.kt")
        public void testKt1410() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1410.kt");
        }

        @Test
        @TestMetadata("kt1718.kt")
        public void testKt1718() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1718.kt");
        }

        @Test
        @TestMetadata("kt1944.kt")
        public void testKt1944() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1944.kt");
        }

        @Test
        @TestMetadata("kt2057.kt")
        public void testKt2057() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2057.kt");
        }

        @Test
        @TestMetadata("kt2179.kt")
        public void testKt2179() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2179.kt");
        }

        @Test
        @TestMetadata("kt2200.kt")
        public void testKt2200() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2200.kt");
        }

        @Test
        @TestMetadata("kt2283.kt")
        public void testKt2283() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2283.kt");
        }

        @Test
        @TestMetadata("kt2286.kt")
        public void testKt2286() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2286.kt");
        }

        @Test
        @TestMetadata("kt2294.kt")
        public void testKt2294() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2294.kt");
        }

        @Test
        @TestMetadata("kt2320.kt")
        public void testKt2320() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2320.kt");
        }

        @Test
        @TestMetadata("kt2324.kt")
        public void testKt2324() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2324.kt");
        }

        @Test
        @TestMetadata("kt2407.kt")
        public void testKt2407() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2407.kt");
        }

        @Test
        @TestMetadata("kt2445.kt")
        public void testKt2445() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2445.kt");
        }

        @Test
        @TestMetadata("kt2459.kt")
        public void testKt2459() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2459.kt");
        }

        @Test
        @TestMetadata("kt2484.kt")
        public void testKt2484() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2484.kt");
        }

        @Test
        @TestMetadata("kt2505.kt")
        public void testKt2505() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2505.kt");
        }

        @Test
        @TestMetadata("kt2514.kt")
        public void testKt2514() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2514.kt");
        }

        @Test
        @TestMetadata("kt2588.kt")
        public void testKt2588() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2588.kt");
        }

        @Test
        @TestMetadata("kt2741.kt")
        public void testKt2741() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2741.kt");
        }

        @Test
        @TestMetadata("kt2754.kt")
        public void testKt2754() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2754.kt");
        }

        @Test
        @TestMetadata("kt2838.kt")
        public void testKt2838() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2838.kt");
        }

        @Test
        @TestMetadata("kt2841.kt")
        public void testKt2841() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2841.kt");
        }

        @Test
        @TestMetadata("kt2841_it.kt")
        public void testKt2841_it() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2841_it.kt");
        }

        @Test
        @TestMetadata("kt2841_it_this.kt")
        public void testKt2841_it_this() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2841_it_this.kt");
        }

        @Test
        @TestMetadata("kt2841_this.kt")
        public void testKt2841_this() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2841_this.kt");
        }

        @Test
        @TestMetadata("kt2842.kt")
        public void testKt2842() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2842.kt");
        }

        @Test
        @TestMetadata("kt2883.kt")
        public void testKt2883() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2883.kt");
        }

        @Test
        @TestMetadata("kt3007.kt")
        public void testKt3007() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3007.kt");
        }

        @Test
        @TestMetadata("kt3038.kt")
        public void testKt3038() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3038.kt");
        }

        @Test
        @TestMetadata("kt3150.kt")
        public void testKt3150() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3150.kt");
        }

        @Test
        @TestMetadata("kt3174.kt")
        public void testKt3174() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3174.kt");
        }

        @Test
        @TestMetadata("kt32106.kt")
        public void testKt32106() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt32106.kt");
        }

        @Test
        @TestMetadata("kt32250.kt")
        public void testKt32250() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt32250.kt");
        }

        @Test
        @TestMetadata("kt32862_both.kt")
        public void testKt32862_both() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt32862_both.kt");
        }

        @Test
        @TestMetadata("kt32862_none.kt")
        public void testKt32862_none() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt32862_none.kt");
        }

        @Test
        @TestMetadata("kt3301.kt")
        public void testKt3301() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3301.kt");
        }

        @Test
        @TestMetadata("kt3344.kt")
        public void testKt3344() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3344.kt");
        }

        @Test
        @TestMetadata("kt33629.kt")
        public void testKt33629() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt33629.kt");
        }

        @Test
        @TestMetadata("kt34029.kt")
        public void testKt34029() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt34029.kt");
        }

        @Test
        @TestMetadata("kt34282.kt")
        public void testKt34282() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt34282.kt");
        }

        @Test
        @TestMetadata("kt3496.kt")
        public void testKt3496() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3496.kt");
        }

        @Test
        @TestMetadata("kt3496_2.kt")
        public void testKt3496_2() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3496_2.kt");
        }

        @Test
        @TestMetadata("kt3559.kt")
        public void testKt3559() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3559.kt");
        }

        @Test
        @TestMetadata("kt35844.kt")
        public void testKt35844() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt35844.kt");
        }

        @Test
        @TestMetadata("kt35943.kt")
        public void testKt35943() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt35943.kt");
        }

        @Test
        @TestMetadata("kt36342.kt")
        public void testKt36342() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt36342.kt");
        }

        @Test
        @TestMetadata("kt36342_2.kt")
        public void testKt36342_2() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt36342_2.kt");
        }

        @Test
        @TestMetadata("kt37043.kt")
        public void testKt37043() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt37043.kt");
        }

        @Test
        @TestMetadata("kt37043_2.kt")
        public void testKt37043_2() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt37043_2.kt");
        }

        @Test
        @TestMetadata("kt37419.kt")
        public void testKt37419() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt37419.kt");
        }

        @Test
        @TestMetadata("kt37650.kt")
        public void testKt37650() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt37650.kt");
        }

        @Test
        @TestMetadata("kt38549.kt")
        public void testKt38549() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt38549.kt");
        }

        @Test
        @TestMetadata("kt38691.kt")
        public void testKt38691() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt38691.kt");
        }

        @Test
        @TestMetadata("kt41386.kt")
        public void testKt41386() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt41386.kt");
        }

        @Test
        @TestMetadata("kt41394.kt")
        public void testKt41394() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt41394.kt");
        }

        @Test
        @TestMetadata("kt4420.kt")
        public void testKt4420() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt4420.kt");
        }

        @Test
        @TestMetadata("kt44440.kt")
        public void testKt44440() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt44440.kt");
        }

        @Test
        @TestMetadata("kt47941.kt")
        public void testKt47941() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt47941.kt");
        }

        @Test
        @TestMetadata("kt702.kt")
        public void testKt702() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt702.kt");
        }

        @Test
        @TestMetadata("kt731.kt")
        public void testKt731() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt731.kt");
        }

        @Test
        @TestMetadata("kt742.kt")
        public void testKt742() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt742.kt");
        }

        @Test
        @TestMetadata("kt8132.kt")
        public void testKt8132() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt8132.kt");
        }

        @Test
        @TestMetadata("kt832.kt")
        public void testKt832() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt832.kt");
        }

        @Test
        @TestMetadata("kt943.kt")
        public void testKt943() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt943.kt");
        }

        @Test
        @TestMetadata("kt9461.kt")
        public void testKt9461() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt9461.kt");
        }

        @Test
        @TestMetadata("kt948.kt")
        public void testKt948() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/kt948.kt");
        }

        @Test
        @TestMetadata("noRecursionOnCallingPureKotlinFunctionAsSyntheticJavaAccessor.kt")
        public void testNoRecursionOnCallingPureKotlinFunctionAsSyntheticJavaAccessor() {
          runTest("compiler/testData/diagnostics/tests/inference/regressions/noRecursionOnCallingPureKotlinFunctionAsSyntheticJavaAccessor.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/reified")
      @TestDataPath("$PROJECT_ROOT")
      public class Reified {
        @Test
        public void testAllFilesPresentInReified() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/reified"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("ReifiedIntersectionError.kt")
        public void testReifiedIntersectionError() {
          runTest("compiler/testData/diagnostics/tests/inference/reified/ReifiedIntersectionError.kt");
        }

        @Test
        @TestMetadata("ReifiedIntersectionWarning.kt")
        public void testReifiedIntersectionWarning() {
          runTest("compiler/testData/diagnostics/tests/inference/reified/ReifiedIntersectionWarning.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/reportingImprovements")
      @TestDataPath("$PROJECT_ROOT")
      public class ReportingImprovements {
        @Test
        public void testAllFilesPresentInReportingImprovements() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/reportingImprovements"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("cannotInferParameterTypeWithInference.kt")
        public void testCannotInferParameterTypeWithInference() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/cannotInferParameterTypeWithInference.kt");
        }

        @Test
        @TestMetadata("ErrorTypeAsGenericParameter.kt")
        public void testErrorTypeAsGenericParameter() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/ErrorTypeAsGenericParameter.kt");
        }

        @Test
        @TestMetadata("FunctionPlaceholder.kt")
        public void testFunctionPlaceholder() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/FunctionPlaceholder.kt");
        }

        @Test
        @TestMetadata("inferTypeFromUnresolvedArgument.kt")
        public void testInferTypeFromUnresolvedArgument() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/inferTypeFromUnresolvedArgument.kt");
        }

        @Test
        @TestMetadata("kt42620.kt")
        public void testKt42620() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/kt42620.kt");
        }

        @Test
        @TestMetadata("multipleDiagnosticsInOneCallChain.kt")
        public void testMultipleDiagnosticsInOneCallChain() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/multipleDiagnosticsInOneCallChain.kt");
        }

        @Test
        @TestMetadata("NoAmbiguityForDifferentFunctionTypes.kt")
        public void testNoAmbiguityForDifferentFunctionTypes() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/NoAmbiguityForDifferentFunctionTypes.kt");
        }

        @Test
        @TestMetadata("reportUnresolvedReferenceWrongReceiverForManyCandidates.kt")
        public void testReportUnresolvedReferenceWrongReceiverForManyCandidates() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/reportUnresolvedReferenceWrongReceiverForManyCandidates.kt");
        }

        @Test
        @TestMetadata("subtypeForInvariantWithErrorGenerics.kt")
        public void testSubtypeForInvariantWithErrorGenerics() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/subtypeForInvariantWithErrorGenerics.kt");
        }

        @Test
        @TestMetadata("typeInferenceFailedOnComponentN.kt")
        public void testTypeInferenceFailedOnComponentN() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/typeInferenceFailedOnComponentN.kt");
        }

        @Test
        @TestMetadata("typeInferenceFailedOnIteratorCall.kt")
        public void testTypeInferenceFailedOnIteratorCall() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/typeInferenceFailedOnIteratorCall.kt");
        }

        @Test
        @TestMetadata("wrongArgumentExtensionFunction.kt")
        public void testWrongArgumentExtensionFunction() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/wrongArgumentExtensionFunction.kt");
        }

        @Test
        @TestMetadata("wrongArgumentPassedToLocalExtensionFunction.kt")
        public void testWrongArgumentPassedToLocalExtensionFunction() {
          runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/wrongArgumentPassedToLocalExtensionFunction.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/substitutions")
      @TestDataPath("$PROJECT_ROOT")
      public class Substitutions {
        @Test
        public void testAllFilesPresentInSubstitutions() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/substitutions"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("delegationAndInference.kt")
        public void testDelegationAndInference() {
          runTest("compiler/testData/diagnostics/tests/inference/substitutions/delegationAndInference.kt");
        }

        @Test
        @TestMetadata("hideFlexibleLocalTypeInPublicPosition.kt")
        public void testHideFlexibleLocalTypeInPublicPosition() {
          runTest("compiler/testData/diagnostics/tests/inference/substitutions/hideFlexibleLocalTypeInPublicPosition.kt");
        }

        @Test
        @TestMetadata("hideFlexibleLocalTypeInPublicPosition_before.kt")
        public void testHideFlexibleLocalTypeInPublicPosition_before() {
          runTest("compiler/testData/diagnostics/tests/inference/substitutions/hideFlexibleLocalTypeInPublicPosition_before.kt");
        }

        @Test
        @TestMetadata("hideLocalTypeForReturnTypeOfSingleExpressionFunction.kt")
        public void testHideLocalTypeForReturnTypeOfSingleExpressionFunction() {
          runTest("compiler/testData/diagnostics/tests/inference/substitutions/hideLocalTypeForReturnTypeOfSingleExpressionFunction.kt");
        }

        @Test
        @TestMetadata("hideNullableLocalTypeInPublicPosition.kt")
        public void testHideNullableLocalTypeInPublicPosition() {
          runTest("compiler/testData/diagnostics/tests/inference/substitutions/hideNullableLocalTypeInPublicPosition.kt");
        }

        @Test
        @TestMetadata("hideNullableLocalTypeInPublicPosition_before.kt")
        public void testHideNullableLocalTypeInPublicPosition_before() {
          runTest("compiler/testData/diagnostics/tests/inference/substitutions/hideNullableLocalTypeInPublicPosition_before.kt");
        }

        @Test
        @TestMetadata("kt32189returnTypeWithTypealiasSubtitution.kt")
        public void testKt32189returnTypeWithTypealiasSubtitution() {
          runTest("compiler/testData/diagnostics/tests/inference/substitutions/kt32189returnTypeWithTypealiasSubtitution.kt");
        }

        @Test
        @TestMetadata("kt6081SubstituteIntoClassCorrectly.kt")
        public void testKt6081SubstituteIntoClassCorrectly() {
          runTest("compiler/testData/diagnostics/tests/inference/substitutions/kt6081SubstituteIntoClassCorrectly.kt");
        }

        @Test
        @TestMetadata("simpleSubstitutionCheckTypeArgumentsNotTypeParameters.kt")
        public void testSimpleSubstitutionCheckTypeArgumentsNotTypeParameters() {
          runTest("compiler/testData/diagnostics/tests/inference/substitutions/simpleSubstitutionCheckTypeArgumentsNotTypeParameters.kt");
        }

        @Test
        @TestMetadata("substitutionIntoAnonymousClass.kt")
        public void testSubstitutionIntoAnonymousClass() {
          runTest("compiler/testData/diagnostics/tests/inference/substitutions/substitutionIntoAnonymousClass.kt");
        }

        @Test
        @TestMetadata("substitutionIntoInnerClass.kt")
        public void testSubstitutionIntoInnerClass() {
          runTest("compiler/testData/diagnostics/tests/inference/substitutions/substitutionIntoInnerClass.kt");
        }

        @Test
        @TestMetadata("substitutionOfTypeEnhancement.kt")
        public void testSubstitutionOfTypeEnhancement() {
          runTest("compiler/testData/diagnostics/tests/inference/substitutions/substitutionOfTypeEnhancement.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inference/upperBounds")
      @TestDataPath("$PROJECT_ROOT")
      public class UpperBounds {
        @Test
        public void testAllFilesPresentInUpperBounds() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/upperBounds"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("conflictingSubstitutionsFromUpperBound.kt")
        public void testConflictingSubstitutionsFromUpperBound() {
          runTest("compiler/testData/diagnostics/tests/inference/upperBounds/conflictingSubstitutionsFromUpperBound.kt");
        }

        @Test
        @TestMetadata("doNotInferFromBoundsOnly.kt")
        public void testDoNotInferFromBoundsOnly() {
          runTest("compiler/testData/diagnostics/tests/inference/upperBounds/doNotInferFromBoundsOnly.kt");
        }

        @Test
        @TestMetadata("flexibilityInCommonSuperTypeCalculation.kt")
        public void testFlexibilityInCommonSuperTypeCalculation() {
          runTest("compiler/testData/diagnostics/tests/inference/upperBounds/flexibilityInCommonSuperTypeCalculation.kt");
        }

        @Test
        @TestMetadata("flexibilityInCommonSuperTypeCalculation.ni.kt")
        public void testFlexibilityInCommonSuperTypeCalculation_ni() {
          runTest("compiler/testData/diagnostics/tests/inference/upperBounds/flexibilityInCommonSuperTypeCalculation.ni.kt");
        }

        @Test
        @TestMetadata("inferringVariableByMaterializeAndUpperBound.kt")
        public void testInferringVariableByMaterializeAndUpperBound() {
          runTest("compiler/testData/diagnostics/tests/inference/upperBounds/inferringVariableByMaterializeAndUpperBound.kt");
        }

        @Test
        @TestMetadata("intersectUpperBounds.kt")
        public void testIntersectUpperBounds() {
          runTest("compiler/testData/diagnostics/tests/inference/upperBounds/intersectUpperBounds.kt");
        }

        @Test
        @TestMetadata("kt2856.kt")
        public void testKt2856() {
          runTest("compiler/testData/diagnostics/tests/inference/upperBounds/kt2856.kt");
        }

        @Test
        @TestMetadata("nonNullUpperBound.kt")
        public void testNonNullUpperBound() {
          runTest("compiler/testData/diagnostics/tests/inference/upperBounds/nonNullUpperBound.kt");
        }

        @Test
        @TestMetadata("typeParameterAsUpperBound.kt")
        public void testTypeParameterAsUpperBound() {
          runTest("compiler/testData/diagnostics/tests/inference/upperBounds/typeParameterAsUpperBound.kt");
        }

        @Test
        @TestMetadata("useBoundsIfUnknownParameters.kt")
        public void testUseBoundsIfUnknownParameters() {
          runTest("compiler/testData/diagnostics/tests/inference/upperBounds/useBoundsIfUnknownParameters.kt");
        }

        @Test
        @TestMetadata("useBoundsToInferTypeParamsSimple.kt")
        public void testUseBoundsToInferTypeParamsSimple() {
          runTest("compiler/testData/diagnostics/tests/inference/upperBounds/useBoundsToInferTypeParamsSimple.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/infos")
    @TestDataPath("$PROJECT_ROOT")
    public class Infos {
      @Test
      public void testAllFilesPresentInInfos() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/infos"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("PropertiesWithBackingFields.kt")
      public void testPropertiesWithBackingFields() {
        runTest("compiler/testData/diagnostics/tests/infos/PropertiesWithBackingFields.kt");
      }

      @Test
      @TestMetadata("SmartCasts.kt")
      public void testSmartCasts() {
        runTest("compiler/testData/diagnostics/tests/infos/SmartCasts.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/inline")
    @TestDataPath("$PROJECT_ROOT")
    public class Inline {
      @Test
      public void testAllFilesPresentInInline() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("anonymousObjects.kt")
      public void testAnonymousObjects() {
        runTest("compiler/testData/diagnostics/tests/inline/anonymousObjects.kt");
      }

      @Test
      @TestMetadata("approximateReturnedAnonymousObjects.kt")
      public void testApproximateReturnedAnonymousObjects() {
        runTest("compiler/testData/diagnostics/tests/inline/approximateReturnedAnonymousObjects.kt");
      }

      @Test
      @TestMetadata("assignment.kt")
      public void testAssignment() {
        runTest("compiler/testData/diagnostics/tests/inline/assignment.kt");
      }

      @Test
      @TestMetadata("capture.kt")
      public void testCapture() {
        runTest("compiler/testData/diagnostics/tests/inline/capture.kt");
      }

      @Test
      @TestMetadata("constructor.kt")
      public void testConstructor() {
        runTest("compiler/testData/diagnostics/tests/inline/constructor.kt");
      }

      @Test
      @TestMetadata("default.kt")
      public void testDefault() {
        runTest("compiler/testData/diagnostics/tests/inline/default.kt");
      }

      @Test
      @TestMetadata("defaultLambdaInlineSuspend.kt")
      public void testDefaultLambdaInlineSuspend() {
        runTest("compiler/testData/diagnostics/tests/inline/defaultLambdaInlineSuspend.kt");
      }

      @Test
      @TestMetadata("defaultLambdaInlining.kt")
      public void testDefaultLambdaInlining() {
        runTest("compiler/testData/diagnostics/tests/inline/defaultLambdaInlining.kt");
      }

      @Test
      @TestMetadata("extensionOnFunction.kt")
      public void testExtensionOnFunction() {
        runTest("compiler/testData/diagnostics/tests/inline/extensionOnFunction.kt");
      }

      @Test
      @TestMetadata("forbidExtensionCallsOnInlineFunctionalParameters_after.kt")
      public void testForbidExtensionCallsOnInlineFunctionalParameters_after() {
        runTest("compiler/testData/diagnostics/tests/inline/forbidExtensionCallsOnInlineFunctionalParameters_after.kt");
      }

      @Test
      @TestMetadata("forbidExtensionCallsOnInlineFunctionalParameters_before.kt")
      public void testForbidExtensionCallsOnInlineFunctionalParameters_before() {
        runTest("compiler/testData/diagnostics/tests/inline/forbidExtensionCallsOnInlineFunctionalParameters_before.kt");
      }

      @Test
      @TestMetadata("fromInlineToNoInline.kt")
      public void testFromInlineToNoInline() {
        runTest("compiler/testData/diagnostics/tests/inline/fromInlineToNoInline.kt");
      }

      @Test
      @TestMetadata("functions.kt")
      public void testFunctions() {
        runTest("compiler/testData/diagnostics/tests/inline/functions.kt");
      }

      @Test
      @TestMetadata("inlineCallsPrivateInline.kt")
      public void testInlineCallsPrivateInline() {
        runTest("compiler/testData/diagnostics/tests/inline/inlineCallsPrivateInline.kt");
      }

      @Test
      @TestMetadata("inlineCallsStaticMethod.kt")
      public void testInlineCallsStaticMethod() {
        runTest("compiler/testData/diagnostics/tests/inline/inlineCallsStaticMethod.kt");
      }

      @Test
      @TestMetadata("inlineCallsStaticMethodFromOtherPackage.kt")
      public void testInlineCallsStaticMethodFromOtherPackage() {
        runTest("compiler/testData/diagnostics/tests/inline/inlineCallsStaticMethodFromOtherPackage.kt");
      }

      @Test
      @TestMetadata("inlineLambdaInDefaultInlineParameter.kt")
      public void testInlineLambdaInDefaultInlineParameter() {
        runTest("compiler/testData/diagnostics/tests/inline/inlineLambdaInDefaultInlineParameter.kt");
      }

      @Test
      @TestMetadata("inlineReified.kt")
      public void testInlineReified() {
        runTest("compiler/testData/diagnostics/tests/inline/inlineReified.kt");
      }

      @Test
      @TestMetadata("inlinedReturnInBranch.kt")
      public void testInlinedReturnInBranch() {
        runTest("compiler/testData/diagnostics/tests/inline/inlinedReturnInBranch.kt");
      }

      @Test
      @TestMetadata("invoke.kt")
      public void testInvoke() {
        runTest("compiler/testData/diagnostics/tests/inline/invoke.kt");
      }

      @Test
      @TestMetadata("isCheck.kt")
      public void testIsCheck() {
        runTest("compiler/testData/diagnostics/tests/inline/isCheck.kt");
      }

      @Test
      @TestMetadata("kt15410.kt")
      public void testKt15410() {
        runTest("compiler/testData/diagnostics/tests/inline/kt15410.kt");
      }

      @Test
      @TestMetadata("kt19679.kt")
      public void testKt19679() {
        runTest("compiler/testData/diagnostics/tests/inline/kt19679.kt");
      }

      @Test
      @TestMetadata("kt21177.kt")
      public void testKt21177() {
        runTest("compiler/testData/diagnostics/tests/inline/kt21177.kt");
      }

      @Test
      @TestMetadata("kt21177Warning.kt")
      public void testKt21177Warning() {
        runTest("compiler/testData/diagnostics/tests/inline/kt21177Warning.kt");
      }

      @Test
      @TestMetadata("kt4869.kt")
      public void testKt4869() {
        runTest("compiler/testData/diagnostics/tests/inline/kt4869.kt");
      }

      @Test
      @TestMetadata("labeled.kt")
      public void testLabeled() {
        runTest("compiler/testData/diagnostics/tests/inline/labeled.kt");
      }

      @Test
      @TestMetadata("labelsAndNonInlineUsage.kt")
      public void testLabelsAndNonInlineUsage() {
        runTest("compiler/testData/diagnostics/tests/inline/labelsAndNonInlineUsage.kt");
      }

      @Test
      @TestMetadata("lambdaCast.kt")
      public void testLambdaCast() {
        runTest("compiler/testData/diagnostics/tests/inline/lambdaCast.kt");
      }

      @Test
      @TestMetadata("localFun.kt")
      public void testLocalFun() {
        runTest("compiler/testData/diagnostics/tests/inline/localFun.kt");
      }

      @Test
      @TestMetadata("messagesForUnsupportedInInline.kt")
      public void testMessagesForUnsupportedInInline() {
        runTest("compiler/testData/diagnostics/tests/inline/messagesForUnsupportedInInline.kt");
      }

      @Test
      @TestMetadata("nonVirtualMembersWithInline.kt")
      public void testNonVirtualMembersWithInline() {
        runTest("compiler/testData/diagnostics/tests/inline/nonVirtualMembersWithInline.kt");
      }

      @Test
      @TestMetadata("notInlinableWithLabel.kt")
      public void testNotInlinableWithLabel() {
        runTest("compiler/testData/diagnostics/tests/inline/notInlinableWithLabel.kt");
      }

      @Test
      @TestMetadata("nothingToInline.kt")
      public void testNothingToInline() {
        runTest("compiler/testData/diagnostics/tests/inline/nothingToInline.kt");
      }

      @Test
      @TestMetadata("nullabilityOperations.kt")
      public void testNullabilityOperations() {
        runTest("compiler/testData/diagnostics/tests/inline/nullabilityOperations.kt");
      }

      @Test
      @TestMetadata("nullableFunction.kt")
      public void testNullableFunction() {
        runTest("compiler/testData/diagnostics/tests/inline/nullableFunction.kt");
      }

      @Test
      @TestMetadata("overrideWithInline.kt")
      public void testOverrideWithInline() {
        runTest("compiler/testData/diagnostics/tests/inline/overrideWithInline.kt");
      }

      @Test
      @TestMetadata("parenthesized.kt")
      public void testParenthesized() {
        runTest("compiler/testData/diagnostics/tests/inline/parenthesized.kt");
      }

      @Test
      @TestMetadata("privateClass.kt")
      public void testPrivateClass() {
        runTest("compiler/testData/diagnostics/tests/inline/privateClass.kt");
      }

      @Test
      @TestMetadata("privateOperatorsInInlineAfter.kt")
      public void testPrivateOperatorsInInlineAfter() {
        runTest("compiler/testData/diagnostics/tests/inline/privateOperatorsInInlineAfter.kt");
      }

      @Test
      @TestMetadata("privateOperatorsInInlineBefore.kt")
      public void testPrivateOperatorsInInlineBefore() {
        runTest("compiler/testData/diagnostics/tests/inline/privateOperatorsInInlineBefore.kt");
      }

      @Test
      @TestMetadata("propagation.kt")
      public void testPropagation() {
        runTest("compiler/testData/diagnostics/tests/inline/propagation.kt");
      }

      @Test
      @TestMetadata("protectedCallError.kt")
      public void testProtectedCallError() {
        runTest("compiler/testData/diagnostics/tests/inline/protectedCallError.kt");
      }

      @Test
      @TestMetadata("protectedJavaFieldInInline.kt")
      public void testProtectedJavaFieldInInline() {
        runTest("compiler/testData/diagnostics/tests/inline/protectedJavaFieldInInline.kt");
      }

      @Test
      @TestMetadata("protectedMembers.kt")
      public void testProtectedMembers() {
        runTest("compiler/testData/diagnostics/tests/inline/protectedMembers.kt");
      }

      @Test
      @TestMetadata("protectedMembersFromSuper.kt")
      public void testProtectedMembersFromSuper() {
        runTest("compiler/testData/diagnostics/tests/inline/protectedMembersFromSuper.kt");
      }

      @Test
      @TestMetadata("protectedStaticAndInline.kt")
      public void testProtectedStaticAndInline() {
        runTest("compiler/testData/diagnostics/tests/inline/protectedStaticAndInline.kt");
      }

      @Test
      @TestMetadata("publishedApi.kt")
      public void testPublishedApi() {
        runTest("compiler/testData/diagnostics/tests/inline/publishedApi.kt");
      }

      @Test
      @TestMetadata("publishedApiSubstitutionOverride.kt")
      public void testPublishedApiSubstitutionOverride() {
        runTest("compiler/testData/diagnostics/tests/inline/publishedApiSubstitutionOverride.kt");
      }

      @Test
      @TestMetadata("recursion.kt")
      public void testRecursion() {
        runTest("compiler/testData/diagnostics/tests/inline/recursion.kt");
      }

      @Test
      @TestMetadata("recursiveTypeInPrivateInlineFunction.kt")
      public void testRecursiveTypeInPrivateInlineFunction() {
        runTest("compiler/testData/diagnostics/tests/inline/recursiveTypeInPrivateInlineFunction.kt");
      }

      @Test
      @TestMetadata("returnedAnonymousObjects_2.kt")
      public void testReturnedAnonymousObjects_2() {
        runTest("compiler/testData/diagnostics/tests/inline/returnedAnonymousObjects_2.kt");
      }

      @Test
      @TestMetadata("returns.kt")
      public void testReturns() {
        runTest("compiler/testData/diagnostics/tests/inline/returns.kt");
      }

      @Test
      @TestMetadata("sam.kt")
      public void testSam() {
        runTest("compiler/testData/diagnostics/tests/inline/sam.kt");
      }

      @Test
      @TestMetadata("stringTemplate.kt")
      public void testStringTemplate() {
        runTest("compiler/testData/diagnostics/tests/inline/stringTemplate.kt");
      }

      @Test
      @TestMetadata("superCall.kt")
      public void testSuperCall() {
        runTest("compiler/testData/diagnostics/tests/inline/superCall.kt");
      }

      @Test
      @TestMetadata("superCallDepecation.kt")
      public void testSuperCallDepecation() {
        runTest("compiler/testData/diagnostics/tests/inline/superCallDepecation.kt");
      }

      @Test
      @TestMetadata("superCallDepecationWarning.kt")
      public void testSuperCallDepecationWarning() {
        runTest("compiler/testData/diagnostics/tests/inline/superCallDepecationWarning.kt");
      }

      @Test
      @TestMetadata("superCallFromMultipleSubclasses.kt")
      public void testSuperCallFromMultipleSubclasses() {
        runTest("compiler/testData/diagnostics/tests/inline/superCallFromMultipleSubclasses.kt");
      }

      @Test
      @TestMetadata("superProperty.kt")
      public void testSuperProperty() {
        runTest("compiler/testData/diagnostics/tests/inline/superProperty.kt");
      }

      @Test
      @TestMetadata("usageIsNotInlinable.kt")
      public void testUsageIsNotInlinable() {
        runTest("compiler/testData/diagnostics/tests/inline/usageIsNotInlinable.kt");
      }

      @Test
      @TestMetadata("valueClasses.kt")
      public void testValueClasses() {
        runTest("compiler/testData/diagnostics/tests/inline/valueClasses.kt");
      }

      @Test
      @TestMetadata("valueOfKFunctionTypeAsArgumentOfInlineFunction.kt")
      public void testValueOfKFunctionTypeAsArgumentOfInlineFunction() {
        runTest("compiler/testData/diagnostics/tests/inline/valueOfKFunctionTypeAsArgumentOfInlineFunction.kt");
      }

      @Test
      @TestMetadata("vararg.kt")
      public void testVararg() {
        runTest("compiler/testData/diagnostics/tests/inline/vararg.kt");
      }

      @Test
      @TestMetadata("virtualMemberInEnum.kt")
      public void testVirtualMemberInEnum() {
        runTest("compiler/testData/diagnostics/tests/inline/virtualMemberInEnum.kt");
      }

      @Test
      @TestMetadata("virtualValInEnum.kt")
      public void testVirtualValInEnum() {
        runTest("compiler/testData/diagnostics/tests/inline/virtualValInEnum.kt");
      }

      @Test
      @TestMetadata("when.kt")
      public void testWhen() {
        runTest("compiler/testData/diagnostics/tests/inline/when.kt");
      }

      @Test
      @TestMetadata("wrongUsage.kt")
      public void testWrongUsage() {
        runTest("compiler/testData/diagnostics/tests/inline/wrongUsage.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inline/binaryExpressions")
      @TestDataPath("$PROJECT_ROOT")
      public class BinaryExpressions {
        @Test
        public void testAllFilesPresentInBinaryExpressions() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/binaryExpressions"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("andOr.kt")
        public void testAndOr() {
          runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/andOr.kt");
        }

        @Test
        @TestMetadata("arrayAccess.kt")
        public void testArrayAccess() {
          runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/arrayAccess.kt");
        }

        @Test
        @TestMetadata("assignment.kt")
        public void testAssignment() {
          runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/assignment.kt");
        }

        @Test
        @TestMetadata("comparison.kt")
        public void testComparison() {
          runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/comparison.kt");
        }

        @Test
        @TestMetadata("componentAccess.kt")
        public void testComponentAccess() {
          runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/componentAccess.kt");
        }

        @Test
        @TestMetadata("contains.kt")
        public void testContains() {
          runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/contains.kt");
        }

        @Test
        @TestMetadata("mathOperations.kt")
        public void testMathOperations() {
          runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/mathOperations.kt");
        }

        @Test
        @TestMetadata("rangeTo.kt")
        public void testRangeTo() {
          runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/rangeTo.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inline/nonLocalBreakContinue")
      @TestDataPath("$PROJECT_ROOT")
      public class NonLocalBreakContinue {
        @Test
        public void testAllFilesPresentInNonLocalBreakContinue() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/nonLocalBreakContinue"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("baseFeatureInteractions.kt")
        public void testBaseFeatureInteractions() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalBreakContinue/baseFeatureInteractions.kt");
        }

        @Test
        @TestMetadata("defaultLambdaInline.kt")
        public void testDefaultLambdaInline() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalBreakContinue/defaultLambdaInline.kt");
        }

        @Test
        @TestMetadata("inlineExtensionFunction.kt")
        public void testInlineExtensionFunction() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalBreakContinue/inlineExtensionFunction.kt");
        }

        @Test
        @TestMetadata("lambdaAsGeneric.kt")
        public void testLambdaAsGeneric() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalBreakContinue/lambdaAsGeneric.kt");
        }

        @Test
        @TestMetadata("lambdaAsNonFunction.kt")
        public void testLambdaAsNonFunction() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalBreakContinue/lambdaAsNonFunction.kt");
        }

        @Test
        @TestMetadata("lambdaCallWithSuper.kt")
        public void testLambdaCallWithSuper() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalBreakContinue/lambdaCallWithSuper.kt");
        }

        @Test
        @TestMetadata("lambdaWithReceiver.kt")
        public void testLambdaWithReceiver() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalBreakContinue/lambdaWithReceiver.kt");
        }

        @Test
        @TestMetadata("nestedLambdas.kt")
        public void testNestedLambdas() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalBreakContinue/nestedLambdas.kt");
        }

        @Test
        @TestMetadata("withGuards.kt")
        public void testWithGuards() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalBreakContinue/withGuards.kt");
        }

        @Test
        @TestMetadata("withOverrideByInline.kt")
        public void testWithOverrideByInline() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalBreakContinue/withOverrideByInline.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns")
      @TestDataPath("$PROJECT_ROOT")
      public class NonLocalReturns {
        @Test
        public void testAllFilesPresentInNonLocalReturns() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/nonLocalReturns"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("anonymousObjects.kt")
        public void testAnonymousObjects() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/anonymousObjects.kt");
        }

        @Test
        @TestMetadata("anonymousObjectsNested.kt")
        public void testAnonymousObjectsNested() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/anonymousObjectsNested.kt");
        }

        @Test
        @TestMetadata("explicitReturnType.kt")
        public void testExplicitReturnType() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/explicitReturnType.kt");
        }

        @Test
        @TestMetadata("fromOnlyLocal.kt")
        public void testFromOnlyLocal() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/fromOnlyLocal.kt");
        }

        @Test
        @TestMetadata("inlineLambda.kt")
        public void testInlineLambda() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/inlineLambda.kt");
        }

        @Test
        @TestMetadata("labeledReturn.kt")
        public void testLabeledReturn() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/labeledReturn.kt");
        }

        @Test
        @TestMetadata("lambdaAsGeneric.kt")
        public void testLambdaAsGeneric() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/lambdaAsGeneric.kt");
        }

        @Test
        @TestMetadata("lambdaAsNonFunction.kt")
        public void testLambdaAsNonFunction() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/lambdaAsNonFunction.kt");
        }

        @Test
        @TestMetadata("lambdaWithGlobalReturnsInsideOnlyLocalOne.kt")
        public void testLambdaWithGlobalReturnsInsideOnlyLocalOne() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/lambdaWithGlobalReturnsInsideOnlyLocalOne.kt");
        }

        @Test
        @TestMetadata("localFun.kt")
        public void testLocalFun() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/localFun.kt");
        }

        @Test
        @TestMetadata("nestedNonLocals.kt")
        public void testNestedNonLocals() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/nestedNonLocals.kt");
        }

        @Test
        @TestMetadata("noInlineAnnotation.kt")
        public void testNoInlineAnnotation() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/noInlineAnnotation.kt");
        }

        @Test
        @TestMetadata("noInlineLambda.kt")
        public void testNoInlineLambda() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/noInlineLambda.kt");
        }

        @Test
        @TestMetadata("nonInlinedClass.kt")
        public void testNonInlinedClass() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/nonInlinedClass.kt");
        }

        @Test
        @TestMetadata("onlyLocalReturnLambda.kt")
        public void testOnlyLocalReturnLambda() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/onlyLocalReturnLambda.kt");
        }

        @Test
        @TestMetadata("onlyLocalReturnLambdaBinaryExpr.kt")
        public void testOnlyLocalReturnLambdaBinaryExpr() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/onlyLocalReturnLambdaBinaryExpr.kt");
        }

        @Test
        @TestMetadata("propertyAccessorsAndConstructor.kt")
        public void testPropertyAccessorsAndConstructor() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/propertyAccessorsAndConstructor.kt");
        }

        @Test
        @TestMetadata("toOnlyLocal.kt")
        public void testToOnlyLocal() {
          runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/toOnlyLocal.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inline/nonPublicMember")
      @TestDataPath("$PROJECT_ROOT")
      public class NonPublicMember {
        @Test
        public void testAllFilesPresentInNonPublicMember() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/nonPublicMember"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("enumMemberInAnnotation.kt")
        public void testEnumMemberInAnnotation() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/enumMemberInAnnotation.kt");
        }

        @Test
        @TestMetadata("inAnnotation.kt")
        public void testInAnnotation() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inAnnotation.kt");
        }

        @Test
        @TestMetadata("inNonPublicClass.kt")
        public void testInNonPublicClass() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inNonPublicClass.kt");
        }

        @Test
        @TestMetadata("inNonPublicInnerClass.kt")
        public void testInNonPublicInnerClass() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inNonPublicInnerClass.kt");
        }

        @Test
        @TestMetadata("inPackage.kt")
        public void testInPackage() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inPackage.kt");
        }

        @Test
        @TestMetadata("inPublicClass.kt")
        public void testInPublicClass() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inPublicClass.kt");
        }

        @Test
        @TestMetadata("kt14887.kt")
        public void testKt14887() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/kt14887.kt");
        }

        @Test
        @TestMetadata("kt55179.kt")
        public void testKt55179() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/kt55179.kt");
        }

        @Test
        @TestMetadata("localClass.kt")
        public void testLocalClass() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/localClass.kt");
        }

        @Test
        @TestMetadata("localClass2.kt")
        public void testLocalClass2() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/localClass2.kt");
        }

        @Test
        @TestMetadata("localFun.kt")
        public void testLocalFun() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/localFun.kt");
        }

        @Test
        @TestMetadata("protectedInlineInsideInternal.kt")
        public void testProtectedInlineInsideInternal() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/protectedInlineInsideInternal.kt");
        }

        @Test
        @TestMetadata("publishedApi.kt")
        public void testPublishedApi() {
          runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/publishedApi.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inline/property")
      @TestDataPath("$PROJECT_ROOT")
      public class Property {
        @Test
        public void testAllFilesPresentInProperty() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/property"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("invoke.kt")
        public void testInvoke() {
          runTest("compiler/testData/diagnostics/tests/inline/property/invoke.kt");
        }

        @Test
        @TestMetadata("propertyWithBackingField.kt")
        public void testPropertyWithBackingField() {
          runTest("compiler/testData/diagnostics/tests/inline/property/propertyWithBackingField.kt");
        }

        @Test
        @TestMetadata("unsupportedConstruction.kt")
        public void testUnsupportedConstruction() {
          runTest("compiler/testData/diagnostics/tests/inline/property/unsupportedConstruction.kt");
        }

        @Test
        @TestMetadata("virtualProperty.kt")
        public void testVirtualProperty() {
          runTest("compiler/testData/diagnostics/tests/inline/property/virtualProperty.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inline/regressions")
      @TestDataPath("$PROJECT_ROOT")
      public class Regressions {
        @Test
        public void testAllFilesPresentInRegressions() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/regressions"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("kt4341.kt")
        public void testKt4341() {
          runTest("compiler/testData/diagnostics/tests/inline/regressions/kt4341.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inline/unaryExpressions")
      @TestDataPath("$PROJECT_ROOT")
      public class UnaryExpressions {
        @Test
        public void testAllFilesPresentInUnaryExpressions() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/unaryExpressions"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("mathOperation.kt")
        public void testMathOperation() {
          runTest("compiler/testData/diagnostics/tests/inline/unaryExpressions/mathOperation.kt");
        }

        @Test
        @TestMetadata("notOnCall.kt")
        public void testNotOnCall() {
          runTest("compiler/testData/diagnostics/tests/inline/unaryExpressions/notOnCall.kt");
        }

        @Test
        @TestMetadata("notOperation.kt")
        public void testNotOperation() {
          runTest("compiler/testData/diagnostics/tests/inline/unaryExpressions/notOperation.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineClasses {
      @Test
      public void testAllFilesPresentInInlineClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inlineClasses"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("basicInlineClassDeclaration.kt")
      public void testBasicInlineClassDeclaration() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/basicInlineClassDeclaration.kt");
      }

      @Test
      @TestMetadata("delegatedPropertyInInlineClass.kt")
      public void testDelegatedPropertyInInlineClass() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/delegatedPropertyInInlineClass.kt");
      }

      @Test
      @TestMetadata("functionsJvmSignaturesConflictOnInheritance.kt")
      public void testFunctionsJvmSignaturesConflictOnInheritance() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/functionsJvmSignaturesConflictOnInheritance.kt");
      }

      @Test
      @TestMetadata("genericInlineClass.kt")
      public void testGenericInlineClass() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/genericInlineClass.kt");
      }

      @Test
      @TestMetadata("identityComparisonWithInlineClasses.kt")
      public void testIdentityComparisonWithInlineClasses() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/identityComparisonWithInlineClasses.kt");
      }

      @Test
      @TestMetadata("inefficientEqualsOverridingInInlineClass.kt")
      public void testInefficientEqualsOverridingInInlineClass() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/inefficientEqualsOverridingInInlineClass.kt");
      }

      @Test
      @TestMetadata("inlineClassCanImplementInterfaceByDelegation.kt")
      public void testInlineClassCanImplementInterfaceByDelegation() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassCanImplementInterfaceByDelegation.kt");
      }

      @Test
      @TestMetadata("inlineClassCanOnlyImplementInterfaces.kt")
      public void testInlineClassCanOnlyImplementInterfaces() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassCanOnlyImplementInterfaces.kt");
      }

      @Test
      @TestMetadata("inlineClassCannotImplementInterfaceByDelegation.kt")
      public void testInlineClassCannotImplementInterfaceByDelegation() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassCannotImplementInterfaceByDelegation.kt");
      }

      @Test
      @TestMetadata("inlineClassConstructorParameterWithDefaultValue.kt")
      public void testInlineClassConstructorParameterWithDefaultValue() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassConstructorParameterWithDefaultValue.kt");
      }

      @Test
      @TestMetadata("inlineClassDeclarationCheck.kt")
      public void testInlineClassDeclarationCheck() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassDeclarationCheck.kt");
      }

      @Test
      @TestMetadata("inlineClassDeprecated.kt")
      public void testInlineClassDeprecated() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassDeprecated.kt");
      }

      @Test
      @TestMetadata("inlineClassImplementsCollection.kt")
      public void testInlineClassImplementsCollection() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassImplementsCollection.kt");
      }

      @Test
      @TestMetadata("inlineClassWithForbiddenUnderlyingType.kt")
      public void testInlineClassWithForbiddenUnderlyingType() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassWithForbiddenUnderlyingType.kt");
      }

      @Test
      @TestMetadata("inlineClassesInsideAnnotations.kt")
      public void testInlineClassesInsideAnnotations() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassesInsideAnnotations.kt");
      }

      @Test
      @TestMetadata("innerClassInsideInlineClass.kt")
      public void testInnerClassInsideInlineClass() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/innerClassInsideInlineClass.kt");
      }

      @Test
      @TestMetadata("kt51366.kt")
      public void testKt51366() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/kt51366.kt");
      }

      @Test
      @TestMetadata("lateinitInlineClassesOff.kt")
      public void testLateinitInlineClassesOff() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/lateinitInlineClassesOff.kt");
      }

      @Test
      @TestMetadata("presenceOfInitializerBlockInsideInlineClass.kt")
      public void testPresenceOfInitializerBlockInsideInlineClass() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/presenceOfInitializerBlockInsideInlineClass.kt");
      }

      @Test
      @TestMetadata("presenceOfPublicPrimaryConstructorForInlineClass.kt")
      public void testPresenceOfPublicPrimaryConstructorForInlineClass() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/presenceOfPublicPrimaryConstructorForInlineClass.kt");
      }

      @Test
      @TestMetadata("propertiesWithBackingFieldsInsideInlineClass.kt")
      public void testPropertiesWithBackingFieldsInsideInlineClass() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/propertiesWithBackingFieldsInsideInlineClass.kt");
      }

      @Test
      @TestMetadata("recursiveInlineClasses.kt")
      public void testRecursiveInlineClasses() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/recursiveInlineClasses.kt");
      }

      @Test
      @TestMetadata("reifiedGenericUnderlyingType.kt")
      public void testReifiedGenericUnderlyingType() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/reifiedGenericUnderlyingType.kt");
      }

      @Test
      @TestMetadata("reservedConstructorsBodyInKotlinPre19.kt")
      public void testReservedConstructorsBodyInKotlinPre19() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/reservedConstructorsBodyInKotlinPre19.kt");
      }

      @Test
      @TestMetadata("reservedMembersAndConstructsInsideInlineClass.kt")
      public void testReservedMembersAndConstructsInsideInlineClass() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/reservedMembersAndConstructsInsideInlineClass.kt");
      }

      @Test
      @TestMetadata("synchronizedForbidden.kt")
      public void testSynchronizedForbidden() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/synchronizedForbidden.kt");
      }

      @Test
      @TestMetadata("typedEqualsOperatorDeclarationCheck.kt")
      public void testTypedEqualsOperatorDeclarationCheck() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/typedEqualsOperatorDeclarationCheck.kt");
      }

      @Test
      @TestMetadata("typedEqualsOperatorModifierInInlineClass.kt")
      public void testTypedEqualsOperatorModifierInInlineClass() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/typedEqualsOperatorModifierInInlineClass.kt");
      }

      @Test
      @TestMetadata("unsignedLiteralsWithoutArtifactOnClasspath.kt")
      public void testUnsignedLiteralsWithoutArtifactOnClasspath() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/unsignedLiteralsWithoutArtifactOnClasspath.kt");
      }

      @Test
      @TestMetadata("varargsOnParametersOfInlineClassType.kt")
      public void testVarargsOnParametersOfInlineClassType() {
        runTest("compiler/testData/diagnostics/tests/inlineClasses/varargsOnParametersOfInlineClassType.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/inner")
    @TestDataPath("$PROJECT_ROOT")
    public class Inner {
      @Test
      @TestMetadata("accessingToJavaNestedClass.kt")
      public void testAccessingToJavaNestedClass() {
        runTest("compiler/testData/diagnostics/tests/inner/accessingToJavaNestedClass.kt");
      }

      @Test
      @TestMetadata("accessingToKotlinNestedClass.kt")
      public void testAccessingToKotlinNestedClass() {
        runTest("compiler/testData/diagnostics/tests/inner/accessingToKotlinNestedClass.kt");
      }

      @Test
      public void testAllFilesPresentInInner() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inner"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("annotationInInnerClass.kt")
      public void testAnnotationInInnerClass() {
        runTest("compiler/testData/diagnostics/tests/inner/annotationInInnerClass.kt");
      }

      @Test
      @TestMetadata("callingOuterGenericClassConstructorWithSelfTypes.kt")
      public void testCallingOuterGenericClassConstructorWithSelfTypes() {
        runTest("compiler/testData/diagnostics/tests/inner/callingOuterGenericClassConstructorWithSelfTypes.kt");
      }

      @Test
      @TestMetadata("callingOuterGenericClassConstructorWithSelfTypesInitial.kt")
      public void testCallingOuterGenericClassConstructorWithSelfTypesInitial() {
        runTest("compiler/testData/diagnostics/tests/inner/callingOuterGenericClassConstructorWithSelfTypesInitial.kt");
      }

      @Test
      @TestMetadata("classesInClassObjectHeader.kt")
      public void testClassesInClassObjectHeader() {
        runTest("compiler/testData/diagnostics/tests/inner/classesInClassObjectHeader.kt");
      }

      @Test
      @TestMetadata("constructorAccess.kt")
      public void testConstructorAccess() {
        runTest("compiler/testData/diagnostics/tests/inner/constructorAccess.kt");
      }

      @Test
      @TestMetadata("deepInnerClass.kt")
      public void testDeepInnerClass() {
        runTest("compiler/testData/diagnostics/tests/inner/deepInnerClass.kt");
      }

      @Test
      @TestMetadata("enumEntries.kt")
      public void testEnumEntries() {
        runTest("compiler/testData/diagnostics/tests/inner/enumEntries.kt");
      }

      @Test
      @TestMetadata("enumInInnerClass.kt")
      public void testEnumInInnerClass() {
        runTest("compiler/testData/diagnostics/tests/inner/enumInInnerClass.kt");
      }

      @Test
      @TestMetadata("extensionFun.kt")
      public void testExtensionFun() {
        runTest("compiler/testData/diagnostics/tests/inner/extensionFun.kt");
      }

      @Test
      @TestMetadata("extensionLambdaInsideNestedClass.kt")
      public void testExtensionLambdaInsideNestedClass() {
        runTest("compiler/testData/diagnostics/tests/inner/extensionLambdaInsideNestedClass.kt");
      }

      @Test
      @TestMetadata("illegalModifier_lv12.kt")
      public void testIllegalModifier_lv12() {
        runTest("compiler/testData/diagnostics/tests/inner/illegalModifier_lv12.kt");
      }

      @Test
      @TestMetadata("inheritedInnerAndNested.kt")
      public void testInheritedInnerAndNested() {
        runTest("compiler/testData/diagnostics/tests/inner/inheritedInnerAndNested.kt");
      }

      @Test
      @TestMetadata("innerClassInEnumEntryClassMemberResolve.kt")
      public void testInnerClassInEnumEntryClassMemberResolve() {
        runTest("compiler/testData/diagnostics/tests/inner/innerClassInEnumEntryClassMemberResolve.kt");
      }

      @Test
      @TestMetadata("innerClassInEnumEntryClass_lv12.kt")
      public void testInnerClassInEnumEntryClass_lv12() {
        runTest("compiler/testData/diagnostics/tests/inner/innerClassInEnumEntryClass_lv12.kt");
      }

      @Test
      @TestMetadata("innerClassInEnumEntryClass_lv13.kt")
      public void testInnerClassInEnumEntryClass_lv13() {
        runTest("compiler/testData/diagnostics/tests/inner/innerClassInEnumEntryClass_lv13.kt");
      }

      @Test
      @TestMetadata("InnerClassNameClash.kt")
      public void testInnerClassNameClash() {
        runTest("compiler/testData/diagnostics/tests/inner/InnerClassNameClash.kt");
      }

      @Test
      @TestMetadata("innerClassesInStaticParameters.kt")
      public void testInnerClassesInStaticParameters() {
        runTest("compiler/testData/diagnostics/tests/inner/innerClassesInStaticParameters.kt");
      }

      @Test
      @TestMetadata("innerConstructorsFromQualifiers.kt")
      public void testInnerConstructorsFromQualifiers() {
        runTest("compiler/testData/diagnostics/tests/inner/innerConstructorsFromQualifiers.kt");
      }

      @Test
      @TestMetadata("innerConstructorsFromQualifiersWithIrrelevantCandidate.kt")
      public void testInnerConstructorsFromQualifiersWithIrrelevantCandidate() {
        runTest("compiler/testData/diagnostics/tests/inner/innerConstructorsFromQualifiersWithIrrelevantCandidate.kt");
      }

      @Test
      @TestMetadata("innerErrorForClassObjects.kt")
      public void testInnerErrorForClassObjects() {
        runTest("compiler/testData/diagnostics/tests/inner/innerErrorForClassObjects.kt");
      }

      @Test
      @TestMetadata("innerErrorForObjects.kt")
      public void testInnerErrorForObjects() {
        runTest("compiler/testData/diagnostics/tests/inner/innerErrorForObjects.kt");
      }

      @Test
      @TestMetadata("innerThisSuper.kt")
      public void testInnerThisSuper() {
        runTest("compiler/testData/diagnostics/tests/inner/innerThisSuper.kt");
      }

      @Test
      @TestMetadata("interfaceInInnerClass.kt")
      public void testInterfaceInInnerClass() {
        runTest("compiler/testData/diagnostics/tests/inner/interfaceInInnerClass.kt");
      }

      @Test
      @TestMetadata("kt5854.kt")
      public void testKt5854() {
        runTest("compiler/testData/diagnostics/tests/inner/kt5854.kt");
      }

      @Test
      @TestMetadata("kt6026.kt")
      public void testKt6026() {
        runTest("compiler/testData/diagnostics/tests/inner/kt6026.kt");
      }

      @Test
      @TestMetadata("localClass.kt")
      public void testLocalClass() {
        runTest("compiler/testData/diagnostics/tests/inner/localClass.kt");
      }

      @Test
      @TestMetadata("localClassInsideNested.kt")
      public void testLocalClassInsideNested() {
        runTest("compiler/testData/diagnostics/tests/inner/localClassInsideNested.kt");
      }

      @Test
      @TestMetadata("localThisSuper.kt")
      public void testLocalThisSuper() {
        runTest("compiler/testData/diagnostics/tests/inner/localThisSuper.kt");
      }

      @Test
      @TestMetadata("modality.kt")
      public void testModality() {
        runTest("compiler/testData/diagnostics/tests/inner/modality.kt");
      }

      @Test
      @TestMetadata("nestedClassAccessedViaInstanceReference.kt")
      public void testNestedClassAccessedViaInstanceReference() {
        runTest("compiler/testData/diagnostics/tests/inner/nestedClassAccessedViaInstanceReference.kt");
      }

      @Test
      @TestMetadata("nestedClassExtendsOuter.kt")
      public void testNestedClassExtendsOuter() {
        runTest("compiler/testData/diagnostics/tests/inner/nestedClassExtendsOuter.kt");
      }

      @Test
      @TestMetadata("nestedClassExtendsOuterGeneric.kt")
      public void testNestedClassExtendsOuterGeneric() {
        runTest("compiler/testData/diagnostics/tests/inner/nestedClassExtendsOuterGeneric.kt");
      }

      @Test
      @TestMetadata("nestedClassInObject.kt")
      public void testNestedClassInObject() {
        runTest("compiler/testData/diagnostics/tests/inner/nestedClassInObject.kt");
      }

      @Test
      @TestMetadata("nestedClassNotAllowed_after.kt")
      public void testNestedClassNotAllowed_after() {
        runTest("compiler/testData/diagnostics/tests/inner/nestedClassNotAllowed_after.kt");
      }

      @Test
      @TestMetadata("nestedClassNotAllowed_before.kt")
      public void testNestedClassNotAllowed_before() {
        runTest("compiler/testData/diagnostics/tests/inner/nestedClassNotAllowed_before.kt");
      }

      @Test
      @TestMetadata("nestedClassTypeParameterNameCollision.kt")
      public void testNestedClassTypeParameterNameCollision() {
        runTest("compiler/testData/diagnostics/tests/inner/nestedClassTypeParameterNameCollision.kt");
      }

      @Test
      @TestMetadata("nestedObject.kt")
      public void testNestedObject() {
        runTest("compiler/testData/diagnostics/tests/inner/nestedObject.kt");
      }

      @Test
      @TestMetadata("nestedVsInnerAccessOuterMember.kt")
      public void testNestedVsInnerAccessOuterMember() {
        runTest("compiler/testData/diagnostics/tests/inner/nestedVsInnerAccessOuterMember.kt");
      }

      @Test
      @TestMetadata("outerGenericParam.kt")
      public void testOuterGenericParam() {
        runTest("compiler/testData/diagnostics/tests/inner/outerGenericParam.kt");
      }

      @Test
      @TestMetadata("outerProtectedMember.kt")
      public void testOuterProtectedMember() {
        runTest("compiler/testData/diagnostics/tests/inner/outerProtectedMember.kt");
      }

      @Test
      @TestMetadata("outerSuperClassMember.kt")
      public void testOuterSuperClassMember() {
        runTest("compiler/testData/diagnostics/tests/inner/outerSuperClassMember.kt");
      }

      @Test
      @TestMetadata("referenceToSelfInLocal.kt")
      public void testReferenceToSelfInLocal() {
        runTest("compiler/testData/diagnostics/tests/inner/referenceToSelfInLocal.kt");
      }

      @Test
      @TestMetadata("resolvePackageClassInObjects.kt")
      public void testResolvePackageClassInObjects() {
        runTest("compiler/testData/diagnostics/tests/inner/resolvePackageClassInObjects.kt");
      }

      @Test
      @TestMetadata("selfAnnotationForClassObject.kt")
      public void testSelfAnnotationForClassObject() {
        runTest("compiler/testData/diagnostics/tests/inner/selfAnnotationForClassObject.kt");
      }

      @Test
      @TestMetadata("starProjectedInnerType.kt")
      public void testStarProjectedInnerType() {
        runTest("compiler/testData/diagnostics/tests/inner/starProjectedInnerType.kt");
      }

      @Test
      @TestMetadata("traits.kt")
      public void testTraits() {
        runTest("compiler/testData/diagnostics/tests/inner/traits.kt");
      }

      @Test
      @TestMetadata("typeVarianceConflict.kt")
      public void testTypeVarianceConflict() {
        runTest("compiler/testData/diagnostics/tests/inner/typeVarianceConflict.kt");
      }

      @Test
      @TestMetadata("typeVarianceConflictFeatureOn.kt")
      public void testTypeVarianceConflictFeatureOn() {
        runTest("compiler/testData/diagnostics/tests/inner/typeVarianceConflictFeatureOn.kt");
      }

      @Test
      @TestMetadata("uninitializedSuperType.kt")
      public void testUninitializedSuperType() {
        runTest("compiler/testData/diagnostics/tests/inner/uninitializedSuperType.kt");
      }

      @Test
      @TestMetadata("visibility.kt")
      public void testVisibility() {
        runTest("compiler/testData/diagnostics/tests/inner/visibility.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression")
      @TestDataPath("$PROJECT_ROOT")
      public class QualifiedExpression {
        @Test
        public void testAllFilesPresentInQualifiedExpression() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inner/qualifiedExpression"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("classObjectOfNestedClass.kt")
        public void testClassObjectOfNestedClass() {
          runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/classObjectOfNestedClass.kt");
        }

        @Test
        @TestMetadata("constructNestedClass.kt")
        public void testConstructNestedClass() {
          runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/constructNestedClass.kt");
        }

        @Test
        @TestMetadata("dataLocalVariable.kt")
        public void testDataLocalVariable() {
          runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/dataLocalVariable.kt");
        }

        @Test
        @TestMetadata("enumConstant.kt")
        public void testEnumConstant() {
          runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/enumConstant.kt");
        }

        @Test
        @TestMetadata("genericNestedClass.kt")
        public void testGenericNestedClass() {
          runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/genericNestedClass.kt");
        }

        @Test
        @TestMetadata("importNestedClass.kt")
        public void testImportNestedClass() {
          runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/importNestedClass.kt");
        }

        @Test
        @TestMetadata("nestedClassInPackage.kt")
        public void testNestedClassInPackage() {
          runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/nestedClassInPackage.kt");
        }

        @Test
        @TestMetadata("nestedEnumConstant.kt")
        public void testNestedEnumConstant() {
          runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/nestedEnumConstant.kt");
        }

        @Test
        @TestMetadata("nestedObjects.kt")
        public void testNestedObjects() {
          runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/nestedObjects.kt");
        }

        @Test
        @TestMetadata("typePosition.kt")
        public void testTypePosition() {
          runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/typePosition.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/integerLiterals")
    @TestDataPath("$PROJECT_ROOT")
    public class IntegerLiterals {
      @Test
      public void testAllFilesPresentInIntegerLiterals() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/integerLiterals"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("complexMapping.kt")
      public void testComplexMapping() {
        runTest("compiler/testData/diagnostics/tests/integerLiterals/complexMapping.kt");
      }

      @Test
      @TestMetadata("constantUnaryOperators.kt")
      public void testConstantUnaryOperators() {
        runTest("compiler/testData/diagnostics/tests/integerLiterals/constantUnaryOperators.kt");
      }

      @Test
      @TestMetadata("IltAsExtensionReceiver.kt")
      public void testIltAsExtensionReceiver() {
        runTest("compiler/testData/diagnostics/tests/integerLiterals/IltAsExtensionReceiver.kt");
      }

      @Test
      @TestMetadata("intToLongConversion.kt")
      public void testIntToLongConversion() {
        runTest("compiler/testData/diagnostics/tests/integerLiterals/intToLongConversion.kt");
      }

      @Test
      @TestMetadata("literalInCompletedGeneric.kt")
      public void testLiteralInCompletedGeneric() {
        runTest("compiler/testData/diagnostics/tests/integerLiterals/literalInCompletedGeneric.kt");
      }

      @Test
      @TestMetadata("literalsInInference.kt")
      public void testLiteralsInInference() {
        runTest("compiler/testData/diagnostics/tests/integerLiterals/literalsInInference.kt");
      }

      @Test
      @TestMetadata("sortedBy.kt")
      public void testSortedBy() {
        runTest("compiler/testData/diagnostics/tests/integerLiterals/sortedBy.kt");
      }

      @Test
      @TestMetadata("typealiasOnLong.kt")
      public void testTypealiasOnLong() {
        runTest("compiler/testData/diagnostics/tests/integerLiterals/typealiasOnLong.kt");
      }

      @Test
      @TestMetadata("vararg.kt")
      public void testVararg() {
        runTest("compiler/testData/diagnostics/tests/integerLiterals/vararg.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests/j+k")
    @TestDataPath("$PROJECT_ROOT")
    public class J_k {
      @Test
      @TestMetadata("accessClassObjectFromJava.kt")
      public void testAccessClassObjectFromJava() {
        runTest("compiler/testData/diagnostics/tests/j+k/accessClassObjectFromJava.kt");
      }

      @Test
      public void testAllFilesPresentInJ_k() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
      }

      @Test
      @TestMetadata("ambiguousSamAdapters.kt")
      public void testAmbiguousSamAdapters() {
        runTest("compiler/testData/diagnostics/tests/j+k/ambiguousSamAdapters.kt");
      }

      @Test
      @TestMetadata("annotationWithArgumentsMissingDependencies.kt")
      public void testAnnotationWithArgumentsMissingDependencies() {
        runTest("compiler/testData/diagnostics/tests/j+k/annotationWithArgumentsMissingDependencies.kt");
      }

      @Test
      @TestMetadata("annotationsInheritance.kt")
      public void testAnnotationsInheritance() {
        runTest("compiler/testData/diagnostics/tests/j+k/annotationsInheritance.kt");
      }

      @Test
      @TestMetadata("arrayAnnotationConstructorReference.kt")
      public void testArrayAnnotationConstructorReference() {
        runTest("compiler/testData/diagnostics/tests/j+k/arrayAnnotationConstructorReference.kt");
      }

      @Test
      @TestMetadata("arrayOfStarParametrized.kt")
      public void testArrayOfStarParametrized() {
        runTest("compiler/testData/diagnostics/tests/j+k/arrayOfStarParametrized.kt");
      }

      @Test
      @TestMetadata("callableReferencesStaticMemberClash.kt")
      public void testCallableReferencesStaticMemberClash() {
        runTest("compiler/testData/diagnostics/tests/j+k/callableReferencesStaticMemberClash.kt");
      }

      @Test
      @TestMetadata("canDeclareIfSamAdapterIsInherited.kt")
      public void testCanDeclareIfSamAdapterIsInherited() {
        runTest("compiler/testData/diagnostics/tests/j+k/canDeclareIfSamAdapterIsInherited.kt");
      }

      @Test
      @TestMetadata("collectionsInKJKcall.kt")
      public void testCollectionsInKJKcall() {
        runTest("compiler/testData/diagnostics/tests/j+k/collectionsInKJKcall.kt");
      }

      @Test
      @TestMetadata("collectorInference.kt")
      public void testCollectorInference() {
        runTest("compiler/testData/diagnostics/tests/j+k/collectorInference.kt");
      }

      @Test
      @TestMetadata("complexGenericOverride.kt")
      public void testComplexGenericOverride() {
        runTest("compiler/testData/diagnostics/tests/j+k/complexGenericOverride.kt");
      }

      @Test
      @TestMetadata("computeIfAbsentConcurrent.kt")
      public void testComputeIfAbsentConcurrent() {
        runTest("compiler/testData/diagnostics/tests/j+k/computeIfAbsentConcurrent.kt");
      }

      @Test
      @TestMetadata("contravariantIterable.kt")
      public void testContravariantIterable() {
        runTest("compiler/testData/diagnostics/tests/j+k/contravariantIterable.kt");
      }

      @Test
      @TestMetadata("defaultMethods.kt")
      public void testDefaultMethods() {
        runTest("compiler/testData/diagnostics/tests/j+k/defaultMethods.kt");
      }

      @Test
      @TestMetadata("defaultMethodsIndirectInheritance.kt")
      public void testDefaultMethodsIndirectInheritance() {
        runTest("compiler/testData/diagnostics/tests/j+k/defaultMethodsIndirectInheritance.kt");
      }

      @Test
      @TestMetadata("defaultMethodsIndirectInheritance_before.kt")
      public void testDefaultMethodsIndirectInheritance_before() {
        runTest("compiler/testData/diagnostics/tests/j+k/defaultMethodsIndirectInheritance_before.kt");
      }

      @Test
      @TestMetadata("defaultMethods_before.kt")
      public void testDefaultMethods_before() {
        runTest("compiler/testData/diagnostics/tests/j+k/defaultMethods_before.kt");
      }

      @Test
      @TestMetadata("differentFilename.kt")
      public void testDifferentFilename() {
        runTest("compiler/testData/diagnostics/tests/j+k/differentFilename.kt");
      }

      @Test
      @TestMetadata("enumGetOrdinal.kt")
      public void testEnumGetOrdinal() {
        runTest("compiler/testData/diagnostics/tests/j+k/enumGetOrdinal.kt");
      }

      @Test
      @TestMetadata("exceptionMessage.kt")
      public void testExceptionMessage() {
        runTest("compiler/testData/diagnostics/tests/j+k/exceptionMessage.kt");
      }

      @Test
      @TestMetadata("fieldOverridesField.kt")
      public void testFieldOverridesField() {
        runTest("compiler/testData/diagnostics/tests/j+k/fieldOverridesField.kt");
      }

      @Test
      @TestMetadata("fieldOverridesFieldOfDifferentType.kt")
      public void testFieldOverridesFieldOfDifferentType() {
        runTest("compiler/testData/diagnostics/tests/j+k/fieldOverridesFieldOfDifferentType.kt");
      }

      @Test
      @TestMetadata("fieldOverridesNothing.kt")
      public void testFieldOverridesNothing() {
        runTest("compiler/testData/diagnostics/tests/j+k/fieldOverridesNothing.kt");
      }

      @Test
      @TestMetadata("fileJvmNameSameAsClass.kt")
      public void testFileJvmNameSameAsClass() {
        runTest("compiler/testData/diagnostics/tests/j+k/fileJvmNameSameAsClass.kt");
      }

      @Test
      @TestMetadata("finalCollectionSize.kt")
      public void testFinalCollectionSize() {
        runTest("compiler/testData/diagnostics/tests/j+k/finalCollectionSize.kt");
      }

      @Test
      @TestMetadata("flexibleNothing.kt")
      public void testFlexibleNothing() {
        runTest("compiler/testData/diagnostics/tests/j+k/flexibleNothing.kt");
      }

      @Test
      @TestMetadata("flexibleTypeVariablePosition.kt")
      public void testFlexibleTypeVariablePosition() {
        runTest("compiler/testData/diagnostics/tests/j+k/flexibleTypeVariablePosition.kt");
      }

      @Test
      @TestMetadata("flexibleTypeVariablePositionDnnRepresentation.kt")
      public void testFlexibleTypeVariablePositionDnnRepresentation() {
        runTest("compiler/testData/diagnostics/tests/j+k/flexibleTypeVariablePositionDnnRepresentation.kt");
      }

      @Test
      @TestMetadata("futureGet.kt")
      public void testFutureGet() {
        runTest("compiler/testData/diagnostics/tests/j+k/futureGet.kt");
      }

      @Test
      @TestMetadata("futureGetDnnRepresentation.kt")
      public void testFutureGetDnnRepresentation() {
        runTest("compiler/testData/diagnostics/tests/j+k/futureGetDnnRepresentation.kt");
      }

      @Test
      @TestMetadata("genericConstructorWithMultipleBounds.kt")
      public void testGenericConstructorWithMultipleBounds() {
        runTest("compiler/testData/diagnostics/tests/j+k/genericConstructorWithMultipleBounds.kt");
      }

      @Test
      @TestMetadata("GenericsInSupertypes.kt")
      public void testGenericsInSupertypes() {
        runTest("compiler/testData/diagnostics/tests/j+k/GenericsInSupertypes.kt");
      }

      @Test
      @TestMetadata("inheritAbstractSamAdapter.kt")
      public void testInheritAbstractSamAdapter() {
        runTest("compiler/testData/diagnostics/tests/j+k/inheritAbstractSamAdapter.kt");
      }

      @Test
      @TestMetadata("inheritanceStaticMethodFromInterface.kt")
      public void testInheritanceStaticMethodFromInterface() {
        runTest("compiler/testData/diagnostics/tests/j+k/inheritanceStaticMethodFromInterface.kt");
      }

      @Test
      @TestMetadata("InheritedGenericFunction.kt")
      public void testInheritedGenericFunction() {
        runTest("compiler/testData/diagnostics/tests/j+k/InheritedGenericFunction.kt");
      }

      @Test
      @TestMetadata("InnerClassFromJava.kt")
      public void testInnerClassFromJava() {
        runTest("compiler/testData/diagnostics/tests/j+k/InnerClassFromJava.kt");
      }

      @Test
      @TestMetadata("innerLightClass.kt")
      public void testInnerLightClass() {
        runTest("compiler/testData/diagnostics/tests/j+k/innerLightClass.kt");
      }

      @Test
      @TestMetadata("innerNestedClassFromJava.kt")
      public void testInnerNestedClassFromJava() {
        runTest("compiler/testData/diagnostics/tests/j+k/innerNestedClassFromJava.kt");
      }

      @Test
      @TestMetadata("integerNotNullable.kt")
      public void testIntegerNotNullable() {
        runTest("compiler/testData/diagnostics/tests/j+k/integerNotNullable.kt");
      }

      @Test
      @TestMetadata("internalClash.kt")
      public void testInternalClash() {
        runTest("compiler/testData/diagnostics/tests/j+k/internalClash.kt");
      }

      @Test
      @TestMetadata("internalClash2.kt")
      public void testInternalClash2() {
        runTest("compiler/testData/diagnostics/tests/j+k/internalClash2.kt");
      }

      @Test
      @TestMetadata("intersectionWithJavaVoidNothing.kt")
      public void testIntersectionWithJavaVoidNothing() {
        runTest("compiler/testData/diagnostics/tests/j+k/intersectionWithJavaVoidNothing.kt");
      }

      @Test
      @TestMetadata("invisibleFake.kt")
      public void testInvisibleFake() {
        runTest("compiler/testData/diagnostics/tests/j+k/invisibleFake.kt");
      }

      @Test
      @TestMetadata("invisibleFake2.kt")
      public void testInvisibleFake2() {
        runTest("compiler/testData/diagnostics/tests/j+k/invisibleFake2.kt");
      }

      @Test
      @TestMetadata("invisiblePackagePrivateInheritedMember.kt")
      public void testInvisiblePackagePrivateInheritedMember() {
        runTest("compiler/testData/diagnostics/tests/j+k/invisiblePackagePrivateInheritedMember.kt");
      }

      @Test
      @TestMetadata("javaLangStringCtr.kt")
      public void testJavaLangStringCtr() {
        runTest("compiler/testData/diagnostics/tests/j+k/javaLangStringCtr.kt");
      }

      @Test
      @TestMetadata("javaLikeCallOnTypeParameter.kt")
      public void testJavaLikeCallOnTypeParameter() {
        runTest("compiler/testData/diagnostics/tests/j+k/javaLikeCallOnTypeParameter.kt");
      }

      @Test
      @TestMetadata("javaStaticImport.kt")
      public void testJavaStaticImport() {
        runTest("compiler/testData/diagnostics/tests/j+k/javaStaticImport.kt");
      }

      @Test
      @TestMetadata("javaSupertypeNameDisambiguation.kt")
      public void testJavaSupertypeNameDisambiguation() {
        runTest("compiler/testData/diagnostics/tests/j+k/javaSupertypeNameDisambiguation.kt");
      }

      @Test
      @TestMetadata("jkjPrivateProperty.kt")
      public void testJkjPrivateProperty() {
        runTest("compiler/testData/diagnostics/tests/j+k/jkjPrivateProperty.kt");
      }

      @Test
      @TestMetadata("KJKInheritance.kt")
      public void testKJKInheritance() {
        runTest("compiler/testData/diagnostics/tests/j+k/KJKInheritance.kt");
      }

      @Test
      @TestMetadata("KJKInheritanceGeneric.kt")
      public void testKJKInheritanceGeneric() {
        runTest("compiler/testData/diagnostics/tests/j+k/KJKInheritanceGeneric.kt");
      }

      @Test
      @TestMetadata("kjkImplicitReturnType.kt")
      public void testKjkImplicitReturnType() {
        runTest("compiler/testData/diagnostics/tests/j+k/kjkImplicitReturnType.kt");
      }

      @Test
      @TestMetadata("kjkRawTypeWithKotlinUpperBound.kt")
      public void testKjkRawTypeWithKotlinUpperBound() {
        runTest("compiler/testData/diagnostics/tests/j+k/kjkRawTypeWithKotlinUpperBound.kt");
      }

      @Test
      @TestMetadata("kjkimplicitTypesCrash.kt")
      public void testKjkimplicitTypesCrash() {
        runTest("compiler/testData/diagnostics/tests/j+k/kjkimplicitTypesCrash.kt");
      }

      @Test
      @TestMetadata("kt1402.kt")
      public void testKt1402() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt1402.kt");
      }

      @Test
      @TestMetadata("kt1431.kt")
      public void testKt1431() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt1431.kt");
      }

      @Test
      @TestMetadata("kt1730_implementCharSequence.kt")
      public void testKt1730_implementCharSequence() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt1730_implementCharSequence.kt");
      }

      @Test
      @TestMetadata("kt2152.kt")
      public void testKt2152() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt2152.kt");
      }

      @Test
      @TestMetadata("kt2394.kt")
      public void testKt2394() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt2394.kt");
      }

      @Test
      @TestMetadata("kt2606.kt")
      public void testKt2606() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt2606.kt");
      }

      @Test
      @TestMetadata("kt2619.kt")
      public void testKt2619() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt2619.kt");
      }

      @Test
      @TestMetadata("kt2641.kt")
      public void testKt2641() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt2641.kt");
      }

      @Test
      @TestMetadata("kt2890.kt")
      public void testKt2890() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt2890.kt");
      }

      @Test
      @TestMetadata("kt3307.kt")
      public void testKt3307() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt3307.kt");
      }

      @Test
      @TestMetadata("kt3311.kt")
      public void testKt3311() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt3311.kt");
      }

      @Test
      @TestMetadata("kt36856.kt")
      public void testKt36856() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt36856.kt");
      }

      @Test
      @TestMetadata("kt60580.kt")
      public void testKt60580() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt60580.kt");
      }

      @Test
      @TestMetadata("kt62118.kt")
      public void testKt62118() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt62118.kt");
      }

      @Test
      @TestMetadata("kt62197.kt")
      public void testKt62197() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt62197.kt");
      }

      @Test
      @TestMetadata("kt6720_abstractProperty.kt")
      public void testKt6720_abstractProperty() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt6720_abstractProperty.kt");
      }

      @Test
      @TestMetadata("kt7523.kt")
      public void testKt7523() {
        runTest("compiler/testData/diagnostics/tests/j+k/kt7523.kt");
      }

      @Test
      @TestMetadata("ktij24272.kt")
      public void testKtij24272() {
        runTest("compiler/testData/diagnostics/tests/j+k/ktij24272.kt");
      }

      @Test
      @TestMetadata("matchers.kt")
      public void testMatchers() {
        runTest("compiler/testData/diagnostics/tests/j+k/matchers.kt");
      }

      @Test
      @TestMetadata("mutableIterator.kt")
      public void testMutableIterator() {
        runTest("compiler/testData/diagnostics/tests/j+k/mutableIterator.kt");
      }

      @Test
      @TestMetadata("nullForOptionalOf.kt")
      public void testNullForOptionalOf() {
        runTest("compiler/testData/diagnostics/tests/j+k/nullForOptionalOf.kt");
      }

      @Test
      @TestMetadata("nullForOptionalOrElse.kt")
      public void testNullForOptionalOrElse() {
        runTest("compiler/testData/diagnostics/tests/j+k/nullForOptionalOrElse.kt");
      }

      @Test
      @TestMetadata("nullableLinkedListToQueue.kt")
      public void testNullableLinkedListToQueue() {
        runTest("compiler/testData/diagnostics/tests/j+k/nullableLinkedListToQueue.kt");
      }

      @Test
      @TestMetadata("nullableLinkedListToQueueDnnRepresentation.kt")
      public void testNullableLinkedListToQueueDnnRepresentation() {
        runTest("compiler/testData/diagnostics/tests/j+k/nullableLinkedListToQueueDnnRepresentation.kt");
      }

      @Test
      @TestMetadata("nullableRawTypeWithFlexibleArguments.kt")
      public void testNullableRawTypeWithFlexibleArguments() {
        runTest("compiler/testData/diagnostics/tests/j+k/nullableRawTypeWithFlexibleArguments.kt");
      }

      @Test
      @TestMetadata("orderOfSupertypesAndFakeOverrides_1.kt")
      public void testOrderOfSupertypesAndFakeOverrides_1() {
        runTest("compiler/testData/diagnostics/tests/j+k/orderOfSupertypesAndFakeOverrides_1.kt");
      }

      @Test
      @TestMetadata("orderOfSupertypesAndFakeOverrides_2.kt")
      public void testOrderOfSupertypesAndFakeOverrides_2() {
        runTest("compiler/testData/diagnostics/tests/j+k/orderOfSupertypesAndFakeOverrides_2.kt");
      }

      @Test
      @TestMetadata("overrideForMemberExtensionProp.kt")
      public void testOverrideForMemberExtensionProp() {
        runTest("compiler/testData/diagnostics/tests/j+k/overrideForMemberExtensionProp.kt");
      }

      @Test
      @TestMetadata("overrideRawType.kt")
      public void testOverrideRawType() {
        runTest("compiler/testData/diagnostics/tests/j+k/overrideRawType.kt");
      }

      @Test
      @TestMetadata("OverrideVararg.kt")
      public void testOverrideVararg() {
        runTest("compiler/testData/diagnostics/tests/j+k/OverrideVararg.kt");
      }

      @Test
      @TestMetadata("overrideWithErasure.kt")
      public void testOverrideWithErasure() {
        runTest("compiler/testData/diagnostics/tests/j+k/overrideWithErasure.kt");
      }

      @Test
      @TestMetadata("overrideWithSamAndTypeParameter.kt")
      public void testOverrideWithSamAndTypeParameter() {
        runTest("compiler/testData/diagnostics/tests/j+k/overrideWithSamAndTypeParameter.kt");
      }

      @Test
      @TestMetadata("overrideWithTypeParameter.kt")
      public void testOverrideWithTypeParameter() {
        runTest("compiler/testData/diagnostics/tests/j+k/overrideWithTypeParameter.kt");
      }

      @Test
      @TestMetadata("overrideWithTypeParameterAfter.kt")
      public void testOverrideWithTypeParameterAfter() {
        runTest("compiler/testData/diagnostics/tests/j+k/overrideWithTypeParameterAfter.kt");
      }

      @Test
      @TestMetadata("overrideWithTypeParameterReverse.kt")
      public void testOverrideWithTypeParameterReverse() {
        runTest("compiler/testData/diagnostics/tests/j+k/overrideWithTypeParameterReverse.kt");
      }

      @Test
      @TestMetadata("overrideWithTypeParameterReverseAfter.kt")
      public void testOverrideWithTypeParameterReverseAfter() {
        runTest("compiler/testData/diagnostics/tests/j+k/overrideWithTypeParameterReverseAfter.kt");
      }

      @Test
      @TestMetadata("packagePrivateClassStaticMember.kt")
      public void testPackagePrivateClassStaticMember() {
        runTest("compiler/testData/diagnostics/tests/j+k/packagePrivateClassStaticMember.kt");
      }

      @Test
      @TestMetadata("packageVisibility.kt")
      public void testPackageVisibility() {
        runTest("compiler/testData/diagnostics/tests/j+k/packageVisibility.kt");
      }

      @Test
      @TestMetadata("privateFieldOverridesNothing.kt")
      public void testPrivateFieldOverridesNothing() {
        runTest("compiler/testData/diagnostics/tests/j+k/privateFieldOverridesNothing.kt");
      }

      @Test
      @TestMetadata("privateNestedClassStaticMember.kt")
      public void testPrivateNestedClassStaticMember() {
        runTest("compiler/testData/diagnostics/tests/j+k/privateNestedClassStaticMember.kt");
      }

      @Test
      @TestMetadata("privatePropertyAndSetterMultiModule.kt")
      public void testPrivatePropertyAndSetterMultiModule() {
        runTest("compiler/testData/diagnostics/tests/j+k/privatePropertyAndSetterMultiModule.kt");
      }

      @Test
      @TestMetadata("propagateFlexibleTypeToAnonymousFunction.kt")
      public void testPropagateFlexibleTypeToAnonymousFunction() {
        runTest("compiler/testData/diagnostics/tests/j+k/propagateFlexibleTypeToAnonymousFunction.kt");
      }

      @Test
      @TestMetadata("protectedStaticSamePackage.kt")
      public void testProtectedStaticSamePackage() {
        runTest("compiler/testData/diagnostics/tests/j+k/protectedStaticSamePackage.kt");
      }

      @Test
      @TestMetadata("purelyImplementedSupertype.kt")
      public void testPurelyImplementedSupertype() {
        runTest("compiler/testData/diagnostics/tests/j+k/purelyImplementedSupertype.kt");
      }

      @Test
      @TestMetadata("rawOverride.kt")
      public void testRawOverride() {
        runTest("compiler/testData/diagnostics/tests/j+k/rawOverride.kt");
      }

      @Test
      @TestMetadata("rawTypeCrash.kt")
      public void testRawTypeCrash() {
        runTest("compiler/testData/diagnostics/tests/j+k/rawTypeCrash.kt");
      }

      @Test
      @TestMetadata("rawTypeScope.kt")
      public void testRawTypeScope() {
        runTest("compiler/testData/diagnostics/tests/j+k/rawTypeScope.kt");
      }

      @Test
      @TestMetadata("rawTypesFromCaptured.kt")
      public void testRawTypesFromCaptured() {
        runTest("compiler/testData/diagnostics/tests/j+k/rawTypesFromCaptured.kt");
      }

      @Test
      @TestMetadata("rawTypesFromCapturedOriginal.kt")
      public void testRawTypesFromCapturedOriginal() {
        runTest("compiler/testData/diagnostics/tests/j+k/rawTypesFromCapturedOriginal.kt");
      }

      @Test
      @TestMetadata("rawUpperBounds.kt")
      public void testRawUpperBounds() {
        runTest("compiler/testData/diagnostics/tests/j+k/rawUpperBounds.kt");
      }

      @Test
      @TestMetadata("receiverEnhancement.kt")
      public void testReceiverEnhancement() {
        runTest("compiler/testData/diagnostics/tests/j+k/receiverEnhancement.kt");
      }

      @Test
      @TestMetadata("recursionWithJavaSyntheticProperty.kt")
      public void testRecursionWithJavaSyntheticProperty() {
        runTest("compiler/testData/diagnostics/tests/j+k/recursionWithJavaSyntheticProperty.kt");
      }

      @Test
      @TestMetadata("recursiveRawUpperBound.kt")
      public void testRecursiveRawUpperBound() {
        runTest("compiler/testData/diagnostics/tests/j+k/recursiveRawUpperBound.kt");
      }

      @Test
      @TestMetadata("recursiveRawUpperBound2.kt")
      public void testRecursiveRawUpperBound2() {
        runTest("compiler/testData/diagnostics/tests/j+k/recursiveRawUpperBound2.kt");
      }

      @Test
      @TestMetadata("recursiveRawUpperBound3.kt")
      public void testRecursiveRawUpperBound3() {
        runTest("compiler/testData/diagnostics/tests/j+k/recursiveRawUpperBound3.kt");
      }

      @Test
      @TestMetadata("recursiveSelfTypes.kt")
      public void testRecursiveSelfTypes() {
        runTest("compiler/testData/diagnostics/tests/j+k/recursiveSelfTypes.kt");
      }

      @Test
      @TestMetadata("runnableOrCallable.kt")
      public void testRunnableOrCallable() {
        runTest("compiler/testData/diagnostics/tests/j+k/runnableOrCallable.kt");
      }

      @Test
      @TestMetadata("safeCallDefinitelyNotNull.kt")
      public void testSafeCallDefinitelyNotNull() {
        runTest("compiler/testData/diagnostics/tests/j+k/safeCallDefinitelyNotNull.kt");
      }

      @Test
      @TestMetadata("samInConstructorWithGenerics.kt")
      public void testSamInConstructorWithGenerics() {
        runTest("compiler/testData/diagnostics/tests/j+k/samInConstructorWithGenerics.kt");
      }

      @Test
      @TestMetadata("samWithConsumer.kt")
      public void testSamWithConsumer() {
        runTest("compiler/testData/diagnostics/tests/j+k/samWithConsumer.kt");
      }

      @Test
      @TestMetadata("selectMoreSpecific.kt")
      public void testSelectMoreSpecific() {
        runTest("compiler/testData/diagnostics/tests/j+k/selectMoreSpecific.kt");
      }

      @Test
      @TestMetadata("serializable.kt")
      public void testSerializable() {
        runTest("compiler/testData/diagnostics/tests/j+k/serializable.kt");
      }

      @Test
      @TestMetadata("shadowingPrimitiveStaticField.kt")
      public void testShadowingPrimitiveStaticField() {
        runTest("compiler/testData/diagnostics/tests/j+k/shadowingPrimitiveStaticField.kt");
      }

      @Test
      @TestMetadata("Simple.kt")
      public void testSimple() {
        runTest("compiler/testData/diagnostics/tests/j+k/Simple.kt");
      }

      @Test
      @TestMetadata("specialBridges.kt")
      public void testSpecialBridges() {
        runTest("compiler/testData/diagnostics/tests/j+k/specialBridges.kt");
      }

      @Test
      @TestMetadata("staticImportViaInheritance.kt")
      public void testStaticImportViaInheritance() {
        runTest("compiler/testData/diagnostics/tests/j+k/staticImportViaInheritance.kt");
      }

      @Test
      @TestMetadata("StaticMembersFromSuperclasses.kt")
      public void testStaticMembersFromSuperclasses() {
        runTest("compiler/testData/diagnostics/tests/j+k/StaticMembersFromSuperclasses.kt");
      }

      @Test
      @TestMetadata("staticMethodInClass.kt")
      public void testStaticMethodInClass() {
        runTest("compiler/testData/diagnostics/tests/j+k/staticMethodInClass.kt");
      }

      @Test
      @TestMetadata("SupertypeArgumentsNullability-NotNull-SpecialTypes.kt")
      public void testSupertypeArgumentsNullability_NotNull_SpecialTypes() {
        runTest("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-NotNull-SpecialTypes.kt");
      }

      @Test
      @TestMetadata("SupertypeArgumentsNullability-NotNull-UserTypes.kt")
      public void testSupertypeArgumentsNullability_NotNull_UserTypes() {
        runTest("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-NotNull-UserTypes.kt");
      }

      @Test
      @TestMetadata("SupertypeArgumentsNullability-SpecialTypes.kt")
      public void testSupertypeArgumentsNullability_SpecialTypes() {
        runTest("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-SpecialTypes.kt");
      }

      @Test
      @TestMetadata("SupertypeArgumentsNullability-UserTypes.kt")
      public void testSupertypeArgumentsNullability_UserTypes() {
        runTest("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-UserTypes.kt");
      }

      @Test
      @TestMetadata("supertypeUsesNested.kt")
      public void testSupertypeUsesNested() {
        runTest("compiler/testData/diagnostics/tests/j+k/supertypeUsesNested.kt");
      }

      @Test
      @TestMetadata("syntheticAssignmentInLambdaExpressionBody.kt")
      public void testSyntheticAssignmentInLambdaExpressionBody() {
        runTest("compiler/testData/diagnostics/tests/j+k/syntheticAssignmentInLambdaExpressionBody.kt");
      }

      @Test
      @TestMetadata("syntheticPropertyOverridden.kt")
      public void testSyntheticPropertyOverridden() {
        runTest("compiler/testData/diagnostics/tests/j+k/syntheticPropertyOverridden.kt");
      }

      @Test
      @TestMetadata("syntheticPropertyOverridden2.kt")
      public void testSyntheticPropertyOverridden2() {
        runTest("compiler/testData/diagnostics/tests/j+k/syntheticPropertyOverridden2.kt");
      }

      @Test
      @TestMetadata("throwableConstructor.kt")
      public void testThrowableConstructor() {
        runTest("compiler/testData/diagnostics/tests/j+k/throwableConstructor.kt");
      }

      @Test
      @TestMetadata("traitDefaultCall.kt")
      public void testTraitDefaultCall() {
        runTest("compiler/testData/diagnostics/tests/j+k/traitDefaultCall.kt");
      }

      @Test
      @TestMetadata("typeAliasWithSamConstructor.kt")
      public void testTypeAliasWithSamConstructor() {
        runTest("compiler/testData/diagnostics/tests/j+k/typeAliasWithSamConstructor.kt");
      }

      @Test
      @TestMetadata("typeFromGenericFunWithAnnotation.kt")
      public void testTypeFromGenericFunWithAnnotation() {
        runTest("compiler/testData/diagnostics/tests/j+k/typeFromGenericFunWithAnnotation.kt");
      }

      @Test
      @TestMetadata("typeFromGenericFunWithAnnotationDnnRepresentation.kt")
      public void testTypeFromGenericFunWithAnnotationDnnRepresentation() {
        runTest("compiler/testData/diagnostics/tests/j+k/typeFromGenericFunWithAnnotationDnnRepresentation.kt");
      }

      @Test
      @TestMetadata("typeFromGenericWithAnnotation.kt")
      public void testTypeFromGenericWithAnnotation() {
        runTest("compiler/testData/diagnostics/tests/j+k/typeFromGenericWithAnnotation.kt");
      }

      @Test
      @TestMetadata("typeFromGenericWithAnnotationDnnRepresentation.kt")
      public void testTypeFromGenericWithAnnotationDnnRepresentation() {
        runTest("compiler/testData/diagnostics/tests/j+k/typeFromGenericWithAnnotationDnnRepresentation.kt");
      }

      @Test
      @TestMetadata("typeFromJavaGeneric.kt")
      public void testTypeFromJavaGeneric() {
        runTest("compiler/testData/diagnostics/tests/j+k/typeFromJavaGeneric.kt");
      }

      @Test
      @TestMetadata("typeFromJavaGenericDnnRepresentation.kt")
      public void testTypeFromJavaGenericDnnRepresentation() {
        runTest("compiler/testData/diagnostics/tests/j+k/typeFromJavaGenericDnnRepresentation.kt");
      }

      @Test
      @TestMetadata("typeFromJavaGenericFun.kt")
      public void testTypeFromJavaGenericFun() {
        runTest("compiler/testData/diagnostics/tests/j+k/typeFromJavaGenericFun.kt");
      }

      @Test
      @TestMetadata("typeFromJavaGenericFunDnnRepresentation.kt")
      public void testTypeFromJavaGenericFunDnnRepresentation() {
        runTest("compiler/testData/diagnostics/tests/j+k/typeFromJavaGenericFunDnnRepresentation.kt");
      }

      @Test
      @TestMetadata("UnboxingNulls.kt")
      public void testUnboxingNulls() {
        runTest("compiler/testData/diagnostics/tests/j+k/UnboxingNulls.kt");
      }

      @Test
      @TestMetadata("withTestConnection.kt")
      public void testWithTestConnection() {
        runTest("compiler/testData/diagnostics/tests/j+k/withTestConnection.kt");
      }

      @Test
      @TestMetadata("withTestConnection2.kt")
      public void testWithTestConnection2() {
        runTest("compiler/testData/diagnostics/tests/j+k/withTestConnection2.kt");
      }

      @Test
      @TestMetadata("withTestConnection3.kt")
      public void testWithTestConnection3() {
        runTest("compiler/testData/diagnostics/tests/j+k/withTestConnection3.kt");
      }

      @Test
      @TestMetadata("withTestConnection4.kt")
      public void testWithTestConnection4() {
        runTest("compiler/testData/diagnostics/tests/j+k/withTestConnection4.kt");
      }

      @Test
      @TestMetadata("wrongVarianceInJava.kt")
      public void testWrongVarianceInJava() {
        runTest("compiler/testData/diagnostics/tests/j+k/wrongVarianceInJava.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/j+k/brokenCode")
      @TestDataPath("$PROJECT_ROOT")
      public class BrokenCode {
        @Test
        public void testAllFilesPresentInBrokenCode() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/brokenCode"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("classDuplicates.kt")
        public void testClassDuplicates() {
          runTest("compiler/testData/diagnostics/tests/j+k/brokenCode/classDuplicates.kt");
        }

        @Test
        @TestMetadata("fieldDuplicates.kt")
        public void testFieldDuplicates() {
          runTest("compiler/testData/diagnostics/tests/j+k/brokenCode/fieldDuplicates.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides")
      @TestDataPath("$PROJECT_ROOT")
      public class CollectionOverrides {
        @Test
        public void testAllFilesPresentInCollectionOverrides() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/collectionOverrides"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("charAtAndOverloadWithoutExplicitOverride.kt")
        public void testCharAtAndOverloadWithoutExplicitOverride() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/charAtAndOverloadWithoutExplicitOverride.kt");
        }

        @Test
        @TestMetadata("charBuffer.kt")
        public void testCharBuffer() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/charBuffer.kt");
        }

        @Test
        @TestMetadata("collectionStringImpl.kt")
        public void testCollectionStringImpl() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/collectionStringImpl.kt");
        }

        @Test
        @TestMetadata("commonCollections.kt")
        public void testCommonCollections() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/commonCollections.kt");
        }

        @Test
        @TestMetadata("contains.kt")
        public void testContains() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/contains.kt");
        }

        @Test
        @TestMetadata("containsAll.kt")
        public void testContainsAll() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/containsAll.kt");
        }

        @Test
        @TestMetadata("containsAndOverload.kt")
        public void testContainsAndOverload() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/containsAndOverload.kt");
        }

        @Test
        @TestMetadata("containsAndOverloadWithoutExplicitOverride.kt")
        public void testContainsAndOverloadWithoutExplicitOverride() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/containsAndOverloadWithoutExplicitOverride.kt");
        }

        @Test
        @TestMetadata("getCharSequence.kt")
        public void testGetCharSequence() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/getCharSequence.kt");
        }

        @Test
        @TestMetadata("intersectionWithMappedSignature.kt")
        public void testIntersectionWithMappedSignature() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/intersectionWithMappedSignature.kt");
        }

        @Test
        @TestMetadata("irrelevantCharAtAbstract.kt")
        public void testIrrelevantCharAtAbstract() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantCharAtAbstract.kt");
        }

        @Test
        @TestMetadata("irrelevantImplCharSequence.kt")
        public void testIrrelevantImplCharSequence() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplCharSequence.kt");
        }

        @Test
        @TestMetadata("irrelevantImplCharSequenceKotlin.kt")
        public void testIrrelevantImplCharSequenceKotlin() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplCharSequenceKotlin.kt");
        }

        @Test
        @TestMetadata("irrelevantImplMutableList.kt")
        public void testIrrelevantImplMutableList() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplMutableList.kt");
        }

        @Test
        @TestMetadata("irrelevantImplMutableListKotlin.kt")
        public void testIrrelevantImplMutableListKotlin() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplMutableListKotlin.kt");
        }

        @Test
        @TestMetadata("irrelevantMapGetAbstract.kt")
        public void testIrrelevantMapGetAbstract() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantMapGetAbstract.kt");
        }

        @Test
        @TestMetadata("mapGetOverride.kt")
        public void testMapGetOverride() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/mapGetOverride.kt");
        }

        @Test
        @TestMetadata("mapMethodsImplementedInJava.kt")
        public void testMapMethodsImplementedInJava() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/mapMethodsImplementedInJava.kt");
        }

        @Test
        @TestMetadata("nonDirectHiddenOverride.kt")
        public void testNonDirectHiddenOverride() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/nonDirectHiddenOverride.kt");
        }

        @Test
        @TestMetadata("overrideAnClashWithJvmSignatureInMPP.kt")
        public void testOverrideAnClashWithJvmSignatureInMPP() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/overrideAnClashWithJvmSignatureInMPP.kt");
        }

        @Test
        @TestMetadata("removeAt.kt")
        public void testRemoveAt() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/removeAt.kt");
        }

        @Test
        @TestMetadata("sizeFromKotlinOverriddenInJava.kt")
        public void testSizeFromKotlinOverriddenInJava() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/sizeFromKotlinOverriddenInJava.kt");
        }

        @Test
        @TestMetadata("twoInheritedContains.kt")
        public void testTwoInheritedContains() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/twoInheritedContains.kt");
        }

        @Test
        @TestMetadata("weirdCharBuffers.kt")
        public void testWeirdCharBuffers() {
          runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/weirdCharBuffers.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/j+k/deprecations")
      @TestDataPath("$PROJECT_ROOT")
      public class Deprecations {
        @Test
        public void testAllFilesPresentInDeprecations() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/deprecations"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("doNotMarkWriteIfGetterDeprecated.kt")
        public void testDoNotMarkWriteIfGetterDeprecated() {
          runTest("compiler/testData/diagnostics/tests/j+k/deprecations/doNotMarkWriteIfGetterDeprecated.kt");
        }

        @Test
        @TestMetadata("forFakeOverrides.kt")
        public void testForFakeOverrides() {
          runTest("compiler/testData/diagnostics/tests/j+k/deprecations/forFakeOverrides.kt");
        }

        @Test
        @TestMetadata("forMixedOverride.kt")
        public void testForMixedOverride() {
          runTest("compiler/testData/diagnostics/tests/j+k/deprecations/forMixedOverride.kt");
        }

        @Test
        @TestMetadata("forOverrides.kt")
        public void testForOverrides() {
          runTest("compiler/testData/diagnostics/tests/j+k/deprecations/forOverrides.kt");
        }

        @Test
        @TestMetadata("forSyntheticPropertyOverrides.kt")
        public void testForSyntheticPropertyOverrides() {
          runTest("compiler/testData/diagnostics/tests/j+k/deprecations/forSyntheticPropertyOverrides.kt");
        }

        @Test
        @TestMetadata("hiddenJavaClass.kt")
        public void testHiddenJavaClass() {
          runTest("compiler/testData/diagnostics/tests/j+k/deprecations/hiddenJavaClass.kt");
        }

        @Test
        @TestMetadata("javaWithHiddenDeprecation.kt")
        public void testJavaWithHiddenDeprecation() {
          runTest("compiler/testData/diagnostics/tests/j+k/deprecations/javaWithHiddenDeprecation.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor")
      @TestDataPath("$PROJECT_ROOT")
      public class GenericConstructor {
        @Test
        public void testAllFilesPresentInGenericConstructor() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/genericConstructor"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("classTypeParameterInferredFromArgument.kt")
        public void testClassTypeParameterInferredFromArgument() {
          runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/classTypeParameterInferredFromArgument.kt");
        }

        @Test
        @TestMetadata("innerClass.kt")
        public void testInnerClass() {
          runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/innerClass.kt");
        }

        @Test
        @TestMetadata("noClassTypeParameters.kt")
        public void testNoClassTypeParameters() {
          runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/noClassTypeParameters.kt");
        }

        @Test
        @TestMetadata("noClassTypeParametersInvParameter.kt")
        public void testNoClassTypeParametersInvParameter() {
          runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/noClassTypeParametersInvParameter.kt");
        }

        @Test
        @TestMetadata("recursive.kt")
        public void testRecursive() {
          runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/recursive.kt");
        }

        @Test
        @TestMetadata("selfTypes.kt")
        public void testSelfTypes() {
          runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/selfTypes.kt");
        }

        @Test
        @TestMetadata("superCall.kt")
        public void testSuperCall() {
          runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/superCall.kt");
        }

        @Test
        @TestMetadata("superCallImpossibleToInfer.kt")
        public void testSuperCallImpossibleToInfer() {
          runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/superCallImpossibleToInfer.kt");
        }

        @Test
        @TestMetadata("withClassTypeParameters.kt")
        public void testWithClassTypeParameters() {
          runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/withClassTypeParameters.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/j+k/polymorphicSignature")
      @TestDataPath("$PROJECT_ROOT")
      public class PolymorphicSignature {
        @Test
        public void testAllFilesPresentInPolymorphicSignature() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/polymorphicSignature"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("spreadOperator_after.kt")
        public void testSpreadOperator_after() {
          runTest("compiler/testData/diagnostics/tests/j+k/polymorphicSignature/spreadOperator_after.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/j+k/primitiveOverrides")
      @TestDataPath("$PROJECT_ROOT")
      public class PrimitiveOverrides {
        @Test
        public void testAllFilesPresentInPrimitiveOverrides() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/primitiveOverrides"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("kt11140.kt")
        public void testKt11140() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/kt11140.kt");
        }

        @Test
        @TestMetadata("notNullAnnotated.kt")
        public void testNotNullAnnotated() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/notNullAnnotated.kt");
        }

        @Test
        @TestMetadata("removeAt.kt")
        public void testRemoveAt() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/removeAt.kt");
        }

        @Test
        @TestMetadata("specializedMap.kt")
        public void testSpecializedMap() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/specializedMap.kt");
        }

        @Test
        @TestMetadata("triangleWithFlexibleType.kt")
        public void testTriangleWithFlexibleType() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/triangleWithFlexibleType.kt");
        }

        @Test
        @TestMetadata("triangleWithFlexibleTypeAndSubstitution.kt")
        public void testTriangleWithFlexibleTypeAndSubstitution() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/triangleWithFlexibleTypeAndSubstitution.kt");
        }

        @Test
        @TestMetadata("triangleWithFlexibleTypeAndSubstitution2.kt")
        public void testTriangleWithFlexibleTypeAndSubstitution2() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/triangleWithFlexibleTypeAndSubstitution2.kt");
        }

        @Test
        @TestMetadata("triangleWithFlexibleTypeAndSubstitution3.kt")
        public void testTriangleWithFlexibleTypeAndSubstitution3() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/triangleWithFlexibleTypeAndSubstitution3.kt");
        }

        @Test
        @TestMetadata("triangleWithFlexibleTypeAndSubstitution4.kt")
        public void testTriangleWithFlexibleTypeAndSubstitution4() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/triangleWithFlexibleTypeAndSubstitution4.kt");
        }

        @Test
        @TestMetadata("triangleWithFlexibleTypeAndSubstitution5.kt")
        public void testTriangleWithFlexibleTypeAndSubstitution5() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/triangleWithFlexibleTypeAndSubstitution5.kt");
        }

        @Test
        @TestMetadata("triangleWithNotNullType.kt")
        public void testTriangleWithNotNullType() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/triangleWithNotNullType.kt");
        }

        @Test
        @TestMetadata("triangleWithNullableType.kt")
        public void testTriangleWithNullableType() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/triangleWithNullableType.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/j+k/primitiveOverridesWithInlineClass")
      @TestDataPath("$PROJECT_ROOT")
      public class PrimitiveOverridesWithInlineClass {
        @Test
        public void testAllFilesPresentInPrimitiveOverridesWithInlineClass() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/primitiveOverridesWithInlineClass"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("inlineClassErasedToPrimitiveInt.kt")
        public void testInlineClassErasedToPrimitiveInt() {
          runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverridesWithInlineClass/inlineClassErasedToPrimitiveInt.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/diagnostics/tests/j+k/properties")
      @TestDataPath("$PROJECT_ROOT")
      public class Properties {
        @Test
        public void testAllFilesPresentInProperties() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/properties"), Pattern.compile("^(.+)\\.(kt|kts)$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), true, "lightTree");
        }

        @Test
        @TestMetadata("fieldPropertyOverloads.kt")
        public void testFieldPropertyOverloads() {
          runTest("compiler/testData/diagnostics/tests/j+k/properties/fieldPropertyOverloads.kt");
        }

        @Test
        @TestMetadata("fieldPropertyOverloadsNI.kt")
        public void testFieldPropertyOverloadsNI() {
          runTest("compiler/testData/diagnostics/tests/j+k/properties/fieldPropertyOverloadsNI.kt");
        }

        @Test
        @TestMetadata("interface.kt")
        public void testInterface() {
          runTest("compiler/testData/diagnostics/tests/j+k/properties/interface.kt");
        }

        @Test
        @TestMetadata("isName.kt")
        public void testIsName() {
          runTest("compiler/testData/diagnostics/tests/j+k/properties/isName.kt");
        }

        @Test
    