/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.base.incremental.JavacVisitorsKt;
import org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/ConstantTreeVisitor;", "Lcom/sun/source/util/TreePathScanner;", "Ljava/lang/Void;", "sourceStructure", "Lorg/jetbrains/kotlin/kapt3/base/incremental/SourceFileStructure;", "<init>", "(Lorg/jetbrains/kotlin/kapt3/base/incremental/SourceFileStructure;)V", "getSourceStructure", "()Lorg/jetbrains/kotlin/kapt3/base/incremental/SourceFileStructure;", "isTrivialLiteralExpression", "", "tree", "Lcom/sun/source/tree/Tree;", "visitAssignment", "node", "Lcom/sun/source/tree/AssignmentTree;", "p", "visitMemberSelect", "Lcom/sun/source/tree/MemberSelectTree;", "visitIdentifier", "Lcom/sun/source/tree/IdentifierTree;", "addConstantSymbol", "", "sym", "Lcom/sun/tools/javac/code/Symbol;", "kotlin-annotation-processing-base"})
final class ConstantTreeVisitor
extends TreePathScanner<Void, Void> {
    @NotNull
    private final SourceFileStructure sourceStructure;

    public ConstantTreeVisitor(@NotNull SourceFileStructure sourceStructure) {
        Intrinsics.checkNotNullParameter((Object)sourceStructure, (String)"sourceStructure");
        this.sourceStructure = sourceStructure;
    }

    @NotNull
    public final SourceFileStructure getSourceStructure() {
        return this.sourceStructure;
    }

    public final boolean isTrivialLiteralExpression(@NotNull Tree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        return JavacVisitorsKt.access$getLiteralKinds$p().contains((Object)tree.getKind());
    }

    @Override
    @Nullable
    public Void visitAssignment(@NotNull AssignmentTree node, @Nullable Void p) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.scan(node.getExpression(), p);
        return null;
    }

    @Override
    @Nullable
    public Void visitMemberSelect(@NotNull MemberSelectTree node, @Nullable Void p) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Symbol symbol = ((JCTree.JCFieldAccess)node).sym;
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"sym");
        this.addConstantSymbol(symbol);
        return null;
    }

    @Override
    @Nullable
    public Void visitIdentifier(@NotNull IdentifierTree node, @Nullable Void p) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Symbol symbol = ((JCTree.JCIdent)node).sym;
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"sym");
        this.addConstantSymbol(symbol);
        return null;
    }

    private final void addConstantSymbol(Symbol sym) {
        Name name = sym.name;
        Symbol containingClass = sym.owner;
        String string = containingClass.getQualifiedName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.sourceStructure.addMentionedConstant(string, string2);
    }
}

