/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.incremental.DeclaredProcType;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000&\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a.\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\nH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"INCREMENTAL_DECLARED_TYPES", "", "", "INCREMENTAL_ANNOTATION_FLAG", "getIncrementalProcessorsFromClasspath", "", "Lorg/jetbrains/kotlin/kapt3/base/incremental/DeclaredProcType;", "names", "classpath", "", "Ljava/io/File;", "processSingleClasspathEntry", "rootFile", "kotlin-annotation-processing-base"})
@SourceDebugExtension(value={"SMAP\nincrementalProcessorDiscovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 incrementalProcessorDiscovery.kt\norg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessorDiscoveryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,63:1\n1853#2:64\n1854#2:74\n526#3:65\n511#3,6:66\n215#4,2:72\n*S KotlinDebug\n*F\n+ 1 incrementalProcessorDiscovery.kt\norg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessorDiscoveryKt\n*L\n24#1:64\n24#1:74\n26#1:65\n26#1:66,6\n26#1:72,2\n*E\n"})
public final class IncrementalProcessorDiscoveryKt {
    @NotNull
    private static final Set<String> INCREMENTAL_DECLARED_TYPES;
    @NotNull
    private static final String INCREMENTAL_ANNOTATION_FLAG = "META-INF/gradle/incremental.annotation.processors";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, DeclaredProcType> getIncrementalProcessorsFromClasspath(@NotNull Set<String> names, @NotNull Iterable<? extends File> classpath) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Map finalValues = new LinkedHashMap();
        Iterable<? extends File> $this$forEach$iv = classpath;
        boolean $i$f$forEach = false;
        Iterator<? extends File> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            Map fromEntry;
            File element$iv;
            File entry = element$iv = iterator.next();
            boolean bl = false;
            Map $this$filter$iv = fromEntry = IncrementalProcessorDiscoveryKt.processSingleClasspathEntry(entry);
            boolean $i$f$filter = false;
            Object object = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                if (!names.contains(it.getKey())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$forEach2 = false;
            object = $this$forEach$iv2.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry it = element$iv2 = (Map.Entry)object.next();
                boolean bl3 = false;
                finalValues.put(it.getKey(), it.getValue());
            }
            if (finalValues.size() != names.size()) continue;
            return finalValues;
        }
        return finalValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, DeclaredProcType> processSingleClasspathEntry(File rootFile) {
        String[] content;
        Object object;
        block12: {
            block13: {
                Object object2;
                Object markerFile;
                block11: {
                    if (!rootFile.isDirectory()) break block11;
                    markerFile = FilesKt.resolve((File)rootFile, (String)INCREMENTAL_ANNOTATION_FLAG);
                    if (((File)markerFile).exists()) {
                        object2 = markerFile;
                        Charset charset = Charsets.UTF_8;
                        int n = 8192;
                        Object object3 = object2;
                        object = TextStreamsKt.readLines((Reader)((object3 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object3), charset)) instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n)));
                    } else {
                        object = CollectionsKt.emptyList();
                    }
                    break block12;
                }
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)rootFile), (Object)"jar")) break block13;
                markerFile = new ZipFile(rootFile);
                object2 = null;
                try {
                    Object object4;
                    Object zipFile;
                    block15: {
                        block14: {
                            zipFile = markerFile;
                            boolean bl = false;
                            object4 = content = zipFile.getInputStream(new ZipEntry(INCREMENTAL_ANNOTATION_FLAG));
                            if (content == null) break block14;
                            String[] stringArray = object4;
                            Charset charset = Charsets.UTF_8;
                            Reader reader = new InputStreamReader((InputStream)stringArray, charset);
                            int n = 8192;
                            object4 = TextStreamsKt.readLines((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                            if (object4 != null) break block15;
                        }
                        object4 = CollectionsKt.emptyList();
                    }
                    zipFile = object4;
                    object = zipFile;
                }
                catch (Throwable zipFile) {
                    object2 = zipFile;
                    throw zipFile;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)markerFile, (Throwable)object2);
                }
            }
            object = CollectionsKt.emptyList();
        }
        Object text = object;
        Map nameToType = new LinkedHashMap();
        for (String line : text) {
            String kind;
            List parts = StringsKt.split$default((CharSequence)line, (String[])(content = new String[]{","}), (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((String)parts.get(1)).toUpperCase(Locale.ROOT), (String)"toUpperCase(...)");
            if (!INCREMENTAL_DECLARED_TYPES.contains(kind)) continue;
            nameToType.put(parts.get(0), DeclaredProcType.valueOf(kind));
        }
        return nameToType;
    }

    static {
        Object[] objectArray = new String[]{"AGGREGATING", "ISOLATING", "DYNAMIC"};
        INCREMENTAL_DECLARED_TYPES = SetsKt.setOf((Object[])objectArray);
    }
}

