/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder;

import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.ModuleFileCache;
import org.jetbrains.kotlin.com.google.common.collect.MapMaker;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/ModuleFileCacheImpl;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/ModuleFileCache;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)V", "getModuleComponents", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "ktFileToFirFile", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "fileCached", "file", "createValue", "Lkotlin/Function0;", "getCachedFirFile", "ktFile", "getContainerFirFile", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "low-level-api-fir"})
public final class ModuleFileCacheImpl
extends ModuleFileCache {
    @NotNull
    private final LLFirModuleResolveComponents moduleComponents;
    @NotNull
    private final ConcurrentMap<KtFile, FirFile> ktFileToFirFile;

    public ModuleFileCacheImpl(@NotNull LLFirModuleResolveComponents moduleComponents) {
        Intrinsics.checkNotNullParameter((Object)moduleComponents, (String)"moduleComponents");
        this.moduleComponents = moduleComponents;
        ConcurrentMap concurrentMap = new MapMaker().weakKeys().makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"makeMap(...)");
        this.ktFileToFirFile = concurrentMap;
    }

    @Override
    @NotNull
    public LLFirModuleResolveComponents getModuleComponents() {
        return this.moduleComponents;
    }

    @Override
    @NotNull
    public FirFile fileCached(@NotNull KtFile file, @NotNull Function0<? extends FirFile> createValue) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(createValue, (String)"createValue");
        FirFile firFile = this.ktFileToFirFile.computeIfAbsent(file, arg_0 -> ModuleFileCacheImpl.fileCached$lambda$1(arg_0 -> ModuleFileCacheImpl.fileCached$lambda$0(createValue, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)firFile, (String)"computeIfAbsent(...)");
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getCachedFirFile(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        return (FirFile)this.ktFileToFirFile.get(ktFile);
    }

    @Override
    @Nullable
    public FirFile getContainerFirFile(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        PsiElement psiElement = UtilsKt.getPsi((FirElement)((FirElement)declaration));
        PsiFile psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile == null) {
            return null;
        }
        KtFile ktFile2 = ktFile;
        return this.getCachedFirFile(ktFile2);
    }

    private static final FirFile fileCached$lambda$0(Function0 $createValue, KtFile it) {
        return (FirFile)$createValue.invoke();
    }

    private static final FirFile fileCached$lambda$1(Function1 $tmp0, Object p0) {
        return (FirFile)$tmp0.invoke(p0);
    }
}

