/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.base.incremental.Changes;
import org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure;
import org.jetbrains.kotlin.kapt3.base.incremental.SourcesToReprocess;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rJ\u0017\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0018J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u0007J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "Ljava/io/Serializable;", "()V", "dependencyCache", "", "", "", "Ljava/net/URI;", "generatedTypes", "Ljava/io/File;", "", "nonTransitiveCache", "sourceCache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/SourceFileStructure;", "addGeneratedType", "", "type", "generatedFile", "addSourceStructure", "sourceStructure", "getStructure", "sourceFile", "getStructure$kotlin_annotation_processing_maven", "invalidateAll", "invalidateAll$kotlin_annotation_processing_maven", "invalidateEntriesAnnotatedWith", "", "annotations", "invalidateEntriesForChangedFiles", "Lorg/jetbrains/kotlin/kapt3/base/incremental/SourcesToReprocess;", "changes", "Lorg/jetbrains/kotlin/kapt3/base/incremental/Changes;", "invalidateGeneratedTypes", "files", "", "isAlreadyProcessed", "", "readObject", "input", "Ljava/io/ObjectInputStream;", "writeObject", "output", "Ljava/io/ObjectOutputStream;", "kotlin-annotation-processing-maven"})
public final class JavaClassCache
implements Serializable {
    private Map<URI, SourceFileStructure> sourceCache;
    private Map<File, List<String>> generatedTypes;
    private transient Map<String, Set<URI>> dependencyCache;
    private transient Map<String, Set<URI>> nonTransitiveCache;

    public final void addSourceStructure(@NotNull SourceFileStructure sourceStructure) {
        Intrinsics.checkParameterIsNotNull((Object)sourceStructure, (String)"sourceStructure");
        this.sourceCache.put(sourceStructure.getSourceFile(), sourceStructure);
    }

    public final void addGeneratedType(@NotNull String type, @NotNull File generatedFile) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)generatedFile, (String)"generatedFile");
        List list = this.generatedTypes.get(generatedFile);
        if (list == null) {
            list = new ArrayList(1);
        }
        List typesInFile = list;
        typesInFile.add((String)type);
        this.generatedTypes.put(generatedFile, typesInFile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> invalidateGeneratedTypes(@NotNull List<? extends File> files) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Iterable $this$mapNotNull$iv = files;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List<String> list;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (this.generatedTypes.remove(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            List<String> it$iv$iv = list;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    private final void readObject(ObjectInputStream input) {
        Set dependants;
        boolean bl;
        Object object = input.readObject();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<java.net.URI, org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure>");
        }
        this.sourceCache = TypeIntrinsics.asMutableMap((Object)object);
        Object object2 = input.readObject();
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<java.io.File, kotlin.collections.MutableList<kotlin.String>>");
        }
        this.generatedTypes = TypeIntrinsics.asMutableMap((Object)object2);
        this.dependencyCache = new HashMap(this.sourceCache.size() * 4);
        for (SourceFileStructure sourceInfo : this.sourceCache.values()) {
            for (String mentionedType : sourceInfo.getMentionedTypes()) {
                Set set = this.dependencyCache.get(mentionedType);
                if (set == null) {
                    bl = false;
                    set = new LinkedHashSet();
                }
                dependants = set;
                dependants.add((URI)sourceInfo.getSourceFile());
                this.dependencyCache.put(mentionedType, dependants);
            }
            for (String mentionedConstants : sourceInfo.getMentionedConstants().keySet()) {
                Set set = this.dependencyCache.get(mentionedConstants);
                if (set == null) {
                    bl = false;
                    set = new LinkedHashSet();
                }
                dependants = set;
                dependants.add((URI)sourceInfo.getSourceFile());
                this.dependencyCache.put(mentionedConstants, dependants);
            }
        }
        this.nonTransitiveCache = new HashMap(this.sourceCache.size() * 2);
        for (SourceFileStructure sourceInfo : this.sourceCache.values()) {
            for (String privateType : sourceInfo.getPrivateTypes()) {
                Set set = this.nonTransitiveCache.get(privateType);
                if (set == null) {
                    bl = false;
                    set = new LinkedHashSet();
                }
                dependants = set;
                dependants.add((URI)sourceInfo.getSourceFile());
                this.nonTransitiveCache.put(privateType, dependants);
            }
        }
    }

    private final void writeObject(ObjectOutputStream output) {
        output.writeObject(this.sourceCache);
        output.writeObject(this.generatedTypes);
    }

    public final boolean isAlreadyProcessed(@NotNull URI sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        return this.sourceCache.containsKey(sourceFile) || this.generatedTypes.containsKey(new File(sourceFile));
    }

    @Nullable
    public final SourceFileStructure getStructure$kotlin_annotation_processing_maven(@NotNull File sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        return this.sourceCache.get(sourceFile.toURI());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SourcesToReprocess invalidateEntriesForChangedFiles(@NotNull Changes changes) {
        void $this$mapTo$iv$iv;
        Object object;
        Collection<URI> collection;
        Set<URI> $this$mapTo$iv$iv222;
        Intrinsics.checkParameterIsNotNull((Object)changes, (String)"changes");
        boolean bl = false;
        Set allDirtyFiles = new LinkedHashSet();
        Iterable $this$map$iv = changes.getSourceChanges();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv222) {
            void it;
            File file = (File)t;
            collection = destination$iv$iv22;
            boolean bl2 = false;
            object = it.toURI();
            collection.add((URI)object);
        }
        collection = (List)destination$iv$iv22;
        Set currentDirtyFiles = CollectionsKt.toMutableSet((Iterable)collection);
        for (String classpathFqName : changes.getDirtyFqNamesFromClasspath()) {
            boolean bl2;
            Set<URI> it;
            if (this.nonTransitiveCache.get(classpathFqName) != null) {
                boolean destination$iv$iv22 = false;
                $i$f$mapTo = false;
                it = $this$mapTo$iv$iv222;
                bl2 = false;
                allDirtyFiles.addAll((Collection)it);
            }
            if (this.dependencyCache.get(classpathFqName) == null) continue;
            boolean destination$iv$iv22 = false;
            $i$f$mapTo = false;
            it = $this$mapTo$iv$iv222;
            bl2 = false;
            currentDirtyFiles.addAll((Collection)it);
        }
        $i$f$map22 = false;
        Set allDirtyTypes = new LinkedHashSet();
        while (true) {
            void $this$filterTo$iv$iv;
            Collection $i$f$map22 = currentDirtyFiles;
            boolean $this$mapTo$iv$iv222 = false;
            if (!(!$i$f$map22.isEmpty())) break;
            $this$mapTo$iv$iv222 = false;
            Set nextRound = new LinkedHashSet();
            destination$iv$iv22 = currentDirtyFiles.iterator();
            while (destination$iv$iv22.hasNext()) {
                SourceFileStructure structure;
                URI dirtyFile;
                URI uRI = dirtyFile = (URI)destination$iv$iv22.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"dirtyFile");
                allDirtyFiles.add(uRI);
                if (this.sourceCache.remove(dirtyFile) == null) {
                    continue;
                }
                Set<String> dirtyTypes = structure.getDeclaredTypes();
                allDirtyTypes.addAll((Collection)dirtyTypes);
                Iterable iterable2 = dirtyTypes;
                boolean $i$f$forEach = false;
                for (Object element$iv : iterable2) {
                    Set<URI> it;
                    Set<URI> set;
                    boolean bl5;
                    boolean bl6;
                    String type = (String)element$iv;
                    boolean bl7 = false;
                    if (this.nonTransitiveCache.get(type) != null) {
                        bl6 = false;
                        bl5 = false;
                        it = set;
                        boolean bl8 = false;
                        allDirtyFiles.addAll((Collection)it);
                    }
                    if (this.dependencyCache.get(type) == null) continue;
                    bl6 = false;
                    bl5 = false;
                    it = set;
                    boolean bl9 = false;
                    nextRound.addAll((Collection)it);
                }
            }
            Iterable $this$filter$iv = nextRound;
            boolean $i$f$filter = false;
            Iterable structure = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean bl3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                URI it = (URI)element$iv$iv;
                boolean bl10 = false;
                if (!(!allDirtyFiles.contains(it))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv3;
            currentDirtyFiles = CollectionsKt.toMutableSet((Iterable)collection);
        }
        Iterable $this$map$iv2 = allDirtyFiles;
        boolean $i$f$map3 = false;
        Iterable $i$f$filter = $this$map$iv2;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            URI element$iv$iv = (URI)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl11 = false;
            File file = new File((URI)it);
            object.add(file);
        }
        object = (List)destination$iv$iv4;
        Set set = allDirtyTypes;
        Object object2 = object;
        return new SourcesToReprocess.Incremental((List<? extends File>)object2, set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<File> invalidateEntriesAnnotatedWith(@NotNull Set<String> annotations) {
        void $this$mapTo$iv$iv;
        Object $this$any$iv;
        Serializable serializable;
        Collection collection;
        List list;
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        if (annotations.contains("*")) {
            list = CollectionsKt.listOf((Object)Pattern.compile(".*"));
        } else {
            Iterable $this$map$iv = annotations;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : iterable) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                serializable = Pattern.compile(StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)".", (String)"\\.", (boolean)false, (int)4, null), (String)"*", (String)".+", (boolean)false, (int)4, null));
                collection.add(serializable);
            }
            list = (List)destination$iv$iv;
        }
        List patterns = list;
        Function1 matchesAnyPattern2 = (Function1)new Function1<String, Boolean>(patterns){
            final /* synthetic */ List $patterns;

            public final boolean invoke(@NotNull String name) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Iterable $this$any$iv = this.$patterns;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Pattern it = (Pattern)element$iv;
                            boolean bl2 = false;
                            if (!it.matcher(name).matches()) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$patterns = list;
                super(1);
            }
        };
        boolean bl = false;
        Set toReprocess = new LinkedHashSet();
        Map<URI, SourceFileStructure> $i$f$mapTo = this.sourceCache;
        boolean bl2 = false;
        for (Map.Entry entry : $i$f$mapTo.entrySet()) {
            boolean bl3;
            block9: {
                $this$any$iv = ((SourceFileStructure)entry.getValue()).getMentionedAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    Object item$iv$iv;
                    item$iv$iv = $this$any$iv.iterator();
                    while (item$iv$iv.hasNext()) {
                        Object element$iv = item$iv$iv.next();
                        if (!((Boolean)matchesAnyPattern2.invoke(element$iv)).booleanValue()) continue;
                        bl3 = true;
                        break block9;
                    }
                    bl3 = false;
                }
            }
            if (!bl3) continue;
            toReprocess.add(entry.getKey());
        }
        Iterable iterable = toReprocess;
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable) {
            URI it = (URI)element$iv;
            boolean bl3 = false;
            this.sourceCache.remove(it);
        }
        Iterable iterable2 = toReprocess;
        boolean $i$f$map = false;
        $this$any$iv = iterable2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            URI uRI = (URI)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            serializable = new File((URI)it);
            collection.add(serializable);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final void invalidateAll$kotlin_annotation_processing_maven() {
        this.sourceCache.clear();
        this.generatedTypes.clear();
    }

    public JavaClassCache() {
        Map map;
        JavaClassCache javaClassCache = this;
        boolean bl = false;
        javaClassCache.sourceCache = map = (Map)new LinkedHashMap();
        javaClassCache = this;
        bl = false;
        javaClassCache.generatedTypes = map = (Map)new LinkedHashMap();
        javaClassCache = this;
        bl = false;
        javaClassCache.dependencyCache = map = (Map)new LinkedHashMap();
        javaClassCache = this;
        bl = false;
        javaClassCache.nonTransitiveCache = map = (Map)new LinkedHashMap();
    }
}

