/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.incremental.AnnotationProcessorDependencyCollector;
import org.jetbrains.kotlin.kapt3.base.incremental.DeclaredProcType;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalFiler;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessingEnvironment;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessorsKt;
import org.jetbrains.kotlin.kapt3.base.incremental.RuntimeProcType;
import org.jetbrains.kotlin.kapt3.base.util.KaptLogger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\nH\u0002J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013Jm\u0010\u0014\u001a&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016 \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016\u0018\u00010\u00180\u00152\u000e\u0010\u0019\u001a\n \u0017*\u0004\u0018\u00010\u001a0\u001a2\u000e\u0010\u001b\u001a\n \u0017*\u0004\u0018\u00010\u001c0\u001c2\u000e\u0010\u001d\u001a\n \u0017*\u0004\u0018\u00010\u001e0\u001e2\u000e\u0010\u001f\u001a\n \u0017*\u0004\u0018\u00010\f0\fH\u0096\u0001J\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\f0!J\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\f0!J\u0006\u0010$\u001a\u00020%J-\u0010&\u001a&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\f0\f \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\f0\f\u0018\u00010\u00130'H\u0096\u0001J-\u0010(\u001a&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\f0\f \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\f0\f\u0018\u00010\u00130'H\u0096\u0001J\u0011\u0010)\u001a\n \u0017*\u0004\u0018\u00010*0*H\u0096\u0001J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000200J\u001e\u00102\u001a\u0002002\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00132\u0006\u00105\u001a\u000206H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessor;", "Ljavax/annotation/processing/Processor;", "processor", "kind", "Lorg/jetbrains/kotlin/kapt3/base/incremental/DeclaredProcType;", "logger", "Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;", "(Ljavax/annotation/processing/Processor;Lorg/jetbrains/kotlin/kapt3/base/incremental/DeclaredProcType;Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;)V", "dependencyCollector", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/kapt3/base/incremental/AnnotationProcessorDependencyCollector;", "incrementalSupportType", "", "getIncrementalSupportType", "()Ljava/lang/String;", "processorName", "getProcessorName", "createDependencyCollector", "getAggregatedTypes", "", "getCompletions", "", "Ljavax/annotation/processing/Completion;", "kotlin.jvm.PlatformType", "", "p0", "Ljavax/lang/model/element/Element;", "p1", "Ljavax/lang/model/element/AnnotationMirror;", "p2", "Ljavax/lang/model/element/ExecutableElement;", "p3", "getGeneratedClassFilesToTypes", "", "Ljava/io/File;", "getGeneratedToSources", "getRuntimeType", "Lorg/jetbrains/kotlin/kapt3/base/incremental/RuntimeProcType;", "getSupportedAnnotationTypes", "", "getSupportedOptions", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "init", "", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "isMissingIncrementalSupport", "", "isUnableToRunIncrementally", "process", "annotations", "Ljavax/lang/model/element/TypeElement;", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "kotlin-annotation-processing-base"})
public final class IncrementalProcessor
implements Processor {
    @NotNull
    private final Processor processor;
    @NotNull
    private final DeclaredProcType kind;
    @NotNull
    private final KaptLogger logger;
    @NotNull
    private Lazy<AnnotationProcessorDependencyCollector> dependencyCollector;
    @NotNull
    private final String processorName;
    @NotNull
    private final String incrementalSupportType;

    public IncrementalProcessor(@NotNull Processor processor, @NotNull DeclaredProcType kind, @NotNull KaptLogger logger) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.processor = processor;
        this.kind = kind;
        this.logger = logger;
        this.dependencyCollector = LazyKt.lazy((Function0)((Function0)new Function0<AnnotationProcessorDependencyCollector>(this){
            final /* synthetic */ IncrementalProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AnnotationProcessorDependencyCollector invoke() {
                return IncrementalProcessor.access$createDependencyCollector(this.this$0);
            }
        }));
        String string = this.processor.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processor.javaClass.name");
        this.processorName = string;
        this.incrementalSupportType = this.kind.name();
    }

    public Iterable<Completion> getCompletions(Element p0, AnnotationMirror p1, ExecutableElement p2, String p3) {
        return this.processor.getCompletions(p0, p1, p2, p3);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.processor.getSupportedAnnotationTypes();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return this.processor.getSupportedOptions();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return this.processor.getSupportedSourceVersion();
    }

    @NotNull
    public final String getProcessorName() {
        return this.processorName;
    }

    @NotNull
    public final String getIncrementalSupportType() {
        return this.incrementalSupportType;
    }

    @Override
    public void init(@NotNull ProcessingEnvironment processingEnv) {
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        if (!this.kind.getCanRunIncrementally()) {
            this.processor.init(processingEnv);
        } else {
            Filer originalFiler = processingEnv.getFiler();
            Intrinsics.checkNotNullExpressionValue((Object)originalFiler, (String)"originalFiler");
            IncrementalFiler incrementalFiler = new IncrementalFiler(originalFiler);
            IncrementalProcessingEnvironment incProcEnvironment = new IncrementalProcessingEnvironment(processingEnv, incrementalFiler);
            this.processor.init(incProcEnvironment);
            incrementalFiler.setDependencyCollector$kotlin_annotation_processing_base((AnnotationProcessorDependencyCollector)this.dependencyCollector.getValue());
        }
    }

    private final AnnotationProcessorDependencyCollector createDependencyCollector() {
        RuntimeProcType runtimeProcType;
        if (this.kind == DeclaredProcType.DYNAMIC) {
            Object v1;
            block6: {
                Set<String> set = this.getSupportedOptions();
                Intrinsics.checkNotNullExpressionValue(set, (String)"supportedOptions");
                Iterable $this$singleOrNull$iv = set;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!StringsKt.startsWith$default((String)it, (String)"org.gradle.annotation.processing.", (boolean)false, (int)2, null)) continue;
                    if (found$iv) {
                        v1 = null;
                        break block6;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            String fromOptions = v1;
            if (fromOptions == null) {
                runtimeProcType = RuntimeProcType.NON_INCREMENTAL;
            } else {
                String string = StringsKt.drop((String)fromOptions, (int)"org.gradle.annotation.processing.".length()).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                String declaredType = string;
                runtimeProcType = IncrementalProcessorsKt.access$getALLOWED_RUNTIME_TYPES$p().contains(declaredType) ? RuntimeProcType.valueOf(declaredType) : RuntimeProcType.NON_INCREMENTAL;
            }
        } else {
            runtimeProcType = this.kind.toRuntimeType();
        }
        RuntimeProcType type = runtimeProcType;
        return new AnnotationProcessorDependencyCollector(type, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ IncrementalProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                IncrementalProcessor.access$getLogger$p(this.this$0).warn("Issue detected with " + this.this$0.getProcessorName() + ". " + s);
            }
        }));
    }

    public final boolean isMissingIncrementalSupport() {
        if (this.kind == DeclaredProcType.NON_INCREMENTAL) {
            return true;
        }
        return this.kind == DeclaredProcType.DYNAMIC && this.getRuntimeType() == RuntimeProcType.NON_INCREMENTAL;
    }

    public final boolean isUnableToRunIncrementally() {
        return !this.kind.getCanRunIncrementally();
    }

    @NotNull
    public final Map<File, String> getGeneratedToSources() {
        return ((AnnotationProcessorDependencyCollector)this.dependencyCollector.getValue()).getGeneratedToSources$kotlin_annotation_processing_base();
    }

    @NotNull
    public final Set<String> getAggregatedTypes() {
        return ((AnnotationProcessorDependencyCollector)this.dependencyCollector.getValue()).getAggregatedTypes$kotlin_annotation_processing_base();
    }

    @NotNull
    public final Map<File, String> getGeneratedClassFilesToTypes() {
        return ((AnnotationProcessorDependencyCollector)this.dependencyCollector.getValue()).getGeneratedClassFilesToTypes$kotlin_annotation_processing_base();
    }

    @NotNull
    public final RuntimeProcType getRuntimeType() {
        return ((AnnotationProcessorDependencyCollector)this.dependencyCollector.getValue()).getRuntimeType$kotlin_annotation_processing_base();
    }

    @Override
    public boolean process(@NotNull Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        if (this.getRuntimeType() == RuntimeProcType.AGGREGATING) {
            AnnotationProcessorDependencyCollector annotationProcessorDependencyCollector = (AnnotationProcessorDependencyCollector)this.dependencyCollector.getValue();
            Set<String> set = this.processor.getSupportedAnnotationTypes();
            Intrinsics.checkNotNullExpressionValue(set, (String)"processor.supportedAnnotationTypes");
            annotationProcessorDependencyCollector.recordProcessingInputs$kotlin_annotation_processing_base(set, annotations, roundEnv);
        }
        return this.processor.process(annotations, roundEnv);
    }

    public static final /* synthetic */ KaptLogger access$getLogger$p(IncrementalProcessor $this) {
        return $this.logger;
    }

    public static final /* synthetic */ AnnotationProcessorDependencyCollector access$createDependencyCollector(IncrementalProcessor $this) {
        return $this.createDependencyCollector();
    }
}

