/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.processing.Processor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.base.kapt3.KaptFlag;
import org.jetbrains.kotlin.base.kapt3.KaptOptions;
import org.jetbrains.kotlin.kapt3.base.LoadedProcessors;
import org.jetbrains.kotlin.kapt3.base.ProcessorLoader;
import org.jetbrains.kotlin.kapt3.base.incremental.DeclaredProcType;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessor;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessorDiscoveryKt;
import org.jetbrains.kotlin.kapt3.base.util.KaptLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0013J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J*\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001dH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/ProcessorLoader;", "Ljava/io/Closeable;", "options", "Lorg/jetbrains/kotlin/base/kapt3/KaptOptions;", "logger", "Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;", "(Lorg/jetbrains/kotlin/base/kapt3/KaptOptions;Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;)V", "annotationProcessingClassLoader", "Ljava/net/URLClassLoader;", "close", "", "doLoadProcessors", "", "Ljavax/annotation/processing/Processor;", "classpath", "Ljava/util/LinkedHashSet;", "Ljava/io/File;", "Lkotlin/collections/LinkedHashSet;", "classLoader", "Ljava/lang/ClassLoader;", "loadProcessors", "Lorg/jetbrains/kotlin/kapt3/base/LoadedProcessors;", "parentClassLoader", "tryLoadProcessor", "fqName", "", "wrapInIncrementalProcessor", "Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessor;", "processors", "", "kotlin-annotation-processing-base"})
@SourceDebugExtension(value={"SMAP\nProcessorLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessorLoader.kt\norg/jetbrains/kotlin/kapt3/base/ProcessorLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 KaptLogger.kt\norg/jetbrains/kotlin/kapt3/base/util/KaptLoggerKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,157:1\n1549#2:158\n1620#2,3:159\n1603#2,9:164\n1855#2:173\n1856#2:175\n1612#2:176\n1549#2:181\n1620#2,3:182\n1549#2:185\n1620#2,3:186\n766#2:189\n857#2,2:190\n1549#2:192\n1620#2,3:193\n1603#2,9:197\n1855#2:206\n1856#2:208\n1612#2:209\n37#3,2:162\n1#4:174\n1#4:196\n1#4:207\n1#4:210\n25#5,4:177\n25#5,4:211\n25#5,4:215\n1313#6,2:219\n*S KotlinDebug\n*F\n+ 1 ProcessorLoader.kt\norg/jetbrains/kotlin/kapt3/base/ProcessorLoader\n*L\n36#1:158\n36#1:159,3\n41#1:164,9\n41#1:173\n41#1:175\n41#1:176\n58#1:181\n58#1:182,3\n61#1:185\n61#1:186,3\n65#1:189\n65#1:190,2\n66#1:192\n66#1:193,3\n119#1:197,9\n119#1:206\n119#1:208\n119#1:209\n36#1:162,2\n41#1:174\n119#1:207\n50#1:177,4\n125#1:211,4\n128#1:215,4\n83#1:219,2\n*E\n"})
public class ProcessorLoader
implements Closeable {
    @NotNull
    private final KaptOptions options;
    @NotNull
    private final KaptLogger logger;
    @Nullable
    private URLClassLoader annotationProcessingClassLoader;

    public ProcessorLoader(@NotNull KaptOptions options, @NotNull KaptLogger logger) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.options = options;
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LoadedProcessors loadProcessors(@NotNull ClassLoader parentClassLoader) {
        List processors;
        List list;
        URLClassLoader classLoader;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        LinkedHashSet<File> linkedHashSet;
        Intrinsics.checkNotNullParameter((Object)parentClassLoader, (String)"parentClassLoader");
        LinkedHashSet<File> $this$loadProcessors_u24lambda_u240 = linkedHashSet = new LinkedHashSet<File>();
        boolean bl = false;
        $this$loadProcessors_u24lambda_u240.addAll((Collection)this.options.getProcessingClasspath());
        if (this.options.get(KaptFlag.INCLUDE_COMPILE_CLASSPATH)) {
            $this$loadProcessors_u24lambda_u240.addAll((Collection)this.options.getCompileClasspath());
        }
        LinkedHashSet<File> classpath = linkedHashSet;
        Iterable $this$map$iv = classpath;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toURI().toURL());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ClassLoader classLoader2 = parentClassLoader;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        this.annotationProcessingClassLoader = classLoader = new URLClassLoader(uRLArray, classLoader2);
        if (!((Collection)this.options.getProcessors()).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            this.logger.info("Annotation processor class names are set, skip AP discovery");
            Iterable $this$mapNotNull$iv = this.options.getProcessors();
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Processor it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                if (this.tryLoadProcessor(it, classLoader) == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            this.logger.info("Need to discovery annotation processors in the AP classpath");
            list = processors = this.doLoadProcessors(classpath, classLoader);
        }
        if (processors.isEmpty()) {
            this.logger.info("No annotation processors available, aborting");
        } else {
            KaptLogger $this$info$iv = this.logger;
            boolean $i$f$info = false;
            if ($this$info$iv.isVerbose()) {
                KaptLogger kaptLogger = $this$info$iv;
                boolean bl6 = false;
                kaptLogger.info("Annotation processors: " + CollectionsKt.joinToString$default((Iterable)processors, null, null, null, (int)0, null, (Function1)loadProcessors.1.1.INSTANCE, (int)31, null));
            }
        }
        return new LoadedProcessors(this.wrapInIncrementalProcessor(processors, (Iterable<? extends File>)classpath), classLoader);
    }

    public static /* synthetic */ LoadedProcessors loadProcessors$default(ProcessorLoader processorLoader, ClassLoader classLoader, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadProcessors");
        }
        if ((n & 1) != 0) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getSystemClassLoader(...)");
            classLoader = classLoader2;
        }
        return processorLoader.loadProcessors(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IncrementalProcessor> wrapInIncrementalProcessor(List<? extends Processor> processors, Iterable<? extends File> classpath) {
        void $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (this.options.getIncrementalCache() == null) {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv = processors;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it2;
                Processor processor = (Processor)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(new IncrementalProcessor((Processor)it2, DeclaredProcType.NON_INCREMENTAL, this.logger));
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$map$iv = processors;
        boolean $i$f$map = false;
        Iterable destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            Processor bl = (Processor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it3.getClass().getName());
        }
        Set processorNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Map<String, DeclaredProcType> processorsInfo = IncrementalProcessorDiscoveryKt.getIncrementalProcessorsFromClasspath(processorNames, classpath);
        Iterable $this$filter$iv = processorNames;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!processorsInfo.containsKey(it))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List nonIncremental = (List)destination$iv$iv3;
        Iterable $this$map$iv2 = processors;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DeclaredProcType declaredProcType;
            block9: {
                block8: {
                    it = (Processor)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    declaredProcType = processorsInfo.get(it.getClass().getName());
                    if (declaredProcType == null) break block8;
                    DeclaredProcType it4 = declaredProcType;
                    boolean bl3 = false;
                    DeclaredProcType declaredProcType2 = nonIncremental.isEmpty() ? it4 : DeclaredProcType.INCREMENTAL_BUT_OTHER_APS_ARE_NOT;
                    declaredProcType = declaredProcType2;
                    if (declaredProcType2 != null) break block9;
                }
                declaredProcType = DeclaredProcType.NON_INCREMENTAL;
            }
            DeclaredProcType procType = declaredProcType;
            collection.add(new IncrementalProcessor((Processor)it, procType, this.logger));
        }
        return (List)destination$iv$iv3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<Processor> doLoadProcessors(@NotNull LinkedHashSet<File> classpath, @NotNull ClassLoader classLoader) {
        void $this$mapNotNullTo$iv$iv;
        Object it;
        Object object;
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Set processorNames = new LinkedHashSet();
        String serviceFile = "META-INF/services/javax.annotation.processing.Processor";
        for (File file : classpath) {
            Serializable serializable;
            if (file.isDirectory()) {
                Intrinsics.checkNotNull((Object)file);
                File it2 = serializable = FilesKt.resolve((File)file, (String)serviceFile);
                boolean bl = false;
                File file2 = it2.isFile() ? serializable : null;
                if (file2 != null) {
                    it2 = file2;
                    boolean bl2 = false;
                    ProcessorLoader.doLoadProcessors$processSingleInput(processorNames, new FileInputStream(it2));
                }
                continue;
            }
            if (file.isFile()) {
                Intrinsics.checkNotNull((Object)file);
                if (StringsKt.equals((String)FilesKt.getExtension((File)file), (String)"jar", (boolean)true)) {
                    object = new ZipFile(file);
                    serializable = null;
                    try {
                        Unit unit;
                        ZipEntry zipEntry;
                        ZipFile zipFile = (ZipFile)object;
                        boolean bl = false;
                        ZipEntry zipEntry2 = zipEntry = zipFile.getEntry(serviceFile);
                        if (zipEntry2 != null) {
                            Intrinsics.checkNotNull((Object)zipEntry2);
                            ZipEntry zipEntry3 = zipEntry;
                            boolean bl3 = false;
                            Closeable closeable = zipFile.getInputStream(zipEntry3);
                            Throwable throwable = null;
                            try {
                                it = (InputStream)closeable;
                                boolean bl4 = false;
                                Intrinsics.checkNotNull((Object)it);
                                ProcessorLoader.doLoadProcessors$processSingleInput(processorNames, (InputStream)it);
                                it = Unit.INSTANCE;
                            }
                            catch (Throwable it3) {
                                throwable = it3;
                                throw it3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        zipFile = unit;
                        continue;
                    }
                    catch (Throwable zipFile) {
                        serializable = zipFile;
                        throw zipFile;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)serializable);
                        continue;
                    }
                }
            }
            this.logger.info(file + " cannot be used to locate " + serviceFile + " file.");
        }
        Iterable $this$mapNotNull$iv = processorNames;
        boolean $i$f$mapNotNull = false;
        object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Processor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            it = (String)element$iv$iv;
            boolean bl5 = false;
            if (this.tryLoadProcessor((String)it, classLoader) == null) continue;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Processor tryLoadProcessor(String fqName, ClassLoader classLoader) {
        Class<?> $i$f$info;
        ClassLoader classLoader2;
        KaptLogger kaptLogger;
        boolean $i$f$info2;
        KaptLogger $this$info$iv;
        ClassLoader providedClassloader;
        ClassLoader classLoader3;
        ClassLoader classLoader4 = this.options.getProcessingClassLoader();
        if (classLoader4 != null) {
            ClassLoader classLoader5;
            ClassLoader it = classLoader5 = classLoader4;
            boolean bl = false;
            classLoader3 = !this.options.getSeparateClassloaderForProcessors().contains(fqName) ? classLoader5 : null;
        } else {
            classLoader3 = providedClassloader = null;
        }
        if (providedClassloader != null) {
            $this$info$iv = this.logger;
            $i$f$info2 = false;
            if ($this$info$iv.isVerbose()) {
                kaptLogger = $this$info$iv;
                boolean bl = false;
                kaptLogger.info("Use provided ClassLoader for processor '" + fqName + '\'');
            }
            classLoader2 = providedClassloader;
        } else {
            $this$info$iv = this.logger;
            $i$f$info2 = false;
            if ($this$info$iv.isVerbose()) {
                kaptLogger = $this$info$iv;
                boolean bl = false;
                kaptLogger.info("Use own ClassLoader for processor '" + fqName + '\'');
            }
            classLoader2 = classLoader;
        }
        ClassLoader classLoaderToUse = classLoader2;
        try {
            $i$f$info = Class.forName(fqName, true, classLoaderToUse);
        }
        catch (Throwable e) {
            this.logger.warn("Can't find annotation processor class " + fqName + ": " + e.getMessage());
            return null;
        }
        Class<?> annotationProcessorClass = $i$f$info;
        try {
            Object annotationProcessorInstance = annotationProcessorClass.newInstance();
            if (!(annotationProcessorInstance instanceof Processor)) {
                this.logger.warn(fqName + " is not an instance of 'Processor'");
                return null;
            }
            return (Processor)annotationProcessorInstance;
        }
        catch (Throwable e) {
            this.logger.warn("Can't load annotation processor class " + fqName + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    public void close() {
        block0: {
            URLClassLoader uRLClassLoader = this.annotationProcessingClassLoader;
            if (uRLClassLoader == null) break block0;
            uRLClassLoader.close();
        }
    }

    private static final void doLoadProcessors$processSingleInput(Set<String> processorNames, InputStream input) {
        Sequence lines;
        InputStream inputStream = input;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream, charset);
        int n = 8192;
        Sequence $this$forEach$iv = lines = TextStreamsKt.lineSequence((BufferedReader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            String processedLine = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)line, (String)"#", null, (int)2, null))).toString();
            if (!(((CharSequence)processedLine).length() > 0)) continue;
            processorNames.add(processedLine);
        }
    }
}

