/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.resolve.extensions

import com.intellij.psi.PsiElement
import org.jetbrains.kotlin.analysis.api.KaExperimentalApi
import org.jetbrains.kotlin.analysis.api.KaSession
import org.jetbrains.kotlin.psi.KtElement

@KaExperimentalApi
public abstract class KaResolveExtensionNavigationTargetsProvider {
    /**
     * Provides a list of [PsiElement]s which should be used as navigation targets in place of the generated [element]. They will be used as
     * navigation targets in IntelliJ.
     *
     * These [PsiElement]s should be the source item(s) that [element] is generated from. For example, for a [KtElement] generated by a
     * resource compiler, the navigation elements will typically be the [PsiElement]s of the resource items in the corresponding resource
     * file.
     *
     * While [getNavigationTargets] usually returns a single result, it may return an empty collection if there is no navigation target, or
     * multiple targets in case of an ambiguity.
     */
    public abstract fun KaSession.getNavigationTargets(element: KtElement): Collection<PsiElement>
}
