/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.FileToIdMap;
import org.jetbrains.kotlin.incremental.storage.IdToFileMap;
import org.jetbrains.kotlin.incremental.storage.LookupMap;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u000f\u001a\u00020\u00102\u001e\u0010\u0011\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00130\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0002J \u0010\u001c\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020\u0010J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010$\u001a\u00020\u0014J\u0012\u0010%\u001a\u00020\u00102\b\b\u0002\u0010&\u001a\u00020!H\u0002J\u0014\u0010'\u001a\u00020\u00102\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "targetDataDir", "Ljava/io/File;", "(Ljava/io/File;)V", "countersFile", "deletedCount", "", "fileToId", "Lorg/jetbrains/kotlin/incremental/storage/FileToIdMap;", "idToFile", "Lorg/jetbrains/kotlin/incremental/storage/IdToFileMap;", "lookupMap", "Lorg/jetbrains/kotlin/incremental/storage/LookupMap;", "size", "addAll", "", "lookups", "", "", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "", "", "allPaths", "addFileIfNeeded", "file", "clean", "doRemoveGarbage", "dump", "lookupSymbols", "basePath", "flush", "memoryCachesOnly", "", "forceGC", "get", "lookupSymbol", "removeGarbageIfNeeded", "force", "removeLookupsFrom", "files", "Lkotlin/sequences/Sequence;", "Companion", "kotlin-build-common"})
public class LookupStorage
extends BasicMapsOwner {
    private final File countersFile;
    private final IdToFileMap idToFile;
    private final FileToIdMap fileToId;
    private final LookupMap lookupMap;
    private volatile int size;
    private volatile int deletedCount;
    private static final double DELETED_TO_SIZE_TRESHOLD;
    private static final int MINIMUM_GARBAGE_COLLECTIBLE_SIZE;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Collection<String> get(@NotNull LookupSymbol lookupSymbol) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)lookupSymbol, (String)"lookupSymbol");
        LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
        Collection<Integer> collection = this.lookupMap.get(key);
        if (collection == null) {
            return SetsKt.emptySet();
        }
        Collection<Integer> fileIds = collection;
        Iterable iterable = $receiver$iv = (Iterable)fileIds;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            int it = ((Number)element$iv$iv).intValue();
            File file = this.idToFile.get(it);
            String string2 = file != null ? file.getPath() : null;
            if (string2 == null) continue;
            String it$iv$iv = string = string2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void addAll(@NotNull Set<? extends Map.Entry<LookupSymbol, ? extends Collection<String>>> lookups, @NotNull Set<String> allPaths) {
        Intrinsics.checkParameterIsNotNull(lookups, (String)"lookups");
        Intrinsics.checkParameterIsNotNull(allPaths, (String)"allPaths");
        Map pathToId2 = CollectionsKt.keysToMap((Iterable)allPaths, (Function1)((Function1)new Function1<String, Integer>(this){
            final /* synthetic */ LookupStorage this$0;

            public final int invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return LookupStorage.access$addFileIfNeeded(this.this$0, new File(it));
            }
            {
                this.this$0 = lookupStorage;
                super(1);
            }
        }));
        Iterator<? extends Map.Entry<LookupSymbol, ? extends Collection<String>>> iterator = lookups.iterator();
        while (iterator.hasNext()) {
            void $receiver$iv;
            Map.Entry<LookupSymbol, ? extends Collection<String>> entry;
            Map.Entry<LookupSymbol, ? extends Collection<String>> entry2 = entry = iterator.next();
            LookupSymbol lookupSymbol = entry2.getKey();
            entry2 = entry;
            Collection<String> paths = entry2.getValue();
            LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
            Iterable iterable = paths;
            Collection destination$iv = new HashSet();
            for (Object item$iv : $receiver$iv) {
                void it;
                String string = (String)item$iv;
                Collection collection = destination$iv;
                Object v = pathToId2.get(it);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                Integer n = ((Number)v).intValue();
                collection.add(n);
            }
            HashSet fileIds = (HashSet)destination$iv;
            Collection collection = this.lookupMap.get(key);
            if (collection == null) {
                collection = SetsKt.emptySet();
            }
            fileIds.addAll(collection);
            this.lookupMap.set(key, fileIds);
        }
    }

    public final synchronized void removeLookupsFrom(@NotNull Sequence<? extends File> files) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        for (File file : files) {
            Integer n = this.fileToId.get(file);
            if (n == null) {
                continue;
            }
            int id = n;
            this.idToFile.remove(id);
            this.fileToId.remove(file);
            int n2 = this.deletedCount;
            this.deletedCount = n2 + 1;
        }
    }

    @Override
    public synchronized void clean() {
        if (this.countersFile.exists()) {
            this.countersFile.delete();
        }
        this.size = 0;
        this.deletedCount = 0;
        super.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush(boolean memoryCachesOnly) {
        try {
            LookupStorage.removeGarbageIfNeeded$default(this, false, 1, null);
            if (this.size > 0) {
                if (!this.countersFile.exists()) {
                    this.countersFile.getParentFile().mkdirs();
                    this.countersFile.createNewFile();
                }
                FilesKt.writeText$default((File)this.countersFile, (String)("" + this.size + '\n' + this.deletedCount), null, (int)2, null);
            }
        }
        finally {
            super.flush(memoryCachesOnly);
        }
    }

    private final int addFileIfNeeded(File file) {
        Integer existing = this.fileToId.get(file);
        if (existing != null) {
            return existing;
        }
        int n = this.size;
        this.size = n + 1;
        int id = n;
        this.fileToId.set(file, id);
        this.idToFile.set(id, file);
        return id;
    }

    private final void removeGarbageIfNeeded(boolean force) {
        if (force || this.size > MINIMUM_GARBAGE_COLLECTIBLE_SIZE && (double)this.deletedCount / (double)this.size > DELETED_TO_SIZE_TRESHOLD) {
            this.doRemoveGarbage();
        }
    }

    static /* bridge */ /* synthetic */ void removeGarbageIfNeeded$default(LookupStorage lookupStorage, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeGarbageIfNeeded");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        lookupStorage.removeGarbageIfNeeded(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void doRemoveGarbage() {
        Iterator<Object> iterator;
        Map.Entry<File, Integer> $receiver$iv;
        for (LookupSymbolKey hash : this.lookupMap.getKeys()) {
            void $receiver$iv$iv;
            Collection<Integer> collection = this.lookupMap.get(hash);
            if (collection == null) {
                Intrinsics.throwNpe();
            }
            Iterable iterable = collection;
            LookupSymbolKey lookupSymbolKey = hash;
            LookupMap lookupMap = this.lookupMap;
            iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                if (!this.idToFile.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            lookupMap.set(lookupSymbolKey, kotlin.collections.CollectionsKt.toSet((Iterable)list));
        }
        Map<File, Integer> oldFileToId = this.fileToId.toMap();
        HashMap oldIdToNewId = new HashMap(oldFileToId.size());
        this.idToFile.clean();
        this.fileToId.clean();
        this.size = 0;
        this.deletedCount = 0;
        iterator = oldFileToId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<File, Integer> element$iv$iv = $receiver$iv = iterator.next();
            File file = element$iv$iv.getKey();
            element$iv$iv = $receiver$iv;
            int oldId = ((Number)element$iv$iv.getValue()).intValue();
            int newId = this.addFileIfNeeded(file);
            Map it = oldIdToNewId;
            Integer $i$a$1$filter = oldId;
            Integer n = newId;
            it.put($i$a$1$filter, n);
        }
        for (LookupSymbolKey lookup : this.lookupMap.getKeys()) {
            void $receiver$iv$iv;
            Iterable $receiver$iv2;
            Collection<Integer> collection = this.lookupMap.get(lookup);
            if (collection == null) {
                Intrinsics.throwNpe();
            }
            Iterable newId = $receiver$iv2 = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Integer n;
                Object element$iv$iv = element$iv$iv$iv;
                int it = ((Number)element$iv$iv).intValue();
                if ((Integer)oldIdToNewId.get(it) == null) continue;
                Integer it$iv$iv = n;
                destination$iv$iv.add(it$iv$iv);
            }
            Set fileIds = kotlin.collections.CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (fileIds.isEmpty()) {
                this.lookupMap.remove(lookup);
                continue;
            }
            this.lookupMap.set(lookup, fileIds);
        }
    }

    public final void forceGC() {
        this.removeGarbageIfNeeded(true);
        this.flush(false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump(@NotNull Set<LookupSymbol> lookupSymbols, @Nullable File basePath) {
        Object value$iv$iv$iv;
        Object it;
        Object element$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(lookupSymbols, (String)"lookupSymbols");
        this.flush(false);
        StringBuilder sb = new StringBuilder();
        Printer p = new Printer((Appendable)sb);
        Iterable $receiver$iv = lookupSymbols;
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            element$iv$iv = iterator.next();
            it = (LookupSymbol)element$iv$iv;
            LookupSymbolKey key$iv$iv = new LookupSymbolKey(((LookupSymbol)it).getName(), ((LookupSymbol)it).getScope());
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map lookupsStrings = destination$iv$iv;
        for (LookupSymbolKey lookup : kotlin.collections.CollectionsKt.sorted((Iterable)this.lookupMap.getKeys())) {
            void $receiver$iv$iv2;
            Collection<Integer> fileIds;
            Iterable $receiver$iv2;
            String string;
            Object object;
            Iterable iterable2;
            Iterable destination$iv$iv2;
            if (this.lookupMap.get(lookup) == null) {
                Intrinsics.throwNpe();
            }
            if ((it = (element$iv$iv = lookupsStrings)).containsKey(lookup)) {
                void $receiver$iv$iv3;
                Object v = lookupsStrings.get(lookup);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                Iterable $receiver$iv3 = (Iterable)v;
                it = $receiver$iv3;
                destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv3) {
                    void it2;
                    value$iv$iv$iv = (LookupSymbol)item$iv$iv;
                    iterable2 = destination$iv$iv2;
                    object = it2.getScope() + '#' + it2.getName();
                    iterable2.add(object);
                }
                string = kotlin.collections.CollectionsKt.joinToString$default((Iterable)kotlin.collections.CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            } else {
                string = lookup.toString();
            }
            String key = string;
            destination$iv$iv2 = $receiver$iv2 = (Iterable)fileIds;
            Collection destination$iv$iv3 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                Object object2;
                block14: {
                    void it3;
                    block13: {
                        File file;
                        int $i$a$1$map = ((Number)item$iv$iv).intValue();
                        iterable2 = destination$iv$iv3;
                        object2 = this.idToFile.get((int)it3);
                        if (object2 == null) break block13;
                        File it4 = file = object2;
                        object2 = basePath == null ? it4.getAbsolutePath() : FilesKt.toRelativeString((File)it4, (File)basePath);
                        if (object2 != null) break block14;
                    }
                    object2 = String.valueOf((int)it3);
                }
                object = object2;
                iterable2.add(object);
            }
            String value = kotlin.collections.CollectionsKt.joinToString$default((Iterable)kotlin.collections.CollectionsKt.sorted((Iterable)((List)destination$iv$iv3)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            p.println(new Object[]{key + " -> " + value});
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String dump$default(LookupStorage lookupStorage, Set set, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dump");
        }
        if ((n & 2) != 0) {
            file = null;
        }
        return lookupStorage.dump(set, file);
    }

    public LookupStorage(@NotNull File targetDataDir) {
        Intrinsics.checkParameterIsNotNull((Object)targetDataDir, (String)"targetDataDir");
        super(targetDataDir);
        this.countersFile = this.getStorageFile("counters");
        this.idToFile = (IdToFileMap)this.registerMap((BasicMap)new IdToFileMap(this.getStorageFile("id-to-file")));
        this.fileToId = (FileToIdMap)this.registerMap((BasicMap)new FileToIdMap(this.getStorageFile("file-to-id")));
        this.lookupMap = (LookupMap)this.registerMap((BasicMap)new LookupMap(this.getStorageFile("lookups")));
        try {
            if (this.countersFile.exists()) {
                int n;
                List lines = FilesKt.readLines$default((File)this.countersFile, null, (int)1, null);
                String string = (String)lines.get(0);
                LookupStorage lookupStorage = this;
                lookupStorage.size = n = Integer.parseInt(string);
                string = (String)lines.get(1);
                lookupStorage = this;
                lookupStorage.deletedCount = n = Integer.parseInt(string);
            }
        }
        catch (Exception e) {
            throw (Throwable)new IOException("Could not read " + this.countersFile, e);
        }
    }

    static {
        Companion = new Companion(null);
        DELETED_TO_SIZE_TRESHOLD = 0.5;
        MINIMUM_GARBAGE_COLLECTIBLE_SIZE = 10000;
    }

    public static final /* synthetic */ int access$addFileIfNeeded(LookupStorage $this, @NotNull File file) {
        return $this.addFileIfNeeded(file);
    }

    @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage$Companion;", "", "()V", "DELETED_TO_SIZE_TRESHOLD", "", "MINIMUM_GARBAGE_COLLECTIBLE_SIZE", "", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

