/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.IncrementalJsCacheKt;
import org.jetbrains.kotlin.incremental.InlineFunctionsMap;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.SourceToClassesMap;
import org.jetbrains.kotlin.incremental.TranslationResultMap;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0016J\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#0\"R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache;", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheCommon;", "cachesDir", "Ljava/io/File;", "(Ljava/io/File;)V", "dirtySources", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "value", "", "header", "getHeader", "()[B", "setHeader", "([B)V", "headerFile", "getHeaderFile", "()Ljava/io/File;", "inlineFunctions", "Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "sourcesToClasses", "Lorg/jetbrains/kotlin/incremental/SourceToClassesMap;", "translationResults", "Lorg/jetbrains/kotlin/incremental/TranslationResultMap;", "compareAndUpdate", "", "incrementalResults", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumerImpl;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "markDirty", "removedAndCompiledSources", "", "nonDirtyPackageParts", "", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "Companion", "kotlin-build-common"})
public class IncrementalJsCache
extends IncrementalCacheCommon {
    private final ArrayList<File> dirtySources;
    private final TranslationResultMap translationResults;
    private final SourceToClassesMap sourcesToClasses;
    private final InlineFunctionsMap inlineFunctions;
    private static final String TRANSLATION_RESULT_MAP = "translation-result";
    private static final String SOURCES_TO_CLASSES_FQNS = "sources-to-classes";
    private static final String INLINE_FUNCTIONS = "inline-functions";
    private static final String HEADER_FILE_NAME = "header.meta";
    public static final Companion Companion = new Companion(null);

    private final File getHeaderFile() {
        return new File(this.getCachesDir(), IncrementalJsCache.Companion.getHEADER_FILE_NAME());
    }

    @NotNull
    public final byte[] getHeader() {
        return FilesKt.readBytes((File)this.getHeaderFile());
    }

    public final void setHeader(@NotNull byte[] value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.getCachesDir().mkdirs();
        FilesKt.writeBytes((File)this.getHeaderFile(), (byte[])value);
    }

    @Override
    public void markDirty(@NotNull List<? extends File> removedAndCompiledSources) {
        Intrinsics.checkParameterIsNotNull(removedAndCompiledSources, (String)"removedAndCompiledSources");
        this.dirtySources.addAll((Collection<File>)removedAndCompiledSources);
    }

    /*
     * WARNING - void declaration
     */
    public final void compareAndUpdate(@NotNull IncrementalResultsConsumerImpl incrementalResults, @NotNull ChangesCollector changesCollector) {
        Object srcFile;
        Object object;
        Object element$iv22;
        Intrinsics.checkParameterIsNotNull((Object)incrementalResults, (String)"incrementalResults");
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        Map translatedFiles = incrementalResults.getPackageParts();
        Iterable entry = this.dirtySources;
        for (Object element$iv22 : entry) {
            Map map;
            File it = (File)element$iv22;
            object = translatedFiles;
            Map map2 = map = object;
            if (map2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (!map2.containsKey(it)) {
                this.translationResults.remove(it, changesCollector);
                this.inlineFunctions.remove(it);
            }
            this.removeAllFromClassStorage(this.sourcesToClasses.get(it));
            this.sourcesToClasses.clearOutputsForSource(it);
        }
        this.dirtySources.clear();
        element$iv22 = translatedFiles;
        for (Map.Entry entry2 : element$iv22.entrySet()) {
            void binaryMetadata;
            Object object2;
            byte[] binaryAst;
            block11: {
                block10: {
                    TranslationResultValue $i$f$forEach;
                    TranslationResultValue it;
                    TranslationResultValue data;
                    object = entry2;
                    srcFile = (File)object.getKey();
                    object = entry2;
                    TranslationResultValue $i$a$1$forEach = data = (TranslationResultValue)object.getValue();
                    object = $i$a$1$forEach.component1();
                    binaryAst = $i$a$1$forEach.component2();
                    object2 = this.translationResults.get((File)srcFile);
                    if (object2 == null) break block10;
                    byte[] byArray = object2.getMetadata();
                    object2 = byArray;
                    if (byArray != null && (object2 = IncrementalJsCacheKt.getProtoData((File)srcFile, (byte[])(it = ($i$f$forEach = object2)))) != null) break block11;
                }
                object2 = MapsKt.emptyMap();
            }
            TranslationResultValue oldProtoMap = object2;
            Map<ClassId, ProtoData> newProtoMap = IncrementalJsCacheKt.getProtoData((File)srcFile, (byte[])binaryMetadata);
            for (ProtoData protoData : newProtoMap.values()) {
                if (!(protoData instanceof ClassProtoData)) continue;
                this.addToClassStorage(((ClassProtoData)protoData).getProto(), ((ClassProtoData)protoData).getNameResolver(), (File)srcFile);
            }
            for (ClassId classId : SetsKt.plus(oldProtoMap.keySet(), (Iterable)newProtoMap.keySet())) {
                changesCollector.collectProtoChanges((ProtoData)oldProtoMap.get(classId), newProtoMap.get(classId));
            }
            this.translationResults.put((File)srcFile, (byte[])binaryMetadata, binaryAst);
        }
        srcFile = incrementalResults.getInlineFunctions();
        for (Map.Entry entry3 : srcFile.entrySet()) {
            object = entry3;
            srcFile = (File)object.getKey();
            object = entry3;
            Map inlineDeclarations = (Map)object.getValue();
            this.inlineFunctions.process((File)srcFile, inlineDeclarations, changesCollector);
        }
    }

    @NotNull
    public final Map<File, TranslationResultValue> nonDirtyPackageParts() {
        HashMap<File, TranslationResultValue> hashMap;
        HashMap<File, TranslationResultValue> $receiver = hashMap = new HashMap<File, TranslationResultValue>();
        for (String path : this.translationResults.keys()) {
            File file = new File(path);
            if (this.dirtySources.contains(file)) continue;
            TranslationResultValue translationResultValue = this.translationResults.get(path);
            if (translationResultValue == null) {
                Intrinsics.throwNpe();
            }
            $receiver.put(file, translationResultValue);
        }
        return hashMap;
    }

    public IncrementalJsCache(@NotNull File cachesDir) {
        Intrinsics.checkParameterIsNotNull((Object)cachesDir, (String)"cachesDir");
        super(cachesDir);
        IncrementalJsCache incrementalJsCache = this;
        ArrayList arrayList = new ArrayList();
        incrementalJsCache.dirtySources = arrayList;
        this.translationResults = (TranslationResultMap)this.registerMap((BasicMap)new TranslationResultMap(this.getStorageFile(IncrementalJsCache.Companion.getTRANSLATION_RESULT_MAP())));
        this.sourcesToClasses = (SourceToClassesMap)this.registerMap((BasicMap)new SourceToClassesMap(this.getStorageFile(IncrementalJsCache.Companion.getSOURCES_TO_CLASSES_FQNS())));
        this.inlineFunctions = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(IncrementalJsCache.Companion.getINLINE_FUNCTIONS())));
    }

    static {
        TRANSLATION_RESULT_MAP = TRANSLATION_RESULT_MAP;
        SOURCES_TO_CLASSES_FQNS = SOURCES_TO_CLASSES_FQNS;
        INLINE_FUNCTIONS = INLINE_FUNCTIONS;
        HEADER_FILE_NAME = HEADER_FILE_NAME;
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache$Companion;", "", "()V", "HEADER_FILE_NAME", "", "getHEADER_FILE_NAME", "()Ljava/lang/String;", "INLINE_FUNCTIONS", "getINLINE_FUNCTIONS", "SOURCES_TO_CLASSES_FQNS", "getSOURCES_TO_CLASSES_FQNS", "TRANSLATION_RESULT_MAP", "getTRANSLATION_RESULT_MAP", "kotlin-build-common"})
    public static final class Companion {
        private final String getTRANSLATION_RESULT_MAP() {
            return TRANSLATION_RESULT_MAP;
        }

        private final String getSOURCES_TO_CLASSES_FQNS() {
            return SOURCES_TO_CLASSES_FQNS;
        }

        private final String getINLINE_FUNCTIONS() {
            return INLINE_FUNCTIONS;
        }

        private final String getHEADER_FILE_NAME() {
            return HEADER_FILE_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

