/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.NameTransformer;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0002B#\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0086\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00032\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/AbstractSourceToOutputMap;", "Name", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "nameTransformer", "Lorg/jetbrains/kotlin/incremental/storage/NameTransformer;", "storageFile", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Lorg/jetbrains/kotlin/incremental/storage/NameTransformer;Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "add", "", "sourceFile", "className", "(Ljava/io/File;Ljava/lang/Object;)V", "clearOutputsForSource", "contains", "", "dumpValue", "value", "get", "getFqNames", "Lorg/jetbrains/kotlin/name/FqName;", "remove", "path", "kotlin-build-common"})
public abstract class AbstractSourceToOutputMap<Name>
extends BasicStringMap<Collection<? extends String>> {
    private final NameTransformer<Name> nameTransformer;
    private final FileToPathConverter pathConverter;

    public final void clearOutputsForSource(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        this.remove(this.pathConverter.toPath(sourceFile));
    }

    public final void add(@NotNull File sourceFile, Name className2) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        this.getStorage().append(this.pathConverter.toPath(sourceFile), CollectionsKt.listOf((Object)this.nameTransformer.asString(className2)));
    }

    public final boolean contains(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.getStorage().contains(this.pathConverter.toPath(sourceFile));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Name> get(@NotNull File sourceFile) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Iterable iterable = (Collection)this.getStorage().get(this.pathConverter.toPath(sourceFile));
        boolean bl = false;
        Collection collection = iterable;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        iterable = collection;
        NameTransformer<Name> nameTransformer = this.nameTransformer;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            Name Name2 = nameTransformer.asName((String)p1);
            collection2.add(Name2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<FqName> getFqNames(@NotNull File sourceFile) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Iterable iterable = (Collection)this.getStorage().get(this.pathConverter.toPath(sourceFile));
        boolean bl = false;
        Collection collection = iterable;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        iterable = collection;
        NameTransformer<Name> nameTransformer = this.nameTransformer;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            FqName fqName = nameTransformer.asFqName((String)p1);
            collection2.add(fqName);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Collection<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return IncrementalJvmCacheKt.dumpCollection(value);
    }

    private final void remove(String path) {
        this.getStorage().remove(path);
    }

    public AbstractSourceToOutputMap(@NotNull NameTransformer<Name> nameTransformer, @NotNull File storageFile, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter(nameTransformer, (String)"nameTransformer");
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        super(storageFile, (KeyDescriptor<String>)((KeyDescriptor)PathStringDescriptor.INSTANCE), (DataExternalizer)StringCollectionExternalizer.INSTANCE);
        this.nameTransformer = nameTransformer;
        this.pathConverter = pathConverter;
    }
}

