/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0015\u0010\t\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH$\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0003H\u0016J\u001d\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/StringMapExternalizer;", "T", "Lcom/intellij/util/io/DataExternalizer;", "", "", "()V", "read", "input", "Ljava/io/DataInput;", "readValue", "(Ljava/io/DataInput;)Ljava/lang/Object;", "save", "", "output", "Ljava/io/DataOutput;", "map", "writeValue", "value", "(Ljava/io/DataOutput;Ljava/lang/Object;)V", "kotlin-build-common"})
public abstract class StringMapExternalizer<T>
implements DataExternalizer<Map<String, ? extends T>> {
    public void save(@NotNull DataOutput output, @Nullable Map<String, ? extends T> map) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Map<String, T> map2 = map;
        Intrinsics.checkNotNull(map2);
        output.writeInt(map2.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            String key = entry.getKey();
            T value = entry.getValue();
            ExternalizersKt.writeString(output, key);
            this.writeValue(output, value);
        }
    }

    @Nullable
    public Map<String, T> read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int size = input.readInt();
        HashMap map = new HashMap(size);
        int n = 0;
        while (n < size) {
            int it = n++;
            boolean bl = false;
            String name = ExternalizersKt.readString(input);
            ((Map)map).put(name, this.readValue(input));
        }
        return map;
    }

    protected abstract void writeValue(@NotNull DataOutput var1, T var2);

    protected abstract T readValue(@NotNull DataInput var1);
}

