/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.InlineFunctionsMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006J\u001c\u0010\u0013\u001a\u00020\u00032\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "process", "", "srcFile", "newMap", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "sourceFile", "dumpValue", "value", "kotlin-build-common"})
final class InlineFunctionsMap
extends BasicStringMap<Map<String, ? extends Long>> {
    public InlineFunctionsMap(@NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(storageFile, StringToLongMapExternalizer.INSTANCE, icContext);
    }

    public final synchronized void process(@NotNull File srcFile, @NotNull Map<String, Long> newMap2, @NotNull ChangesCollector changesCollector) {
        Map oldMap2;
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        Intrinsics.checkNotNullParameter(newMap2, (String)"newMap");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        String key = this.getPathConverter().toPath(srcFile);
        Map map = (Map)this.getStorage().get(key);
        if (map == null) {
            map = oldMap2 = MapsKt.emptyMap();
        }
        if (!newMap2.isEmpty()) {
            this.getStorage().set(key, newMap2);
        } else {
            this.getStorage().remove(key);
        }
        for (String fn : SetsKt.plus(oldMap2.keySet(), (Iterable)newMap2.keySet())) {
            FqName fqName;
            String[] stringArray = new String[]{"."};
            List fqNameSegments = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)StringsKt.removePrefix((String)fn, (CharSequence)"<get>"), (CharSequence)"<set>"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Intrinsics.checkNotNullExpressionValue((Object)FqName.fromSegments((List)fqNameSegments), (String)"fromSegments(...)");
            FqName fqName2 = fqName.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"parent(...)");
            String string = fqName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            changesCollector.collectMemberIfValueWasChanged(fqName2, string, oldMap2.get(fn), newMap2.get(fn));
        }
    }

    @Override
    public final synchronized void remove(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        this.getStorage().remove(this.getPathConverter().toPath(sourceFile));
    }

    @Override
    @NotNull
    public String dumpValue(@NotNull Map<String, Long> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return IncrementalJvmCacheKt.dumpMap(value, dumpValue.1.INSTANCE);
    }
}

