/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.PersistentStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000fH\u0002J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000fH\u0004J$\u0010\u0017\u001a\u001e\u0012\f\u0012\n \u0018*\u0004\u0018\u00018\u00008\u0000\u0012\f\u0012\n \u0018*\u0004\u0018\u00018\u00018\u00010\u000fH\u0002J\u0016\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010!J\u001e\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020#2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020#H\u0016J\b\u0010)\u001a\u00020#H\u0016J\b\u0010*\u001a\u00020#H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0010\u0010\u0012R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/LazyStorage;", "KEY", "VALUE", "Lorg/jetbrains/kotlin/incremental/storage/PersistentStorage;", "storageFile", "Ljava/io/File;", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "<init>", "(Ljava/io/File;Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;)V", "getStorageFile", "()Ljava/io/File;", "storage", "Lcom/intellij/util/io/PersistentHashMap;", "isStorageFileExist", "", "()Z", "isStorageFileExist$delegate", "Lkotlin/Lazy;", "getStorageIfExists", "getStorageOrCreateNew", "createMap", "kotlin.jvm.PlatformType", "keys", "", "getKeys", "()Ljava/util/Set;", "contains", "key", "(Ljava/lang/Object;)Z", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "remove", "(Ljava/lang/Object;)V", "flush", "close", "clean", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nLazyStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyStorage.kt\norg/jetbrains/kotlin/incremental/storage/LazyStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public class LazyStorage<KEY, VALUE>
implements PersistentStorage<KEY, VALUE> {
    @NotNull
    private final File storageFile;
    @NotNull
    private final KeyDescriptor<KEY> keyDescriptor;
    @NotNull
    private final DataExternalizer<VALUE> valueExternalizer;
    @Nullable
    private PersistentHashMap<KEY, VALUE> storage;
    @NotNull
    private final Lazy isStorageFileExist$delegate;

    public LazyStorage(@NotNull File storageFile, @NotNull KeyDescriptor<KEY> keyDescriptor, @NotNull DataExternalizer<VALUE> valueExternalizer) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        this.storageFile = storageFile;
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
        this.isStorageFileExist$delegate = LazyKt.lazy(() -> LazyStorage.isStorageFileExist_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public File getStorageFile() {
        return this.storageFile;
    }

    private final boolean isStorageFileExist() {
        Lazy lazy = this.isStorageFileExist$delegate;
        return (Boolean)lazy.getValue();
    }

    private final PersistentHashMap<KEY, VALUE> getStorageIfExists() {
        PersistentHashMap<KEY, VALUE> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            if (this.isStorageFileExist()) {
                PersistentHashMap<KEY, VALUE> persistentHashMap2;
                PersistentHashMap<KEY, VALUE> it = persistentHashMap2 = this.createMap();
                boolean bl = false;
                this.storage = it;
                persistentHashMap = persistentHashMap2;
            } else {
                persistentHashMap = null;
            }
        }
        return persistentHashMap;
    }

    @NotNull
    protected final PersistentHashMap<KEY, VALUE> getStorageOrCreateNew() {
        PersistentHashMap<KEY, VALUE> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            PersistentHashMap<KEY, VALUE> persistentHashMap2;
            PersistentHashMap<KEY, VALUE> it = persistentHashMap2 = this.createMap();
            boolean bl = false;
            this.storage = it;
            persistentHashMap = persistentHashMap2;
        }
        return persistentHashMap;
    }

    private final PersistentHashMap<KEY, VALUE> createMap() {
        return new PersistentHashMap(this.getStorageFile().toPath(), this.keyDescriptor, this.valueExternalizer);
    }

    @Override
    @NotNull
    public synchronized Set<KEY> getKeys() {
        Set set;
        block0: {
            Set $this$_get_keys__u24lambda_u243 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            PersistentHashMap<KEY, VALUE> persistentHashMap = this.getStorageIfExists();
            if (persistentHashMap == null) break block0;
            persistentHashMap.processKeysWithExistingMapping((Processor)new CommonProcessors.CollectProcessor((Collection)$this$_get_keys__u24lambda_u243));
        }
        return SetsKt.build((Set)set);
    }

    @Override
    public synchronized boolean contains(KEY key) {
        PersistentHashMap<KEY, VALUE> persistentHashMap = this.getStorageIfExists();
        return persistentHashMap != null ? persistentHashMap.containsMapping(key) : false;
    }

    @Override
    @Nullable
    public synchronized VALUE get(KEY key) {
        PersistentHashMap<KEY, VALUE> persistentHashMap = this.getStorageIfExists();
        return (VALUE)(persistentHashMap != null ? persistentHashMap.get(key) : null);
    }

    @Override
    public synchronized void set(KEY key, VALUE value) {
        this.getStorageOrCreateNew().put(key, value);
    }

    @Override
    public synchronized void remove(KEY key) {
        block0: {
            PersistentHashMap<KEY, VALUE> persistentHashMap = this.getStorageIfExists();
            if (persistentHashMap == null) break block0;
            persistentHashMap.remove(key);
        }
    }

    @Override
    public synchronized void flush() {
        block0: {
            PersistentHashMap<KEY, VALUE> persistentHashMap = this.storage;
            if (persistentHashMap == null) break block0;
            persistentHashMap.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            PersistentHashMap<KEY, VALUE> persistentHashMap = this.storage;
            if (persistentHashMap != null) {
                persistentHashMap.close();
            }
        }
        finally {
            this.storage = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clean() {
        try {
            PersistentHashMap<KEY, VALUE> persistentHashMap = this.storage;
            if (persistentHashMap != null) {
                persistentHashMap.close();
            }
        }
        finally {
            this.storage = null;
            if (!IOUtil.deleteAllFilesStartingWith((File)this.getStorageFile())) {
                throw new IOException("Could not delete internal storage: " + this.getStorageFile().getAbsolutePath());
            }
        }
    }

    private static final boolean isStorageFileExist_delegate$lambda$0(LazyStorage this$0) {
        return this$0.getStorageFile().exists();
    }
}

