/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.scripting.resolve;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMapKt;
import org.jetbrains.kotlin.fir.scopes.DelicateScopeAPI;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirLocalScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B_\u0012\u001c\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u0003\u0012\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u0019H\u0016J(\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00160\u0019H\u0016J.\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u001c\u0010\u0018\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00160\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\"H\u0016J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H\u0017R'\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/scripting/resolve/FirReplHistoryScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "properties", "", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "functions", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "classLikes", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getProperties", "()Ljava/util/Map;", "getFunctions", "getClassLikes", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "processFunctionsByName", "", "name", "processor", "Lkotlin/Function1;", "processPropertiesByName", "processClassifiersByNameWithSubstitution", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "mayContainName", "", "getCallableNames", "", "getClassifierNames", "withReplacedSessionOrNull", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "newSession", "newScopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "kotlin-scripting-compiler-impl"})
@SourceDebugExtension(value={"SMAP\nFirReplHistoryScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReplHistoryScope.kt\norg/jetbrains/kotlin/scripting/resolve/FirReplHistoryScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1300#2,2:61\n1315#2,4:63\n*S KotlinDebug\n*F\n+ 1 FirReplHistoryScope.kt\norg/jetbrains/kotlin/scripting/resolve/FirReplHistoryScope\n*L\n44#1:61,2\n44#1:63,4\n*E\n"})
public final class FirReplHistoryScope
extends FirContainingNamesAwareScope {
    @NotNull
    private final Map<Name, List<FirVariableSymbol<?>>> properties;
    @NotNull
    private final Map<Name, List<FirNamedFunctionSymbol>> functions;
    @NotNull
    private final Map<Name, FirClassLikeSymbol<?>> classLikes;
    @NotNull
    private final FirSession useSiteSession;

    public FirReplHistoryScope(@NotNull Map<Name, ? extends List<? extends FirVariableSymbol<?>>> properties, @NotNull Map<Name, ? extends List<? extends FirNamedFunctionSymbol>> functions, @NotNull Map<Name, ? extends FirClassLikeSymbol<?>> classLikes, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        Intrinsics.checkNotNullParameter(classLikes, (String)"classLikes");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        this.properties = properties;
        this.functions = functions;
        this.classLikes = classLikes;
        this.useSiteSession = useSiteSession;
    }

    @NotNull
    public final Map<Name, List<FirVariableSymbol<?>>> getProperties() {
        return this.properties;
    }

    @NotNull
    public final Map<Name, List<FirNamedFunctionSymbol>> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final Map<Name, FirClassLikeSymbol<?>> getClassLikes() {
        return this.classLikes;
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    public void processFunctionsByName(@NotNull Name name, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        List list = this.functions.get(name);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (FirNamedFunctionSymbol function : CollectionsKt.asReversed(list)) {
            processor.invoke((Object)function);
        }
    }

    public void processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        List list = this.properties.get(name);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (FirVariableSymbol property : CollectionsKt.asReversed(list)) {
            processor.invoke((Object)property);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processClassifiersByNameWithSubstitution(@NotNull Name name, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        FirClassLikeSymbol<?> klass = this.classLikes.get(name);
        if (klass != null) {
            void $this$associateWithTo$iv$iv;
            Iterable $this$associateWith$iv = klass.getTypeParameterSymbols();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable iterable = $this$associateWith$iv;
            Map destination$iv$iv = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                FirTypeParameterSymbol firTypeParameterSymbol = (FirTypeParameterSymbol)element$iv$iv;
                Object t = element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                ConeTypeParameterType coneTypeParameterType = FirNestedClassifierScopeKt.toConeType((FirTypeParameterSymbol)it);
                map.put(t, coneTypeParameterType);
            }
            Map substitution = destination$iv$iv;
            processor.invoke(klass, (Object)ConeSubstitutorByMapKt.substitutorByMap((Map)substitution, (FirSession)this.useSiteSession, (boolean)true));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayContainName(@NotNull Name name) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.properties.containsKey(name)) return true;
        List<FirNamedFunctionSymbol> list = this.functions.get(name);
        if (list != null) {
            if (!((Collection)list).isEmpty()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!this.classLikes.containsKey(name)) return false;
        return true;
    }

    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.plus(this.properties.keySet(), (Iterable)this.functions.keySet());
    }

    @NotNull
    public Set<Name> getClassifierNames() {
        return this.classLikes.keySet();
    }

    @DelicateScopeAPI
    @Nullable
    public FirLocalScope withReplacedSessionOrNull(@NotNull FirSession newSession, @NotNull ScopeSession newScopeSession) {
        Intrinsics.checkNotNullParameter((Object)newSession, (String)"newSession");
        Intrinsics.checkNotNullParameter((Object)newScopeSession, (String)"newScopeSession");
        return null;
    }
}

