/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.gnu.trove.THashSet;

public class InheritanceImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.InheritanceImplUtil");

    public static boolean isInheritor(final @NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep) {
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (baseClass instanceof PsiAnonymousClass) {
            return false;
        }
        if (!checkDeep) {
            return InheritanceImplUtil.isInheritor(candidateClass.getManager(), candidateClass, baseClass, false, null);
        }
        if (InheritanceImplUtil.hasObjectQualifiedName(candidateClass)) {
            return false;
        }
        if (InheritanceImplUtil.hasObjectQualifiedName(baseClass)) {
            return true;
        }
        Map<PsiClass, Boolean> map = CachedValuesManager.getCachedValue(candidateClass, new CachedValueProvider<Map<PsiClass, Boolean>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<Map<PsiClass, Boolean>> compute() {
                ConcurrentMap map = ContainerUtil.createConcurrentWeakMap();
                return CachedValueProvider.Result.create(map, candidateClass, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
            }
        });
        Boolean computed = map.get(baseClass);
        if (computed == null) {
            computed = InheritanceImplUtil.isInheritor(candidateClass.getManager(), candidateClass, baseClass, true, null);
            map.put(baseClass, computed);
        }
        return computed;
    }

    public static boolean hasObjectQualifiedName(@NotNull PsiClass candidateClass) {
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "com/intellij/psi/impl/InheritanceImplUtil", "hasObjectQualifiedName"));
        }
        if (!"Object".equals(candidateClass.getName())) {
            return false;
        }
        PsiElement parent = candidateClass.getParent();
        return parent instanceof PsiJavaFile && "java.lang".equals(((PsiJavaFile)parent).getPackageName());
    }

    private static boolean isInheritor(@NotNull PsiManager manager, @NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep, @Nullable Set<PsiClass> checkedClasses) {
        PsiClass objectClass;
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritor"));
        }
        if (candidateClass instanceof PsiAnonymousClass) {
            PsiClass baseCandidateClass = ((PsiAnonymousClass)candidateClass).getBaseClassType().resolve();
            return baseCandidateClass != null && InheritanceUtil.isInheritorOrSelf(baseCandidateClass, baseClass, checkDeep);
        }
        if (checkDeep && LOG.isDebugEnabled()) {
            LOG.debug("Using uncached version for " + candidateClass.getQualifiedName() + " and " + baseClass);
        }
        if (InheritanceImplUtil.hasObjectQualifiedName(baseClass) && manager.areElementsEquivalent(baseClass, objectClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Object", candidateClass.getResolveScope()))) {
            if (manager.areElementsEquivalent(candidateClass, objectClass)) {
                return false;
            }
            if (checkDeep || candidateClass.isInterface()) {
                return true;
            }
            return manager.areElementsEquivalent(candidateClass.getSuperClass(), objectClass);
        }
        if (!checkDeep) {
            boolean cInt = candidateClass.isInterface();
            boolean bInt = baseClass.isInterface();
            if (candidateClass instanceof PsiCompiledElement) {
                String baseQName = baseClass.getQualifiedName();
                if (baseQName == null) {
                    return false;
                }
                GlobalSearchScope scope2 = candidateClass.getResolveScope();
                if (cInt == bInt && InheritanceImplUtil.checkReferenceListWithQualifiedNames(baseQName, candidateClass.getExtendsList(), manager, scope2)) {
                    return true;
                }
                return bInt && !cInt && InheritanceImplUtil.checkReferenceListWithQualifiedNames(baseQName, candidateClass.getImplementsList(), manager, scope2);
            }
            String baseName = baseClass.getName();
            if (cInt == bInt) {
                for (PsiClassType type2 : candidateClass.getExtendsListTypes()) {
                    if (!Comparing.equal(type2.getClassName(), baseName) || !manager.areElementsEquivalent(baseClass, type2.resolve())) continue;
                    return true;
                }
            } else if (!cInt) {
                for (PsiClassType type3 : candidateClass.getImplementsListTypes()) {
                    if (!Comparing.equal(type3.getClassName(), baseName) || !manager.areElementsEquivalent(baseClass, type3.resolve())) continue;
                    return true;
                }
            }
            return false;
        }
        return InheritanceImplUtil.isInheritorWithoutCaching(manager, candidateClass, baseClass, checkedClasses);
    }

    private static boolean checkReferenceListWithQualifiedNames(String baseQName, PsiReferenceList extList, PsiManager manager, GlobalSearchScope scope2) {
        if (extList != null) {
            PsiJavaCodeReferenceElement[] refs;
            for (PsiJavaCodeReferenceElement ref : refs = extList.getReferenceElements()) {
                if (!Comparing.equal(PsiNameHelper.getQualifiedClassName(ref.getQualifiedName(), false), baseQName) || JavaPsiFacade.getInstance(manager.getProject()).findClass(baseQName, scope2) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInheritorWithoutCaching(@NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull PsiClass baseClass, @Nullable Set<PsiClass> checkedClasses) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritorWithoutCaching"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritorWithoutCaching"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritorWithoutCaching"));
        }
        if (manager.areElementsEquivalent(aClass, baseClass)) {
            return false;
        }
        if (aClass.isInterface() && !baseClass.isInterface()) {
            return false;
        }
        if (checkedClasses == null) {
            checkedClasses = new THashSet<PsiClass>();
        }
        checkedClasses.add(aClass);
        return InheritanceImplUtil.checkInheritor(manager, aClass.getExtendsListTypes(), baseClass, checkedClasses) || InheritanceImplUtil.checkInheritor(manager, aClass.getImplementsListTypes(), baseClass, checkedClasses);
    }

    private static boolean checkInheritor(@NotNull PsiManager manager, @NotNull PsiClassType[] supers, @NotNull PsiClass baseClass, @NotNull Set<PsiClass> checkedClasses) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (supers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supers", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (checkedClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedClasses", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        for (PsiClassType aSuper : supers) {
            PsiClass aClass = aSuper.resolve();
            if (aClass == null || !InheritanceImplUtil.checkInheritor(manager, aClass, baseClass, checkedClasses)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkInheritor(@NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull PsiClass baseClass, @NotNull Set<PsiClass> checkedClasses) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        if (checkedClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedClasses", "com/intellij/psi/impl/InheritanceImplUtil", "checkInheritor"));
        }
        ProgressIndicatorProvider.checkCanceled();
        if (manager.areElementsEquivalent(baseClass, aClass)) {
            return true;
        }
        if (checkedClasses.contains(aClass)) {
            return false;
        }
        return InheritanceImplUtil.isInheritor(manager, aClass, baseClass, true, checkedClasses);
    }

    public static boolean isInheritorDeep(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, @Nullable PsiClass classToByPass) {
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritorDeep"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/InheritanceImplUtil", "isInheritorDeep"));
        }
        if (baseClass instanceof PsiAnonymousClass) {
            return false;
        }
        THashSet<PsiClass> checkedClasses = null;
        if (classToByPass != null) {
            checkedClasses = new THashSet<PsiClass>();
            checkedClasses.add(classToByPass);
        }
        return InheritanceImplUtil.isInheritor(candidateClass.getManager(), candidateClass, baseClass, true, checkedClasses);
    }
}

