/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.gnu.trove.THashMap;
import org.jetbrains.kotlin.relocated.org.jdom.Element;

abstract class AbstractCollectionBinding
extends Binding
implements MultiNodeBinding {
    private Map<Class<?>, Binding> itemBindings;
    protected final Class<?> itemType;
    private final AbstractCollection annotation;

    public AbstractCollectionBinding(@NotNull Class elementType, @Nullable MutableAccessor accessor) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/util/xmlb/AbstractCollectionBinding", "<init>"));
        }
        super(accessor);
        this.itemType = elementType;
        this.annotation = accessor == null ? null : accessor.getAnnotation(AbstractCollection.class);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    public void init(@NotNull Type originalType) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/AbstractCollectionBinding", "init"));
        }
        if (this.annotation == null || this.annotation.surroundWithTag()) {
            return;
        }
        if (StringUtil.isEmpty(this.annotation.elementTag()) || this.annotation.elementTag().equals("option") && XmlSerializerImpl.getBinding(this.itemType) == null) {
            throw new XmlSerializationException("If surround with tag is turned off, element tag must be specified for: " + this.myAccessor);
        }
    }

    @NotNull
    private synchronized Map<Class<?>, Binding> getElementBindings() {
        if (this.itemBindings == null) {
            Binding binding = XmlSerializerImpl.getBinding(this.itemType);
            if (this.annotation == null || this.annotation.elementTypes().length == 0) {
                this.itemBindings = binding == null ? Collections.emptyMap() : Collections.singletonMap(this.itemType, binding);
            } else {
                this.itemBindings = new THashMap();
                if (binding != null) {
                    this.itemBindings.put(this.itemType, binding);
                }
                for (Class aClass : this.annotation.elementTypes()) {
                    Binding b = XmlSerializerImpl.getBinding(aClass);
                    if (b == null) continue;
                    this.itemBindings.put(aClass, b);
                }
                if (this.itemBindings.isEmpty()) {
                    this.itemBindings = Collections.emptyMap();
                }
            }
        }
        Map<Class<?>, Binding> map = this.itemBindings;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/AbstractCollectionBinding", "getElementBindings"));
        }
        return map;
    }

    @Nullable
    private Binding getElementBinding(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/AbstractCollectionBinding", "getElementBinding"));
        }
        for (Binding binding : this.getElementBindings().values()) {
            if (!binding.isBoundTo(element)) continue;
            return binding;
        }
        return null;
    }

    abstract Object processResult(Collection var1, Object var2);

    @Override
    @Nullable
    public Object deserializeList(Object context2, @NotNull List<Element> elements) {
        Collection<Object> result2;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeList"));
        }
        if (this.getTagName(context2) == null) {
            if (context2 instanceof Collection) {
                result2 = (SmartList)context2;
                result2.clear();
            } else {
                result2 = new SmartList();
            }
            for (Element node : elements) {
                result2.add(this.deserializeItem(node, context2));
            }
            if (result2 == context2) {
                return result2;
            }
        } else {
            assert (elements.size() == 1);
            result2 = this.deserializeSingle(context2, elements.get(0));
        }
        return this.processResult(result2, context2);
    }

    private Object deserializeItem(@NotNull Element node, Object context2) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeItem"));
        }
        Binding binding = this.getElementBinding(node);
        if (binding == null) {
            String attributeName = this.annotation == null ? "value" : this.annotation.elementValueAttribute();
            String value = attributeName.isEmpty() ? XmlSerializerImpl.getTextValue(node, "") : node.getAttributeValue(attributeName);
            return XmlSerializerImpl.convert(value, this.itemType);
        }
        return binding.deserialize(context2, node);
    }

    @Override
    public Object deserialize(Object context2, @NotNull Element element) {
        SmartList<Object> result2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserialize"));
        }
        if (this.getTagName(context2) == null) {
            if (context2 instanceof Collection) {
                result2 = (Collection)context2;
                result2.clear();
            } else {
                result2 = new SmartList<Object>();
            }
            result2.add(this.deserializeItem(element, context2));
            if (result2 == context2) {
                return result2;
            }
        } else {
            result2 = this.deserializeSingle(context2, element);
        }
        return this.processResult(result2, context2);
    }

    @NotNull
    private Collection deserializeSingle(Object context2, @NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeSingle"));
        }
        Collection result2 = this.createCollection(node.getName());
        for (Element child : node.getChildren()) {
            result2.add(this.deserializeItem(child, context2));
        }
        Collection collection = result2;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeSingle"));
        }
        return collection;
    }

    protected Collection createCollection(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/util/xmlb/AbstractCollectionBinding", "createCollection"));
        }
        return new SmartList();
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/AbstractCollectionBinding", "isBoundTo"));
        }
        String tagName = this.getTagName(element);
        if (tagName == null) {
            if (element.getName().equals(this.annotation == null ? "option" : this.annotation.elementTag())) {
                return true;
            }
            if (this.getElementBinding(element) != null) {
                return true;
            }
        }
        return element.getName().equals(tagName);
    }

    @Nullable
    private String getTagName(@Nullable Object target) {
        return this.annotation == null || this.annotation.surroundWithTag() ? this.getCollectionTagName(target) : null;
    }

    protected abstract String getCollectionTagName(@Nullable Object var1);
}

