/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MutableAccessor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.org.jdom.Element;

class CompactCollectionBinding
extends Binding {
    private final String name;

    protected CompactCollectionBinding(@NotNull MutableAccessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/CompactCollectionBinding", "<init>"));
        }
        super(accessor);
        this.name = this.myAccessor.getName();
    }

    @Override
    @Nullable
    public Object deserialize(Object context2, @NotNull Element element) {
        List list;
        block5: {
            block4: {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/CompactCollectionBinding", "deserialize"));
                }
                list = (List)context2;
                list.clear();
                if (!element.getName().equals(this.name)) break block4;
                for (Element item : element.getChildren("item")) {
                    ContainerUtil.addIfNotNull(list, item.getAttributeValue("value"));
                }
                break block5;
            }
            Element value = element.getChild("value");
            if (value != null) {
                value = value.getChild("list");
            }
            if (value == null) break block5;
            for (Element item : value.getChildren("item")) {
                ContainerUtil.addIfNotNull(list, item.getAttributeValue("itemvalue"));
            }
        }
        return list;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/CompactCollectionBinding", "isBoundTo"));
        }
        String elementName = element.getName();
        if (this.isNameEqual(elementName)) {
            return true;
        }
        if (elementName.equals("option")) {
            return this.isNameEqual(element.getAttributeValue("name"));
        }
        return false;
    }

    private boolean isNameEqual(@Nullable String value) {
        if (value == null) {
            return false;
        }
        if (value.equals(this.name)) {
            return true;
        }
        if (value.length() == this.name.length() + 2 && value.startsWith("my")) {
            return Character.isUpperCase(value.charAt(2)) && value.regionMatches(true, 2, this.name, 0, this.name.length());
        }
        return false;
    }
}

