/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.org.jdom.Attribute;
import org.jetbrains.kotlin.relocated.org.jdom.Element;

class MapBinding
extends Binding
implements MultiNodeBinding {
    private static final Comparator<Object> KEY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
            return 0;
        }
    };
    private final MapAnnotation myMapAnnotation;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private Binding keyBinding;
    private Binding valueBinding;

    public MapBinding(@NotNull MutableAccessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/MapBinding", "<init>"));
        }
        super(accessor);
        this.myMapAnnotation = accessor.getAnnotation(MapAnnotation.class);
    }

    @Override
    public void init(@NotNull Type originalType) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/MapBinding", "init"));
        }
        ParameterizedType type2 = (ParameterizedType)originalType;
        Type[] typeArguments = type2.getActualTypeArguments();
        this.keyClass = XmlSerializerImpl.typeToClass(typeArguments[0]);
        this.valueClass = XmlSerializerImpl.typeToClass(typeArguments[1]);
        this.keyBinding = XmlSerializerImpl.getClassBinding(this.keyClass, typeArguments[0], null);
        this.valueBinding = XmlSerializerImpl.getClassBinding(this.valueClass, typeArguments[1], null);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    private String getEntryAttributeName() {
        return this.myMapAnnotation == null ? "entry" : this.myMapAnnotation.entryTagName();
    }

    private String getKeyAttributeName() {
        return this.myMapAnnotation == null ? "key" : this.myMapAnnotation.keyAttributeName();
    }

    private String getValueAttributeName() {
        return this.myMapAnnotation == null ? "value" : this.myMapAnnotation.valueAttributeName();
    }

    @Override
    @Nullable
    public Object deserializeList(Object context2, @NotNull List<Element> elements) {
        List<Element> childNodes;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/xmlb/MapBinding", "deserializeList"));
        }
        if (this.myMapAnnotation == null || this.myMapAnnotation.surroundWithTag()) {
            assert (elements.size() == 1);
            childNodes = elements.get(0).getChildren();
        } else {
            childNodes = elements;
        }
        return this.deserialize(context2, childNodes);
    }

    @Override
    public Object deserialize(Object context2, @NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/MapBinding", "deserialize"));
        }
        if (this.myMapAnnotation == null || this.myMapAnnotation.surroundWithTag()) {
            return this.deserialize(context2, element.getChildren());
        }
        return this.deserialize(context2, Collections.singletonList(element));
    }

    private Map deserialize(Object context2, List<Element> childNodes) {
        Map map = (Map)context2;
        map.clear();
        for (Element childNode : childNodes) {
            if (!childNode.getName().equals(this.getEntryAttributeName())) {
                LOG.warn("unexpected entry for serialized Map will be skipped: " + childNode);
                continue;
            }
            map.put(this.deserializeKeyOrValue(childNode, this.getKeyAttributeName(), context2, this.keyBinding, this.keyClass), this.deserializeKeyOrValue(childNode, this.getValueAttributeName(), context2, this.valueBinding, this.valueClass));
        }
        return map;
    }

    private Object deserializeKeyOrValue(@NotNull Element entry, @NotNull String attributeName, Object context2, @Nullable Binding binding, @NotNull Class<?> valueClass) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/util/xmlb/MapBinding", "deserializeKeyOrValue"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/util/xmlb/MapBinding", "deserializeKeyOrValue"));
        }
        if (valueClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "com/intellij/util/xmlb/MapBinding", "deserializeKeyOrValue"));
        }
        Attribute attribute = entry.getAttribute(attributeName);
        if (attribute != null) {
            return XmlSerializerImpl.convert(attribute.getValue(), valueClass);
        }
        if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundKeyWithTag()) {
            assert (binding != null);
            for (Element element : entry.getChildren()) {
                if (!binding.isBoundTo(element)) continue;
                return binding.deserialize(context2, element);
            }
        } else {
            List<Object> children;
            Element entryChild = entry.getChild(attributeName);
            List<Object> list = children = entryChild == null ? Collections.emptyList() : entryChild.getChildren();
            if (children.isEmpty()) {
                return null;
            }
            assert (binding != null);
            return Binding.deserializeList(binding, context2, children);
        }
        return null;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/MapBinding", "isBoundTo"));
        }
        if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundWithTag()) {
            return this.myMapAnnotation.entryTagName().equals(element.getName());
        }
        return element.getName().equals("map");
    }
}

