/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typeUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.types.DelegatingType;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypesPackage$dynamicTypes$18e465db;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.JetTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilPackage$TypeUtils$01ebc082;
import kotlin.reflect.jvm.internal.impl.utils.UtilsPackage$collections$b33ae3d0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeUtilPackage$TypeUtils$01ebc082 {
    @NotNull
    public static final Collection<TypeParameterDescriptor> getContainedTypeParameters(@JetValueParameter(name="$receiver") JetType $receiver) {
        Collection destination;
        Object it2;
        Iterable $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor declarationDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            ClassifierDescriptor classifierDescriptor = declarationDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "declarationDescriptor");
            return KotlinPackage.listOf(classifierDescriptor);
        }
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        if (flexibility != null) {
            return KotlinPackage.plus((Iterable)TypeUtilPackage$TypeUtils$01ebc082.getContainedTypeParameters(flexibility.getLowerBound()), (Iterable)TypeUtilPackage$TypeUtils$01ebc082.getContainedTypeParameters(flexibility.getUpperBound()));
        }
        Iterable $receiver3 = $receiver.getArguments();
        Iterable iterable = $receiver3;
        Collection collection = new ArrayList();
        for (Object element : $receiver2) {
            it2 = (TypeProjection)element;
            if (!(!it2.isStarProjection())) continue;
            destination.add(element);
        }
        $receiver3 = (List)destination;
        $receiver2 = $receiver3;
        destination = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver3, 10));
        for (Object item : $receiver2) {
            it2 = (TypeProjection)item;
            Collection collection2 = destination;
            JetType jetType = it2.getType();
            collection2.add(jetType);
        }
        $receiver3 = (List)destination;
        $receiver2 = $receiver3;
        destination = new ArrayList();
        for (Object element : $receiver2) {
            it2 = (JetType)element;
            Iterable list = TypeUtilPackage$TypeUtils$01ebc082.getContainedTypeParameters((JetType)it2);
            KotlinPackage.addAll(destination, list);
        }
        return (List)destination;
    }

    @NotNull
    public static final Collection<TypeParameterDescriptor> getCapturedTypeParameters(@JetValueParameter(name="$receiver") DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        LinkedHashSet<TypeParameterDescriptor> result2 = new LinkedHashSet<TypeParameterDescriptor>();
        DeclarationDescriptor containingDeclaration = $receiver.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            result2.addAll(TypeUtilPackage$TypeUtils$01ebc082.getContainedTypeParameters(((ClassDescriptor)containingDeclaration).getDefaultType()));
        } else if (containingDeclaration instanceof CallableDescriptor) {
            Collection collection = ((CallableDescriptor)containingDeclaration).getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(collection, "containingDeclaration.getTypeParameters()");
            result2.addAll(collection);
        }
        if (containingDeclaration != null) {
            result2.addAll(TypeUtilPackage$TypeUtils$01ebc082.getCapturedTypeParameters(containingDeclaration));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<TypeConstructor> getContainedAndCapturedTypeParameterConstructors(@JetValueParameter(name="$receiver") JetType $receiver) {
        void destination;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        List typeParameters = KotlinPackage.plus((Iterable)TypeUtilPackage$TypeUtils$01ebc082.getContainedTypeParameters($receiver), (Iterable)TypeUtilPackage$TypeUtils$01ebc082.getCapturedTypeParameters($receiver.getConstructor().getDeclarationDescriptor()));
        Iterable $receiver3 = typeParameters;
        Iterable iterable = $receiver3;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver3, 10));
        for (Object item : $receiver2) {
            void it2;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item;
            void var8_8 = destination;
            TypeConstructor typeConstructor2 = it2.getTypeConstructor();
            var8_8.add(typeConstructor2);
        }
        return UtilsPackage$collections$b33ae3d0.toReadOnlyList((List)destination);
    }

    public static final boolean isSubtypeOf(@JetValueParameter(name="$receiver") JetType $receiver, @JetValueParameter(name="superType") @NotNull JetType superType) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(superType, "superType");
        return JetTypeChecker.DEFAULT.isSubtypeOf($receiver, superType);
    }

    public static final boolean cannotBeReified(@JetValueParameter(name="$receiver") JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isNothingOrNullableNothing($receiver) || TypesPackage$dynamicTypes$18e465db.isDynamic($receiver);
    }

    @NotNull
    public static final TypeProjection substitute(@JetValueParameter(name="$receiver") TypeProjection $receiver, @JetValueParameter(name="doSubstitute") @NotNull Function1<? super JetType, ? extends JetType> doSubstitute) {
        TypeProjection typeProjection;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(doSubstitute, "doSubstitute");
        if ($receiver.isStarProjection()) {
            typeProjection = $receiver;
        } else {
            Variance variance = $receiver.getProjectionKind();
            JetType jetType = $receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(jetType, "getType()");
            typeProjection = new TypeProjectionImpl(variance, doSubstitute.invoke(jetType));
        }
        return typeProjection;
    }

    @NotNull
    public static final JetType replaceAnnotations(@JetValueParameter(name="$receiver") JetType $receiver, @JetValueParameter(name="newAnnotations") @NotNull Annotations newAnnotations) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(newAnnotations, "newAnnotations");
        if (newAnnotations.isEmpty()) {
            return $receiver;
        }
        return new DelegatingType($receiver, newAnnotations){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ JetType receiver$0;
            final /* synthetic */ Annotations $newAnnotations;

            static {
                $kotlinClass = Reflection.createKotlinClass(replaceAnnotations.1.class);
            }

            @NotNull
            protected JetType getDelegate() {
                return this.receiver$0;
            }

            @NotNull
            public Annotations getAnnotations() {
                return this.$newAnnotations;
            }
            {
                this.receiver$0 = $receiver;
                this.$newAnnotations = $captured_local_variable$1;
            }
        };
    }

    public static final boolean isJavaLangClass(@JetValueParameter(name="$receiver") JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor classifier2 = $receiver.getConstructor().getDeclarationDescriptor();
        if (!(classifier2 instanceof ClassDescriptor)) {
            return false;
        }
        return DescriptorUtils.isJavaLangClass((ClassDescriptor)classifier2);
    }

    public static final boolean isArrayOfJavaLangClass(@JetValueParameter(name="$receiver") JetType $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isArray($receiver) && ((object = KotlinPackage.firstOrNull($receiver.getArguments())) != null && (object = object.getType()) != null ? TypeUtilPackage$TypeUtils$01ebc082.isJavaLangClass((JetType)object) : false);
    }

    public static final boolean isJavaLangClassOrArray(@JetValueParameter(name="$receiver") JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtilPackage$TypeUtils$01ebc082.isJavaLangClass($receiver) || TypeUtilPackage$TypeUtils$01ebc082.isArrayOfJavaLangClass($receiver);
    }

    public static final boolean equalTypesOrNulls(@JetValueParameter(name="$receiver") JetTypeChecker $receiver, @JetValueParameter(name="type1", type="?") @Nullable JetType type1, @JetValueParameter(name="type2", type="?") @Nullable JetType type2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return $receiver.equalTypes(type1, type2);
    }
}

