/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.JavaBindingContext;
import org.jetbrains.kotlin.load.java.components.ExternalAnnotationResolver;
import org.jetbrains.kotlin.load.java.components.ExternalSignatureResolver;
import org.jetbrains.kotlin.load.java.structure.JavaConstructor;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaMember;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.relocated.javax.inject.Inject;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.JvmPackage;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.AlternativeFieldSignatureData;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.AlternativeMethodSignatureData;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.kotlin.types.JetType;

public class TraceBasedExternalSignatureResolver
implements ExternalSignatureResolver {
    private BindingTrace trace;
    private ExternalAnnotationResolver externalAnnotationResolver;
    private Project project;

    @Inject
    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    @Inject
    public void setExternalAnnotationResolver(ExternalAnnotationResolver externalAnnotationResolver) {
        this.externalAnnotationResolver = externalAnnotationResolver;
    }

    @Inject
    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.PropagatedMethodSignature resolvePropagatedSignature(@NotNull JavaMethod method, @NotNull ClassDescriptor owner, @NotNull JetType returnType2, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        SignaturesPropagationData data2 = new SignaturesPropagationData(owner, returnType2, receiverType, valueParameters, typeParameters, method);
        ExternalSignatureResolver.PropagatedMethodSignature propagatedMethodSignature = new ExternalSignatureResolver.PropagatedMethodSignature(data2.getModifiedReturnType(), data2.getModifiedReceiverType(), data2.getModifiedValueParameters(), data2.getModifiedTypeParameters(), data2.getSignatureErrors(), data2.getModifiedHasStableParameterNames(), data2.getSuperFunctions());
        if (propagatedMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        return propagatedMethodSignature;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.AlternativeMethodSignature resolveAlternativeMethodSignature(@NotNull JavaMember methodOrConstructor, boolean hasSuperMethods, @Nullable JetType returnType2, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, boolean hasStableParameterNames) {
        if (methodOrConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodOrConstructor", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        assert (methodOrConstructor instanceof JavaMethod || methodOrConstructor instanceof JavaConstructor) : "Not a method or a constructor: " + methodOrConstructor.getName();
        AlternativeMethodSignatureData data2 = new AlternativeMethodSignatureData(this.externalAnnotationResolver, methodOrConstructor, receiverType, this.project, valueParameters, returnType2, typeParameters, hasSuperMethods);
        if (data2.isAnnotated() && !data2.hasErrors()) {
            if (JvmPackage.getPLATFORM_TYPES()) {
                ExternalSignatureResolver.AlternativeMethodSignature alternativeMethodSignature = new ExternalSignatureResolver.AlternativeMethodSignature(returnType2, receiverType, AlternativeMethodSignatureData.updateNames(valueParameters, data2.getValueParameters()), typeParameters, Collections.<String>emptyList(), true);
                if (alternativeMethodSignature == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
                }
                return alternativeMethodSignature;
            }
            ExternalSignatureResolver.AlternativeMethodSignature alternativeMethodSignature = new ExternalSignatureResolver.AlternativeMethodSignature(data2.getReturnType(), receiverType, data2.getValueParameters(), data2.getTypeParameters(), Collections.<String>emptyList(), true);
            if (alternativeMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
            }
            return alternativeMethodSignature;
        }
        List<String> error = data2.hasErrors() ? Collections.singletonList(data2.getError()) : Collections.emptyList();
        ExternalSignatureResolver.AlternativeMethodSignature alternativeMethodSignature = new ExternalSignatureResolver.AlternativeMethodSignature(returnType2, receiverType, valueParameters, typeParameters, error, hasStableParameterNames);
        if (alternativeMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        return alternativeMethodSignature;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.AlternativeFieldSignature resolveAlternativeFieldSignature(@NotNull JavaField field2, @NotNull JetType returnType2, boolean isVar) {
        if (field2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
        }
        AlternativeFieldSignatureData data2 = new AlternativeFieldSignatureData(this.externalAnnotationResolver, field2, returnType2, this.project, isVar);
        if (data2.isAnnotated() && !data2.hasErrors()) {
            if (JvmPackage.getPLATFORM_TYPES()) {
                ExternalSignatureResolver.AlternativeFieldSignature alternativeFieldSignature = new ExternalSignatureResolver.AlternativeFieldSignature(returnType2, null);
                if (alternativeFieldSignature == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
                }
                return alternativeFieldSignature;
            }
            ExternalSignatureResolver.AlternativeFieldSignature alternativeFieldSignature = new ExternalSignatureResolver.AlternativeFieldSignature(data2.getReturnType(), null);
            if (alternativeFieldSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
            }
            return alternativeFieldSignature;
        }
        String error = data2.hasErrors() ? data2.getError() : null;
        ExternalSignatureResolver.AlternativeFieldSignature alternativeFieldSignature = new ExternalSignatureResolver.AlternativeFieldSignature(returnType2, error);
        if (alternativeFieldSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
        }
        return alternativeFieldSignature;
    }

    @Override
    public void reportSignatureErrors(@NotNull CallableMemberDescriptor descriptor2, @NotNull List<String> signatureErrors) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "reportSignatureErrors"));
        }
        if (signatureErrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureErrors", "org/jetbrains/kotlin/load/java/components/TraceBasedExternalSignatureResolver", "reportSignatureErrors"));
        }
        this.trace.record(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor2, signatureErrors);
    }
}

