/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.common.collect;

import java.util.Map;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableAsList;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableCollection;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Iterators;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Maps;
import org.jetbrains.kotlin.relocated.com.google.common.collect.UnmodifiableIterator;

final class ImmutableMapValues<K, V>
extends ImmutableCollection<V> {
    private final ImmutableMap<K, V> map;

    ImmutableMapValues(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<V> iterator() {
        return Maps.valueIterator(((ImmutableSet)this.map.entrySet()).iterator());
    }

    @Override
    public boolean contains(Object object) {
        return object != null && Iterators.contains(this.iterator(), object);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    ImmutableList<V> createAsList() {
        final ImmutableList entryList = ((ImmutableCollection)((Object)this.map.entrySet())).asList();
        return new ImmutableAsList<V>(){

            @Override
            public V get(int index2) {
                return ((Map.Entry)entryList.get(index2)).getValue();
            }

            @Override
            ImmutableCollection<V> delegateCollection() {
                return ImmutableMapValues.this;
            }
        };
    }
}

