/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.FunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeArgumentList;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.relocated.com.google.common.base.Function;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Collections2;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.resolve.ChainedTemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForInvoke;
import org.jetbrains.kotlin.resolve.calls.util.DelegatingCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public class CallTransformer<D extends CallableDescriptor, F extends D> {
    public static CallTransformer<CallableDescriptor, CallableDescriptor> MEMBER_CALL_TRANSFORMER = new CallTransformer();
    public static CallTransformer<VariableDescriptor, VariableDescriptor> VARIABLE_CALL_TRANSFORMER = new CallTransformer();
    public static CallTransformer<CallableDescriptor, FunctionDescriptor> FUNCTION_CALL_TRANSFORMER = new CallTransformer<CallableDescriptor, FunctionDescriptor>(){

        @Override
        @NotNull
        public Collection<CallCandidateResolutionContext<CallableDescriptor>> createCallContexts(@NotNull ResolutionCandidate<CallableDescriptor> candidate, @NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task, @NotNull TemporaryBindingTrace candidateTrace) {
            if (candidate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "createCallContexts"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "createCallContexts"));
            }
            if (candidateTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateTrace", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "createCallContexts"));
            }
            if (candidate.getDescriptor() instanceof FunctionDescriptor) {
                Collection<CallCandidateResolutionContext<CallableDescriptor>> collection = super.createCallContexts(candidate, task, candidateTrace);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "createCallContexts"));
                }
                return collection;
            }
            assert (candidate.getDescriptor() instanceof VariableDescriptor);
            boolean hasReceiver = candidate.getExtensionReceiver().exists();
            Call variableCall = this.stripCallArguments(task.call);
            ResolutionCandidate<CallableDescriptor> variableCandidate = ResolutionCandidate.create(variableCall, candidate.getDescriptor(), candidate.getDispatchReceiver(), candidate.getExtensionReceiver(), candidate.getExplicitReceiverKind(), null);
            if (!hasReceiver) {
                CallCandidateResolutionContext<CallableDescriptor> context2 = CallCandidateResolutionContext.create(ResolvedCallImpl.create(variableCandidate, candidateTrace, task.tracing, task.dataFlowInfoForArguments), task, candidateTrace, task.tracing, variableCall);
                Set<CallCandidateResolutionContext<CallableDescriptor>> set = Collections.singleton(context2);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "createCallContexts"));
                }
                return set;
            }
            CallCandidateResolutionContext<CallableDescriptor> contextWithReceiver = this.createContextWithChainedTrace(variableCandidate, variableCall, candidateTrace, task, ReceiverValue.NO_RECEIVER);
            Call variableCallWithoutReceiver = this.stripReceiver(variableCall);
            ResolutionCandidate<CallableDescriptor> candidateWithoutReceiver = ResolutionCandidate.create(variableCallWithoutReceiver, candidate.getDescriptor(), candidate.getDispatchReceiver(), ReceiverValue.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
            CallCandidateResolutionContext<CallableDescriptor> contextWithoutReceiver = this.createContextWithChainedTrace(candidateWithoutReceiver, variableCallWithoutReceiver, candidateTrace, task, variableCall.getExplicitReceiver());
            ArrayList<CallCandidateResolutionContext<CallableDescriptor>> arrayList = Lists.newArrayList(contextWithReceiver, contextWithoutReceiver);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "createCallContexts"));
            }
            return arrayList;
        }

        private CallCandidateResolutionContext<CallableDescriptor> createContextWithChainedTrace(@NotNull ResolutionCandidate<CallableDescriptor> candidate, @NotNull Call call, @NotNull TemporaryBindingTrace temporaryTrace, @NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task, @NotNull ReceiverValue receiverValue) {
            if (candidate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "createContextWithChainedTrace"));
            }
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "createContextWithChainedTrace"));
            }
            if (temporaryTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "temporaryTrace", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "createContextWithChainedTrace"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "createContextWithChainedTrace"));
            }
            if (receiverValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "createContextWithChainedTrace"));
            }
            ChainedTemporaryBindingTrace chainedTrace = ChainedTemporaryBindingTrace.create(temporaryTrace, "chained trace to resolve candidate", candidate);
            ResolvedCallImpl<CallableDescriptor> resolvedCall = ResolvedCallImpl.create(candidate, chainedTrace, task.tracing, task.dataFlowInfoForArguments);
            return CallCandidateResolutionContext.create(resolvedCall, task, chainedTrace, task.tracing, call, receiverValue);
        }

        private Call stripCallArguments(@NotNull Call call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "stripCallArguments"));
            }
            return new DelegatingCall(call){

                @Override
                public JetValueArgumentList getValueArgumentList() {
                    return null;
                }

                @Override
                @NotNull
                public List<? extends ValueArgument> getValueArguments() {
                    List list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1$1", "getValueArguments"));
                    }
                    return list;
                }

                @NotNull
                public List<FunctionLiteralArgument> getFunctionLiteralArguments() {
                    List<FunctionLiteralArgument> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1$1", "getFunctionLiteralArguments"));
                    }
                    return list;
                }

                @Override
                @NotNull
                public List<JetTypeProjection> getTypeArguments() {
                    List<JetTypeProjection> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1$1", "getTypeArguments"));
                    }
                    return list;
                }

                @Override
                public JetTypeArgumentList getTypeArgumentList() {
                    return null;
                }

                @Override
                @NotNull
                public JetElement getCallElement() {
                    JetExpression calleeExpression = this.getCalleeExpression();
                    assert (calleeExpression != null) : "No callee expression: " + this.getCallElement().getText();
                    JetExpression jetExpression = calleeExpression;
                    if (jetExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1$1", "getCallElement"));
                    }
                    return jetExpression;
                }
            };
        }

        private Call stripReceiver(@NotNull Call variableCall) {
            if (variableCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableCall", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "stripReceiver"));
            }
            return new DelegatingCall(variableCall){

                @Override
                @Nullable
                public ASTNode getCallOperationNode() {
                    return null;
                }

                @Override
                @NotNull
                public ReceiverValue getExplicitReceiver() {
                    ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
                    if (receiverValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1$2", "getExplicitReceiver"));
                    }
                    return receiverValue;
                }
            };
        }

        @Override
        @NotNull
        public Collection<MutableResolvedCall<FunctionDescriptor>> transformCall(@NotNull CallCandidateResolutionContext<CallableDescriptor> context2, @NotNull CallResolver callResolver, @NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task) {
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "transformCall"));
            }
            if (callResolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "transformCall"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "transformCall"));
            }
            Object descriptor2 = context2.candidateCall.getCandidateDescriptor();
            if (descriptor2 instanceof FunctionDescriptor) {
                Collection<MutableResolvedCall<FunctionDescriptor>> collection = super.transformCall(context2, callResolver, task);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "transformCall"));
                }
                return collection;
            }
            assert (descriptor2 instanceof VariableDescriptor);
            JetType returnType2 = descriptor2.getReturnType();
            if (returnType2 == null) {
                List<MutableResolvedCall<FunctionDescriptor>> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "transformCall"));
                }
                return list;
            }
            final MutableResolvedCall variableResolvedCall = context2.candidateCall;
            JetExpression calleeExpression = task.call.getCalleeExpression();
            if (calleeExpression == null) {
                List<MutableResolvedCall<FunctionDescriptor>> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "transformCall"));
                }
                return list;
            }
            ExpressionReceiver variableReceiver = new ExpressionReceiver(calleeExpression, ((VariableDescriptor)variableResolvedCall.getResultingDescriptor()).getType());
            CallForImplicitInvoke functionCall = new CallForImplicitInvoke(context2.explicitExtensionReceiverForInvoke, variableReceiver, task.call);
            DelegatingBindingTrace variableCallTrace = context2.candidateCall.getTrace();
            BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(((CallCandidateResolutionContext)context2.replaceBindingTrace(variableCallTrace)).replaceContextDependency(ContextDependency.DEPENDENT), functionCall, context2.checkArguments, context2.dataFlowInfoForArguments);
            TracingStrategyForInvoke tracingForInvoke = new TracingStrategyForInvoke(calleeExpression, functionCall, variableReceiver.getType());
            OverloadResolutionResults<FunctionDescriptor> results = callResolver.resolveCallForInvoke(basicCallResolutionContext, tracingForInvoke);
            Collection calls = ((OverloadResolutionResultsImpl)results).getResultingCalls();
            Collection<MutableResolvedCall<FunctionDescriptor>> collection = Collections2.transform(calls, new Function<MutableResolvedCall<FunctionDescriptor>, MutableResolvedCall<FunctionDescriptor>>(){

                @Override
                public MutableResolvedCall<FunctionDescriptor> apply(MutableResolvedCall<FunctionDescriptor> functionResolvedCall) {
                    return new VariableAsFunctionResolvedCallImpl(functionResolvedCall, variableResolvedCall);
                }
            });
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "transformCall"));
            }
            return collection;
        }
    };

    private CallTransformer() {
    }

    @NotNull
    public Collection<CallCandidateResolutionContext<D>> createCallContexts(@NotNull ResolutionCandidate<D> candidate, @NotNull ResolutionTask<D, F> task, @NotNull TemporaryBindingTrace candidateTrace) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "createCallContexts"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "createCallContexts"));
        }
        if (candidateTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateTrace", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "createCallContexts"));
        }
        ResolvedCallImpl<D> candidateCall = ResolvedCallImpl.create(candidate, candidateTrace, task.tracing, task.dataFlowInfoForArguments);
        Set<CallCandidateResolutionContext<D>> set = Collections.singleton(CallCandidateResolutionContext.create(candidateCall, task, candidateTrace, task.tracing));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "createCallContexts"));
        }
        return set;
    }

    @NotNull
    public Collection<MutableResolvedCall<F>> transformCall(@NotNull CallCandidateResolutionContext<D> callCandidateResolutionContext, @NotNull CallResolver callResolver, @NotNull ResolutionTask<D, F> task) {
        if (callCandidateResolutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callCandidateResolutionContext", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "transformCall"));
        }
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "transformCall"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "transformCall"));
        }
        Set<MutableResolvedCall<F>> set = Collections.singleton(callCandidateResolutionContext.candidateCall);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "transformCall"));
        }
        return set;
    }

    public static class CallForImplicitInvoke
    extends DelegatingCall {
        private final Call outerCall;
        private final ReceiverValue explicitExtensionReceiver;
        private final ExpressionReceiver calleeExpressionAsDispatchReceiver;
        private final JetSimpleNameExpression fakeInvokeExpression;

        public CallForImplicitInvoke(@NotNull ReceiverValue explicitExtensionReceiver, @NotNull ExpressionReceiver calleeExpressionAsDispatchReceiver, @NotNull Call call) {
            if (explicitExtensionReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitExtensionReceiver", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "<init>"));
            }
            if (calleeExpressionAsDispatchReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeExpressionAsDispatchReceiver", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "<init>"));
            }
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "<init>"));
            }
            super(call);
            this.outerCall = call;
            this.explicitExtensionReceiver = explicitExtensionReceiver;
            this.calleeExpressionAsDispatchReceiver = calleeExpressionAsDispatchReceiver;
            this.fakeInvokeExpression = (JetSimpleNameExpression)PsiPackage.JetPsiFactory(call.getCallElement()).createExpression(OperatorConventions.INVOKE.asString());
        }

        @Override
        @Nullable
        public ASTNode getCallOperationNode() {
            return this.explicitExtensionReceiver.exists() ? super.getCallOperationNode() : null;
        }

        @Override
        @NotNull
        public ReceiverValue getExplicitReceiver() {
            ReceiverValue receiverValue = this.explicitExtensionReceiver;
            if (receiverValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "getExplicitReceiver"));
            }
            return receiverValue;
        }

        @Override
        @NotNull
        public ExpressionReceiver getDispatchReceiver() {
            ExpressionReceiver expressionReceiver = this.calleeExpressionAsDispatchReceiver;
            if (expressionReceiver == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "getDispatchReceiver"));
            }
            return expressionReceiver;
        }

        @Override
        public JetExpression getCalleeExpression() {
            return this.fakeInvokeExpression;
        }

        @Override
        @NotNull
        public Call.CallType getCallType() {
            Call.CallType callType = Call.CallType.INVOKE;
            if (callType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "getCallType"));
            }
            return callType;
        }

        @NotNull
        public Call getOuterCall() {
            Call call = this.outerCall;
            if (call == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "getOuterCall"));
            }
            return call;
        }
    }
}

