/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.FunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Maps;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

public class ValueArgumentsToParametersMapper {
    public static <D extends CallableDescriptor> Status mapValueArgumentsToParameters(@NotNull Call call, @NotNull TracingStrategy tracing, @NotNull MutableResolvedCall<D> candidateCall, @NotNull Set<ValueArgument> unmappedArguments) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper", "mapValueArgumentsToParameters"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper", "mapValueArgumentsToParameters"));
        }
        if (candidateCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateCall", "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper", "mapValueArgumentsToParameters"));
        }
        if (unmappedArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unmappedArguments", "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper", "mapValueArgumentsToParameters"));
        }
        Processor processor = new Processor(call, candidateCall, tracing);
        processor.process();
        unmappedArguments.addAll(processor.unmappedArguments);
        return processor.status;
    }

    private ValueArgumentsToParametersMapper() {
    }

    private static class Processor<D extends CallableDescriptor> {
        private final Call call;
        private final TracingStrategy tracing;
        private final MutableResolvedCall<D> candidateCall;
        private final Map<Name, ValueParameterDescriptor> parameterByName;
        private final Set<ValueArgument> unmappedArguments;
        private final Map<ValueParameterDescriptor, VarargValueArgument> varargs;
        private final Set<ValueParameterDescriptor> usedParameters;
        private Status status;
        private final ProcessorState positionedOnly;
        private final ProcessorState positionedThenNamed;

        private Processor(@NotNull Call call, @NotNull MutableResolvedCall<D> candidateCall, @NotNull TracingStrategy tracing) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper$Processor", "<init>"));
            }
            if (candidateCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateCall", "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper$Processor", "<init>"));
            }
            if (tracing == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper$Processor", "<init>"));
            }
            this.unmappedArguments = Sets.newHashSet();
            this.varargs = Maps.newHashMap();
            this.usedParameters = Sets.newHashSet();
            this.status = Status.OK;
            this.positionedOnly = new ProcessorState(){
                private int currentParameter = 0;

                @Nullable
                public ValueParameterDescriptor nextValueParameter() {
                    List<ValueParameterDescriptor> parameters2 = Processor.this.candidateCall.getCandidateDescriptor().getValueParameters();
                    if (this.currentParameter >= parameters2.size()) {
                        return null;
                    }
                    ValueParameterDescriptor head = parameters2.get(this.currentParameter);
                    if (head.getVarargElementType() == null) {
                        ++this.currentParameter;
                    }
                    return head;
                }

                @Override
                public ProcessorState processNamedArgument(@NotNull ValueArgument argument) {
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper$Processor$1", "processNamedArgument"));
                    }
                    return Processor.this.positionedThenNamed.processNamedArgument(argument);
                }

                @Override
                public ProcessorState processPositionedArgument(@NotNull ValueArgument argument, int index2) {
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper$Processor$1", "processPositionedArgument"));
                    }
                    ValueParameterDescriptor valueParameterDescriptor = this.nextValueParameter();
                    if (valueParameterDescriptor != null) {
                        Processor.this.usedParameters.add(valueParameterDescriptor);
                        Processor.this.putVararg(valueParameterDescriptor, argument);
                    } else {
                        Processor.this.report(Errors.TOO_MANY_ARGUMENTS.on(argument.asElement(), (CallableDescriptor)Processor.this.candidateCall.getCandidateDescriptor()));
                        Processor.this.unmappedArguments.add(argument);
                        Processor.this.setStatus(Status.WEAK_ERROR);
                    }
                    return Processor.this.positionedOnly;
                }
            };
            this.positionedThenNamed = new ProcessorState(){

                @Override
                public ProcessorState processNamedArgument(@NotNull ValueArgument argument) {
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper$Processor$2", "processNamedArgument"));
                    }
                    assert (argument.isNamed());
                    Object candidate = Processor.this.candidateCall.getCandidateDescriptor();
                    JetSimpleNameExpression nameReference = argument.getArgumentName().getReferenceExpression();
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)Processor.this.parameterByName.get(nameReference.getReferencedNameAsName());
                    if (!candidate.hasStableParameterNames()) {
                        Processor.this.report(Errors.NAMED_ARGUMENTS_NOT_ALLOWED.on(nameReference, candidate instanceof FunctionInvokeDescriptor ? Errors.BadNamedArgumentsTarget.INVOKE_ON_FUNCTION_TYPE : Errors.BadNamedArgumentsTarget.NON_KOTLIN_FUNCTION));
                    }
                    if (valueParameterDescriptor == null) {
                        Processor.this.report(Errors.NAMED_PARAMETER_NOT_FOUND.on(nameReference, nameReference));
                        Processor.this.unmappedArguments.add(argument);
                        Processor.this.setStatus(Status.WEAK_ERROR);
                    } else {
                        Processor.this.candidateCall.getTrace().record(BindingContext.REFERENCE_TARGET, nameReference, valueParameterDescriptor);
                        if (!Processor.this.usedParameters.add(valueParameterDescriptor)) {
                            Processor.this.report(Errors.ARGUMENT_PASSED_TWICE.on(nameReference));
                            Processor.this.unmappedArguments.add(argument);
                            Processor.this.setStatus(Status.WEAK_ERROR);
                        } else {
                            Processor.this.putVararg(valueParameterDescriptor, argument);
                        }
                    }
                    return Processor.this.positionedThenNamed;
                }

                @Override
                public ProcessorState processPositionedArgument(@NotNull ValueArgument argument, int index2) {
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper$Processor$2", "processPositionedArgument"));
                    }
                    Processor.this.report(Errors.MIXING_NAMED_AND_POSITIONED_ARGUMENTS.on(argument.asElement()));
                    Processor.this.setStatus(Status.WEAK_ERROR);
                    Processor.this.unmappedArguments.add(argument);
                    return Processor.this.positionedThenNamed;
                }
            };
            this.call = call;
            this.tracing = tracing;
            this.candidateCall = candidateCall;
            this.parameterByName = Maps.newHashMap();
            for (ValueParameterDescriptor valueParameter : candidateCall.getCandidateDescriptor().getValueParameters()) {
                this.parameterByName.put(valueParameter.getName(), valueParameter);
            }
        }

        public void process() {
            ProcessorState state = this.positionedOnly;
            List<ValueArgument> argumentsInParentheses = CallUtilPackage.getValueArgumentsInParentheses(this.call);
            for (int i = 0; i < argumentsInParentheses.size(); ++i) {
                ValueArgument valueArgument = argumentsInParentheses.get(i);
                state = valueArgument.isNamed() ? state.processNamedArgument(valueArgument) : state.processPositionedArgument(valueArgument, i);
            }
            for (Map.Entry<ValueParameterDescriptor, VarargValueArgument> entry : this.varargs.entrySet()) {
                this.candidateCall.recordValueArgument(entry.getKey(), entry.getValue());
            }
            this.processFunctionLiteralArguments();
            this.reportUnmappedParameters();
            this.checkReceiverArgument();
        }

        private void processFunctionLiteralArguments() {
            Object candidate = this.candidateCall.getCandidateDescriptor();
            List<ValueParameterDescriptor> valueParameters = candidate.getValueParameters();
            List<? extends FunctionLiteralArgument> functionLiteralArguments = this.call.getFunctionLiteralArguments();
            if (!functionLiteralArguments.isEmpty()) {
                FunctionLiteralArgument functionLiteralArgument = functionLiteralArguments.get(0);
                JetExpression possiblyLabeledFunctionLiteral = functionLiteralArgument.getArgumentExpression();
                if (valueParameters.isEmpty()) {
                    this.report(Errors.TOO_MANY_ARGUMENTS.on(possiblyLabeledFunctionLiteral, (CallableDescriptor)candidate));
                    this.setStatus(Status.ERROR);
                } else {
                    ValueParameterDescriptor valueParameterDescriptor = valueParameters.get(valueParameters.size() - 1);
                    if (valueParameterDescriptor.getVarargElementType() != null) {
                        this.report(Errors.VARARG_OUTSIDE_PARENTHESES.on(possiblyLabeledFunctionLiteral));
                        this.setStatus(Status.ERROR);
                    } else if (!this.usedParameters.add(valueParameterDescriptor)) {
                        this.report(Errors.TOO_MANY_ARGUMENTS.on(possiblyLabeledFunctionLiteral, (CallableDescriptor)candidate));
                        this.setStatus(Status.WEAK_ERROR);
                    } else {
                        this.putVararg(valueParameterDescriptor, functionLiteralArgument);
                    }
                }
                for (int i = 1; i < functionLiteralArguments.size(); ++i) {
                    JetExpression argument = functionLiteralArguments.get(i).getArgumentExpression();
                    this.report(Errors.MANY_FUNCTION_LITERAL_ARGUMENTS.on(argument));
                    this.setStatus(Status.WEAK_ERROR);
                }
            }
        }

        private void reportUnmappedParameters() {
            List<ValueParameterDescriptor> valueParameters = this.candidateCall.getCandidateDescriptor().getValueParameters();
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                if (this.usedParameters.contains(valueParameter)) continue;
                if (valueParameter.hasDefaultValue()) {
                    this.candidateCall.recordValueArgument(valueParameter, DefaultValueArgument.DEFAULT);
                    continue;
                }
                if (valueParameter.getVarargElementType() != null) {
                    this.candidateCall.recordValueArgument(valueParameter, new VarargValueArgument());
                    continue;
                }
                this.tracing.noValueForParameter(this.candidateCall.getTrace(), valueParameter);
                this.setStatus(Status.ERROR);
            }
        }

        private void checkReceiverArgument() {
            Object candidate = this.candidateCall.getCandidateDescriptor();
            ReceiverParameterDescriptor receiverParameter = candidate.getExtensionReceiverParameter();
            ReceiverValue receiverArgument = this.candidateCall.getExtensionReceiver();
            if (receiverParameter != null && !receiverArgument.exists()) {
                this.tracing.missingReceiver(this.candidateCall.getTrace(), receiverParameter);
                this.setStatus(Status.ERROR);
            }
            if (receiverParameter == null && receiverArgument.exists()) {
                this.tracing.noReceiverAllowed(this.candidateCall.getTrace());
                if (this.call.getCalleeExpression() instanceof JetSimpleNameExpression) {
                    this.setStatus(Status.STRONG_ERROR);
                } else {
                    this.setStatus(Status.ERROR);
                }
            }
        }

        private void putVararg(ValueParameterDescriptor valueParameterDescriptor, ValueArgument valueArgument) {
            if (valueParameterDescriptor.getVarargElementType() != null) {
                VarargValueArgument vararg = this.varargs.get(valueParameterDescriptor);
                if (vararg == null) {
                    vararg = new VarargValueArgument();
                    this.varargs.put(valueParameterDescriptor, vararg);
                }
                vararg.addArgument(valueArgument);
            } else {
                LeafPsiElement spread = valueArgument.getSpreadElement();
                if (spread != null) {
                    this.candidateCall.getTrace().report(Errors.NON_VARARG_SPREAD.on(spread));
                    this.setStatus(Status.WEAK_ERROR);
                }
                ExpressionValueArgument argument = new ExpressionValueArgument(valueArgument);
                this.candidateCall.recordValueArgument(valueParameterDescriptor, argument);
            }
        }

        private void setStatus(@NotNull Status newStatus) {
            if (newStatus == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStatus", "org/jetbrains/kotlin/resolve/calls/ValueArgumentsToParametersMapper$Processor", "setStatus"));
            }
            this.status = this.status.compose(newStatus);
        }

        private void report(Diagnostic diagnostic) {
            this.candidateCall.getTrace().report(diagnostic);
        }

        private static interface ProcessorState {
            public ProcessorState processNamedArgument(@NotNull ValueArgument var1);

            public ProcessorState processPositionedArgument(@NotNull ValueArgument var1, int var2);
        }
    }

    public static enum Status {
        STRONG_ERROR(false),
        ERROR(false),
        WEAK_ERROR(false),
        OK(true);

        private final boolean success;

        private Status(boolean success) {
            this.success = success;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Status compose(Status other) {
            if (this == STRONG_ERROR || other == STRONG_ERROR) {
                return STRONG_ERROR;
            }
            if (this == ERROR || other == ERROR) {
                return ERROR;
            }
            if (this == WEAK_ERROR || other == WEAK_ERROR) {
                return WEAK_ERROR;
            }
            return this;
        }
    }
}

